/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SaveFilePanel
extends JPanel {
    private JFileChooser fc = new JFileChooser();
    private SimpleWizardPanel panel;
    private JButton jButtonChoose;
    private JLabel jLabel1;
    private JTextField jTextFieldFile;

    public SaveFilePanel() {
        this.initComponents();
        this.fc.setDialogType(1);
        this.jTextFieldFile.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SaveFilePanel.this.check();
            }

            public void removeUpdate(DocumentEvent e) {
                SaveFilePanel.this.check();
            }

            public void changedUpdate(DocumentEvent e) {
                SaveFilePanel.this.check();
            }
        });
    }

    public void setWizardPanel(SimpleWizardPanel panel) {
        this.panel = panel;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonChoose = new JButton();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getBundle((Class)SaveFilePanel.class).getString("ChooseFile"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle((Class)SaveFilePanel.class).getString("File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextFieldFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonChoose, (String)"...");
        this.jButtonChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveFilePanel.this.jButtonChooseActionPerformed(evt);
            }
        });
        this.add((Component)this.jButtonChoose, new GridBagConstraints());
    }

    private void jButtonChooseActionPerformed(ActionEvent evt) {
        this.fc.setSelectedFile(new File(this.jTextFieldFile.getText()));
        if (this.fc.showSaveDialog(this) != 0) {
            return;
        }
        if (this.fc.getSelectedFile().exists()) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)SaveFilePanel.class, (String)"FileExistsOverwrite"), NbBundle.getMessage((Class)SaveFilePanel.class, (String)"Warning"), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.OK_OPTION) {
                return;
            }
        }
        this.jTextFieldFile.setText(this.fc.getSelectedFile().getAbsolutePath());
    }

    public JFileChooser getFileChooser() {
        return this.fc;
    }

    public void setFile(File f) {
        this.jTextFieldFile.setText(f.getAbsolutePath());
        this.fc.setSelectedFile(f);
        this.check();
    }

    public File getFile() {
        return new File(this.jTextFieldFile.getText());
    }

    private void check() {
        String t = this.jTextFieldFile.getText().trim();
        if (t.length() == 0) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)SaveFilePanel.class, (String)"EmptyFileName"));
            return;
        }
        File f = new File(t);
        if (f.isDirectory()) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)SaveFilePanel.class, (String)"NotAFile"));
            return;
        }
        File dir = f.getParentFile();
        if (dir == null || !dir.isDirectory()) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)SaveFilePanel.class, (String)"NoParent"));
            return;
        }
        if (!f.isAbsolute()) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)SaveFilePanel.class, (String)"NotAnAbsolutePath"));
            return;
        }
        try {
            System.getSecurityManager().checkWrite(f.getAbsolutePath());
            this.panel.setErrorMessage(null);
        }
        catch (SecurityException e) {
            this.panel.setErrorMessage(e.getLocalizedMessage());
        }
    }
}

