/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.ElementOrder;
import org.netbeans.modules.java.bridge.FeaturesCollection;
import org.netbeans.modules.java.bridge.IdentContextSupport;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.java.bridge.ImportsCollection;
import org.netbeans.modules.java.bridge.TopClassesCollection;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.Task;

public class SourceElementImpl
extends ElementImpl
implements SourceElement.Impl,
ElementOrder,
PropertyChangeListener {
    private transient FeaturesCollection members;
    transient TopClassesCollection topClasses;
    transient ImportsCollection imports;
    private ElementImpl.ElementListener classesListener;
    private ElementImpl.ElementListener sourceListener;
    private ElementImpl.ElementListener importsListener;
    private IdentContextSupport identSupp;
    private transient Resource resource;
    private transient JavaDataObject javaObject;
    private static final long serialVersionUID = 8506642610861188475L;
    static /* synthetic */ Class class$org$netbeans$modules$java$bridge$ElementImpl;

    public SourceElementImpl(DefaultLangModel model, Resource resource, JavaDataObject jdo) {
        super(model, (RefObject)resource);
        this.resource = resource;
        this.javaObject = jdo;
        this.identSupp = new IdentContextSupport(11);
        this.members = new FeaturesCollection(this);
        this.topClasses = new TopClassesCollection(this.members, resource, this);
        this.imports = new ImportsCollection(this.members, resource);
    }

    public void connectListener() {
        this.sourceListener = new SourceListener(this);
        this.sourceListener.connect();
        this.classesListener = new TopClassesCollection.TopClassesListener(this);
        this.classesListener.connect();
        ResourceImpl resImpl = (ResourceImpl)this.resource;
        if (resImpl.importsInited()) {
            this.importsListener = new ImportsCollection.ImportsListener(this);
            this.importsListener.connect();
        } else {
            resImpl.addImportsListener((PropertyChangeListener)this);
        }
    }

    boolean isResourceValid() {
        return this.resource.isValid();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.importsListener = new ImportsCollection.ImportsListener(this);
        this.importsListener.connect();
    }

    protected void notifyElementCreated() {
    }

    protected void createFromModel(Element model) throws SourceException {
    }

    public Element[] getElements() {
        return this.getClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getPackage() {
        this.repository.beginTrans(false);
        try {
            if (this.resource.isValid()) {
                this.setClassPath();
                String javaPackage = this.resource.getPackageName();
                Identifier identifier = javaPackage != null ? Identifier.create((String)javaPackage) : null;
                return identifier;
            }
            Identifier identifier = null;
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public Import[] getImports() {
        return this.imports.getImports();
    }

    public ImportElement[] getImportElements() {
        return (ImportElement[])this.imports.getElements();
    }

    public ClassElement getClass(Identifier id) {
        return this.topClasses.getClass(id);
    }

    public ClassElement[] getClasses() {
        return this.topClasses.getClasses();
    }

    public ClassElement[] getAllClasses() {
        ClassElement[] tops = this.getClasses();
        LinkedList list = new LinkedList();
        for (int i = 0; i < tops.length; ++i) {
            this.addAllClasses(tops[i], list);
        }
        return list.toArray(new ClassElement[0]);
    }

    private void addAllClasses(ClassElement c, Collection col) {
        col.add(c);
        ClassElement[] inner = c.getClasses();
        for (int i = 0; i < inner.length; ++i) {
            this.addAllClasses(inner[i], col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackage(Identifier packageID) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.resource.isValid()) {
                this.setClassPath();
                Identifier old = this.getPackage();
                if (old == packageID || old != null && packageID != null && old.getSourceName().equals(packageID.getSourceName())) {
                    failed = false;
                    return;
                }
                JavaPackageClass pkgProxy = ((JavaModelPackage)this.resource.refImmediatePackage()).getJavaPackage();
                String packId = packageID != null ? packageID.getFullName() : "";
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getEventSource(), "package", old, packageID);
                this.checkVetoablePropertyChange(evt);
                this.resource.setPackageName(packId);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void firePackageChange(Identifier oldId, Identifier newId) {
        if (oldId == newId || oldId != null && newId != null && oldId.getSourceName().equals(newId.getSourceName())) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getEventSource(), "package", oldId, newId);
        this.fireOwnPropertyChange(evt);
    }

    public void changeImports(Import[] defs, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.imports.changeImports(defs, operation);
    }

    public void changeClasses(ClassElement[] classes, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.topClasses.changeMembers((Element[])classes, operation);
    }

    private void notifyCreate(Element[] els) {
        for (int i = 0; i < els.length; ++i) {
            ElementImpl impl = (ElementImpl)els[i].getCookie(class$org$netbeans$modules$java$bridge$ElementImpl == null ? SourceElementImpl.class$("org.netbeans.modules.java.bridge.ElementImpl") : class$org$netbeans$modules$java$bridge$ElementImpl);
            impl.notifyCreate();
        }
    }

    protected void notifyCreate() {
    }

    private Binding.Source getSourceBinding() {
        return (Binding.Source)this.getBinding();
    }

    public int getStatus() {
        return 0;
    }

    public Task prepare() {
        return Task.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(Runnable run) {
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            this.setClassPath();
            run.run();
            failed = false;
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void runAtomicAsUser(Runnable run) throws SourceException {
        this.runAtomic(run);
    }

    public void updateMembers(String name, Element[] elements, int[] optMap) {
    }

    protected void checkWritable(boolean unsafeOp) throws SourceException {
        SourceException.IO e = null;
        int status = this.resource.getStatus();
        if ((status & 1) != 0) {
            e = new SourceException.IO("Source containing generics cannot be modified: " + this.resource.getName());
        } else if ((status & 8) != 0) {
            e = new SourceException.IO("Source containing annotations cannot be modified: " + this.resource.getName());
        }
        if (e != null) {
            if (JDK15_CHECKS_DISABLED) {
                if (unsafeOp) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            } else {
                throw e;
            }
        }
    }

    public void setParent(ElementImpl impl) {
    }

    protected SourceElementImpl findSource() {
        return this;
    }

    public Object readResolve() {
        return null;
    }

    protected Element cloneSelf() {
        return null;
    }

    protected Identifier createLocalIdentifier(Identifier id, int status) {
        return this.identSupp.create(id, status);
    }

    protected boolean checkIdentifierContext(Identifier id) {
        return this.identSupp.checkContext(id);
    }

    protected boolean parentValid() {
        return this.isValid();
    }

    protected void notifyRemove() {
    }

    public Node.Cookie getCookie(Class type) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.javaObject.getCookie(type);
    }

    static class SourceListener
    extends ElementImpl.ElementListener {
        Identifier packageId = null;

        SourceListener(SourceElementImpl impl) {
            super(impl);
            String pkgName = ((Resource)this.javaElement).getPackageName();
            this.packageId = pkgName != null ? Identifier.create((String)pkgName) : null;
        }

        public void doChange(MDRChangeEvent event) {
            super.doChange(event);
            if (event instanceof AttributeEvent && ((AttributeEvent)event).getAttributeName().equals("packageName")) {
                Identifier oldId = this.packageId;
                String name = (String)((AttributeEvent)event).getNewElement();
                this.packageId = name != null ? Identifier.create((String)name) : null;
                ((SourceElementImpl)this.impl).firePackageChange(oldId, this.packageId);
            }
        }
    }
}

