/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementEvents;
import org.netbeans.modules.java.bridge.ExceptionRunnable;
import org.netbeans.modules.java.bridge.JavaDocImpl;
import org.netbeans.modules.java.bridge.NullBinding;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.netbeans.modules.java.bridge.Util;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.ElementProperties;
import org.openide.src.Identifier;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.SourceVetoException;
import org.openide.src.Type;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class ElementImpl
implements Element.Impl,
Element.Impl2,
ElementProperties,
Node.Cookie,
ElementEvents {
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    protected static final boolean JDK15_CHECKS_DISABLED = "true".equalsIgnoreCase(System.getProperty("org.netbeans.java.bridge.disable_jdk15_checks", "true"));
    private transient org.openide.src.Element element;
    private transient Collection propListeners;
    private transient VetoableChangeSupport vetoSupport;
    protected transient Binding binding;
    private transient boolean valid;
    private CookieSet cookieSet;
    protected transient DefaultLangModel model;
    private transient boolean inCreation;
    protected JavaDocImpl javadoc;
    protected transient Element javaElement;
    protected transient JavaModelPackage javaModelPackage;
    protected transient MDRepository repository;
    private static final Binding NULL_BINDING = new NullBinding();
    private static final boolean DEBUG_EVENTS = false;
    private static final long serialVersionUID = -6337836874152020892L;
    static /* synthetic */ Class class$org$netbeans$modules$java$bridge$ElementImpl$LWeakReference;

    protected ElementImpl(DefaultLangModel model) {
        this.model = model;
        this.javaElement = null;
        this.inCreation = false;
        this.valid = true;
        this.repository = JavaMetamodel.getDefaultRepository();
        this.binding = NULL_BINDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementImpl(DefaultLangModel model, RefObject javaElement) {
        this.model = model;
        this.javaElement = (Element)javaElement;
        this.inCreation = false;
        this.valid = true;
        this.repository = JavaMetamodel.getDefaultRepository();
        this.binding = NULL_BINDING;
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.javaModelPackage = (JavaModelPackage)javaElement.refImmediatePackage();
            }
        }
        finally {
            this.repository.endTrans();
        }
    }

    public RefObject getJavaElement() {
        return this.javaElement;
    }

    public Type descrToType(org.netbeans.jmi.javamodel.Type type) {
        return this.descrToType(TypeClassImpl.getRawType((org.netbeans.jmi.javamodel.Type)type), null);
    }

    public Type descrToType(org.netbeans.jmi.javamodel.Type descr, String sourceName) {
        if (descr == null) {
            return null;
        }
        if (descr instanceof TypeParameter) {
            return Type.createClass((Identifier)this.createClassIdentifier(JAVA_LANG_OBJECT));
        }
        if (descr instanceof ParameterizedType) {
            if (((ParameterizedType)descr).getParameters().size() == 0) {
                descr = ((ParameterizedType)descr).getDefinition();
            } else {
                if (sourceName == null) {
                    return Type.createClass((Identifier)this.createClassIdentifier(JAVA_LANG_OBJECT));
                }
                return Type.createClass((Identifier)this.createClassIdentifier(JAVA_LANG_OBJECT, sourceName));
            }
        }
        if (descr instanceof Array) {
            return Type.createArray((Type)this.descrToType(((Array)descr).getType()));
        }
        if (descr instanceof JavaClass) {
            String name = ((JavaClass)descr).getName();
            if (sourceName == null) {
                return Type.createClass((Identifier)this.createClassIdentifier(name));
            }
            return Type.createClass((Identifier)this.createClassIdentifier(name, sourceName));
        }
        PrimitiveTypeKind kind = ((PrimitiveType)descr).getKind();
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return Type.BOOLEAN;
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return Type.INT;
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return Type.CHAR;
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return Type.BYTE;
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return Type.SHORT;
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return Type.LONG;
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return Type.FLOAT;
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return Type.DOUBLE;
        }
        return descr != null ? Type.VOID : null;
    }

    public org.netbeans.jmi.javamodel.Type typeToDescr(Type type) {
        if (type.isArray()) {
            org.netbeans.jmi.javamodel.Type jmiType = this.typeToDescr(type.getElementType());
            JavaModelPackage pck = (JavaModelPackage)jmiType.refImmediatePackage();
            return pck.getArray().resolveArray(jmiType);
        }
        if (type.isClass()) {
            return this.getClassDescriptor(type.getClassName().getFullName());
        }
        return (PrimitiveType)this.javaModelPackage.getType().resolve(type.getFullString());
    }

    public TypeReference typeToTypeReference(Type type) {
        if (type.isArray()) {
            int dimCount = 0;
            do {
                ++dimCount;
            } while ((type = type.getElementType()).isArray());
            String name = type.getSourceString();
            if (name == null) {
                name = type.getFullString();
            }
            MultipartId parent = this.javaModelPackage.getMultipartId().createMultipartId(name, null, null);
            return this.javaModelPackage.getArrayReference().createArrayReference("", parent, dimCount);
        }
        String name = type.getSourceString();
        if (name == null) {
            name = type.getFullString();
        }
        return this.javaModelPackage.getMultipartId().createMultipartId(name, null, null);
    }

    public Type stringToType(String name) {
        return this.stringToType(name, name);
    }

    public Type stringToType(String fullName, String sourceName) {
        if ("boolean".equals(fullName)) {
            return Type.BOOLEAN;
        }
        if ("int".equals(fullName)) {
            return Type.INT;
        }
        if ("char".equals(fullName)) {
            return Type.CHAR;
        }
        if ("byte".equals(fullName)) {
            return Type.BYTE;
        }
        if ("short".equals(fullName)) {
            return Type.SHORT;
        }
        if ("long".equals(fullName)) {
            return Type.LONG;
        }
        if ("float".equals(fullName)) {
            return Type.FLOAT;
        }
        if ("double".equals(fullName)) {
            return Type.DOUBLE;
        }
        if ("void".equals(fullName) || fullName == null) {
            return Type.VOID;
        }
        return Type.createClass((Identifier)this.createClassIdentifier(fullName, sourceName));
    }

    public Type typeReferenceToType(TypeReference descr) {
        if (descr == null) {
            return null;
        }
        Type type = null;
        if (descr instanceof ArrayReference) {
            type = this.multipartIdToType(descr.getParent());
            int dimCount = ((ArrayReference)descr).getDimCount();
            for (int x = 0; x < dimCount; ++x) {
                type = Type.createArray((Type)type);
            }
        } else {
            type = this.multipartIdToType((MultipartId)descr);
        }
        return type;
    }

    private Type multipartIdToType(MultipartId id) {
        String fullName;
        String sourceName = ElementImpl.multipartIdToName(id);
        NamedElement elem = id.getElement();
        int resolved = 1;
        if (elem instanceof PrimitiveType) {
            return this.stringToType(sourceName, null);
        }
        if (JAVA_LANG_OBJECT.equals(sourceName)) {
            fullName = sourceName;
        } else {
            fullName = elem != null && elem instanceof JavaClass ? ((JavaClass)elem).getName() : null;
            if (fullName == null) {
                fullName = sourceName;
                resolved = 2;
            }
        }
        return Type.createClass((Identifier)Identifier.create((String)fullName, (String)sourceName, (int)resolved));
    }

    public org.netbeans.jmi.javamodel.Type getClassDescriptor(String fullName) {
        return this.javaModelPackage.getType().resolve(fullName);
    }

    public Identifier createClassIdentifier(MultipartId id) {
        String sourceName = ElementImpl.multipartIdToName(id);
        String fullName = null;
        JavaClass jcls = (JavaClass)id.getElement();
        fullName = JAVA_LANG_OBJECT.equals(sourceName) ? sourceName : (jcls == null ? sourceName : this.typeToFullName(jcls));
        int resolved = 1;
        if (jcls == null || jcls instanceof UnresolvedClass) {
            resolved = 2;
        }
        return Identifier.create((String)fullName, (String)sourceName, (int)resolved);
    }

    public static String multipartIdToName(MultipartId id) {
        LinkedList<String> list = new LinkedList<String>();
        while (id != null) {
            if (!id.getTypeArguments().isEmpty()) {
                return JAVA_LANG_OBJECT;
            }
            list.addFirst(id.getName());
            id = id.getParent();
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    public String typeToFullName(JavaClass jc) {
        if (jc instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)jc;
            StringBuffer buf = new StringBuffer();
            buf.append(this.typeToFullName(p.getDefinition()));
            List pars = p.getParameters();
            if (pars.size() > 0) {
                buf.append('<');
                Iterator iter = pars.iterator();
                while (iter.hasNext()) {
                    JavaClass par = (JavaClass)iter.next();
                    buf.append(this.typeToFullName(par));
                    if (!iter.hasNext()) continue;
                    buf.append(',');
                }
                buf.append('>');
            }
            return buf.toString();
        }
        return jc.getName();
    }

    public Identifier createClassIdentifier(String fullName) {
        return this.createClassIdentifier(fullName, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier createClassIdentifier(String fullName, String sourceName) {
        this.repository.beginTrans(false);
        try {
            this.setClassPath();
            boolean exists = ClassIndex.hasClass((String)fullName, (ClassPath)JavaMetamodel.getManager().getClassPath());
            Identifier identifier = Identifier.create((String)fullName, (String)sourceName, (int)(exists ? 1 : 2));
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public void checkIsValid() throws SourceException {
        if (!this.javaElement.isValid()) {
            this.throwIsInvalid();
        }
    }

    public void throwIsInvalid() throws SourceException {
        Util.throwException("Element was deleted", "EXC_ElementInvalid");
    }

    public abstract void connectListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachedToElement(org.openide.src.Element el) {
        this.element = el;
        if (!this.valid) {
            return;
        }
        this.repository.beginTrans(false);
        try {
            if (!this.javaElement.isValid()) {
                this.setValid(false);
            } else {
                this.connectListener();
                this.setValid(true);
            }
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public void setBinding(Binding b) {
        if (this.binding != null) {
            return;
        }
        if (b instanceof Node.Cookie) {
            this.getCookieSet().add((Node.Cookie)b);
        }
        this.binding = b;
    }

    private String describeEvent(PropertyChangeEvent evt) {
        StringBuffer sb = new StringBuffer();
        sb.append(evt.getPropertyName());
        Object oldV = evt.getOldValue();
        sb.append(" old = " + this.describeValue(evt.getOldValue()));
        sb.append(" new = " + this.describeValue(evt.getNewValue()));
        return sb.toString();
    }

    private String describeValue(Object o) {
        if (o instanceof Identifier) {
            Identifier id = (Identifier)o;
            return id.getSourceName() + "/" + id.getFullName() + "/" + id.getResolutionStatus();
        }
        if (o instanceof Identifier[]) {
            StringBuffer sb = new StringBuffer();
            sb.append("[ ");
            Identifier[] ids = (Identifier[])o;
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.describeValue(ids[i]));
            }
            sb.append(" ]");
            return sb.toString();
        }
        if (o instanceof MethodParameter[]) {
            MethodParameter[] pars = (MethodParameter[])o;
            if (pars.length == 0) {
                return "()";
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < pars.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pars[i].getSourceString());
                sb.append("/");
                Type t = pars[i].getType();
                sb.append(t.getFullString());
                while (t.isArray()) {
                    t = t.getElementType();
                }
                if (!t.isClass()) continue;
                sb.append('/');
                sb.append(new Integer(t.getTypeIdentifier().getResolutionStatus()).toString());
            }
            return sb.toString();
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            String s = t.getSourceString() + "/" + t.getFullString();
            while (t.isArray()) {
                t = t.getElementType();
            }
            if (t.isClass()) {
                s = s + "/" + t.getTypeIdentifier().getResolutionStatus();
            }
            return s;
        }
        if (o != null) {
            return o.toString();
        }
        return "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        Object object;
        if (this.propListeners == null) {
            object = this;
            synchronized (object) {
                if (this.propListeners == null) {
                    this.propListeners = new LinkedList();
                    this.initializeListenerSupport();
                }
            }
        }
        object = this.propListeners;
        synchronized (object) {
            this.propListeners.add(l);
        }
    }

    protected boolean isCreated() {
        return this.inCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propListeners != null) {
            Collection collection = this.propListeners;
            synchronized (collection) {
                this.propListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoSupport == null) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                if (this.vetoSupport == null) {
                    this.vetoSupport = new VetoableChangeSupport(this.element);
                    this.initializeListenerSupport();
                }
            }
        }
        this.vetoSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoSupport != null) {
            this.vetoSupport.removeVetoableChangeListener(l);
        }
    }

    public boolean hasVetoableListeners(String propName) {
        if (this.vetoSupport == null) {
            return false;
        }
        return this.vetoSupport.hasListeners(propName);
    }

    public void markCurrent(boolean beforeAfter) {
    }

    public final org.openide.src.Element getElement() {
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CookieSet getCookieSet() {
        if (this.cookieSet == null) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                if (this.cookieSet == null) {
                    this.cookieSet = new CookieSet();
                    this.initializeCookies(this.cookieSet);
                }
            }
        }
        return this.cookieSet;
    }

    protected void initializeCookies(CookieSet set) {
        set.add((Node.Cookie)this);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.fireOwnPropertyChange(new PropertyChangeEvent(this.getElement(), name, o, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChangeEvent(PropertyChangeEvent evt) {
        Vector listeners;
        if (this.propListeners == null) {
            return;
        }
        Collection collection = this.propListeners;
        synchronized (collection) {
            listeners = new Vector(this.propListeners);
        }
        for (int i = 0; i < listeners.size(); ++i) {
            PropertyChangeListener l = (PropertyChangeListener)listeners.elementAt(i);
            l.propertyChange(evt);
        }
    }

    protected final void fireOwnPropertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        this.firePropertyChangeEvent(evt);
    }

    protected org.openide.src.Element cloneSelf() {
        throw new UnsupportedOperationException("clone unsupported on " + this.getClass());
    }

    public final void addPropertyChange(PropertyChangeEvent evt) {
        if (this.isCreated()) {
            return;
        }
        this.getModelImpl().getEventQueue().addPropertyChange(this, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this.isCreated()) {
            return;
        }
        if (this.vetoSupport != null) {
            try {
                this.getModelImpl().notifyEventsDispatched(true);
                this.vetoSupport.fireVetoableChange(name, o, n);
            }
            finally {
                this.getModelImpl().notifyEventsDispatched(false);
            }
        }
    }

    public final void fireVetoableChange(PropertyChangeEvent evt) throws SourceException {
        if (this.isCreated()) {
            return;
        }
        this.checkVetoablePropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.vetoSupport != null) {
            try {
                this.getModelImpl().notifyEventsDispatched(true);
                this.vetoSupport.fireVetoableChange(evt);
            }
            finally {
                this.getModelImpl().notifyEventsDispatched(false);
            }
        }
    }

    protected void checkVetoablePropertyChange(PropertyChangeEvent evt) throws SourceException {
        if (this.isCreated() || !this.isConstrained()) {
            return;
        }
        try {
            this.doFireVetoableChange(evt);
        }
        catch (SourceVetoException ex) {
            throw ex.getNestedException();
        }
        catch (PropertyVetoException ex) {
            throw new SourceException(ex.getMessage());
        }
    }

    public final Binding getBinding() {
        if (this.isCreated()) {
            return NULL_BINDING;
        }
        return this.binding;
    }

    public final Binding getRawBinding() {
        return this.getBinding();
    }

    protected void invalidate() {
        this.setValid(false);
    }

    private void setValid(boolean valid) {
        boolean old = this.valid;
        if (old == valid) {
            return;
        }
        this.valid = valid;
        if (old) {
            this.fireOwnPropertyChange(new PropertyChangeEvent(this.getEventSource(), "valid", valid ? Boolean.FALSE : Boolean.TRUE, valid ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected void checkValid(Object lockToken) throws SourceException {
        if (this.isValid()) {
            return;
        }
        this.releaseLock(lockToken);
        Util.throwException("Element was deleted", "EXC_ElementInvalid");
    }

    public void checkDocument() {
        JavaDataObject jdo = this.model.getJavaDataObject();
        CloneableEditorSupport edSupport = (CloneableEditorSupport)jdo.getCookie(JavaEditor.class);
        if (!edSupport.isDocumentLoaded()) {
            try {
                edSupport.openDocument();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void setClassPath() {
        JavaDataObject jdo = this.model.getJavaDataObject();
        FileObject fo = jdo.getPrimaryFile();
        JavaMetamodel.getManager().setClassPath(fo);
    }

    protected abstract void checkWritable(boolean var1) throws SourceException;

    public Node.Cookie getCookie(Class desired) {
        if (desired.isAssignableFrom(this.getClass())) {
            return this;
        }
        Node.Cookie ret = this.getCookieSet().getCookie(desired);
        if (ret != null) {
            return ret;
        }
        return this.getModelImpl().findElementCookie(this.getElement(), desired);
    }

    protected abstract SourceElementImpl findSource();

    protected void createAfter(Binding.Container cb, Binding refBinding) throws SourceException {
        this.inCreation = false;
        cb.insert(this.binding, refBinding);
        this.setValid(true);
    }

    protected abstract boolean parentValid();

    public void notifyConnectionChange(org.openide.src.Element old) {
        this.getModelImpl().fireElementChanged(old, this.getElement());
    }

    public void notifyConnectionAdd(org.openide.src.Element newElem) {
        this.getModelImpl().fireElementAdded(newElem);
    }

    public void notifyConnectionRemove(org.openide.src.Element removedElem) {
        this.getModelImpl().fireElementRemoved(removedElem);
    }

    public void notifyConnectionSet(org.openide.src.Element oldElem, org.openide.src.Element newElem) {
        this.getModelImpl().fireElementSet(oldElem, newElem);
    }

    protected void notifyCreate() {
        this.inCreation = false;
        this.setValid(true);
        if (this.parentValid()) {
            this.notifyElementCreated();
        }
    }

    protected void notifyElementCreated() {
        this.getModelImpl().getEventQueue().elementCreated(this.getElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setJavaDocText(String content, boolean raw) throws SourceException {
        if (!(this.javaElement instanceof Feature)) {
            return;
        }
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                String oldContent;
                this.setClassPath();
                String string = oldContent = raw ? this.javadoc.getRawText() : this.javadoc.getText();
                if (content == oldContent || content != null && oldContent != null && content.equals(oldContent)) {
                    failed = false;
                    return;
                }
                this.javadoc.changeJavaDocText(content, raw);
                ((Feature)this.javaElement).setJavadocText(this.javadoc.getRawText());
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeJavaDocTags(JavaDocTag[] tags, int action) throws SourceException {
        if (!(this.javaElement instanceof Feature)) {
            return;
        }
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                String oldContent = this.javadoc.getRawText();
                this.javadoc.changeJavaDocTags(tags, action);
                ((Feature)this.javaElement).setJavadocText(this.javadoc.getRawText());
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireJavaDocChange() {
        this.fireOwnPropertyChange(new PropertyChangeEvent(this.getEventSource(), "javadoc", null, null));
    }

    protected void notifyRemove() {
        this.invalidate();
        this.getModelImpl().getEventQueue().elementRemoved(this.getElement());
    }

    protected void checkRemove() throws SourceException {
        if (this.isCreated() || !this.isConstrained()) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "valid", Boolean.TRUE, Boolean.FALSE);
        this.checkVetoablePropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasListeners(String propName) {
        if (this.vetoSupport.hasListeners(propName)) {
            return true;
        }
        if (this.propListeners == null) {
            return false;
        }
        Collection collection = this.propListeners;
        synchronized (collection) {
            return !this.propListeners.isEmpty();
        }
    }

    protected void runAtomic(ExceptionRunnable r) throws SourceException {
        this.model.runAtomic(r);
    }

    protected void initializeListenerSupport() {
    }

    public final Object getEventSource() {
        return this.getElement();
    }

    public final ElementImpl getElementImpl() {
        return this;
    }

    protected abstract void setParent(ElementImpl var1);

    protected void setParent(org.openide.src.Element parent) {
        this.setParent((ElementImpl)parent.getCookie(ElementImpl.class));
    }

    protected final DefaultLangModel getModelImpl() {
        return this.model;
    }

    protected final Object takeLock() {
        if (this.isCreated()) {
            return null;
        }
        Object o = this.getModelImpl().writeLock();
        return o;
    }

    protected final void releaseLock(Object o) {
        if (this.isCreated()) {
            return;
        }
        this.getModelImpl().releaseWriteLock(o);
    }

    protected final void takeReadLock() {
        this.getModelImpl().readLock();
    }

    protected final void releaseReadLock() {
        this.getModelImpl().releaseReadLock();
    }

    protected final Object takeMasterLock() throws SourceException {
        if (this.isCreated()) {
            return null;
        }
        Object l = this.getModelImpl().masterWriteLock();
        this.checkValid(l);
        return l;
    }

    protected abstract void createFromModel(org.openide.src.Element var1) throws SourceException;

    protected final void commit() {
        if (!this.isValid()) {
            return;
        }
        this.getModelImpl().commitChanges();
    }

    protected final boolean isConstrained() {
        return this.getModelImpl().isConstrained();
    }

    protected Identifier createLocalIdentifier(Identifier id, int status) {
        if (id.getResolutionStatus() == status) {
            return id;
        }
        return Identifier.create((String)id.getFullName(), (String)id.getSourceName(), (int)status);
    }

    protected boolean checkIdentifierContext(Identifier id) {
        return false;
    }

    static class LWeakReference
    extends WeakReference
    implements Runnable {
        private static RequestProcessor CLEANUP_RP;
        private ElementListener listener;

        public LWeakReference(Object ref, ElementListener listener) {
            super(ref, Utilities.activeReferenceQueue());
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$org$netbeans$modules$java$bridge$ElementImpl$LWeakReference == null ? (class$org$netbeans$modules$java$bridge$ElementImpl$LWeakReference = ElementImpl.class$("org.netbeans.modules.java.bridge.ElementImpl$LWeakReference")) : class$org$netbeans$modules$java$bridge$ElementImpl$LWeakReference;
            synchronized (clazz) {
                if (CLEANUP_RP == null) {
                    CLEANUP_RP = new RequestProcessor("Source hierarchy bridge");
                }
            }
            CLEANUP_RP.post(new Runnable(){

                public void run() {
                    try {
                        LWeakReference.this.listener.doRemove();
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    static abstract class ElementListener
    implements MDRChangeListener {
        public static boolean REGISTER_LISTENER = true;
        protected RefObject javaElement;
        protected LWeakReference ref;
        protected ElementImpl impl;
        protected Object source;
        public boolean isValid = true;

        ElementListener(ElementImpl impl) {
            this.javaElement = impl.getJavaElement();
            this.ref = new LWeakReference(impl, this);
        }

        public ElementImpl getImpl() {
            return (ElementImpl)this.ref.get();
        }

        public RefObject getJavaElement() {
            return this.javaElement;
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                Iterator iter = ((InstanceHandler)this.javaElement).getListeners().iterator();
                while (iter.hasNext()) {
                    Object listener = iter.next();
                    if (!(listener instanceof ElementListener)) continue;
                    ((ElementListener)listener).checkValidity();
                }
                ((MDRChangeSource)this.javaElement).addListener((MDRChangeListener)this);
                this.isValid = true;
            }
        }

        public void remove() {
            try {
                ((MDRChangeSource)this.javaElement).removeListener((MDRChangeListener)this);
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
            this.isValid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRemove() {
            MDRepository repository = JavaMetamodel.getDefaultRepository();
            repository.beginTrans(false);
            try {
                this.remove();
            }
            finally {
                repository.endTrans(false);
            }
        }

        public void checkValidity() {
            if (this.ref.get() == null) {
                this.doRemove();
            }
        }

        public final void change(MDRChangeEvent event) {
            if (!this.isValid) {
                return;
            }
            try {
                this.impl = (ElementImpl)this.ref.get();
                if (this.impl == null) {
                    this.doRemove();
                    return;
                }
                this.source = event.getSource();
                if (this.source == this.javaElement && event.isOfType(0x2010002)) {
                    this.doRemove();
                    this.impl.setValid(false);
                    return;
                }
                try {
                    this.doChange(event);
                }
                catch (InvalidObjectException e) {
                    this.doRemove();
                    this.impl.setValid(false);
                }
                this.impl = null;
                this.source = null;
            }
            catch (RuntimeException e) {
                System.out.println("Exception in Listener.change () thrown !!");
                e.printStackTrace();
                throw e;
            }
        }

        public void doChange(MDRChangeEvent event) {
            if (this.source instanceof Feature && event instanceof AttributeEvent && "javadoc".equals(((AttributeEvent)event).getAttributeName())) {
                this.impl.fireJavaDocChange();
            }
        }
    }
}

