/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.jspparser.FastOpenInfoParser;
import org.netbeans.modules.web.jspparser.WebAppParseProxy;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class JspParserImpl
implements JspParserAPI {
    private HashMap parseSupports;
    private static Constructor webAppParserImplConstructor;
    private static final JspParserAPI.JspOpenInfo DEFAULT_OPENINFO;
    private static boolean loggerInitialized;

    public JspParserImpl() {
        JspParserImpl.initializeLogger();
        this.parseSupports = new HashMap();
    }

    private static void initReflection() {
        if (webAppParserImplConstructor == null) {
            File[] files = new File[]{InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/glassfish-jspparser.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/jsp-parser-ext.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/servlet2.5-jsp2.1-api.jar", null, false)};
            try {
                URL[] urls = new URL[files.length];
                for (int i = 0; i < files.length; ++i) {
                    urls[i] = files[i].toURI().toURL();
                }
                ExtClassLoader urlCL = new ExtClassLoader(urls, JspParserImpl.class.getClassLoader());
                Class<?> cl = urlCL.loadClass("org.netbeans.modules.web.jspparser_ext.WebAppParseSupport");
                webAppParserImplConstructor = cl.getDeclaredConstructor(JspParserAPI.WebModule.class);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private static synchronized void initializeLogger() {
    }

    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject jspFile, JspParserAPI.WebModule wm, boolean useEditor) {
        WebAppParseProxy pp;
        FileObject wmRoot;
        JspParserAPI.JspOpenInfo jspOI;
        FastOpenInfoParser fastOIP = FastOpenInfoParser.get(wm);
        if (fastOIP != null && (jspOI = fastOIP.getJspOpenInfo(jspFile, useEditor)) != null) {
            return jspOI;
        }
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (pp = this.getParseProxy(wm)) != null) {
            return pp.getJspOpenInfo(jspFile, useEditor);
        }
        return DEFAULT_OPENINFO;
    }

    public JspParserAPI.ParseResult analyzePage(FileObject jspFile, JspParserAPI.WebModule wm, int errorReportingMode) {
        if (wm == null) {
            return this.getNoWebModuleResult(jspFile, null);
        }
        FileObject wmRoot = wm.getDocumentBase();
        if (wmRoot == null) {
            return this.getNoWebModuleResult(jspFile, wm);
        }
        WebAppParseProxy pp = this.getParseProxy(wm);
        if (pp == null) {
            return this.getNoWebModuleResult(jspFile, wm);
        }
        return pp.analyzePage(jspFile, errorReportingMode);
    }

    public Map getTaglibMap(JspParserAPI.WebModule wm) throws IOException {
        FileObject wmRoot = wm.getDocumentBase();
        if (wmRoot == null) {
            throw new IOException();
        }
        WebAppParseProxy pp = this.getParseProxy(wm);
        return pp.getTaglibMap(true);
    }

    private synchronized WebAppParseProxy getParseProxy(JspParserAPI.WebModule wm) {
        WAParseSupportKey key = new WAParseSupportKey(wm);
        WebAppParseProxy pp = (WebAppParseProxy)this.parseSupports.get(key);
        if (pp == null) {
            pp = this.createParseProxy(wm);
            this.parseSupports.put(key, pp);
        }
        return pp;
    }

    private WebAppParseProxy createParseProxy(JspParserAPI.WebModule wm) {
        try {
            JspParserImpl.initReflection();
            return (WebAppParseProxy)webAppParserImplConstructor.newInstance(wm);
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    public URLClassLoader getModuleClassLoader(JspParserAPI.WebModule wm) {
        WebAppParseProxy pp = this.getParseProxy(wm);
        return pp.getWAClassLoader();
    }

    private JspParserAPI.ParseResult getNoWebModuleResult(FileObject jspFile, JspParserAPI.WebModule wm) {
        JspParserAPI.ErrorDescriptor error = new JspParserAPI.ErrorDescriptor(null, jspFile, -1, -1, NbBundle.getMessage(JspParserImpl.class, (String)"MSG_webModuleNotFound", (Object)jspFile.getNameExt()), "");
        return new JspParserAPI.ParseResult(new JspParserAPI.ErrorDescriptor[]{error});
    }

    static {
        DEFAULT_OPENINFO = new JspParserAPI.JspOpenInfo(false, "ISO-8859-1");
        loggerInitialized = false;
    }

    private static class ExtClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();

        public ExtClassLoader(URL[] classLoadingURLs, ClassLoader parent) {
            super(classLoadingURLs, parent);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }
    }

    private static class WAParseSupportKey {
        JspParserAPI.WebModule wm;
        FileObject wmRoot;

        WAParseSupportKey(JspParserAPI.WebModule wm) {
            this.wm = wm;
            this.wmRoot = wm.getDocumentBase();
        }

        public boolean equals(Object o) {
            if (o instanceof WAParseSupportKey) {
                WAParseSupportKey k = (WAParseSupportKey)o;
                return this.wmRoot.isValid() && k.wmRoot.isValid() && this.wmRoot.getPath().equals(k.wmRoot.getPath());
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

