/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

class MainClassUpdater
implements PropertyChangeListener,
MDRChangeListener {
    private static RequestProcessor performer = new RequestProcessor();
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final ClassPath sourcePath;
    private final String mainClassPropName;
    private JavaClass mainClass;

    public MainClassUpdater(Project project, PropertyEvaluator eval, UpdateHelper helper, ClassPath sourcePath, String mainClassPropName) {
        this.project = project;
        this.eval = eval;
        this.helper = helper;
        this.sourcePath = sourcePath;
        this.mainClassPropName = mainClassPropName;
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.addClassListener();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.mainClassPropName.equals(evt.getPropertyName())) {
            this.addClassListener();
        }
    }

    public void change(MDRChangeEvent event) {
        String newMainClassName;
        AttributeEvent atEvent;
        String attributeName;
        if (event.isOfType(0x101FFFF) && "name".equals(attributeName = (atEvent = (AttributeEvent)event).getAttributeName()) && (newMainClassName = (String)atEvent.getNewElement()) != null) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        String oldMainClass = (String)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){

                            public Object run() throws Exception {
                                EditableProperties props = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                return props.getProperty(MainClassUpdater.this.mainClassPropName);
                            }
                        });
                        if (!newMainClassName.equals(oldMainClass) && MainClassUpdater.this.helper.requestSave()) {
                            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                                public Object run() throws Exception {
                                    EditableProperties props = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                    props.put((Object)MainClassUpdater.this.mainClassPropName, (Object)newMainClassName);
                                    MainClassUpdater.this.helper.putProperties("nbproject/project.properties", props);
                                    ProjectManager.getDefault().saveProject(MainClassUpdater.this.project);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (MutexException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public synchronized void unregister() {
        if (this.mainClass != null) {
            ((MDRChangeSource)this.mainClass).removeListener((MDRChangeListener)this);
            this.mainClass = null;
        }
    }

    private void addClassListener() {
        performer.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block7: {
                    JMManager manager = (JMManager)JavaMetamodel.getManager();
                    manager.waitScanFinished();
                    JavaModel.getJavaRepository().beginTrans(false);
                    try {
                        JavaModel.setClassPath((ClassPath)MainClassUpdater.this.sourcePath);
                        String mainClassName = MainClassUpdater.this.eval.getProperty(MainClassUpdater.this.mainClassPropName);
                        Type type = manager.getDefaultExtent().getType().resolve(mainClassName);
                        if (!(type instanceof JavaClass) || type instanceof UnresolvedClass) break block7;
                        MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                        synchronized (mainClassUpdater) {
                            if (MainClassUpdater.this.mainClass != null) {
                                ((MDRChangeSource)MainClassUpdater.this.mainClass).removeListener((MDRChangeListener)MainClassUpdater.this);
                            }
                            MainClassUpdater.this.mainClass = (JavaClass)type;
                            ((MDRChangeSource)MainClassUpdater.this.mainClass).addListener((MDRChangeListener)MainClassUpdater.this);
                        }
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                }
            }
        });
    }
}

