/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.SunURIManager;
import org.netbeans.modules.j2ee.sun.ide.editors.AdminAuthenticator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.RunTimeDDCatalog;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.ExecSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.RegisterPointbase;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainHostPortPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainNamePasswordPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainPlatformPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainPortsDefPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class AddDomainWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private int index;
    private WizardDescriptor.Panel[] panels = null;
    static final String USER_NAME = "username";
    static final String PASSWORD = "password";
    static final String BLANK = "";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String CREATE_LOCALLY = "create_locally";
    static final String DOMAIN_FILE = "domain_file";
    static final String PLATFORM_LOCATION = "platform_location";
    static final String INSTALL_LOCATION = "install_location";
    static final String DOMAIN = "domain";
    static final String INSTANCE_PORT = "instance_port";
    static final String JMS_PORT = "jms_port";
    static final String ORB_LISTENER_PORT = "orb_listener_port";
    static final String ORB_SSL_PORT = "orb_ssl_port";
    static final String HTTP_SSL_PORT = "http_ssl_port";
    static final String ORB_MUTUAL_AUTH_PORT = "orb_mutual_auth_port";
    static final String ADMIN_JMX_PORT = "admin_jmx_port";
    static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    static final String TYPE = "type";
    static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private AddDomainHostPortPanel hppanel = new AddDomainHostPortPanel();
    private AddDomainDirectoryPanel domainDirPanel = new AddDomainDirectoryPanel(false);
    private AddDomainDirectoryPanel personalDirPanel = new AddDomainDirectoryPanel(true);
    private AddDomainPlatformPanel platformPanel = new AddDomainPlatformPanel();
    private AddDomainNamePasswordPanel unamePanel = new AddDomainNamePasswordPanel();
    private AddDomainPortsDefPanel portsPanel = new AddDomainPortsDefPanel();
    private WizardDescriptor.Panel[] defaultFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.unamePanel};
    private WizardDescriptor.Panel[] remoteFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.hppanel, this.unamePanel};
    private WizardDescriptor.Panel[] localFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.domainDirPanel, this.unamePanel};
    private WizardDescriptor.Panel[] personalFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.personalDirPanel, this.unamePanel, this.portsPanel};
    private transient Set listeners = new HashSet(1);
    private WizardDescriptor wizard;
    static InstanceType PERSONAL = new InstanceType();
    static InstanceType REMOTE = new InstanceType();
    static InstanceType LOCAL = new InstanceType();
    static InstanceType DEFAULT = new InstanceType();

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.decoratePanels(this.remoteFlow);
            this.decoratePanels(this.localFlow);
            this.decoratePanels(this.personalFlow);
            this.decoratePanels(this.defaultFlow);
            this.platformPanel.addChangeListener(this);
            this.panels = this.defaultFlow;
        }
        return this.panels;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener l = (ChangeListener)it.next();
            l.stateChanged(ev);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.wizard.getProperty(TYPE) == REMOTE) {
            this.panels = this.remoteFlow;
            this.decoratePanels(this.remoteFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == DEFAULT) {
            this.panels = this.defaultFlow;
            this.decoratePanels(this.defaultFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == LOCAL) {
            this.panels = this.localFlow;
            this.decoratePanels(this.localFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == PERSONAL) {
            this.panels = this.personalFlow;
            this.decoratePanels(this.personalFlow);
            this.fireChangeEvent();
        } else {
            System.out.println("THIS CANNOT BE TRUE!");
            this.panels = this.defaultFlow;
            this.fireChangeEvent();
        }
    }

    private void decoratePanels(WizardDescriptor.Panel[] pnls) {
        String[] steps = new String[pnls.length];
        for (int i = 0; i < pnls.length; ++i) {
            Component c = pnls[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet(1);
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public Set instantiate() {
        InstanceProperties ip = this.createInstance();
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        if (ip != null) {
            result.add(ip);
        }
        return result;
    }

    private void queryForNameAndWord() {
        PasswordPanel pp = new PasswordPanel();
        pp.setPrompt(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"PROMPT_USERNAME_PASSWORD"));
        DialogDescriptor dd = new DialogDescriptor((Object)pp, NbBundle.getMessage(AddDomainWizardIterator.class, (String)"TITLE_USERNAME_PASSWORD"));
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() != NotifyDescriptor.CANCEL_OPTION) {
            this.wizard.putProperty(USER_NAME, (Object)pp.getUsername());
            this.wizard.putProperty(PASSWORD, (Object)pp.getTPassword());
        } else {
            this.wizard.putProperty(USER_NAME, (Object)BLANK);
            this.wizard.putProperty(PASSWORD, (Object)BLANK);
        }
    }

    public InstanceProperties createInstance() {
        InstanceProperties retVal = null;
        try {
            if (this.isValidHost((String)this.wizard.getProperty(HOST))) {
                String password;
                String uname = (String)this.wizard.getProperty(USER_NAME);
                if (null == uname) {
                    uname = BLANK;
                }
                if (null == (password = (String)this.wizard.getProperty(PASSWORD))) {
                    password = BLANK;
                }
                if (this.wizard.getProperty(TYPE) == PERSONAL) {
                    if (uname.trim().length() < 1 || password.trim().length() < 1) {
                        this.queryForNameAndWord();
                    }
                    if (((String)this.wizard.getProperty(USER_NAME)).trim().length() < 1 || ((String)this.wizard.getProperty(PASSWORD)).trim().length() < 8) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddDomainWizardIterator.class, (String)"ERR_Illegal_Values")));
                        return null;
                    }
                    CreateDomain cd = new CreateDomain(((String)this.wizard.getProperty(USER_NAME)).trim(), ((String)this.wizard.getProperty(PASSWORD)).trim());
                    cd.start();
                } else {
                    retVal = this.createIP(uname, password);
                }
            }
        }
        catch (InstanceCreationException e) {
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 1);
            d.setTitle(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_RegServerFailed"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
        return retVal;
    }

    private InstanceProperties createIP(String uname, String password) throws IllegalStateException, InstanceCreationException {
        String domainDir = (String)this.wizard.getProperty(INSTALL_LOCATION);
        String displayName = (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
        InstanceProperties instanceProperties = SunURIManager.createInstanceProperties((File)((File)this.wizard.getProperty(PLATFORM_LOCATION)), (String)((String)this.wizard.getProperty(HOST)), (String)((String)this.wizard.getProperty(PORT)), (String)uname.trim(), (String)password.trim(), (String)displayName);
        instanceProperties.setProperty("httpportnumber", (String)this.wizard.getProperty(PORT));
        instanceProperties.setProperty("DOMAIN", (String)this.wizard.getProperty(DOMAIN));
        instanceProperties.setProperty("LOCATION", domainDir);
        if (this.wizard.getProperty(TYPE) != REMOTE) {
            RegisterPointbase.getDefault().register((File)this.wizard.getProperty(PLATFORM_LOCATION));
        }
        RunTimeDDCatalog.getRunTimeDDCatalog().refresh();
        this.wizard.putProperty(USER_NAME, (Object)BLANK);
        this.wizard.putProperty(PASSWORD, (Object)BLANK);
        InstanceProperties retVal = instanceProperties;
        return retVal;
    }

    private boolean isValidHost(String hostname) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException ex) {
            String mess = MessageFormat.format(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"MSG_UnknownHost"), hostname);
            Util.showInformationWhenHolding(mess, NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_UnknownHost"));
        }
        return addr != null;
    }

    static class InstanceType {
        InstanceType() {
        }
    }

    static class PasswordPanel
    extends JPanel {
        private static final int DEFAULT_WIDTH = 200;
        private static final int DEFAULT_HEIGHT = 0;
        static final long serialVersionUID = 1555749205340031767L;
        ResourceBundle bundle = NbBundle.getBundle(AdminAuthenticator.class);
        private JPanel mainPanel;
        private JLabel promptLabel;
        private JLabel jLabel1;
        private JTextField usernameField;
        private JLabel jLabel2;
        private JPasswordField passwordField;

        public PasswordPanel() {
            this.initComponents();
            this.usernameField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_UserNameField"));
            this.passwordField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_PasswordField"));
        }

        public Dimension getPreferredSize() {
            Dimension sup = super.getPreferredSize();
            return new Dimension(Math.max(sup.width, 200), Math.max(sup.height, 0));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
            this.promptLabel = new JLabel();
            this.promptLabel.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 6, 0);
            this.mainPanel.add((Component)this.promptLabel, gridBagConstraints1);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(this.bundle.getString("LAB_AUTH_User_Name"));
            this.jLabel1.setDisplayedMnemonic(this.bundle.getString("LAB_AUTH_User_Name_Mnemonic").charAt(0));
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 5, 12);
            gridBagConstraints1.anchor = 17;
            this.mainPanel.add((Component)this.jLabel1, gridBagConstraints1);
            this.usernameField = new JTextField();
            this.usernameField.setMinimumSize(new Dimension(70, 20));
            this.usernameField.setPreferredSize(new Dimension(70, 20));
            this.jLabel1.setLabelFor(this.usernameField);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            this.mainPanel.add((Component)this.usernameField, gridBagConstraints1);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(this.bundle.getString("LAB_AUTH_Password"));
            this.jLabel2.setDisplayedMnemonic(this.bundle.getString("LAB_AUTH_Password_Mnemonic").charAt(0));
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints1);
            this.passwordField = new JPasswordField();
            this.passwordField.setMinimumSize(new Dimension(70, 20));
            this.passwordField.setPreferredSize(new Dimension(70, 20));
            this.jLabel2.setLabelFor(this.passwordField);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            this.mainPanel.add((Component)this.passwordField, gridBagConstraints1);
            this.add((Component)this.mainPanel, "Center");
        }

        String getUsername() {
            return this.usernameField.getText();
        }

        char[] getPassword() {
            return this.passwordField.getPassword();
        }

        String getTPassword() {
            return new String(this.passwordField.getPassword());
        }

        void setPrompt(String prompt) {
            if (prompt == null) {
                this.promptLabel.setVisible(false);
                this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_NbAuthenticatorPasswordPanel"));
            } else {
                this.promptLabel.setVisible(true);
                this.promptLabel.setText(prompt);
                this.getAccessibleContext().setAccessibleDescription(prompt);
            }
        }
    }

    static class PDCancel
    implements Cancellable {
        private Process p;
        private String dirname;
        private boolean notFired = true;

        PDCancel(Process p, String newDirName) {
            this.p = p;
            this.dirname = newDirName;
        }

        public synchronized boolean notFired() {
            return this.notFired;
        }

        public synchronized boolean cancel() {
            this.notFired = false;
            this.p.destroy();
            File domainDir = new File(this.dirname);
            if (domainDir.exists()) {
                FileObject fo = FileUtil.toFileObject((File)domainDir);
                try {
                    fo.delete();
                }
                catch (IOException ex) {
                    Util.showError(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"ERR_Failed_cleanup", (Object)this.dirname));
                }
            }
            return true;
        }
    }

    private class CreateDomain
    extends Thread {
        private String uname;
        private String pword;

        CreateDomain(String uname, String pword) {
            this.uname = uname;
            this.pword = pword;
        }

        public void run() {
            Process process = null;
            File irf = (File)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PLATFORM_LOCATION);
            if (null != irf && irf.exists()) {
                PDCancel pdcan = null;
                String installRoot = irf.getAbsolutePath();
                String asadminCmd = installRoot + File.separator + "bin" + File.separator + "asadmin";
                if (File.separator.equals("\\")) {
                    asadminCmd = asadminCmd + ".bat";
                }
                String domain = (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.DOMAIN);
                String domainDir = (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.INSTALL_LOCATION);
                File passWordFile = Utils.createTempPasswordFile(this.pword, "changeit");
                if (passWordFile == null) {
                    return;
                }
                String[] arrnd = new String[]{asadminCmd, "create-domain", "--domaindir", domainDir, "--adminport", (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PORT), "--adminuser", this.uname, "--passwordfile", passWordFile.getAbsolutePath(), "--instanceport", (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.INSTANCE_PORT), "--domainproperties", "jms.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.JMS_PORT)).trim() + ":orb.listener.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_LISTENER_PORT)).trim() + ":http.ssl.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.HTTP_SSL_PORT)).trim() + ":orb.ssl.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_SSL_PORT)).trim() + ":orb.mutualauth.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_MUTUAL_AUTH_PORT)).trim() + ":domain.jmxPort=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ADMIN_JMX_PORT)).trim(), domain};
                ProgressHandle ph = null;
                try {
                    ExecSupport ee = new ExecSupport();
                    process = Runtime.getRuntime().exec(arrnd);
                    pdcan = new PDCancel(process, domainDir + File.separator + domain);
                    ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_Creating_personal_domain"), (Cancellable)pdcan);
                    ph.start();
                    ee.displayProcessOutputs(process, NbBundle.getMessage(this.getClass(), (String)"LBL_outputtab"), NbBundle.getMessage(this.getClass(), (String)"LBL_RunningCreateDomainCommand"));
                }
                catch (MissingResourceException ex) {
                    Util.showInformation(ex.getLocalizedMessage());
                }
                catch (IOException ex) {
                    Util.showInformation(ex.getLocalizedMessage());
                }
                catch (InterruptedException ex) {
                    Util.showInformation(ex.getLocalizedMessage());
                }
                catch (RuntimeException ex) {
                    Util.showInformation(ex.getLocalizedMessage());
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                int retVal = 0;
                if (null != process) {
                    try {
                        retVal = process.waitFor();
                    }
                    catch (InterruptedException ie) {
                        retVal = -1;
                        ErrorManager.getDefault().notify(1, (Throwable)ie);
                    }
                }
                if (null != ph) {
                    ph.finish();
                }
                if (null != pdcan) {
                    if (0 != retVal && pdcan.notFired()) {
                        Util.showError(NbBundle.getMessage(this.getClass(), (String)"WARN_DELETE_INSTANCE", (Object)((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PROP_DISPLAY_NAME))), NbBundle.getMessage(this.getClass(), (String)"WARN_DELETE_INSTANCE_TITLE"));
                    } else if (pdcan.notFired()) {
                        try {
                            AddDomainWizardIterator.this.createIP(this.uname, this.pword);
                        }
                        catch (InstanceCreationException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        catch (IllegalStateException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            }
        }
    }
}

