/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.swt.widgets.Control;

public class ControlObservableValue
extends AbstractObservableValue {
    private final Control control;
    private final String attribute;

    public ControlObservableValue(Control control, String attribute) {
        this.control = control;
        this.attribute = attribute;
        if (!attribute.equals("enabled") && !attribute.equals("visible")) {
            throw new IllegalArgumentException();
        }
    }

    public void setValue(Object value) {
        Object oldValue = this.doGetValue();
        if (this.attribute.equals("enabled")) {
            this.control.setEnabled(((Boolean)value).booleanValue());
        } else if (this.attribute.equals("visible")) {
            this.control.setVisible(((Boolean)value).booleanValue());
        }
        this.fireValueChange(Diffs.createValueDiff(oldValue, value));
    }

    public Object doGetValue() {
        return new Boolean(this.attribute.equals("enabled") ? this.control.getEnabled() : this.control.getVisible());
    }

    public Object getValueType() {
        return Boolean.TYPE;
    }
}

