/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.wst.rdb.data.internal.core.common.data.DataSerializer;
import org.eclipse.wst.rdb.data.internal.core.common.data.ResultSetReader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.outputview.IXMLResult;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.ProcedureCallCache;
import org.eclipse.wst.rdb.internal.outputview.ResultTableRow;

public class ResultTableModel {
    private static final String XML_RESULTS_EXT_POINT = "org.eclipse.wst.rdb.outputview.xmlResults";
    private static final String XML_RESULT_ATTR_XMLDATA = "xmldata";
    protected String[] columnNames;
    protected ArrayList tableRows;
    protected int numRows;
    protected int columnCount;
    protected boolean haveRS = false;
    protected int[] columnTypes;
    protected int[] columnLengths;
    protected char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ResultTableModel() {
        this.haveRS = false;
        this.numRows = 0;
        this.columnCount = 0;
        this.tableRows = new ArrayList();
    }

    public ResultTableModel(ResultSet rs) throws SQLException {
        if (rs != null) {
            this.haveRS = true;
            int maxLOBLengthRetrieved = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
            try {
                this.tableRows = new ArrayList();
                ResultSetMetaData rmeta = rs.getMetaData();
                this.columnCount = rmeta.getColumnCount();
                this.columnNames = new String[this.columnCount];
                this.columnTypes = new int[this.columnCount];
                this.columnLengths = new int[this.columnCount];
                int j = 1;
                while (j <= this.columnCount) {
                    this.columnNames[j - 1] = rmeta.getColumnName(j);
                    this.columnTypes[j - 1] = rmeta.getColumnType(j);
                    try {
                        this.columnLengths[j - 1] = rmeta.getPrecision(j);
                    }
                    catch (Exception exception) {
                        this.columnLengths[j - 1] = 5;
                    }
                    ++j;
                }
                this.numRows = 0;
                while (rs.next()) {
                    ResultTableRow row = new ResultTableRow(this.columnCount);
                    int i = 1;
                    while (i <= this.columnCount) {
                        String value = null;
                        int colType = rmeta.getColumnType(i);
                        Object result = null;
                        if (colType == 1111) {
                            result = this.getXMLFromExtension(rs, i);
                        }
                        if (result != null) {
                            row.setColumn(result, i - 1);
                        } else {
                            Object o = ResultSetReader.read((ResultSet)rs, (int)(i - 1), (int)maxLOBLengthRetrieved);
                            value = DataSerializer.serialize((Object)o, (int)colType);
                            row.setColumn(value, i - 1);
                        }
                        ++i;
                    }
                    this.tableRows.add(row);
                    ++this.numRows;
                }
            }
            catch (SQLException sqlE) {
                throw sqlE;
            }
            catch (Exception e) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:constructor.", e);
            }
        }
    }

    private String getValueForCLOB(ResultSet aResult, int index, int maxLength) {
        try {
            Clob clob = aResult.getClob(index);
            if (clob != null) {
                String stringValue = clob.getSubString(1L, maxLength);
                return stringValue;
            }
        }
        catch (Exception ex) {
            OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getValueForCLOB.", ex);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getValueForBLOB(ResultSet aResult, int index, int maxLength) {
        BufferedInputStream stream = null;
        try {
            block14: {
                String string;
                stream = new BufferedInputStream(aResult.getBinaryStream(index));
                byte[] byteArray = new byte[maxLength];
                try {
                    stream.available();
                }
                catch (IOException iOException) {
                    Object var9_7 = null;
                    try {
                        if (stream == null) return null;
                        stream.close();
                        return null;
                    }
                    catch (Exception exception) {}
                    return null;
                }
                int bytesRead = stream.read(byteArray, 0, maxLength);
                if (bytesRead <= 0) break block14;
                StringBuffer sb = new StringBuffer(bytesRead * 2);
                int i = 0;
                while (true) {
                    if (i >= bytesRead) {
                        String stringValue;
                        string = stringValue = sb.toString();
                        Object var9_8 = null;
                        break;
                    }
                    sb.append(this.hexDigits[(byteArray[i] & 0xF0) >>> 4]);
                    sb.append(this.hexDigits[byteArray[i] & 0xF]);
                    ++i;
                }
                try {}
                catch (Exception exception) {}
                if (stream == null) return string;
                stream.close();
                return string;
                catch (Exception ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getValueForBLOB.", ex);
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {}
            catch (Exception exception) {}
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    public ResultTableModel(ProcedureCallCache proc) throws SQLException {
        if (proc != null) {
            this.haveRS = false;
            this.tableRows = new ArrayList();
            this.columnCount = proc.getColumnCount();
            this.columnNames = new String[this.columnCount];
            this.columnTypes = new int[this.columnCount];
            this.columnLengths = new int[this.columnCount];
            int j = 1;
            while (j <= this.columnCount) {
                this.columnNames[j - 1] = proc.getColumnName(j);
                this.columnTypes[j - 1] = proc.getColumnSQLType(j);
                this.columnLengths[j - 1] = proc.getColumnLength(j);
                ++j;
            }
            this.numRows = proc.getNumRows();
            int i = 0;
            while (i < this.numRows) {
                ResultTableRow row = new ResultTableRow(this.columnCount);
                int j2 = 1;
                while (j2 <= this.columnCount) {
                    Object result = null;
                    if (this.columnTypes[j2 - 1] == 1111) {
                        result = this.getXMLFromExtension(proc, j2);
                    }
                    if (result != null) {
                        row.setColumn(result, j2 - 1);
                    } else {
                        row.setColumn(proc.getColumnValueToString(j2), j2 - 1);
                    }
                    ++j2;
                }
                this.tableRows.add(row);
                proc.nextRow();
                ++i;
            }
        }
    }

    public ResultTableRow getRow(int rowIndex) {
        return (ResultTableRow)this.tableRows.get(rowIndex);
    }

    public ArrayList getTableRows() {
        return this.tableRows;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected int getResultSetRowCount() {
        if (this.haveRS) {
            return this.numRows;
        }
        return -1;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }

    protected Object getXMLFromExtension(ProcedureCallCache procCache, int col) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(XML_RESULTS_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement currentConfigElement = configElements[j];
                try {
                    IXMLResult myXMLResults = (IXMLResult)currentConfigElement.createExecutableExtension(XML_RESULT_ATTR_XMLDATA);
                    myXMLResults.initXMLResult(procCache, col);
                    return myXMLResults;
                }
                catch (CoreException ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getXMLFromExtension()", ex);
                }
                catch (Exception e) {
                    MessageBox box = new MessageBox(OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                    box.setMessage(e.getMessage());
                    box.open();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected Object getXMLFromExtension(ResultSet resultSet, int col) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(XML_RESULTS_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement currentConfigElement = configElements[j];
                try {
                    IXMLResult myXMLResults = (IXMLResult)currentConfigElement.createExecutableExtension(XML_RESULT_ATTR_XMLDATA);
                    myXMLResults.initXMLResult(resultSet, col);
                    return myXMLResults;
                }
                catch (CoreException ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "ResultTableModel:getXMLFromExtension()", ex);
                }
                catch (Exception e) {
                    MessageBox box = new MessageBox(OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                    box.setMessage(e.getMessage());
                    box.open();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

