/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.internal.proxy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.eclipse.wst.internet.internal.proxy.Base64;

public class Encoder {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String USAGE = "Usage: Encoder [-action encode|decode] [-key <key-name>] [-in <input-file-name>] [-out <output-file-name>]";
    public static final String ENCODE_ACTION = "encode";
    public static final String DECODE_ACTION = "decode";
    public static final String DEFAULT_ACTION = "encode";
    public static final String DEFAULT_KEY = "password";
    public static final String ACTION_OPTION = "-action";
    public static final String KEY_OPTION = "-key";
    public static final String INPUT_OPTION = "-in";
    public static final String OUTPUT_OPTION = "-out";
    private String outputFileName;
    private String inputFileName;
    private String keyName = "password";
    private String action = "encode";
    private Properties properties;
    private static final String ENCODED_PREFIX = "encoded:";
    private static final String CHARACTER_ENCODING = "utf-8";

    public static String decode(String encodedText) throws IllegalArgumentException {
        String clearText;
        if (!Encoder.isEncoded(encodedText)) {
            throw new IllegalArgumentException("Text is not encoded.");
        }
        String base64 = encodedText.substring(ENCODED_PREFIX.length());
        byte[] data8 = Base64.decode(base64);
        int length8 = data8.length;
        if (length8 % 8 != 0) {
            throw new IllegalArgumentException("Encoded text has wrong length.");
        }
        int length = length8 / 8;
        byte[] data = new byte[length];
        int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < 8) {
                int k = j * length + i;
                byte value = data8[k];
                if (((value = (byte)(value ^ k)) & mask[j]) != value) {
                    throw new IllegalArgumentException("Encoded text has illegal value.");
                }
                int n = i;
                data[n] = (byte)(data[n] + value);
                ++j;
            }
            ++i;
        }
        try {
            clearText = new String(data, CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getLocalizedMessage());
        }
        return clearText;
    }

    public static String encode(String clearText) throws IllegalArgumentException {
        byte[] data;
        if (Encoder.isEncoded(clearText)) {
            throw new IllegalArgumentException("Text is already encoded.");
        }
        try {
            data = clearText.getBytes(CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getLocalizedMessage());
        }
        int length = data.length;
        byte[] data8 = new byte[length * 8];
        int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < 8) {
                int k = j * length + i;
                data8[k] = (byte)(mask[j] & data[i]);
                int n = k;
                data8[n] = (byte)(data8[n] ^ k);
                ++j;
            }
            ++i;
        }
        String base64 = Base64.encode(data8);
        return ENCODED_PREFIX + base64;
    }

    public String getAction() {
        return this.action;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static boolean isEncoded(String text) {
        return text.startsWith(ENCODED_PREFIX);
    }

    public void load() throws IOException, FileNotFoundException {
        String inputFileName = this.getInputFileName();
        InputStream in = inputFileName == null ? System.in : new FileInputStream(inputFileName);
        Properties properties = new Properties();
        properties.load(in);
        in.close();
        this.setProperties(properties);
    }

    public static void main(String[] args) {
        Encoder encoder = new Encoder();
        try {
            encoder.parseArgs(args);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.err.println(USAGE);
            return;
        }
        try {
            encoder.load();
            encoder.update();
            encoder.store();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void parseArgs(String[] args) {
        int n = args.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be in option-value pairs.");
        }
        int i = 0;
        while (i < n) {
            String option = args[i];
            String value = args[i + 1];
            if (option.equals(ACTION_OPTION)) {
                this.setAction(value);
            } else if (option.equals(KEY_OPTION)) {
                this.setKeyName(value);
            } else if (option.equals(INPUT_OPTION)) {
                this.setInputFileName(value);
            } else if (option.equals(OUTPUT_OPTION)) {
                this.setOutputFileName(value);
            } else {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            i += 2;
        }
    }

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public void setInputFileName(String newInputFileName) {
        this.inputFileName = newInputFileName;
    }

    public void setKeyName(String newKeyName) {
        this.keyName = newKeyName;
    }

    public void setOutputFileName(String newOutputFileName) {
        this.outputFileName = newOutputFileName;
    }

    public void setProperties(Properties newProperties) {
        this.properties = newProperties;
    }

    public void store() throws IOException, FileNotFoundException {
        String outputFileName = this.getOutputFileName();
        OutputStream out = outputFileName == null ? System.out : new FileOutputStream(outputFileName);
        Properties properties = this.getProperties();
        properties.store(out, null);
        out.close();
    }

    public void update() {
        Properties properties = this.getProperties();
        String keyName = this.getKeyName();
        String keyValue = properties.getProperty(this.keyName);
        if (keyValue == null || keyValue.length() == 0) {
            return;
        }
        String action = this.getAction();
        if (Encoder.isEncoded(keyValue)) {
            if (action.equals(DECODE_ACTION)) {
                keyValue = Encoder.decode(keyValue);
            }
        } else if (action.equals("encode")) {
            keyValue = Encoder.encode(keyValue);
        }
        properties.setProperty(keyName, keyValue);
    }
}

