/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.debug.PerlDebugModel;
import org.epic.debug.PerlLineBreakpoint;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        Job job = new Job("Toggle Line Breakpoint (epic)"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = ToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor == null || !(selection instanceof ITextSelection)) {
                    return Status.OK_STATUS;
                }
                int lineNumber = ((TextSelection)selection).getStartLine() + 1;
                IResource resource = ToggleBreakpointAdapter.this.getResource(editor);
                try {
                    IBreakpoint breakpoint = PerlDebugModel.lineBreakpointExists(resource, lineNumber);
                    if (breakpoint != null) {
                        ToggleBreakpointAdapter.this.removeBreakpoint(breakpoint, true);
                    } else {
                        ToggleBreakpointAdapter.this.createLineBreakpoint(resource, lineNumber);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    protected IResource getResource(ITextEditor editor) {
        IResource resource;
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            IEditorInput iEditorInput2 = editor.getEditorInput();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)iEditorInput2.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)part.getAdapter((Class)clazz);
    }

    private void createLineBreakpoint(IResource resource, int lineNumber) {
        try {
            new PerlLineBreakpoint(resource, lineNumber);
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }
}

