/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOModelWizard.java,v 1.14 2006/02/21 13:16:06 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.presentation;


import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.provider.SDOEditPlugin;


import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;

//import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;


/**
 * This is a simple wizard for creating a new model file.
 */
public class SDOModelWizard extends Wizard implements INewWizard
{
  /**
   * This caches an instance of the model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SDOPackage sdoPackage = SDOPackage.eINSTANCE;

  /**
   * This caches an instance of the model factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SDOFactory sdoFactory = sdoPackage.getSDOFactory();

  /**
   * This is the file creation page.
   */
  protected SDOModelWizardNewFileCreationPage newFileCreationPage;

  /**
   * This is the file creation page.
   */
  protected SDOModelWizardInitialObjectCreationPage initialObjectCreationPage;

  /**
   * Remember the selection during initialization for populating the default container.
   */
  protected IStructuredSelection selection;

  /**
   * Remember the workbench during initialization.
   */
  protected IWorkbench workbench;

  /**
   * Caches the names of the types that can be created as the root object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected List initialObjectNames;

  /**
   * This just records the information.
   */
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
    this.workbench = workbench;
    this.selection = selection;
    setWindowTitle(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
    setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SDOEditorPlugin.INSTANCE.getImage("full/wizban/NewSDO")));
  }

  /**
   * Returns the names of the types that can be created as the root object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection getInitialObjectNames()
  {
    if (initialObjectNames == null)
    {
      initialObjectNames = new ArrayList();
      for (Iterator classifiers = sdoPackage.getEClassifiers().iterator(); classifiers.hasNext(); )
      {
        EClassifier eClassifier = (EClassifier)classifiers.next();
        if (eClassifier instanceof EClass)
        {
          EClass eClass = (EClass)eClassifier;
          if (!eClass.isAbstract())
          {
            initialObjectNames.add(eClass.getName());
          }
        }
      }
      Collections.sort(initialObjectNames, java.text.Collator.getInstance());
    }
    return initialObjectNames;
  }

  /**
   * Create a new model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EObject createInitialModel()
  {
    EClass eClass = (EClass)sdoPackage.getEClassifier(initialObjectCreationPage.getInitialObjectName());
    EObject rootObject = sdoFactory.create(eClass);
    return rootObject;
  }

  /**
   * Do the work after everything is specified.
   */
  public boolean performFinish()
  {
    try
    {
      // Remember the file.
      //
      final IFile modelFile = getModelFile();

      // Do the work within an operation.
      //
      WorkspaceModifyOperation operation =
        new WorkspaceModifyOperation()
        {
          protected void execute(IProgressMonitor progressMonitor)
          {
            try
            {
              // Create the initial model object.
              //
              EDataGraph eDataGraph = initialObjectCreationPage.createRootObject();

              // Get the URI of the model file.
              //
              URI fileURI = URI.createPlatformResourceURI(modelFile.getFullPath().toString());
              eDataGraph.getDataGraphResource().setURI(fileURI);

              // Save the contents of the resource to the file system.
              //
              Map options = new HashMap();
              options.put(XMLResource.OPTION_ENCODING, initialObjectCreationPage.getEncoding());
              eDataGraph.getDataGraphResource().save(options);
            }
            catch (Exception exception)
            {
              SDOEditorPlugin.INSTANCE.log(exception);
            }
            finally
            {
              progressMonitor.done();
            }
          }
        };

      getContainer().run(false, false, operation);

      // Select the new file resource in the current view.
      //
      IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
      IWorkbenchPage page = workbenchWindow.getActivePage();
      final IWorkbenchPart activePart = page.getActivePart();
      if (activePart instanceof ISetSelectionTarget)
      {
        final ISelection targetSelection = new StructuredSelection(modelFile);
        getShell().getDisplay().asyncExec
          (new Runnable()
           {
             public void run()
             {
               ((ISetSelectionTarget)activePart).selectReveal(targetSelection);
             }
           });
      }

      // Open an editor on the new file.
      //
      try
      {
        page.openEditor
          (new FileEditorInput(modelFile),
           workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
      }
      catch (PartInitException exception)
      {
        MessageDialog.openError(workbenchWindow.getShell(), SDOEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), exception.getMessage());
        return false;
      }

      return true;
    }
    catch (Exception exception)
    {
      SDOEditorPlugin.INSTANCE.log(exception);
      return false;
    }
  }

  /**
   * This is the one page of the wizard.
   */
  public class SDOModelWizardNewFileCreationPage extends WizardNewFileCreationPage
  {
    /**
     * Remember the model file.
     */
    protected IFile modelFile;

    /**
     * Pass in the selection.
     */
    public SDOModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection)
    {
      super(pageId, selection);
    }

    /**
     * The framework calls this to see if the file is correct.
     */
    protected boolean validatePage()
    {
      if (super.validatePage())
      {
        // Make sure the file ends in ".sdo".
        //
        String requiredExt = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
        String enteredExt = new Path(getFileName()).getFileExtension();
        if (enteredExt == null || !enteredExt.equals(requiredExt))
        {
          setErrorMessage(SDOEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object [] { requiredExt }));
          return false;
        }
        else
        {
          return true;
        }
      }
      else
      {
        return false;
      }
    }

    /**
     * Store the dialog field settings upon completion.
     */
    public boolean performFinish()
    {
      modelFile = getModelFile();
      return true;
    }

    public IFile getModelFile()
    {
      return
        modelFile == null ?
          ResourcesPlugin.getWorkspace().getRoot().getFile(getContainerFullPath().append(getFileName())) :
          modelFile;
    }
  }

  /**
   * This is the page where the type of object to create is selected.
   */
  public class SDOModelWizardInitialObjectCreationPage extends WizardPage
  {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Combo initialObjectField;

    /**
     * @generated
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     */
    protected List encodings;

    /**
     * The URI of the model to fetch
     */
    protected String modelURI;

    /**
     */
    protected CCombo modelURIField;

    /**
     * The name of the model to fetch
     */
    protected String modelObject;

    /**
     */
    protected EDataGraph eDataGraph;

    protected boolean isType;

    /**
     */
    protected String encoding;

    /**
     */
    protected CCombo encodingField;

    /**
     * Pass in the selection.
     */
    public SDOModelWizardInitialObjectCreationPage(String pageId)
    {
      super(pageId);
    }

    public EDataGraph createRootObject()
    {
      if (isType)
      {
        eDataGraph.createRootObject(eDataGraph.getType(getModelURI(), getModelObject()));
      }
      else
      {
        EClass documentRoot = (EClass)eDataGraph.getEClassifier(getModelURI(), "");
        EObject rootObject = eDataGraph.createEObject(documentRoot);
        eDataGraph.setERootObject(rootObject);

        EStructuralFeature eStructuralFeature = documentRoot.getEStructuralFeature(getModelObject());
        if (eStructuralFeature instanceof EAttribute)
        {
        }
        else
        {
          rootObject.eSet(eStructuralFeature, eDataGraph.createEObject((EClass)eStructuralFeature.getEType()));
        }
      }
      return eDataGraph;
    }

    /**
     */
    public void createControl(Composite parent)
    {
      Composite composite = new Composite(parent, SWT.NONE);
      {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        composite.setLayout(layout);

        GridData data = new GridData();
        data.verticalAlignment = GridData.FILL;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = GridData.FILL;
        composite.setLayoutData(data);
      }

      Label modelURILabel = new Label(composite, SWT.LEFT);
      {
        modelURILabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelURI"));

        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        modelURILabel.setLayoutData(data);
      }

      Composite buttonComposite = new Composite(composite, SWT.NONE);
      {
        GridData data = new GridData();
        data.horizontalAlignment = GridData.END;
        buttonComposite.setLayoutData(data);
      
        RowLayout layout = new RowLayout();
        layout.justify = true;
        layout.pack = true;
        layout.spacing = 15;
        buttonComposite.setLayout(layout);
      }
      Button modelURIBrowseFileSystemButton = new Button(buttonComposite, SWT.PUSH);
      modelURIBrowseFileSystemButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));

      final String [] filters = { "*.xsd;*.wsdl;*.ecore;*.emof", "*.xsd;*.wsdl", "*.xsd", "*.wsdl", "*.ecore;*.emof", "*.ecore", "*.emof" };
      final List suffixList = Arrays.asList(new String [] { "xsd", "wsdl", "ecore", "emof" });
      modelURIBrowseFileSystemButton.addSelectionListener
        (new SelectionAdapter()
         {
           public void widgetSelected(SelectionEvent event)
           {
             FileDialog fileDialog = new FileDialog(SDOModelWizardInitialObjectCreationPage.this.getShell());
             fileDialog.setFilterExtensions(filters);
             fileDialog.open();
             if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0)
             {
               String filePath = fileDialog.getFilterPath() + File.separator + fileDialog.getFileName();
               modelURIField.setText((modelURIField.getText() + "  " + URI.createFileURI(filePath).toString()).trim());
               loadModelURI();
             }
           }
         });
      
      Button modelURIBrowseWorkspaceButton = new Button(buttonComposite, SWT.PUSH);
      modelURIBrowseWorkspaceButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
      modelURIBrowseWorkspaceButton.addSelectionListener
        (new SelectionAdapter()
         {
           public void widgetSelected(SelectionEvent event)
           {
             ResourceSelectionDialog resourceSelectionDialog =
               new ResourceSelectionDialog
                 (SDOModelWizardInitialObjectCreationPage.this.getShell(),
                  ResourcesPlugin.getWorkspace().getRoot(),
                  SDOEditorPlugin.INSTANCE.getString("_UI_SelectTheModel_label"));

             resourceSelectionDialog.open();
             Object [] result = resourceSelectionDialog.getResult();
             if (result != null)
             {
               StringBuffer text = new StringBuffer();
               for (int i = 0; i < result.length; ++i)
               {
                 IResource resource = (IResource)result[i];
                 if (resource.getType() == IResource.FILE && suffixList.contains(resource.getFullPath().getFileExtension()))
                 {
                   text.append(URI.createPlatformResourceURI(resource.getFullPath().toString()));
                   text.append("  ");
                 }
               }
               modelURIField.setText((modelURIField.getText() + "  " + text.toString()).trim());
               loadModelURI();
             }
           }
         });

      modelURIField = new CCombo(composite, SWT.BORDER);
      {
        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        modelURIField.setLayoutData(data);
      }

      List packageURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
      Collections.sort(packageURIs, java.text.Collator.getInstance());
      for (Iterator i = packageURIs.iterator(); i.hasNext(); )
      {
        String objectName = (String)i.next();
        modelURIField.add(objectName);
      }

      modelURIField.addSelectionListener
        (new SelectionAdapter()
         {
           public void widgetSelected(SelectionEvent e)
           {
             loadModelURI();
           }
         });


      Label initialObjectLabel = new Label(composite, SWT.LEFT);
      {
        initialObjectLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelObject"));

        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        initialObjectLabel.setLayoutData(data);
      }

      Button loadModelButton = new Button(composite, SWT.PUSH);
      loadModelButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Load_label"));
      {
        GridData data = new GridData();
        data.horizontalAlignment = GridData.END;
        loadModelButton.setLayoutData(data);
      }
      
      loadModelButton.addSelectionListener
        (new SelectionAdapter()
         {
           public void widgetSelected(SelectionEvent event)
           {
             loadModelURI();
           }
         });

      initialObjectField = new Combo(composite, SWT.BORDER);
      {
        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        initialObjectField.setLayoutData(data);
      }
      initialObjectField.addSelectionListener
        (new SelectionAdapter()
         {
           public void widgetSelected(SelectionEvent e)
           {
             setPageComplete(isPageComplete());
           }
         });

      Label encodingLabel = new Label(composite, SWT.LEFT);
      {
        encodingLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));

        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        data.horizontalSpan = 2;
        encodingLabel.setLayoutData(data);
      }
      encodingField = new CCombo(composite, SWT.BORDER);
      {
        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        encodingField.setLayoutData(data);
      }

      for (StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices")); stringTokenizer.hasMoreTokens(); )
      {
        encodingField.add(stringTokenizer.nextToken());
      }
      encodingField.select(0);

      setControl(composite);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ModifyListener validator =
      new ModifyListener()
      {
        public void modifyText(ModifyEvent e)
        {
          setPageComplete(validatePage());
        }
      };

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected boolean validatePage()
    {
      return getInitialObjectName() != null && getEncodings().contains(encodingField.getText());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setVisible(boolean visible)
    {
      super.setVisible(visible);
      if (visible)
      {
        if (initialObjectField.getItemCount() == 1)
        {
          initialObjectField.clearSelection();
          encodingField.setFocus();
        }
        else
        {
          encodingField.clearSelection();
          initialObjectField.setFocus();
        }
      }
    }

    protected void loadModelURI()
    {
      eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
      ResourceSet resourceSet = eDataGraph.getResourceSet();
      Resource resource = resourceSet.getResource(URI.createURI(getModelURI()), true);
      List objectNames = new ArrayList();
      for (Iterator i = resource.getContents().iterator(); i.hasNext(); )
      {
        Object object = i.next();
        if (object instanceof EPackage)
        {
          EPackage ePackage = (EPackage)object;

          if (resource.getResourceSet() == resourceSet)
          {
            ePackage.setEFactoryInstance(new DynamicEDataObjectImpl.FactoryImpl());
            resourceSet.getPackageRegistry().put(resource.getURI().toString(), ePackage);
            resourceSet.getPackageRegistry().put(ePackage.getNsURI(), ePackage);
          }
          else if (resourceSet.getPackageRegistry().getEPackage(getModelURI()) != null)
          {
            // Fetch the package with the matching nsURI (which might be different for nested packages).
            //
            ePackage = resourceSet.getPackageRegistry().getEPackage(getModelURI());
          }

          EClass documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(ePackage);
          if (documentRoot != null)
          {
            isType = false;
            for (Iterator j = ExtendedMetaData.INSTANCE.getElements(documentRoot).iterator(); j.hasNext(); )
            {
              EStructuralFeature eStructuralFeature = (EStructuralFeature)j.next();
              objectNames.add(eStructuralFeature.getName());
            }
          }
          else
          {
            isType = true;
            for (Iterator j = ePackage.getEClassifiers().iterator(); j.hasNext(); )
            {
              EClassifier eClassifier = (EClassifier)j.next();
              if (eClassifier instanceof EClass)
              {
                objectNames.add(eClassifier.getName());
              }
            }
          }

          break;
        }
      }

      initialObjectField.removeAll();
      Collections.sort(objectNames, java.text.Collator.getInstance());
      for (Iterator i = objectNames.iterator(); i.hasNext(); )
      {
        String objectName = (String)i.next();
        initialObjectField.add(objectName);
      }

      setPageComplete(isPageComplete());
    }

    public boolean isPageComplete()
    {
      return initialObjectField.getSelectionIndex() != -1;
    }

    /**
     * Store the dialog field settings upon completion.
     */
    public boolean performFinish()
    {
      modelURI = getModelURI();
      modelObject = getModelObject();
      encoding = getEncoding();
      return true;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getInitialObjectName()
    {
      String label = initialObjectField.getText();

      for (Iterator i = getInitialObjectNames().iterator(); i.hasNext(); )
      {
        String name = (String)i.next();
        if (getLabel(name).equals(label))
        {
          return name;
        }
      }
      return null;
    }

    /**
     */
    public String getModelURI()
    {
      return
        modelURI == null ?
          modelURIField.getText() :
          modelURI;
    }

    /**
     */
    public String getModelObject()
    {
      return
        modelObject == null ?
          initialObjectField.getText() :
          modelObject;
    }

    /**
     */
    public String getEncoding()
    {
      return
        encoding == null ?
          encodingField.getText() :
          encoding;
    }

    /**
     * Returns the label for the specified type name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected String getLabel(String typeName)
    {
      try
      {
        return SDOEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
      }
      catch(MissingResourceException mre)
      {
        SDOEditorPlugin.INSTANCE.log(mre);
      }
      return typeName;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection getEncodings()
    {
      if (encodings == null)
      {
        encodings = new ArrayList();
        for (StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices")); stringTokenizer.hasMoreTokens(); )
        {
          encodings.add(stringTokenizer.nextToken());
        }
      }
      return encodings;
    }
  }

  /**
   * The framework calls this to create the contents of the wizard.
   */
  public void addPages()
  {
    // Create a page, set the title, and the initial model file name.
    //
    newFileCreationPage = new SDOModelWizardNewFileCreationPage("Whatever", selection);
    newFileCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
    newFileCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_description"));
    newFileCreationPage.setFileName(SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase") + "." + SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension"));
    addPage(newFileCreationPage);

    // Try and get the resource selection to determine a current directory for the file dialog.
    //
    if (selection != null && !selection.isEmpty())
    {
      // Get the resource...
      //
      Object selectedElement = selection.iterator().next();
      if (selectedElement instanceof IResource)
      {
        // Get the resource parent, if its a file.
        //
        IResource selectedResource = (IResource)selectedElement;
        if (selectedResource.getType() == IResource.FILE)
        {
          selectedResource = selectedResource.getParent();
        }

        // This gives us a directory...
        //
        if (selectedResource instanceof IFolder || selectedResource instanceof IProject)
        {
          // Set this for the container.
          //
          newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());

          // Make up a unique new name here.
          //
          String defaultModelBaseFilename = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase");
          String defaultModelFilenameExtension = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
          String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
          for (int i = 1; ((IContainer)selectedResource).findMember(modelFilename) != null; ++i)
          {
            modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
          }
          newFileCreationPage.setFileName(modelFilename);
        }
      }
    }
    initialObjectCreationPage = new SDOModelWizardInitialObjectCreationPage("Whatever2");
    initialObjectCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
    initialObjectCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
    addPage(initialObjectCreationPage);
  }

  /**
   * Get the file from the page.
   */
  public IFile getModelFile()
  {
    return newFileCreationPage.getModelFile();
  }
}
