theta.md                package:MASS                R Documentation

_E_s_t_i_m_a_t_e _t_h_e_t_a _o_f _t_h_e _N_e_g_a_t_i_v_e _B_i_n_o_m_i_a_l

_D_e_s_c_r_i_p_t_i_o_n:

     Given the estimated mean vector, estimate 'theta' of the Negative
     Binomial Distribution.

_U_s_a_g_e:

     theta.md(y, mu, dfr, weights, limit = 20, eps = .Machine$double.eps^0.25)

     theta.ml(y, mu, n, weights, limit = 10, eps = .Machine$double.eps^0.25,
              trace = FALSE)

     theta.mm(y, mu, dfr, weights, limit = 10, eps = .Machine$double.eps^0.25)

_A_r_g_u_m_e_n_t_s:

       y: Vector of observed values from the Negative Binomial. 

      mu: Estimated mean vector. 

       n: Number of data points (defaults to the sum of 'weights') 

     dfr: Residual degrees of freedom (assuming 'theta' known).  For a
          weighted fit this is the sum of the weights minus the number
          of fitted parameters. 

 weights: Case weights.  If missing, taken as 1. 

   limit: Limit on the number of iterations. 

     eps: Tolerance to determine convergence. 

   trace: logical: should iteration progress be printed? 

_D_e_t_a_i_l_s:

     'theta.md' estimates by equating the deviance to the residual
     degrees of freedom, an analogue of a moment estimator.

     'theta.ml' uses maximum likelihood.

     'theta.mm' calculates the moment estimator of 'theta' by equating
     the Pearson chi-square sum((y-mu)^2/(mu+mu^2/theta)) to the
     residual degrees of freedom.

_V_a_l_u_e:

     The required estimate of 'theta', as a scalar. For 'theta.ml', the
     standard error is given as attribute '"SE"'.

_S_e_e _A_l_s_o:

     'glm.nb'

_E_x_a_m_p_l_e_s:

     quine.nb <- glm.nb(Days ~ .^2, data = quine)
     theta.md(quine$Days, fitted(quine.nb), dfr = df.residual(quine.nb))
     theta.ml(quine$Days, fitted(quine.nb))
     theta.mm(quine$Days, fitted(quine.nb), dfr = df.residual(quine.nb))

     ## weighted example
     yeast <- data.frame(cbind(numbers = 0:5, fr = c(213, 128, 37, 18, 3, 1)))
     fit <- glm.nb(numbers ~ 1, weights = fr, data = yeast)
     summary(fit)
     attach(yeast)
     mu <- fitted(fit)
     theta.md(numbers, mu, dfr = 399, weights = fr)
     theta.ml(numbers, mu, weights = fr)
     theta.mm(numbers, mu, dfr = 399, weights = fr)
     detach()

