/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.pad.EllipseCell;
import org.jgraph.pad.GPConverter;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.actions.AbstractActionFile;
import org.jgraph.pad.resources.Translator;

public class FileExportImageMap
extends AbstractActionFile {
    public FileExportImageMap(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public String getURL(GPGraph gPGraph, Object object) {
        Object object2;
        Object object3;
        if (object instanceof DefaultGraphCell && (object3 = ((DefaultGraphCell)object).getUserObject()) instanceof GPUserObject && (object2 = ((GPUserObject)object3).getProperty(GPUserObject.keyURI)) != null) {
            return object2.toString();
        }
        return object.toString();
    }

    public String getLabel(GPGraph gPGraph, Object object) {
        return gPGraph.convertValueToString(object.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                if (this.getCurrentDocument().getModel().getRootCount() <= 0) break block7;
                String string = "jpg";
                String string2 = this.saveDialog(string.toUpperCase() + " Image " + Translator.getString("FileSaveAsLabel"), string.toLowerCase(), string.toUpperCase() + " Image");
                if (string2 == null) {
                    return;
                }
                BufferedImage bufferedImage = null;
                bufferedImage = GPConverter.toImage(this.getCurrentGraph());
                ImageIO.write((RenderedImage)bufferedImage, string.toLowerCase(), new File(string2));
                if (bufferedImage != null) {
                    string = "html";
                    String string3 = this.saveDialog(string.toUpperCase() + " File " + Translator.getString("FileSaveAsLabel"), string.toLowerCase(), string.toUpperCase() + " File");
                    if (string3 == null) {
                        return;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string3);
                    String string4 = "<img src=\"" + string2 + "\" width=\"" + bufferedImage.getWidth() + "\" height=\"" + bufferedImage.getHeight() + "\" border=\"0\" ismap usemap=\"#map\">\n";
                    fileOutputStream.write(string4.getBytes());
                    fileOutputStream.write("<map NAME=\"map\">\n".getBytes());
                    GPGraph gPGraph = super.getCurrentGraph();
                    Rectangle rectangle = gPGraph.getCellBounds(gPGraph.getRoots());
                    Object[] objectArray = gPGraph.getVertices(gPGraph.getAll());
                    int n = 0;
                    while (n < objectArray.length) {
                        String string5 = this.getLabel(gPGraph, objectArray[n]);
                        String string6 = this.getURL(gPGraph, objectArray[n]);
                        CellView cellView = gPGraph.getGraphLayoutCache().getMapping(objectArray[n], false);
                        if (cellView != null && string6 != null) {
                            Rectangle rectangle2 = gPGraph.toScreen(new Rectangle(cellView.getBounds()));
                            rectangle2.translate(-rectangle.x + 5, -rectangle.y + 5);
                            String string7 = rectangle2.x + "," + rectangle2.y + "," + (rectangle2.x + rectangle2.width) + "," + (rectangle2.y + rectangle2.height);
                            String string8 = objectArray[n] instanceof EllipseCell ? "circle" : "rect";
                            String string9 = "<area shape=" + string8 + " coords=\"" + string7 + "\" href=\"" + string6 + "\" alt=\"" + string5 + "\">\n";
                            fileOutputStream.write(string9.getBytes());
                        }
                        ++n;
                    }
                    fileOutputStream.write("</map>".getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                this.graphpad.error(iOException.getMessage());
            }
        }
    }
}

