/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFCharStream;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFOutputStream;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFStreamException;
import de.tu_darmstadt.sp.paul.StreamFilterFactory;
import de.tu_darmstadt.sp.util.VerbatimOutputStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PDFInputStream
extends PDFStream {
    private PDFCharStream inFile;
    private long filePointer;
    byte[] content;

    PDFInputStream(PDFDictionary dict, PDFCharStream inFile) {
        this.dictionary = dict;
        this.inFile = inFile;
        this.filePointer = inFile.getFilePointer();
    }

    public PDFInputStream(PDFInputStream source, List filters) {
        this(source, filters, null);
    }

    public PDFInputStream(PDFInputStream source, List filters, List params) {
        this(new PDFOutputStream(source, filters, params));
    }

    public PDFInputStream(PDFOutputStream source) {
        this.dictionary = (PDFDictionary)source.dictionary.clone();
        if (source.contentStream == null) {
            throw new PDFStreamException("can't create from empty source");
        }
        source.closeOutputStream();
        byte[] othercontent = source.contentStream.toByteArray();
        int len = source.contentStream.size();
        this.content = new byte[len];
        System.arraycopy(othercontent, 0, this.content, 0, len);
        this.dictionary.put(PDFName.LENGTH, (PDFObject)PDFInteger.forInt(len));
    }

    public PDFInputStream(byte[] content) {
        this.dictionary = new PDFDictionary();
        this.dictionary.put(PDFName.LENGTH, (PDFObject)PDFInteger.forInt(content.length));
        this.content = content;
    }

    public void changeFilters(List filters, List parms) throws PDFStreamException {
        PDFOutputStream tmp = new PDFOutputStream(this, filters, parms);
        this.dictionary = tmp.dictionary;
        tmp.closeOutputStream();
        byte[] othercontent = tmp.contentStream.toByteArray();
        int len = tmp.contentStream.size();
        this.content = new byte[len];
        System.arraycopy(othercontent, 0, this.content, 0, len);
        this.dictionary.put(PDFName.LENGTH, (PDFObject)PDFInteger.forInt(len));
    }

    protected boolean deepEquiv(PDFReferenceContainer obj, Map compared) {
        if (obj instanceof PDFOutputStream) {
            return ((PDFOutputStream)obj).deepEquiv(this, compared);
        }
        PDFInputStream sObj = (PDFInputStream)obj;
        this.updateContent();
        sObj.updateContent();
        return this.dictionary.dfsEquiv(sObj.dictionary, compared) && Arrays.equals(this.content, sObj.content);
    }

    public InputStream getInputStream() {
        this.updateContent();
        InputStream in = new ByteArrayInputStream(this.content);
        List filters = this.getFilters();
        List parms = this.getParms();
        int len = filters.size();
        int len2 = parms.size();
        int i = 0;
        while (i < len) {
            in = StreamFilterFactory.createInputFilter(in, (PDFName)filters.get(i), len2 == 0 ? PDFObject.NULL : (PDFObject)parms.get(i));
            ++i;
        }
        return in;
    }

    private void readContent() {
        int length = this.getLength();
        this.content = new byte[length];
        try {
            this.inFile.seek(this.filePointer);
            this.inFile.readFully(this.content);
        }
        catch (IOException iOException) {
            throw new PDFStreamException("could not read stream content from input");
        }
    }

    private void updateContent() {
        if (this.content == null) {
            if (this.inFile != null) {
                this.readContent();
            } else {
                throw new PDFStreamException("no input stream data");
            }
        }
    }

    public void write(Writer out) throws IOException {
        this.updateContent();
        this.dictionary.write(out);
        out.write("\nstream\n");
        if (out instanceof VerbatimOutputStreamWriter) {
            ((VerbatimOutputStreamWriter)out).write(this.content);
        } else {
            int i = 0;
            while (i < this.content.length) {
                out.write(this.content[i]);
                ++i;
            }
        }
        out.write("endstream");
    }
}

