require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&IWN_TX_RING_COUNT)) {
    sub IWN_TX_RING_COUNT () {	256;}
}
unless(defined(&IWN_RX_RING_COUNT)) {
    sub IWN_RX_RING_COUNT () {	64;}
}
unless(defined(&IWN_NTXQUEUES)) {
    sub IWN_NTXQUEUES () {	16;}
}
unless(defined(&IWN_NTXCHAINS)) {
    sub IWN_NTXCHAINS () {	2;}
}
unless(defined(&IWN_RING_DMA_ALIGN)) {
    sub IWN_RING_DMA_ALIGN () {	256;}
}
unless(defined(&IWN_MAX_SCATTER)) {
    sub IWN_MAX_SCATTER () {	20;}
}
unless(defined(&IWN_RBUF_SIZE)) {
    sub IWN_RBUF_SIZE () {	(4* 1024);}
}
unless(defined(&IWN_HWCONFIG)) {
    sub IWN_HWCONFIG () {	0x;}
}
unless(defined(&IWN_INTR_MIT)) {
    sub IWN_INTR_MIT () {	0x4;}
}
unless(defined(&IWN_INTR)) {
    sub IWN_INTR () {	0x8;}
}
unless(defined(&IWN_MASK)) {
    sub IWN_MASK () {	0xc;}
}
unless(defined(&IWN_INTR_STATUS)) {
    sub IWN_INTR_STATUS () {	0x10;}
}
unless(defined(&IWN_RESET)) {
    sub IWN_RESET () {	0x20;}
}
unless(defined(&IWN_GPIO_CTL)) {
    sub IWN_GPIO_CTL () {	0x24;}
}
unless(defined(&IWN_EEPROM_CTL)) {
    sub IWN_EEPROM_CTL () {	0x2c;}
}
unless(defined(&IWN_UCODE_CLR)) {
    sub IWN_UCODE_CLR () {	0x5c;}
}
unless(defined(&IWN_CHICKEN)) {
    sub IWN_CHICKEN () {	0x100;}
}
unless(defined(&IWN_QUEUE_OFFSET)) {
    sub IWN_QUEUE_OFFSET {
	my($qid) = @_;
	eval q((0x380 + ($qid) * 8));
    }
}
unless(defined(&IWN_MEM_WADDR)) {
    sub IWN_MEM_WADDR () {	0x410;}
}
unless(defined(&IWN_MEM_WDATA)) {
    sub IWN_MEM_WDATA () {	0x418;}
}
unless(defined(&IWN_WRITE_MEM_ADDR)) {
    sub IWN_WRITE_MEM_ADDR () {	0x444;}
}
unless(defined(&IWN_READ_MEM_ADDR)) {
    sub IWN_READ_MEM_ADDR () {	0x448;}
}
unless(defined(&IWN_WRITE_MEM_DATA)) {
    sub IWN_WRITE_MEM_DATA () {	0x44c;}
}
unless(defined(&IWN_READ_MEM_DATA)) {
    sub IWN_READ_MEM_DATA () {	0x450;}
}
unless(defined(&IWN_TX_WIDX)) {
    sub IWN_TX_WIDX () {	0x460;}
}
unless(defined(&IWN_KW_BASE)) {
    sub IWN_KW_BASE () {	0x197c;}
}
unless(defined(&IWN_TX_BASE)) {
    sub IWN_TX_BASE {
	my($qid) = @_;
	eval q((0x19d0 + ($qid) * 4));
    }
}
unless(defined(&IWN_RW_WIDX_PTR)) {
    sub IWN_RW_WIDX_PTR () {	0x1bc0;}
}
unless(defined(&IWN_RX_BASE)) {
    sub IWN_RX_BASE () {	0x1bc4;}
}
unless(defined(&IWN_RX_WIDX)) {
    sub IWN_RX_WIDX () {	0x1bc8;}
}
unless(defined(&IWN_RX_CONFIG)) {
    sub IWN_RX_CONFIG () {	0x1c00;}
}
unless(defined(&IWN_RX_STATUS)) {
    sub IWN_RX_STATUS () {	0x1c44;}
}
unless(defined(&IWN_TX_CONFIG)) {
    sub IWN_TX_CONFIG {
	my($qid) = @_;
	eval q((0x1d00 + ($qid) * 32));
    }
}
unless(defined(&IWN_TX_STATUS)) {
    sub IWN_TX_STATUS () {	0x1eb0;}
}
unless(defined(&IWN_SRAM_BASE)) {
    sub IWN_SRAM_BASE () {	0xa02c00;}
}
unless(defined(&IWN_TX_ACTIVE)) {
    sub IWN_TX_ACTIVE () {	( &IWN_SRAM_BASE + 0x1c);}
}
unless(defined(&IWN_QUEUE_RIDX)) {
    sub IWN_QUEUE_RIDX {
	my($qid) = @_;
	eval q(( &IWN_SRAM_BASE + 0x64 + ($qid) * 4));
    }
}
unless(defined(&IWN_SELECT_QCHAIN)) {
    sub IWN_SELECT_QCHAIN () {	( &IWN_SRAM_BASE + 0xd0);}
}
unless(defined(&IWN_QUEUE_INTR_MASK)) {
    sub IWN_QUEUE_INTR_MASK () {	( &IWN_SRAM_BASE + 0xe4);}
}
unless(defined(&IWN_TXQ_STATUS)) {
    sub IWN_TXQ_STATUS {
	my($qid) = @_;
	eval q(( &IWN_SRAM_BASE + 0x104 + ($qid) * 4));
    }
}
unless(defined(&IWN_CLOCK_CTL)) {
    sub IWN_CLOCK_CTL () {	0x3000;}
}
unless(defined(&IWN_MEM_CLOCK2)) {
    sub IWN_MEM_CLOCK2 () {	0x3008;}
}
unless(defined(&IWN_MEM_POWER)) {
    sub IWN_MEM_POWER () {	0x300c;}
}
unless(defined(&IWN_MEM_PCIDEV)) {
    sub IWN_MEM_PCIDEV () {	0x3010;}
}
unless(defined(&IWN_MEM_UCODE_CTL)) {
    sub IWN_MEM_UCODE_CTL () {	0x3400;}
}
unless(defined(&IWN_MEM_UCODE_SRC)) {
    sub IWN_MEM_UCODE_SRC () {	0x3404;}
}
unless(defined(&IWN_MEM_UCODE_DST)) {
    sub IWN_MEM_UCODE_DST () {	0x3408;}
}
unless(defined(&IWN_MEM_UCODE_SIZE)) {
    sub IWN_MEM_UCODE_SIZE () {	0x340c;}
}
unless(defined(&IWN_MEM_TEXT_BASE)) {
    sub IWN_MEM_TEXT_BASE () {	0x3490;}
}
unless(defined(&IWN_MEM_TEXT_SIZE)) {
    sub IWN_MEM_TEXT_SIZE () {	0x3494;}
}
unless(defined(&IWN_MEM_DATA_BASE)) {
    sub IWN_MEM_DATA_BASE () {	0x3498;}
}
unless(defined(&IWN_MEM_DATA_SIZE)) {
    sub IWN_MEM_DATA_SIZE () {	0x349c;}
}
unless(defined(&IWN_MEM_UCODE_BASE)) {
    sub IWN_MEM_UCODE_BASE () {	0x3800;}
}
unless(defined(&IWN_HW_EEPROM_LOCKED)) {
    sub IWN_HW_EEPROM_LOCKED () {	(1<< 21);}
}
unless(defined(&IWN_MEM_4)) {
    sub IWN_MEM_4 () {	(($sizeof{ &uint32_t} - 1) << 24);}
}
unless(defined(&IWN_FW_TEXT)) {
    sub IWN_FW_TEXT () {	0x;}
}
unless(defined(&IWN_NEVO_RESET)) {
    sub IWN_NEVO_RESET () {	(1<< 0);}
}
unless(defined(&IWN_SW_RESET)) {
    sub IWN_SW_RESET () {	(1<< 7);}
}
unless(defined(&IWN_MASTER_DISABLED)) {
    sub IWN_MASTER_DISABLED () {	(1<< 8);}
}
unless(defined(&IWN_STOP_MASTER)) {
    sub IWN_STOP_MASTER () {	(1<< 9);}
}
unless(defined(&IWN_GPIO_CLOCK)) {
    sub IWN_GPIO_CLOCK () {	(1<< 0);}
}
unless(defined(&IWN_GPIO_INIT)) {
    sub IWN_GPIO_INIT () {	(1<< 2);}
}
unless(defined(&IWN_GPIO_MAC)) {
    sub IWN_GPIO_MAC () {	(1<< 3);}
}
unless(defined(&IWN_GPIO_SLEEP)) {
    sub IWN_GPIO_SLEEP () {	(1<< 4);}
}
unless(defined(&IWN_GPIO_PWR_STATUS)) {
    sub IWN_GPIO_PWR_STATUS () {	0x7000000;}
}
unless(defined(&IWN_GPIO_PWR_SLEEP)) {
    sub IWN_GPIO_PWR_SLEEP () {	(4<< 24);}
}
unless(defined(&IWN_GPIO_RF_ENABLED)) {
    sub IWN_GPIO_RF_ENABLED () {	(1<< 27);}
}
unless(defined(&IWN_CHICKEN_DISLOS)) {
    sub IWN_CHICKEN_DISLOS () {	(1<< 29);}
}
unless(defined(&IWN_RADIO_OFF)) {
    sub IWN_RADIO_OFF () {	(1<< 1);}
}
unless(defined(&IWN_DISABLE_CMD)) {
    sub IWN_DISABLE_CMD () {	(1<< 2);}
}
unless(defined(&IWN_CTEMP_STOP_RF)) {
    sub IWN_CTEMP_STOP_RF () {	(1<< 3);}
}
unless(defined(&IWN_RX_IDLE)) {
    sub IWN_RX_IDLE () {	(1<< 24);}
}
unless(defined(&IWN_UC_ENABLE)) {
    sub IWN_UC_ENABLE () {	(1<< 30);}
}
unless(defined(&IWN_UC_RUN)) {
    sub IWN_UC_RUN () {	(1<< 31);}
}
unless(defined(&IWN_ALIVE_INTR)) {
    sub IWN_ALIVE_INTR () {	(1<< 0);}
}
unless(defined(&IWN_WAKEUP_INTR)) {
    sub IWN_WAKEUP_INTR () {	(1<< 1);}
}
unless(defined(&IWN_SW_RX_INTR)) {
    sub IWN_SW_RX_INTR () {	(1<< 3);}
}
unless(defined(&IWN_CT_REACHED)) {
    sub IWN_CT_REACHED () {	(1<< 6);}
}
unless(defined(&IWN_RF_TOGGLED)) {
    sub IWN_RF_TOGGLED () {	(1<< 7);}
}
unless(defined(&IWN_SW_ERROR)) {
    sub IWN_SW_ERROR () {	(1<< 25);}
}
unless(defined(&IWN_TX_INTR)) {
    sub IWN_TX_INTR () {	(1<< 27);}
}
unless(defined(&IWN_HW_ERROR)) {
    sub IWN_HW_ERROR () {	(1<< 29);}
}
unless(defined(&IWN_RX_INTR)) {
    sub IWN_RX_INTR () {	(1<< 31);}
}
unless(defined(&IWN_INTR_MASK)) {
    sub IWN_INTR_MASK () {	( &IWN_SW_ERROR |  &IWN_HW_ERROR |  &IWN_TX_INTR |  &IWN_RX_INTR |  &IWN_ALIVE_INTR |  &IWN_WAKEUP_INTR |  &IWN_SW_RX_INTR |  &IWN_CT_REACHED |  &IWN_RF_TOGGLED);}
}
unless(defined(&IWN_STATUS_TXQ)) {
    sub IWN_STATUS_TXQ {
	my($x) = @_;
	eval q((1<< ($x)));
    }
}
unless(defined(&IWN_STATUS_RXQ)) {
    sub IWN_STATUS_RXQ {
	my($x) = @_;
	eval q((1<< (($x) + 16)));
    }
}
unless(defined(&IWN_STATUS_PRI)) {
    sub IWN_STATUS_PRI () {	(1<< 30);}
}
unless(defined(&IWN_TX_STATUS_INTR)) {
    sub IWN_TX_STATUS_INTR () {	( &IWN_STATUS_TXQ(0) |  &IWN_STATUS_TXQ(1) |  &IWN_STATUS_TXQ(6));}
}
unless(defined(&IWN_RX_STATUS_INTR)) {
    sub IWN_RX_STATUS_INTR () {	( &IWN_STATUS_RXQ(0) |  &IWN_STATUS_RXQ(1) |  &IWN_STATUS_RXQ(2) |  &IWN_STATUS_PRI);}
}
unless(defined(&IWN_TX_IDLE)) {
    sub IWN_TX_IDLE {
	my($qid) = @_;
	eval q((1<< (($qid) + 24) | 1<< (($qid) + 16)));
    }
}
unless(defined(&IWN_EEPROM_READY)) {
    sub IWN_EEPROM_READY () {	(1<< 0);}
}
unless(defined(&IWN_EEPROM_CMD)) {
    sub IWN_EEPROM_CMD () {	(1<< 1);}
}
unless(defined(&IWN_TXQ_STATUS_ACTIVE)) {
    sub IWN_TXQ_STATUS_ACTIVE () {	0x7fc01;}
}
unless(defined(&IWN_POWER_RESET)) {
    sub IWN_POWER_RESET () {	(1<< 26);}
}
unless(defined(&IWN_FW_UPDATED)) {
    sub IWN_FW_UPDATED () {	(1<< 31);}
}
unless(defined(&IWN_DIS_NOSNOOP)) {
    sub IWN_DIS_NOSNOOP () {	(1<< 11);}
}
unless(defined(&IWN_ENA_L1)) {
    sub IWN_ENA_L1 () {	(1<< 1);}
}
unless(defined(&IWN_TX_WINDOW)) {
    sub IWN_TX_WINDOW () {	64;}
}
unless(defined(&IWN_SET_DESC_NSEGS)) {
    sub IWN_SET_DESC_NSEGS {
	my($d, $x) = @_;
	eval q(($d)-> &flags =  &htole32((($x) & 0x1f) << 24));
    }
}
unless(defined(&IWN_SET_DESC_SEG)) {
    sub IWN_SET_DESC_SEG {
	my($d, $n, $addr, $size) = @_;
	eval q( &do {  &if (($n) & 1) { ($d)-> ($segs[(n) / 2]->{w2}) |=  &htole32((($addr) & 0xffff) << 16); ($d)-> ($segs[(n) / 2]->{w3}) =  &htole32(((($addr) >> 16) & 0xffff) | ($size) << 20); }  &else { ($d)-> ($segs[(n) / 2]->{w1}) =  &htole32($addr); ($d)-> ($segs[(n) / 2]->{w2}) =  &htole32(($size) << 4); } }  &while (0));
    }
}
unless(defined(&IWN_UC_READY)) {
    sub IWN_UC_READY () {	1;}
}
unless(defined(&IWN_ADD_NODE_DONE)) {
    sub IWN_ADD_NODE_DONE () {	24;}
}
unless(defined(&IWN_TX_DONE)) {
    sub IWN_TX_DONE () {	28;}
}
unless(defined(&IWN_START_SCAN)) {
    sub IWN_START_SCAN () {	130;}
}
unless(defined(&IWN_STOP_SCAN)) {
    sub IWN_STOP_SCAN () {	132;}
}
unless(defined(&IWN_RX_STATISTICS)) {
    sub IWN_RX_STATISTICS () {	156;}
}
unless(defined(&IWN_BEACON_STATISTICS)) {
    sub IWN_BEACON_STATISTICS () {	157;}
}
unless(defined(&IWN_STATE_CHANGED)) {
    sub IWN_STATE_CHANGED () {	161;}
}
unless(defined(&IWN_BEACON_MISSED)) {
    sub IWN_BEACON_MISSED () {	162;}
}
unless(defined(&IWN_AMPDU_RX_START)) {
    sub IWN_AMPDU_RX_START () {	192;}
}
unless(defined(&IWN_AMPDU_RX_DONE)) {
    sub IWN_AMPDU_RX_DONE () {	193;}
}
unless(defined(&IWN_RX_DONE)) {
    sub IWN_RX_DONE () {	195;}
}
unless(defined(&IWN_RX_NO_CRC_ERR)) {
    sub IWN_RX_NO_CRC_ERR () {	(1<< 0);}
}
unless(defined(&IWN_RX_NO_OVFL_ERR)) {
    sub IWN_RX_NO_OVFL_ERR () {	(1<< 1);}
}
unless(defined(&IWN_RX_NOERROR)) {
    sub IWN_RX_NOERROR () {	( &IWN_RX_NO_CRC_ERR |  &IWN_RX_NO_OVFL_ERR);}
}
unless(defined(&IWN_CMD_CONFIGURE)) {
    sub IWN_CMD_CONFIGURE () {	16;}
}
unless(defined(&IWN_CMD_ASSOCIATE)) {
    sub IWN_CMD_ASSOCIATE () {	17;}
}
unless(defined(&IWN_CMD_EDCA_PARAMS)) {
    sub IWN_CMD_EDCA_PARAMS () {	19;}
}
unless(defined(&IWN_CMD_TSF)) {
    sub IWN_CMD_TSF () {	20;}
}
unless(defined(&IWN_CMD_ADD_NODE)) {
    sub IWN_CMD_ADD_NODE () {	24;}
}
unless(defined(&IWN_CMD_TX_DATA)) {
    sub IWN_CMD_TX_DATA () {	28;}
}
unless(defined(&IWN_CMD_NODE_MRR_SETUP)) {
    sub IWN_CMD_NODE_MRR_SETUP () {	78;}
}
unless(defined(&IWN_CMD_SET_LED)) {
    sub IWN_CMD_SET_LED () {	72;}
}
unless(defined(&IWN_CMD_SET_POWER_MODE)) {
    sub IWN_CMD_SET_POWER_MODE () {	119;}
}
unless(defined(&IWN_CMD_SCAN)) {
    sub IWN_CMD_SCAN () {	128;}
}
unless(defined(&IWN_CMD_TXPOWER)) {
    sub IWN_CMD_TXPOWER () {	151;}
}
unless(defined(&IWN_CMD_BLUETOOTH)) {
    sub IWN_CMD_BLUETOOTH () {	155;}
}
unless(defined(&IWN_CMD_GET_STATISTICS)) {
    sub IWN_CMD_GET_STATISTICS () {	156;}
}
unless(defined(&IWN_CMD_SET_CRITICAL_TEMP)) {
    sub IWN_CMD_SET_CRITICAL_TEMP () {	164;}
}
unless(defined(&IWN_SENSITIVITY)) {
    sub IWN_SENSITIVITY () {	168;}
}
unless(defined(&IWN_PHY_CALIB)) {
    sub IWN_PHY_CALIB () {	176;}
}
unless(defined(&IWN_MODE_HOSTAP)) {
    sub IWN_MODE_HOSTAP () {	1;}
}
unless(defined(&IWN_MODE_STA)) {
    sub IWN_MODE_STA () {	3;}
}
unless(defined(&IWN_MODE_IBSS)) {
    sub IWN_MODE_IBSS () {	4;}
}
unless(defined(&IWN_MODE_MONITOR)) {
    sub IWN_MODE_MONITOR () {	6;}
}
unless(defined(&IWN_RXCHAIN_ANTMSK_SHIFT)) {
    sub IWN_RXCHAIN_ANTMSK_SHIFT () {	1;}
}
unless(defined(&IWN_RXCHAIN_FORCE_MIMO)) {
    sub IWN_RXCHAIN_FORCE_MIMO () {	(1<< 14);}
}
unless(defined(&IWN_CONFIG_24GHZ)) {
    sub IWN_CONFIG_24GHZ () {	(1<< 0);}
}
unless(defined(&IWN_CONFIG_CCK)) {
    sub IWN_CONFIG_CCK () {	(1<< 1);}
}
unless(defined(&IWN_CONFIG_AUTO)) {
    sub IWN_CONFIG_AUTO () {	(1<< 2);}
}
unless(defined(&IWN_CONFIG_SHSLOT)) {
    sub IWN_CONFIG_SHSLOT () {	(1<< 4);}
}
unless(defined(&IWN_CONFIG_SHPREAMBLE)) {
    sub IWN_CONFIG_SHPREAMBLE () {	(1<< 5);}
}
unless(defined(&IWN_CONFIG_NODIVERSITY)) {
    sub IWN_CONFIG_NODIVERSITY () {	(1<< 7);}
}
unless(defined(&IWN_CONFIG_ANTENNA_A)) {
    sub IWN_CONFIG_ANTENNA_A () {	(1<< 8);}
}
unless(defined(&IWN_CONFIG_ANTENNA_B)) {
    sub IWN_CONFIG_ANTENNA_B () {	(1<< 9);}
}
unless(defined(&IWN_CONFIG_TSF)) {
    sub IWN_CONFIG_TSF () {	(1<< 15);}
}
unless(defined(&IWN_FILTER_PROMISC)) {
    sub IWN_FILTER_PROMISC () {	(1<< 0);}
}
unless(defined(&IWN_FILTER_CTL)) {
    sub IWN_FILTER_CTL () {	(1<< 1);}
}
unless(defined(&IWN_FILTER_MULTICAST)) {
    sub IWN_FILTER_MULTICAST () {	(1<< 2);}
}
unless(defined(&IWN_FILTER_NODECRYPT)) {
    sub IWN_FILTER_NODECRYPT () {	(1<< 3);}
}
unless(defined(&IWN_FILTER_BSS)) {
    sub IWN_FILTER_BSS () {	(1<< 5);}
}
unless(defined(&IWN_EDCA_UPDATE)) {
    sub IWN_EDCA_UPDATE () {	(1<< 0);}
}
unless(defined(&IWN_EDCA_TXOP)) {
    sub IWN_EDCA_TXOP () {	(1<< 4);}
}
unless(defined(&IWN_NODE_UPDATE)) {
    sub IWN_NODE_UPDATE () {	(1<< 0);}
}
unless(defined(&IWN_ID_BSS)) {
    sub IWN_ID_BSS () {	0;}
}
unless(defined(&IWN_ID_BROADCAST)) {
    sub IWN_ID_BROADCAST () {	31;}
}
unless(defined(&IWN_FLAG_SET_KEY)) {
    sub IWN_FLAG_SET_KEY () {	(1<< 0);}
}
unless(defined(&IWN_AMDPU_SIZE_FACTOR_SHIFT)) {
    sub IWN_AMDPU_SIZE_FACTOR_SHIFT () {	19;}
}
unless(defined(&IWN_AMDPU_DENSITY_SHIFT)) {
    sub IWN_AMDPU_DENSITY_SHIFT () {	23;}
}
unless(defined(&IWN_RFLAG_CCK)) {
    sub IWN_RFLAG_CCK () {	(1<< 1);}
}
unless(defined(&IWN_RFLAG_ANT_A)) {
    sub IWN_RFLAG_ANT_A () {	(1<< 6);}
}
unless(defined(&IWN_RFLAG_ANT_B)) {
    sub IWN_RFLAG_ANT_B () {	(1<< 7);}
}
unless(defined(&IWN_TX_NEED_RTS)) {
    sub IWN_TX_NEED_RTS () {	(1<< 1);}
}
unless(defined(&IWN_TX_NEED_CTS)) {
    sub IWN_TX_NEED_CTS () {	(1<< 2);}
}
unless(defined(&IWN_TX_NEED_ACK)) {
    sub IWN_TX_NEED_ACK () {	(1<< 3);}
}
unless(defined(&IWN_TX_USE_NODE_RATE)) {
    sub IWN_TX_USE_NODE_RATE () {	(1<< 4);}
}
unless(defined(&IWN_TX_FULL_TXOP)) {
    sub IWN_TX_FULL_TXOP () {	(1<< 7);}
}
unless(defined(&IWN_TX_BT_DISABLE)) {
    sub IWN_TX_BT_DISABLE () {	(1<< 12);}
}
unless(defined(&IWN_TX_AUTO_SEQ)) {
    sub IWN_TX_AUTO_SEQ () {	(1<< 13);}
}
unless(defined(&IWN_TX_INSERT_TSTAMP)) {
    sub IWN_TX_INSERT_TSTAMP () {	(1<< 16);}
}
unless(defined(&IWN_TX_NEED_PADDING)) {
    sub IWN_TX_NEED_PADDING () {	(1<< 20);}
}
unless(defined(&IWN_CIPHER_WEP40)) {
    sub IWN_CIPHER_WEP40 () {	1;}
}
unless(defined(&IWN_CIPHER_CCMP)) {
    sub IWN_CIPHER_CCMP () {	2;}
}
unless(defined(&IWN_CIPHER_TKIP)) {
    sub IWN_CIPHER_TKIP () {	3;}
}
unless(defined(&IWN_CIPHER_WEP104)) {
    sub IWN_CIPHER_WEP104 () {	9;}
}
unless(defined(&IWN_LIFETIME_INFINITE)) {
    sub IWN_LIFETIME_INFINITE () {	0xffffffff;}
}
unless(defined(&IWN_MAX_TX_RETRIES)) {
    sub IWN_MAX_TX_RETRIES () {	16;}
}
unless(defined(&IWN_CCK1)) {
    sub IWN_CCK1 () {	0;}
}
unless(defined(&IWN_CCK11)) {
    sub IWN_CCK11 () {	3;}
}
unless(defined(&IWN_OFDM6)) {
    sub IWN_OFDM6 () {	4;}
}
unless(defined(&IWN_OFDM54)) {
    sub IWN_OFDM54 () {	11;}
}
unless(defined(&IWN_LED_ACTIVITY)) {
    sub IWN_LED_ACTIVITY () {	1;}
}
unless(defined(&IWN_LED_LINK)) {
    sub IWN_LED_LINK () {	2;}
}
unless(defined(&IWN_POWER_CAM)) {
    sub IWN_POWER_CAM () {	0;}
}
unless(defined(&IWN_CHAN_ACTIVE)) {
    sub IWN_CHAN_ACTIVE () {	(1<< 0);}
}
unless(defined(&IWN_CHAN_DIRECT)) {
    sub IWN_CHAN_DIRECT () {	(1<< 1);}
}
unless(defined(&IWN_RIDX_MAX)) {
    sub IWN_RIDX_MAX () {	32;}
}
unless(defined(&IWN_CTOK)) {
    sub IWN_CTOK {
	my($c) = @_;
	eval q((($c) + 273));
    }
}
unless(defined(&IWN_KTOC)) {
    sub IWN_KTOC {
	my($k) = @_;
	eval q((($k) - 273));
    }
}
unless(defined(&IWN_CTOMUK)) {
    sub IWN_CTOMUK {
	my($c) = @_;
	eval q(((($c) * 1000000) + 273150000));
    }
}
unless(defined(&IWN_SENSITIVITY_DEFAULTTBL)) {
    sub IWN_SENSITIVITY_DEFAULTTBL () {	0;}
}
unless(defined(&IWN_SENSITIVITY_WORKTBL)) {
    sub IWN_SENSITIVITY_WORKTBL () {	1;}
}
unless(defined(&IWN_SET_DIFF_GAIN)) {
    sub IWN_SET_DIFF_GAIN () {	7;}
}
unless(defined(&IWN_GAIN_SET)) {
    sub IWN_GAIN_SET () {	(1<< 2);}
}
unless(defined(&IWN_NATTEN_GROUPS)) {
    sub IWN_NATTEN_GROUPS () {	5;}
}
unless(defined(&IWN_UCODE_RUNTIME)) {
    sub IWN_UCODE_RUNTIME () {	0;}
}
unless(defined(&IWN_UCODE_INIT)) {
    sub IWN_UCODE_INIT () {	9;}
}
unless(defined(&IWN_STAT_MAXLEN)) {
    sub IWN_STAT_MAXLEN () {	20;}
}
unless(defined(&IWN_RSSI_TO_DBM)) {
    sub IWN_RSSI_TO_DBM () {	44;}
}
unless(defined(&IWN_FW_MAIN_TEXT_MAXSZ)) {
    sub IWN_FW_MAIN_TEXT_MAXSZ () {	(96* 1024);}
}
unless(defined(&IWN_FW_MAIN_DATA_MAXSZ)) {
    sub IWN_FW_MAIN_DATA_MAXSZ () {	(40* 1024);}
}
unless(defined(&IWN_FW_INIT_TEXT_MAXSZ)) {
    sub IWN_FW_INIT_TEXT_MAXSZ () {	(96* 1024);}
}
unless(defined(&IWN_FW_INIT_DATA_MAXSZ)) {
    sub IWN_FW_INIT_DATA_MAXSZ () {	(40* 1024);}
}
unless(defined(&IWN_FW_BOOT_TEXT_MAXSZ)) {
    sub IWN_FW_BOOT_TEXT_MAXSZ () {	1024;}
}
unless(defined(&IWN_EEPROM_MAC)) {
    sub IWN_EEPROM_MAC () {	0x15;}
}
unless(defined(&IWN_EEPROM_DOMAIN)) {
    sub IWN_EEPROM_DOMAIN () {	0x60;}
}
unless(defined(&IWN_EEPROM_BAND1)) {
    sub IWN_EEPROM_BAND1 () {	0x63;}
}
unless(defined(&IWN_EEPROM_BAND2)) {
    sub IWN_EEPROM_BAND2 () {	0x72;}
}
unless(defined(&IWN_EEPROM_BAND3)) {
    sub IWN_EEPROM_BAND3 () {	0x80;}
}
unless(defined(&IWN_EEPROM_BAND4)) {
    sub IWN_EEPROM_BAND4 () {	0x8d;}
}
unless(defined(&IWN_EEPROM_BAND5)) {
    sub IWN_EEPROM_BAND5 () {	0x99;}
}
unless(defined(&IWN_EEPROM_BAND6)) {
    sub IWN_EEPROM_BAND6 () {	0xa0;}
}
unless(defined(&IWN_EEPROM_BAND7)) {
    sub IWN_EEPROM_BAND7 () {	0xa8;}
}
unless(defined(&IWN_EEPROM_MAXPOW)) {
    sub IWN_EEPROM_MAXPOW () {	0xe8;}
}
unless(defined(&IWN_EEPROM_VOLTAGE)) {
    sub IWN_EEPROM_VOLTAGE () {	0xe9;}
}
unless(defined(&IWN_EEPROM_BANDS)) {
    sub IWN_EEPROM_BANDS () {	0xea;}
}
unless(defined(&IWN_EEPROM_CHAN_VALID)) {
    sub IWN_EEPROM_CHAN_VALID () {	(1<< 0);}
}
unless(defined(&IWN_EEPROM_CHAN_IBSS)) {
    sub IWN_EEPROM_CHAN_IBSS () {	(1<< 1);}
}
unless(defined(&IWN_EEPROM_CHAN_ACTIVE)) {
    sub IWN_EEPROM_CHAN_ACTIVE () {	(1<< 3);}
}
unless(defined(&IWN_EEPROM_CHAN_RADAR)) {
    sub IWN_EEPROM_CHAN_RADAR () {	(1<< 4);}
}
unless(defined(&IWN_NSAMPLES)) {
    sub IWN_NSAMPLES () {	3;}
}
unless(defined(&IWN_NBANDS)) {
    sub IWN_NBANDS () {	8;}
}
unless(defined(&IWN_CHAN_BANDS_COUNT)) {
    sub IWN_CHAN_BANDS_COUNT () {	7;}
}
unless(defined(&IWN_MAX_CHAN_PER_BAND)) {
    sub IWN_MAX_CHAN_PER_BAND () {	14;}
}
unless(defined(&IWN_MAX_PWR_INDEX)) {
    sub IWN_MAX_PWR_INDEX () {	107;}
}
unless(defined(&IWN_READ)) {
    sub IWN_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&IWN_WRITE)) {
    sub IWN_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&IWN_WRITE_REGION_4)) {
    sub IWN_WRITE_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
1;
