require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_NETBT_HCI_H_)) {
    eval 'sub _NETBT_HCI_H_ () {1;}' unless defined(&_NETBT_HCI_H_);
    require 'netbt/bluetooth.ph';
    require 'sys/mutex.ph';
    eval 'sub HCI_LAP_SIZE () {3;}' unless defined(&HCI_LAP_SIZE);
    eval 'sub HCI_KEY_SIZE () {16;}' unless defined(&HCI_KEY_SIZE);
    eval 'sub HCI_PIN_SIZE () {16;}' unless defined(&HCI_PIN_SIZE);
    eval 'sub HCI_EVENT_MASK_SIZE () {8;}' unless defined(&HCI_EVENT_MASK_SIZE);
    eval 'sub HCI_CLASS_SIZE () {3;}' unless defined(&HCI_CLASS_SIZE);
    eval 'sub HCI_FEATURES_SIZE () {8;}' unless defined(&HCI_FEATURES_SIZE);
    eval 'sub HCI_UNIT_NAME_SIZE () {248;}' unless defined(&HCI_UNIT_NAME_SIZE);
    eval 'sub HCI_DEVNAME_SIZE () {16;}' unless defined(&HCI_DEVNAME_SIZE);
    eval 'sub HCI_COMMANDS_SIZE () {64;}' unless defined(&HCI_COMMANDS_SIZE);
    eval 'sub HCI_SPEC_V10 () {0x;}' unless defined(&HCI_SPEC_V10);
    eval 'sub HCI_SPEC_V11 () {0x1;}' unless defined(&HCI_SPEC_V11);
    eval 'sub HCI_SPEC_V12 () {0x2;}' unless defined(&HCI_SPEC_V12);
    eval 'sub HCI_SPEC_V20 () {0x3;}' unless defined(&HCI_SPEC_V20);
    eval 'sub HCI_SPEC_V21 () {0x4;}' unless defined(&HCI_SPEC_V21);
    eval 'sub HCI_LMP_3SLOT () {0x1;}' unless defined(&HCI_LMP_3SLOT);
    eval 'sub HCI_LMP_5SLOT () {0x2;}' unless defined(&HCI_LMP_5SLOT);
    eval 'sub HCI_LMP_ENCRYPTION () {0x4;}' unless defined(&HCI_LMP_ENCRYPTION);
    eval 'sub HCI_LMP_SLOT_OFFSET () {0x8;}' unless defined(&HCI_LMP_SLOT_OFFSET);
    eval 'sub HCI_LMP_TIMIACCURACY () {0x10;}' unless defined(&HCI_LMP_TIMIACCURACY);
    eval 'sub HCI_LMP_ROLE_SWITCH () {0x20;}' unless defined(&HCI_LMP_ROLE_SWITCH);
    eval 'sub HCI_LMP_HOLD_MODE () {0x40;}' unless defined(&HCI_LMP_HOLD_MODE);
    eval 'sub HCI_LMP_SNIFF_MODE () {0x80;}' unless defined(&HCI_LMP_SNIFF_MODE);
    eval 'sub HCI_LMP_PARK_MODE () {0x1;}' unless defined(&HCI_LMP_PARK_MODE);
    eval 'sub HCI_LMP_RSSI () {0x2;}' unless defined(&HCI_LMP_RSSI);
    eval 'sub HCI_LMP_CHANNEL_QUALITY () {0x4;}' unless defined(&HCI_LMP_CHANNEL_QUALITY);
    eval 'sub HCI_LMP_SCO_LINK () {0x8;}' unless defined(&HCI_LMP_SCO_LINK);
    eval 'sub HCI_LMP_HV2_PKT () {0x10;}' unless defined(&HCI_LMP_HV2_PKT);
    eval 'sub HCI_LMP_HV3_PKT () {0x20;}' unless defined(&HCI_LMP_HV3_PKT);
    eval 'sub HCI_LMP_ULAW_LOG () {0x40;}' unless defined(&HCI_LMP_ULAW_LOG);
    eval 'sub HCI_LMP_ALAW_LOG () {0x80;}' unless defined(&HCI_LMP_ALAW_LOG);
    eval 'sub HCI_LMP_CVSD () {0x1;}' unless defined(&HCI_LMP_CVSD);
    eval 'sub HCI_LMP_PAGISCHEME () {0x2;}' unless defined(&HCI_LMP_PAGISCHEME);
    eval 'sub HCI_LMP_POWER_CONTROL () {0x4;}' unless defined(&HCI_LMP_POWER_CONTROL);
    eval 'sub HCI_LMP_TRANSPARENT_SCO () {0x8;}' unless defined(&HCI_LMP_TRANSPARENT_SCO);
    eval 'sub HCI_LMP_FLOW_CONTROL_LAG0 () {0x10;}' unless defined(&HCI_LMP_FLOW_CONTROL_LAG0);
    eval 'sub HCI_LMP_FLOW_CONTROL_LAG1 () {0x20;}' unless defined(&HCI_LMP_FLOW_CONTROL_LAG1);
    eval 'sub HCI_LMP_FLOW_CONTROL_LAG2 () {0x40;}' unless defined(&HCI_LMP_FLOW_CONTROL_LAG2);
    eval 'sub HCI_LMP_BC_ENCRYPTION () {0x80;}' unless defined(&HCI_LMP_BC_ENCRYPTION);
    eval 'sub HCI_LMP_EDR_ACL_2MBPS () {0x2;}' unless defined(&HCI_LMP_EDR_ACL_2MBPS);
    eval 'sub HCI_LMP_EDR_ACL_3MBPS () {0x4;}' unless defined(&HCI_LMP_EDR_ACL_3MBPS);
    eval 'sub HCI_LMP_ENHANCED_ISCAN () {0x8;}' unless defined(&HCI_LMP_ENHANCED_ISCAN);
    eval 'sub HCI_LMP_INTERLACED_ISCAN () {0x10;}' unless defined(&HCI_LMP_INTERLACED_ISCAN);
    eval 'sub HCI_LMP_INTERLACED_PSCAN () {0x20;}' unless defined(&HCI_LMP_INTERLACED_PSCAN);
    eval 'sub HCI_LMP_RSSI_INQUIRY () {0x40;}' unless defined(&HCI_LMP_RSSI_INQUIRY);
    eval 'sub HCI_LMP_EV3_PKT () {0x80;}' unless defined(&HCI_LMP_EV3_PKT);
    eval 'sub HCI_LMP_EV4_PKT () {0x1;}' unless defined(&HCI_LMP_EV4_PKT);
    eval 'sub HCI_LMP_EV5_PKT () {0x2;}' unless defined(&HCI_LMP_EV5_PKT);
    eval 'sub HCI_LMP_AFH_CAPABLE_SLAVE () {0x8;}' unless defined(&HCI_LMP_AFH_CAPABLE_SLAVE);
    eval 'sub HCI_LMP_AFH_CLASS_SLAVE () {0x10;}' unless defined(&HCI_LMP_AFH_CLASS_SLAVE);
    eval 'sub HCI_LMP_3SLOT_EDR_ACL () {0x80;}' unless defined(&HCI_LMP_3SLOT_EDR_ACL);
    eval 'sub HCI_LMP_5SLOT_EDR_ACL () {0x1;}' unless defined(&HCI_LMP_5SLOT_EDR_ACL);
    eval 'sub HCI_LMP_SNIFF_SUBRATING () {0x2;}' unless defined(&HCI_LMP_SNIFF_SUBRATING);
    eval 'sub HCI_LMP_PAUSE_ENCRYPTION () {0x4;}' unless defined(&HCI_LMP_PAUSE_ENCRYPTION);
    eval 'sub HCI_LMP_AFH_CAPABLE_MASTER () {0x8;}' unless defined(&HCI_LMP_AFH_CAPABLE_MASTER);
    eval 'sub HCI_LMP_AFH_CLASS_MASTER () {0x10;}' unless defined(&HCI_LMP_AFH_CLASS_MASTER);
    eval 'sub HCI_LMP_EDR_eSCO_2MBPS () {0x20;}' unless defined(&HCI_LMP_EDR_eSCO_2MBPS);
    eval 'sub HCI_LMP_EDR_eSCO_3MBPS () {0x40;}' unless defined(&HCI_LMP_EDR_eSCO_3MBPS);
    eval 'sub HCI_LMP_3SLOT_EDR_eSCO () {0x80;}' unless defined(&HCI_LMP_3SLOT_EDR_eSCO);
    eval 'sub HCI_LMP_EXTENDED_INQUIRY () {0x1;}' unless defined(&HCI_LMP_EXTENDED_INQUIRY);
    eval 'sub HCI_LMP_SIMPLE_PAIRING () {0x8;}' unless defined(&HCI_LMP_SIMPLE_PAIRING);
    eval 'sub HCI_LMP_ENCAPSULATED_PDU () {0x10;}' unless defined(&HCI_LMP_ENCAPSULATED_PDU);
    eval 'sub HCI_LMP_ERRDATA_REPORTING () {0x20;}' unless defined(&HCI_LMP_ERRDATA_REPORTING);
    eval 'sub HCI_LMP_NOFLUSH_PB_FLAG () {0x40;}' unless defined(&HCI_LMP_NOFLUSH_PB_FLAG);
    eval 'sub HCI_LMP_LINK_SUPERVISION_TO () {0x1;}' unless defined(&HCI_LMP_LINK_SUPERVISION_TO);
    eval 'sub HCI_LMP_INQ_RSP_TX_POWER () {0x2;}' unless defined(&HCI_LMP_INQ_RSP_TX_POWER);
    eval 'sub HCI_LMP_EXTENDED_FEATURES () {0x80;}' unless defined(&HCI_LMP_EXTENDED_FEATURES);
    eval 'sub HCI_LINK_SCO () {0x;}' unless defined(&HCI_LINK_SCO);
    eval 'sub HCI_LINK_ACL () {0x1;}' unless defined(&HCI_LINK_ACL);
    eval 'sub HCI_LINK_eSCO () {0x2;}' unless defined(&HCI_LINK_eSCO);
    eval 'sub HCI_PKT_2MBPS_DH1 () {0x2;}' unless defined(&HCI_PKT_2MBPS_DH1);
    eval 'sub HCI_PKT_3MBPS_DH1 () {0x4;}' unless defined(&HCI_PKT_3MBPS_DH1);
    eval 'sub HCI_PKT_DM1 () {0x8;}' unless defined(&HCI_PKT_DM1);
    eval 'sub HCI_PKT_DH1 () {0x10;}' unless defined(&HCI_PKT_DH1);
    eval 'sub HCI_PKT_2MBPS_DH3 () {0x100;}' unless defined(&HCI_PKT_2MBPS_DH3);
    eval 'sub HCI_PKT_3MBPS_DH3 () {0x200;}' unless defined(&HCI_PKT_3MBPS_DH3);
    eval 'sub HCI_PKT_DM3 () {0x400;}' unless defined(&HCI_PKT_DM3);
    eval 'sub HCI_PKT_DH3 () {0x800;}' unless defined(&HCI_PKT_DH3);
    eval 'sub HCI_PKT_2MBPS_DH5 () {0x1000;}' unless defined(&HCI_PKT_2MBPS_DH5);
    eval 'sub HCI_PKT_3MBPS_DH5 () {0x2000;}' unless defined(&HCI_PKT_3MBPS_DH5);
    eval 'sub HCI_PKT_DM5 () {0x4000;}' unless defined(&HCI_PKT_DM5);
    eval 'sub HCI_PKT_DH5 () {0x8000;}' unless defined(&HCI_PKT_DH5);
    eval 'sub HCI_PKT_HV1 () {0x1;}' unless defined(&HCI_PKT_HV1);
    eval 'sub HCI_PKT_HV2 () {0x2;}' unless defined(&HCI_PKT_HV2);
    eval 'sub HCI_PKT_HV3 () {0x4;}' unless defined(&HCI_PKT_HV3);
    eval 'sub HCI_PKT_EV3 () {0x8;}' unless defined(&HCI_PKT_EV3);
    eval 'sub HCI_PKT_EV4 () {0x10;}' unless defined(&HCI_PKT_EV4);
    eval 'sub HCI_PKT_EV5 () {0x20;}' unless defined(&HCI_PKT_EV5);
    eval 'sub HCI_PKT_2MBPS_EV3 () {0x40;}' unless defined(&HCI_PKT_2MBPS_EV3);
    eval 'sub HCI_PKT_3MBPS_EV3 () {0x80;}' unless defined(&HCI_PKT_3MBPS_EV3);
    eval 'sub HCI_PKT_2MBPS_EV5 () {0x100;}' unless defined(&HCI_PKT_2MBPS_EV5);
    eval 'sub HCI_PKT_3MBPS_EV5 () {0x200;}' unless defined(&HCI_PKT_3MBPS_EV5);
    eval 'sub HCI_MANDATORY_PAGE_SCAN_MODE () {0x;}' unless defined(&HCI_MANDATORY_PAGE_SCAN_MODE);
    eval 'sub HCI_OPTIONAL_PAGE_SCAN_MODE1 () {0x1;}' unless defined(&HCI_OPTIONAL_PAGE_SCAN_MODE1);
    eval 'sub HCI_OPTIONAL_PAGE_SCAN_MODE2 () {0x2;}' unless defined(&HCI_OPTIONAL_PAGE_SCAN_MODE2);
    eval 'sub HCI_OPTIONAL_PAGE_SCAN_MODE3 () {0x3;}' unless defined(&HCI_OPTIONAL_PAGE_SCAN_MODE3);
    eval 'sub HCI_SCAN_REP_MODE0 () {0x;}' unless defined(&HCI_SCAN_REP_MODE0);
    eval 'sub HCI_SCAN_REP_MODE1 () {0x1;}' unless defined(&HCI_SCAN_REP_MODE1);
    eval 'sub HCI_SCAN_REP_MODE2 () {0x2;}' unless defined(&HCI_SCAN_REP_MODE2);
    eval 'sub HCI_PAGE_SCAN_PERIOD_MODE0 () {0x;}' unless defined(&HCI_PAGE_SCAN_PERIOD_MODE0);
    eval 'sub HCI_PAGE_SCAN_PERIOD_MODE1 () {0x1;}' unless defined(&HCI_PAGE_SCAN_PERIOD_MODE1);
    eval 'sub HCI_PAGE_SCAN_PERIOD_MODE2 () {0x2;}' unless defined(&HCI_PAGE_SCAN_PERIOD_MODE2);
    eval 'sub HCI_NO_SCAN_ENABLE () {0x;}' unless defined(&HCI_NO_SCAN_ENABLE);
    eval 'sub HCI_INQUIRY_SCAN_ENABLE () {0x1;}' unless defined(&HCI_INQUIRY_SCAN_ENABLE);
    eval 'sub HCI_PAGE_SCAN_ENABLE () {0x2;}' unless defined(&HCI_PAGE_SCAN_ENABLE);
    eval 'sub HCI_HOLD_MODE_NO_CHANGE () {0x;}' unless defined(&HCI_HOLD_MODE_NO_CHANGE);
    eval 'sub HCI_HOLD_MODE_SUSPEND_PAGE_SCAN () {0x1;}' unless defined(&HCI_HOLD_MODE_SUSPEND_PAGE_SCAN);
    eval 'sub HCI_HOLD_MODE_SUSPEND_INQUIRY_SCAN () {0x2;}' unless defined(&HCI_HOLD_MODE_SUSPEND_INQUIRY_SCAN);
    eval 'sub HCI_HOLD_MODE_SUSPEND_PERIOD_INQUIRY () {0x4;}' unless defined(&HCI_HOLD_MODE_SUSPEND_PERIOD_INQUIRY);
    eval 'sub HCI_ROLE_MASTER () {0x;}' unless defined(&HCI_ROLE_MASTER);
    eval 'sub HCI_ROLE_SLAVE () {0x1;}' unless defined(&HCI_ROLE_SLAVE);
    eval 'sub HCI_USE_SEMI_PERMANENT_LINK_KEYS () {0x;}' unless defined(&HCI_USE_SEMI_PERMANENT_LINK_KEYS);
    eval 'sub HCI_USE_TEMPORARY_LINK_KEY () {0x1;}' unless defined(&HCI_USE_TEMPORARY_LINK_KEY);
    eval 'sub HCI_PIN_TYPE_VARIABLE () {0x;}' unless defined(&HCI_PIN_TYPE_VARIABLE);
    eval 'sub HCI_PIN_TYPE_FIXED () {0x1;}' unless defined(&HCI_PIN_TYPE_FIXED);
    eval 'sub HCI_LINK_KEY_TYPE_COMBINATION_KEY () {0x;}' unless defined(&HCI_LINK_KEY_TYPE_COMBINATION_KEY);
    eval 'sub HCI_LINK_KEY_TYPE_LOCAL_UNIT_KEY () {0x1;}' unless defined(&HCI_LINK_KEY_TYPE_LOCAL_UNIT_KEY);
    eval 'sub HCI_LINK_KEY_TYPE_REMOTE_UNIT_KEY () {0x2;}' unless defined(&HCI_LINK_KEY_TYPE_REMOTE_UNIT_KEY);
    eval 'sub HCI_ENCRYPTION_MODE_NONE () {0x;}' unless defined(&HCI_ENCRYPTION_MODE_NONE);
    eval 'sub HCI_ENCRYPTION_MODE_P2P () {0x1;}' unless defined(&HCI_ENCRYPTION_MODE_P2P);
    eval 'sub HCI_ENCRYPTION_MODE_ALL () {0x2;}' unless defined(&HCI_ENCRYPTION_MODE_ALL);
    eval 'sub HCI_SERVICE_TYPE_NO_TRAFFIC () {0x;}' unless defined(&HCI_SERVICE_TYPE_NO_TRAFFIC);
    eval 'sub HCI_SERVICE_TYPE_BEST_EFFORT () {0x1;}' unless defined(&HCI_SERVICE_TYPE_BEST_EFFORT);
    eval 'sub HCI_SERVICE_TYPE_GUARANTEED () {0x2;}' unless defined(&HCI_SERVICE_TYPE_GUARANTEED);
    eval 'sub HCI_LINK_POLICY_DISABLE_ALL_LM_MODES () {0x;}' unless defined(&HCI_LINK_POLICY_DISABLE_ALL_LM_MODES);
    eval 'sub HCI_LINK_POLICY_ENABLE_ROLE_SWITCH () {0x1;}' unless defined(&HCI_LINK_POLICY_ENABLE_ROLE_SWITCH);
    eval 'sub HCI_LINK_POLICY_ENABLE_HOLD_MODE () {0x2;}' unless defined(&HCI_LINK_POLICY_ENABLE_HOLD_MODE);
    eval 'sub HCI_LINK_POLICY_ENABLE_SNIFF_MODE () {0x4;}' unless defined(&HCI_LINK_POLICY_ENABLE_SNIFF_MODE);
    eval 'sub HCI_LINK_POLICY_ENABLE_PARK_MODE () {0x8;}' unless defined(&HCI_LINK_POLICY_ENABLE_PARK_MODE);
    eval 'sub HCI_EVMSK_ALL () {0xffffffff;}' unless defined(&HCI_EVMSK_ALL);
    eval 'sub HCI_EVMSK_NONE () {0x;}' unless defined(&HCI_EVMSK_NONE);
    eval 'sub HCI_EVMSK_INQUIRY_COMPL () {0x1;}' unless defined(&HCI_EVMSK_INQUIRY_COMPL);
    eval 'sub HCI_EVMSK_INQUIRY_RESULT () {0x2;}' unless defined(&HCI_EVMSK_INQUIRY_RESULT);
    eval 'sub HCI_EVMSK_CON_COMPL () {0x4;}' unless defined(&HCI_EVMSK_CON_COMPL);
    eval 'sub HCI_EVMSK_CON_REQ () {0x8;}' unless defined(&HCI_EVMSK_CON_REQ);
    eval 'sub HCI_EVMSK_DISCON_COMPL () {0x10;}' unless defined(&HCI_EVMSK_DISCON_COMPL);
    eval 'sub HCI_EVMSK_AUTH_COMPL () {0x20;}' unless defined(&HCI_EVMSK_AUTH_COMPL);
    eval 'sub HCI_EVMSK_REMOTE_NAME_REQ_COMPL () {0x40;}' unless defined(&HCI_EVMSK_REMOTE_NAME_REQ_COMPL);
    eval 'sub HCI_EVMSK_ENCRYPTION_CHANGE () {0x80;}' unless defined(&HCI_EVMSK_ENCRYPTION_CHANGE);
    eval 'sub HCI_EVMSK_CHANGE_CON_LINK_KEY_COMPL () {0x100;}' unless defined(&HCI_EVMSK_CHANGE_CON_LINK_KEY_COMPL);
    eval 'sub HCI_EVMSK_MASTER_LINK_KEY_COMPL () {0x200;}' unless defined(&HCI_EVMSK_MASTER_LINK_KEY_COMPL);
    eval 'sub HCI_EVMSK_READ_REMOTE_FEATURES_COMPL () {0x400;}' unless defined(&HCI_EVMSK_READ_REMOTE_FEATURES_COMPL);
    eval 'sub HCI_EVMSK_READ_REMOTE_VER_INFO_COMPL () {0x800;}' unless defined(&HCI_EVMSK_READ_REMOTE_VER_INFO_COMPL);
    eval 'sub HCI_EVMSK_QOS_SETUP_COMPL () {0x1000;}' unless defined(&HCI_EVMSK_QOS_SETUP_COMPL);
    eval 'sub HCI_EVMSK_COMMAND_COMPL () {0x2000;}' unless defined(&HCI_EVMSK_COMMAND_COMPL);
    eval 'sub HCI_EVMSK_COMMAND_STATUS () {0x4000;}' unless defined(&HCI_EVMSK_COMMAND_STATUS);
    eval 'sub HCI_EVMSK_HARDWARE_ERROR () {0x8000;}' unless defined(&HCI_EVMSK_HARDWARE_ERROR);
    eval 'sub HCI_EVMSK_FLUSH_OCCUR () {0x10000;}' unless defined(&HCI_EVMSK_FLUSH_OCCUR);
    eval 'sub HCI_EVMSK_ROLE_CHANGE () {0x20000;}' unless defined(&HCI_EVMSK_ROLE_CHANGE);
    eval 'sub HCI_EVMSK_NUM_COMPL_PKTS () {0x40000;}' unless defined(&HCI_EVMSK_NUM_COMPL_PKTS);
    eval 'sub HCI_EVMSK_MODE_CHANGE () {0x80000;}' unless defined(&HCI_EVMSK_MODE_CHANGE);
    eval 'sub HCI_EVMSK_RETURN_LINK_KEYS () {0x100000;}' unless defined(&HCI_EVMSK_RETURN_LINK_KEYS);
    eval 'sub HCI_EVMSK_PIN_CODE_REQ () {0x200000;}' unless defined(&HCI_EVMSK_PIN_CODE_REQ);
    eval 'sub HCI_EVMSK_LINK_KEY_REQ () {0x400000;}' unless defined(&HCI_EVMSK_LINK_KEY_REQ);
    eval 'sub HCI_EVMSK_LINK_KEY_NOTIFICATION () {0x800000;}' unless defined(&HCI_EVMSK_LINK_KEY_NOTIFICATION);
    eval 'sub HCI_EVMSK_LOOPBACK_COMMAND () {0x1000000;}' unless defined(&HCI_EVMSK_LOOPBACK_COMMAND);
    eval 'sub HCI_EVMSK_DATA_BUFFER_OVERFLOW () {0x2000000;}' unless defined(&HCI_EVMSK_DATA_BUFFER_OVERFLOW);
    eval 'sub HCI_EVMSK_MAX_SLOT_CHANGE () {0x4000000;}' unless defined(&HCI_EVMSK_MAX_SLOT_CHANGE);
    eval 'sub HCI_EVMSK_READ_CLOCK_OFFSET_COMLETE () {0x8000000;}' unless defined(&HCI_EVMSK_READ_CLOCK_OFFSET_COMLETE);
    eval 'sub HCI_EVMSK_CON_PKT_TYPE_CHANGED () {0x10000000;}' unless defined(&HCI_EVMSK_CON_PKT_TYPE_CHANGED);
    eval 'sub HCI_EVMSK_QOS_VIOLATION () {0x20000000;}' unless defined(&HCI_EVMSK_QOS_VIOLATION);
    eval 'sub HCI_EVMSK_PAGE_SCAN_MODE_CHANGE () {0x40000000;}' unless defined(&HCI_EVMSK_PAGE_SCAN_MODE_CHANGE);
    eval 'sub HCI_EVMSK_PAGE_SCAN_REP_MODE_CHANGE () {0x80000000;}' unless defined(&HCI_EVMSK_PAGE_SCAN_REP_MODE_CHANGE);
    eval 'sub HCI_FILTER_TYPE_NONE () {0x;}' unless defined(&HCI_FILTER_TYPE_NONE);
    eval 'sub HCI_FILTER_TYPE_INQUIRY_RESULT () {0x1;}' unless defined(&HCI_FILTER_TYPE_INQUIRY_RESULT);
    eval 'sub HCI_FILTER_TYPE_CON_SETUP () {0x2;}' unless defined(&HCI_FILTER_TYPE_CON_SETUP);
    eval 'sub HCI_FILTER_COND_INQUIRY_NEW_UNIT () {0x;}' unless defined(&HCI_FILTER_COND_INQUIRY_NEW_UNIT);
    eval 'sub HCI_FILTER_COND_INQUIRY_UNIT_CLASS () {0x1;}' unless defined(&HCI_FILTER_COND_INQUIRY_UNIT_CLASS);
    eval 'sub HCI_FILTER_COND_INQUIRY_BDADDR () {0x2;}' unless defined(&HCI_FILTER_COND_INQUIRY_BDADDR);
    eval 'sub HCI_FILTER_COND_CON_ANY_UNIT () {0x;}' unless defined(&HCI_FILTER_COND_CON_ANY_UNIT);
    eval 'sub HCI_FILTER_COND_CON_UNIT_CLASS () {0x1;}' unless defined(&HCI_FILTER_COND_CON_UNIT_CLASS);
    eval 'sub HCI_FILTER_COND_CON_BDADDR () {0x2;}' unless defined(&HCI_FILTER_COND_CON_BDADDR);
    eval 'sub HCI_XMIT_LEVEL_CURRENT () {0x;}' unless defined(&HCI_XMIT_LEVEL_CURRENT);
    eval 'sub HCI_XMIT_LEVEL_MAXIMUM () {0x1;}' unless defined(&HCI_XMIT_LEVEL_MAXIMUM);
    eval 'sub HCI_HC2H_FLOW_CONTROL_NONE () {0x;}' unless defined(&HCI_HC2H_FLOW_CONTROL_NONE);
    eval 'sub HCI_HC2H_FLOW_CONTROL_ACL () {0x1;}' unless defined(&HCI_HC2H_FLOW_CONTROL_ACL);
    eval 'sub HCI_HC2H_FLOW_CONTROL_SCO () {0x2;}' unless defined(&HCI_HC2H_FLOW_CONTROL_SCO);
    eval 'sub HCI_HC2H_FLOW_CONTROL_BOTH () {0x3;}' unless defined(&HCI_HC2H_FLOW_CONTROL_BOTH);
    eval 'sub HCI_LOOPBACK_NONE () {0x;}' unless defined(&HCI_LOOPBACK_NONE);
    eval 'sub HCI_LOOPBACK_LOCAL () {0x1;}' unless defined(&HCI_LOOPBACK_LOCAL);
    eval 'sub HCI_LOOPBACK_REMOTE () {0x2;}' unless defined(&HCI_LOOPBACK_REMOTE);
    eval 'sub HCI_OPCODE {
        my($gf,$cf) = @_;
	    eval q((((($gf) & 0x3f) << 10) | (($cf) & 0x3ff)));
    }' unless defined(&HCI_OPCODE);
    eval 'sub HCI_OCF {
        my($op) = @_;
	    eval q((($op) & 0x3ff));
    }' unless defined(&HCI_OCF);
    eval 'sub HCI_OGF {
        my($op) = @_;
	    eval q(((($op) >> 10) & 0x3f));
    }' unless defined(&HCI_OGF);
    eval 'sub HCI_CON_HANDLE {
        my($h) = @_;
	    eval q((($h) & 0xfff));
    }' unless defined(&HCI_CON_HANDLE);
    eval 'sub HCI_PB_FLAG {
        my($h) = @_;
	    eval q(((($h) & 0x3000) >> 12));
    }' unless defined(&HCI_PB_FLAG);
    eval 'sub HCI_BC_FLAG {
        my($h) = @_;
	    eval q(((($h) & 0xc000) >> 14));
    }' unless defined(&HCI_BC_FLAG);
    eval 'sub HCI_MK_CON_HANDLE {
        my($h, $pb, $bc) = @_;
	    eval q(((($h) & 0xfff) | ((($pb) & 3) << 12) | ((($bc) & 3) << 14)));
    }' unless defined(&HCI_MK_CON_HANDLE);
    eval 'sub HCI_PACKET_FRAGMENT () {0x1;}' unless defined(&HCI_PACKET_FRAGMENT);
    eval 'sub HCI_PACKET_START () {0x2;}' unless defined(&HCI_PACKET_START);
    eval 'sub HCI_POINT2POINT () {0x;}' unless defined(&HCI_POINT2POINT);
    eval 'sub HCI_BROADCAST_ACTIVE () {0x1;}' unless defined(&HCI_BROADCAST_ACTIVE);
    eval 'sub HCI_BROADCAST_PICONET () {0x2;}' unless defined(&HCI_BROADCAST_PICONET);
    eval 'sub HCI_CMD_PKT () {0x1;}' unless defined(&HCI_CMD_PKT);
    eval 'sub HCI_CMD_PKT_SIZE () {($sizeof{ &hci_cmd_hdr_t} + 0xff);}' unless defined(&HCI_CMD_PKT_SIZE);
    eval 'sub HCI_ACL_DATA_PKT () {0x2;}' unless defined(&HCI_ACL_DATA_PKT);
    eval 'sub HCI_ACL_PKT_SIZE () {($sizeof{ &hci_acldata_hdr_t} + 0xffff);}' unless defined(&HCI_ACL_PKT_SIZE);
    eval 'sub HCI_SCO_DATA_PKT () {0x3;}' unless defined(&HCI_SCO_DATA_PKT);
    eval 'sub HCI_SCO_PKT_SIZE () {($sizeof{ &hci_scodata_hdr_t} + 0xff);}' unless defined(&HCI_SCO_PKT_SIZE);
    eval 'sub HCI_EVENT_PKT () {0x4;}' unless defined(&HCI_EVENT_PKT);
    eval 'sub HCI_EVENT_PKT_SIZE () {($sizeof{ &hci_event_hdr_t} + 0xff);}' unless defined(&HCI_EVENT_PKT_SIZE);
    eval 'sub HCI_OGF_LINK_CONTROL () {0x1;}' unless defined(&HCI_OGF_LINK_CONTROL);
    eval 'sub HCI_OCF_INQUIRY () {0x1;}' unless defined(&HCI_OCF_INQUIRY);
    eval 'sub HCI_CMD_INQUIRY () {0x401;}' unless defined(&HCI_CMD_INQUIRY);
    eval 'sub HCI_OCF_INQUIRY_CANCEL () {0x2;}' unless defined(&HCI_OCF_INQUIRY_CANCEL);
    eval 'sub HCI_CMD_INQUIRY_CANCEL () {0x402;}' unless defined(&HCI_CMD_INQUIRY_CANCEL);
    eval 'sub HCI_OCF_PERIODIC_INQUIRY () {0x3;}' unless defined(&HCI_OCF_PERIODIC_INQUIRY);
    eval 'sub HCI_CMD_PERIODIC_INQUIRY () {0x403;}' unless defined(&HCI_CMD_PERIODIC_INQUIRY);
    eval 'sub HCI_OCF_EXIT_PERIODIC_INQUIRY () {0x4;}' unless defined(&HCI_OCF_EXIT_PERIODIC_INQUIRY);
    eval 'sub HCI_CMD_EXIT_PERIODIC_INQUIRY () {0x404;}' unless defined(&HCI_CMD_EXIT_PERIODIC_INQUIRY);
    eval 'sub HCI_OCF_CREATE_CON () {0x5;}' unless defined(&HCI_OCF_CREATE_CON);
    eval 'sub HCI_CMD_CREATE_CON () {0x405;}' unless defined(&HCI_CMD_CREATE_CON);
    eval 'sub HCI_OCF_DISCONNECT () {0x6;}' unless defined(&HCI_OCF_DISCONNECT);
    eval 'sub HCI_CMD_DISCONNECT () {0x406;}' unless defined(&HCI_CMD_DISCONNECT);
    eval 'sub HCI_OCF_ADD_SCO_CON () {0x7;}' unless defined(&HCI_OCF_ADD_SCO_CON);
    eval 'sub HCI_CMD_ADD_SCO_CON () {0x407;}' unless defined(&HCI_CMD_ADD_SCO_CON);
    eval 'sub HCI_OCF_CREATE_CON_CANCEL () {0x8;}' unless defined(&HCI_OCF_CREATE_CON_CANCEL);
    eval 'sub HCI_CMD_CREATE_CON_CANCEL () {0x408;}' unless defined(&HCI_CMD_CREATE_CON_CANCEL);
    eval 'sub HCI_OCF_ACCEPT_CON () {0x9;}' unless defined(&HCI_OCF_ACCEPT_CON);
    eval 'sub HCI_CMD_ACCEPT_CON () {0x409;}' unless defined(&HCI_CMD_ACCEPT_CON);
    eval 'sub HCI_OCF_REJECT_CON () {0xa;}' unless defined(&HCI_OCF_REJECT_CON);
    eval 'sub HCI_CMD_REJECT_CON () {0x40a;}' unless defined(&HCI_CMD_REJECT_CON);
    eval 'sub HCI_OCF_LINK_KEY_REP () {0xb;}' unless defined(&HCI_OCF_LINK_KEY_REP);
    eval 'sub HCI_CMD_LINK_KEY_REP () {0x40b;}' unless defined(&HCI_CMD_LINK_KEY_REP);
    eval 'sub HCI_OCF_LINK_KEY_NEG_REP () {0xc;}' unless defined(&HCI_OCF_LINK_KEY_NEG_REP);
    eval 'sub HCI_CMD_LINK_KEY_NEG_REP () {0x40c;}' unless defined(&HCI_CMD_LINK_KEY_NEG_REP);
    eval 'sub HCI_OCF_PIN_CODE_REP () {0xd;}' unless defined(&HCI_OCF_PIN_CODE_REP);
    eval 'sub HCI_CMD_PIN_CODE_REP () {0x40d;}' unless defined(&HCI_CMD_PIN_CODE_REP);
    eval 'sub HCI_OCF_PIN_CODE_NEG_REP () {0xe;}' unless defined(&HCI_OCF_PIN_CODE_NEG_REP);
    eval 'sub HCI_CMD_PIN_CODE_NEG_REP () {0x40e;}' unless defined(&HCI_CMD_PIN_CODE_NEG_REP);
    eval 'sub HCI_OCF_CHANGE_CON_PACKET_TYPE () {0xf;}' unless defined(&HCI_OCF_CHANGE_CON_PACKET_TYPE);
    eval 'sub HCI_CMD_CHANGE_CON_PACKET_TYPE () {0x40f;}' unless defined(&HCI_CMD_CHANGE_CON_PACKET_TYPE);
    eval 'sub HCI_OCF_AUTH_REQ () {0x11;}' unless defined(&HCI_OCF_AUTH_REQ);
    eval 'sub HCI_CMD_AUTH_REQ () {0x411;}' unless defined(&HCI_CMD_AUTH_REQ);
    eval 'sub HCI_OCF_SET_CON_ENCRYPTION () {0x13;}' unless defined(&HCI_OCF_SET_CON_ENCRYPTION);
    eval 'sub HCI_CMD_SET_CON_ENCRYPTION () {0x413;}' unless defined(&HCI_CMD_SET_CON_ENCRYPTION);
    eval 'sub HCI_OCF_CHANGE_CON_LINK_KEY () {0x15;}' unless defined(&HCI_OCF_CHANGE_CON_LINK_KEY);
    eval 'sub HCI_CMD_CHANGE_CON_LINK_KEY () {0x415;}' unless defined(&HCI_CMD_CHANGE_CON_LINK_KEY);
    eval 'sub HCI_OCF_MASTER_LINK_KEY () {0x17;}' unless defined(&HCI_OCF_MASTER_LINK_KEY);
    eval 'sub HCI_CMD_MASTER_LINK_KEY () {0x417;}' unless defined(&HCI_CMD_MASTER_LINK_KEY);
    eval 'sub HCI_OCF_REMOTE_NAME_REQ () {0x19;}' unless defined(&HCI_OCF_REMOTE_NAME_REQ);
    eval 'sub HCI_CMD_REMOTE_NAME_REQ () {0x419;}' unless defined(&HCI_CMD_REMOTE_NAME_REQ);
    eval 'sub HCI_OCF_REMOTE_NAME_REQ_CANCEL () {0x1a;}' unless defined(&HCI_OCF_REMOTE_NAME_REQ_CANCEL);
    eval 'sub HCI_CMD_REMOTE_NAME_REQ_CANCEL () {0x41a;}' unless defined(&HCI_CMD_REMOTE_NAME_REQ_CANCEL);
    eval 'sub HCI_OCF_READ_REMOTE_FEATURES () {0x1b;}' unless defined(&HCI_OCF_READ_REMOTE_FEATURES);
    eval 'sub HCI_CMD_READ_REMOTE_FEATURES () {0x41b;}' unless defined(&HCI_CMD_READ_REMOTE_FEATURES);
    eval 'sub HCI_OCF_READ_REMOTE_EXTENDED_FEATURES () {0x1c;}' unless defined(&HCI_OCF_READ_REMOTE_EXTENDED_FEATURES);
    eval 'sub HCI_CMD_READ_REMOTE_EXTENDED_FEATURES () {0x41c;}' unless defined(&HCI_CMD_READ_REMOTE_EXTENDED_FEATURES);
    eval 'sub HCI_OCF_READ_REMOTE_VER_INFO () {0x1d;}' unless defined(&HCI_OCF_READ_REMOTE_VER_INFO);
    eval 'sub HCI_CMD_READ_REMOTE_VER_INFO () {0x41d;}' unless defined(&HCI_CMD_READ_REMOTE_VER_INFO);
    eval 'sub HCI_OCF_READ_CLOCK_OFFSET () {0x1f;}' unless defined(&HCI_OCF_READ_CLOCK_OFFSET);
    eval 'sub HCI_CMD_READ_CLOCK_OFFSET () {0x41f;}' unless defined(&HCI_CMD_READ_CLOCK_OFFSET);
    eval 'sub HCI_OCF_READ_LMP_HANDLE () {0x20;}' unless defined(&HCI_OCF_READ_LMP_HANDLE);
    eval 'sub HCI_CMD_READ_LMP_HANDLE () {0x420;}' unless defined(&HCI_CMD_READ_LMP_HANDLE);
    eval 'sub HCI_OCF_SETUP_SCO_CON () {0x28;}' unless defined(&HCI_OCF_SETUP_SCO_CON);
    eval 'sub HCI_CMD_SETUP_SCO_CON () {0x428;}' unless defined(&HCI_CMD_SETUP_SCO_CON);
    eval 'sub HCI_OCF_ACCEPT_SCO_CON_REQ () {0x29;}' unless defined(&HCI_OCF_ACCEPT_SCO_CON_REQ);
    eval 'sub HCI_CMD_ACCEPT_SCO_CON_REQ () {0x429;}' unless defined(&HCI_CMD_ACCEPT_SCO_CON_REQ);
    eval 'sub HCI_OCF_REJECT_SCO_CON_REQ () {0x2a;}' unless defined(&HCI_OCF_REJECT_SCO_CON_REQ);
    eval 'sub HCI_CMD_REJECT_SCO_CON_REQ () {0x42a;}' unless defined(&HCI_CMD_REJECT_SCO_CON_REQ);
    eval 'sub HCI_OCF_IO_CAPABILITY_REP () {0x2b;}' unless defined(&HCI_OCF_IO_CAPABILITY_REP);
    eval 'sub HCI_CMD_IO_CAPABILITY_REP () {0x42a;}' unless defined(&HCI_CMD_IO_CAPABILITY_REP);
    eval 'sub HCI_OCF_USER_CONFIRM_REP () {0x2c;}' unless defined(&HCI_OCF_USER_CONFIRM_REP);
    eval 'sub HCI_CMD_USER_CONFIRM_REP () {0x42c;}' unless defined(&HCI_CMD_USER_CONFIRM_REP);
    eval 'sub HCI_OCF_USER_CONFIRM_NEG_REP () {0x2d;}' unless defined(&HCI_OCF_USER_CONFIRM_NEG_REP);
    eval 'sub HCI_CMD_USER_CONFIRM_NEG_REP () {0x42d;}' unless defined(&HCI_CMD_USER_CONFIRM_NEG_REP);
    eval 'sub HCI_OCF_USER_PASSKEY_REP () {0x2e;}' unless defined(&HCI_OCF_USER_PASSKEY_REP);
    eval 'sub HCI_CMD_USER_PASSKEY_REP () {0x42e;}' unless defined(&HCI_CMD_USER_PASSKEY_REP);
    eval 'sub HCI_OCF_USER_PASSKEY_NEG_REP () {0x2f;}' unless defined(&HCI_OCF_USER_PASSKEY_NEG_REP);
    eval 'sub HCI_CMD_USER_PASSKEY_NEG_REP () {0x42f;}' unless defined(&HCI_CMD_USER_PASSKEY_NEG_REP);
    eval 'sub HCI_OCF_OOB_DATA_REP () {0x30;}' unless defined(&HCI_OCF_OOB_DATA_REP);
    eval 'sub HCI_CMD_OOB_DATA_REP () {0x430;}' unless defined(&HCI_CMD_OOB_DATA_REP);
    eval 'sub HCI_OCF_OOB_DATA_NEG_REP () {0x33;}' unless defined(&HCI_OCF_OOB_DATA_NEG_REP);
    eval 'sub HCI_CMD_OOB_DATA_NEG_REP () {0x433;}' unless defined(&HCI_CMD_OOB_DATA_NEG_REP);
    eval 'sub HCI_OCF_IO_CAPABILITY_NEG_REP () {0x34;}' unless defined(&HCI_OCF_IO_CAPABILITY_NEG_REP);
    eval 'sub HCI_CMD_IO_CAPABILITY_NEG_REP () {0x434;}' unless defined(&HCI_CMD_IO_CAPABILITY_NEG_REP);
    eval 'sub HCI_OGF_LINK_POLICY () {0x2;}' unless defined(&HCI_OGF_LINK_POLICY);
    eval 'sub HCI_OCF_HOLD_MODE () {0x1;}' unless defined(&HCI_OCF_HOLD_MODE);
    eval 'sub HCI_CMD_HOLD_MODE () {0x801;}' unless defined(&HCI_CMD_HOLD_MODE);
    eval 'sub HCI_OCF_SNIFF_MODE () {0x3;}' unless defined(&HCI_OCF_SNIFF_MODE);
    eval 'sub HCI_CMD_SNIFF_MODE () {0x803;}' unless defined(&HCI_CMD_SNIFF_MODE);
    eval 'sub HCI_OCF_EXIT_SNIFF_MODE () {0x4;}' unless defined(&HCI_OCF_EXIT_SNIFF_MODE);
    eval 'sub HCI_CMD_EXIT_SNIFF_MODE () {0x804;}' unless defined(&HCI_CMD_EXIT_SNIFF_MODE);
    eval 'sub HCI_OCF_PARK_MODE () {0x5;}' unless defined(&HCI_OCF_PARK_MODE);
    eval 'sub HCI_CMD_PARK_MODE () {0x805;}' unless defined(&HCI_CMD_PARK_MODE);
    eval 'sub HCI_OCF_EXIT_PARK_MODE () {0x6;}' unless defined(&HCI_OCF_EXIT_PARK_MODE);
    eval 'sub HCI_CMD_EXIT_PARK_MODE () {0x806;}' unless defined(&HCI_CMD_EXIT_PARK_MODE);
    eval 'sub HCI_OCF_QOS_SETUP () {0x7;}' unless defined(&HCI_OCF_QOS_SETUP);
    eval 'sub HCI_CMD_QOS_SETUP () {0x807;}' unless defined(&HCI_CMD_QOS_SETUP);
    eval 'sub HCI_OCF_ROLE_DISCOVERY () {0x9;}' unless defined(&HCI_OCF_ROLE_DISCOVERY);
    eval 'sub HCI_CMD_ROLE_DISCOVERY () {0x809;}' unless defined(&HCI_CMD_ROLE_DISCOVERY);
    eval 'sub HCI_OCF_SWITCH_ROLE () {0xb;}' unless defined(&HCI_OCF_SWITCH_ROLE);
    eval 'sub HCI_CMD_SWITCH_ROLE () {0x80b;}' unless defined(&HCI_CMD_SWITCH_ROLE);
    eval 'sub HCI_OCF_READ_LINK_POLICY_SETTINGS () {0xc;}' unless defined(&HCI_OCF_READ_LINK_POLICY_SETTINGS);
    eval 'sub HCI_CMD_READ_LINK_POLICY_SETTINGS () {0x80c;}' unless defined(&HCI_CMD_READ_LINK_POLICY_SETTINGS);
    eval 'sub HCI_OCF_WRITE_LINK_POLICY_SETTINGS () {0xd;}' unless defined(&HCI_OCF_WRITE_LINK_POLICY_SETTINGS);
    eval 'sub HCI_CMD_WRITE_LINK_POLICY_SETTINGS () {0x80d;}' unless defined(&HCI_CMD_WRITE_LINK_POLICY_SETTINGS);
    eval 'sub HCI_OCF_READ_DEFAULT_LINK_POLICY_SETTINGS () {0xe;}' unless defined(&HCI_OCF_READ_DEFAULT_LINK_POLICY_SETTINGS);
    eval 'sub HCI_CMD_READ_DEFAULT_LINK_POLICY_SETTINGS () {0x80e;}' unless defined(&HCI_CMD_READ_DEFAULT_LINK_POLICY_SETTINGS);
    eval 'sub HCI_OCF_WRITE_DEFAULT_LINK_POLICY_SETTINGS () {0xf;}' unless defined(&HCI_OCF_WRITE_DEFAULT_LINK_POLICY_SETTINGS);
    eval 'sub HCI_CMD_WRITE_DEFAULT_LINK_POLICY_SETTINGS () {0x80f;}' unless defined(&HCI_CMD_WRITE_DEFAULT_LINK_POLICY_SETTINGS);
    eval 'sub HCI_OCF_FLOW_SPECIFICATION () {0x10;}' unless defined(&HCI_OCF_FLOW_SPECIFICATION);
    eval 'sub HCI_CMD_FLOW_SPECIFICATION () {0x810;}' unless defined(&HCI_CMD_FLOW_SPECIFICATION);
    eval 'sub HCI_OCF_SNIFF_SUBRATING () {0x11;}' unless defined(&HCI_OCF_SNIFF_SUBRATING);
    eval 'sub HCI_CMD_SNIFF_SUBRATING () {0x810;}' unless defined(&HCI_CMD_SNIFF_SUBRATING);
    eval 'sub HCI_OGF_HC_BASEBAND () {0x3;}' unless defined(&HCI_OGF_HC_BASEBAND);
    eval 'sub HCI_OCF_SET_EVENT_MASK () {0x1;}' unless defined(&HCI_OCF_SET_EVENT_MASK);
    eval 'sub HCI_CMD_SET_EVENT_MASK () {0xc01;}' unless defined(&HCI_CMD_SET_EVENT_MASK);
    eval 'sub HCI_OCF_RESET () {0x3;}' unless defined(&HCI_OCF_RESET);
    eval 'sub HCI_CMD_RESET () {0xc03;}' unless defined(&HCI_CMD_RESET);
    eval 'sub HCI_OCF_SET_EVENT_FILTER () {0x5;}' unless defined(&HCI_OCF_SET_EVENT_FILTER);
    eval 'sub HCI_CMD_SET_EVENT_FILTER () {0xc05;}' unless defined(&HCI_CMD_SET_EVENT_FILTER);
    eval 'sub HCI_OCF_FLUSH () {0x8;}' unless defined(&HCI_OCF_FLUSH);
    eval 'sub HCI_CMD_FLUSH () {0xc08;}' unless defined(&HCI_CMD_FLUSH);
    eval 'sub HCI_OCF_READ_PIN_TYPE () {0x9;}' unless defined(&HCI_OCF_READ_PIN_TYPE);
    eval 'sub HCI_CMD_READ_PIN_TYPE () {0xc09;}' unless defined(&HCI_CMD_READ_PIN_TYPE);
    eval 'sub HCI_OCF_WRITE_PIN_TYPE () {0xa;}' unless defined(&HCI_OCF_WRITE_PIN_TYPE);
    eval 'sub HCI_CMD_WRITE_PIN_TYPE () {0xc0a;}' unless defined(&HCI_CMD_WRITE_PIN_TYPE);
    eval 'sub HCI_OCF_CREATE_NEW_UNIT_KEY () {0xb;}' unless defined(&HCI_OCF_CREATE_NEW_UNIT_KEY);
    eval 'sub HCI_CMD_CREATE_NEW_UNIT_KEY () {0xc0b;}' unless defined(&HCI_CMD_CREATE_NEW_UNIT_KEY);
    eval 'sub HCI_OCF_READ_STORED_LINK_KEY () {0xd;}' unless defined(&HCI_OCF_READ_STORED_LINK_KEY);
    eval 'sub HCI_CMD_READ_STORED_LINK_KEY () {0xc0d;}' unless defined(&HCI_CMD_READ_STORED_LINK_KEY);
    eval 'sub HCI_OCF_WRITE_STORED_LINK_KEY () {0x11;}' unless defined(&HCI_OCF_WRITE_STORED_LINK_KEY);
    eval 'sub HCI_CMD_WRITE_STORED_LINK_KEY () {0xc11;}' unless defined(&HCI_CMD_WRITE_STORED_LINK_KEY);
    eval 'sub HCI_OCF_DELETE_STORED_LINK_KEY () {0x12;}' unless defined(&HCI_OCF_DELETE_STORED_LINK_KEY);
    eval 'sub HCI_CMD_DELETE_STORED_LINK_KEY () {0xc12;}' unless defined(&HCI_CMD_DELETE_STORED_LINK_KEY);
    eval 'sub HCI_OCF_WRITE_LOCAL_NAME () {0x13;}' unless defined(&HCI_OCF_WRITE_LOCAL_NAME);
    eval 'sub HCI_CMD_WRITE_LOCAL_NAME () {0xc13;}' unless defined(&HCI_CMD_WRITE_LOCAL_NAME);
    eval 'sub HCI_OCF_READ_LOCAL_NAME () {0x14;}' unless defined(&HCI_OCF_READ_LOCAL_NAME);
    eval 'sub HCI_CMD_READ_LOCAL_NAME () {0xc14;}' unless defined(&HCI_CMD_READ_LOCAL_NAME);
    eval 'sub HCI_OCF_READ_CON_ACCEPT_TIMEOUT () {0x15;}' unless defined(&HCI_OCF_READ_CON_ACCEPT_TIMEOUT);
    eval 'sub HCI_CMD_READ_CON_ACCEPT_TIMEOUT () {0xc15;}' unless defined(&HCI_CMD_READ_CON_ACCEPT_TIMEOUT);
    eval 'sub HCI_OCF_WRITE_CON_ACCEPT_TIMEOUT () {0x16;}' unless defined(&HCI_OCF_WRITE_CON_ACCEPT_TIMEOUT);
    eval 'sub HCI_CMD_WRITE_CON_ACCEPT_TIMEOUT () {0xc16;}' unless defined(&HCI_CMD_WRITE_CON_ACCEPT_TIMEOUT);
    eval 'sub HCI_OCF_READ_PAGE_TIMEOUT () {0x17;}' unless defined(&HCI_OCF_READ_PAGE_TIMEOUT);
    eval 'sub HCI_CMD_READ_PAGE_TIMEOUT () {0xc17;}' unless defined(&HCI_CMD_READ_PAGE_TIMEOUT);
    eval 'sub HCI_OCF_WRITE_PAGE_TIMEOUT () {0x18;}' unless defined(&HCI_OCF_WRITE_PAGE_TIMEOUT);
    eval 'sub HCI_CMD_WRITE_PAGE_TIMEOUT () {0xc18;}' unless defined(&HCI_CMD_WRITE_PAGE_TIMEOUT);
    eval 'sub HCI_OCF_READ_SCAN_ENABLE () {0x19;}' unless defined(&HCI_OCF_READ_SCAN_ENABLE);
    eval 'sub HCI_CMD_READ_SCAN_ENABLE () {0xc19;}' unless defined(&HCI_CMD_READ_SCAN_ENABLE);
    eval 'sub HCI_OCF_WRITE_SCAN_ENABLE () {0x1a;}' unless defined(&HCI_OCF_WRITE_SCAN_ENABLE);
    eval 'sub HCI_CMD_WRITE_SCAN_ENABLE () {0xc1a;}' unless defined(&HCI_CMD_WRITE_SCAN_ENABLE);
    eval 'sub HCI_OCF_READ_PAGE_SCAN_ACTIVITY () {0x1b;}' unless defined(&HCI_OCF_READ_PAGE_SCAN_ACTIVITY);
    eval 'sub HCI_CMD_READ_PAGE_SCAN_ACTIVITY () {0xc1b;}' unless defined(&HCI_CMD_READ_PAGE_SCAN_ACTIVITY);
    eval 'sub HCI_OCF_WRITE_PAGE_SCAN_ACTIVITY () {0x1c;}' unless defined(&HCI_OCF_WRITE_PAGE_SCAN_ACTIVITY);
    eval 'sub HCI_CMD_WRITE_PAGE_SCAN_ACTIVITY () {0xc1c;}' unless defined(&HCI_CMD_WRITE_PAGE_SCAN_ACTIVITY);
    eval 'sub HCI_OCF_READ_INQUIRY_SCAN_ACTIVITY () {0x1d;}' unless defined(&HCI_OCF_READ_INQUIRY_SCAN_ACTIVITY);
    eval 'sub HCI_CMD_READ_INQUIRY_SCAN_ACTIVITY () {0xc1d;}' unless defined(&HCI_CMD_READ_INQUIRY_SCAN_ACTIVITY);
    eval 'sub HCI_OCF_WRITE_INQUIRY_SCAN_ACTIVITY () {0x1e;}' unless defined(&HCI_OCF_WRITE_INQUIRY_SCAN_ACTIVITY);
    eval 'sub HCI_CMD_WRITE_INQUIRY_SCAN_ACTIVITY () {0xc1e;}' unless defined(&HCI_CMD_WRITE_INQUIRY_SCAN_ACTIVITY);
    eval 'sub HCI_OCF_READ_AUTH_ENABLE () {0x1f;}' unless defined(&HCI_OCF_READ_AUTH_ENABLE);
    eval 'sub HCI_CMD_READ_AUTH_ENABLE () {0xc1f;}' unless defined(&HCI_CMD_READ_AUTH_ENABLE);
    eval 'sub HCI_OCF_WRITE_AUTH_ENABLE () {0x20;}' unless defined(&HCI_OCF_WRITE_AUTH_ENABLE);
    eval 'sub HCI_CMD_WRITE_AUTH_ENABLE () {0xc20;}' unless defined(&HCI_CMD_WRITE_AUTH_ENABLE);
    eval 'sub HCI_OCF_READ_ENCRYPTION_MODE () {0x21;}' unless defined(&HCI_OCF_READ_ENCRYPTION_MODE);
    eval 'sub HCI_CMD_READ_ENCRYPTION_MODE () {0xc21;}' unless defined(&HCI_CMD_READ_ENCRYPTION_MODE);
    eval 'sub HCI_OCF_WRITE_ENCRYPTION_MODE () {0x22;}' unless defined(&HCI_OCF_WRITE_ENCRYPTION_MODE);
    eval 'sub HCI_CMD_WRITE_ENCRYPTION_MODE () {0xc22;}' unless defined(&HCI_CMD_WRITE_ENCRYPTION_MODE);
    eval 'sub HCI_OCF_READ_UNIT_CLASS () {0x23;}' unless defined(&HCI_OCF_READ_UNIT_CLASS);
    eval 'sub HCI_CMD_READ_UNIT_CLASS () {0xc23;}' unless defined(&HCI_CMD_READ_UNIT_CLASS);
    eval 'sub HCI_OCF_WRITE_UNIT_CLASS () {0x24;}' unless defined(&HCI_OCF_WRITE_UNIT_CLASS);
    eval 'sub HCI_CMD_WRITE_UNIT_CLASS () {0xc24;}' unless defined(&HCI_CMD_WRITE_UNIT_CLASS);
    eval 'sub HCI_OCF_READ_VOICE_SETTING () {0x25;}' unless defined(&HCI_OCF_READ_VOICE_SETTING);
    eval 'sub HCI_CMD_READ_VOICE_SETTING () {0xc25;}' unless defined(&HCI_CMD_READ_VOICE_SETTING);
    eval 'sub HCI_OCF_WRITE_VOICE_SETTING () {0x26;}' unless defined(&HCI_OCF_WRITE_VOICE_SETTING);
    eval 'sub HCI_CMD_WRITE_VOICE_SETTING () {0xc26;}' unless defined(&HCI_CMD_WRITE_VOICE_SETTING);
    eval 'sub HCI_OCF_READ_AUTO_FLUSH_TIMEOUT () {0x27;}' unless defined(&HCI_OCF_READ_AUTO_FLUSH_TIMEOUT);
    eval 'sub HCI_CMD_READ_AUTO_FLUSH_TIMEOUT () {0xc27;}' unless defined(&HCI_CMD_READ_AUTO_FLUSH_TIMEOUT);
    eval 'sub HCI_OCF_WRITE_AUTO_FLUSH_TIMEOUT () {0x28;}' unless defined(&HCI_OCF_WRITE_AUTO_FLUSH_TIMEOUT);
    eval 'sub HCI_CMD_WRITE_AUTO_FLUSH_TIMEOUT () {0xc28;}' unless defined(&HCI_CMD_WRITE_AUTO_FLUSH_TIMEOUT);
    eval 'sub HCI_OCF_READ_NUM_BROADCAST_RETRANS () {0x29;}' unless defined(&HCI_OCF_READ_NUM_BROADCAST_RETRANS);
    eval 'sub HCI_CMD_READ_NUM_BROADCAST_RETRANS () {0xc29;}' unless defined(&HCI_CMD_READ_NUM_BROADCAST_RETRANS);
    eval 'sub HCI_OCF_WRITE_NUM_BROADCAST_RETRANS () {0x2a;}' unless defined(&HCI_OCF_WRITE_NUM_BROADCAST_RETRANS);
    eval 'sub HCI_CMD_WRITE_NUM_BROADCAST_RETRANS () {0xc2a;}' unless defined(&HCI_CMD_WRITE_NUM_BROADCAST_RETRANS);
    eval 'sub HCI_OCF_READ_HOLD_MODE_ACTIVITY () {0x2b;}' unless defined(&HCI_OCF_READ_HOLD_MODE_ACTIVITY);
    eval 'sub HCI_CMD_READ_HOLD_MODE_ACTIVITY () {0xc2b;}' unless defined(&HCI_CMD_READ_HOLD_MODE_ACTIVITY);
    eval 'sub HCI_OCF_WRITE_HOLD_MODE_ACTIVITY () {0x2c;}' unless defined(&HCI_OCF_WRITE_HOLD_MODE_ACTIVITY);
    eval 'sub HCI_CMD_WRITE_HOLD_MODE_ACTIVITY () {0xc2c;}' unless defined(&HCI_CMD_WRITE_HOLD_MODE_ACTIVITY);
    eval 'sub HCI_OCF_READ_XMIT_LEVEL () {0x2d;}' unless defined(&HCI_OCF_READ_XMIT_LEVEL);
    eval 'sub HCI_CMD_READ_XMIT_LEVEL () {0xc2d;}' unless defined(&HCI_CMD_READ_XMIT_LEVEL);
    eval 'sub HCI_OCF_READ_SCO_FLOW_CONTROL () {0x2e;}' unless defined(&HCI_OCF_READ_SCO_FLOW_CONTROL);
    eval 'sub HCI_CMD_READ_SCO_FLOW_CONTROL () {0xc2e;}' unless defined(&HCI_CMD_READ_SCO_FLOW_CONTROL);
    eval 'sub HCI_OCF_WRITE_SCO_FLOW_CONTROL () {0x2f;}' unless defined(&HCI_OCF_WRITE_SCO_FLOW_CONTROL);
    eval 'sub HCI_CMD_WRITE_SCO_FLOW_CONTROL () {0xc2f;}' unless defined(&HCI_CMD_WRITE_SCO_FLOW_CONTROL);
    eval 'sub HCI_OCF_HC2H_FLOW_CONTROL () {0x31;}' unless defined(&HCI_OCF_HC2H_FLOW_CONTROL);
    eval 'sub HCI_CMD_HC2H_FLOW_CONTROL () {0xc31;}' unless defined(&HCI_CMD_HC2H_FLOW_CONTROL);
    eval 'sub HCI_OCF_HOST_BUFFER_SIZE () {0x33;}' unless defined(&HCI_OCF_HOST_BUFFER_SIZE);
    eval 'sub HCI_CMD_HOST_BUFFER_SIZE () {0xc33;}' unless defined(&HCI_CMD_HOST_BUFFER_SIZE);
    eval 'sub HCI_OCF_HOST_NUM_COMPL_PKTS () {0x35;}' unless defined(&HCI_OCF_HOST_NUM_COMPL_PKTS);
    eval 'sub HCI_CMD_HOST_NUM_COMPL_PKTS () {0xc35;}' unless defined(&HCI_CMD_HOST_NUM_COMPL_PKTS);
    eval 'sub HCI_OCF_READ_LINK_SUPERVISION_TIMEOUT () {0x36;}' unless defined(&HCI_OCF_READ_LINK_SUPERVISION_TIMEOUT);
    eval 'sub HCI_CMD_READ_LINK_SUPERVISION_TIMEOUT () {0xc36;}' unless defined(&HCI_CMD_READ_LINK_SUPERVISION_TIMEOUT);
    eval 'sub HCI_OCF_WRITE_LINK_SUPERVISION_TIMEOUT () {0x37;}' unless defined(&HCI_OCF_WRITE_LINK_SUPERVISION_TIMEOUT);
    eval 'sub HCI_CMD_WRITE_LINK_SUPERVISION_TIMEOUT () {0xc37;}' unless defined(&HCI_CMD_WRITE_LINK_SUPERVISION_TIMEOUT);
    eval 'sub HCI_OCF_READ_NUM_SUPPORTED_IAC () {0x38;}' unless defined(&HCI_OCF_READ_NUM_SUPPORTED_IAC);
    eval 'sub HCI_CMD_READ_NUM_SUPPORTED_IAC () {0xc38;}' unless defined(&HCI_CMD_READ_NUM_SUPPORTED_IAC);
    eval 'sub HCI_OCF_READ_IAC_LAP () {0x39;}' unless defined(&HCI_OCF_READ_IAC_LAP);
    eval 'sub HCI_CMD_READ_IAC_LAP () {0xc39;}' unless defined(&HCI_CMD_READ_IAC_LAP);
    eval 'sub HCI_OCF_WRITE_IAC_LAP () {0x3a;}' unless defined(&HCI_OCF_WRITE_IAC_LAP);
    eval 'sub HCI_CMD_WRITE_IAC_LAP () {0xc3a;}' unless defined(&HCI_CMD_WRITE_IAC_LAP);
    eval 'sub HCI_OCF_READ_PAGE_SCAN_PERIOD () {0x3b;}' unless defined(&HCI_OCF_READ_PAGE_SCAN_PERIOD);
    eval 'sub HCI_CMD_READ_PAGE_SCAN_PERIOD () {0xc3b;}' unless defined(&HCI_CMD_READ_PAGE_SCAN_PERIOD);
    eval 'sub HCI_OCF_WRITE_PAGE_SCAN_PERIOD () {0x3c;}' unless defined(&HCI_OCF_WRITE_PAGE_SCAN_PERIOD);
    eval 'sub HCI_CMD_WRITE_PAGE_SCAN_PERIOD () {0xc3c;}' unless defined(&HCI_CMD_WRITE_PAGE_SCAN_PERIOD);
    eval 'sub HCI_OCF_READ_PAGE_SCAN () {0x3d;}' unless defined(&HCI_OCF_READ_PAGE_SCAN);
    eval 'sub HCI_CMD_READ_PAGE_SCAN () {0xc3d;}' unless defined(&HCI_CMD_READ_PAGE_SCAN);
    eval 'sub HCI_OCF_WRITE_PAGE_SCAN () {0x3e;}' unless defined(&HCI_OCF_WRITE_PAGE_SCAN);
    eval 'sub HCI_CMD_WRITE_PAGE_SCAN () {0xc3e;}' unless defined(&HCI_CMD_WRITE_PAGE_SCAN);
    eval 'sub HCI_OCF_SET_AFH_CLASSIFICATION () {0x3f;}' unless defined(&HCI_OCF_SET_AFH_CLASSIFICATION);
    eval 'sub HCI_CMD_SET_AFH_CLASSIFICATION () {0xc3f;}' unless defined(&HCI_CMD_SET_AFH_CLASSIFICATION);
    eval 'sub HCI_OCF_READ_INQUIRY_SCAN_TYPE () {0x42;}' unless defined(&HCI_OCF_READ_INQUIRY_SCAN_TYPE);
    eval 'sub HCI_CMD_READ_INQUIRY_SCAN_TYPE () {0xc42;}' unless defined(&HCI_CMD_READ_INQUIRY_SCAN_TYPE);
    eval 'sub HCI_OCF_WRITE_INQUIRY_SCAN_TYPE () {0x43;}' unless defined(&HCI_OCF_WRITE_INQUIRY_SCAN_TYPE);
    eval 'sub HCI_CMD_WRITE_INQUIRY_SCAN_TYPE () {0xc43;}' unless defined(&HCI_CMD_WRITE_INQUIRY_SCAN_TYPE);
    eval 'sub HCI_OCF_READ_INQUIRY_MODE () {0x44;}' unless defined(&HCI_OCF_READ_INQUIRY_MODE);
    eval 'sub HCI_CMD_READ_INQUIRY_MODE () {0xc44;}' unless defined(&HCI_CMD_READ_INQUIRY_MODE);
    eval 'sub HCI_OCF_WRITE_INQUIRY_MODE () {0x45;}' unless defined(&HCI_OCF_WRITE_INQUIRY_MODE);
    eval 'sub HCI_CMD_WRITE_INQUIRY_MODE () {0xc45;}' unless defined(&HCI_CMD_WRITE_INQUIRY_MODE);
    eval 'sub HCI_OCF_READ_PAGE_SCAN_TYPE () {0x46;}' unless defined(&HCI_OCF_READ_PAGE_SCAN_TYPE);
    eval 'sub HCI_CMD_READ_PAGE_SCAN_TYPE () {0xc46;}' unless defined(&HCI_CMD_READ_PAGE_SCAN_TYPE);
    eval 'sub HCI_OCF_WRITE_PAGE_SCAN_TYPE () {0x47;}' unless defined(&HCI_OCF_WRITE_PAGE_SCAN_TYPE);
    eval 'sub HCI_CMD_WRITE_PAGE_SCAN_TYPE () {0xc47;}' unless defined(&HCI_CMD_WRITE_PAGE_SCAN_TYPE);
    eval 'sub HCI_OCF_READ_AFH_ASSESSMENT () {0x48;}' unless defined(&HCI_OCF_READ_AFH_ASSESSMENT);
    eval 'sub HCI_CMD_READ_AFH_ASSESSMENT () {0xc48;}' unless defined(&HCI_CMD_READ_AFH_ASSESSMENT);
    eval 'sub HCI_OCF_WRITE_AFH_ASSESSMENT () {0x49;}' unless defined(&HCI_OCF_WRITE_AFH_ASSESSMENT);
    eval 'sub HCI_CMD_WRITE_AFH_ASSESSMENT () {0xc49;}' unless defined(&HCI_CMD_WRITE_AFH_ASSESSMENT);
    eval 'sub HCI_OCF_READ_EXTENDED_INQUIRY_RSP () {0x51;}' unless defined(&HCI_OCF_READ_EXTENDED_INQUIRY_RSP);
    eval 'sub HCI_CMD_READ_EXTENDED_INQUIRY_RSP () {0xc51;}' unless defined(&HCI_CMD_READ_EXTENDED_INQUIRY_RSP);
    eval 'sub HCI_OCF_WRITE_EXTENDED_INQUIRY_RSP () {0x52;}' unless defined(&HCI_OCF_WRITE_EXTENDED_INQUIRY_RSP);
    eval 'sub HCI_CMD_WRITE_EXTENDED_INQUIRY_RSP () {0xc52;}' unless defined(&HCI_CMD_WRITE_EXTENDED_INQUIRY_RSP);
    eval 'sub HCI_OCF_REFRESH_ENCRYPTION_KEY () {0x53;}' unless defined(&HCI_OCF_REFRESH_ENCRYPTION_KEY);
    eval 'sub HCI_CMD_REFRESH_ENCRYPTION_KEY () {0xc53;}' unless defined(&HCI_CMD_REFRESH_ENCRYPTION_KEY);
    eval 'sub HCI_OCF_READ_SIMPLE_PAIRING_MODE () {0x55;}' unless defined(&HCI_OCF_READ_SIMPLE_PAIRING_MODE);
    eval 'sub HCI_CMD_READ_SIMPLE_PAIRING_MODE () {0xc55;}' unless defined(&HCI_CMD_READ_SIMPLE_PAIRING_MODE);
    eval 'sub HCI_OCF_WRITE_SIMPLE_PAIRING_MODE () {0x56;}' unless defined(&HCI_OCF_WRITE_SIMPLE_PAIRING_MODE);
    eval 'sub HCI_CMD_WRITE_SIMPLE_PAIRING_MODE () {0xc56;}' unless defined(&HCI_CMD_WRITE_SIMPLE_PAIRING_MODE);
    eval 'sub HCI_OCF_READ_LOCAL_OOB_DATA () {0x57;}' unless defined(&HCI_OCF_READ_LOCAL_OOB_DATA);
    eval 'sub HCI_CMD_READ_LOCAL_OOB_DATA () {0xc57;}' unless defined(&HCI_CMD_READ_LOCAL_OOB_DATA);
    eval 'sub HCI_OCF_READ_INQUIRY_RSP_XMIT_POWER () {0x58;}' unless defined(&HCI_OCF_READ_INQUIRY_RSP_XMIT_POWER);
    eval 'sub HCI_CMD_READ_INQUIRY_RSP_XMIT_POWER () {0xc58;}' unless defined(&HCI_CMD_READ_INQUIRY_RSP_XMIT_POWER);
    eval 'sub HCI_OCF_WRITE_INQUIRY_RSP_XMIT_POWER () {0x59;}' unless defined(&HCI_OCF_WRITE_INQUIRY_RSP_XMIT_POWER);
    eval 'sub HCI_CMD_WRITE_INQUIRY_RSP_XMIT_POWER () {0xc59;}' unless defined(&HCI_CMD_WRITE_INQUIRY_RSP_XMIT_POWER);
    eval 'sub HCI_OCF_READ_DEFAULT_ERRDATA_REPORTING () {0x5a;}' unless defined(&HCI_OCF_READ_DEFAULT_ERRDATA_REPORTING);
    eval 'sub HCI_CMD_READ_DEFAULT_ERRDATA_REPORTING () {0xc5a;}' unless defined(&HCI_CMD_READ_DEFAULT_ERRDATA_REPORTING);
    eval 'sub HCI_OCF_WRITE_DEFAULT_ERRDATA_REPORTING () {0x5b;}' unless defined(&HCI_OCF_WRITE_DEFAULT_ERRDATA_REPORTING);
    eval 'sub HCI_CMD_WRITE_DEFAULT_ERRDATA_REPORTING () {0xc5b;}' unless defined(&HCI_CMD_WRITE_DEFAULT_ERRDATA_REPORTING);
    eval 'sub HCI_OCF_ENHANCED_FLUSH () {0x5f;}' unless defined(&HCI_OCF_ENHANCED_FLUSH);
    eval 'sub HCI_CMD_ENHANCED_FLUSH () {0xc5f;}' unless defined(&HCI_CMD_ENHANCED_FLUSH);
    eval 'sub HCI_OCF_SEND_KEYPRESS_NOTIFICATION () {0x60;}' unless defined(&HCI_OCF_SEND_KEYPRESS_NOTIFICATION);
    eval 'sub HCI_CMD_SEND_KEYPRESS_NOTIFICATION () {0xc60;}' unless defined(&HCI_CMD_SEND_KEYPRESS_NOTIFICATION);
    eval 'sub HCI_OGF_INFO () {0x4;}' unless defined(&HCI_OGF_INFO);
    eval 'sub HCI_OCF_READ_LOCAL_VER () {0x1;}' unless defined(&HCI_OCF_READ_LOCAL_VER);
    eval 'sub HCI_CMD_READ_LOCAL_VER () {0x1001;}' unless defined(&HCI_CMD_READ_LOCAL_VER);
    eval 'sub HCI_OCF_READ_LOCAL_COMMANDS () {0x2;}' unless defined(&HCI_OCF_READ_LOCAL_COMMANDS);
    eval 'sub HCI_CMD_READ_LOCAL_COMMANDS () {0x1002;}' unless defined(&HCI_CMD_READ_LOCAL_COMMANDS);
    eval 'sub HCI_OCF_READ_LOCAL_FEATURES () {0x3;}' unless defined(&HCI_OCF_READ_LOCAL_FEATURES);
    eval 'sub HCI_CMD_READ_LOCAL_FEATURES () {0x1003;}' unless defined(&HCI_CMD_READ_LOCAL_FEATURES);
    eval 'sub HCI_OCF_READ_LOCAL_EXTENDED_FEATURES () {0x4;}' unless defined(&HCI_OCF_READ_LOCAL_EXTENDED_FEATURES);
    eval 'sub HCI_CMD_READ_LOCAL_EXTENDED_FEATURES () {0x1004;}' unless defined(&HCI_CMD_READ_LOCAL_EXTENDED_FEATURES);
    eval 'sub HCI_OCF_READ_BUFFER_SIZE () {0x5;}' unless defined(&HCI_OCF_READ_BUFFER_SIZE);
    eval 'sub HCI_CMD_READ_BUFFER_SIZE () {0x1005;}' unless defined(&HCI_CMD_READ_BUFFER_SIZE);
    eval 'sub HCI_OCF_READ_COUNTRY_CODE () {0x7;}' unless defined(&HCI_OCF_READ_COUNTRY_CODE);
    eval 'sub HCI_CMD_READ_COUNTRY_CODE () {0x1007;}' unless defined(&HCI_CMD_READ_COUNTRY_CODE);
    eval 'sub HCI_OCF_READ_BDADDR () {0x9;}' unless defined(&HCI_OCF_READ_BDADDR);
    eval 'sub HCI_CMD_READ_BDADDR () {0x1009;}' unless defined(&HCI_CMD_READ_BDADDR);
    eval 'sub HCI_OGF_STATUS () {0x5;}' unless defined(&HCI_OGF_STATUS);
    eval 'sub HCI_OCF_READ_FAILED_CONTACT_CNTR () {0x1;}' unless defined(&HCI_OCF_READ_FAILED_CONTACT_CNTR);
    eval 'sub HCI_CMD_READ_FAILED_CONTACT_CNTR () {0x1401;}' unless defined(&HCI_CMD_READ_FAILED_CONTACT_CNTR);
    eval 'sub HCI_OCF_RESET_FAILED_CONTACT_CNTR () {0x2;}' unless defined(&HCI_OCF_RESET_FAILED_CONTACT_CNTR);
    eval 'sub HCI_CMD_RESET_FAILED_CONTACT_CNTR () {0x1402;}' unless defined(&HCI_CMD_RESET_FAILED_CONTACT_CNTR);
    eval 'sub HCI_OCF_READ_LINK_QUALITY () {0x3;}' unless defined(&HCI_OCF_READ_LINK_QUALITY);
    eval 'sub HCI_CMD_READ_LINK_QUALITY () {0x1403;}' unless defined(&HCI_CMD_READ_LINK_QUALITY);
    eval 'sub HCI_OCF_READ_RSSI () {0x5;}' unless defined(&HCI_OCF_READ_RSSI);
    eval 'sub HCI_CMD_READ_RSSI () {0x1405;}' unless defined(&HCI_CMD_READ_RSSI);
    eval 'sub HCI_OCF_READ_AFH_CHANNEL_MAP () {0x6;}' unless defined(&HCI_OCF_READ_AFH_CHANNEL_MAP);
    eval 'sub HCI_CMD_READ_AFH_CHANNEL_MAP () {0x1406;}' unless defined(&HCI_CMD_READ_AFH_CHANNEL_MAP);
    eval 'sub HCI_OCF_READ_CLOCK () {0x7;}' unless defined(&HCI_OCF_READ_CLOCK);
    eval 'sub HCI_CMD_READ_CLOCK () {0x1407;}' unless defined(&HCI_CMD_READ_CLOCK);
    eval 'sub HCI_OGF_TESTING () {0x6;}' unless defined(&HCI_OGF_TESTING);
    eval 'sub HCI_OCF_READ_LOOPBACK_MODE () {0x1;}' unless defined(&HCI_OCF_READ_LOOPBACK_MODE);
    eval 'sub HCI_CMD_READ_LOOPBACK_MODE () {0x1801;}' unless defined(&HCI_CMD_READ_LOOPBACK_MODE);
    eval 'sub HCI_OCF_WRITE_LOOPBACK_MODE () {0x2;}' unless defined(&HCI_OCF_WRITE_LOOPBACK_MODE);
    eval 'sub HCI_CMD_WRITE_LOOPBACK_MODE () {0x1802;}' unless defined(&HCI_CMD_WRITE_LOOPBACK_MODE);
    eval 'sub HCI_OCF_ENABLE_UNIT_UNDER_TEST () {0x3;}' unless defined(&HCI_OCF_ENABLE_UNIT_UNDER_TEST);
    eval 'sub HCI_CMD_ENABLE_UNIT_UNDER_TEST () {0x1803;}' unless defined(&HCI_CMD_ENABLE_UNIT_UNDER_TEST);
    eval 'sub HCI_OCF_WRITE_SIMPLE_PAIRING_DEBUG_MODE () {0x4;}' unless defined(&HCI_OCF_WRITE_SIMPLE_PAIRING_DEBUG_MODE);
    eval 'sub HCI_CMD_WRITE_SIMPLE_PAIRING_DEBUG_MODE () {0x1804;}' unless defined(&HCI_CMD_WRITE_SIMPLE_PAIRING_DEBUG_MODE);
    eval 'sub HCI_OGF_BT_LOGO () {0x3e;}' unless defined(&HCI_OGF_BT_LOGO);
    eval 'sub HCI_OGF_VENDOR () {0x3f;}' unless defined(&HCI_OGF_VENDOR);
    eval 'sub HCI_CMD_ERICSSON_WRITE_PCM_SETTINGS () {0xfc07;}' unless defined(&HCI_CMD_ERICSSON_WRITE_PCM_SETTINGS);
    eval 'sub HCI_CMD_ERICSSON_SET_UART_BAUD_RATE () {0xfc09;}' unless defined(&HCI_CMD_ERICSSON_SET_UART_BAUD_RATE);
    eval 'sub HCI_CMD_ERICSSON_SET_SCO_DATA_PATH () {0xfc1d;}' unless defined(&HCI_CMD_ERICSSON_SET_SCO_DATA_PATH);
    eval 'sub HCI_CMD_CSR_EXTN () {0xfc00;}' unless defined(&HCI_CMD_CSR_EXTN);
    eval 'sub HCI_EVENT_INQUIRY_COMPL () {0x1;}' unless defined(&HCI_EVENT_INQUIRY_COMPL);
    eval 'sub HCI_EVENT_INQUIRY_RESULT () {0x2;}' unless defined(&HCI_EVENT_INQUIRY_RESULT);
    eval 'sub HCI_EVENT_CON_COMPL () {0x3;}' unless defined(&HCI_EVENT_CON_COMPL);
    eval 'sub HCI_EVENT_CON_REQ () {0x4;}' unless defined(&HCI_EVENT_CON_REQ);
    eval 'sub HCI_EVENT_DISCON_COMPL () {0x5;}' unless defined(&HCI_EVENT_DISCON_COMPL);
    eval 'sub HCI_EVENT_AUTH_COMPL () {0x6;}' unless defined(&HCI_EVENT_AUTH_COMPL);
    eval 'sub HCI_EVENT_REMOTE_NAME_REQ_COMPL () {0x7;}' unless defined(&HCI_EVENT_REMOTE_NAME_REQ_COMPL);
    eval 'sub HCI_EVENT_ENCRYPTION_CHANGE () {0x8;}' unless defined(&HCI_EVENT_ENCRYPTION_CHANGE);
    eval 'sub HCI_EVENT_CHANGE_CON_LINK_KEY_COMPL () {0x9;}' unless defined(&HCI_EVENT_CHANGE_CON_LINK_KEY_COMPL);
    eval 'sub HCI_EVENT_MASTER_LINK_KEY_COMPL () {0xa;}' unless defined(&HCI_EVENT_MASTER_LINK_KEY_COMPL);
    eval 'sub HCI_EVENT_READ_REMOTE_FEATURES_COMPL () {0xb;}' unless defined(&HCI_EVENT_READ_REMOTE_FEATURES_COMPL);
    eval 'sub HCI_EVENT_READ_REMOTE_VER_INFO_COMPL () {0xc;}' unless defined(&HCI_EVENT_READ_REMOTE_VER_INFO_COMPL);
    eval 'sub HCI_EVENT_QOS_SETUP_COMPL () {0xd;}' unless defined(&HCI_EVENT_QOS_SETUP_COMPL);
    eval 'sub HCI_EVENT_COMMAND_COMPL () {0xe;}' unless defined(&HCI_EVENT_COMMAND_COMPL);
    eval 'sub HCI_EVENT_COMMAND_STATUS () {0xf;}' unless defined(&HCI_EVENT_COMMAND_STATUS);
    eval 'sub HCI_EVENT_HARDWARE_ERROR () {0x10;}' unless defined(&HCI_EVENT_HARDWARE_ERROR);
    eval 'sub HCI_EVENT_FLUSH_OCCUR () {0x11;}' unless defined(&HCI_EVENT_FLUSH_OCCUR);
    eval 'sub HCI_EVENT_ROLE_CHANGE () {0x12;}' unless defined(&HCI_EVENT_ROLE_CHANGE);
    eval 'sub HCI_EVENT_NUM_COMPL_PKTS () {0x13;}' unless defined(&HCI_EVENT_NUM_COMPL_PKTS);
    eval 'sub HCI_EVENT_MODE_CHANGE () {0x14;}' unless defined(&HCI_EVENT_MODE_CHANGE);
    eval 'sub HCI_EVENT_RETURN_LINK_KEYS () {0x15;}' unless defined(&HCI_EVENT_RETURN_LINK_KEYS);
    eval 'sub HCI_EVENT_PIN_CODE_REQ () {0x16;}' unless defined(&HCI_EVENT_PIN_CODE_REQ);
    eval 'sub HCI_EVENT_LINK_KEY_REQ () {0x17;}' unless defined(&HCI_EVENT_LINK_KEY_REQ);
    eval 'sub HCI_EVENT_LINK_KEY_NOTIFICATION () {0x18;}' unless defined(&HCI_EVENT_LINK_KEY_NOTIFICATION);
    eval 'sub HCI_EVENT_LOOPBACK_COMMAND () {0x19;}' unless defined(&HCI_EVENT_LOOPBACK_COMMAND);
    eval 'sub HCI_EVENT_DATA_BUFFER_OVERFLOW () {0x1a;}' unless defined(&HCI_EVENT_DATA_BUFFER_OVERFLOW);
    eval 'sub HCI_EVENT_MAX_SLOT_CHANGE () {0x1b;}' unless defined(&HCI_EVENT_MAX_SLOT_CHANGE);
    eval 'sub HCI_EVENT_READ_CLOCK_OFFSET_COMPL () {0x1c;}' unless defined(&HCI_EVENT_READ_CLOCK_OFFSET_COMPL);
    eval 'sub HCI_EVENT_CON_PKT_TYPE_CHANGED () {0x1d;}' unless defined(&HCI_EVENT_CON_PKT_TYPE_CHANGED);
    eval 'sub HCI_EVENT_QOS_VIOLATION () {0x1e;}' unless defined(&HCI_EVENT_QOS_VIOLATION);
    eval 'sub HCI_EVENT_PAGE_SCAN_MODE_CHANGE () {0x1f;}' unless defined(&HCI_EVENT_PAGE_SCAN_MODE_CHANGE);
    eval 'sub HCI_EVENT_PAGE_SCAN_REP_MODE_CHANGE () {0x20;}' unless defined(&HCI_EVENT_PAGE_SCAN_REP_MODE_CHANGE);
    eval 'sub HCI_EVENT_FLOW_SPECIFICATION_COMPL () {0x21;}' unless defined(&HCI_EVENT_FLOW_SPECIFICATION_COMPL);
    eval 'sub HCI_EVENT_RSSI_RESULT () {0x22;}' unless defined(&HCI_EVENT_RSSI_RESULT);
    eval 'sub HCI_EVENT_READ_REMOTE_EXTENDED_FEATURES () {0x23;}' unless defined(&HCI_EVENT_READ_REMOTE_EXTENDED_FEATURES);
    eval 'sub HCI_EVENT_SCO_CON_COMPL () {0x2c;}' unless defined(&HCI_EVENT_SCO_CON_COMPL);
    eval 'sub HCI_EVENT_SCO_CON_CHANGED () {0x2d;}' unless defined(&HCI_EVENT_SCO_CON_CHANGED);
    eval 'sub HCI_EVENT_SNIFF_SUBRATING () {0x2e;}' unless defined(&HCI_EVENT_SNIFF_SUBRATING);
    eval 'sub HCI_EVENT_EXTENDED_RESULT () {0x2f;}' unless defined(&HCI_EVENT_EXTENDED_RESULT);
    eval 'sub HCI_EVENT_ENCRYPTION_KEY_REFRESH () {0x30;}' unless defined(&HCI_EVENT_ENCRYPTION_KEY_REFRESH);
    eval 'sub HCI_EVENT_IO_CAPABILITY_REQ () {0x31;}' unless defined(&HCI_EVENT_IO_CAPABILITY_REQ);
    eval 'sub HCI_EVENT_IO_CAPABILITY_RSP () {0x32;}' unless defined(&HCI_EVENT_IO_CAPABILITY_RSP);
    eval 'sub HCI_EVENT_USER_CONFIRM_REQ () {0x33;}' unless defined(&HCI_EVENT_USER_CONFIRM_REQ);
    eval 'sub HCI_EVENT_USER_PASSKEY_REQ () {0x34;}' unless defined(&HCI_EVENT_USER_PASSKEY_REQ);
    eval 'sub HCI_EVENT_REMOTE_OOB_DATA_REQ () {0x35;}' unless defined(&HCI_EVENT_REMOTE_OOB_DATA_REQ);
    eval 'sub HCI_EVENT_SIMPLE_PAIRING_COMPL () {0x36;}' unless defined(&HCI_EVENT_SIMPLE_PAIRING_COMPL);
    eval 'sub HCI_EVENT_LINK_SUPERVISION_TO_CHANGED () {0x38;}' unless defined(&HCI_EVENT_LINK_SUPERVISION_TO_CHANGED);
    eval 'sub HCI_EVENT_ENHANCED_FLUSH_COMPL () {0x39;}' unless defined(&HCI_EVENT_ENHANCED_FLUSH_COMPL);
    eval 'sub HCI_EVENT_USER_PASSKEY_NOTIFICATION () {0x3b;}' unless defined(&HCI_EVENT_USER_PASSKEY_NOTIFICATION);
    eval 'sub HCI_EVENT_KEYPRESS_NOTIFICATION () {0x3c;}' unless defined(&HCI_EVENT_KEYPRESS_NOTIFICATION);
    eval 'sub HCI_EVENT_REMOTE_FEATURES_NOTIFICATION () {0x3d;}' unless defined(&HCI_EVENT_REMOTE_FEATURES_NOTIFICATION);
    eval 'sub HCI_EVENT_BT_LOGO () {0xfe;}' unless defined(&HCI_EVENT_BT_LOGO);
    eval 'sub HCI_EVENT_VENDOR () {0xff;}' unless defined(&HCI_EVENT_VENDOR);
    eval 'sub SO_HCI_EVT_FILTER () {1;}' unless defined(&SO_HCI_EVT_FILTER);
    eval 'sub SO_HCI_PKT_FILTER () {2;}' unless defined(&SO_HCI_PKT_FILTER);
    eval 'sub SO_HCI_DIRECTION () {3;}' unless defined(&SO_HCI_DIRECTION);
    eval 'sub SCM_HCI_DIRECTION () { &SO_HCI_DIRECTION;}' unless defined(&SCM_HCI_DIRECTION);
    eval 'sub hci_filter_set {
        my($bit,$filter) = @_;
	    eval q({  &uint8_t  &off = $bit - 1;  &off >>= 5;  ($filter->{mask[&off]}) |= (1<< (($bit - 1) & 0x1f)); });
    }' unless defined(&hci_filter_set);
    eval 'sub hci_filter_clr {
        my($bit,$filter) = @_;
	    eval q({  &uint8_t  &off = $bit - 1;  &off >>= 5;  ($filter->{mask[&off]}) &= ~(1<< (($bit - 1) & 0x1f)); });
    }' unless defined(&hci_filter_clr);
    eval 'sub hci_filter_test {
        my($bit,$filter) = @_;
	    eval q({  &uint8_t  &off = $bit - 1;  &off >>= 5; ( ($filter->{mask[&off]}) & (1<< (($bit - 1) & 0x1f))); });
    }' unless defined(&hci_filter_test);
    eval 'sub SIOCGBTINFO () { &_IOWR(ord(\'b\'), 5, \'struct btreq\');}' unless defined(&SIOCGBTINFO);
    eval 'sub SIOCGBTINFOA () { &_IOWR(ord(\'b\'), 6, \'struct btreq\');}' unless defined(&SIOCGBTINFOA);
    eval 'sub SIOCNBTINFO () { &_IOWR(ord(\'b\'), 7, \'struct btreq\');}' unless defined(&SIOCNBTINFO);
    eval 'sub SIOCSBTFLAGS () { &_IOWR(ord(\'b\'), 8, \'struct btreq\');}' unless defined(&SIOCSBTFLAGS);
    eval 'sub SIOCSBTPOLICY () { &_IOWR(ord(\'b\'), 9, \'struct btreq\');}' unless defined(&SIOCSBTPOLICY);
    eval 'sub SIOCSBTPTYPE () { &_IOWR(ord(\'b\'), 10, \'struct btreq\');}' unless defined(&SIOCSBTPTYPE);
    eval 'sub SIOCGBTSTATS () { &_IOWR(ord(\'b\'), 11, \'struct btreq\');}' unless defined(&SIOCGBTSTATS);
    eval 'sub SIOCZBTSTATS () { &_IOWR(ord(\'b\'), 12, \'struct btreq\');}' unless defined(&SIOCZBTSTATS);
    eval 'sub SIOCBTDUMP () { &_IOW(ord(\'b\'), 13, \'struct btreq\');}' unless defined(&SIOCBTDUMP);
    eval 'sub SIOCSBTSCOMTU () { &_IOWR(ord(\'b\'), 17, \'struct btreq\');}' unless defined(&SIOCSBTSCOMTU);
    eval 'sub btr_flags () { ($btru->{btri}->{btri_flags});}' unless defined(&btr_flags);
    eval 'sub btr_bdaddr () { ($btru->{btri}->{btri_bdaddr});}' unless defined(&btr_bdaddr);
    eval 'sub btr_num_cmd () { ($btru->{btri}->{btri_num_cmd});}' unless defined(&btr_num_cmd);
    eval 'sub btr_num_acl () { ($btru->{btri}->{btri_num_acl});}' unless defined(&btr_num_acl);
    eval 'sub btr_num_sco () { ($btru->{btri}->{btri_num_sco});}' unless defined(&btr_num_sco);
    eval 'sub btr_acl_mtu () { ($btru->{btri}->{btri_acl_mtu});}' unless defined(&btr_acl_mtu);
    eval 'sub btr_sco_mtu () { ($btru->{btri}->{btri_sco_mtu});}' unless defined(&btr_sco_mtu);
    eval 'sub btr_link_policy () { ($btru->{btri}->{btri_link_policy});}' unless defined(&btr_link_policy);
    eval 'sub btr_packet_type () { ($btru->{btri}->{btri_packet_type});}' unless defined(&btr_packet_type);
    eval 'sub btr_stats () { ($btru->{btrs});}' unless defined(&btr_stats);
    eval 'sub BTF_UP () {(1<<0);}' unless defined(&BTF_UP);
    eval 'sub BTF_RUNNING () {(1<<1);}' unless defined(&BTF_RUNNING);
    eval 'sub BTF_XMIT_CMD () {(1<<2);}' unless defined(&BTF_XMIT_CMD);
    eval 'sub BTF_XMIT_ACL () {(1<<3);}' unless defined(&BTF_XMIT_ACL);
    eval 'sub BTF_XMIT_SCO () {(1<<4);}' unless defined(&BTF_XMIT_SCO);
    eval 'sub BTF_XMIT () {( &BTF_XMIT_CMD |  &BTF_XMIT_ACL |  &BTF_XMIT_SCO);}' unless defined(&BTF_XMIT);
    eval 'sub BTF_INIT_BDADDR () {(1<<5);}' unless defined(&BTF_INIT_BDADDR);
    eval 'sub BTF_INIT_BUFFER_SIZE () {(1<<6);}' unless defined(&BTF_INIT_BUFFER_SIZE);
    eval 'sub BTF_INIT_FEATURES () {(1<<7);}' unless defined(&BTF_INIT_FEATURES);
    eval 'sub BTF_POWER_UP_NOOP () {(1<<8);}' unless defined(&BTF_POWER_UP_NOOP);
    eval 'sub BTF_INIT_COMMANDS () {(1<<9);}' unless defined(&BTF_INIT_COMMANDS);
    eval 'sub BTF_INIT () {( &BTF_INIT_BDADDR |  &BTF_INIT_BUFFER_SIZE |  &BTF_INIT_FEATURES |  &BTF_INIT_COMMANDS);}' unless defined(&BTF_INIT);
    if(defined(&_KERNEL)) {
	require 'net/if.ph';
	eval 'sub HCI_LINK_CLOSED () {0;}' unless defined(&HCI_LINK_CLOSED);
	eval 'sub HCI_LINK_WAIT_CONNECT () {1;}' unless defined(&HCI_LINK_WAIT_CONNECT);
	eval 'sub HCI_LINK_WAIT_AUTH () {2;}' unless defined(&HCI_LINK_WAIT_AUTH);
	eval 'sub HCI_LINK_WAIT_ENCRYPT () {3;}' unless defined(&HCI_LINK_WAIT_ENCRYPT);
	eval 'sub HCI_LINK_WAIT_SECURE () {4;}' unless defined(&HCI_LINK_WAIT_SECURE);
	eval 'sub HCI_LINK_OPEN () {5;}' unless defined(&HCI_LINK_OPEN);
	eval 'sub HCI_LINK_BLOCK () {6;}' unless defined(&HCI_LINK_BLOCK);
	eval 'sub HCI_LINK_AUTH_REQ () {(1<<0);}' unless defined(&HCI_LINK_AUTH_REQ);
	eval 'sub HCI_LINK_ENCRYPT_REQ () {(1<<1);}' unless defined(&HCI_LINK_ENCRYPT_REQ);
	eval 'sub HCI_LINK_SECURE_REQ () {(1<<2);}' unless defined(&HCI_LINK_SECURE_REQ);
	eval 'sub HCI_LINK_AUTH () {(1<<3);}' unless defined(&HCI_LINK_AUTH);
	eval 'sub HCI_LINK_ENCRYPT () {(1<<4);}' unless defined(&HCI_LINK_ENCRYPT);
	eval 'sub HCI_LINK_SECURE () {(1<<5);}' unless defined(&HCI_LINK_SECURE);
	unless(defined(&__OpenBSD__)) {
	}
	eval 'sub M_GETCTX {
	    my($m, $t) = @_;
    	    eval q((($t)($m)-> ($m_pkthdr->{rcvif})));
	}' unless defined(&M_GETCTX);
	eval 'sub M_SETCTX {
	    my($m, $c) = @_;
    	    eval q((($m)-> ($m_pkthdr->{r$cvif}) = ( &void *)($c)));
	}' unless defined(&M_SETCTX);
	eval 'sub splraiseipl {
	    my($ipl) = @_;
    	    eval q( &splbio());
	}' unless defined(&splraiseipl);
	eval 'sub ENOLINK () { &ENOENT;}' unless defined(&ENOLINK);
	eval 'sub EPASSTHROUGH () { &ENOTTY;}' unless defined(&EPASSTHROUGH);
	eval 'sub device_xname {
	    my($dv) = @_;
    	    eval q(($dv)-> &dv_xname);
	}' unless defined(&device_xname);
    }
}
1;
