require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I915_DRV_H_)) {
    eval 'sub _I915_DRV_H_ () {1;}' unless defined(&_I915_DRV_H_);
    eval 'sub DRIVER_AUTHOR () {"Tungsten Graphics, Inc.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"i915";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"Intel Graphics";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20070209";}' unless defined(&DRIVER_DATE);
    if(defined( &__linux__)) {
	eval 'sub I915_HAVE_FENCE () {1;}' unless defined(&I915_HAVE_FENCE);
	eval 'sub I915_HAVE_BUFFER () {1;}' unless defined(&I915_HAVE_BUFFER);
    }
    eval 'sub DRIVER_MAJOR () {1;}' unless defined(&DRIVER_MAJOR);
    if(defined( &I915_HAVE_FENCE)  && defined( &I915_HAVE_BUFFER)) {
	eval 'sub DRIVER_MINOR () {11;}' unless defined(&DRIVER_MINOR);
    } else {
	eval 'sub DRIVER_MINOR () {6;}' unless defined(&DRIVER_MINOR);
    }
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    if(defined(&I915_HAVE_BUFFER)) {
	eval 'sub I915_MAX_VALIDATE_BUFFERS () {4096;}' unless defined(&I915_MAX_VALIDATE_BUFFERS);
    }
    if(defined(&I915_HAVE_FENCE)) {
    }
    if(defined(&I915_HAVE_BUFFER)) {
    }
    eval("sub CHIP_I8XX () { 0x01; }") unless defined(&CHIP_I8XX);
    eval("sub CHIP_I9XX () { 0x02; }") unless defined(&CHIP_I9XX);
    eval("sub CHIP_I915 () { 0x04; }") unless defined(&CHIP_I915);
    eval("sub CHIP_I965 () { 0x08; }") unless defined(&CHIP_I965);
    if(defined(&I915_HAVE_FENCE)) {
    }
    if(defined(&I915_HAVE_BUFFER)) {
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,6,25)) {
    }
    eval 'sub I915_READ {
        my($reg) = @_;
	    eval q( &DRM_READ32( ($dev_priv->{mmio_map}), ($reg)));
    }' unless defined(&I915_READ);
    eval 'sub I915_WRITE {
        my($reg,$val) = @_;
	    eval q( &DRM_WRITE32( ($dev_priv->{mmio_map}), ($reg), ($val)));
    }' unless defined(&I915_WRITE);
    eval 'sub I915_READ16 {
        my($reg) = @_;
	    eval q( &DRM_READ16( ($dev_priv->{mmio_map}), ($reg)));
    }' unless defined(&I915_READ16);
    eval 'sub I915_WRITE16 {
        my($reg,$val) = @_;
	    eval q( &DRM_WRITE16( ($dev_priv->{mmio_map}), ($reg), ($val)));
    }' unless defined(&I915_WRITE16);
    eval 'sub I915_VERBOSE () {0;}' unless defined(&I915_VERBOSE);
    eval 'sub RING_LOCALS () {\'unsigned int outring\',  &ringmask,  &outcount;  &volatile \'char\' * &virt;;}' unless defined(&RING_LOCALS);
    eval 'sub BEGIN_LP_RING {
        my($n) = @_;
	    eval q( &do {  &if ( &I915_VERBOSE)  &DRM_DEBUG(\\"BEGIN_LP_RING(%d) in %s\\\\n\\", ($n),  &__FUNCTION__);  &if ( ($dev_priv->{ring}->{space}) < ($n)*4)  &i915_wait_ring( &dev, ($n)*4,  &__FUNCTION__);  &outcount = 0;  &outring =  ($dev_priv->{ring}->{tail});  &ringmask =  ($dev_priv->{ring}->{tail_mask});  &virt =  ($dev_priv->{ring}->{virtual_start}); }  &while (0));
    }' unless defined(&BEGIN_LP_RING);
    eval 'sub OUT_RING {
        my($n) = @_;
	    eval q( &do {  &if ( &I915_VERBOSE)  &DRM_DEBUG(\\"   OUT_RING %x\\\\n\\", ($n)); *( &volatile \'unsigned int\' *)( &virt +  &outring) = ($n);  &outcount++;  &outring += 4;  &outring &=  &ringmask; }  &while (0));
    }' unless defined(&OUT_RING);
    eval 'sub ADVANCE_LP_RING () {
        eval q( &do {  &if ( &I915_VERBOSE)  &DRM_DEBUG(\\"ADVANCE_LP_RING %x\\\\n\\",  &outring);  ($dev_priv->{ring}->{tail}) =  &outring;  ($dev_priv->{ring}->{space}) -=  &outcount * 4;  &I915_WRITE( &LP_RING +  &RING_TAIL,  &outring); }  &while(0));
    }' unless defined(&ADVANCE_LP_RING);
    eval 'sub LBB () {0xf4;}' unless defined(&LBB);
    eval 'sub VGA_ST01_MDA () {0x3ba;}' unless defined(&VGA_ST01_MDA);
    eval 'sub VGA_ST01_CGA () {0x3da;}' unless defined(&VGA_ST01_CGA);
    eval 'sub VGA_MSR_WRITE () {0x3c2;}' unless defined(&VGA_MSR_WRITE);
    eval 'sub VGA_MSR_READ () {0x3cc;}' unless defined(&VGA_MSR_READ);
    eval 'sub VGA_MSR_MEM_EN () {(1<<1);}' unless defined(&VGA_MSR_MEM_EN);
    eval 'sub VGA_MSR_CGA_MODE () {(1<<0);}' unless defined(&VGA_MSR_CGA_MODE);
    eval 'sub VGA_SR_INDEX () {0x3c4;}' unless defined(&VGA_SR_INDEX);
    eval 'sub VGA_SR_DATA () {0x3c5;}' unless defined(&VGA_SR_DATA);
    eval 'sub VGA_AR_INDEX () {0x3c0;}' unless defined(&VGA_AR_INDEX);
    eval 'sub VGA_AR_VID_EN () {(1<<5);}' unless defined(&VGA_AR_VID_EN);
    eval 'sub VGA_AR_DATA_WRITE () {0x3c0;}' unless defined(&VGA_AR_DATA_WRITE);
    eval 'sub VGA_AR_DATA_READ () {0x3c1;}' unless defined(&VGA_AR_DATA_READ);
    eval 'sub VGA_GR_INDEX () {0x3ce;}' unless defined(&VGA_GR_INDEX);
    eval 'sub VGA_GR_DATA () {0x3cf;}' unless defined(&VGA_GR_DATA);
    eval 'sub VGA_GR_MEM_READ_MODE_SHIFT () {3;}' unless defined(&VGA_GR_MEM_READ_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_READ_MODE_PLANE () {1;}' unless defined(&VGA_GR_MEM_READ_MODE_PLANE);
    eval 'sub VGA_GR_MEM_MODE_MASK () {0xc;}' unless defined(&VGA_GR_MEM_MODE_MASK);
    eval 'sub VGA_GR_MEM_MODE_SHIFT () {2;}' unless defined(&VGA_GR_MEM_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_A0000_AFFFF () {0;}' unless defined(&VGA_GR_MEM_A0000_AFFFF);
    eval 'sub VGA_GR_MEM_A0000_BFFFF () {1;}' unless defined(&VGA_GR_MEM_A0000_BFFFF);
    eval 'sub VGA_GR_MEM_B0000_B7FFF () {2;}' unless defined(&VGA_GR_MEM_B0000_B7FFF);
    eval 'sub VGA_GR_MEM_B0000_BFFFF () {3;}' unless defined(&VGA_GR_MEM_B0000_BFFFF);
    eval 'sub VGA_DACMASK () {0x3c6;}' unless defined(&VGA_DACMASK);
    eval 'sub VGA_DACRX () {0x3c7;}' unless defined(&VGA_DACRX);
    eval 'sub VGA_DACWX () {0x3c8;}' unless defined(&VGA_DACWX);
    eval 'sub VGA_DACDATA () {0x3c9;}' unless defined(&VGA_DACDATA);
    eval 'sub VGA_CR_INDEX_MDA () {0x3b4;}' unless defined(&VGA_CR_INDEX_MDA);
    eval 'sub VGA_CR_DATA_MDA () {0x3b5;}' unless defined(&VGA_CR_DATA_MDA);
    eval 'sub VGA_CR_INDEX_CGA () {0x3d4;}' unless defined(&VGA_CR_INDEX_CGA);
    eval 'sub VGA_CR_DATA_CGA () {0x3d5;}' unless defined(&VGA_CR_DATA_CGA);
    eval 'sub GFX_OP_USER_INTERRUPT () {((0<<29)|(2<<23));}' unless defined(&GFX_OP_USER_INTERRUPT);
    eval 'sub GFX_OP_BREAKPOINT_INTERRUPT () {((0<<29)|(1<<23));}' unless defined(&GFX_OP_BREAKPOINT_INTERRUPT);
    eval 'sub CMD_REPORT_HEAD () {(7<<23);}' unless defined(&CMD_REPORT_HEAD);
    eval 'sub CMD_STORE_DWORD_IDX () {((0x21<<23) | 0x1);}' unless defined(&CMD_STORE_DWORD_IDX);
    eval 'sub CMD_OP_BATCH_BUFFER () {((0x<<29)|(0x30<<23)|0x1);}' unless defined(&CMD_OP_BATCH_BUFFER);
    eval 'sub CMD_MI_FLUSH () {(0x4 << 23);}' unless defined(&CMD_MI_FLUSH);
    eval 'sub MI_NO_WRITE_FLUSH () {(1<< 2);}' unless defined(&MI_NO_WRITE_FLUSH);
    eval 'sub MI_READ_FLUSH () {(1<< 0);}' unless defined(&MI_READ_FLUSH);
    eval 'sub MI_EXE_FLUSH () {(1<< 1);}' unless defined(&MI_EXE_FLUSH);
    eval 'sub MI_END_SCENE () {(1<< 4);}' unless defined(&MI_END_SCENE);
    eval 'sub MI_SCENE_COUNT () {(1<< 3);}' unless defined(&MI_SCENE_COUNT);
    eval 'sub CMD_MI_LOAD_REGISTER_IMM () {((0x22 << 23)|0x1);}' unless defined(&CMD_MI_LOAD_REGISTER_IMM);
    eval 'sub BB1_START_ADDR_MASK () {(~0x7);}' unless defined(&BB1_START_ADDR_MASK);
    eval 'sub BB1_PROTECTED () {(1<<0);}' unless defined(&BB1_PROTECTED);
    eval 'sub BB1_UNPROTECTED () {(0<<0);}' unless defined(&BB1_UNPROTECTED);
    eval 'sub BB2_END_ADDR_MASK () {(~0x7);}' unless defined(&BB2_END_ADDR_MASK);
    eval 'sub FBC_CFB_BASE () {0x3200;}' unless defined(&FBC_CFB_BASE);
    eval 'sub FBC_LL_BASE () {0x3204;}' unless defined(&FBC_LL_BASE);
    eval 'sub FBC_CONTROL () {0x3208;}' unless defined(&FBC_CONTROL);
    eval 'sub FBC_CTL_EN () {(1<<31);}' unless defined(&FBC_CTL_EN);
    eval 'sub FBC_CTL_PERIODIC () {(1<<30);}' unless defined(&FBC_CTL_PERIODIC);
    eval 'sub FBC_CTL_INTERVAL_SHIFT () {(16);}' unless defined(&FBC_CTL_INTERVAL_SHIFT);
    eval 'sub FBC_CTL_UNCOMPRESSIBLE () {(1<<14);}' unless defined(&FBC_CTL_UNCOMPRESSIBLE);
    eval 'sub FBC_CTL_STRIDE_SHIFT () {(5);}' unless defined(&FBC_CTL_STRIDE_SHIFT);
    eval 'sub FBC_CTL_FENCENO () {(1<<0);}' unless defined(&FBC_CTL_FENCENO);
    eval 'sub FBC_COMMAND () {0x320c;}' unless defined(&FBC_COMMAND);
    eval 'sub FBC_CMD_COMPRESS () {(1<<0);}' unless defined(&FBC_CMD_COMPRESS);
    eval 'sub FBC_STATUS () {0x3210;}' unless defined(&FBC_STATUS);
    eval 'sub FBC_STAT_COMPRESSING () {(1<<31);}' unless defined(&FBC_STAT_COMPRESSING);
    eval 'sub FBC_STAT_COMPRESSED () {(1<<30);}' unless defined(&FBC_STAT_COMPRESSED);
    eval 'sub FBC_STAT_MODIFIED () {(1<<29);}' unless defined(&FBC_STAT_MODIFIED);
    eval 'sub FBC_STAT_CURRENT_LINE () {(1<<0);}' unless defined(&FBC_STAT_CURRENT_LINE);
    eval 'sub FBC_CONTROL2 () {0x3214;}' unless defined(&FBC_CONTROL2);
    eval 'sub FBC_CTL_FENCE_DBL () {(0<<4);}' unless defined(&FBC_CTL_FENCE_DBL);
    eval 'sub FBC_CTL_IDLE_IMM () {(0<<2);}' unless defined(&FBC_CTL_IDLE_IMM);
    eval 'sub FBC_CTL_IDLE_FULL () {(1<<2);}' unless defined(&FBC_CTL_IDLE_FULL);
    eval 'sub FBC_CTL_IDLE_LINE () {(2<<2);}' unless defined(&FBC_CTL_IDLE_LINE);
    eval 'sub FBC_CTL_IDLE_DEBUG () {(3<<2);}' unless defined(&FBC_CTL_IDLE_DEBUG);
    eval 'sub FBC_CTL_CPU_FENCE () {(1<<1);}' unless defined(&FBC_CTL_CPU_FENCE);
    eval 'sub FBC_CTL_PLANEA () {(0<<0);}' unless defined(&FBC_CTL_PLANEA);
    eval 'sub FBC_CTL_PLANEB () {(1<<0);}' unless defined(&FBC_CTL_PLANEB);
    eval 'sub FBC_FENCE_OFF () {0x321b;}' unless defined(&FBC_FENCE_OFF);
    eval 'sub FBC_LL_SIZE () {(1536);}' unless defined(&FBC_LL_SIZE);
    eval 'sub FBC_LL_PAD () {(32);}' unless defined(&FBC_LL_PAD);
    eval 'sub USER_INT_FLAG () {(1<<1);}' unless defined(&USER_INT_FLAG);
    eval 'sub VSYNC_PIPEB_FLAG () {(1<<5);}' unless defined(&VSYNC_PIPEB_FLAG);
    eval 'sub VSYNC_PIPEA_FLAG () {(1<<7);}' unless defined(&VSYNC_PIPEA_FLAG);
    eval 'sub HWB_OOM_FLAG () {(1<<13);}' unless defined(&HWB_OOM_FLAG);
    eval 'sub I915REG_HWSTAM () {0x2098;}' unless defined(&I915REG_HWSTAM);
    eval 'sub I915REG_INT_IDENTITY_R () {0x20a4;}' unless defined(&I915REG_INT_IDENTITY_R);
    eval 'sub I915REG_INT_MASK_R () {0x20a8;}' unless defined(&I915REG_INT_MASK_R);
    eval 'sub I915REG_INT_ENABLE_R () {0x20a0;}' unless defined(&I915REG_INT_ENABLE_R);
    eval 'sub I915REG_INSTPM () {0x20c0;}' unless defined(&I915REG_INSTPM);
    eval 'sub I915REG_PIPEASTAT () {0x70024;}' unless defined(&I915REG_PIPEASTAT);
    eval 'sub I915REG_PIPEBSTAT () {0x71024;}' unless defined(&I915REG_PIPEBSTAT);
    eval 'sub I915_VBLANK_INTERRUPT_ENABLE () {(1<<17);}' unless defined(&I915_VBLANK_INTERRUPT_ENABLE);
    eval 'sub I915_VBLANK_CLEAR () {(1<<1);}' unless defined(&I915_VBLANK_CLEAR);
    eval 'sub SRX_INDEX () {0x3c4;}' unless defined(&SRX_INDEX);
    eval 'sub SRX_DATA () {0x3c5;}' unless defined(&SRX_DATA);
    eval 'sub SR01 () {1;}' unless defined(&SR01);
    eval 'sub SR01_SCREEN_OFF () {(1<<5);}' unless defined(&SR01_SCREEN_OFF);
    eval 'sub PPCR () {0x61204;}' unless defined(&PPCR);
    eval 'sub PPCR_ON () {(1<<0);}' unless defined(&PPCR_ON);
    eval 'sub DVOB () {0x61140;}' unless defined(&DVOB);
    eval 'sub DVOB_ON () {(1<<31);}' unless defined(&DVOB_ON);
    eval 'sub DVOC () {0x61160;}' unless defined(&DVOC);
    eval 'sub DVOC_ON () {(1<<31);}' unless defined(&DVOC_ON);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_ON () {(1<<31);}' unless defined(&LVDS_ON);
    eval 'sub ADPA () {0x61100;}' unless defined(&ADPA);
    eval 'sub ADPA_DPMS_MASK () {(~(3<<10));}' unless defined(&ADPA_DPMS_MASK);
    eval 'sub ADPA_DPMS_ON () {(0<<10);}' unless defined(&ADPA_DPMS_ON);
    eval 'sub ADPA_DPMS_SUSPEND () {(1<<10);}' unless defined(&ADPA_DPMS_SUSPEND);
    eval 'sub ADPA_DPMS_STANDBY () {(2<<10);}' unless defined(&ADPA_DPMS_STANDBY);
    eval 'sub ADPA_DPMS_OFF () {(3<<10);}' unless defined(&ADPA_DPMS_OFF);
    eval 'sub NOPID () {0x2094;}' unless defined(&NOPID);
    eval 'sub LP_RING () {0x2030;}' unless defined(&LP_RING);
    eval 'sub HP_RING () {0x2040;}' unless defined(&HP_RING);
    eval 'sub HWB_RING () {0x2400;}' unless defined(&HWB_RING);
    eval 'sub RING_TAIL () {0x;}' unless defined(&RING_TAIL);
    eval 'sub TAIL_ADDR () {0x1ffff8;}' unless defined(&TAIL_ADDR);
    eval 'sub RING_HEAD () {0x4;}' unless defined(&RING_HEAD);
    eval 'sub HEAD_WRAP_COUNT () {0xffe00000;}' unless defined(&HEAD_WRAP_COUNT);
    eval 'sub HEAD_WRAP_ONE () {0x200000;}' unless defined(&HEAD_WRAP_ONE);
    eval 'sub HEAD_ADDR () {0x1ffffc;}' unless defined(&HEAD_ADDR);
    eval 'sub RING_START () {0x8;}' unless defined(&RING_START);
    eval 'sub START_ADDR () {0x &xFFFFF000;}' unless defined(&START_ADDR);
    eval 'sub RING_LEN () {0xc;}' unless defined(&RING_LEN);
    eval 'sub RING_NR_PAGES () {0x1ff000;}' unless defined(&RING_NR_PAGES);
    eval 'sub RING_REPORT_MASK () {0x6;}' unless defined(&RING_REPORT_MASK);
    eval 'sub RING_REPORT_64K () {0x2;}' unless defined(&RING_REPORT_64K);
    eval 'sub RING_REPORT_128K () {0x4;}' unless defined(&RING_REPORT_128K);
    eval 'sub RING_NO_REPORT () {0x;}' unless defined(&RING_NO_REPORT);
    eval 'sub RING_VALID_MASK () {0x1;}' unless defined(&RING_VALID_MASK);
    eval 'sub RING_VALID () {0x1;}' unless defined(&RING_VALID);
    eval 'sub RING_INVALID () {0x;}' unless defined(&RING_INVALID);
    eval 'sub IPEIR () {0x2088;}' unless defined(&IPEIR);
    eval 'sub SCPD0 () {0x209c;}' unless defined(&SCPD0);
    eval 'sub ESR () {0x20b8;}' unless defined(&ESR);
    eval 'sub DMA_FADD_S () {0x20d4;}' unless defined(&DMA_FADD_S);
    eval 'sub Cache_Mode_0 () {0x2120;}' unless defined(&Cache_Mode_0);
    eval 'sub CM0_MASK_SHIFT () {16;}' unless defined(&CM0_MASK_SHIFT);
    eval 'sub CM0_IZ_OPT_DISABLE () {(1<<6);}' unless defined(&CM0_IZ_OPT_DISABLE);
    eval 'sub CM0_ZR_OPT_DISABLE () {(1<<5);}' unless defined(&CM0_ZR_OPT_DISABLE);
    eval 'sub CM0_DEPTH_EVICT_DISABLE () {(1<<4);}' unless defined(&CM0_DEPTH_EVICT_DISABLE);
    eval 'sub CM0_COLOR_EVICT_DISABLE () {(1<<3);}' unless defined(&CM0_COLOR_EVICT_DISABLE);
    eval 'sub CM0_DEPTH_WRITE_DISABLE () {(1<<1);}' unless defined(&CM0_DEPTH_WRITE_DISABLE);
    eval 'sub CM0_RC_OP_FLUSH_DISABLE () {(1<<0);}' unless defined(&CM0_RC_OP_FLUSH_DISABLE);
    eval 'sub GFX_FLSH_CNTL () {0x2170;}' unless defined(&GFX_FLSH_CNTL);
    eval 'sub BINCTL () {0x2420;}' unless defined(&BINCTL);
    eval 'sub BC_MASK () {(1<< 9);}' unless defined(&BC_MASK);
    eval 'sub BINSCENE () {0x2428;}' unless defined(&BINSCENE);
    eval 'sub BS_OP_LOAD () {(1<< 8);}' unless defined(&BS_OP_LOAD);
    eval 'sub BS_MASK () {(1<< 22);}' unless defined(&BS_MASK);
    eval 'sub BCPD () {0x2480;}' unless defined(&BCPD);
    eval 'sub BMCD () {0x2484;}' unless defined(&BMCD);
    eval 'sub BDCD () {0x2488;}' unless defined(&BDCD);
    eval 'sub BPCD () {0x248c;}' unless defined(&BPCD);
    eval 'sub BINSKPD () {0x24f0;}' unless defined(&BINSKPD);
    eval 'sub HWBSKPD () {0x24f4;}' unless defined(&HWBSKPD);
    eval 'sub BMP_BUFFER () {0x2430;}' unless defined(&BMP_BUFFER);
    eval 'sub BMP_PAGE_SIZE_4K () {(0<< 10);}' unless defined(&BMP_PAGE_SIZE_4K);
    eval 'sub BMP_BUFFER_SIZE_SHIFT () {1;}' unless defined(&BMP_BUFFER_SIZE_SHIFT);
    eval 'sub BMP_ENABLE () {(1<< 0);}' unless defined(&BMP_ENABLE);
    eval 'sub BMP_GET () {0x2438;}' unless defined(&BMP_GET);
    eval 'sub BMP_PUT () {0x2440;}' unless defined(&BMP_PUT);
    eval 'sub BMP_OFFSET_SHIFT () {5;}' unless defined(&BMP_OFFSET_SHIFT);
    eval 'sub GFX_OP_RASTER_RULES () {((0x3<<29)|(0x7<<24));}' unless defined(&GFX_OP_RASTER_RULES);
    eval 'sub GFX_OP_SCISSOR () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR);
    eval 'sub SC_UPDATE_SCISSOR () {(0x1<<1);}' unless defined(&SC_UPDATE_SCISSOR);
    eval 'sub SC_ENABLE_MASK () {(0x1<<0);}' unless defined(&SC_ENABLE_MASK);
    eval 'sub SC_ENABLE () {(0x1<<0);}' unless defined(&SC_ENABLE);
    eval 'sub GFX_OP_LOAD_INDIRECT () {((0x3<<29)|(0x1d<<24)|(0x7<<16));}' unless defined(&GFX_OP_LOAD_INDIRECT);
    eval 'sub GFX_OP_SCISSOR_INFO () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|(0x1));}' unless defined(&GFX_OP_SCISSOR_INFO);
    eval 'sub SCI_YMIN_MASK () {(0xffff<<16);}' unless defined(&SCI_YMIN_MASK);
    eval 'sub SCI_XMIN_MASK () {(0xffff<<0);}' unless defined(&SCI_XMIN_MASK);
    eval 'sub SCI_YMAX_MASK () {(0xffff<<16);}' unless defined(&SCI_YMAX_MASK);
    eval 'sub SCI_XMAX_MASK () {(0xffff<<0);}' unless defined(&SCI_XMAX_MASK);
    eval 'sub GFX_OP_SCISSOR_ENABLE () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR_ENABLE);
    eval 'sub GFX_OP_SCISSOR_RECT () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|1);}' unless defined(&GFX_OP_SCISSOR_RECT);
    eval 'sub GFX_OP_COLOR_FACTOR () {((0x3<<29)|(0x1d<<24)|(0x1<<16)|0x);}' unless defined(&GFX_OP_COLOR_FACTOR);
    eval 'sub GFX_OP_STIPPLE () {((0x3<<29)|(0x1d<<24)|(0x83<<16));}' unless defined(&GFX_OP_STIPPLE);
    eval 'sub GFX_OP_MAP_INFO () {((0x3<<29)|(0x1d<<24)|0x4);}' unless defined(&GFX_OP_MAP_INFO);
    eval 'sub GFX_OP_DESTBUFFER_VARS () {((0x3<<29)|(0x1d<<24)|(0x85<<16)|0x);}' unless defined(&GFX_OP_DESTBUFFER_VARS);
    eval 'sub GFX_OP_DRAWRECT_INFO () {((0x3<<29)|(0x1d<<24)|(0x80<<16)|(0x3));}' unless defined(&GFX_OP_DRAWRECT_INFO);
    eval 'sub GFX_OP_DRAWRECT_INFO_I965 () {((0x7900<<16)|0x2);}' unless defined(&GFX_OP_DRAWRECT_INFO_I965);
    eval 'sub SRC_COPY_BLT_CMD () {((2<<29)|(0x43<<22)|4);}' unless defined(&SRC_COPY_BLT_CMD);
    eval 'sub XY_SRC_COPY_BLT_CMD () {((2<<29)|(0x53<<22)|6);}' unless defined(&XY_SRC_COPY_BLT_CMD);
    eval 'sub XY_SRC_COPY_BLT_WRITE_ALPHA () {(1<<21);}' unless defined(&XY_SRC_COPY_BLT_WRITE_ALPHA);
    eval 'sub XY_SRC_COPY_BLT_WRITE_RGB () {(1<<20);}' unless defined(&XY_SRC_COPY_BLT_WRITE_RGB);
    eval 'sub MI_BATCH_BUFFER () {((0x30<<23)|1);}' unless defined(&MI_BATCH_BUFFER);
    eval 'sub MI_BATCH_BUFFER_START () {(0x31<<23);}' unless defined(&MI_BATCH_BUFFER_START);
    eval 'sub MI_BATCH_BUFFER_END () {(0xa<<23);}' unless defined(&MI_BATCH_BUFFER_END);
    eval 'sub MI_BATCH_NON_SECURE () {(1);}' unless defined(&MI_BATCH_NON_SECURE);
    eval 'sub MI_BATCH_NON_SECURE_I965 () {(1<<8);}' unless defined(&MI_BATCH_NON_SECURE_I965);
    eval 'sub MI_WAIT_FOR_EVENT () {((0x3<<23));}' unless defined(&MI_WAIT_FOR_EVENT);
    eval 'sub MI_WAIT_FOR_PLANE_B_FLIP () {(1<<6);}' unless defined(&MI_WAIT_FOR_PLANE_B_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_FLIP () {(1<<2);}' unless defined(&MI_WAIT_FOR_PLANE_A_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_SCANLINES () {(1<<1);}' unless defined(&MI_WAIT_FOR_PLANE_A_SCANLINES);
    eval 'sub MI_LOAD_SCAN_LINES_INCL () {((0x12<<23));}' unless defined(&MI_LOAD_SCAN_LINES_INCL);
    eval 'sub CMD_OP_DISPLAYBUFFER_INFO () {((0x<<29)|(0x14<<23)|2);}' unless defined(&CMD_OP_DISPLAYBUFFER_INFO);
    eval 'sub ASYNC_FLIP () {(1<<22);}' unless defined(&ASYNC_FLIP);
    eval 'sub DISPLAY_PLANE_A () {(0<<20);}' unless defined(&DISPLAY_PLANE_A);
    eval 'sub DISPLAY_PLANE_B () {(1<<20);}' unless defined(&DISPLAY_PLANE_B);
    eval 'sub DSPACNTR () {0x70180;}' unless defined(&DSPACNTR);
    eval 'sub DSPBCNTR () {0x71180;}' unless defined(&DSPBCNTR);
    eval 'sub DISPPLANE_SEL_PIPE_MASK () {(1<<24);}' unless defined(&DISPPLANE_SEL_PIPE_MASK);
    eval 'sub CMD_OP_BIN_CONTROL () {((0x3<<29)|(0x1d<<24)|(0x84<<16)|4);}' unless defined(&CMD_OP_BIN_CONTROL);
    eval 'sub CMD_OP_DESTBUFFER_INFO () {((0x3<<29)|(0x1d<<24)|(0x8e<<16)|1);}' unless defined(&CMD_OP_DESTBUFFER_INFO);
    eval 'sub BREADCRUMB_BITS () {31;}' unless defined(&BREADCRUMB_BITS);
    eval 'sub BREADCRUMB_MASK () {((1 <<  &BREADCRUMB_BITS) - 1);}' unless defined(&BREADCRUMB_MASK);
    eval 'sub READ_BREADCRUMB {
        my($dev_priv) = @_;
	    eval q(((( &volatile  &u32*)( ($dev_priv->{hw_status_page})))[5]));
    }' unless defined(&READ_BREADCRUMB);
    eval 'sub READ_HWSP {
        my($dev_priv, $reg) = @_;
	    eval q(((( &volatile  &u32*)( ($dev_priv->{hw_status_page})))[$reg]));
    }' unless defined(&READ_HWSP);
    eval 'sub BLC_PWM_CTL () {0x61254;}' unless defined(&BLC_PWM_CTL);
    eval 'sub BACKLIGHT_MODULATION_FREQ_SHIFT () {(17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_SHIFT);
    eval 'sub BLC_PWM_CTL2 () {0x61250;}' unless defined(&BLC_PWM_CTL2);
    eval 'sub BACKLIGHT_MODULATION_FREQ_MASK () {(0x7fff << 17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_MASK);
    eval 'sub BLM_LEGACY_MODE () {(1<< 16);}' unless defined(&BLM_LEGACY_MODE);
    eval 'sub BACKLIGHT_DUTY_CYCLE_SHIFT () {(0);}' unless defined(&BACKLIGHT_DUTY_CYCLE_SHIFT);
    eval 'sub BACKLIGHT_DUTY_CYCLE_MASK () {(0xffff);}' unless defined(&BACKLIGHT_DUTY_CYCLE_MASK);
    eval 'sub I915_GCFGC () {0xf0;}' unless defined(&I915_GCFGC);
    eval 'sub I915_LOW_FREQUENCY_ENABLE () {(1<< 7);}' unless defined(&I915_LOW_FREQUENCY_ENABLE);
    eval 'sub I915_DISPLAY_CLOCK_190_200_MHZ () {(0<< 4);}' unless defined(&I915_DISPLAY_CLOCK_190_200_MHZ);
    eval 'sub I915_DISPLAY_CLOCK_333_MHZ () {(4<< 4);}' unless defined(&I915_DISPLAY_CLOCK_333_MHZ);
    eval 'sub I915_DISPLAY_CLOCK_MASK () {(7<< 4);}' unless defined(&I915_DISPLAY_CLOCK_MASK);
    eval 'sub I855_HPLLCC () {0xc0;}' unless defined(&I855_HPLLCC);
    eval 'sub I855_CLOCK_CONTROL_MASK () {(3<< 0);}' unless defined(&I855_CLOCK_CONTROL_MASK);
    eval 'sub I855_CLOCK_133_200 () {(0<< 0);}' unless defined(&I855_CLOCK_133_200);
    eval 'sub I855_CLOCK_100_200 () {(1<< 0);}' unless defined(&I855_CLOCK_100_200);
    eval 'sub I855_CLOCK_100_133 () {(2<< 0);}' unless defined(&I855_CLOCK_100_133);
    eval 'sub I855_CLOCK_166_250 () {(3<< 0);}' unless defined(&I855_CLOCK_166_250);
    eval 'sub VCLK2_VCO_M () {0x6008;}' unless defined(&VCLK2_VCO_M);
    eval 'sub VCLK2_VCO_N () {0x600a;}' unless defined(&VCLK2_VCO_N);
    eval 'sub VCLK2_VCO_DIV_SEL () {0x6012;}' unless defined(&VCLK2_VCO_DIV_SEL);
    eval 'sub VCLK_DIVISOR_VGA0 () {0x6000;}' unless defined(&VCLK_DIVISOR_VGA0);
    eval 'sub VCLK_DIVISOR_VGA1 () {0x6004;}' unless defined(&VCLK_DIVISOR_VGA1);
    eval 'sub VCLK_POST_DIV () {0x6010;}' unless defined(&VCLK_POST_DIV);
    eval 'sub VGA1_PD_P2_DIV_4 () {(1<< 15);}' unless defined(&VGA1_PD_P2_DIV_4);
    eval 'sub VGA1_PD_P1_DIV_2 () {(1<< 13);}' unless defined(&VGA1_PD_P1_DIV_2);
    eval 'sub VGA1_PD_P1_SHIFT () {8;}' unless defined(&VGA1_PD_P1_SHIFT);
    eval 'sub VGA1_PD_P1_MASK () {(0x1f << 8);}' unless defined(&VGA1_PD_P1_MASK);
    eval 'sub VGA0_PD_P2_DIV_4 () {(1<< 7);}' unless defined(&VGA0_PD_P2_DIV_4);
    eval 'sub VGA0_PD_P1_DIV_2 () {(1<< 5);}' unless defined(&VGA0_PD_P1_DIV_2);
    eval 'sub VGA0_PD_P1_SHIFT () {0;}' unless defined(&VGA0_PD_P1_SHIFT);
    eval 'sub VGA0_PD_P1_MASK () {(0x1f << 0);}' unless defined(&VGA0_PD_P1_MASK);
    eval 'sub HTOTAL_A () {0x60000;}' unless defined(&HTOTAL_A);
    eval 'sub HBLANK_A () {0x60004;}' unless defined(&HBLANK_A);
    eval 'sub HSYNC_A () {0x60008;}' unless defined(&HSYNC_A);
    eval 'sub VTOTAL_A () {0x6000c;}' unless defined(&VTOTAL_A);
    eval 'sub VBLANK_A () {0x60010;}' unless defined(&VBLANK_A);
    eval 'sub VSYNC_A () {0x60014;}' unless defined(&VSYNC_A);
    eval 'sub PIPEASRC () {0x6001c;}' unless defined(&PIPEASRC);
    eval 'sub BCLRPAT_A () {0x60020;}' unless defined(&BCLRPAT_A);
    eval 'sub VSYNCSHIFT_A () {0x60028;}' unless defined(&VSYNCSHIFT_A);
    eval 'sub HTOTAL_B () {0x61000;}' unless defined(&HTOTAL_B);
    eval 'sub HBLANK_B () {0x61004;}' unless defined(&HBLANK_B);
    eval 'sub HSYNC_B () {0x61008;}' unless defined(&HSYNC_B);
    eval 'sub VTOTAL_B () {0x6100c;}' unless defined(&VTOTAL_B);
    eval 'sub VBLANK_B () {0x61010;}' unless defined(&VBLANK_B);
    eval 'sub VSYNC_B () {0x61014;}' unless defined(&VSYNC_B);
    eval 'sub PIPEBSRC () {0x6101c;}' unless defined(&PIPEBSRC);
    eval 'sub BCLRPAT_B () {0x61020;}' unless defined(&BCLRPAT_B);
    eval 'sub VSYNCSHIFT_B () {0x61028;}' unless defined(&VSYNCSHIFT_B);
    eval 'sub PP_STATUS () {0x61200;}' unless defined(&PP_STATUS);
    eval 'sub PP_ON () {(1<< 31);}' unless defined(&PP_ON);
    eval 'sub PP_READY () {(1<< 30);}' unless defined(&PP_READY);
    eval 'sub PP_SEQUENCE_NONE () {(0<< 28);}' unless defined(&PP_SEQUENCE_NONE);
    eval 'sub PP_SEQUENCE_ON () {(1<< 28);}' unless defined(&PP_SEQUENCE_ON);
    eval 'sub PP_SEQUENCE_OFF () {(2<< 28);}' unless defined(&PP_SEQUENCE_OFF);
    eval 'sub PP_SEQUENCE_MASK () {0x30000000;}' unless defined(&PP_SEQUENCE_MASK);
    eval 'sub PP_CONTROL () {0x61204;}' unless defined(&PP_CONTROL);
    eval 'sub POWER_TARGET_ON () {(1<< 0);}' unless defined(&POWER_TARGET_ON);
    eval 'sub LVDSPP_ON () {0x61208;}' unless defined(&LVDSPP_ON);
    eval 'sub LVDSPP_OFF () {0x6120c;}' unless defined(&LVDSPP_OFF);
    eval 'sub PP_CYCLE () {0x61210;}' unless defined(&PP_CYCLE);
    eval 'sub PFIT_CONTROL () {0x61230;}' unless defined(&PFIT_CONTROL);
    eval 'sub PFIT_ENABLE () {(1<< 31);}' unless defined(&PFIT_ENABLE);
    eval 'sub PFIT_PIPE_MASK () {(3<< 29);}' unless defined(&PFIT_PIPE_MASK);
    eval 'sub PFIT_PIPE_SHIFT () {29;}' unless defined(&PFIT_PIPE_SHIFT);
    eval 'sub VERT_INTERP_DISABLE () {(0<< 10);}' unless defined(&VERT_INTERP_DISABLE);
    eval 'sub VERT_INTERP_BILINEAR () {(1<< 10);}' unless defined(&VERT_INTERP_BILINEAR);
    eval 'sub VERT_INTERP_MASK () {(3<< 10);}' unless defined(&VERT_INTERP_MASK);
    eval 'sub VERT_AUTO_SCALE () {(1<< 9);}' unless defined(&VERT_AUTO_SCALE);
    eval 'sub HORIZ_INTERP_DISABLE () {(0<< 6);}' unless defined(&HORIZ_INTERP_DISABLE);
    eval 'sub HORIZ_INTERP_BILINEAR () {(1<< 6);}' unless defined(&HORIZ_INTERP_BILINEAR);
    eval 'sub HORIZ_INTERP_MASK () {(3<< 6);}' unless defined(&HORIZ_INTERP_MASK);
    eval 'sub HORIZ_AUTO_SCALE () {(1<< 5);}' unless defined(&HORIZ_AUTO_SCALE);
    eval 'sub PANEL_8TO6_DITHER_ENABLE () {(1<< 3);}' unless defined(&PANEL_8TO6_DITHER_ENABLE);
    eval 'sub PFIT_PGM_RATIOS () {0x61234;}' unless defined(&PFIT_PGM_RATIOS);
    eval 'sub PFIT_VERT_SCALE_MASK () {0xfff00000;}' unless defined(&PFIT_VERT_SCALE_MASK);
    eval 'sub PFIT_HORIZ_SCALE_MASK () {0xfff0;}' unless defined(&PFIT_HORIZ_SCALE_MASK);
    eval 'sub PFIT_AUTO_RATIOS () {0x61238;}' unless defined(&PFIT_AUTO_RATIOS);
    eval 'sub DPLL_A () {0x6014;}' unless defined(&DPLL_A);
    eval 'sub DPLL_B () {0x6018;}' unless defined(&DPLL_B);
    eval 'sub DPLL_VCO_ENABLE () {(1<< 31);}' unless defined(&DPLL_VCO_ENABLE);
    eval 'sub DPLL_DVO_HIGH_SPEED () {(1<< 30);}' unless defined(&DPLL_DVO_HIGH_SPEED);
    eval 'sub DPLL_SYNCLOCK_ENABLE () {(1<< 29);}' unless defined(&DPLL_SYNCLOCK_ENABLE);
    eval 'sub DPLL_VGA_MODE_DIS () {(1<< 28);}' unless defined(&DPLL_VGA_MODE_DIS);
    eval 'sub DPLLB_MODE_DAC_SERIAL () {(1<< 26);}' unless defined(&DPLLB_MODE_DAC_SERIAL);
    eval 'sub DPLLB_MODE_LVDS () {(2<< 26);}' unless defined(&DPLLB_MODE_LVDS);
    eval 'sub DPLL_MODE_MASK () {(3<< 26);}' unless defined(&DPLL_MODE_MASK);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_10 () {(0<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_10);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_5 () {(1<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_5);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_14 () {(0<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_14);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_7 () {(1<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_7);
    eval 'sub DPLL_P2_CLOCK_DIV_MASK () {0x3000000;}' unless defined(&DPLL_P2_CLOCK_DIV_MASK);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK () {0xff0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830 () {0x1f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS () {0x3f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS);
    eval 'sub DPLL_FPA01_P1_POST_DIV_SHIFT () {16;}' unless defined(&DPLL_FPA01_P1_POST_DIV_SHIFT);
    eval 'sub PLL_P2_DIVIDE_BY_4 () {(1<< 23);}' unless defined(&PLL_P2_DIVIDE_BY_4);
    eval 'sub PLL_P1_DIVIDE_BY_TWO () {(1<< 21);}' unless defined(&PLL_P1_DIVIDE_BY_TWO);
    eval 'sub PLL_REF_INPUT_DREFCLK () {(0<< 13);}' unless defined(&PLL_REF_INPUT_DREFCLK);
    eval 'sub PLL_REF_INPUT_TVCLKINA () {(1<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINA);
    eval 'sub PLL_REF_INPUT_TVCLKINBC () {(2<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINBC);
    eval 'sub PLLB_REF_INPUT_SPREADSPECTRUMIN () {(3<< 13);}' unless defined(&PLLB_REF_INPUT_SPREADSPECTRUMIN);
    eval 'sub PLL_REF_INPUT_MASK () {(3<< 13);}' unless defined(&PLL_REF_INPUT_MASK);
    eval 'sub PLL_LOAD_PULSE_PHASE_SHIFT () {9;}' unless defined(&PLL_LOAD_PULSE_PHASE_SHIFT);
    eval 'sub PLL_LOAD_PULSE_PHASE_MASK () {(0xf <<  &PLL_LOAD_PULSE_PHASE_SHIFT);}' unless defined(&PLL_LOAD_PULSE_PHASE_MASK);
    eval 'sub DISPLAY_RATE_SELECT_FPA1 () {(1<< 8);}' unless defined(&DISPLAY_RATE_SELECT_FPA1);
    eval 'sub SDVO_MULTIPLIER_MASK () {0xff;}' unless defined(&SDVO_MULTIPLIER_MASK);
    eval 'sub SDVO_MULTIPLIER_SHIFT_HIRES () {4;}' unless defined(&SDVO_MULTIPLIER_SHIFT_HIRES);
    eval 'sub SDVO_MULTIPLIER_SHIFT_VGA () {0;}' unless defined(&SDVO_MULTIPLIER_SHIFT_VGA);
    eval 'sub DPLL_A_MD () {0x601c;}' unless defined(&DPLL_A_MD);
    eval 'sub DPLL_B_MD () {0x6020;}' unless defined(&DPLL_B_MD);
    eval 'sub DPLL_MD_UDI_DIVIDER_MASK () {0x3f000000;}' unless defined(&DPLL_MD_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_UDI_DIVIDER_SHIFT () {24;}' unless defined(&DPLL_MD_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_MASK () {0x3f0000;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_SHIFT () {16;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_MASK () {0x3f00;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_SHIFT () {8;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_MASK () {0x3f;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT () {0;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT);
    eval 'sub DPLL_TEST () {0x606c;}' unless defined(&DPLL_TEST);
    eval 'sub DPLLB_TEST_SDVO_DIV_1 () {(0<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_1);
    eval 'sub DPLLB_TEST_SDVO_DIV_2 () {(1<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_2);
    eval 'sub DPLLB_TEST_SDVO_DIV_4 () {(2<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_4);
    eval 'sub DPLLB_TEST_SDVO_DIV_MASK () {(3<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_MASK);
    eval 'sub DPLLB_TEST_N_BYPASS () {(1<< 19);}' unless defined(&DPLLB_TEST_N_BYPASS);
    eval 'sub DPLLB_TEST_M_BYPASS () {(1<< 18);}' unless defined(&DPLLB_TEST_M_BYPASS);
    eval 'sub DPLLB_INPUT_BUFFER_ENABLE () {(1<< 16);}' unless defined(&DPLLB_INPUT_BUFFER_ENABLE);
    eval 'sub DPLLA_TEST_N_BYPASS () {(1<< 3);}' unless defined(&DPLLA_TEST_N_BYPASS);
    eval 'sub DPLLA_TEST_M_BYPASS () {(1<< 2);}' unless defined(&DPLLA_TEST_M_BYPASS);
    eval 'sub DPLLA_INPUT_BUFFER_ENABLE () {(1<< 0);}' unless defined(&DPLLA_INPUT_BUFFER_ENABLE);
    eval 'sub ADPA () {0x61100;}' unless defined(&ADPA);
    eval 'sub ADPA_DAC_ENABLE () {(1<<31);}' unless defined(&ADPA_DAC_ENABLE);
    eval 'sub ADPA_DAC_DISABLE () {0;}' unless defined(&ADPA_DAC_DISABLE);
    eval 'sub ADPA_PIPE_SELECT_MASK () {(1<<30);}' unless defined(&ADPA_PIPE_SELECT_MASK);
    eval 'sub ADPA_PIPE_A_SELECT () {0;}' unless defined(&ADPA_PIPE_A_SELECT);
    eval 'sub ADPA_PIPE_B_SELECT () {(1<<30);}' unless defined(&ADPA_PIPE_B_SELECT);
    eval 'sub ADPA_USE_VGA_HVPOLARITY () {(1<<15);}' unless defined(&ADPA_USE_VGA_HVPOLARITY);
    eval 'sub ADPA_SETS_HVPOLARITY () {0;}' unless defined(&ADPA_SETS_HVPOLARITY);
    eval 'sub ADPA_VSYNC_CNTL_DISABLE () {(1<<11);}' unless defined(&ADPA_VSYNC_CNTL_DISABLE);
    eval 'sub ADPA_VSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_VSYNC_CNTL_ENABLE);
    eval 'sub ADPA_HSYNC_CNTL_DISABLE () {(1<<10);}' unless defined(&ADPA_HSYNC_CNTL_DISABLE);
    eval 'sub ADPA_HSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_HSYNC_CNTL_ENABLE);
    eval 'sub ADPA_VSYNC_ACTIVE_HIGH () {(1<<4);}' unless defined(&ADPA_VSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_VSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_VSYNC_ACTIVE_LOW);
    eval 'sub ADPA_HSYNC_ACTIVE_HIGH () {(1<<3);}' unless defined(&ADPA_HSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_HSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_HSYNC_ACTIVE_LOW);
    eval 'sub FPA0 () {0x6040;}' unless defined(&FPA0);
    eval 'sub FPA1 () {0x6044;}' unless defined(&FPA1);
    eval 'sub FPB0 () {0x6048;}' unless defined(&FPB0);
    eval 'sub FPB1 () {0x604c;}' unless defined(&FPB1);
    eval 'sub FP_N_DIV_MASK () {0x3f0000;}' unless defined(&FP_N_DIV_MASK);
    eval 'sub FP_N_DIV_SHIFT () {16;}' unless defined(&FP_N_DIV_SHIFT);
    eval 'sub FP_M1_DIV_MASK () {0x3f00;}' unless defined(&FP_M1_DIV_MASK);
    eval 'sub FP_M1_DIV_SHIFT () {8;}' unless defined(&FP_M1_DIV_SHIFT);
    eval 'sub FP_M2_DIV_MASK () {0x3f;}' unless defined(&FP_M2_DIV_MASK);
    eval 'sub FP_M2_DIV_SHIFT () {0;}' unless defined(&FP_M2_DIV_SHIFT);
    eval 'sub PORT_HOTPLUG_EN () {0x61110;}' unless defined(&PORT_HOTPLUG_EN);
    eval 'sub SDVOB_HOTPLUG_INT_EN () {(1<< 26);}' unless defined(&SDVOB_HOTPLUG_INT_EN);
    eval 'sub SDVOC_HOTPLUG_INT_EN () {(1<< 25);}' unless defined(&SDVOC_HOTPLUG_INT_EN);
    eval 'sub TV_HOTPLUG_INT_EN () {(1<< 18);}' unless defined(&TV_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_INT_EN () {(1<< 9);}' unless defined(&CRT_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_FORCE_DETECT () {(1<< 3);}' unless defined(&CRT_HOTPLUG_FORCE_DETECT);
    eval 'sub PORT_HOTPLUG_STAT () {0x61114;}' unless defined(&PORT_HOTPLUG_STAT);
    eval 'sub CRT_HOTPLUG_INT_STATUS () {(1<< 11);}' unless defined(&CRT_HOTPLUG_INT_STATUS);
    eval 'sub TV_HOTPLUG_INT_STATUS () {(1<< 10);}' unless defined(&TV_HOTPLUG_INT_STATUS);
    eval 'sub CRT_HOTPLUG_MONITOR_MASK () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MASK);
    eval 'sub CRT_HOTPLUG_MONITOR_COLOR () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_COLOR);
    eval 'sub CRT_HOTPLUG_MONITOR_MONO () {(2<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MONO);
    eval 'sub CRT_HOTPLUG_MONITOR_NONE () {(0<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_NONE);
    eval 'sub SDVOC_HOTPLUG_INT_STATUS () {(1<< 7);}' unless defined(&SDVOC_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB_HOTPLUG_INT_STATUS () {(1<< 6);}' unless defined(&SDVOB_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB () {0x61140;}' unless defined(&SDVOB);
    eval 'sub SDVOC () {0x61160;}' unless defined(&SDVOC);
    eval 'sub SDVO_ENABLE () {(1<< 31);}' unless defined(&SDVO_ENABLE);
    eval 'sub SDVO_PIPE_B_SELECT () {(1<< 30);}' unless defined(&SDVO_PIPE_B_SELECT);
    eval 'sub SDVO_STALL_SELECT () {(1<< 29);}' unless defined(&SDVO_STALL_SELECT);
    eval 'sub SDVO_INTERRUPT_ENABLE () {(1<< 26);}' unless defined(&SDVO_INTERRUPT_ENABLE);
    eval 'sub SDVO_PORT_MULTIPLY_MASK () {(7<< 23);}' unless defined(&SDVO_PORT_MULTIPLY_MASK);
    eval 'sub SDVO_PORT_MULTIPLY_SHIFT () {23;}' unless defined(&SDVO_PORT_MULTIPLY_SHIFT);
    eval 'sub SDVO_PHASE_SELECT_MASK () {(15<< 19);}' unless defined(&SDVO_PHASE_SELECT_MASK);
    eval 'sub SDVO_PHASE_SELECT_DEFAULT () {(6<< 19);}' unless defined(&SDVO_PHASE_SELECT_DEFAULT);
    eval 'sub SDVO_CLOCK_OUTPUT_INVERT () {(1<< 18);}' unless defined(&SDVO_CLOCK_OUTPUT_INVERT);
    eval 'sub SDVOC_GANG_MODE () {(1<< 16);}' unless defined(&SDVOC_GANG_MODE);
    eval 'sub SDVO_BORDER_ENABLE () {(1<< 7);}' unless defined(&SDVO_BORDER_ENABLE);
    eval 'sub SDVOB_PCIE_CONCURRENCY () {(1<< 3);}' unless defined(&SDVOB_PCIE_CONCURRENCY);
    eval 'sub SDVO_DETECTED () {(1<< 2);}' unless defined(&SDVO_DETECTED);
    eval 'sub SDVOB_PRESERVE_MASK () {((1<< 17) | (1<< 16) | (1<< 14));}' unless defined(&SDVOB_PRESERVE_MASK);
    eval 'sub SDVOC_PRESERVE_MASK () {(1<< 17);}' unless defined(&SDVOC_PRESERVE_MASK);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_PORT_EN () {(1<< 31);}' unless defined(&LVDS_PORT_EN);
    eval 'sub LVDS_PIPEB_SELECT () {(1<< 30);}' unless defined(&LVDS_PIPEB_SELECT);
    eval 'sub LVDS_A0A2_CLKA_POWER_MASK () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_MASK);
    eval 'sub LVDS_A0A2_CLKA_POWER_DOWN () {(0<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_DOWN);
    eval 'sub LVDS_A0A2_CLKA_POWER_UP () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_UP);
    eval 'sub LVDS_A3_POWER_MASK () {(3<< 6);}' unless defined(&LVDS_A3_POWER_MASK);
    eval 'sub LVDS_A3_POWER_DOWN () {(0<< 6);}' unless defined(&LVDS_A3_POWER_DOWN);
    eval 'sub LVDS_A3_POWER_UP () {(3<< 6);}' unless defined(&LVDS_A3_POWER_UP);
    eval 'sub LVDS_CLKB_POWER_MASK () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_MASK);
    eval 'sub LVDS_CLKB_POWER_DOWN () {(0<< 4);}' unless defined(&LVDS_CLKB_POWER_DOWN);
    eval 'sub LVDS_CLKB_POWER_UP () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_UP);
    eval 'sub LVDS_B0B3_POWER_MASK () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_MASK);
    eval 'sub LVDS_B0B3_POWER_DOWN () {(0<< 2);}' unless defined(&LVDS_B0B3_POWER_DOWN);
    eval 'sub LVDS_B0B3_POWER_UP () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_UP);
    eval 'sub PIPEACONF () {0x70008;}' unless defined(&PIPEACONF);
    eval 'sub PIPEACONF_ENABLE () {(1<<31);}' unless defined(&PIPEACONF_ENABLE);
    eval 'sub PIPEACONF_DISABLE () {0;}' unless defined(&PIPEACONF_DISABLE);
    eval 'sub PIPEACONF_DOUBLE_WIDE () {(1<<30);}' unless defined(&PIPEACONF_DOUBLE_WIDE);
    eval 'sub I965_PIPECONF_ACTIVE () {(1<<30);}' unless defined(&I965_PIPECONF_ACTIVE);
    eval 'sub PIPEACONF_SINGLE_WIDE () {0;}' unless defined(&PIPEACONF_SINGLE_WIDE);
    eval 'sub PIPEACONF_PIPE_UNLOCKED () {0;}' unless defined(&PIPEACONF_PIPE_UNLOCKED);
    eval 'sub PIPEACONF_PIPE_LOCKED () {(1<<25);}' unless defined(&PIPEACONF_PIPE_LOCKED);
    eval 'sub PIPEACONF_PALETTE () {0;}' unless defined(&PIPEACONF_PALETTE);
    eval 'sub PIPEACONF_GAMMA () {(1<<24);}' unless defined(&PIPEACONF_GAMMA);
    eval 'sub PIPECONF_FORCE_BORDER () {(1<<25);}' unless defined(&PIPECONF_FORCE_BORDER);
    eval 'sub PIPECONF_PROGRESSIVE () {(0<< 21);}' unless defined(&PIPECONF_PROGRESSIVE);
    eval 'sub PIPECONF_INTERLACE_W_FIELD_INDICATION () {(6<< 21);}' unless defined(&PIPECONF_INTERLACE_W_FIELD_INDICATION);
    eval 'sub PIPECONF_INTERLACE_FIELD_0_ONLY () {(7<< 21);}' unless defined(&PIPECONF_INTERLACE_FIELD_0_ONLY);
    eval 'sub PIPEBCONF () {0x71008;}' unless defined(&PIPEBCONF);
    eval 'sub PIPEBCONF_ENABLE () {(1<<31);}' unless defined(&PIPEBCONF_ENABLE);
    eval 'sub PIPEBCONF_DISABLE () {0;}' unless defined(&PIPEBCONF_DISABLE);
    eval 'sub PIPEBCONF_DOUBLE_WIDE () {(1<<30);}' unless defined(&PIPEBCONF_DOUBLE_WIDE);
    eval 'sub PIPEBCONF_DISABLE () {0;}' unless defined(&PIPEBCONF_DISABLE);
    eval 'sub PIPEBCONF_GAMMA () {(1<<24);}' unless defined(&PIPEBCONF_GAMMA);
    eval 'sub PIPEBCONF_PALETTE () {0;}' unless defined(&PIPEBCONF_PALETTE);
    eval 'sub PIPEBGCMAXRED () {0x71010;}' unless defined(&PIPEBGCMAXRED);
    eval 'sub PIPEBGCMAXGREEN () {0x71014;}' unless defined(&PIPEBGCMAXGREEN);
    eval 'sub PIPEBGCMAXBLUE () {0x71018;}' unless defined(&PIPEBGCMAXBLUE);
    eval 'sub PIPEBSTAT () {0x71024;}' unless defined(&PIPEBSTAT);
    eval 'sub PIPEBFRAMEHIGH () {0x71040;}' unless defined(&PIPEBFRAMEHIGH);
    eval 'sub PIPEBFRAMEPIXEL () {0x71044;}' unless defined(&PIPEBFRAMEPIXEL);
    eval 'sub DSPACNTR () {0x70180;}' unless defined(&DSPACNTR);
    eval 'sub DSPBCNTR () {0x71180;}' unless defined(&DSPBCNTR);
    eval 'sub DISPLAY_PLANE_ENABLE () {(1<<31);}' unless defined(&DISPLAY_PLANE_ENABLE);
    eval 'sub DISPLAY_PLANE_DISABLE () {0;}' unless defined(&DISPLAY_PLANE_DISABLE);
    eval 'sub DISPPLANE_GAMMA_ENABLE () {(1<<30);}' unless defined(&DISPPLANE_GAMMA_ENABLE);
    eval 'sub DISPPLANE_GAMMA_DISABLE () {0;}' unless defined(&DISPPLANE_GAMMA_DISABLE);
    eval 'sub DISPPLANE_PIXFORMAT_MASK () {(0xf<<26);}' unless defined(&DISPPLANE_PIXFORMAT_MASK);
    eval 'sub DISPPLANE_8BPP () {(0x2<<26);}' unless defined(&DISPPLANE_8BPP);
    eval 'sub DISPPLANE_15_16BPP () {(0x4<<26);}' unless defined(&DISPPLANE_15_16BPP);
    eval 'sub DISPPLANE_16BPP () {(0x5<<26);}' unless defined(&DISPPLANE_16BPP);
    eval 'sub DISPPLANE_32BPP_NO_ALPHA () {(0x6<<26);}' unless defined(&DISPPLANE_32BPP_NO_ALPHA);
    eval 'sub DISPPLANE_32BPP () {(0x7<<26);}' unless defined(&DISPPLANE_32BPP);
    eval 'sub DISPPLANE_STEREO_ENABLE () {(1<<25);}' unless defined(&DISPPLANE_STEREO_ENABLE);
    eval 'sub DISPPLANE_STEREO_DISABLE () {0;}' unless defined(&DISPPLANE_STEREO_DISABLE);
    eval 'sub DISPPLANE_SEL_PIPE_MASK () {(1<<24);}' unless defined(&DISPPLANE_SEL_PIPE_MASK);
    eval 'sub DISPPLANE_SEL_PIPE_A () {0;}' unless defined(&DISPPLANE_SEL_PIPE_A);
    eval 'sub DISPPLANE_SEL_PIPE_B () {(1<<24);}' unless defined(&DISPPLANE_SEL_PIPE_B);
    eval 'sub DISPPLANE_SRC_KEY_ENABLE () {(1<<22);}' unless defined(&DISPPLANE_SRC_KEY_ENABLE);
    eval 'sub DISPPLANE_SRC_KEY_DISABLE () {0;}' unless defined(&DISPPLANE_SRC_KEY_DISABLE);
    eval 'sub DISPPLANE_LINE_DOUBLE () {(1<<20);}' unless defined(&DISPPLANE_LINE_DOUBLE);
    eval 'sub DISPPLANE_NO_LINE_DOUBLE () {0;}' unless defined(&DISPPLANE_NO_LINE_DOUBLE);
    eval 'sub DISPPLANE_STEREO_POLARITY_FIRST () {0;}' unless defined(&DISPPLANE_STEREO_POLARITY_FIRST);
    eval 'sub DISPPLANE_STEREO_POLARITY_SECOND () {(1<<18);}' unless defined(&DISPPLANE_STEREO_POLARITY_SECOND);
    eval 'sub DISPPLANE_ALPHA_TRANS_ENABLE () {(1<<15);}' unless defined(&DISPPLANE_ALPHA_TRANS_ENABLE);
    eval 'sub DISPPLANE_ALPHA_TRANS_DISABLE () {0;}' unless defined(&DISPPLANE_ALPHA_TRANS_DISABLE);
    eval 'sub DISPPLANE_SPRITE_ABOVE_DISPLAYA () {0;}' unless defined(&DISPPLANE_SPRITE_ABOVE_DISPLAYA);
    eval 'sub DISPPLANE_SPRITE_ABOVE_OVERLAY () {(1);}' unless defined(&DISPPLANE_SPRITE_ABOVE_OVERLAY);
    eval 'sub DSPABASE () {0x70184;}' unless defined(&DSPABASE);
    eval 'sub DSPASTRIDE () {0x70188;}' unless defined(&DSPASTRIDE);
    eval 'sub DSPBBASE () {0x71184;}' unless defined(&DSPBBASE);
    eval 'sub DSPBADDR () { &DSPBBASE;}' unless defined(&DSPBADDR);
    eval 'sub DSPBSTRIDE () {0x71188;}' unless defined(&DSPBSTRIDE);
    eval 'sub DSPAKEYVAL () {0x70194;}' unless defined(&DSPAKEYVAL);
    eval 'sub DSPAKEYMASK () {0x70198;}' unless defined(&DSPAKEYMASK);
    eval 'sub DSPAPOS () {0x7018c;}' unless defined(&DSPAPOS);
    eval 'sub DSPASIZE () {0x70190;}' unless defined(&DSPASIZE);
    eval 'sub DSPBPOS () {0x7118c;}' unless defined(&DSPBPOS);
    eval 'sub DSPBSIZE () {0x71190;}' unless defined(&DSPBSIZE);
    eval 'sub DSPASURF () {0x7019c;}' unless defined(&DSPASURF);
    eval 'sub DSPATILEOFF () {0x701a4;}' unless defined(&DSPATILEOFF);
    eval 'sub DSPBSURF () {0x7119c;}' unless defined(&DSPBSURF);
    eval 'sub DSPBTILEOFF () {0x711a4;}' unless defined(&DSPBTILEOFF);
    eval 'sub VGACNTRL () {0x71400;}' unless defined(&VGACNTRL);
    eval 'sub VGA_DISP_DISABLE () {(1<< 31);}' unless defined(&VGA_DISP_DISABLE);
    eval 'sub VGA_2X_MODE () {(1<< 30);}' unless defined(&VGA_2X_MODE);
    eval 'sub VGA_PIPE_B_SELECT () {(1<< 29);}' unless defined(&VGA_PIPE_B_SELECT);
    eval 'sub SWF0 () {0x71410;}' unless defined(&SWF0);
    eval 'sub SWF10 () {0x70410;}' unless defined(&SWF10);
    eval 'sub SWF30 () {0x72414;}' unless defined(&SWF30);
    eval 'sub OVADD () {0x30000;}' unless defined(&OVADD);
    eval 'sub DOVSTA () {0x30008;}' unless defined(&DOVSTA);
    eval 'sub OC_BUF () {(0x3<<20);}' unless defined(&OC_BUF);
    eval 'sub OGAMC5 () {0x30010;}' unless defined(&OGAMC5);
    eval 'sub OGAMC4 () {0x30014;}' unless defined(&OGAMC4);
    eval 'sub OGAMC3 () {0x30018;}' unless defined(&OGAMC3);
    eval 'sub OGAMC2 () {0x3001c;}' unless defined(&OGAMC2);
    eval 'sub OGAMC1 () {0x30020;}' unless defined(&OGAMC1);
    eval 'sub OGAMC0 () {0x30024;}' unless defined(&OGAMC0);
    eval 'sub PALETTE_A () {0xa000;}' unless defined(&PALETTE_A);
    eval 'sub PALETTE_B () {0xa800;}' unless defined(&PALETTE_B);
    eval 'sub IS_I830 {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82830_CGC));
    }' unless defined(&IS_I830);
    eval 'sub IS_845G {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82845G_IG));
    }' unless defined(&IS_845G);
    eval 'sub IS_I85X {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82855GM_IG));
    }' unless defined(&IS_I85X);
    eval 'sub IS_I855 {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82855GM_IG));
    }' unless defined(&IS_I855);
    eval 'sub IS_I865G {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82865_IG));
    }' unless defined(&IS_I865G);
    if(defined(&__OpenBSD__)) {
	eval 'sub IS_I915G {
	    my($dev) = @_;
    	    eval q(( ($dev->{pci_device}) ==  &PCI_PRODUCT_INTEL_82915G_IGD_1));
	}' unless defined(&IS_I915G);
	eval 'sub IS_I915GM {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_PRODUCT_INTEL_82915GM_IGD_1));
	}' unless defined(&IS_I915GM);
	eval 'sub IS_I945G {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_PRODUCT_INTEL_82945G_IGD_1));
	}' unless defined(&IS_I945G);
	eval 'sub IS_I945GM {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_PRODUCT_INTEL_82945GM_IGD_1));
	}' unless defined(&IS_I945GM);
    } else {
	eval 'sub IS_I915G {
	    my($dev) = @_;
    	    eval q(( ($dev->{pci_device}) ==  &PCI_DEVICE_ID_INTEL_82915G_IG));
	}' unless defined(&IS_I915G);
	eval 'sub IS_I915GM {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82915GM_IG));
	}' unless defined(&IS_I915GM);
	eval 'sub IS_I945G {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82945G_IG));
	}' unless defined(&IS_I945G);
	eval 'sub IS_I945GM {
	    my($dev) = @_;
    	    eval q((($dev)-> &pci_device ==  &PCI_DEVICE_ID_INTEL_82945GM_IG));
	}' unless defined(&IS_I945GM);
    }
    eval 'sub IS_I965G {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device == 0x2972 || ($dev)-> &pci_device == 0x2982 || ($dev)-> &pci_device == 0x2992 || ($dev)-> &pci_device == 0x29a2 || ($dev)-> &pci_device == 0x2a02 || ($dev)-> &pci_device == 0x2a12));
    }' unless defined(&IS_I965G);
    eval 'sub IS_I965GM {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device == 0x2a02));
    }' unless defined(&IS_I965GM);
    eval 'sub IS_G33 {
        my($dev) = @_;
	    eval q((($dev)-> &pci_device == 0x29c2 || ($dev)-> &pci_device == 0x29b2 || ($dev)-> &pci_device == 0x29d2));
    }' unless defined(&IS_G33);
    eval 'sub IS_I9XX {
        my($dev) = @_;
	    eval q(( &IS_I915G($dev) ||  &IS_I915GM($dev) ||  &IS_I945G($dev) ||  &IS_I945GM($dev) ||  &IS_I965G($dev) ||  &IS_G33($dev)));
    }' unless defined(&IS_I9XX);
    eval 'sub IS_MOBILE {
        my($dev) = @_;
	    eval q(( &IS_I830($dev) ||  &IS_I85X($dev) ||  &IS_I915GM($dev) ||  &IS_I945GM($dev) ||  &IS_I965GM($dev)));
    }' unless defined(&IS_MOBILE);
    eval 'sub PRIMARY_RINGBUFFER_SIZE () {(128*1024);}' unless defined(&PRIMARY_RINGBUFFER_SIZE);
}
1;
