require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&time_second)) {
    sub time_second () {	( ($mono_time->{tv_sec}));}
}
if(defined(&AAC_DEBUG)) {
    eval 'sub AAC_DPRINTF {
        my($mask, $args) = @_;
	    eval q( &if ( &aac_debug & ($mask))  &printf $args);
    }' unless defined(&AAC_DPRINTF);
    eval 'sub AAC_D_INTR () {0x1;}' unless defined(&AAC_D_INTR);
    eval 'sub AAC_D_MISC () {0x2;}' unless defined(&AAC_D_MISC);
    eval 'sub AAC_D_CMD () {0x4;}' unless defined(&AAC_D_CMD);
    eval 'sub AAC_D_QUEUE () {0x8;}' unless defined(&AAC_D_QUEUE);
    eval 'sub AAC_D_IO () {0x10;}' unless defined(&AAC_D_IO);
    eval 'sub AAC_D_IOCTL () {0x20;}' unless defined(&AAC_D_IOCTL);
    eval 'sub AAC_D_LOCK () {0x40;}' unless defined(&AAC_D_LOCK);
    eval 'sub AAC_D_THREAD () {0x80;}' unless defined(&AAC_D_THREAD);
    eval 'sub AAC_D_FIB () {0x100;}' unless defined(&AAC_D_FIB);
    eval 'sub AAC_PRINT_FIB {
        my($sc, $fib) = @_;
	    eval q( &do {  &if ( &aac_debug &  &AAC_D_FIB)  &aac_print_fib(($sc), ($fib),  &__func__); }  &while (0));
    }' unless defined(&AAC_PRINT_FIB);
} else {
    eval 'sub AAC_DPRINTF {
        my($mask, $args) = @_;
	    eval q();
    }' unless defined(&AAC_DPRINTF);
    eval 'sub AAC_PRINT_FIB {
        my($sc, $fib) = @_;
	    eval q();
    }' unless defined(&AAC_PRINT_FIB);
}
unless(defined(&AAC_ADAPTER_FIBS)) {
    sub AAC_ADAPTER_FIBS () {	8;}
}
unless(defined(&AAC_FIB_COUNT)) {
    sub AAC_FIB_COUNT () {	( &PAGE_SIZE/$sizeof{'struct aac_fib'});}
}
unless(defined(&AAC_MAX_FIBS)) {
    sub AAC_MAX_FIBS () {	512;}
}
unless(defined(&AAC_FIBMAP_SIZE)) {
    sub AAC_FIBMAP_SIZE () {	( &PAGE_SIZE);}
}
unless(defined(&AAC_AIFQ_LENGTH)) {
    sub AAC_AIFQ_LENGTH () {	64;}
}
unless(defined(&AAC_PRINTF_BUFSIZE)) {
    sub AAC_PRINTF_BUFSIZE () {	256;}
}
unless(defined(&AAC_BOOT_TIMEOUT)) {
    sub AAC_BOOT_TIMEOUT () {	(3* 60);}
}
unless(defined(&AAC_IMMEDIATE_TIMEOUT)) {
    sub AAC_IMMEDIATE_TIMEOUT () {	30;}
}
unless(defined(&AAC_CMD_TIMEOUT)) {
    sub AAC_CMD_TIMEOUT () {	30;}
}
unless(defined(&AAC_PERIODIC_INTERVAL)) {
    sub AAC_PERIODIC_INTERVAL () {	20;}
}
unless(defined(&AAC_WATCH_TIMEOUT)) {
    sub AAC_WATCH_TIMEOUT () {	10000;}
}
unless(defined(&AAC_SYNC_DELAY)) {
    sub AAC_SYNC_DELAY () {	20000;}
}
unless(defined(&AAC_MAXSGENTRIES)) {
    sub AAC_MAXSGENTRIES () {	64;}
}
unless(defined(&AAC_COMMON_ALLOCSIZE)) {
    sub AAC_COMMON_ALLOCSIZE () {	(8192+ $sizeof{'struct aac_common'});}
}
unless(defined(&AAC_GET_FWSTATUS)) {
    sub AAC_GET_FWSTATUS {
	my($sc) = @_;
	eval q((($sc)-> ($aac_if->{aif_get_fwstatus})($sc)));
    }
}
unless(defined(&AAC_QNOTIFY)) {
    sub AAC_QNOTIFY {
	my($sc, $qbit) = @_;
	eval q((($sc)-> ($aac_if->{aif_qnotify})(($sc), ($qbit))));
    }
}
unless(defined(&AAC_GET_ISTATUS)) {
    sub AAC_GET_ISTATUS {
	my($sc) = @_;
	eval q((($sc)-> ($aac_if->{aif_get_istatus})($sc)));
    }
}
unless(defined(&AAC_CLEAR_ISTATUS)) {
    sub AAC_CLEAR_ISTATUS {
	my($sc, $mask) = @_;
	eval q((($sc)-> ($aac_if->{aif_set_istatus})(($sc), ($mask))));
    }
}
unless(defined(&AAC_SET_MAILBOX)) {
    sub AAC_SET_MAILBOX {
	my($sc, $command, $arg0, $arg1, $arg2, $arg3) = @_;
	eval q( &do { (($sc)-> ($aac_if->{aif_set_mailbox})(($sc), ($command), ($arg0), ($arg1), ($arg2), ($arg3))); }  &while(0));
    }
}
unless(defined(&AAC_GET_MAILBOX)) {
    sub AAC_GET_MAILBOX {
	my($sc, $mb) = @_;
	eval q((($sc)-> ($aac_if->{aif_get_mailbox})($sc, ($mb))));
    }
}
unless(defined(&AAC_MASK_INTERRUPTS)) {
    sub AAC_MASK_INTERRUPTS {
	my($sc) = @_;
	eval q((($sc)-> ($aac_if->{aif_set_interrupts})(($sc), 0)));
    }
}
unless(defined(&AAC_UNMASK_INTERRUPTS)) {
    sub AAC_UNMASK_INTERRUPTS {
	my($sc) = @_;
	eval q((($sc)-> ($aac_if->{aif_set_interrupts})(($sc), 1)));
    }
}
unless(defined(&AAC_SETREG4)) {
    sub AAC_SETREG4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg), ($val)));
    }
}
unless(defined(&AAC_GETREG4)) {
    sub AAC_GETREG4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg)));
    }
}
unless(defined(&AAC_SETREG2)) {
    sub AAC_SETREG2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg), ($val)));
    }
}
unless(defined(&AAC_GETREG2)) {
    sub AAC_GETREG2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg)));
    }
}
unless(defined(&AAC_SETREG1)) {
    sub AAC_SETREG1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg), ($val)));
    }
}
unless(defined(&AAC_GETREG1)) {
    sub AAC_GETREG1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &aac_memt, ($sc)-> &aac_memh, ($reg)));
    }
}
unless(defined(&AAC_LOCK_INIT)) {
    sub AAC_LOCK_INIT {
	my($l, $s) = @_;
	eval q( &do {  &rw_init(($l), \"aaclock\");  &AAC_DPRINTF( &AAC_D_LOCK, (\"%s: init lock @%s: %d\\n\",  ($sc->{aac_dev}->{dv_xname}),  &__FUNCTION__,  &__LINE__)); }  &while (0));
    }
}
unless(defined(&AAC_LOCK_ACQUIRE)) {
    sub AAC_LOCK_ACQUIRE {
	my($l) = @_;
	eval q( &do {  &AAC_DPRINTF( &AAC_D_LOCK, (\"%s: lock @%s: %d\\n\",  ($sc->{aac_dev}->{dv_xname}),  &__FUNCTION__,  &__LINE__));  &rw_enter_write(($l)); }  &while (0));
    }
}
unless(defined(&AAC_LOCK_RELEASE)) {
    sub AAC_LOCK_RELEASE {
	my($l) = @_;
	eval q( &do {  &rw_exit_write(($l));  &AAC_DPRINTF( &AAC_D_LOCK, (\"%s: unlock @%s: %d\\n\",  ($sc->{aac_dev}->{dv_xname}),  &__FUNCTION__,  &__LINE__)); }  &while (0));
    }
}
unless(defined(&AAC_CMD_MAPPED)) {
    sub AAC_CMD_MAPPED () {	(1<<0);}
}
unless(defined(&AAC_CMD_DATAIN)) {
    sub AAC_CMD_DATAIN () {	(1<<1);}
}
unless(defined(&AAC_CMD_DATAOUT)) {
    sub AAC_CMD_DATAOUT () {	(1<<2);}
}
unless(defined(&AAC_CMD_COMPLETED)) {
    sub AAC_CMD_COMPLETED () {	(1<<3);}
}
unless(defined(&AAC_CMD_TIMEDOUT)) {
    sub AAC_CMD_TIMEDOUT () {	(1<<4);}
}
unless(defined(&AAC_ON_AACQ_FREE)) {
    sub AAC_ON_AACQ_FREE () {	(1<<5);}
}
unless(defined(&AAC_ON_AACQ_READY)) {
    sub AAC_ON_AACQ_READY () {	(1<<6);}
}
unless(defined(&AAC_ON_AACQ_BUSY)) {
    sub AAC_ON_AACQ_BUSY () {	(1<<7);}
}
unless(defined(&AAC_ON_AACQ_BIO)) {
    sub AAC_ON_AACQ_BIO () {	(1<<8);}
}
unless(defined(&AAC_ON_AACQ_MASK)) {
    sub AAC_ON_AACQ_MASK () {	((1<<5)|(1<<6)|(1<<7)|(1<<8));}
}
unless(defined(&AAC_QUEUE_FRZN)) {
    sub AAC_QUEUE_FRZN () {	(1<<9);}
}
unless(defined(&AAC_ACF_WATCHDOG)) {
    sub AAC_ACF_WATCHDOG () {	(1<<10);}
}
unless(defined(&AACQ_FREE)) {
    sub AACQ_FREE () {	0;}
}
unless(defined(&AACQ_BIO)) {
    sub AACQ_BIO () {	1;}
}
unless(defined(&AACQ_READY)) {
    sub AACQ_READY () {	2;}
}
unless(defined(&AACQ_BUSY)) {
    sub AACQ_BUSY () {	3;}
}
unless(defined(&AACQ_COUNT)) {
    sub AACQ_COUNT () {	4;}
}
unless(defined(&AAC_STATE_SUSPEND)) {
    sub AAC_STATE_SUSPEND () {	(1<<0);}
}
unless(defined(&AAC_STATE_OPEN)) {
    sub AAC_STATE_OPEN () {	(1<<1);}
}
unless(defined(&AAC_STATE_INTERRUPTS_ON)) {
    sub AAC_STATE_INTERRUPTS_ON () {	(1<<2);}
}
unless(defined(&AAC_STATE_AIF_SLEEPER)) {
    sub AAC_STATE_AIF_SLEEPER () {	(1<<3);}
}
unless(defined(&AAC_HWIF_I960RX)) {
    sub AAC_HWIF_I960RX () {	0;}
}
unless(defined(&AAC_HWIF_STRONGARM)) {
    sub AAC_HWIF_STRONGARM () {	1;}
}
unless(defined(&AAC_HWIF_FALCON)) {
    sub AAC_HWIF_FALCON () {	2;}
}
unless(defined(&AAC_HWIF_RKT)) {
    sub AAC_HWIF_RKT () {	3;}
}
unless(defined(&AAC_HWIF_UNKNOWN)) {
    sub AAC_HWIF_UNKNOWN () {	-1;}
}
unless(defined(&AAC_SYNC_LOCK_FORCE)) {
    sub AAC_SYNC_LOCK_FORCE () {	(1<< 0);}
}
unless(defined(&AAC_AIFFLAGS_RUNNING)) {
    sub AAC_AIFFLAGS_RUNNING () {	(1<< 0);}
}
unless(defined(&AAC_AIFFLAGS_AIF)) {
    sub AAC_AIFFLAGS_AIF () {	(1<< 1);}
}
unless(defined(&AAC_AIFFLAGS_EXIT)) {
    sub AAC_AIFFLAGS_EXIT () {	(1<< 2);}
}
unless(defined(&AAC_AIFFLAGS_EXITED)) {
    sub AAC_AIFFLAGS_EXITED () {	(1<< 3);}
}
unless(defined(&AAC_AIFFLAGS_COMPLETE)) {
    sub AAC_AIFFLAGS_COMPLETE () {	(1<< 4);}
}
unless(defined(&AAC_AIFFLAGS_PRINTF)) {
    sub AAC_AIFFLAGS_PRINTF () {	(1<< 5);}
}
unless(defined(&AAC_AIFFLAGS_PENDING)) {
    sub AAC_AIFFLAGS_PENDING () {	( &AAC_AIFFLAGS_AIF |  &AAC_AIFFLAGS_COMPLETE |  &AAC_AIFFLAGS_PRINTF);}
}
unless(defined(&AAC_FLAGS_PERC2QC)) {
    sub AAC_FLAGS_PERC2QC () {	(1<< 0);}
}
unless(defined(&AAC_FLAGS_ENABLE_CAM)) {
    sub AAC_FLAGS_ENABLE_CAM () {	(1<< 1);}
}
unless(defined(&AAC_FLAGS_CAM_NORESET)) {
    sub AAC_FLAGS_CAM_NORESET () {	(1<< 2);}
}
unless(defined(&AAC_FLAGS_CAM_PASSONLY)) {
    sub AAC_FLAGS_CAM_PASSONLY () {	(1<< 3);}
}
unless(defined(&AAC_FLAGS_SG_64BIT)) {
    sub AAC_FLAGS_SG_64BIT () {	(1<< 4);}
}
unless(defined(&AAC_FLAGS_4GB_WINDOW)) {
    sub AAC_FLAGS_4GB_WINDOW () {	(1<< 5);}
}
unless(defined(&AAC_FLAGS_NO4GB)) {
    sub AAC_FLAGS_NO4GB () {	(1<< 6);}
}
unless(defined(&AAC_FLAGS_256FIBS)) {
    sub AAC_FLAGS_256FIBS () {	(1<< 7);}
}
unless(defined(&AAC_FLAGS_BROKEN_MEMMAP)) {
    sub AAC_FLAGS_BROKEN_MEMMAP () {	(1<< 8);}
}
if(defined(&AAC_DEBUG)) {
}
unless(defined(&AACQ_ADD)) {
    sub AACQ_ADD {
	my($sc, $qname) = @_;
	eval q( &do { 'struct aac_qstat' * &qs;  &qs = ($sc)-> $aac_qstat[$qname];  ($qs->{q_length})++;  &if ( ($qs->{q_length}) >  ($qs->{q_max}))  ($qs->{q_max}) =  ($qs->{q_length}); }  &while (0));
    }
}
unless(defined(&AACQ_REMOVE)) {
    sub AACQ_REMOVE {
	my($sc, $qname) = @_;
	eval q(($sc)-> ($aac_qstat[$qname]->{q_length})--);
    }
}
unless(defined(&AACQ_INIT)) {
    sub AACQ_INIT {
	my($sc, $qname) = @_;
	eval q( &do {  ($sc->{aac_qstat[$qname]}->{q_length}) = 0;  ($sc->{aac_qstat[$qname]}->{q_max}) = 0; }  &while (0));
    }
}
unless(defined(&AACQ_COMMAND_QUEUE)) {
    sub AACQ_COMMAND_QUEUE {
	my($name, $index) = @_;
	eval q( &static  &__inline  &void  &aac_initq_  $name ('struct aac_softc' * &sc) {  &TAILQ_INIT( ($sc->{aac_})  $name);  &AACQ_INIT( &sc, $index); }  &static  &__inline  &void  &aac_enqueue_  $name ('struct aac_command' * &cm) {  &AAC_DPRINTF( &AAC_D_CMD, (\": enqueue \" $name));  &if (( ($cm->{cm_flags}) &  &AAC_ON_AACQ_MASK) != 0) {  &printf(\"command %p is on another queue, flags = %#x\\n\",  &cm,  ($cm->{cm_flags}));  &panic(\"command is on another queue\"); }  &TAILQ_INSERT_TAIL( ($cm->{cm_sc}->{aac_})  $name,  &cm,  &cm_link);  ($cm->{cm_flags}) |=  &AAC_ON_  $index;  &AACQ_ADD( ($cm->{cm_sc}), $index); }  &static  &__inline  &void  &aac_requeue_  $name ('struct aac_command' * &cm) {  &AAC_DPRINTF( &AAC_D_CMD, (\": requeue \" $name));  &if (( ($cm->{cm_flags}) &  &AAC_ON_AACQ_MASK) != 0) {  &printf(\"command %p is on another queue, flags = %#x\\n\",  &cm,  ($cm->{cm_flags}));  &panic(\"command is on another queue\"); }  &TAILQ_INSERT_HEAD( ($cm->{cm_sc}->{aac_})  $name,  &cm,  &cm_link);  ($cm->{cm_flags}) |=  &AAC_ON_  $index;  &AACQ_ADD( ($cm->{cm_sc}), $index); }  &static  &__inline 'struct aac_command' *  &aac_dequeue_  $name ('struct aac_softc' * &sc) { 'struct aac_command' * &cm;  &if (( &cm =  &TAILQ_FIRST( ($sc->{aac_})  $name)) !=  &NULL) {  &AAC_DPRINTF( &AAC_D_CMD, (\": dequeue \" $name));  &if (( ($cm->{cm_flags}) &  &AAC_ON_  $index) == 0) {  &printf(\"dequeue - command %p not in queue, flags = %#x, \" \"bit = %#x\\n\",  &cm,  ($cm->{cm_flags}),  &AAC_ON_  $index);  &panic(\"command not in queue\"); }  &TAILQ_REMOVE( ($sc->{aac_})  $name,  &cm,  &cm_link);  ($cm->{cm_flags}) &= ~ &AAC_ON_  $index;  &AACQ_REMOVE( &sc, $index); }  &return( &cm); }  &static  &__inline  &void  &aac_remove_  $name ('struct aac_command' * &cm) {  &AAC_DPRINTF( &AAC_D_CMD, (\": remove \" $name));  &if (( ($cm->{cm_flags}) &  &AAC_ON_  $index) == 0) {  &printf(\"remove - command %p not in queue, flags = %#x, \" \"bit = %#x\\n\",  &cm,  ($cm->{cm_flags}),  &AAC_ON_  $index);  &panic(\"command not in queue\"); }  &TAILQ_REMOVE( ($cm->{cm_sc}->{aac_})  $name,  &cm,  &cm_link);  ($cm->{cm_flags}) &= ~ &AAC_ON_  $index;  &AACQ_REMOVE( ($cm->{cm_sc}), $index); } 'struct hack');
    }
}
unless(defined(&aac_print_printf)) {
    sub aac_print_printf {
	my($sc) = @_;
	eval q({  &printf(\"** %s: %.*s\",  ($sc->{aac_dev}->{dv_xname}),  &AAC_PRINTF_BUFSIZE,  ($sc->{aac_common}->{ac_printf}));  ($sc->{aac_common}->{ac_printf[0]}) = 0;  &AAC_QNOTIFY($sc,  &AAC_DB_PRINTF); });
    }
}
1;
