require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM_ARM_VMPARAM_H_)) {
    eval 'sub _ARM_ARM_VMPARAM_H_ () {1;}' unless defined(&_ARM_ARM_VMPARAM_H_);
    if(defined(&_KERNEL)) {
	require 'sys/lock.ph';
	require 'arm/pte.ph';
    }
    eval 'sub USRTEXT () { &VM_MIN_ADDRESS;}' unless defined(&USRTEXT);
    eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    eval 'sub KERNBASE () { &VM_MAXUSER_ADDRESS;}' unless defined(&KERNBASE);
    eval 'sub MAXTSIZ () {(16*1024*1024);}' unless defined(&MAXTSIZ);
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(512*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(8*1024*1024);}' unless defined(&MAXSSIZ);
    }
    eval 'sub STACKGAP_RANDOM () {256*1024;}' unless defined(&STACKGAP_RANDOM);
    unless(defined(&SHMMAXPGS)) {
	eval 'sub SHMMAXPGS () {1024;}' unless defined(&SHMMAXPGS);
    }
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t) 0x1000);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)  &ARM_KERNEL_BASE);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)  &ARM_KERNEL_BASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) 0xffffffff);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    if(defined(&_KERNEL)) {
	unless(defined(&VM_MAX_KERNEL_BUF)) {
	    eval 'sub VM_MAX_KERNEL_BUF () {(( &virtual_end -  &virtual_avail) * 4/ 10);}' unless defined(&VM_MAX_KERNEL_BUF);
	}
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub kro_mappings () { ($k_u->{s_mappings[0]});}' unless defined(&kro_mappings);
	eval 'sub krw_mappings () { ($k_u->{s_mappings[1]});}' unless defined(&krw_mappings);
	eval 'sub k_mappings () { ($k_u->{i_mappings});}' unless defined(&k_mappings);
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pvh_list}) =  &NULL;  &simple_lock_init(($pg)-> ($mdpage->{pvh_slock})); ($pg)-> ($mdpage->{pvh_attrs}) = 0; ($pg)-> ($mdpage->{uro_mappings}) = 0; ($pg)-> ($mdpage->{urw_mappings}) = 0; ($pg)-> ($mdpage->{k_mappings}) = 0; }  &while ( 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
