require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_XMMINTRIN_H_INCLUDED)) {
    eval 'sub _XMMINTRIN_H_INCLUDED () {1;}' unless defined(&_XMMINTRIN_H_INCLUDED);
    unless(defined(&__SSE__)) {
	die("SSE instruction set not enabled");
    } else {
	require 'mmintrin.ph';
	eval 'sub _MM_SHUFFLE {
	    my($fp3,$fp2,$fp1,$fp0) = @_;
    	    eval q(((($fp3) << 6) | (($fp2) << 4) | (($fp1) << 2) | ($fp0)));
	}' unless defined(&_MM_SHUFFLE);
	eval("sub _MM_HINT_T0 () { 3; }") unless defined(&_MM_HINT_T0);
	eval("sub _MM_HINT_T1 () { 2; }") unless defined(&_MM_HINT_T1);
	eval("sub _MM_HINT_T2 () { 1; }") unless defined(&_MM_HINT_T2);
	eval("sub _MM_HINT_NTA () { 0; }") unless defined(&_MM_HINT_NTA);
	eval 'sub _MM_EXCEPT_MASK () {0x3f;}' unless defined(&_MM_EXCEPT_MASK);
	eval 'sub _MM_EXCEPT_INVALID () {0x1;}' unless defined(&_MM_EXCEPT_INVALID);
	eval 'sub _MM_EXCEPT_DENORM () {0x2;}' unless defined(&_MM_EXCEPT_DENORM);
	eval 'sub _MM_EXCEPT_DIV_ZERO () {0x4;}' unless defined(&_MM_EXCEPT_DIV_ZERO);
	eval 'sub _MM_EXCEPT_OVERFLOW () {0x8;}' unless defined(&_MM_EXCEPT_OVERFLOW);
	eval 'sub _MM_EXCEPT_UNDERFLOW () {0x10;}' unless defined(&_MM_EXCEPT_UNDERFLOW);
	eval 'sub _MM_EXCEPT_INEXACT () {0x20;}' unless defined(&_MM_EXCEPT_INEXACT);
	eval 'sub _MM_MASK_MASK () {0x1f80;}' unless defined(&_MM_MASK_MASK);
	eval 'sub _MM_MASK_INVALID () {0x80;}' unless defined(&_MM_MASK_INVALID);
	eval 'sub _MM_MASK_DENORM () {0x100;}' unless defined(&_MM_MASK_DENORM);
	eval 'sub _MM_MASK_DIV_ZERO () {0x200;}' unless defined(&_MM_MASK_DIV_ZERO);
	eval 'sub _MM_MASK_OVERFLOW () {0x400;}' unless defined(&_MM_MASK_OVERFLOW);
	eval 'sub _MM_MASK_UNDERFLOW () {0x800;}' unless defined(&_MM_MASK_UNDERFLOW);
	eval 'sub _MM_MASK_INEXACT () {0x1000;}' unless defined(&_MM_MASK_INEXACT);
	eval 'sub _MM_ROUND_MASK () {0x6000;}' unless defined(&_MM_ROUND_MASK);
	eval 'sub _MM_ROUND_NEAREST () {0x;}' unless defined(&_MM_ROUND_NEAREST);
	eval 'sub _MM_ROUND_DOWN () {0x2000;}' unless defined(&_MM_ROUND_DOWN);
	eval 'sub _MM_ROUND_UP () {0x4000;}' unless defined(&_MM_ROUND_UP);
	eval 'sub _MM_ROUND_TOWARD_ZERO () {0x6000;}' unless defined(&_MM_ROUND_TOWARD_ZERO);
	eval 'sub _MM_FLUSH_ZERO_MASK () {0x8000;}' unless defined(&_MM_FLUSH_ZERO_MASK);
	eval 'sub _MM_FLUSH_ZERO_ON () {0x8000;}' unless defined(&_MM_FLUSH_ZERO_ON);
	eval 'sub _MM_FLUSH_ZERO_OFF () {0x;}' unless defined(&_MM_FLUSH_ZERO_OFF);
	eval 'sub _mm_sub_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_subss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_sub_ss);
	eval 'sub _mm_mul_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_mulss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_mul_ss);
	eval 'sub _mm_div_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_divss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_div_ss);
	eval 'sub _mm_sqrt_ss {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_sqrtss (( &__v4sf)$__A); });
	}' unless defined(&_mm_sqrt_ss);
	eval 'sub _mm_rcp_ss {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_rcpss (( &__v4sf)$__A); });
	}' unless defined(&_mm_rcp_ss);
	eval 'sub _mm_rsqrt_ss {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_rsqrtss (( &__v4sf)$__A); });
	}' unless defined(&_mm_rsqrt_ss);
	eval 'sub _mm_min_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_minss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_min_ss);
	eval 'sub _mm_max_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_maxss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_max_ss);
	eval 'sub _mm_sub_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_subps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_sub_ps);
	eval 'sub _mm_mul_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_mulps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_mul_ps);
	eval 'sub _mm_div_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_divps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_div_ps);
	eval 'sub _mm_sqrt_ps {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_sqrtps (( &__v4sf)$__A); });
	}' unless defined(&_mm_sqrt_ps);
	eval 'sub _mm_rcp_ps {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_rcpps (( &__v4sf)$__A); });
	}' unless defined(&_mm_rcp_ps);
	eval 'sub _mm_rsqrt_ps {
	    my($__A) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_rsqrtps (( &__v4sf)$__A); });
	}' unless defined(&_mm_rsqrt_ps);
	eval 'sub _mm_min_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_minps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_min_ps);
	eval 'sub _mm_max_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_maxps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_max_ps);
	eval 'sub _mm_andnot_ps {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_andnps ($__A, $__B); });
	}' unless defined(&_mm_andnot_ps);
	eval 'sub _mm_or_ps {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_orps ($__A, $__B); });
	}' unless defined(&_mm_or_ps);
	eval 'sub _mm_xor_ps {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_xorps ($__A, $__B); });
	}' unless defined(&_mm_xor_ps);
	eval 'sub _mm_cmplt_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpltss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmplt_ss);
	eval 'sub _mm_cmple_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpless (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmple_ss);
	eval 'sub _mm_cmpgt_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_movss (( &__v4sf) $__A, ( &__v4sf)  &__builtin_ia32_cmpltss (( &__v4sf) $__B, ( &__v4sf) $__A)); });
	}' unless defined(&_mm_cmpgt_ss);
	eval 'sub _mm_cmpge_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_movss (( &__v4sf) $__A, ( &__v4sf)  &__builtin_ia32_cmpless (( &__v4sf) $__B, ( &__v4sf) $__A)); });
	}' unless defined(&_mm_cmpge_ss);
	eval 'sub _mm_cmpneq_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpneqss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpneq_ss);
	eval 'sub _mm_cmpnlt_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpnltss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpnlt_ss);
	eval 'sub _mm_cmpnle_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpnless (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpnle_ss);
	eval 'sub _mm_cmpngt_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_movss (( &__v4sf) $__A, ( &__v4sf)  &__builtin_ia32_cmpnltss (( &__v4sf) $__B, ( &__v4sf) $__A)); });
	}' unless defined(&_mm_cmpngt_ss);
	eval 'sub _mm_cmpnge_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_movss (( &__v4sf) $__A, ( &__v4sf)  &__builtin_ia32_cmpnless (( &__v4sf) $__B, ( &__v4sf) $__A)); });
	}' unless defined(&_mm_cmpnge_ss);
	eval 'sub _mm_cmpord_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpordss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpord_ss);
	eval 'sub _mm_cmpunord_ss {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpunordss (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpunord_ss);
	eval 'sub _mm_cmplt_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpltps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmplt_ps);
	eval 'sub _mm_cmple_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpleps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmple_ps);
	eval 'sub _mm_cmpgt_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpgtps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpgt_ps);
	eval 'sub _mm_cmpge_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpgeps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpge_ps);
	eval 'sub _mm_cmpneq_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpneqps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpneq_ps);
	eval 'sub _mm_cmpnlt_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpnltps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpnlt_ps);
	eval 'sub _mm_cmpnle_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpnleps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpnle_ps);
	eval 'sub _mm_cmpngt_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpngtps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpngt_ps);
	eval 'sub _mm_cmpnge_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpngeps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpnge_ps);
	eval 'sub _mm_cmpord_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpordps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpord_ps);
	eval 'sub _mm_cmpunord_ps {
	    my($__A,$__B) = @_;
    	    eval q({ ( &__m128)  &__builtin_ia32_cmpunordps (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cmpunord_ps);
	eval 'sub _mm_comilt_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comilt (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_comilt_ss);
	eval 'sub _mm_comile_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comile (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_comile_ss);
	eval 'sub _mm_comigt_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comigt (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_comigt_ss);
	eval 'sub _mm_comige_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comige (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_comige_ss);
	eval 'sub _mm_comineq_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comineq (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_comineq_ss);
	eval 'sub _mm_ucomieq_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomieq (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomieq_ss);
	eval 'sub _mm_ucomilt_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomilt (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomilt_ss);
	eval 'sub _mm_ucomile_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomile (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomile_ss);
	eval 'sub _mm_ucomigt_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomigt (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomigt_ss);
	eval 'sub _mm_ucomige_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomige (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomige_ss);
	eval 'sub _mm_ucomineq_ss {
	    my($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomineq (( &__v4sf)$__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_ucomineq_ss);
	eval 'sub _mm_cvt_ss2si {
	    my($__A) = @_;
    	    eval q({  &_mm_cvtss_si32 ($__A); });
	}' unless defined(&_mm_cvt_ss2si);
	if(defined(&__x86_64__)) {
	}
	eval 'sub _mm_cvt_ps2pi {
	    my($__A) = @_;
    	    eval q({  &_mm_cvtps_pi32 ($__A); });
	}' unless defined(&_mm_cvt_ps2pi);
	eval 'sub _mm_cvtt_ss2si {
	    my($__A) = @_;
    	    eval q({  &_mm_cvttss_si32 ($__A); });
	}' unless defined(&_mm_cvtt_ss2si);
	if(defined(&__x86_64__)) {
	}
	eval 'sub _mm_cvtt_ps2pi {
	    my($__A) = @_;
    	    eval q({  &_mm_cvttps_pi32 ($__A); });
	}' unless defined(&_mm_cvtt_ps2pi);
	eval 'sub _mm_cvt_si2ss {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_cvtsi32_ss ($__A, $__B); });
	}' unless defined(&_mm_cvt_si2ss);
	if(defined(&__x86_64__)) {
	}
	eval 'sub _mm_cvt_pi2ps {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_cvtpi32_ps ($__A, $__B); });
	}' unless defined(&_mm_cvt_pi2ps);
	if(0) {
	    eval 'sub _mm_shuffle_ps {
	        my($__A,$__B,$__mask) = @_;
    		eval q({ ( &__m128)  &__builtin_ia32_shufps (( &__v4sf)$__A, ( &__v4sf)$__B, $__mask); });
	    }' unless defined(&_mm_shuffle_ps);
	} else {
	    eval 'sub _mm_shuffle_ps {
	        my($A, $B, $MASK) = @_;
    		eval q((( &__m128)  &__builtin_ia32_shufps (( &__v4sf)($A), ( &__v4sf)($B), ($MASK))));
	    }' unless defined(&_mm_shuffle_ps);
	}
	eval 'sub _MM_GET_EXCEPTION_MASK {
	    my($void) = @_;
    	    eval q({  &_mm_getcsr() &  &_MM_MASK_MASK; });
	}' unless defined(&_MM_GET_EXCEPTION_MASK);
	eval 'sub _MM_GET_ROUNDING_MODE {
	    my($void) = @_;
    	    eval q({  &_mm_getcsr() &  &_MM_ROUND_MASK; });
	}' unless defined(&_MM_GET_ROUNDING_MODE);
	eval 'sub _MM_GET_FLUSH_ZERO_MODE {
	    my($void) = @_;
    	    eval q({  &_mm_getcsr() &  &_MM_FLUSH_ZERO_MASK; });
	}' unless defined(&_MM_GET_FLUSH_ZERO_MODE);
	eval 'sub _MM_SET_EXCEPTION_MASK {
	    my($__mask) = @_;
    	    eval q({  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_MASK_MASK) | $__mask); });
	}' unless defined(&_MM_SET_EXCEPTION_MASK);
	eval 'sub _MM_SET_ROUNDING_MODE {
	    my($__mode) = @_;
    	    eval q({  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_ROUND_MASK) | $__mode); });
	}' unless defined(&_MM_SET_ROUNDING_MODE);
	eval 'sub _MM_SET_FLUSH_ZERO_MODE {
	    my($__mode) = @_;
    	    eval q({  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_FLUSH_ZERO_MASK) | $__mode); });
	}' unless defined(&_MM_SET_FLUSH_ZERO_MODE);
	eval 'sub _mm_load_ps1 {
	    my($__P) = @_;
    	    eval q({  &_mm_load1_ps ($__P); });
	}' unless defined(&_mm_load_ps1);
	eval 'sub _mm_set_ps1 {
	    my($__F) = @_;
    	    eval q({  &_mm_set1_ps ($__F); });
	}' unless defined(&_mm_set_ps1);
	eval 'sub _mm_store_ps1 {
	    my($__P,$__A) = @_;
    	    eval q({  &_mm_store1_ps ($__P, $__A); });
	}' unless defined(&_mm_store_ps1);
	if(0) {
	    eval 'sub _mm_extract_pi16 {
	        my($__A,$__N) = @_;
    		eval q({  &__builtin_ia32_pextrw (( &__v4hi)$__A, $__N); });
	    }' unless defined(&_mm_extract_pi16);
	    eval 'sub _m_pextrw {
	        my($__A,$__N) = @_;
    		eval q({  &_mm_extract_pi16 ($__A, $__N); });
	    }' unless defined(&_m_pextrw);
	} else {
	    eval 'sub _mm_extract_pi16 {
	        my($A, $N) = @_;
    		eval q( &__builtin_ia32_pextrw (( &__v4hi)($A), ($N)));
	    }' unless defined(&_mm_extract_pi16);
	    eval 'sub _m_pextrw {
	        my($A, $N) = @_;
    		eval q( &_mm_extract_pi16(($A), ($N)));
	    }' unless defined(&_m_pextrw);
	}
	if(0) {
	    eval 'sub _mm_insert_pi16 {
	        my($__A,$__D,$__N) = @_;
    		eval q({ ( &__m64) &__builtin_ia32_pinsrw (( &__v4hi)$__A, $__D, $__N); });
	    }' unless defined(&_mm_insert_pi16);
	    eval 'sub _m_pinsrw {
	        my($__A,$__D,$__N) = @_;
    		eval q({  &_mm_insert_pi16 ($__A, $__D, $__N); });
	    }' unless defined(&_m_pinsrw);
	} else {
	    eval 'sub _mm_insert_pi16 {
	        my($A, $D, $N) = @_;
    		eval q((( &__m64)  &__builtin_ia32_pinsrw (( &__v4hi)($A), ($D), ($N))));
	    }' unless defined(&_mm_insert_pi16);
	    eval 'sub _m_pinsrw {
	        my($A, $D, $N) = @_;
    		eval q( &_mm_insert_pi16(($A), ($D), ($N)));
	    }' unless defined(&_m_pinsrw);
	}
	eval 'sub _m_pmaxsw {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_max_pi16 ($__A, $__B); });
	}' unless defined(&_m_pmaxsw);
	eval 'sub _m_pmaxub {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_max_pu8 ($__A, $__B); });
	}' unless defined(&_m_pmaxub);
	eval 'sub _m_pminsw {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_min_pi16 ($__A, $__B); });
	}' unless defined(&_m_pminsw);
	eval 'sub _m_pminub {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_min_pu8 ($__A, $__B); });
	}' unless defined(&_m_pminub);
	eval 'sub _m_pmovmskb {
	    my($__A) = @_;
    	    eval q({  &_mm_movemask_pi8 ($__A); });
	}' unless defined(&_m_pmovmskb);
	eval 'sub _m_pmulhuw {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_mulhi_pu16 ($__A, $__B); });
	}' unless defined(&_m_pmulhuw);
	if(0) {
	    eval 'sub _mm_shuffle_pi16 {
	        my($__A,$__N) = @_;
    		eval q({ ( &__m64)  &__builtin_ia32_pshufw (( &__v4hi)$__A, $__N); });
	    }' unless defined(&_mm_shuffle_pi16);
	    eval 'sub _m_pshufw {
	        my($__A,$__N) = @_;
    		eval q({  &_mm_shuffle_pi16 ($__A, $__N); });
	    }' unless defined(&_m_pshufw);
	} else {
	    eval 'sub _mm_shuffle_pi16 {
	        my($A, $N) = @_;
    		eval q((( &__m64)  &__builtin_ia32_pshufw (( &__v4hi)($A), ($N))));
	    }' unless defined(&_mm_shuffle_pi16);
	    eval 'sub _m_pshufw {
	        my($A, $N) = @_;
    		eval q( &_mm_shuffle_pi16 (($A), ($N)));
	    }' unless defined(&_m_pshufw);
	}
	eval 'sub _m_maskmovq {
	    my($__A,$__N,$__P) = @_;
    	    eval q({  &_mm_maskmove_si64 ($__A, $__N, $__P); });
	}' unless defined(&_m_maskmovq);
	eval 'sub _m_pavgb {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_avg_pu8 ($__A, $__B); });
	}' unless defined(&_m_pavgb);
	eval 'sub _m_pavgw {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_avg_pu16 ($__A, $__B); });
	}' unless defined(&_m_pavgw);
	eval 'sub _m_psadbw {
	    my($__A,$__B) = @_;
    	    eval q({  &_mm_sad_pu8 ($__A, $__B); });
	}' unless defined(&_m_psadbw);
	if(0) {
	    eval 'sub _mm_prefetch {
	        my($__P,$__I) = @_;
    		eval q({  &__builtin_prefetch ($__P, 0, $__I); });
	    }' unless defined(&_mm_prefetch);
	} else {
	    eval 'sub _mm_prefetch {
	        my($P, $I) = @_;
    		eval q( &__builtin_prefetch (($P), 0, ($I)));
	    }' unless defined(&_mm_prefetch);
	}
	eval 'sub _MM_TRANSPOSE4_PS {
	    my($row0, $row1, $row2, $row3) = @_;
    	    eval q( &do {  &__v4sf  &__r0 = ($row0),  &__r1 = ($row1),  &__r2 = ($row2),  &__r3 = ($row3);  &__v4sf  &__t0 =  &__builtin_ia32_shufps ( &__r0,  &__r1, 0x44);  &__v4sf  &__t2 =  &__builtin_ia32_shufps ( &__r0,  &__r1, 0xee);  &__v4sf  &__t1 =  &__builtin_ia32_shufps ( &__r2,  &__r3, 0x44);  &__v4sf  &__t3 =  &__builtin_ia32_shufps ( &__r2,  &__r3, 0xee); ($row0) =  &__builtin_ia32_shufps ( &__t0,  &__t1, 0x88); ($row1) =  &__builtin_ia32_shufps ( &__t0,  &__t1, 0xdd); ($row2) =  &__builtin_ia32_shufps ( &__t2,  &__t3, 0x88); ($row3) =  &__builtin_ia32_shufps ( &__t2,  &__t3, 0xdd); }  &while (0));
	}' unless defined(&_MM_TRANSPOSE4_PS);
	require 'emmintrin.ph';
    }
}
1;
