require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DRM_P_H_)) {
    eval 'sub _DRM_P_H_ () {1;}' unless defined(&_DRM_P_H_);
    if(defined( &_KERNEL) || defined( &__KERNEL__)) {
	require 'sys/param.ph';
	require 'sys/queue.ph';
	require 'sys/malloc.ph';
	require 'sys/kernel.ph';
	require 'sys/systm.ph';
	require 'sys/conf.ph';
	require 'sys/stat.ph';
	if((defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) >= 700000) {
	    require 'sys/priv.ph';
	}
	require 'sys/proc.ph';
	require 'sys/lock.ph';
	require 'sys/fcntl.ph';
	require 'sys/uio.ph';
	require 'sys/filio.ph';
	require 'sys/sysctl.ph';
	if(defined(&__FreeBSD__)) {
	    require 'sys/bus.ph';
	    require 'sys/module.ph';
	    require 'sys/taskqueue.ph';
	    require 'vm/vm.ph';
	    require 'vm/pmap.ph';
	    require 'vm/vm_extern.ph';
	    require 'vm/vm_map.ph';
	    require 'vm/vm_param.ph';
	    require 'machine/resource.ph';
	}
	require 'sys/signalvar.ph';
	require 'sys/poll.ph';
	require 'sys/tree.ph';
	require 'machine/param.ph';
	require 'machine/pmap.ph';
	require 'machine/bus.ph';
	require 'machine/param.ph';
	require 'machine/bus.ph';
	if(!defined( &DRM_NO_MTRR)) {
	    require 'machine/sysarch.ph';
	}
	require 'sys/endian.ph';
	require 'sys/mman.ph';
	if(defined( &__FreeBSD__)) {
	    require 'sys/rman.ph';
	    require 'dev/pci/agpvar.ph';
	    require 'sys/memrange.ph';
	    require 'sys/agpio.ph';
	    if((defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) >= 500000) {
		require 'sys/mutex.ph';
		require 'sys/selinfo.ph';
	    } else {
		require 'dev/pci/pcivar.ph';
		require 'sys/select.ph';
	    }
	}
 elsif(defined( &__NetBSD__)) {
	    unless(defined(&DRM_NO_MTRR)) {
		require 'machine/mtrr.ph';
	    }
	    require 'sys/vnode.ph';
	    require 'sys/select.ph';
	    require 'sys/device.ph';
	    require 'sys/resourcevar.ph';
	    require 'sys/agpio.ph';
	    require 'sys/ttycom.ph';
	    require 'sys/mman.ph';
	    require 'sys/kauth.ph';
	    require 'sys/types.ph';
	    require 'sys/file.ph';
	    require 'uvm/uvm.ph';
	    require 'dev/pci/pcireg.ph';
	    require 'dev/pci/pcivar.ph';
	    require 'dev/pci/agpvar.ph';
	}
 elsif(defined( &__OpenBSD__)) {
	    require 'sys/types.ph';
	    require 'sys/conf.ph';
	    require 'sys/stdint.ph';
	    require 'sys/malloc.ph';
	    require 'machine/bus.ph';
	    require 'sys/agpio.ph';
	    require 'sys/memrange.ph';
	    require 'sys/vnode.ph';
	    require 'dev/pci/pcidevs.ph';
	    require 'uvm/uvm.ph';
	    require 'dev/pci/pcivar.ph';
	    require 'dev/pci/agpvar.ph';
	    require 'dev/pci/vga_pcivar.ph';
	    require 'dev/pci/pcivar.ph';
	}
	require 'drm.ph';
	require 'drm_linux_list.ph';
	require 'drm_atomic.ph';
	if(defined( &__FreeBSD__) || defined( &__NetBSD__) ) {
	    require 'opt_drm.ph';
	}
	if(defined(&DRM_DEBUG)) {
	    undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	    eval 'sub DRM_DEBUG_DEFAULT_ON () {1;}' unless defined(&DRM_DEBUG_DEFAULT_ON);
	}
	unless(defined(&__Linux__)) {
	    eval 'sub LINUX_VERSION_CODE () {500;}' unless defined(&LINUX_VERSION_CODE);
	    eval 'sub KERNEL_VERSION {
	        my($a,$b,$c) = @_;
    		eval q(0);
	    }' unless defined(&KERNEL_VERSION);
	}
	if(defined( &DRM_LINUX)  && (defined(&DRM_LINUX) ? &DRM_LINUX : 0)  && !defined( &__amd64__)) {
	    require 'sys/file.ph';
	    require 'sys/proc.ph';
	    require 'machine/../linux/linux.ph';
	    require 'machine/../linux/linux_proto.ph';
	} else {
	    undef(&DRM_LINUX) if defined(&DRM_LINUX);
	    eval 'sub DRM_LINUX () {0;}' unless defined(&DRM_LINUX);
	}
	eval 'sub DRM_HASH_SIZE () {16;}' unless defined(&DRM_HASH_SIZE);
	eval 'sub DRM_KERNEL_CONTEXT () {0;}' unless defined(&DRM_KERNEL_CONTEXT);
	eval 'sub DRM_RESERVED_CONTEXTS () {1;}' unless defined(&DRM_RESERVED_CONTEXTS);
	eval 'sub DRM_MEM_DMA () {0;}' unless defined(&DRM_MEM_DMA);
	eval 'sub DRM_MEM_SAREA () {1;}' unless defined(&DRM_MEM_SAREA);
	eval 'sub DRM_MEM_DRIVER () {2;}' unless defined(&DRM_MEM_DRIVER);
	eval 'sub DRM_MEM_MAGIC () {3;}' unless defined(&DRM_MEM_MAGIC);
	eval 'sub DRM_MEM_IOCTLS () {4;}' unless defined(&DRM_MEM_IOCTLS);
	eval 'sub DRM_MEM_MAPS () {5;}' unless defined(&DRM_MEM_MAPS);
	eval 'sub DRM_MEM_BUFS () {6;}' unless defined(&DRM_MEM_BUFS);
	eval 'sub DRM_MEM_SEGS () {7;}' unless defined(&DRM_MEM_SEGS);
	eval 'sub DRM_MEM_PAGES () {8;}' unless defined(&DRM_MEM_PAGES);
	eval 'sub DRM_MEM_FILES () {9;}' unless defined(&DRM_MEM_FILES);
	eval 'sub DRM_MEM_QUEUES () {10;}' unless defined(&DRM_MEM_QUEUES);
	eval 'sub DRM_MEM_CMDS () {11;}' unless defined(&DRM_MEM_CMDS);
	eval 'sub DRM_MEM_MAPPINGS () {12;}' unless defined(&DRM_MEM_MAPPINGS);
	eval 'sub DRM_MEM_BUFLISTS () {13;}' unless defined(&DRM_MEM_BUFLISTS);
	eval 'sub DRM_MEM_AGPLISTS () {14;}' unless defined(&DRM_MEM_AGPLISTS);
	eval 'sub DRM_MEM_TOTALAGP () {15;}' unless defined(&DRM_MEM_TOTALAGP);
	eval 'sub DRM_MEM_BOUNDAGP () {16;}' unless defined(&DRM_MEM_BOUNDAGP);
	eval 'sub DRM_MEM_CTXBITMAP () {17;}' unless defined(&DRM_MEM_CTXBITMAP);
	eval 'sub DRM_MEM_STUB () {18;}' unless defined(&DRM_MEM_STUB);
	eval 'sub DRM_MEM_SGLISTS () {19;}' unless defined(&DRM_MEM_SGLISTS);
	eval 'sub DRM_MEM_DRAWABLE () {20;}' unless defined(&DRM_MEM_DRAWABLE);
	eval 'sub DRM_MAX_CTXBITMAP () {( &PAGE_SIZE * 8);}' unless defined(&DRM_MAX_CTXBITMAP);
	eval 'sub DRM_ARRAY_SIZE {
	    my($x) = @_;
    	    eval q(($sizeof{$x}/$sizeof{$x->[0]}));
	}' unless defined(&DRM_ARRAY_SIZE);
	eval 'sub DRM_MIN {
	    my($a,$b) = @_;
    	    eval q((($a)<($b)?($a):($b)));
	}' unless defined(&DRM_MIN);
	eval 'sub DRM_MAX {
	    my($a,$b) = @_;
    	    eval q((($a)>($b)?($a):($b)));
	}' unless defined(&DRM_MAX);
	eval 'sub DRM_IF_VERSION {
	    my($maj, $min) = @_;
    	    eval q(($maj << 16| $min));
	}' unless defined(&DRM_IF_VERSION);
	unless(defined(&__OpenBSD__)) {
	}
	eval 'sub __OS_HAS_AGP () {1;}' unless defined(&__OS_HAS_AGP);
	eval 'sub DRM_DEV_MODE () {( &S_IRUSR| &S_IWUSR| &S_IRGRP| &S_IWGRP);}' unless defined(&DRM_DEV_MODE);
	eval 'sub DRM_DEV_UID () {0;}' unless defined(&DRM_DEV_UID);
	eval 'sub DRM_DEV_GID () {0;}' unless defined(&DRM_DEV_GID);
	eval 'sub wait_queue_head_t () { &atomic_t;}' unless defined(&wait_queue_head_t);
	eval 'sub DRM_WAKEUP {
	    my($w) = @_;
    	    eval q( &wakeup(( &void *)$w));
	}' unless defined(&DRM_WAKEUP);
	eval 'sub DRM_WAKEUP_INT {
	    my($w) = @_;
    	    eval q( &wakeup($w));
	}' unless defined(&DRM_WAKEUP_INT);
	eval 'sub DRM_INIT_WAITQUEUE {
	    my($queue) = @_;
    	    eval q( &do {( &void)($queue);}  &while (0));
	}' unless defined(&DRM_INIT_WAITQUEUE);
	if(defined( &__FreeBSD__)  && (defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) < 502109) {
	    eval 'sub bus_alloc_resource_any {
	        my($dev, $type, $rid, $flags) = @_;
    		eval q( &bus_alloc_resource($dev, $type, $rid, 0, ~0, 1, $flags));
	    }' unless defined(&bus_alloc_resource_any);
	}
	if(defined( &__FreeBSD__)  && (defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) >= 500000) {
	    eval 'sub DRM_CDEV () {\'struct cdev\' *;}' unless defined(&DRM_CDEV);
	    eval 'sub DRM_CURPROC () { &curthread;}' unless defined(&DRM_CURPROC);
	    eval 'sub DRM_STRUCTPROC () {\'struct thread\';}' unless defined(&DRM_STRUCTPROC);
	    eval 'sub DRM_PROC {
	        my($p) = @_;
    		eval q(($p));
	    }' unless defined(&DRM_PROC);
	    eval 'sub DRM_SPINTYPE () {\'struct mtx\';}' unless defined(&DRM_SPINTYPE);
	    eval 'sub DRM_SPININIT {
	        my($l,$name) = @_;
    		eval q( &mtx_init($l, $name,  &NULL,  &MTX_DEF));
	    }' unless defined(&DRM_SPININIT);
	    eval 'sub DRM_SPINUNINIT {
	        my($l) = @_;
    		eval q( &mtx_destroy($l));
	    }' unless defined(&DRM_SPINUNINIT);
	    eval 'sub DRM_SPINLOCK {
	        my($l) = @_;
    		eval q( &mtx_lock($l));
	    }' unless defined(&DRM_SPINLOCK);
	    eval 'sub DRM_SPINUNLOCK {
	        my($u) = @_;
    		eval q( &mtx_unlock($u));
	    }' unless defined(&DRM_SPINUNLOCK);
	    eval 'sub DRM_SPINLOCK_ASSERT {
	        my($l) = @_;
    		eval q( &mtx_assert($l,  &MA_OWNED));
	    }' unless defined(&DRM_SPINLOCK_ASSERT);
	    eval 'sub DRM_PID {
	        my($p) = @_;
    		eval q(($p)-> ($td_proc->{p_pid}));
	    }' unless defined(&DRM_PID);
	    eval 'sub DRM_CURRENTPID () { &DRM_PID( &curthread);}' unless defined(&DRM_CURRENTPID);
	    eval 'sub DRM_UID {
	        my($p) = @_;
    		eval q(($p)-> ($td_ucred->{cr_svuid}));
	    }' unless defined(&DRM_UID);
	    eval 'sub DRM_LOCK () {
	        eval q( &mtx_lock( ($dev->{dev_lock})));
	    }' unless defined(&DRM_LOCK);
	    eval 'sub DRM_UNLOCK () {
	        eval q( &mtx_unlock( ($dev->{dev_lock})));
	    }' unless defined(&DRM_UNLOCK);
	    eval 'sub DRM_SYSCTL_HANDLER_ARGS () {( &SYSCTL_HANDLER_ARGS);}' unless defined(&DRM_SYSCTL_HANDLER_ARGS);
	} else {
	    if(defined(&__NetBSD__)) {
		eval 'sub DRM_CDEV () { &dev_t;}' unless defined(&DRM_CDEV);
		eval 'sub DRM_CURPROC () { &curproc;}' unless defined(&DRM_CURPROC);
		eval 'sub DRM_STRUCTPROC () {\'struct proc\';}' unless defined(&DRM_STRUCTPROC);
		eval 'sub DRM_SPINTYPE () {\'struct simplelock\';}' unless defined(&DRM_SPINTYPE);
		eval 'sub DRM_SPININIT {
		    my($l,$name) = @_;
    		    eval q( &simple_lock_init($l));
		}' unless defined(&DRM_SPININIT);
		eval 'sub DRM_SPINUNINIT {
		    my($l) = @_;
    		    eval q( &DRM_NOOP);
		}' unless defined(&DRM_SPINUNINIT);
		eval 'sub DRM_SPINLOCK {
		    my($l) = @_;
    		    eval q( &if(! &simple_lock_try($l))  &simple_lock($l));
		}' unless defined(&DRM_SPINLOCK);
		eval 'sub DRM_SPINUNLOCK {
		    my($u) = @_;
    		    eval q( &simple_unlock($u));
		}' unless defined(&DRM_SPINUNLOCK);
		eval 'sub DRM_SPINLOCK_ASSERT {
		    my($l) = @_;
    		    eval q( &DRM_NOOP);
		}' unless defined(&DRM_SPINLOCK_ASSERT);
		eval 'sub DRM_LOCK () {
		    eval q( &DRM_SPINLOCK( ($dev->{dev_lock})));
		}' unless defined(&DRM_LOCK);
		eval 'sub DRM_UNLOCK () {
		    eval q( &DRM_SPINUNLOCK( ($dev->{dev_lock})));
		}' unless defined(&DRM_UNLOCK);
		eval 'sub DRM_SLEEPLOCK {
		    my($v,$l,$f,$s,$i) = @_;
    		    eval q( &ltsleep($v,$f,$s,$i,$l););
		}' unless defined(&DRM_SLEEPLOCK);
		eval 'sub spldrm () {
		    eval q( &spltty());
		}' unless defined(&spldrm);
		eval 'sub DRM_PID {
		    my($p) = @_;
    		    eval q(($p)-> &p_pid);
		}' unless defined(&DRM_PID);
		eval 'sub DRM_CURRENTPID () { &DRM_PID( &curproc);}' unless defined(&DRM_CURRENTPID);
		eval 'sub DRM_UID {
		    my($p) = @_;
    		    eval q( &kauth_cred_getsvuid(($p)-> &p_cred));
		}' unless defined(&DRM_UID);
		eval 'sub DRM_SYSCTL_HANDLER_ARGS () {( &SYSCTLFN_ARGS);}' unless defined(&DRM_SYSCTL_HANDLER_ARGS);
	    } else {
		if(defined(&__OpenBSD__)) {
		    eval 'sub DRM_CDEV () { &dev_t;}' unless defined(&DRM_CDEV);
		    eval 'sub DRM_CURPROC () { &curproc;}' unless defined(&DRM_CURPROC);
		    eval 'sub DRM_STRUCTPROC () {\'struct proc\';}' unless defined(&DRM_STRUCTPROC);
		    eval 'sub DRM_STRUCTCDEVPROC () {\'struct proc\';}' unless defined(&DRM_STRUCTCDEVPROC);
		    eval 'sub DRM_PROC {
		        my($p) = @_;
    			eval q(($p));
		    }' unless defined(&DRM_PROC);
		    eval 'sub DRM_NOOP () { &do {}  &while(0);}' unless defined(&DRM_NOOP);
		    eval 'sub DRM_SPINTYPE () {\'struct mutex\';}' unless defined(&DRM_SPINTYPE);
		    eval 'sub DRM_SPININIT {
		        my($l,$name) = @_;
    			eval q( &mtx_init($l, &IPL_NONE));
		    }' unless defined(&DRM_SPININIT);
		    eval 'sub DRM_SPINUNINIT {
		        my($l) = @_;
    			eval q( &DRM_NOOP);
		    }' unless defined(&DRM_SPINUNINIT);
		    eval 'sub DRM_SPINLOCK {
		        my($l) = @_;
    			eval q( &mtx_enter($l));
		    }' unless defined(&DRM_SPINLOCK);
		    eval 'sub DRM_SPINUNLOCK {
		        my($l) = @_;
    			eval q( &mtx_leave($l));
		    }' unless defined(&DRM_SPINUNLOCK);
		    eval 'sub DRM_SPINLOCK_ASSERT {
		        my($l) = @_;
    			eval q( &DRM_NOOP);
		    }' unless defined(&DRM_SPINLOCK_ASSERT);
		    eval 'sub DRM_LOCK () {
		        eval q( &DRM_SPINLOCK( ($dev->{dev_lock})));
		    }' unless defined(&DRM_LOCK);
		    eval 'sub DRM_UNLOCK () {
		        eval q( &DRM_SPINUNLOCK( ($dev->{dev_lock})));
		    }' unless defined(&DRM_UNLOCK);
		    eval 'sub DRM_SLEEPLOCK {
		        my($v,$l,$f,$s,$i) = @_;
    			eval q( &msleep($v,$l,$f,$s,$i););
		    }' unless defined(&DRM_SLEEPLOCK);
		    eval 'sub DRM_PID {
		        my($p) = @_;
    			eval q(($p)-> &p_pid);
		    }' unless defined(&DRM_PID);
		    eval 'sub DRM_CURRENTPID () { &DRM_PID( &curproc);}' unless defined(&DRM_CURRENTPID);
		    eval 'sub DRM_UID {
		        my($p) = @_;
    			eval q(($p)-> &p_pid);
		    }' unless defined(&DRM_UID);
		    eval 'sub DRM_MAXUNITS () {8;}' unless defined(&DRM_MAXUNITS);
		    eval 'sub DRM_SYSCTL_HANDLER_ARGS () {(\'int\' * &name, \'u_int\'  &namelen,  &void * &oldp, \'size_t\' * &oldlenp,  &void * &newp, \'size_t\'  &newlen, \'struct proc\' * &p);}' unless defined(&DRM_SYSCTL_HANDLER_ARGS);
		    eval 'sub printk () { &printf;}' unless defined(&printk);
		    eval 'sub __unused () {1;}' unless defined(&__unused);
		    eval 'sub drm_ioctl () { &drmioctl;}' unless defined(&drm_ioctl);
		    eval 'sub drm_open () { &drmopen;}' unless defined(&drm_open);
		    eval 'sub drm_close () { &drmclose;}' unless defined(&drm_close);
		    eval 'sub drm_read () { &drmread;}' unless defined(&drm_read);
		    eval 'sub drm_poll () { &drmpoll;}' unless defined(&drm_poll);
		    eval 'sub drm_mmap () { &drmmmap;}' unless defined(&drm_mmap);
		}
	    }
	}
	eval 'sub DRM_SPINLOCK_IRQSAVE {
	    my($l, $irqflags) = @_;
    	    eval q( &do {  &DRM_SPINLOCK($l); ( &void)$irqflags; }  &while (0));
	}' unless defined(&DRM_SPINLOCK_IRQSAVE);
	eval 'sub DRM_SPINUNLOCK_IRQRESTORE {
	    my($u, $irqflags) = @_;
    	    eval q( &DRM_SPINUNLOCK($u));
	}' unless defined(&DRM_SPINUNLOCK_IRQRESTORE);
	eval 'sub DRM_IRQ_ARGS () { &void * &arg;}' unless defined(&DRM_IRQ_ARGS);
	if(defined(&__FreeBSD__)) {
	    eval 'sub IRQ_HANDLED () {1;}' unless defined(&IRQ_HANDLED);
	    eval 'sub IRQ_NONE () {1;}' unless defined(&IRQ_NONE);
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	    eval 'sub IRQ_HANDLED () {0;}' unless defined(&IRQ_HANDLED);
	    eval 'sub IRQ_NONE () {0;}' unless defined(&IRQ_NONE);
	}
	eval("sub DRM_IS_NOT_AGP () { 0; }") unless defined(&DRM_IS_NOT_AGP);
	eval("sub DRM_IS_AGP () { 1; }") unless defined(&DRM_IS_AGP);
	eval("sub DRM_MIGHT_BE_AGP () { 2; }") unless defined(&DRM_MIGHT_BE_AGP);
	eval 'sub DRM_AGP_MEM () {\'struct agp_memory_info\';}' unless defined(&DRM_AGP_MEM);
	if(defined( &__FreeBSD__)) {
	    eval 'sub drm_get_device_from_kdev {
	        my($_kdev) = @_;
    		eval q(( ($_kdev->{si_drv1})));
	    }' unless defined(&drm_get_device_from_kdev);
	}
 elsif(defined( &__NetBSD__)) {
	    eval 'sub drm_get_device_from_kdev {
	        my($_kdev) = @_;
    		eval q( &device_lookup( &drm_cd,  &minor($_kdev)));
	    }' unless defined(&drm_get_device_from_kdev);
	}
 elsif(defined( &__OpenBSD__)) {
	    eval 'sub drm_get_device_from_kdev {
	        my($_kdev) = @_;
    		eval q(( &minor( &kdev) <  &DRM_MAXUNITS) ?  $drm_units[ &minor( &kdev)] :  &NULL);
	    }' unless defined(&drm_get_device_from_kdev);
	}
	if(defined(&__FreeBSD__)) {
	    eval 'sub PAGE_ALIGN {
	        my($addr) = @_;
    		eval q( &round_page($addr));
	    }' unless defined(&PAGE_ALIGN);
	    if((defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) >= 700000) {
		eval 'sub DRM_SUSER {
		    my($p) = @_;
    		    eval q(( &priv_check($p,  &PRIV_DRIVER) == 0));
		}' unless defined(&DRM_SUSER);
	    } else {
		eval 'sub DRM_SUSER {
		    my($p) = @_;
    		    eval q(( &suser($p) == 0));
		}' unless defined(&DRM_SUSER);
	    }
	    eval 'sub DRM_AGP_FIND_DEVICE () {
	        eval q( &agp_find_device());
	    }' unless defined(&DRM_AGP_FIND_DEVICE);
	    eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	    eval 'sub jiffies () { &ticks;}' unless defined(&jiffies);
	} else {
	    if(defined( &__NetBSD__)) {
		eval 'sub DRM_SUSER {
		    my($p) = @_;
    		    eval q(( &kauth_cred_getsvuid(($p)-> &p_cred) == 0));
		}' unless defined(&DRM_SUSER);
		eval 'sub DRM_MAXUNITS () {128;}' unless defined(&DRM_MAXUNITS);
		eval 'sub jiffies () { &hardclock_ticks;}' unless defined(&jiffies);
		eval 'sub CDEV_MAJOR () {34;}' unless defined(&CDEV_MAJOR);
		eval 'sub DRM_MTRR_WC () { &MTRR_TYPE_WC;}' unless defined(&DRM_MTRR_WC);
	    }
 elsif(defined( &__OpenBSD__)) {
		eval 'sub DRM_SUSER {
		    my($p) = @_;
    		    eval q(( &suser($p,  ($p->{p_acflag})) == 0));
		}' unless defined(&DRM_SUSER);
		eval 'sub jiffies () {0;}' unless defined(&jiffies);
		eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	    }
	    eval 'sub PAGE_ALIGN {
	        my($addr) = @_;
    		eval q(((($addr) +  &PAGE_SIZE - 1) &  &PAGE_MASK));
	    }' unless defined(&PAGE_ALIGN);
	    if(defined(&DRM_NO_AGP)) {
		eval 'sub DRM_AGP_FIND_DEVICE () {
		    eval q(0);
		}' unless defined(&DRM_AGP_FIND_DEVICE);
	    } else {
		eval 'sub DRM_AGP_FIND_DEVICE () {
		    eval q( &agp_find_device(0));
		}' unless defined(&DRM_AGP_FIND_DEVICE);
	    }
	}
	unless(defined(&PCIY_AGP)) {
	    eval 'sub PCIY_AGP () {0x2;}' unless defined(&PCIY_AGP);
	}
	unless(defined(&PCIY_EXPRESS)) {
	    eval 'sub PCIY_EXPRESS () {0x10;}' unless defined(&PCIY_EXPRESS);
	}
	if(defined( &__i386__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined( &__alpha__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &alpha_wmb(););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined( &__amd64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
	if(defined(&__FreeBSD__)) {
	    eval 'sub DRM_READ8 {
	        my($map, $offset) = @_;
    		eval q(*( &volatile  &u_int8_t *) ((($map)-> &handle) + ($offset)));
	    }' unless defined(&DRM_READ8);
	    eval 'sub DRM_READ16 {
	        my($map, $offset) = @_;
    		eval q(*( &volatile  &u_int16_t *) ((($map)-> &handle) + ($offset)));
	    }' unless defined(&DRM_READ16);
	    eval 'sub DRM_READ32 {
	        my($map, $offset) = @_;
    		eval q(*( &volatile  &u_int32_t *)((($map)-> &handle) + ($offset)));
	    }' unless defined(&DRM_READ32);
	    eval 'sub DRM_WRITE8 {
	        my($map, $offset, $val) = @_;
    		eval q(*( &volatile  &u_int8_t *) ((($map)-> &handle) + ($offset)) = $val);
	    }' unless defined(&DRM_WRITE8);
	    eval 'sub DRM_WRITE16 {
	        my($map, $offset, $val) = @_;
    		eval q(*( &volatile  &u_int16_t *) ((($map)-> &handle) + ($offset)) = $val);
	    }' unless defined(&DRM_WRITE16);
	    eval 'sub DRM_WRITE32 {
	        my($map, $offset, $val) = @_;
    		eval q(*( &volatile  &u_int32_t *)((($map)-> &handle) + ($offset)) = $val);
	    }' unless defined(&DRM_WRITE32);
	    eval 'sub DRM_VERIFYAREA_READ {
	        my( $uaddr, $size ) = @_;
    		eval q((! &useracc( &__DECONST(\'caddr_t\', $uaddr), $size,  &VM_PROT_READ)));
	    }' unless defined(&DRM_VERIFYAREA_READ);
	} else {
	    eval 'sub DRM_READ8 {
	        my($map, $offset) = @_;
    		eval q( &bus_space_read_1( ($map)-> &bst, ($map)-> &bsh, ($offset)));
	    }' unless defined(&DRM_READ8);
	    eval 'sub DRM_READ16 {
	        my($map, $offset) = @_;
    		eval q( &bus_space_read_2( ($map)-> &bst, ($map)-> &bsh, ($offset)));
	    }' unless defined(&DRM_READ16);
	    eval 'sub DRM_READ32 {
	        my($map, $offset) = @_;
    		eval q( &bus_space_read_4( ($map)-> &bst, ($map)-> &bsh, ($offset)));
	    }' unless defined(&DRM_READ32);
	    eval 'sub DRM_WRITE8 {
	        my($map, $offset, $val) = @_;
    		eval q( &bus_space_write_1(($map)-> &bst, ($map)-> &bsh, ($offset), ($val)));
	    }' unless defined(&DRM_WRITE8);
	    eval 'sub DRM_WRITE16 {
	        my($map, $offset, $val) = @_;
    		eval q( &bus_space_write_2(($map)-> &bst, ($map)-> &bsh, ($offset), ($val)));
	    }' unless defined(&DRM_WRITE16);
	    eval 'sub DRM_WRITE32 {
	        my($map, $offset, $val) = @_;
    		eval q( &bus_space_write_4(($map)-> &bst, ($map)-> &bsh, ($offset), ($val)));
	    }' unless defined(&DRM_WRITE32);
	    eval 'sub DRM_VERIFYAREA_READ {
	        my( $uaddr, $size ) = @_;
    		eval q((! &uvm_map_checkprot(( ($curproc->{p_vmspace}->{vm_map})), ( &vaddr_t)$uaddr, ( &vaddr_t)$uaddr+$size,  &UVM_PROT_READ)));
	    }' unless defined(&DRM_VERIFYAREA_READ);
	}
	eval 'sub DRM_COPY_TO_USER {
	    my($user, $kern, $size) = @_;
    	    eval q( &copyout($kern, $user, $size));
	}' unless defined(&DRM_COPY_TO_USER);
	eval 'sub DRM_COPY_FROM_USER {
	    my($kern, $user, $size) = @_;
    	    eval q( &copyin($user, $kern, $size));
	}' unless defined(&DRM_COPY_FROM_USER);
	eval 'sub DRM_COPY_FROM_USER_UNCHECKED {
	    my($arg1, $arg2, $arg3) = @_;
    	    eval q( &copyin($arg2, $arg1, $arg3));
	}' unless defined(&DRM_COPY_FROM_USER_UNCHECKED);
	eval 'sub DRM_COPY_TO_USER_UNCHECKED {
	    my($arg1, $arg2, $arg3) = @_;
    	    eval q( &copyout($arg2, $arg1, $arg3));
	}' unless defined(&DRM_COPY_TO_USER_UNCHECKED);
	if((defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) > 500000) {
	    eval 'sub DRM_GET_USER_UNCHECKED {
	        my($val, $uaddr) = @_;
    		eval q((($val) =  &fuword32($uaddr), 0));
	    }' unless defined(&DRM_GET_USER_UNCHECKED);
	} else {
	    eval 'sub DRM_GET_USER_UNCHECKED {
	        my($val, $uaddr) = @_;
    		eval q((($val) =  &fuword($uaddr), 0));
	    }' unless defined(&DRM_GET_USER_UNCHECKED);
	}
	if(defined(&__OpenBSD__)) {
	    eval 'sub le32_to_cpu {
	        my($x) = @_;
    		eval q( &letoh32($x));
	    }' unless defined(&le32_to_cpu);
	} else {
	    eval 'sub le32_to_cpu {
	        my($x) = @_;
    		eval q( &le32toh($x));
	    }' unless defined(&le32_to_cpu);
	}
	eval 'sub cpu_to_le32 {
	    my($x) = @_;
    	    eval q( &htole32($x));
	}' unless defined(&cpu_to_le32);
	eval 'sub DRM_HZ () { &hz;}' unless defined(&DRM_HZ);
	eval 'sub DRM_UDELAY {
	    my($udelay) = @_;
    	    eval q( &DELAY($udelay));
	}' unless defined(&DRM_UDELAY);
	eval 'sub DRM_TIME_SLICE () {( &hz/20);}' unless defined(&DRM_TIME_SLICE);
	eval 'sub DRM_GET_PRIV_SAREA {
	    my($_dev, $_ctx, $_map) = @_;
    	    eval q( &do { ($_map) = ($_dev)-> $context_sareas[$_ctx]; }  &while(0));
	}' unless defined(&DRM_GET_PRIV_SAREA);
	eval 'sub LOCK_TEST_WITH_RETURN {
	    my($dev, $file_priv) = @_;
    	    eval q( &do {  &if (! &_DRM_LOCK_IS_HELD( ($dev->{lock}->{hw_lock}->{lock})) ||  ($dev->{lock}->{file_priv}) != $file_priv) {  &DRM_ERROR(\\"%s called without lock held\\\\n\\",  &__FUNCTION__);  &return  &EINVAL; } }  &while (0));
	}' unless defined(&LOCK_TEST_WITH_RETURN);
	if(defined( &__OpenBSD__) || (defined( &__FreeBSD__)  && (defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) > 500000)) {
	    eval 'sub DRM_WAIT_ON {
	        my( $ret, $queue, $timeout, $condition ) = @_;
    		eval q( &for ( $ret = 0; !$ret  && !($condition) ; ) {  &DRM_UNLOCK();  &DRM_SPINLOCK( ($dev->{irq_lock}));  &if (!($condition)) $ret = - &msleep(($queue),  ($dev->{irq_lock}),  &PZERO |  &PCATCH, \\"drmwtq\\", ($timeout));  &DRM_SPINUNLOCK( ($dev->{irq_lock}));  &DRM_LOCK(); });
	    }' unless defined(&DRM_WAIT_ON);
	} else {
	    eval 'sub DRM_WAIT_ON {
	        my( $ret, $queue, $timeout, $condition ) = @_;
    		eval q( &for ( $ret = 0; !$ret  && !($condition) ; ) { \'int\'  &s =  &spldrm();  &if (!($condition)) $ret = - &tsleep( ($queue),  &PZERO |  &PCATCH, \\"drmwtq\\", ($timeout) );  &splx( &s); });
	    }' unless defined(&DRM_WAIT_ON);
	}
	eval 'sub DRM_ERROR () {( &fmt,  &arg...)  &printf("error: ["  &DRM_NAME ":pid%d:%s] *ERROR* "  &fmt,  &DRM_CURRENTPID,  &__func__ ,   &arg);}' unless defined(&DRM_ERROR);
	eval 'sub DRM_INFO () {( &fmt,  &arg...)  &printf("info: ["  &DRM_NAME "] "  &fmt ,   &arg);}' unless defined(&DRM_INFO);
	undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  &DRM_CURRENTPID,  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG);
	eval 'sub DRM_AUTH () {0x1;}' unless defined(&DRM_AUTH);
	eval 'sub DRM_MASTER () {0x2;}' unless defined(&DRM_MASTER);
	eval 'sub DRM_ROOT_ONLY () {0x4;}' unless defined(&DRM_ROOT_ONLY);
	eval 'sub DRM_IOCTL_DEF {
	    my($ioctl, $func, $flags) = @_;
    	    eval q([ &DRM_IOCTL_NR($ioctl)] = {$ioctl, $func, $flags});
	}' unless defined(&DRM_IOCTL_DEF);
	eval("sub DRM_LIST_NONE () { 0; }") unless defined(&DRM_LIST_NONE);
	eval("sub DRM_LIST_FREE () { 1; }") unless defined(&DRM_LIST_FREE);
	eval("sub DRM_LIST_WAIT () { 2; }") unless defined(&DRM_LIST_WAIT);
	eval("sub DRM_LIST_PEND () { 3; }") unless defined(&DRM_LIST_PEND);
	eval("sub DRM_LIST_PRIO () { 4; }") unless defined(&DRM_LIST_PRIO);
	eval("sub DRM_LIST_RECLAIM () { 5; }") unless defined(&DRM_LIST_RECLAIM);
	if(defined( &__FreeBSD__)) {
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	eval("sub _DRM_DMA_USE_AGP () { 0x01; }") unless defined(&_DRM_DMA_USE_AGP);
	eval("sub _DRM_DMA_USE_SG () { 0x02; }") unless defined(&_DRM_DMA_USE_SG);
	if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	} else {
	}
	eval 'sub DRM_ATI_GART_MAIN () {1;}' unless defined(&DRM_ATI_GART_MAIN);
	eval 'sub DRM_ATI_GART_FB () {2;}' unless defined(&DRM_ATI_GART_FB);
	eval 'sub DRM_ATI_GART_PCI () {1;}' unless defined(&DRM_ATI_GART_PCI);
	eval 'sub DRM_ATI_GART_PCIE () {2;}' unless defined(&DRM_ATI_GART_PCIE);
	eval 'sub DRM_ATI_GART_IGP () {3;}' unless defined(&DRM_ATI_GART_IGP);
	eval 'sub DRM_MAX_PCI_RESOURCE () {3;}' unless defined(&DRM_MAX_PCI_RESOURCE);
	if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	}
	if(defined(&__OpenBSD__)) {
	}
	if((defined( &__FreeBSD__)  && (defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) > 500000) || defined (defined(&__NetBSD__) ? &__NetBSD__ : 0) || defined (defined(&__OpenBSD__) ? &__OpenBSD__ : 0)) {
	}
	if(defined(&__FreeBSD__)) {
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	} else {
	}
	if(defined(&__FreeBSD__)) {
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	} else {
	}
	if(defined( &__FreeBSD__)) {
	}
 elsif(defined( &__OpenBSD__)) {
	} else {
	}
	if(defined(&__FreeBSD__)) {
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	}
	eval 'sub drm_core_reclaim_buffers () { &drm_reclaim_buffers;}' unless defined(&drm_core_reclaim_buffers);
	if(defined( &__FreeBSD__) || defined ( &__NetBSD__) || defined ( &__OpenBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	} else {
	}
    }
}
1;
