/*	$OpenBSD: usbdevs_data.h,v 1.290 2007/08/10 06:32:29 xsa Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	OpenBSD: usbdevs,v 1.285 2007/08/10 06:31:17 xsa Exp 
 */
/* $NetBSD: usbdevs,v 1.322 2003/05/10 17:47:14 hamajima Exp $ */

/*
 * Copyright (c) 1998, 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net) at
 * Carlstedt Research & Technology.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Descriptions of known vendors and devices ("products").
 */
struct usb_known_vendor {
	u_int16_t	vendor;
	char		*vendorname;
};

struct usb_known_product {
	u_int16_t	vendor;
	u_int16_t	product;
	char		*productname;
};

const struct usb_known_product usb_known_products[] = {
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_HOMECONN,
	    "HomeConnect",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3CREB96,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C19250,
	    "3C19250 Ethernet",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3CRSHEW696,
	    "3CRSHEW696",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C460,
	    "HomeConnect 3C460",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_USR56K,
	    "U.S.Robotics 56000",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C460B,
	    "HomeConnect 3C460B",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_3,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COM2, USB_PRODUCT_3COM2_3CRUSB10075,
	    "3CRUSB10075",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_OFFICECONN,
	    "3Com OfficeConnect Analog Modem",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_USRISDN,
	    "3Com U.S. Robotics Pro ISDN TA",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_HOMECONN,
	    "3Com HomeConnect",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_USR56K,
	    "U.S.Robotics 56000",
	},
	{
	    USB_VENDOR_HUAWEI3COM, USB_PRODUCT_HUAWEI3COM_WUB320G,
	    "Aolynk WUB320g",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX1,
	    "XX1",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX2,
	    "XX2",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_URE450,
	    "URE450 Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_UFE1000,
	    "UFE1000 Fast Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_DSB650TX_PNA,
	    "1/10/100 ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX4,
	    "XX4",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX5,
	    "XX5",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX6,
	    "XX6",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RTL8151,
	    "RTL8151",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX7,
	    "XX7",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX8,
	    "XX8",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX9,
	    "XX9",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_WL54,
	    "WL54",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX10,
	    "XX10",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_BWU613,
	    "BWU613",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_HWU54DM,
	    "HWU54DM",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_3,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_4,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_WUG2700,
	    "WUG2700",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_USB320_EC,
	    "USB320-EC Ethernet",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_2664W,
	    "2664W",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_111,
	    "T-Sinus 111 WLAN",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SMCWUSBG,
	    "SMCWUSB-G",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SS1001,
	    "SpeedStream Ethernet",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ACEECA, USB_PRODUCT_ACEECA_MEZ1000,
	    "MEZ1000 RDA",
	},
	{
	    USB_VENDOR_ACERLABS, USB_PRODUCT_ACERLABS_M5632,
	    "USB 2.0 Data Link",
	},
	{
	    USB_VENDOR_ACERW, USB_PRODUCT_ACERW_WARPLINK,
	    "Warplink",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_C310U,
	    "Acerscan C310U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_320U,
	    "Acerscan 320U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_640U,
	    "Acerscan 640U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_620U,
	    "Acerscan 620U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ATAPI,
	    "ATA/ATAPI",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_AWL300,
	    "AWL300",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_AWL400,
	    "AWL400",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_PRISM_25,
	    "Prism2.5 WLAN",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_PRISM_25A,
	    "Prism2.5 WLAN A",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_FREELAN,
	    "ROPEX FreeLan 802.11b",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_802UAT1,
	    "802UAT1",
	},
	{
	    USB_VENDOR_ACTISYS, USB_PRODUCT_ACTISYS_IR2000U,
	    "ACT-IR2000U FIR",
	},
	{
	    USB_VENDOR_TOPRE, USB_PRODUCT_TOPRE_HHKB,
	    "HHKB Professional",
	},
	{
	    USB_VENDOR_ACTIVEWIRE, USB_PRODUCT_ACTIVEWIRE_IOBOARD,
	    "I/O Board",
	},
	{
	    USB_VENDOR_ACTIVEWIRE, USB_PRODUCT_ACTIVEWIRE_IOBOARD_FW1,
	    "I/O Board, rev. 1",
	},
	{
	    USB_VENDOR_ADAPTEC, USB_PRODUCT_ADAPTEC_AWN8020,
	    "AWN-8020 WLAN",
	},
	{
	    USB_VENDOR_ADDONICS2, USB_PRODUCT_ADDONICS2_205,
	    "Cable 205",
	},
	{
	    USB_VENDOR_ADDTRON, USB_PRODUCT_ADDTRON_AWU120,
	    "AWU-120",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_4,
	    "AN986A Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUS,
	    "AN986 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII,
	    "AN8511 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_2,
	    "AN8513 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_3,
	    "AN8515 Ethernet",
	},
	{
	    USB_VENDOR_ADS, USB_PRODUCT_ADS_UBS10BT,
	    "UBS-10BT Ethernet",
	},
	{
	    USB_VENDOR_ADS, USB_PRODUCT_ADS_UBS10BTX,
	    "UBS-10BT Ethernet",
	},
	{
	    USB_VENDOR_AEI, USB_PRODUCT_AEI_FASTETHERNET,
	    "Fast Ethernet",
	},
	{
	    USB_VENDOR_AGATE, USB_PRODUCT_AGATE_QDRIVE,
	    "Q-Drive",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1212U,
	    "SnapScan 1212U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1236U,
	    "SnapScan 1236U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANTOUCH,
	    "SnapScan Touch",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1212U2,
	    "SnapScan 1212U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE40,
	    "SnapScan e40",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE50,
	    "SnapScan e50",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE20,
	    "SnapScan e20",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE25,
	    "SnapScan e25",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE26,
	    "SnapScan e26",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE52,
	    "SnapScan e52",
	},
	{
	    USB_VENDOR_AIRPRIME, USB_PRODUCT_AIRPRIME_PC5220,
	    "AirPrime CDMA Wireless EVDO card",
	},
	{
	    USB_VENDOR_AINCOMM, USB_PRODUCT_AINCOMM_AWU2000B,
	    "AWU2000B",
	},
	{
	    USB_VENDOR_PHEENET, USB_PRODUCT_PHEENET_WM168B,
	    "WM-168b",
	},
	{
	    USB_VENDOR_AKS, USB_PRODUCT_AKS_USBHASP,
	    "USB-HASP 0.06",
	},
	{
	    USB_VENDOR_ALCATEL, USB_PRODUCT_ALCATEL_OT535,
	    "One Touch 535/735",
	},
	{
	    USB_VENDOR_ALCATELT, USB_PRODUCT_ALCATELT_ST120G,
	    "SpeedTouch 120g",
	},
	{
	    USB_VENDOR_ALCOR2, USB_PRODUCT_ALCOR2_KBD_HUB,
	    "Kbd Hub",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_MA_KBD_HUB,
	    "MacAlly Kbd Hub",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_AU9814,
	    "AU9814 Hub",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_SM_KBD,
	    "MicroConnectors/StrongMan",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_NEC_KBD_HUB,
	    "NEC Kbd Hub",
	},
	{
	    USB_VENDOR_ALLIEDTELESYN, USB_PRODUCT_ALLIEDTELESYN_ATUSB100,
	    "AT-USB100",
	},
	{
	    USB_VENDOR_ALTEC, USB_PRODUCT_ALTEC_ADA70,
	    "ADA70 Speakers",
	},
	{
	    USB_VENDOR_ALTEC, USB_PRODUCT_ALTEC_ASC495,
	    "ASC495 Speakers",
	},
	{
	    USB_VENDOR_AMBIT, USB_PRODUCT_AMBIT_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_AMBIT, USB_PRODUCT_AMBIT_NTL_250,
	    "NTL 250 cable modem",
	},
	{
	    USB_VENDOR_APC, USB_PRODUCT_APC_UPSPRO500,
	    "Back-UPS Pro 500",
	},
	{
	    USB_VENDOR_AMIT, USB_PRODUCT_AMIT_CGWLUSB2GO,
	    "CG-WLUSB2GO",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEI,
	    "Eagle I",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEI_NF,
	    "Eagle I",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEII,
	    "Eagle II",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEII_NF,
	    "Eagle II",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIIC,
	    "Eagle IIC",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIIC_NF,
	    "Eagle IIC",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIII,
	    "Eagle III",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIII_NF,
	    "Eagle III",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_EZUSB,
	    "EZUSB",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_EZLINK,
	    "EZLINK",
	},
	{
	    USB_VENDOR_ANYDATA, USB_PRODUCT_ANYDATA_ADU_E100H,
	    "ADU-E100H",
	},
	{
	    USB_VENDOR_AOX, USB_PRODUCT_AOX_USB101,
	    "Ethernet",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_OPTMOUSE,
	    "Optical mouse",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_ADB,
	    "ADB device",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_SPEAKERS,
	    "Speakers",
	},
	{
	    USB_VENDOR_ARANEUS, USB_PRODUCT_ARANEUS_ALEA,
	    "True Random Number Generator",
	},
	{
	    USB_VENDOR_ARKMICRO, USB_PRODUCT_ARKMICRO_ARK3116,
	    "ARK3116 Serial",
	},
	{
	    USB_VENDOR_ASAHIOPTICAL, USB_PRODUCT_ASAHIOPTICAL_OPTIO230,
	    "PENTAX Optio230",
	},
	{
	    USB_VENDOR_ASANTE, USB_PRODUCT_ASANTE_EA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_WLL013I,
	    "WLL013 (Intersil)",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_WLL013,
	    "WLL013",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_VOYAGER1010,
	    "Voyager 1010",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88172,
	    "USB 2.0 10/100 ethernet controller",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88178,
	    "AX88178",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88772,
	    "AX88772",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2573_1,
	    "RT2573",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_WL159G,
	    "WL-159g",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_MYPAL_A730,
	    "MyPal A730",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_A9T_WIFI,
	    "A9T wireless",
	},
	{
	    USB_VENDOR_ASUSTEK, USB_PRODUCT_ASUSTEK_WL140,
	    "WL-140",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC1284,
	    "Parallel",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC10T,
	    "10Mbps Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC110T,
	    "UC-110T Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC232A,
	    "Serial",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC210T,
	    "UC210T Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_DSB650C,
	    "DSB-650C",
	},
	{
	    USB_VENDOR_ATHEROS, USB_PRODUCT_ATHEROS_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS, USB_PRODUCT_ATHEROS_AR5523_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_3,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_3_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATI2, USB_PRODUCT_ATI2_205,
	    "USB Cable 205",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_UHB124,
	    "UHB124 hub",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_WN210,
	    "W-Buddie WN210",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_DWL900AP,
	    "DWL-900AP Wireless access point",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503I1,
	    "AT76C503 (Intersil 3861 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503I2,
	    "AT76C503 (Intersil 3863 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503RFMD,
	    "AT76C503 (RFMD Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505RFMD,
	    "AT76C505 (RFMD Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505RFMD2958,
	    "AT76C505 (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505A,
	    "AT76C505A (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505AS,
	    "AT76C505AS (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_AUDIOTECHNICA, USB_PRODUCT_AUDIOTECHNICA_ATCHA4USB,
	    "ATC-HA4USB USB headphone",
	},
	{
	    USB_VENDOR_AUDIOVOX, USB_PRODUCT_AUDIOVOX_PC5740,
	    "PC5740 EVDO",
	},
	{
	    USB_VENDOR_AVANCELOGIC, USB_PRODUCT_AVANCELOGIC_USBAUDIO,
	    "USB Audio Speaker",
	},
	{
	    USB_VENDOR_AVERATEC, USB_PRODUCT_AVERATEC_USBWLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_AVISION, USB_PRODUCT_AVISION_1200U,
	    "1200U",
	},
	{
	    USB_VENDOR_BBELECTRONICS, USB_PRODUCT_BBELECTRONICS_USOTL4,
	    "uLinks RS-422/485",
	},
	{
	    USB_VENDOR_BALTECH, USB_PRODUCT_BALTECH_CARDREADER,
	    "Card reader",
	},
	{
	    USB_VENDOR_BELKIN2, USB_PRODUCT_BELKIN2_F5U002,
	    "F5U002 Parallel",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D6050,
	    "F5D6050 802.11b Wireless adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_FBT001V,
	    "FBT001v2 Bluetooth",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_FBT003V,
	    "FBT003v2 Bluetooth",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U103,
	    "F5U103 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U109,
	    "F5U109 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_SCSI,
	    "SCSI",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D5050,
	    "F5D5050 Ethernet",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U237,
	    "F5U237 USB 2.0 7-Port Hub",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U257,
	    "F5U257 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U409,
	    "F5U409 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C550AVR,
	    "F6C550-AVR UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U120,
	    "F5U120-PC Hub",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D5055,
	    "F5D5055",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050,
	    "F5D7050 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050A,
	    "F5D705A 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050C,
	    "F5D705C 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D9050V3,
	    "F5D9050 ver 3",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USB100,
	    "USB100N 10/100 Ethernet",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBLP100,
	    "USB100LP",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBEL100,
	    "USB100EL",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBE100,
	    "USBE100",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USB2AR,
	    "USB2AR Ethernet",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM2033,
	    "BCM2033",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM2033NF,
	    "BCM2033 (no fw)",
	},
	{
	    USB_VENDOR_BROTHER, USB_PRODUCT_BROTHER_HL1050,
	    "HL-1050 laser printer",
	},
	{
	    USB_VENDOR_BROTHER, USB_PRODUCT_BROTHER_MFC210C,
	    "MFC 210C",
	},
	{
	    USB_VENDOR_BTC, USB_PRODUCT_BTC_BTC7932,
	    "Keyboard/Mouse",
	},
	{
	    USB_VENDOR_BWCT, USB_PRODUCT_BWCT_6CHCONSER,
	    "6ch ConSer",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N656U,
	    "CANOSCAN N656U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N1220U,
	    "CANOSCAN N1220U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N670U,
	    "CANOSCAN N670U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N1240U,
	    "CANOSCAN N1240U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_LIDE60,
	    "CANOSCAN LiDE60",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S10,
	    "PowerShot S10",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S20,
	    "PowerShot S20",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S100_US,
	    "PowerShot S100",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S100_EU,
	    "PowerShot S100",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_G1,
	    "PowerShot G1",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_A20,
	    "PowerShot A20",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_A540,
	    "PowerShot A540",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_NETMATE,
	    "Netmate Ethernet",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_NETMATE2,
	    "Netmate2 Ethernet",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_CHIEF,
	    "USB Chief Bus & Protocol Analyzer",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_ANDROMEDA,
	    "Andromeda hub",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_QV,
	    "QV",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_BE300,
	    "BE-300 PDA",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_NAMELAND,
	    "CASIO Nameland EZ-USB",
	},
	{
	    USB_VENDOR_CCYU, USB_PRODUCT_CCYU_EASYDISK,
	    "EasyDisk Portable",
	},
	{
	    USB_VENDOR_CHERRY, USB_PRODUCT_CHERRY_MY3000KBD,
	    "My3000 keyboard",
	},
	{
	    USB_VENDOR_CHERRY, USB_PRODUCT_CHERRY_MY3000HUB,
	    "My3000 hub",
	},
	{
	    USB_VENDOR_CHIC, USB_PRODUCT_CHIC_MOUSE1,
	    "mouse",
	},
	{
	    USB_VENDOR_CHIC, USB_PRODUCT_CHIC_CYPRESS,
	    "Cypress",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_KB8933,
	    "KB-8933 keyboard",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_PROTHROTTLE,
	    "Pro Throttle",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_PROPEDALS,
	    "Pro Pedals",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_FIGHTERSTICK,
	    "Fighterstick",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_FLIGHTYOKE,
	    "Flight Sim Yoke",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54G,
	    "RT2570",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GP,
	    "RT2570",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_USB200MV2,
	    "USB200M v2",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GC,
	    "WUSB54GC",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GR,
	    "WUSB54GR",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSBF54G,
	    "WUSBF54G",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_HU200TS,
	    "HU200-TS",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQPOCKETPC,
	    "iPAQ PocketPC",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_A1500,
	    "A1500",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQWLAN,
	    "iPAQ WLAN",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_W100,
	    "W100",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_W200,
	    "WLAN MultiPort W200",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_PJB100,
	    "Personal Jukebox PJB100",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQLINUX,
	    "iPAQ Linux",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_SNAPPORT,
	    "SnapPort Ethernet",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CM5100P,
	    "CM-5100P EVDO",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_C11U,
	    "C11U",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_WL210,
	    "WL-210",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_C54RU,
	    "C54RU WLAN",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_C54RU2,
	    "C54RU",
	},
	{
	    USB_VENDOR_CONCORDCAMERA, USB_PRODUCT_CONCORDCAMERA_EYE_Q_3X,
	    "Eye Q 3x",
	},
	{
	    USB_VENDOR_CONNECTIX, USB_PRODUCT_CONNECTIX_QUICKCAM,
	    "QuickCam",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_ETHER_USB_T,
	    "Ether USB-T",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TX,
	    "FEther USB-TX",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLAN_USB_USB_11,
	    "WirelessLAN USB-11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TXS,
	    "FEther USB-TXS",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLANUSB,
	    "Wireless LAN Stick-11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB2_TX,
	    "FEther USB2-TX",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLUSB_11_KEY,
	    "ULUSB-11 Key",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLUSB_11_STICK,
	    "WLAN USB Stick 11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TXC,
	    "FEther USB-TXC",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD_II,
	    "Nomad II",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD_IIMG,
	    "Nomad II MG",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD,
	    "Nomad",
	},
	{
	    USB_VENDOR_CREATIVE2, USB_PRODUCT_CREATIVE2_VOIP_BLASTER,
	    "Voip Blaster",
	},
	{
	    USB_VENDOR_CSR, USB_PRODUCT_CSR_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_CSR, USB_PRODUCT_CSR_BLUECORE,
	    "BlueCore",
	},
	{
	    USB_VENDOR_CTX, USB_PRODUCT_CTX_EX1300,
	    "Ex1300 hub",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_TG54USB,
	    "TG54USB",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_MOUSE,
	    "mouse",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_THERMO,
	    "thermometer",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_KBDHUB,
	    "Keyboard/Hub",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_FMRADIO,
	    "FM Radio",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_USBRS232,
	    "RS232",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_HUB2,
	    "USB2 Hub",
	},
	{
	    USB_VENDOR_DAISY, USB_PRODUCT_DAISY_DMC,
	    "PhotoClip",
	},
	{
	    USB_VENDOR_DALLAS, USB_PRODUCT_DALLAS_J6502,
	    "J-6502 speakers",
	},
	{
	    USB_VENDOR_DALLAS, USB_PRODUCT_DALLAS_USB_FOB_IBUTTON,
	    "USB-FOB/iBUTTON",
	},
	{
	    USB_VENDOR_DAVICOM, USB_PRODUCT_DAVICOM_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_DAVICOM, USB_PRODUCT_DAVICOM_WK668,
	    "HenTong WK-668",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_AXIM,
	    "Axim X51v",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_BC02,
	    "BC02 Bluetooth",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_TM1180,
	    "TrueMobile 1180 WLAN",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_BLUETOOTH350,
	    "Bluetooth 350",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_W5500,
	    "W5500 HSDPA",
	},
	{
	    USB_VENDOR_DELORME, USB_PRODUCT_DELORME_EMUSB,
	    "Earthmate GPS",
	},
	{
	    USB_VENDOR_DELORME, USB_PRODUCT_DELORME_EMLT20,
	    "Earthmate LT20",
	},
	{
	    USB_VENDOR_DIAMOND, USB_PRODUCT_DIAMOND_RIO500USB,
	    "Rio 500",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_WL200U,
	    "WL-200U",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_CHUSB611G,
	    "CHUSB 611G",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_WL240U,
	    "WL-240U",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_XH1153,
	    "XH1153 802.11b",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_CWD854F,
	    "C-Net CWD-854 rev F",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT2,
	    "AccelePort 2",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT4,
	    "AccelePort 4",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT8,
	    "AccelePort 8",
	},
	{
	    USB_VENDOR_DIGITALSTREAM, USB_PRODUCT_DIGITALSTREAM_PS2,
	    "PS/2 Active",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUBE100,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX4,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL120E,
	    "DWL-120 rev E",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL122,
	    "DWL-122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG120,
	    "DWL-G120",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL120F,
	    "DWL-120 rev F",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG132,
	    "DWL-AG132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG132_NF,
	    "DWL-AG132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG132,
	    "DWL-G132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG132_NF,
	    "DWL-G132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG122,
	    "DWL-AG122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG122_NF,
	    "DWL-AG122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWLG122C1,
	    "DWL-G122 rev C1",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_WUA1340,
	    "WUA-1340",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUBE100B1,
	    "DUB-E100 rev B1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650C,
	    "10Mbps ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX1,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX_PNA,
	    "1/10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX3,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX2,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650,
	    "10/100 ethernet",
	},
	{
	    USB_VENDOR_DMI, USB_PRODUCT_DMI_SA2_0,
	    "Storage Adapter",
	},
	{
	    USB_VENDOR_DRAYTEK, USB_PRODUCT_DRAYTEK_VIGOR550,
	    "Vigor550",
	},
	{
	    USB_VENDOR_DRAYTEK, USB_PRODUCT_DRAYTEK_VIGOR600,
	    "Vigor600",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANTDEVBOARD,
	    "ANT dev board",
	},
	{
	    USB_VENDOR_EASYDISK, USB_PRODUCT_EASYDISK_EASYDISK,
	    "Flash Disk",
	},
	{
	    USB_VENDOR_EGALAX, USB_PRODUCT_EGALAX_TPANEL,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EGALAX, USB_PRODUCT_EGALAX_TPANEL2,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EGALAX2, USB_PRODUCT_EGALAX2_TPANEL,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EICON, USB_PRODUCT_EICON_DIVA852,
	    "Diva 852 ISDN TA",
	},
	{
	    USB_VENDOR_EIZO, USB_PRODUCT_EIZO_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_EIZO, USB_PRODUCT_EIZO_MONITOR,
	    "monitor",
	},
	{
	    USB_VENDOR_ELCON, USB_PRODUCT_ELCON_PLAN,
	    "Goldpfeil P-LAN",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MOUSE29UO,
	    "29UO",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX0,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX1,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBLTX,
	    "LD-USBL/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX2,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSB20,
	    "LD-USB20",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_UCSGT,
	    "UC-SGT Serial",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_UCSGT0,
	    "UC-SGT0 Serial",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX3,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELSA, USB_PRODUCT_ELSA_MODEM1,
	    "ELSA",
	},
	{
	    USB_VENDOR_ELSA, USB_PRODUCT_ELSA_USB2ETHERNET,
	    "Microlink USB2Ethernet",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S,
	    "1S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_2S,
	    "2S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S25,
	    "1S25 serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_4S,
	    "4S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_E45,
	    "E45 Ethernet",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_CENTRONICS,
	    "Centronics",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_XX1,
	    "Ethernet",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S9,
	    "1S9 serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_EZUSB,
	    "EZ-USB",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_2U4S,
	    "2U4S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_XX2,
	    "Ethernet",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER1,
	    "USB Printer",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER2,
	    "ISD Smart Cable for Mac",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER3,
	    "ISD Smart Cable",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER5,
	    "USB Printer",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_636,
	    "Perfection 636U / 636Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_610,
	    "Perfection 610",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1200,
	    "Perfection 1200U / 1200Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1600,
	    "Expression 1600",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1640,
	    "Perfection 1640SU",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1240,
	    "Perfection 1240U / 1240Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_640U,
	    "Perfection 640U",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1650,
	    "Perfection 1650",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_GT9700F,
	    "GT-9700F",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_2400,
	    "Perfection 2400",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1260,
	    "Perfection 1260",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1660,
	    "Perfection 1660",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1670,
	    "Perfection 1670",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_CX3650,
	    "Stylus CX3650",
	},
	{
	    USB_VENDOR_ETEK, USB_PRODUCT_ETEK_1COM,
	    "Serial",
	},
	{
	    USB_VENDOR_EXTENDED, USB_PRODUCT_EXTENDED_XTNDACCESS,
	    "XTNDAccess IrDA",
	},
	{
	    USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_TWIST,
	    "Falcom Twist USB",
	},
	{
	    USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_SAMBA,
	    "Falcom Samba USB",
	},
	{
	    USB_VENDOR_FIBERLINE, USB_PRODUCT_FIBERLINE_WL430U,
	    "WL-430U",
	},
	{
	    USB_VENDOR_FREECOM, USB_PRODUCT_FREECOM_DVD,
	    "Connector for DVD drive",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U232AM,
	    "8U232AM Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_2232C,
	    "2232C Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PS2KBDMS,
	    "PS/2 Keyboard/Mouse",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U100AX,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MJS_SIRIUS_PC,
	    "MJS Sirius To PC Interface",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_232BM,
	    "FT232BM Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_KW,
	    "KW",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_YS,
	    "YS",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y6,
	    "Y6",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y8,
	    "Y8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_IC,
	    "IC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_DB9,
	    "DB9",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_RS232,
	    "RS232",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y9,
	    "Y9",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_COASTAL_TNCX,
	    "Coastal ChipWorks TNC-X",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ITM_TOUCH,
	    "ITM Touchscreen",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_MX200,
	    "Matrix Orbital MX200 Series LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK202_24,
	    "Matrix Orbital LK202-24 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK204_24,
	    "Matrix Orbital LK204-24 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_631,
	    "Crystalfontz CFA-631 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_632,
	    "Crystalfontz CFA-632 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_633,
	    "Crystalfontz CFA-633 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_634,
	    "Crystalfontz CFA-634 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SEMC_DSS20,
	    "SEMC DSS-20 SyncStation",
	},
	{
	    USB_VENDOR_FUJIPHOTO, USB_PRODUCT_FUJIPHOTO_MASS0100,
	    "Mass Storage",
	},
	{
	    USB_VENDOR_FUJITSU, USB_PRODUCT_FUJITSU_AH_F401U,
	    "AH-F401U Air H device",
	},
	{
	    USB_VENDOR_GMATE, USB_PRODUCT_GMATE_YP3X00,
	    "YP3X00 PDA",
	},
	{
	    USB_VENDOR_GARMIN, USB_PRODUCT_GARMIN_IQUE3600,
	    "Ique 3600",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GENELINK,
	    "GeneLink Host-Host Bridge",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GL650,
	    "GL650 Hub",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GL641USB,
	    "GL641USB CompactFlash",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNBR402W,
	    "GN-BR402W",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWLBM101,
	    "GN-WLBM101",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWBKG,
	    "GN-WBKG",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWB01GS,
	    "GN-WB01GS",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWI05GS,
	    "GN-WI05GS",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_SMCWUSBTG,
	    "SMCWUSBT-G",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_SMCWUSBTG_NF,
	    "SMCWUSBT-G",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_AR5523_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GOHUBS, USB_PRODUCT_GOHUBS_GOCOM232,
	    "GoCOM232 Serial converter",
	},
	{
	    USB_VENDOR_GOODWAY, USB_PRODUCT_GOODWAY_GWUSB2E,
	    "GWUSB2E",
	},
	{
	    USB_VENDOR_GOODWAY, USB_PRODUCT_GOODWAY_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_GRAVIS, USB_PRODUCT_GRAVIS_GAMEPADPRO,
	    "GamePad Pro",
	},
	{
	    USB_VENDOR_GREENHOUSE, USB_PRODUCT_GREENHOUSE_KANA21,
	    "CF-writer/MP3 Player",
	},
	{
	    USB_VENDOR_GRIFFIN, USB_PRODUCT_GRIFFIN_IMATE,
	    "iMate, ADB adapter",
	},
	{
	    USB_VENDOR_GUDE, USB_PRODUCT_GUDE_DCF,
	    "Expert mouseCLOCK USB",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_DALEADER,
	    "DA Leader",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254,
	    "HWGUSB2-54 WLAN",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254LB,
	    "HWGUSB2-54-LB",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254V2AP,
	    "HWGUSB2-54V2-AP",
	},
	{
	    USB_VENDOR_GUNZE, USB_PRODUCT_GUNZE_TOUCHPANEL,
	    "Gunze USB Touch Panel",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FGSM,
	    "FlashGate SmartMedia",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FGCF,
	    "FlashGate CompactFlash",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FG,
	    "FlashGate",
	},
	{
	    USB_VENDOR_HAL, USB_PRODUCT_HAL_IMR001,
	    "Crossam2+USB IR commander",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_VISOR,
	    "Handspring Visor",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_TREO,
	    "Handspring Treo",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_TREO600,
	    "Handspring Treo 600",
	},
	{
	    USB_VENDOR_HAUPPAUGE, USB_PRODUCT_HAUPPAUGE_WINTV_USB_FM,
	    "WinTV FM",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_UF100,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_UF200,
	    "UF200 Ethernet",
	},
	{
	    USB_VENDOR_HITACHI, USB_PRODUCT_HITACHI_DZMV100A,
	    "DVD-CAM DZ-MV100A Camcorder",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_895C,
	    "DeskJet 895C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4100C,
	    "Scanjet 4100C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_S20,
	    "Photosmart S20",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_880C,
	    "DeskJet 880C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4200C,
	    "ScanJet 4200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CDWRITERPLUS,
	    "CD-Writer Plus",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_KBDHUB,
	    "Multimedia Keyboard Hub",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HN210W,
	    "HN210W",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_6200C,
	    "ScanJet 6200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_S20b,
	    "PhotoSmart S20",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_815C,
	    "DeskJet 815C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_3300C,
	    "ScanJet 3300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CDW8200,
	    "CD-Writer Plus 8200e",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1220C,
	    "DeskJet 1220C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_810C,
	    "DeskJet 810C/812C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4300C,
	    "Scanjet 4300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CD4E,
	    "CD-Writer+ CD-4e",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_G85XI,
	    "OfficeJet G85xi",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1200,
	    "LaserJet 1200",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5200C,
	    "Scanjet 5200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_830C,
	    "DeskJet 830C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_3400CSE,
	    "ScanJet 3400cse",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_885C,
	    "DeskJet 885C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_6300C,
	    "Scanjet 6300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_840C,
	    "DeskJet 840c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_2200C,
	    "ScanJet 2200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5300C,
	    "Scanjet 5300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_816C,
	    "DeskJet 816C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_970CSE,
	    "Deskjet 970Cse",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5400C,
	    "Scanjet 5400C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_959C,
	    "Deskjet 959C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_930C,
	    "DeskJet 930c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_P2000U,
	    "Inkjet P-2000U",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_640C,
	    "DeskJet 640c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_P1100,
	    "Photosmart P1100",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HN210E,
	    "HN210E Ethernet",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_2215,
	    "iPAQ 22xx/Jornada 548",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_568J,
	    "Jornada 568",
	},
	{
	    USB_VENDOR_HP2, USB_PRODUCT_HP2_C500,
	    "PhotoSmart C500",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E618,
	    "HUAWEI Mobile E618",
	},
	{
	    USB_VENDOR_HUMAX, USB_PRODUCT_HUMAX_PVRSMART,
	    "PVR-SMART",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_OPTTRAVELMOUSE,
	    "Optical",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_USBCDROMDRIVE,
	    "CD-ROM",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_THINKPADHUB,
	    "Hub",
	},
	{
	    USB_VENDOR_IDQUANTIQUE, USB_PRODUCT_IDQUANTIQUE_QUANTISUSB,
	    "Quantis USB",
	},
	{
	    USB_VENDOR_IIYAMA, USB_PRODUCT_IIYAMA_HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_IMATION, USB_PRODUCT_IMATION_FLASHGO,
	    "Flash Go!",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4,
	    "EdgePort/4 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_HUBPORT7,
	    "Hubport/7",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_RAPIDPORT4,
	    "Rapidport/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4T,
	    "Edgeport/4 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2,
	    "Edgeport/2 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4I,
	    "Edgeport/4 RS422",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2I,
	    "Edgeport/2 RS422/RS485",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_HUBPORT4,
	    "Hubport/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8HAND,
	    "Hand-built Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_MULTIMODEM,
	    "MultiTech version of RP/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORTPPORT,
	    "Edgeport/(4)21 Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT421,
	    "Edgeport/421 Hub+RS232+Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT21,
	    "Edgeport/21 RS232+Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8DC,
	    "1/2 Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8,
	    "Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2DIN,
	    "Edgeport/2 RS232/DIN",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4DIN,
	    "Edgeport/4 RS232/DIN",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT16DC,
	    "1/2 Edgeport/16",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORTCOMP,
	    "Edgeport Compatible",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8I,
	    "Edgeport/8 RS422",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_MT4X56USB,
	    "OEM device",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_F5U002,
	    "Parallel",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ATAPI,
	    "ATAPI",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_IDEUSB2,
	    "USB2 Storage",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ISD110,
	    "IDE ISD110",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ISD105,
	    "IDE ISD105",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_DRIVEV2,
	    "Portable USB Harddrive V2",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_DRIVEV2_5,
	    "Portable USB Harddrive V2",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_USBCABLE,
	    "USB cable",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ADAPTERV2,
	    "USB Storage Adapter V2",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_EASYPC_CAMERA,
	    "EasyPC",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_AP310,
	    "AP310 AnyPoint II",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_I2011B,
	    "Wireless 2011B",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_TESTBOARD,
	    "82930 test board",
	},
	{
	    USB_VENDOR_INTERSIL, USB_PRODUCT_INTERSIL_PRISM_2X,
	    "Prism2.x WLAN",
	},
	{
	    USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_VALUECAN,
	    "ValueCAN",
	},
	{
	    USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_NEOVI,
	    "NeoVI Blue",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBSSMRW,
	    "USB-SSMRW SD-card",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBSDRW,
	    "USB-SDRW SD-card",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETT,
	    "USB ETT",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETTX,
	    "USB ETTX",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETTXS,
	    "USB ETTX",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNB11A,
	    "USB WN-B11",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNB11,
	    "USB Airport WN-B11",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_ETGUS2,
	    "ETG-US2",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBRSAQ,
	    "RSAQ1 Serial",
	},
	{
	    USB_VENDOR_IODATA2, USB_PRODUCT_IODATA2_USB2SC,
	    "USB2.0-SCSI Bridge USB2-SC",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP100,
	    "Zip 100",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP250,
	    "Zip 250",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP250_2,
	    "Zip 250",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_CDRW,
	    "CDRW 9602",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_1XX,
	    "iFP-1xx",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_3XX,
	    "iFP-3xx",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_5XX,
	    "iFP-5xx",
	},
	{
	    USB_VENDOR_ITEGNO, USB_PRODUCT_ITEGNO_WM1080A,
	    "WM1080A",
	},
	{
	    USB_VENDOR_JABLOTRON, USB_PRODUCT_JABLOTRON_PC60B,
	    "PC-60B",
	},
	{
	    USB_VENDOR_JATON, USB_PRODUCT_JATON_EDA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_JENOPTIK, USB_PRODUCT_JENOPTIK_JD350,
	    "JD 350",
	},
	{
	    USB_VENDOR_JRC, USB_PRODUCT_JRC_AH_J3001V_J3002V,
	    "AirH\"PHONE AH-J3001V/J3002V",
	},
	{
	    USB_VENDOR_JVC, USB_PRODUCT_JVC_MP_XP7250_WL,
	    "MP-XP7250 Builtin WLAN",
	},
	{
	    USB_VENDOR_JVC, USB_PRODUCT_JVC_MP_PRX1,
	    "MP-PRX1",
	},
	{
	    USB_VENDOR_KLSI, USB_PRODUCT_KLSI_DUH3E10BT,
	    "10BT Ethernet",
	},
	{
	    USB_VENDOR_KLSI, USB_PRODUCT_KLSI_DUH3E10BTN,
	    "10BT Ethernet",
	},
	{
	    USB_VENDOR_KAWATSU, USB_PRODUCT_KAWATSU_MH4000P,
	    "MiniHub 4000P",
	},
	{
	    USB_VENDOR_KAWATSU, USB_PRODUCT_KAWATSU_KC180,
	    "KC-180 IrDA",
	},
	{
	    USB_VENDOR_KEISOKUGIKEN, USB_PRODUCT_KEISOKUGIKEN_USBDAQ,
	    "HKS-0200 USBDAQ",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_ORBIT,
	    "Orbit trackball",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_TURBOBALL,
	    "TurboBall",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_ORBIT_MAC,
	    "Orbit trackball for Mac",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_BT_EDR,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_VIDEOCAM_VGA,
	    "VideoCAM VGA",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28_NF,
	    "USA-28 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28X_NF,
	    "USA-28X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19_NF,
	    "USA-19 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18_NF,
	    "USA-18 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18X_NF,
	    "USA-18X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19W_NF,
	    "USA-19W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19,
	    "USA-19 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19W,
	    "USA-19W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA49W_NF,
	    "USA-49W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA49W,
	    "USA-49W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QI_NF,
	    "USA-19QI serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QI,
	    "USA-19QI serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19Q_NF,
	    "USA-19Q serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19Q,
	    "USA-19Q serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28,
	    "USA-28 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XXB,
	    "USA-28X/XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18,
	    "USA-18 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18X,
	    "USA-18X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XB_NF,
	    "USA-28XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XA_NF,
	    "USA-28XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XA,
	    "USA-28XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18XA_NF,
	    "USA-18XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18XA,
	    "USA-18XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QW_NF,
	    "USA-19WQ serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QW,
	    "USA-19WQ serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_UIA10,
	    "UIA-10 remote control",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_UIA11,
	    "UIA-11 remote control",
	},
	{
	    USB_VENDOR_KINGSTON, USB_PRODUCT_KINGSTON_XX1,
	    "Ethernet",
	},
	{
	    USB_VENDOR_KINGSTON, USB_PRODUCT_KINGSTON_KNU101TX,
	    "KNU101TX Ethernet",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC220,
	    "Digital Science DC220",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC260,
	    "Digital Science DC260",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC265,
	    "Digital Science DC265",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC290,
	    "Digital Science DC290",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC240,
	    "Digital Science DC240",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC280,
	    "Digital Science DC280",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DX4900,
	    "EasyShare DX4900",
	},
	{
	    USB_VENDOR_KONICA, USB_PRODUCT_KONICA_CAMERA,
	    "Camera",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_NICHE,
	    "Niche mouse",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_NETSCROLL,
	    "Genius NetScroll mouse",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_FLIGHT2000,
	    "Flight 2000 joystick",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_VIVIDPRO,
	    "ColorPage Vivid-Pro",
	},
	{
	    USB_VENDOR_KYOCERA, USB_PRODUCT_KYOCERA_AHK3001V,
	    "AH-K3001V",
	},
	{
	    USB_VENDOR_KYOCERA2, USB_PRODUCT_KYOCERA2_KPC650,
	    "KPC650 EVDO",
	},
	{
	    USB_VENDOR_LACIE, USB_PRODUCT_LACIE_HD,
	    "Hard Disk",
	},
	{
	    USB_VENDOR_LACIE, USB_PRODUCT_LACIE_CDRW,
	    "CD R/W",
	},
	{
	    USB_VENDOR_LEADTEK, USB_PRODUCT_LEADTEK_9531,
	    "9531 GPS",
	},
	{
	    USB_VENDOR_LEXAR, USB_PRODUCT_LEXAR_JUMPSHOT,
	    "jumpSHOT CompactFlash",
	},
	{
	    USB_VENDOR_LEXAR, USB_PRODUCT_LEXAR_2662WAR,
	    "2662W-AR",
	},
	{
	    USB_VENDOR_LEXMARK, USB_PRODUCT_LEXMARK_S2450,
	    "Optra S 2450",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_USB1000,
	    "USB1000",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_MAUSB2,
	    "Camedia MAUSB-2",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TX1,
	    "USB10TX",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10T,
	    "USB10T Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB100TX,
	    "USB100TX Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB100H1,
	    "USB100H1 Ethernet/HPNA",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TA,
	    "USB10TA Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB11,
	    "WUSB11 802.11b",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB11_25,
	    "WUSB11 802.11b v2.5",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB12_11,
	    "WUSB12 802.11b v1.1",
	},
	{
	    USB_VENDOR_LINKSYS2, USB_PRODUCT_LINKSYS2_USB200M,
	    "USB 2.0 10/100 ethernet controller",
	},
	{
	    USB_VENDOR_LINKSYS2, USB_PRODUCT_LINKSYS2_WUSB11,
	    "WUSB11",
	},
	{
	    USB_VENDOR_LINKSYS2, USB_PRODUCT_LINKSYS2_NWU11B,
	    "Network Everywhere NWU11B",
	},
	{
	    USB_VENDOR_LINKSYS3, USB_PRODUCT_LINKSYS3_WUSB11V28,
	    "WUSB11 v2.8",
	},
	{
	    USB_VENDOR_LINKSYS3, USB_PRODUCT_LINKSYS3_WUSB11V30,
	    "WUSB11 v3.0",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TX2,
	    "USB10TX",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_M2452,
	    "M2452 keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_M4848,
	    "M4848 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_PAGESCAN,
	    "PageScan",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMWEB,
	    "QuickCam Web",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO,
	    "QuickCam Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMEXP,
	    "QuickCam Express",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAM,
	    "QuickCam",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMDLXNB,
	    "QuickCam Notebook Deluxe",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO3k,
	    "QuickCam Pro 3000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRONB,
	    "QuickCam Notebook Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO4K,
	    "QuickCam Pro 4000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_N43,
	    "N43",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_N48,
	    "N48 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_MBA47,
	    "M-BA47 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMMOUSE,
	    "WingMan Gaming Mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BD58,
	    "BD58 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_UN58A,
	    "iFeel Mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMPAD,
	    "WingMan GamePad Extreme",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMRPAD,
	    "WingMan RumblePad",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMJOY,
	    "WingMan Force joystick",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMFFGP,
	    "WingMan Formula Force GP (GT-Force)",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_ITOUCH,
	    "iTouch Keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BB13,
	    "USB-PS/2 Trackball",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BB18,
	    "TrackMan Wheel",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_RK53,
	    "Cordless mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_RB6,
	    "Cordless keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_CDO,
	    "Cordless Desktop Optical",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO2,
	    "QuickCam Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMZOOM,
	    "QuickCam Zoom",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_LCS8138TX,
	    "LCS-8138TX",
	},
	{
	    USB_VENDOR_LUCENT, USB_PRODUCT_LUCENT_EVALKIT,
	    "USS-720 evaluation kit",
	},
	{
	    USB_VENDOR_MACALLY, USB_PRODUCT_MACALLY_MOUSE1,
	    "mouse",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_HUB0100,
	    "Hub",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_DU_H3SP_USB232,
	    "D-Link DU-H3SP BAY Hub",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_USB232,
	    "RS232 Interface",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_SITECOM_USB232,
	    "Sitecom RS232",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_ML_4500,
	    "ML-4500",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUATX1,
	    "LUA-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUATX5,
	    "LUA-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_NINWIFI,
	    "Nintendo Wi-Fi",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUA2TX5,
	    "LUA2-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUAKTX,
	    "LUA-KTX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_S11,
	    "WLI-USB-S11",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_MCRSM2,
	    "MCR-SM2 SmartMedia",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_DUBPXXG,
	    "USB-IDE Bridge: DUB-PxxG",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KS11G,
	    "WLI-USB-KS11G wlan",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUAU2KTX,
	    "LUA-U2-KTX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KB11,
	    "WLI-USB-KB11 WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54YB,
	    "WLI-U2-KG54-YB WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54,
	    "WLI-U2-KG54 WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54AI,
	    "WLI-U2-KG54-AI WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_SG54HP,
	    "WLI-U2-SG54HP",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_G54HP,
	    "WLI-U2-G54HP",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54L,
	    "WLI-U2-KG54L",
	},
	{
	    USB_VENDOR_METAGEEK, USB_PRODUCT_METAGEEK_WISPY,
	    "Wi-Spy",
	},
	{
	    USB_VENDOR_METRICOM, USB_PRODUCT_METRICOM_RICOCHET_GS,
	    "Ricochet GS",
	},
	{
	    USB_VENDOR_MGE, USB_PRODUCT_MGE_UPS1,
	    "Protection Center 1 UPS",
	},
	{
	    USB_VENDOR_MGE, USB_PRODUCT_MGE_UPS2,
	    "Protection Center 2 UPS",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570_3,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_1,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_3,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_4,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_BLUETOOTH_2,
	    "Bluetooth2",
	},
	{
	    USB_VENDOR_MICRONET, USB_PRODUCT_MICRONET_SP128AR,
	    "SP128AR EtherFast",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_SIDEPREC,
	    "SideWinder Precision Pro",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INTELLIMOUSE,
	    "IntelliMouse",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_NATURALKBD,
	    "Natural",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_DDS80,
	    "Digital Sound System 80",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_SIDEWINDER,
	    "Sidewinder Precision Racing Wheel",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_TBEXPLORER,
	    "Trackball Explorer",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INTELLIEYE,
	    "IntelliEye mouse",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INETPRO,
	    "Internet Keyboard Pro",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_MN510,
	    "MN510 Wireless",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_MN110,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_XBOX360,
	    "XBOX 360 WLAN",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_SCSIDB25,
	    "SCSI-DB25",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_SCSIHD50,
	    "SCSI-HD50",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_DPCM,
	    "CameraMate",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_FREECOM,
	    "Freecom IDE",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_336CX,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_X6U,
	    "ScanMaker X6 - X6U",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_C6,
	    "Phantom C6",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_336CX2,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6USL,
	    "ScanMaker V6USL",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6USL2,
	    "ScanMaker V6USL",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6UL,
	    "ScanMaker V6UL",
	},
	{
	    USB_VENDOR_MIDIMAN, USB_PRODUCT_MIDIMAN_MIDISPORT2X2,
	    "Midisport 2x2",
	},
	{
	    USB_VENDOR_MINDSATWORK, USB_PRODUCT_MINDSATWORK_DW,
	    "Digital Wallet",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_S304,
	    "Dimage S304",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_X,
	    "Dimage X",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_DIMAGE7I,
	    "Dimage 7i",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_DIMAGEA1,
	    "Dimage A1",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_CDRRW,
	    "CD-R/RW Drive",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_MOUSE,
	    "Mouse",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_FDD,
	    "FDD",
	},
	{
	    USB_VENDOR_MOBILEACTION, USB_PRODUCT_MOBILEACTION_MA620,
	    "MA-620 IrDA",
	},
	{
	    USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_EA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_EASIDOCK,
	    "EasiDock Ethernet",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7703,
	    "MCS7703 Serial",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7830,
	    "MCS7830 Ethernet",
	},
	{
	    USB_VENDOR_MOTOROLA, USB_PRODUCT_MOTOROLA_MC141555,
	    "MC141555 hub controller",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_T720C,
	    "T720c",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_V360,
	    "V360",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_USBLAN,
	    "USBLAN",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_USBLAN2,
	    "USBLAN",
	},
	{
	    USB_VENDOR_MOTOROLA, USB_PRODUCT_MOTOROLA_SB4100,
	    "SB4100 Cable Modem",
	},
	{
	    USB_VENDOR_MOTOROLA3, USB_PRODUCT_MOTOROLA3_SB5100,
	    "SB5100 Cable Modem",
	},
	{
	    USB_VENDOR_MULTITECH, USB_PRODUCT_MULTITECH_ATLAS,
	    "MT5634ZBA modem",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200CU,
	    "1200 CU",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_600CU,
	    "600 CU",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200USB,
	    "1200",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200UB,
	    "1200 UB",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200USBPLUS,
	    "1200 Plus",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200CUPLUS,
	    "1200 CU Plus",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_BEARPAW1200F,
	    "BearPaw 1200F",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_600USB,
	    "600",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_MDC800,
	    "MDC-800",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_DV2000,
	    "DV2000",
	},
	{
	    USB_VENDOR_MSYSTEMS, USB_PRODUCT_MSYSTEMS_DISKONKEY,
	    "DiskOnKey",
	},
	{
	    USB_VENDOR_MSYSTEMS, USB_PRODUCT_MSYSTEMS_DISKONKEY2,
	    "DiskOnKey",
	},
	{
	    USB_VENDOR_NI, USB_PRODUCT_NI_GPIB_USB_A,
	    "GPIB-USB-A",
	},
	{
	    USB_VENDOR_NATIONAL, USB_PRODUCT_NATIONAL_BEARPAW1200,
	    "BearPaw 1200",
	},
	{
	    USB_VENDOR_NATIONAL, USB_PRODUCT_NATIONAL_BEARPAW2400,
	    "BearPaw 2400",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_USB2EXTEND,
	    "Repeater",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_HUB_B,
	    "hub",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY760,
	    "Picty760",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY900,
	    "Picty900",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY920,
	    "Picty920",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY800,
	    "Picty800",
	},
	{
	    USB_VENDOR_NEC2, USB_PRODUCT_NEC2_HUB2_0,
	    "USB2.0 Hub",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND3050,
	    "6-in-1 Flash Device Controller",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND3260,
	    "8-in-1 Flash Device Controller",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND5010,
	    "Multi-format Flash Controller",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_TURBOCONNECT,
	    "Turbo-Connect",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_CLIK40,
	    "Clik! 40",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_ETHERNETGADGET,
	    "EthernetGadget",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_EA101,
	    "Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_EA101X,
	    "Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_FA101,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_FA120,
	    "USB 2.0 Fast Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR2, USB_PRODUCT_NETGEAR2_MA101,
	    "MA101",
	},
	{
	    USB_VENDOR_NETGEAR2, USB_PRODUCT_NETGEAR2_MA101B,
	    "MA101 Rev B",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_MA111NA,
	    "802.11b",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_MA111V2,
	    "802.11b V2",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WG111T,
	    "WG111T",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WG111T_NF,
	    "WG111T",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111U,
	    "WG111U",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111U_NF,
	    "WG111U",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WPN111,
	    "WPN111",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WPN111_NF,
	    "WPN111",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111V2,
	    "WG111v2",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E990,
	    "E990",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E880,
	    "E880",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E885,
	    "E885",
	},
	{
	    USB_VENDOR_NHJ, USB_PRODUCT_NHJ_CAM2,
	    "Camera",
	},
	{
	    USB_VENDOR_NOKIA, USB_PRODUCT_NOKIA_CA42,
	    "CA-42 Serial",
	},
	{
	    USB_VENDOR_NOVATECH, USB_PRODUCT_NOVATECH_NV902W,
	    "NV-902W",
	},
	{
	    USB_VENDOR_NOVATECH, USB_PRODUCT_NOVATECH_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_EXPRESSCARD,
	    "ExpressCard 3G",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINV620,
	    "Merlin V620",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_S720,
	    "S720",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINU740,
	    "Merlin U740",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_XU870,
	    "XU870",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_ES620,
	    "ES620 CDMA",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_U720,
	    "U720",
	},
	{
	    USB_VENDOR_OLYMPUS, USB_PRODUCT_OLYMPUS_C1,
	    "C-1",
	},
	{
	    USB_VENDOR_OLYMPUS, USB_PRODUCT_OLYMPUS_C700,
	    "C-700 Ultra Zoom",
	},
	{
	    USB_VENDOR_SIIG2, USB_PRODUCT_SIIG2_USBTOETHER,
	    "USB TO Ethernet",
	},
	{
	    USB_VENDOR_OMNIVISION, USB_PRODUCT_OMNIVISION_OV511,
	    "OV511",
	},
	{
	    USB_VENDOR_OMNIVISION, USB_PRODUCT_OMNIVISION_OV511PLUS,
	    "OV511+",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MD2,
	    "disk",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MDCFEB,
	    "MDCFE-B CF",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_SIIGMS,
	    "Memory Stick+CF",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_DATAFAB3,
	    "Datafab-based",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_DATAFAB4,
	    "Datafab-based",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_PNYCFSM,
	    "PNY/Datafab CF+SM",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_STECHCFSM,
	    "Simple Tech/Datafab CF+SM",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_LC1,
	    "CF + SM Combo (LC1)",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MD1II,
	    "Datafab MD1-II PC-Card",
	},
	{
	    USB_VENDOR_ONSPEC2, USB_PRODUCT_ONSPEC2_8IN2,
	    "8In2",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_WIFI01,
	    "model 01 WiFi interface",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_BT01,
	    "model 01 Bluetooth interface",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_ETHER01PLUS,
	    "model 01+ Ethernet",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_ETHER01,
	    "model 01 Ethernet interface",
	},
	{
	    USB_VENDOR_OTI, USB_PRODUCT_OTI_SOLID,
	    "Solid state disk",
	},
	{
	    USB_VENDOR_OTI, USB_PRODUCT_OTI_DKU5,
	    "DKU-5 Serial",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_SERIAL,
	    "USB Serial Adaptor",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M500,
	    "Palm m500",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M505,
	    "Palm m505",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M515,
	    "Palm m515",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_I705,
	    "Palm i705",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_TUNGSTEN_Z,
	    "Palm Tungsten Z",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M125,
	    "Palm m125",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M130,
	    "Palm m130",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_TUNGSTEN_T,
	    "Palm Tungsten T",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_ZIRE_31,
	    "Palm Zire 31",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_ZIRE,
	    "Palm Zire",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_LS120,
	    "LS-120",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_SDCAAE,
	    "MultiMediaCard",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_TYTP50P6S,
	    "TY-TP50P6-S 50in Touch Panel",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_USBREADER,
	    "6 in 1",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_MOBILEDRIVE,
	    "3 in 1",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_USBDISK,
	    "Disk",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_SERIAL1,
	    "Serial Converter",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET3,
	    "At-Home Ethernet",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET2,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PHEENET, USB_PRODUCT_PHEENET_WL503IA,
	    "WL-503IA",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS350,
	    "DSS 350 Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS,
	    "DSS XXX Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCA645VC,
	    "PCA645VC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCA646VC,
	    "PCA646VC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC675K,
	    "PCVC675K Vesta",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC680K,
	    "PCVC680K Vesta Pro",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC690K,
	    "PCVC690K Vesta Pro Scan Camera",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC730K,
	    "PCVC730K ToUCam Fun",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC740K,
	    "PCVC740K ToUCam Pro PC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC750K,
	    "PCVC750K ToUCam Pro Scan",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS150,
	    "DSS 150 Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU6500,
	    "SNU6500",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU5600,
	    "SNU5600",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DIVAUSB,
	    "DIVA mp3 player",
	},
	{
	    USB_VENDOR_PHILIPSSEMI, USB_PRODUCT_PHILIPSSEMI_HUB1122,
	    "hub",
	},
	{
	    USB_VENDOR_PIENGINEERING, USB_PRODUCT_PIENGINEERING_PS2USB,
	    "PS2 to Mac",
	},
	{
	    USB_VENDOR_PIENGINEERING, USB_PRODUCT_PIENGINEERING_XKEYS,
	    "Xkeys Programmable Keyboard",
	},
	{
	    USB_VENDOR_PILOTECH, USB_PRODUCT_PILOTECH_CRW600,
	    "CRW-600 6-in-1",
	},
	{
	    USB_VENDOR_PLANEX, USB_PRODUCT_PLANEX_GW_US11H,
	    "GW-US11H WLAN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GW_US11S,
	    "GW-US11S WLAN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54HP,
	    "GW-US54HP",
	},
	{
	    USB_VENDOR_PLANEX3, USB_PRODUCT_PLANEX3_GU1000T,
	    "GU-1000T",
	},
	{
	    USB_VENDOR_PLANEX3, USB_PRODUCT_PLANEX3_GWUS54MINI,
	    "GW-US54Mini",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54MINI2,
	    "GW-US54Mini2",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54SG,
	    "GW-US54SG",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54GZL,
	    "GW-US54GZL",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSMM,
	    "GW-USMM",
	},
	{
	    USB_VENDOR_PLANTRONICS, USB_PRODUCT_PLANTRONICS_HEADSET,
	    "DSP-400 Headset",
	},
	{
	    USB_VENDOR_PLX, USB_PRODUCT_PLX_TESTBOARD,
	    "test board",
	},
	{
	    USB_VENDOR_PLX, USB_PRODUCT_PLX_CA42,
	    "CA-42 Serial",
	},
	{
	    USB_VENDOR_PORTGEAR, USB_PRODUCT_PORTGEAR_EA8,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PORTGEAR, USB_PRODUCT_PORTGEAR_EA9,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PORTSMITH, USB_PRODUCT_PORTSMITH_EEA,
	    "Express Ethernet",
	},
	{
	    USB_VENDOR_PQI, USB_PRODUCT_PQI_TRAVELFLASH,
	    "Travel Flash Drive",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2X300,
	    "G2-200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E300,
	    "G2E-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2300,
	    "G2-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E3002,
	    "G2E-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_9600,
	    "Colorado 9600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_600U,
	    "Colorado 600u",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_6200,
	    "Visioneer 6200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_19200,
	    "Colorado 19200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_1200U,
	    "Colorado 1200u",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G600,
	    "G2-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_636I,
	    "ReadyScan 636i",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2600,
	    "G2-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E600,
	    "G2E-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_COMFORT,
	    "Comfort",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_MOUSEINABOX,
	    "Mouse-in-a-Box",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_PCGAUMS1,
	    "Sony PCGA-UMS1",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2301,
	    "PL2301 Host-Host interface",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2302,
	    "PL2302 Host-Host interface",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_RSAQ2,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC2, USB_PRODUCT_PROLIFIC2_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2305,
	    "Parallel printer",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_ATAPI4,
	    "ATAPI-4 Bridge Controller",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2501,
	    "PL2501 Host-Host interface",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303X,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303X2,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PUTERCOM, USB_PRODUCT_PUTERCOM_UPA100,
	    "USB-1284 BRIDGE",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_QTRONIX, USB_PRODUCT_QTRONIX_980N,
	    "Scorpion-980N",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_MODEM,
	    "CDMA MSM modem",
	},
	{
	    USB_VENDOR_QUALCOMM2, USB_PRODUCT_QUALCOMM2_MSM_PHONE,
	    "CDMA MSM phone",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_HSDPA,
	    "HSDPA MSM",
	},
	{
	    USB_VENDOR_QUICKSHOT, USB_PRODUCT_QUICKSHOT_STRIKEPAD,
	    "USB StrikePad",
	},
	{
	    USB_VENDOR_RADIOSHACK, USB_PRODUCT_RADIOSHACK_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_RAINBOW, USB_PRODUCT_RAINBOW_IKEY2000,
	    "i-Key 2000",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570_3,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2671,
	    "RT2671",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_RATOC, USB_PRODUCT_RATOC_REXUSB60,
	    "USB serial REX-USB60",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8150,
	    "RTL8150",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8151,
	    "RTL8151 PNA",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8187,
	    "RTL8187",
	},
	{
	    USB_VENDOR_RIM, USB_PRODUCT_RIM_BLACKBERRY,
	    "Blackberry",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UA100,
	    "UA-100 Audio I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM4,
	    "UM-4 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SC8850,
	    "SC-8850 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_U8,
	    "U-8 Audio I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM2,
	    "UM-2 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SC8820,
	    "SC-8820 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_PC300,
	    "PC-300 MIDI Keyboard",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM1,
	    "UM-1 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SK500,
	    "SK-500 MIDI Keyboard",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SCD70,
	    "SC-D70 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM880N,
	    "UM-880 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD90,
	    "SD-90 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM550,
	    "UM-550 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD20,
	    "SD-20 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD80,
	    "SD-80 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UA700,
	    "UA-700 Audio I/F",
	},
	{
	    USB_VENDOR_ROCKFIRE, USB_PRODUCT_ROCKFIRE_GAMEPAD,
	    "Gamepad 203USB",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_XG760A,
	    "XG-760A",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_XG76NA,
	    "XG-76NA",
	},
	{
	    USB_VENDOR_SAITEK, USB_PRODUCT_SAITEK_CYBORG_3D_GOLD,
	    "Cyborg 3D Gold Joystick",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR05A,
	    "ImageMate SDDR-05a",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR31,
	    "ImageMate SDDR-31",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR05,
	    "ImageMate SDDR-05",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR12,
	    "ImageMate SDDR-12",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR09,
	    "ImageMate SDDR-09",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR75,
	    "ImageMate SDDR-75",
	},
	{
	    USB_VENDOR_SANWASUPPLY, USB_PRODUCT_SANWASUPPLY_JYDV9USB,
	    "JY-DV9USB gamepad",
	},
	{
	    USB_VENDOR_SANYO, USB_PRODUCT_SANYO_SCP4900,
	    "Sanyo SCP-4900 Phone",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_I330,
	    "I330",
	},
	{
	    USB_VENDOR_SAMSUNG, USB_PRODUCT_SAMSUNG_SWL2100W,
	    "SWL-2100U",
	},
	{
	    USB_VENDOR_SCANLOGIC, USB_PRODUCT_SCANLOGIC_SL11R,
	    "SL11R-IDE",
	},
	{
	    USB_VENDOR_SCANLOGIC, USB_PRODUCT_SCANLOGIC_336CX,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_USBSERIAL,
	    "USB-Serial converter",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_NUB8301,
	    "NUB-8301",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_NUB862,
	    "NUB-862",
	},
	{
	    USB_VENDOR_SERVERWORKS, USB_PRODUCT_SERVERWORKS_HUB,
	    "Root Hub",
	},
	{
	    USB_VENDOR_SGI, USB_PRODUCT_SGI_SN1_L1_SC,
	    "SN1 L1 System Controller",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_ST268,
	    "ST268",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_SHARK, USB_PRODUCT_SHARK_PA,
	    "Pocket Adapter",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_SL5500,
	    "SL5500",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_A300,
	    "A300",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_SL5600,
	    "SL5600",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_C700,
	    "C700",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_C750,
	    "C750",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSB,
	    "E-USB Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_SDDR09,
	    "ImageMate SDDR09",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSBSMCF,
	    "eUSB SmartMedia / CompactFlash",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_ZIOMMC,
	    "eUSB MultiMediaCard",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_HIFD,
	    "Sony Hifd",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSBATAPI,
	    "eUSB ATA/ATAPI",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_CF,
	    "eUSB CompactFlash",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI_B,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI_C,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_CDRW,
	    "CD-RW Device",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_SCM,
	    "SCM Micro",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_SX1,
	    "SX1",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_X65,
	    "X65",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_X75,
	    "X75",
	},
	{
	    USB_VENDOR_SIEMENS2, USB_PRODUCT_SIEMENS2_WLL013,
	    "WLL013",
	},
	{
	    USB_VENDOR_SIEMENS2, USB_PRODUCT_SIEMENS2_ES75,
	    "GSM module MC35",
	},
	{
	    USB_VENDOR_SIEMENS, USB_PRODUCT_SIEMENS_SPEEDSTREAM,
	    "SpeedStream",
	},
	{
	    USB_VENDOR_SIEMENS, USB_PRODUCT_SIEMENS_SPEEDSTREAM22,
	    "SpeedStream 1022",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_GIGASET108,
	    "Siemens Gigaset 108",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_EM5625,
	    "EM5625",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5720,
	    "MC5720",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_595,
	    "AirCard 595",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5725,
	    "MC5725",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_580,
	    "Aircard 580 EVDO",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8755_2,
	    "MC8755",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8765,
	    "MC8765",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8755,
	    "MC8755 HSDPA",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8775,
	    "MC8775 HSDPA",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_875,
	    "Aircard 875 HSDPA",
	},
	{
	    USB_VENDOR_SIGMATEL, USB_PRODUCT_SIGMATEL_IRDA,
	    "IrDA",
	},
	{
	    USB_VENDOR_SIGMATEL, USB_PRODUCT_SIGMATEL_DNSSF7X,
	    "Datum Networks SSF-7X Multi Players",
	},
	{
	    USB_VENDOR_SIIG, USB_PRODUCT_SIIG_DIGIFILMREADER,
	    "DigiFilm-Combo",
	},
	{
	    USB_VENDOR_SIIG, USB_PRODUCT_SIIG_MULTICARDREADER,
	    "MULTICARDREADER",
	},
	{
	    USB_VENDOR_SIIG2, USB_PRODUCT_SIIG2_US2308,
	    "Serial",
	},
	{
	    USB_VENDOR_SILICOM, USB_PRODUCT_SILICOM_U2E,
	    "U2E",
	},
	{
	    USB_VENDOR_SILICOM, USB_PRODUCT_SILICOM_GPE,
	    "Psion Dacom Gold Port Ethernet",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_POLOLU,
	    "Pololu Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ARGUSISP,
	    "Argussoft ISP",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CRUMB128,
	    "Crumb128",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_DEGREECONT,
	    "Degree Controls",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_SUNNTO,
	    "Suunto sports",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_DESKTOPMOBILE,
	    "Burnside Desktop mobile",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_IPLINK1220,
	    "IP-Link 1220",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_JTAG,
	    "Lipowsky Baby-JTAG",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_LIN,
	    "Lipowsky Baby-LIN",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_HARP,
	    "Lipowsky HARP-1",
	},
	{
	    USB_VENDOR_SILABS2, USB_PRODUCT_SILABS2_DCU11CLONE,
	    "DCU-11 clone",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP210X_1,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP210X_2,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_SILICONPORTALS, USB_PRODUCT_SILICONPORTALS_YAPPH_NF,
	    "YAP Phone (no firmware)",
	},
	{
	    USB_VENDOR_SILICONPORTALS, USB_PRODUCT_SILICONPORTALS_YAPPHONE,
	    "YAP Phone",
	},
	{
	    USB_VENDOR_SIRIUS, USB_PRODUCT_SIRIUS_ROADSTER,
	    "NetComm Roadster II 56",
	},
	{
	    USB_VENDOR_SITECOM, USB_PRODUCT_SITECOM_LN029,
	    "LN029",
	},
	{
	    USB_VENDOR_SITECOM2, USB_PRODUCT_SITECOM2_WL022,
	    "WL-022",
	},
	{
	    USB_VENDOR_SITECOM, USB_PRODUCT_SITECOM_CN104,
	    "CN104",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_LN028,
	    "LN-028",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL113,
	    "WL-113",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL172,
	    "WL-172",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL113R2,
	    "WL-113 rev 2",
	},
	{
	    USB_VENDOR_SMARTBRIDGES, USB_PRODUCT_SMARTBRIDGES_SMARTLINK,
	    "SmartLink Ethernet",
	},
	{
	    USB_VENDOR_SMARTBRIDGES, USB_PRODUCT_SMARTBRIDGES_SMARTNIC,
	    "smartNIC 2 PnP",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2102USB,
	    "10Mbps Ethernet",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2202USB,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2206USB,
	    "EZ Connect Ethernet",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_2020HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_2504HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_SMC3, USB_PRODUCT_SMC3_2662WV1,
	    "EZ Connect 11Mbps",
	},
	{
	    USB_VENDOR_SMC3, USB_PRODUCT_SMC3_2662WV2,
	    "EZ Connect 11Mbps v2",
	},
	{
	    USB_VENDOR_SOHOWARE, USB_PRODUCT_SOHOWARE_NUB100,
	    "NUB100 Ethernet",
	},
	{
	    USB_VENDOR_SOHOWARE, USB_PRODUCT_SOHOWARE_NUB110,
	    "NUB110 Ethernet",
	},
	{
	    USB_VENDOR_SOLIDYEAR, USB_PRODUCT_SOLIDYEAR_KEYBOARD,
	    "Keyboard",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_DSC,
	    "Sony DSC Cameras",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_NWMS7,
	    "Memorystick NW-MS7",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_DRIVEV2,
	    "Harddrive V2",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_MSACUS1,
	    "Memorystick MSAC-US1",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_HANDYCAM,
	    "Handycam",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_MSC,
	    "Sony MSC Memorystick Slot",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_35,
	    "Clie v3.5",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2KEYBOARD,
	    "PlayStation2 keyboard",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2KEYBOARDHUB,
	    "PlayStation2 keyboard hub",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2MOUSE,
	    "PlayStation2 mouse",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_40,
	    "Clie v4.0",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_40_MS,
	    "Clie v4.0 Memory Stick slot",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_S360,
	    "Sony Clie s360",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_41_MS,
	    "Clie v4.1 Memory Stick slot",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_41,
	    "Clie v4.1",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_NX60,
	    "Sony Clie nx60",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_TJ25,
	    "Sony Clie tj25",
	},
	{
	    USB_VENDOR_SOURCENEXT, USB_PRODUCT_SOURCENEXT_KEIKAI8,
	    "KeikaiDenwa 8",
	},
	{
	    USB_VENDOR_SOURCENEXT, USB_PRODUCT_SOURCENEXT_KEIKAI8_CHG,
	    "KeikaiDenwa 8 with charger",
	},
	{
	    USB_VENDOR_SPEEDDRAGON, USB_PRODUCT_SPEEDDRAGON_MS3303H,
	    "MS3303H Serial",
	},
	{
	    USB_VENDOR_SPHAIRON, USB_PRODUCT_SPHAIRON_UB801R,
	    "UB801R",
	},
	{
	    USB_VENDOR_STMICRO, USB_PRODUCT_STMICRO_BIOMETRIC_COPR,
	    "Biometric Coprocessor",
	},
	{
	    USB_VENDOR_STMICRO, USB_PRODUCT_STMICRO_COMMUNICATOR,
	    "Communicator",
	},
	{
	    USB_VENDOR_STSN, USB_PRODUCT_STSN_STSN0001,
	    "Internet Access Device",
	},
	{
	    USB_VENDOR_SUNCOMM, USB_PRODUCT_SUNCOMM_MB_ADAPTOR,
	    "Mobile Adaptor",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_DS96L,
	    "U-Cable type D2",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_PS64P1,
	    "U-Cable type P1",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_VS10U,
	    "Slipper U",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_IS96U,
	    "Ir-Trinity",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_AS64LX,
	    "U-Cable type A3",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_AS144L4,
	    "U-Cable type A4",
	},
	{
	    USB_VENDOR_SUN, USB_PRODUCT_SUN_KEYBOARD6,
	    "Type 6 Keyboard",
	},
	{
	    USB_VENDOR_SUN, USB_PRODUCT_SUN_KEYBOARD7,
	    "Type 7 Keyboard",
	},
	{
	    USB_VENDOR_SUN, USB_PRODUCT_SUN_MOUSE,
	    "Type 6 Mouse",
	},
	{
	    USB_VENDOR_SYSTEMTALKS, USB_PRODUCT_SYSTEMTALKS_SGCX2UL,
	    "SGC-X2UL",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_SUPRAEXPRESS56K,
	    "Supra Express 56K",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_SUPRA2890,
	    "SupraMax 2890 56K",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_RIO600USB,
	    "Rio 600",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_RIO800USB,
	    "Rio 800",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_PSAPLAY120,
	    "Nike psa[play 120",
	},
	{
	    USB_VENDOR_ACERCM, USB_PRODUCT_ACERCM_EP1427X2,
	    "EP-1427X-2 Ethernet",
	},
	{
	    USB_VENDOR_SURECOM, USB_PRODUCT_SURECOM_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_SURECOM, USB_PRODUCT_SURECOM_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_SUSTEEN, USB_PRODUCT_SUSTEEN_DCU11,
	    "Ericsson DCU-10/11",
	},
	{
	    USB_VENDOR_SWEEX, USB_PRODUCT_SWEEX_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_SYNTECH, USB_PRODUCT_SYNTECH_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_TANGTOP, USB_PRODUCT_TANGTOP_USBPS2,
	    "USBPS2",
	},
	{
	    USB_VENDOR_TAUGA, USB_PRODUCT_TAUGA_CAMERAMATE,
	    "CameraMate (DPCM_USB)",
	},
	{
	    USB_VENDOR_TAPWAVE, USB_PRODUCT_TAPWAVE_ZODIAC,
	    "Zodiac",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UPA9664,
	    "USB-PDC Adapter UPA9664",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UCA1464,
	    "USB-cdmaOne Adapter UCA1464",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UHA6400,
	    "USB-PHS Adapter UHA6400",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UPA6400,
	    "USB-PHS Adapter UPA6400",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_TEAC, USB_PRODUCT_TEAC_FD05PUB,
	    "FD-05PUB",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_0193,
	    "ALLNET 0193 WLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZYAIR_B200,
	    "ZyXEL ZyAIR B200 WLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_U300C,
	    "U-300C",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_QUICKWLAN,
	    "QuickWLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZD1211_1,
	    "ZD1211",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZD1211_2,
	    "ZD1211",
	},
	{
	    USB_VENDOR_TELEX, USB_PRODUCT_TELEX_MIC1,
	    "Microphone",
	},
	{
	    USB_VENDOR_TENDA, USB_PRODUCT_TENDA_TWL541U,
	    "TWL541U WLAN",
	},
	{
	    USB_VENDOR_TENX, USB_PRODUCT_TENX_MISSILE,
	    "Missile Launcher",
	},
	{
	    USB_VENDOR_ISSC, USB_PRODUCT_ISSC_KYBT100,
	    "KY-BT100 Bluetooth",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_UTUSB41,
	    "UT-USB41 hub",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_TUSB2046,
	    "TUSB2046 hub",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_NEXII,
	    "Nex II Digital",
	},
	{
	    USB_VENDOR_THRUST, USB_PRODUCT_THRUST_FUSION_PAD,
	    "Fusion Digital Gamepad",
	},
	{
	    USB_VENDOR_TODOS, USB_PRODUCT_TODOS_ARGOS_MINI,
	    "Argos Mini Smartcard",
	},
	{
	    USB_VENDOR_TREK, USB_PRODUCT_TREK_THUMBDRIVE,
	    "ThumbDrive",
	},
	{
	    USB_VENDOR_TREK, USB_PRODUCT_TREK_THUMBDRIVE_8MB,
	    "ThumbDrive 8MB",
	},
	{
	    USB_VENDOR_TRIPPLITE, USB_PRODUCT_TRIPPLITE_U209,
	    "U209 Serial",
	},
	{
	    USB_VENDOR_TRUMPION, USB_PRODUCT_TRUMPION_T33521,
	    "USB/MP3 decoder",
	},
	{
	    USB_VENDOR_TRUMPION, USB_PRODUCT_TRUMPION_XXX1100,
	    "XXX 1100",
	},
	{
	    USB_VENDOR_TSUNAMI, USB_PRODUCT_TSUNAMI_SM2000,
	    "SM-2000",
	},
	{
	    USB_VENDOR_TWINMOS, USB_PRODUCT_TWINMOS_G240,
	    "G240",
	},
	{
	    USB_VENDOR_UBLOX, USB_PRODUCT_UBLOX_ANTARIS4,
	    "ANTARIS4 GPS",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UB_A,
	    "TEW-429UB_A",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UB,
	    "TEW-429UB",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW444UBEU,
	    "TEW-444UB EU",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW444UBEU_NF,
	    "TEW-444UB EU",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UBC1,
	    "TEW-429UB C1",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_ALL0298V2,
	    "ALL0298 v2",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ULTIMA, USB_PRODUCT_ULTIMA_1200UBPLUS,
	    "1200 UB Plus",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA1236U,
	    "Astra 1236U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA1220U,
	    "Astra 1220U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2000U,
	    "Astra 2000U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2100U,
	    "Astra 2100U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2200U,
	    "Astra 2200U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA3400,
	    "Astra 3400",
	},
	{
	    USB_VENDOR_UNIACCESS, USB_PRODUCT_UNIACCESS_PANACHE,
	    "Panache Surf ISDN",
	},
	{
	    USB_VENDOR_UNKNOWN1, USB_PRODUCT_UNKNOWN1_ZD1211B_1,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_UNKNOWN1, USB_PRODUCT_UNKNOWN1_ZD1211B_2,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_UNKNOWN2, USB_PRODUCT_UNKNOWN2_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_UNKNOWN3, USB_PRODUCT_UNKNOWN3_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR1120,
	    "USR1120 WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_A,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_A_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_A,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_A_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_B,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_B_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_B,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_B_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5422,
	    "USR5422 WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5421A,
	    "USR5421A WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5423,
	    "USR5423 WLAN",
	},
	{
	    USB_VENDOR_USI, USB_PRODUCT_USI_MC60,
	    "MC60 Serial",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_G773HUB,
	    "G773 Monitor Hub",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_P815HUB,
	    "P815 Monitor Hub",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_AIRSYNC,
	    "Airsync",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_G773CTRL,
	    "G773 Monitor Control",
	},
	{
	    USB_VENDOR_VISION, USB_PRODUCT_VISION_VC6452V002,
	    "CPiA Camera",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_7600,
	    "OneTouch 7600",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_5300,
	    "OneTouch 5300",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_3000,
	    "Scanport 3000",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_6100,
	    "OneTouch 6100",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_6200,
	    "OneTouch 6200",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_8100,
	    "OneTouch 8100",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_8600,
	    "OneTouch 8600",
	},
	{
	    USB_VENDOR_VIVITAR, USB_PRODUCT_VIVITAR_DSC350,
	    "DSC350",
	},
	{
	    USB_VENDOR_VTECH, USB_PRODUCT_VTECH_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_VTECH, USB_PRODUCT_VTECH_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_VODAFONEMC3G,
	    "Vodafone Mobile Connect 3G",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GFUSION,
	    "GlobeTrotter 3G FUSION",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GQUAD,
	    "GlobeTrotter 3G QUAD",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GQUADPLUS,
	    "GlobeTrotter 3G QUAD PLUS",
	},
	{
	    USB_VENDOR_WCH, USB_PRODUCT_WCH_CH341,
	    "CH341 serial/parallel",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_CT0405U,
	    "CT-0405-U Tablet",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE,
	    "Graphire",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE3_4X5,
	    "Graphire3 4x5",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE4_4X5,
	    "Graphire4 Classic A6",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_INTUOSA5,
	    "Intuos A5",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_UR055G,
	    "UR055G",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_XIRLINK, USB_PRODUCT_XIRLINK_IMAGING,
	    "Imaging Device",
	},
	{
	    USB_VENDOR_XIRLINK, USB_PRODUCT_XIRLINK_PCCAM,
	    "IBM PC Camera",
	},
	{
	    USB_VENDOR_YEDATA, USB_PRODUCT_YEDATA_FLASHBUSTERU,
	    "Flashbuster-U",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_UX256,
	    "UX256 MIDI I/F",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_UX96,
	    "UX96 MIDI I/F",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RPU200,
	    "RP-U200",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTA54I,
	    "NetVolante RTA54i",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTW65B,
	    "NetVolante RTW65b",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTW65I,
	    "NetVolante RTW65i",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTA55I,
	    "NetVolante RTA55i",
	},
	{
	    USB_VENDOR_YANO, USB_PRODUCT_YANO_U640MO,
	    "U640MO-03",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_M4Y750,
	    "M4Y-750",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_XI725,
	    "XI-725/726",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_XI735,
	    "XI-735",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_AR5523_NF,
	    "AR5523 driver",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_ZOOM, USB_PRODUCT_ZOOM_2986L,
	    "2986L Fax Modem",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1201,
	    "ZD1201",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_OMNI56K,
	    "Omni 56K Plus",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_980N,
	    "Scorpion-980N",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_ZYAIRG220,
	    "ZyAIR G-220",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_AG225H,
	    "AG-225H",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_M202,
	    "M-202",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G270S,
	    "G-270S",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G220V2,
	    "G-220 v2",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G202,
	    "G-202",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_PRESTIGE,
	    "Prestige",
	},
	{ 0, 0, NULL }
};

const struct usb_known_vendor usb_known_vendors[] = {
	{
	    USB_VENDOR_UNKNOWN1,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_UNKNOWN2,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_EGALAX2,
	    "eGalax",
	},
	{
	    USB_VENDOR_HUMAX,
	    "HUMAX",
	},
	{
	    USB_VENDOR_BWCT,
	    "Bernd Walter Computer Technology",
	},
	{
	    USB_VENDOR_AOX,
	    "AOX",
	},
	{
	    USB_VENDOR_ATMEL,
	    "Atmel",
	},
	{
	    USB_VENDOR_MITSUMI,
	    "Mitsumi",
	},
	{
	    USB_VENDOR_HP,
	    "Hewlett Packard",
	},
	{
	    USB_VENDOR_ADAPTEC,
	    "Adaptec",
	},
	{
	    USB_VENDOR_NATIONAL,
	    "National Semiconductor",
	},
	{
	    USB_VENDOR_ACERLABS,
	    "Acer Labs",
	},
	{
	    USB_VENDOR_FTDI,
	    "Future Technology Devices",
	},
	{
	    USB_VENDOR_NEC,
	    "NEC",
	},
	{
	    USB_VENDOR_KODAK,
	    "Eastman Kodak",
	},
	{
	    USB_VENDOR_MELCO,
	    "Melco",
	},
	{
	    USB_VENDOR_LEADTEK,
	    "Leadtek",
	},
	{
	    USB_VENDOR_CREATIVE,
	    "Creative Labs",
	},
	{
	    USB_VENDOR_CREATIVE2,
	    "Creative Labs",
	},
	{
	    USB_VENDOR_ADI,
	    "ADI Systems",
	},
	{
	    USB_VENDOR_CATC,
	    "Computer Access Technology",
	},
	{
	    USB_VENDOR_SMC2,
	    "Standard Microsystems",
	},
	{
	    USB_VENDOR_GRAVIS,
	    "Advanced Gravis Computer",
	},
	{
	    USB_VENDOR_SUN,
	    "Sun Microsystems",
	},
	{
	    USB_VENDOR_TAUGA,
	    "Taugagreining HF",
	},
	{
	    USB_VENDOR_AMD,
	    "Advanced Micro Devices",
	},
	{
	    USB_VENDOR_LEXMARK,
	    "Lexmark International",
	},
	{
	    USB_VENDOR_NANAO,
	    "NANAO",
	},
	{
	    USB_VENDOR_ALPS,
	    "Alps Electric",
	},
	{
	    USB_VENDOR_THRUST,
	    "Thrustmaster",
	},
	{
	    USB_VENDOR_TI,
	    "Texas Instruments",
	},
	{
	    USB_VENDOR_ANALOGDEVICES,
	    "Analog Devices",
	},
	{
	    USB_VENDOR_SIS,
	    "Silicon Integrated Systems Corp.",
	},
	{
	    USB_VENDOR_KYE,
	    "KYE Systems",
	},
	{
	    USB_VENDOR_DIAMOND2,
	    "Diamond (Supra)",
	},
	{
	    USB_VENDOR_MICROSOFT,
	    "Microsoft",
	},
	{
	    USB_VENDOR_PRIMAX,
	    "Primax Electronics",
	},
	{
	    USB_VENDOR_MGE,
	    "MGE UPS Systems",
	},
	{
	    USB_VENDOR_AMP,
	    "AMP",
	},
	{
	    USB_VENDOR_CHERRY,
	    "Cherry Mikroschalter",
	},
	{
	    USB_VENDOR_MEGATRENDS,
	    "American Megatrends",
	},
	{
	    USB_VENDOR_LOGITECH,
	    "Logitech",
	},
	{
	    USB_VENDOR_BTC,
	    "Behavior Tech. Computer",
	},
	{
	    USB_VENDOR_PHILIPS,
	    "Philips",
	},
	{
	    USB_VENDOR_SANYO,
	    "Sanyo Electric",
	},
	{
	    USB_VENDOR_CONNECTIX,
	    "Connectix",
	},
	{
	    USB_VENDOR_KENSINGTON,
	    "Kensington",
	},
	{
	    USB_VENDOR_LUCENT,
	    "Lucent",
	},
	{
	    USB_VENDOR_KYOCERA,
	    "Kyocera",
	},
	{
	    USB_VENDOR_PLANTRONICS,
	    "Plantronics",
	},
	{
	    USB_VENDOR_STMICRO,
	    "STMicroelectronics",
	},
	{
	    USB_VENDOR_YAMAHA,
	    "YAMAHA",
	},
	{
	    USB_VENDOR_COMPAQ,
	    "Compaq",
	},
	{
	    USB_VENDOR_HITACHI,
	    "Hitachi",
	},
	{
	    USB_VENDOR_ACERP,
	    "Acer Peripherals",
	},
	{
	    USB_VENDOR_DAVICOM,
	    "Davicom",
	},
	{
	    USB_VENDOR_VISIONEER,
	    "Visioneer",
	},
	{
	    USB_VENDOR_CANON,
	    "Canon",
	},
	{
	    USB_VENDOR_NIKON,
	    "Nikon",
	},
	{
	    USB_VENDOR_IBM,
	    "IBM",
	},
	{
	    USB_VENDOR_CYPRESS,
	    "Cypress Semiconductor",
	},
	{
	    USB_VENDOR_EPSON,
	    "Seiko Epson",
	},
	{
	    USB_VENDOR_RAINBOW,
	    "Rainbow Technologies",
	},
	{
	    USB_VENDOR_IODATA,
	    "I/O Data",
	},
	{
	    USB_VENDOR_TDK,
	    "TDK",
	},
	{
	    USB_VENDOR_3COMUSR,
	    "U.S. Robotics",
	},
	{
	    USB_VENDOR_METHODE,
	    "Methode Electronics Far East",
	},
	{
	    USB_VENDOR_MAXISWITCH,
	    "Maxi Switch",
	},
	{
	    USB_VENDOR_LOCKHEEDMER,
	    "Lockheed Martin Energy Research",
	},
	{
	    USB_VENDOR_FUJITSU,
	    "Fujitsu",
	},
	{
	    USB_VENDOR_TOSHIBAAM,
	    "Toshiba America",
	},
	{
	    USB_VENDOR_MICROMACRO,
	    "Micro Macro Technologies",
	},
	{
	    USB_VENDOR_KONICA,
	    "Konica",
	},
	{
	    USB_VENDOR_LITEON,
	    "Lite-On Technology",
	},
	{
	    USB_VENDOR_FUJIPHOTO,
	    "Fuji Photo Film",
	},
	{
	    USB_VENDOR_PHILIPSSEMI,
	    "Philips Semiconductors",
	},
	{
	    USB_VENDOR_TATUNG,
	    "Tatung Co. Of America",
	},
	{
	    USB_VENDOR_SCANLOGIC,
	    "ScanLogic",
	},
	{
	    USB_VENDOR_MYSON,
	    "Myson Technology",
	},
	{
	    USB_VENDOR_DIGI2,
	    "Digi",
	},
	{
	    USB_VENDOR_ITTCANON,
	    "ITT Canon",
	},
	{
	    USB_VENDOR_ALTEC,
	    "Altec Lansing",
	},
	{
	    USB_VENDOR_PANASONIC,
	    "Panasonic (Matsushita)",
	},
	{
	    USB_VENDOR_SHARP,
	    "Sharp",
	},
	{
	    USB_VENDOR_IIYAMA,
	    "Iiyama",
	},
	{
	    USB_VENDOR_SHUTTLE,
	    "Shuttle Technology",
	},
	{
	    USB_VENDOR_SAMSUNG2,
	    "Samsung Electronics",
	},
	{
	    USB_VENDOR_ANNABOOKS,
	    "Annabooks",
	},
	{
	    USB_VENDOR_JVC,
	    "JVC",
	},
	{
	    USB_VENDOR_CHICONY,
	    "Chicony Electronics",
	},
	{
	    USB_VENDOR_BROTHER,
	    "Brother Industries",
	},
	{
	    USB_VENDOR_DALLAS,
	    "Dallas Semiconductor",
	},
	{
	    USB_VENDOR_ACER,
	    "Acer",
	},
	{
	    USB_VENDOR_3COM,
	    "3Com",
	},
	{
	    USB_VENDOR_AZTECH,
	    "Aztech Systems",
	},
	{
	    USB_VENDOR_BELKIN,
	    "Belkin Components",
	},
	{
	    USB_VENDOR_KAWATSU,
	    "Kawatsu Semiconductor",
	},
	{
	    USB_VENDOR_APC,
	    "American Power Conversion",
	},
	{
	    USB_VENDOR_CONNECTEK,
	    "Advanced Connectek USA",
	},
	{
	    USB_VENDOR_NETCHIP,
	    "NetChip Technology",
	},
	{
	    USB_VENDOR_ALTRA,
	    "ALTRA",
	},
	{
	    USB_VENDOR_ATI,
	    "ATI Technologies",
	},
	{
	    USB_VENDOR_AKS,
	    "Aladdin Knowledge Systems",
	},
	{
	    USB_VENDOR_UNIACCESS,
	    "Universal Access",
	},
	{
	    USB_VENDOR_VIEWSONIC,
	    "ViewSonic",
	},
	{
	    USB_VENDOR_XIRLINK,
	    "Xirlink",
	},
	{
	    USB_VENDOR_ANCHOR,
	    "Anchor Chips",
	},
	{
	    USB_VENDOR_SONY,
	    "Sony",
	},
	{
	    USB_VENDOR_VISION,
	    "VLSI Vision",
	},
	{
	    USB_VENDOR_ASAHIKASEI,
	    "Asahi Kasei Microsystems",
	},
	{
	    USB_VENDOR_ATEN,
	    "ATEN International",
	},
	{
	    USB_VENDOR_SAMSUNG,
	    "Samsung",
	},
	{
	    USB_VENDOR_MUSTEK,
	    "Mustek Systems",
	},
	{
	    USB_VENDOR_TELEX,
	    "Telex Communications",
	},
	{
	    USB_VENDOR_PERACOM,
	    "Peracom Networks",
	},
	{
	    USB_VENDOR_ALCOR2,
	    "Alcor Micro",
	},
	{
	    USB_VENDOR_WACOM,
	    "WACOM",
	},
	{
	    USB_VENDOR_ETEK,
	    "e-TEK Labs",
	},
	{
	    USB_VENDOR_EIZO,
	    "EIZO",
	},
	{
	    USB_VENDOR_ELECOM,
	    "Elecom",
	},
	{
	    USB_VENDOR_HAUPPAUGE,
	    "Hauppauge Computer Works",
	},
	{
	    USB_VENDOR_BAFO,
	    "BAFO/Quality Computer Accessories",
	},
	{
	    USB_VENDOR_YEDATA,
	    "Y-E Data",
	},
	{
	    USB_VENDOR_AVM,
	    "AVM",
	},
	{
	    USB_VENDOR_QUICKSHOT,
	    "Quickshot",
	},
	{
	    USB_VENDOR_ROLAND,
	    "Roland",
	},
	{
	    USB_VENDOR_ROCKFIRE,
	    "Rockfire",
	},
	{
	    USB_VENDOR_RATOC,
	    "RATOC Systems",
	},
	{
	    USB_VENDOR_ZYXEL,
	    "ZyXEL Communication",
	},
	{
	    USB_VENDOR_ALCOR,
	    "Alcor Micro",
	},
	{
	    USB_VENDOR_IOMEGA,
	    "Iomega",
	},
	{
	    USB_VENDOR_ATREND,
	    "A-Trend Technology",
	},
	{
	    USB_VENDOR_AID,
	    "Advanced Input Devices",
	},
	{
	    USB_VENDOR_LACIE,
	    "LaCie",
	},
	{
	    USB_VENDOR_THRUSTMASTER,
	    "Thrustmaster",
	},
	{
	    USB_VENDOR_OMNIVISION,
	    "OmniVision",
	},
	{
	    USB_VENDOR_INSYSTEM,
	    "In-System Design",
	},
	{
	    USB_VENDOR_APPLE,
	    "Apple Computer",
	},
	{
	    USB_VENDOR_DIGI,
	    "Digi International",
	},
	{
	    USB_VENDOR_QUALCOMM,
	    "Qualcomm",
	},
	{
	    USB_VENDOR_QTRONIX,
	    "Qtronix",
	},
	{
	    USB_VENDOR_RICOH,
	    "Ricoh",
	},
	{
	    USB_VENDOR_ELSA,
	    "ELSA",
	},
	{
	    USB_VENDOR_BRAINBOXES,
	    "Brainboxes",
	},
	{
	    USB_VENDOR_ULTIMA,
	    "Ultima",
	},
	{
	    USB_VENDOR_AXIOHM,
	    "Axiohm Transaction Solutions",
	},
	{
	    USB_VENDOR_MICROTEK,
	    "Microtek",
	},
	{
	    USB_VENDOR_SUNTAC,
	    "SUN Corporation",
	},
	{
	    USB_VENDOR_LEXAR,
	    "Lexar Media",
	},
	{
	    USB_VENDOR_ADDTRON,
	    "Addtron",
	},
	{
	    USB_VENDOR_SYMBOL,
	    "Symbol Technologies",
	},
	{
	    USB_VENDOR_GENESYS,
	    "Genesys Logic",
	},
	{
	    USB_VENDOR_FUJI,
	    "Fuji Electric",
	},
	{
	    USB_VENDOR_KEITHLEY,
	    "Keithley Instruments",
	},
	{
	    USB_VENDOR_EIZONANAO,
	    "EIZO Nanao",
	},
	{
	    USB_VENDOR_KLSI,
	    "Kawasaki LSI",
	},
	{
	    USB_VENDOR_FFC,
	    "FFC",
	},
	{
	    USB_VENDOR_ANKO,
	    "Anko Electronic",
	},
	{
	    USB_VENDOR_PIENGINEERING,
	    "P.I. Engineering",
	},
	{
	    USB_VENDOR_AOC,
	    "AOC International",
	},
	{
	    USB_VENDOR_CHIC,
	    "Chic Technology",
	},
	{
	    USB_VENDOR_BARCO,
	    "Barco Display Systems",
	},
	{
	    USB_VENDOR_BRIDGE,
	    "Bridge Information",
	},
	{
	    USB_VENDOR_SOLIDYEAR,
	    "Solid Year",
	},
	{
	    USB_VENDOR_BIORAD,
	    "Bio-Rad Laboratories",
	},
	{
	    USB_VENDOR_MACALLY,
	    "Macally",
	},
	{
	    USB_VENDOR_ACTLABS,
	    "Act Labs",
	},
	{
	    USB_VENDOR_ALARIS,
	    "Alaris",
	},
	{
	    USB_VENDOR_APEX,
	    "Apex",
	},
	{
	    USB_VENDOR_VIVITAR,
	    "Vivitar",
	},
	{
	    USB_VENDOR_GUNZE,
	    "Gunze Electronics USA",
	},
	{
	    USB_VENDOR_AVISION,
	    "Avision",
	},
	{
	    USB_VENDOR_TEAC,
	    "TEAC",
	},
	{
	    USB_VENDOR_ARKMICRO,
	    "Arkmicro",
	},
	{
	    USB_VENDOR_SGI,
	    "Silicon Graphics",
	},
	{
	    USB_VENDOR_SANWASUPPLY,
	    "Sanwa Supply",
	},
	{
	    USB_VENDOR_LINKSYS,
	    "Linksys",
	},
	{
	    USB_VENDOR_ACERSA,
	    "Acer Semiconductor America",
	},
	{
	    USB_VENDOR_SIGMATEL,
	    "Sigmatel",
	},
	{
	    USB_VENDOR_DRAYTEK,
	    "DrayTek",
	},
	{
	    USB_VENDOR_AIWA,
	    "Aiwa",
	},
	{
	    USB_VENDOR_ACARD,
	    "ACARD Technology",
	},
	{
	    USB_VENDOR_PROLIFIC,
	    "Prolific Technology",
	},
	{
	    USB_VENDOR_SIEMENS,
	    "Siemens",
	},
	{
	    USB_VENDOR_AVANCELOGIC,
	    "Avance Logic",
	},
	{
	    USB_VENDOR_SIEMENS2,
	    "Siemens",
	},
	{
	    USB_VENDOR_MINOLTA,
	    "Minolta",
	},
	{
	    USB_VENDOR_CHPRODUCTS,
	    "CH Products",
	},
	{
	    USB_VENDOR_HAGIWARA,
	    "Hagiwara Sys-Com",
	},
	{
	    USB_VENDOR_CTX,
	    "Chuntex",
	},
	{
	    USB_VENDOR_ASKEY,
	    "Askey Computer",
	},
	{
	    USB_VENDOR_SAITEK,
	    "Saitek",
	},
	{
	    USB_VENDOR_ALCATELT,
	    "Alcatel Telecom",
	},
	{
	    USB_VENDOR_AGFA,
	    "AGFA-Gevaert",
	},
	{
	    USB_VENDOR_ASIAMD,
	    "Asia Microelectronic Development",
	},
	{
	    USB_VENDOR_BIZLINK,
	    "Bizlink International",
	},
	{
	    USB_VENDOR_KEYSPAN,
	    "Keyspan",
	},
	{
	    USB_VENDOR_AASHIMA,
	    "Aashima Technology",
	},
	{
	    USB_VENDOR_MULTITECH,
	    "MultiTech",
	},
	{
	    USB_VENDOR_ADS,
	    "ADS Technologies",
	},
	{
	    USB_VENDOR_ALCATELM,
	    "Alcatel Microelectronics",
	},
	{
	    USB_VENDOR_SIRIUS,
	    "Sirius Technologies",
	},
	{
	    USB_VENDOR_BOSTON,
	    "Boston Acoustics",
	},
	{
	    USB_VENDOR_GUILLEMOT,
	    "Guillemot",
	},
	{
	    USB_VENDOR_SMC,
	    "Standard Microsystems",
	},
	{
	    USB_VENDOR_PUTERCOM,
	    "Putercom",
	},
	{
	    USB_VENDOR_MCT,
	    "MCT",
	},
	{
	    USB_VENDOR_IMATION,
	    "Imation",
	},
	{
	    USB_VENDOR_SUSTEEN,
	    "Susteen",
	},
	{
	    USB_VENDOR_EICON,
	    "Eicon Networks",
	},
	{
	    USB_VENDOR_SYNTECH,
	    "Syntech Information",
	},
	{
	    USB_VENDOR_DIGITALSTREAM,
	    "Digital Stream",
	},
	{
	    USB_VENDOR_AUREAL,
	    "Aureal Semiconductor",
	},
	{
	    USB_VENDOR_MIDIMAN,
	    "Midiman",
	},
	{
	    USB_VENDOR_SURECOM,
	    "Surecom Technology",
	},
	{
	    USB_VENDOR_LINKSYS2,
	    "Linksys",
	},
	{
	    USB_VENDOR_GRIFFIN,
	    "Griffin Technology",
	},
	{
	    USB_VENDOR_SANDISK,
	    "SanDisk",
	},
	{
	    USB_VENDOR_JENOPTIK,
	    "Jenoptik",
	},
	{
	    USB_VENDOR_NOKIA,
	    "Nokia",
	},
	{
	    USB_VENDOR_BRIMAX,
	    "Brimax",
	},
	{
	    USB_VENDOR_AXIS,
	    "Axis Communications",
	},
	{
	    USB_VENDOR_ABL,
	    "ABL Electronics",
	},
	{
	    USB_VENDOR_SAGEM,
	    "Sagem",
	},
	{
	    USB_VENDOR_SUNCOMM,
	    "Sun Communications",
	},
	{
	    USB_VENDOR_ALFADATA,
	    "Alfadata Computer",
	},
	{
	    USB_VENDOR_NATIONALTECH,
	    "National Technical Systems",
	},
	{
	    USB_VENDOR_ONNTO,
	    "Onnto",
	},
	{
	    USB_VENDOR_BE,
	    "Be",
	},
	{
	    USB_VENDOR_ADMTEK,
	    "ADMtek",
	},
	{
	    USB_VENDOR_COREGA,
	    "Corega",
	},
	{
	    USB_VENDOR_FREECOM,
	    "Freecom",
	},
	{
	    USB_VENDOR_MICROTECH,
	    "Microtech",
	},
	{
	    USB_VENDOR_MOTOROLA3,
	    "Motorola",
	},
	{
	    USB_VENDOR_OLYMPUS,
	    "Olympus",
	},
	{
	    USB_VENDOR_ABOCOM,
	    "AboCom Systems",
	},
	{
	    USB_VENDOR_KEISOKUGIKEN,
	    "Keisokugiken",
	},
	{
	    USB_VENDOR_ONSPEC,
	    "OnSpec",
	},
	{
	    USB_VENDOR_APG,
	    "APG Cash Drawer",
	},
	{
	    USB_VENDOR_BUG,
	    "B.U.G.",
	},
	{
	    USB_VENDOR_ALLIEDTELESYN,
	    "Allied Telesyn International",
	},
	{
	    USB_VENDOR_AVERMEDIA,
	    "AVerMedia Technologies",
	},
	{
	    USB_VENDOR_SIIG,
	    "SIIG",
	},
	{
	    USB_VENDOR_CASIO,
	    "CASIO",
	},
	{
	    USB_VENDOR_DLINK2,
	    "D-Link",
	},
	{
	    USB_VENDOR_APTIO,
	    "Aptio Products",
	},
	{
	    USB_VENDOR_ARASAN,
	    "Arasan Chip Systems",
	},
	{
	    USB_VENDOR_ALLIEDCABLE,
	    "Allied Cable",
	},
	{
	    USB_VENDOR_STSN,
	    "STSN",
	},
	{
	    USB_VENDOR_ZOOM,
	    "Zoom Telephonics",
	},
	{
	    USB_VENDOR_BROADLOGIC,
	    "BroadLogic",
	},
	{
	    USB_VENDOR_HANDSPRING,
	    "Handspring",
	},
	{
	    USB_VENDOR_ACTIONSTAR,
	    "Action Star Enterprise",
	},
	{
	    USB_VENDOR_PALM,
	    "Palm Computing",
	},
	{
	    USB_VENDOR_SOURCENEXT,
	    "SOURCENEXT",
	},
	{
	    USB_VENDOR_ACCTON,
	    "Accton Technology",
	},
	{
	    USB_VENDOR_DIAMOND,
	    "Diamond",
	},
	{
	    USB_VENDOR_NETGEAR,
	    "BayNETGEAR",
	},
	{
	    USB_VENDOR_TOPRE,
	    "Topre Corporation",
	},
	{
	    USB_VENDOR_ACTIVEWIRE,
	    "ActiveWire",
	},
	{
	    USB_VENDOR_BBELECTRONICS,
	    "B&B Electronics",
	},
	{
	    USB_VENDOR_PORTGEAR,
	    "PortGear",
	},
	{
	    USB_VENDOR_NETGEAR2,
	    "Netgear",
	},
	{
	    USB_VENDOR_SYSTEMTALKS,
	    "System Talks",
	},
	{
	    USB_VENDOR_METRICOM,
	    "Metricom",
	},
	{
	    USB_VENDOR_ADESSOKBTEK,
	    "ADESSO/Kbtek America",
	},
	{
	    USB_VENDOR_JATON,
	    "Jaton",
	},
	{
	    USB_VENDOR_APT,
	    "APT Technologies",
	},
	{
	    USB_VENDOR_BOCARESEARCH,
	    "Boca Research",
	},
	{
	    USB_VENDOR_ANDREA,
	    "Andrea Electronics",
	},
	{
	    USB_VENDOR_BURRBROWN,
	    "Burr-Brown Japan",
	},
	{
	    USB_VENDOR_2WIRE,
	    "2Wire",
	},
	{
	    USB_VENDOR_AIPTEK,
	    "AIPTEK International",
	},
	{
	    USB_VENDOR_SMARTBRIDGES,
	    "SmartBridges",
	},
	{
	    USB_VENDOR_BILLIONTON,
	    "Billionton Systems",
	},
	{
	    USB_VENDOR_EXTENDED,
	    "Extended Systems",
	},
	{
	    USB_VENDOR_MSYSTEMS,
	    "M-Systems",
	},
	{
	    USB_VENDOR_AUTHENTEC,
	    "AuthenTec",
	},
	{
	    USB_VENDOR_AUDIOTECHNICA,
	    "Audio-Technica",
	},
	{
	    USB_VENDOR_TRUMPION,
	    "Trumpion Microelectronics",
	},
	{
	    USB_VENDOR_ALATION,
	    "Alation Systems",
	},
	{
	    USB_VENDOR_CONCORDCAMERA,
	    "Concord Camera",
	},
	{
	    USB_VENDOR_GARMIN,
	    "Garmin International",
	},
	{
	    USB_VENDOR_GOHUBS,
	    "GoHubs",
	},
	{
	    USB_VENDOR_BIOMETRIC,
	    "American Biometric Company",
	},
	{
	    USB_VENDOR_INTREPIDCS,
	    "Intrepid",
	},
	{
	    USB_VENDOR_YANO,
	    "Yano",
	},
	{
	    USB_VENDOR_KINGSTON,
	    "Kingston Technology",
	},
	{
	    USB_VENDOR_BLUEWATER,
	    "BlueWater Systems",
	},
	{
	    USB_VENDOR_AGILENT,
	    "Agilent Technologies",
	},
	{
	    USB_VENDOR_GUDE,
	    "Gude ADS",
	},
	{
	    USB_VENDOR_PORTSMITH,
	    "Portsmith",
	},
	{
	    USB_VENDOR_ACERW,
	    "Acer",
	},
	{
	    USB_VENDOR_ADIRONDACK,
	    "Adirondack Wire & Cable",
	},
	{
	    USB_VENDOR_BECKHOFF,
	    "Beckhoff",
	},
	{
	    USB_VENDOR_MINDSATWORK,
	    "Minds At Work",
	},
	{
	    USB_VENDOR_INTERSIL,
	    "Intersil",
	},
	{
	    USB_VENDOR_ALTIUS,
	    "Altius Solutions",
	},
	{
	    USB_VENDOR_ARRIS,
	    "Arris Interactive",
	},
	{
	    USB_VENDOR_ACTIVCARD,
	    "ACTIVCARD",
	},
	{
	    USB_VENDOR_ACTISYS,
	    "ACTiSYS",
	},
	{
	    USB_VENDOR_AFOURTECH,
	    "A-FOUR TECH",
	},
	{
	    USB_VENDOR_AIMEX,
	    "AIMEX",
	},
	{
	    USB_VENDOR_ADDONICS,
	    "Addonics Technologies",
	},
	{
	    USB_VENDOR_AKAI,
	    "AKAI professional M.I.",
	},
	{
	    USB_VENDOR_ARESCOM,
	    "ARESCOM",
	},
	{
	    USB_VENDOR_BAY,
	    "Bay Associates",
	},
	{
	    USB_VENDOR_ALTERA,
	    "Altera",
	},
	{
	    USB_VENDOR_CSR,
	    "Cambridge Silicon Radio",
	},
	{
	    USB_VENDOR_TREK,
	    "Trek Technology",
	},
	{
	    USB_VENDOR_ASAHIOPTICAL,
	    "Asahi Optical",
	},
	{
	    USB_VENDOR_BOCASYSTEMS,
	    "Boca Systems",
	},
	{
	    USB_VENDOR_SHANTOU,
	    "ShanTou",
	},
	{
	    USB_VENDOR_BROADCOM,
	    "Broadcom",
	},
	{
	    USB_VENDOR_GREENHOUSE,
	    "GREENHOUSE",
	},
	{
	    USB_VENDOR_GEOCAST,
	    "Geocast Network Systems",
	},
	{
	    USB_VENDOR_IDQUANTIQUE,
	    "id Quantique",
	},
	{
	    USB_VENDOR_ZYDAS,
	    "ZyDAS Technology",
	},
	{
	    USB_VENDOR_NEODIO,
	    "Neodio",
	},
	{
	    USB_VENDOR_OPTION,
	    "Option",
	},
	{
	    USB_VENDOR_TODOS,
	    "Todos Data System",
	},
	{
	    USB_VENDOR_ASUS,
	    "ASUS",
	},
	{
	    USB_VENDOR_SIIG2,
	    "SIIG",
	},
	{
	    USB_VENDOR_TEKRAM,
	    "Tekram Technology",
	},
	{
	    USB_VENDOR_HAL,
	    "HAL Corporation",
	},
	{
	    USB_VENDOR_NEC2,
	    "NEC",
	},
	{
	    USB_VENDOR_ATI2,
	    "ATI",
	},
	{
	    USB_VENDOR_KURUSUGAWA,
	    "Kurusugawa Electronics",
	},
	{
	    USB_VENDOR_ASIX,
	    "ASIX Electronics",
	},
	{
	    USB_VENDOR_USR,
	    "U.S. Robotics",
	},
	{
	    USB_VENDOR_AMBIT,
	    "Ambit Microsystems",
	},
	{
	    USB_VENDOR_REALTEK,
	    "Realtek",
	},
	{
	    USB_VENDOR_ADDONICS2,
	    "Addonics Technology",
	},
	{
	    USB_VENDOR_AGATE,
	    "Agate Technologies",
	},
	{
	    USB_VENDOR_DMI,
	    "DMI",
	},
	{
	    USB_VENDOR_MICRODIA,
	    "Microdia",
	},
	{
	    USB_VENDOR_SEALEVEL,
	    "Sealevel System",
	},
	{
	    USB_VENDOR_EASYDISK,
	    "EasyDisk",
	},
	{
	    USB_VENDOR_KYOCERA2,
	    "Kyocera",
	},
	{
	    USB_VENDOR_ZCOM,
	    "Z-Com",
	},
	{
	    USB_VENDOR_ATHEROS2,
	    "Atheros Communications",
	},
	{
	    USB_VENDOR_TANGTOP,
	    "Tangtop",
	},
	{
	    USB_VENDOR_SMC3,
	    "SMC",
	},
	{
	    USB_VENDOR_PEN,
	    "Pen Drive",
	},
	{
	    USB_VENDOR_ABC,
	    "ABC",
	},
	{
	    USB_VENDOR_CONCEPTRONIC,
	    "Conceptronic",
	},
	{
	    USB_VENDOR_MSI,
	    "Micro Star International",
	},
	{
	    USB_VENDOR_ELCON,
	    "ELCON Systemtechnik",
	},
	{
	    USB_VENDOR_SITECOMEU,
	    "Sitecom Europe",
	},
	{
	    USB_VENDOR_MOBILEACTION,
	    "Mobile Action",
	},
	{
	    USB_VENDOR_SPEEDDRAGON,
	    "Speed Dragon Multimedia",
	},
	{
	    USB_VENDOR_HAWKING,
	    "Hawking",
	},
	{
	    USB_VENDOR_GMATE,
	    "G.Mate",
	},
	{
	    USB_VENDOR_OTI,
	    "Ours Technology",
	},
	{
	    USB_VENDOR_PILOTECH,
	    "Pilotech",
	},
	{
	    USB_VENDOR_NOVATECH,
	    "Nova Tech",
	},
	{
	    USB_VENDOR_EGALAX,
	    "eGalax",
	},
	{
	    USB_VENDOR_ITEGNO,
	    "iTegno",
	},
	{
	    USB_VENDOR_AIRPRIME,
	    "Airprime",
	},
	{
	    USB_VENDOR_VTECH,
	    "VTech",
	},
	{
	    USB_VENDOR_FALCOM,
	    "Falcom Wireless Communications GmbH",
	},
	{
	    USB_VENDOR_RIM,
	    "Research In Motion",
	},
	{
	    USB_VENDOR_DYNASTREAM,
	    "Dynastream Innovations",
	},
	{
	    USB_VENDOR_QUALCOMM2,
	    "Qualcomm",
	},
	{
	    USB_VENDOR_GIGABYTE,
	    "GIGABYTE",
	},
	{
	    USB_VENDOR_MOTOROLA,
	    "Motorola",
	},
	{
	    USB_VENDOR_CCYU,
	    "CCYU Technology",
	},
	{
	    USB_VENDOR_AUDIOVOX,
	    "Audiovox",
	},
	{
	    USB_VENDOR_SILABS2,
	    "SILABS2",
	},
	{
	    USB_VENDOR_USI,
	    "USI",
	},
	{
	    USB_VENDOR_PLX,
	    "PLX",
	},
	{
	    USB_VENDOR_ASANTE,
	    "Asante",
	},
	{
	    USB_VENDOR_SILABS,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_ANALOG,
	    "Analog Devices",
	},
	{
	    USB_VENDOR_TENX,
	    "Ten X Technology, Inc.",
	},
	{
	    USB_VENDOR_ISSC,
	    "Integrated System Solution Corp.",
	},
	{
	    USB_VENDOR_JRC,
	    "Japan Radio Company",
	},
	{
	    USB_VENDOR_SPHAIRON,
	    "Sphairon Access Systems GmbH",
	},
	{
	    USB_VENDOR_DELORME,
	    "DeLorme",
	},
	{
	    USB_VENDOR_SERVERWORKS,
	    "ServerWorks",
	},
	{
	    USB_VENDOR_ACERCM,
	    "Acer Communications & Multimedia",
	},
	{
	    USB_VENDOR_SIERRA,
	    "Sierra Wireless",
	},
	{
	    USB_VENDOR_SIEMENS3,
	    "Siemens",
	},
	{
	    USB_VENDOR_ALCATEL,
	    "Alcatel",
	},
	{
	    USB_VENDOR_UNKNOWN3,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_TSUNAMI,
	    "Tsunami",
	},
	{
	    USB_VENDOR_PHEENET,
	    "Pheenet",
	},
	{
	    USB_VENDOR_RAPTORGAMING,
	    "Raptor Gaming",
	},
	{
	    USB_VENDOR_TWINMOS,
	    "TwinMOS",
	},
	{
	    USB_VENDOR_TENDA,
	    "Tenda",
	},
	{
	    USB_VENDOR_BELKIN2,
	    "Belkin Components",
	},
	{
	    USB_VENDOR_CYBERTAN,
	    "CyberTAN Technology",
	},
	{
	    USB_VENDOR_HUAWEI,
	    "HUAWEI Technologies",
	},
	{
	    USB_VENDOR_ARANEUS,
	    "Araneus Information Systems",
	},
	{
	    USB_VENDOR_TAPWAVE,
	    "Tapwave",
	},
	{
	    USB_VENDOR_AINCOMM,
	    "Aincomm",
	},
	{
	    USB_VENDOR_MOBILITY,
	    "Mobility",
	},
	{
	    USB_VENDOR_DICKSMITH,
	    "Dick Smith Electronics",
	},
	{
	    USB_VENDOR_NETGEAR3,
	    "Netgear",
	},
	{
	    USB_VENDOR_BALTECH,
	    "Baltech",
	},
	{
	    USB_VENDOR_CISCOLINKSYS,
	    "Cisco-Linksys",
	},
	{
	    USB_VENDOR_SHARK,
	    "Shark",
	},
	{
	    USB_VENDOR_NOVATEL,
	    "Novatel Wireless",
	},
	{
	    USB_VENDOR_WISTRONNEWEB,
	    "Wistron NeWeb",
	},
	{
	    USB_VENDOR_RADIOSHACK,
	    "Radio Shack",
	},
	{
	    USB_VENDOR_HUAWEI3COM,
	    "Huawei 3Com",
	},
	{
	    USB_VENDOR_SILICOM,
	    "Silicom",
	},
	{
	    USB_VENDOR_RALINK,
	    "Ralink Technology",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2,
	    "Conceptronic",
	},
	{
	    USB_VENDOR_PLANEX3,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_SILICONPORTALS,
	    "Silicon Portals",
	},
	{
	    USB_VENDOR_UBLOX,
	    "U-blox",
	},
	{
	    USB_VENDOR_OQO,
	    "OQO",
	},
	{
	    USB_VENDOR_UMEDIA,
	    "U-MEDIA Communications",
	},
	{
	    USB_VENDOR_FIBERLINE,
	    "Fiberline",
	},
	{
	    USB_VENDOR_SOHOWARE,
	    "SOHOware",
	},
	{
	    USB_VENDOR_UMAX,
	    "UMAX Data Systems",
	},
	{
	    USB_VENDOR_INSIDEOUT,
	    "Inside Out Networks",
	},
	{
	    USB_VENDOR_GOODWAY,
	    "Good Way Technology",
	},
	{
	    USB_VENDOR_ENTREGA,
	    "Entrega",
	},
	{
	    USB_VENDOR_ACTIONTEC,
	    "Actiontec Electronics",
	},
	{
	    USB_VENDOR_ATHEROS,
	    "Atheros Communications",
	},
	{
	    USB_VENDOR_GIGASET,
	    "Gigaset",
	},
	{
	    USB_VENDOR_GLOBALSUN,
	    "Global Sun Technology",
	},
	{
	    USB_VENDOR_ANYDATA,
	    "AnyDATA Inc.",
	},
	{
	    USB_VENDOR_JABLOTRON,
	    "Jablotron",
	},
	{
	    USB_VENDOR_CMOTECH,
	    "CMOTECH CDMA Technologies",
	},
	{
	    USB_VENDOR_LINKSYS4,
	    "Linksys",
	},
	{
	    USB_VENDOR_SENAO,
	    "Senao",
	},
	{
	    USB_VENDOR_METAGEEK,
	    "MetaGeek",
	},
	{
	    USB_VENDOR_AMIT,
	    "AMIT",
	},
	{
	    USB_VENDOR_QCOM,
	    "Qcom",
	},
	{
	    USB_VENDOR_LINKSYS3,
	    "Linksys",
	},
	{
	    USB_VENDOR_DLINK,
	    "D-Link",
	},
	{
	    USB_VENDOR_PLANEX2,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_MOTOROLA2,
	    "Motorola",
	},
	{
	    USB_VENDOR_TRIPPLITE,
	    "Tripp-Lite",
	},
	{
	    USB_VENDOR_NHJ,
	    "NHJ",
	},
	{
	    USB_VENDOR_ASUSTEK,
	    "ASUSTeK Computer",
	},
	{
	    USB_VENDOR_PLANEX,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_AEI,
	    "AEI",
	},
	{
	    USB_VENDOR_PQI,
	    "PQI",
	},
	{
	    USB_VENDOR_DAISY,
	    "Daisy Technology",
	},
	{
	    USB_VENDOR_NI,
	    "National Instruments",
	},
	{
	    USB_VENDOR_MICRONET,
	    "Micronet Communications",
	},
	{
	    USB_VENDOR_IODATA2,
	    "I-O Data",
	},
	{
	    USB_VENDOR_IRIVER,
	    "iRiver",
	},
	{
	    USB_VENDOR_DELL,
	    "Dell",
	},
	{
	    USB_VENDOR_WCH,
	    "QinHeng Electronics",
	},
	{
	    USB_VENDOR_ACEECA,
	    "Aceeca",
	},
	{
	    USB_VENDOR_AVERATEC,
	    "Averatec",
	},
	{
	    USB_VENDOR_SWEEX,
	    "Sweex",
	},
	{
	    USB_VENDOR_PROLIFIC2,
	    "Prolific Technology",
	},
	{
	    USB_VENDOR_ONSPEC2,
	    "OnSpec",
	},
	{
	    USB_VENDOR_ZINWELL,
	    "Zinwell",
	},
	{
	    USB_VENDOR_SITECOM,
	    "Sitecom",
	},
	{
	    USB_VENDOR_3COM2,
	    "3Com",
	},
	{
	    USB_VENDOR_INTEL,
	    "Intel",
	},
	{
	    USB_VENDOR_SITECOM2,
	    "Sitecom",
	},
	{
	    USB_VENDOR_MOSCHIP,
	    "MosChip",
	},
	{
	    USB_VENDOR_3COM3,
	    "3Com",
	},
	{
	    USB_VENDOR_HP2,
	    "Hewlett Packard",
	},
	{ 0, NULL }
};
