require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&ESS_ACMD_DAC8WRITE)) {
    sub ESS_ACMD_DAC8WRITE () {	0x10;}
}
unless(defined(&ESS_ACMD_DAC16WRITE)) {
    sub ESS_ACMD_DAC16WRITE () {	0x11;}
}
unless(defined(&ESS_ACMD_DMA8OUT)) {
    sub ESS_ACMD_DMA8OUT () {	0x14;}
}
unless(defined(&ESS_ACMD_DMA16OUT)) {
    sub ESS_ACMD_DMA16OUT () {	0x15;}
}
unless(defined(&ESS_ACMD_AUTODMA8OUT)) {
    sub ESS_ACMD_AUTODMA8OUT () {	0x1c;}
}
unless(defined(&ESS_ACMD_AUTODMA16OUT)) {
    sub ESS_ACMD_AUTODMA16OUT () {	0x1d;}
}
unless(defined(&ESS_ACMD_ADC8READ)) {
    sub ESS_ACMD_ADC8READ () {	0x20;}
}
unless(defined(&ESS_ACMD_ADC16READ)) {
    sub ESS_ACMD_ADC16READ () {	0x21;}
}
unless(defined(&ESS_ACMD_DMA8IN)) {
    sub ESS_ACMD_DMA8IN () {	0x24;}
}
unless(defined(&ESS_ACMD_DMA16IN)) {
    sub ESS_ACMD_DMA16IN () {	0x25;}
}
unless(defined(&ESS_ACMD_AUTODMA8IN)) {
    sub ESS_ACMD_AUTODMA8IN () {	0x2c;}
}
unless(defined(&ESS_ACMD_AUTODMA16IN)) {
    sub ESS_ACMD_AUTODMA16IN () {	0x2d;}
}
unless(defined(&ESS_ACMD_SETTIMECONST1)) {
    sub ESS_ACMD_SETTIMECONST1 () {	0x40;}
}
unless(defined(&ESS_ACMD_SETTIMECONST15)) {
    sub ESS_ACMD_SETTIMECONST15 () {	0x41;}
}
unless(defined(&ESS_ACMD_SETFILTER)) {
    sub ESS_ACMD_SETFILTER () {	0x42;}
}
unless(defined(&ESS_ACMD_BLOCKSIZE)) {
    sub ESS_ACMD_BLOCKSIZE () {	0x48;}
}
unless(defined(&ESS_ACMD_DMA4OUT)) {
    sub ESS_ACMD_DMA4OUT () {	0x74;}
}
unless(defined(&ESS_ACMD_DMA4OUTREF)) {
    sub ESS_ACMD_DMA4OUTREF () {	0x75;}
}
unless(defined(&ESS_ACMD_DMA2_6OUT)) {
    sub ESS_ACMD_DMA2_6OUT () {	0x76;}
}
unless(defined(&ESS_ACMD_DMA2_6OUTREF)) {
    sub ESS_ACMD_DMA2_6OUTREF () {	0x77;}
}
unless(defined(&ESS_ACMD_DMA2OUT)) {
    sub ESS_ACMD_DMA2OUT () {	0x7a;}
}
unless(defined(&ESS_ACMD_DMA2OUTREF)) {
    sub ESS_ACMD_DMA2OUTREF () {	0x7b;}
}
unless(defined(&ESS_ACMD_SILENCEOUT)) {
    sub ESS_ACMD_SILENCEOUT () {	0x80;}
}
unless(defined(&ESS_ACMD_START_AUTO_OUT)) {
    sub ESS_ACMD_START_AUTO_OUT () {	0x90;}
}
unless(defined(&ESS_ACMD_START_OUT)) {
    sub ESS_ACMD_START_OUT () {	0x91;}
}
unless(defined(&ESS_ACMD_START_AUTO_IN)) {
    sub ESS_ACMD_START_AUTO_IN () {	0x98;}
}
unless(defined(&ESS_ACMD_START_IN)) {
    sub ESS_ACMD_START_IN () {	0x99;}
}
unless(defined(&ESS_XCMD_SAMPLE_RATE)) {
    sub ESS_XCMD_SAMPLE_RATE () {	0xa1;}
}
unless(defined(&ESS_XCMD_FILTER_CLOCK)) {
    sub ESS_XCMD_FILTER_CLOCK () {	0xa2;}
}
unless(defined(&ESS_XCMD_XFER_COUNTLO)) {
    sub ESS_XCMD_XFER_COUNTLO () {	0xa4;}
}
unless(defined(&ESS_XCMD_XFER_COUNTHI)) {
    sub ESS_XCMD_XFER_COUNTHI () {	0xa5;}
}
unless(defined(&ESS_XCMD_AUDIO_CTRL)) {
    sub ESS_XCMD_AUDIO_CTRL () {	0xa8;}
}
unless(defined(&ESS_AUDIO_CTRL_MONITOR)) {
    sub ESS_AUDIO_CTRL_MONITOR () {	0x8;}
}
unless(defined(&ESS_AUDIO_CTRL_MONO)) {
    sub ESS_AUDIO_CTRL_MONO () {	0x2;}
}
unless(defined(&ESS_AUDIO_CTRL_STEREO)) {
    sub ESS_AUDIO_CTRL_STEREO () {	0x1;}
}
unless(defined(&ESS_XCMD_PREAMP_CTRL)) {
    sub ESS_XCMD_PREAMP_CTRL () {	0xa9;}
}
unless(defined(&ESS_PREAMP_CTRL_ENABLE)) {
    sub ESS_PREAMP_CTRL_ENABLE () {	0x4;}
}
unless(defined(&ESS_XCMD_IRQ_CTRL)) {
    sub ESS_XCMD_IRQ_CTRL () {	0xb1;}
}
unless(defined(&ESS_IRQ_CTRL_INTRA)) {
    sub ESS_IRQ_CTRL_INTRA () {	0x;}
}
unless(defined(&ESS_IRQ_CTRL_INTRB)) {
    sub ESS_IRQ_CTRL_INTRB () {	0x4;}
}
unless(defined(&ESS_IRQ_CTRL_INTRC)) {
    sub ESS_IRQ_CTRL_INTRC () {	0x8;}
}
unless(defined(&ESS_IRQ_CTRL_INTRD)) {
    sub ESS_IRQ_CTRL_INTRD () {	0xc;}
}
unless(defined(&ESS_IRQ_CTRL_MASK)) {
    sub ESS_IRQ_CTRL_MASK () {	0x10;}
}
unless(defined(&ESS_IRQ_CTRL_EXT)) {
    sub ESS_IRQ_CTRL_EXT () {	0x40;}
}
unless(defined(&ESS_XCMD_DRQ_CTRL)) {
    sub ESS_XCMD_DRQ_CTRL () {	0xb2;}
}
unless(defined(&ESS_DRQ_CTRL_DRQA)) {
    sub ESS_DRQ_CTRL_DRQA () {	0x4;}
}
unless(defined(&ESS_DRQ_CTRL_DRQB)) {
    sub ESS_DRQ_CTRL_DRQB () {	0x8;}
}
unless(defined(&ESS_DRQ_CTRL_DRQC)) {
    sub ESS_DRQ_CTRL_DRQC () {	0xc;}
}
unless(defined(&ESS_DRQ_CTRL_PU)) {
    sub ESS_DRQ_CTRL_PU () {	0x10;}
}
unless(defined(&ESS_DRQ_CTRL_EXT)) {
    sub ESS_DRQ_CTRL_EXT () {	0x40;}
}
unless(defined(&ESS_XCMD_VOLIN_CTRL)) {
    sub ESS_XCMD_VOLIN_CTRL () {	0xb4;}
}
unless(defined(&ESS_1788_XCMD_AUDIO_CTRL0)) {
    sub ESS_1788_XCMD_AUDIO_CTRL0 () {	0xb6;}
}
unless(defined(&ESS_CTRL0_SIGNED)) {
    sub ESS_CTRL0_SIGNED () {	0x;}
}
unless(defined(&ESS_CTRL0_UNSIGNED)) {
    sub ESS_CTRL0_UNSIGNED () {	0x80;}
}
unless(defined(&ESS_XCMD_AUDIO1_CTRL1)) {
    sub ESS_XCMD_AUDIO1_CTRL1 () {	0xb7;}
}
unless(defined(&ESS_AUDIO1_CTRL1_FIFO_CONNECT)) {
    sub ESS_AUDIO1_CTRL1_FIFO_CONNECT () {	0x80;}
}
unless(defined(&ESS_AUDIO1_CTRL1_FIFO_MONO)) {
    sub ESS_AUDIO1_CTRL1_FIFO_MONO () {	0x40;}
}
unless(defined(&ESS_AUDIO1_CTRL1_FIFO_SIGNED)) {
    sub ESS_AUDIO1_CTRL1_FIFO_SIGNED () {	0x20;}
}
unless(defined(&ESS_AUDIO1_CTRL1_FIFO_STEREO)) {
    sub ESS_AUDIO1_CTRL1_FIFO_STEREO () {	0x8;}
}
unless(defined(&ESS_AUDIO1_CTRL1_FIFO_SIZE)) {
    sub ESS_AUDIO1_CTRL1_FIFO_SIZE () {	0x4;}
}
unless(defined(&ESS_XCMD_AUDIO1_CTRL2)) {
    sub ESS_XCMD_AUDIO1_CTRL2 () {	0xb8;}
}
unless(defined(&ESS_AUDIO1_CTRL2_FIFO_ENABLE)) {
    sub ESS_AUDIO1_CTRL2_FIFO_ENABLE () {	0x1;}
}
unless(defined(&ESS_AUDIO1_CTRL2_DMA_READ)) {
    sub ESS_AUDIO1_CTRL2_DMA_READ () {	0x2;}
}
unless(defined(&ESS_AUDIO1_CTRL2_AUTO_INIT)) {
    sub ESS_AUDIO1_CTRL2_AUTO_INIT () {	0x4;}
}
unless(defined(&ESS_AUDIO1_CTRL2_ADC_ENABLE)) {
    sub ESS_AUDIO1_CTRL2_ADC_ENABLE () {	0x8;}
}
unless(defined(&ESS_XCMD_DEMAND_CTRL)) {
    sub ESS_XCMD_DEMAND_CTRL () {	0xb9;}
}
unless(defined(&ESS_DEMAND_CTRL_SINGLE)) {
    sub ESS_DEMAND_CTRL_SINGLE () {	0x;}
}
unless(defined(&ESS_DEMAND_CTRL_DEMAND_2)) {
    sub ESS_DEMAND_CTRL_DEMAND_2 () {	0x1;}
}
unless(defined(&ESS_DEMAND_CTRL_DEMAND_4)) {
    sub ESS_DEMAND_CTRL_DEMAND_4 () {	0x2;}
}
unless(defined(&ESS_ACMD_ENABLE_EXT)) {
    sub ESS_ACMD_ENABLE_EXT () {	0xc6;}
}
unless(defined(&ESS_ACMD_DISABLE_EXT)) {
    sub ESS_ACMD_DISABLE_EXT () {	0xc7;}
}
unless(defined(&ESS_ACMD_PAUSE_DMA)) {
    sub ESS_ACMD_PAUSE_DMA () {	0xd0;}
}
unless(defined(&ESS_ACMD_ENABLE_SPKR)) {
    sub ESS_ACMD_ENABLE_SPKR () {	0xd1;}
}
unless(defined(&ESS_ACMD_DISABLE_SPKR)) {
    sub ESS_ACMD_DISABLE_SPKR () {	0xd3;}
}
unless(defined(&ESS_ACMD_CONT_DMA)) {
    sub ESS_ACMD_CONT_DMA () {	0xd4;}
}
unless(defined(&ESS_ACMD_SPKR_STATUS)) {
    sub ESS_ACMD_SPKR_STATUS () {	0xd8;}
}
unless(defined(&ESS_SPKR_OFF)) {
    sub ESS_SPKR_OFF () {	0x;}
}
unless(defined(&ESS_SPKR_ON)) {
    sub ESS_SPKR_ON () {	0xff;}
}
unless(defined(&ESS_ACMD_VERSION)) {
    sub ESS_ACMD_VERSION () {	0xe1;}
}
unless(defined(&ESS_ACMD_LEGACY_ID)) {
    sub ESS_ACMD_LEGACY_ID () {	0xe7;}
}
unless(defined(&ESS_MINRATE)) {
    sub ESS_MINRATE () {	4000;}
}
unless(defined(&ESS_MAXRATE)) {
    sub ESS_MAXRATE () {	44100;}
}
unless(defined(&ESS_BASE_VALID)) {
    sub ESS_BASE_VALID {
	my($base) = @_;
	eval q((($base) == 0x220 || ($base) == 0x230 || ($base) == 0x240 || ($base) == 0x250));
    }
}
unless(defined(&ESS_IRQ1_VALID)) {
    sub ESS_IRQ1_VALID {
	my($irq) = @_;
	eval q((($irq) == 5|| ($irq) == 7|| ($irq) == 9|| ($irq) == 10));
    }
}
unless(defined(&ESS_IRQ2_VALID)) {
    sub ESS_IRQ2_VALID {
	my($irq) = @_;
	eval q((($irq) == 15));
    }
}
unless(defined(&ESS_IRQ12_VALID)) {
    sub ESS_IRQ12_VALID {
	my($irq) = @_;
	eval q((($irq) == 5|| ($irq) == 7|| ($irq) == 9|| ($irq) == 10|| ($irq) == 15));
    }
}
unless(defined(&ESS_DRQ1_VALID)) {
    sub ESS_DRQ1_VALID {
	my($chan) = @_;
	eval q((($chan) == 0|| ($chan) == 1|| ($chan) == 3));
    }
}
unless(defined(&ESS_DRQ2_VALID)) {
    sub ESS_DRQ2_VALID {
	my($chan) = @_;
	eval q((($chan) == 0|| ($chan) == 1|| ($chan) == 3|| ($chan) == 5));
    }
}
unless(defined(&ESS_USE_AUDIO1)) {
    sub ESS_USE_AUDIO1 {
	my($model) = @_;
	eval q(((($model) ==  &ESS_1788) || (($model) ==  &ESS_1868) || (($model) == &ESS_1878) || (($model) ==  &ESS_1869) || (($model) ==  &ESS_1879)));
    }
}
unless(defined(&ESS_4BIT_GAIN)) {
    sub ESS_4BIT_GAIN {
	my($x) = @_;
	eval q((($x) & 0xf0));
    }
}
unless(defined(&ESS_3BIT_GAIN)) {
    sub ESS_3BIT_GAIN {
	my($x) = @_;
	eval q(((($x) & 0xe0) >> 1));
    }
}
unless(defined(&ESS_STEREO_GAIN)) {
    sub ESS_STEREO_GAIN {
	my($l, $r) = @_;
	eval q((($l) | (($r) >> 4)));
    }
}
unless(defined(&ESS_MONO_GAIN)) {
    sub ESS_MONO_GAIN {
	my($x) = @_;
	eval q((($x) >> 4));
    }
}
if(defined(&ESS_AMODE_LOW)) {
    eval 'sub ESS_CONFIG_KEY_BASE () {0x229;}' unless defined(&ESS_CONFIG_KEY_BASE);
    eval 'sub ESS_CONFIG_KEY_PORTS () {3;}' unless defined(&ESS_CONFIG_KEY_PORTS);
} else {
    eval 'sub ESS_SCR_ACCESS_BASE () {0xf9;}' unless defined(&ESS_SCR_ACCESS_BASE);
    eval 'sub ESS_SCR_ACCESS_PORTS () {3;}' unless defined(&ESS_SCR_ACCESS_PORTS);
    eval 'sub ESS_SCR_LOCK () {0;}' unless defined(&ESS_SCR_LOCK);
    eval 'sub ESS_SCR_UNLOCK () {2;}' unless defined(&ESS_SCR_UNLOCK);
    eval 'sub ESS_SCR_BASE () {0xe0;}' unless defined(&ESS_SCR_BASE);
    eval 'sub ESS_SCR_PORTS () {2;}' unless defined(&ESS_SCR_PORTS);
    eval 'sub ESS_SCR_INDEX () {0;}' unless defined(&ESS_SCR_INDEX);
    eval 'sub ESS_SCR_DATA () {1;}' unless defined(&ESS_SCR_DATA);
    eval 'sub ESS_SCR_AUDIO_ENABLE () {0x4;}' unless defined(&ESS_SCR_AUDIO_ENABLE);
    eval 'sub ESS_SCR_AUDIO_220 () {0x;}' unless defined(&ESS_SCR_AUDIO_220);
    eval 'sub ESS_SCR_AUDIO_230 () {0x1;}' unless defined(&ESS_SCR_AUDIO_230);
    eval 'sub ESS_SCR_AUDIO_240 () {0x2;}' unless defined(&ESS_SCR_AUDIO_240);
    eval 'sub ESS_SCR_AUDIO_250 () {0x3;}' unless defined(&ESS_SCR_AUDIO_250);
}
unless(defined(&ESS_READ_TIMEOUT)) {
    sub ESS_READ_TIMEOUT () {	5000;}
}
unless(defined(&ESS_WRITE_TIMEOUT)) {
    sub ESS_WRITE_TIMEOUT () {	5000;}
}
unless(defined(&ESS_NPORT)) {
    sub ESS_NPORT () {	16;}
}
unless(defined(&ESS_DSP_RESET)) {
    sub ESS_DSP_RESET () {	0x6;}
}
unless(defined(&ESS_RESET_EXT)) {
    sub ESS_RESET_EXT () {	0x3;}
}
unless(defined(&ESS_MAGIC)) {
    sub ESS_MAGIC () {	0xaa;}
}
unless(defined(&ESS_DSP_READ)) {
    sub ESS_DSP_READ () {	0xa;}
}
unless(defined(&ESS_DSP_WRITE)) {
    sub ESS_DSP_WRITE () {	0xc;}
}
unless(defined(&ESS_CLEAR_INTR)) {
    sub ESS_CLEAR_INTR () {	0xe;}
}
unless(defined(&ESS_DSP_RW_STATUS)) {
    sub ESS_DSP_RW_STATUS () {	0xc;}
}
unless(defined(&ESS_DSP_WRITE_BUSY)) {
    sub ESS_DSP_WRITE_BUSY () {	0x80;}
}
unless(defined(&ESS_DSP_READ_READY)) {
    sub ESS_DSP_READ_READY () {	0x40;}
}
unless(defined(&ESS_DSP_READ_FULL)) {
    sub ESS_DSP_READ_FULL () {	0x20;}
}
unless(defined(&ESS_DSP_READ_EMPTY)) {
    sub ESS_DSP_READ_EMPTY () {	0x10;}
}
unless(defined(&ESS_DSP_READ_HALF)) {
    sub ESS_DSP_READ_HALF () {	0x8;}
}
unless(defined(&ESS_DSP_READ_IRQ)) {
    sub ESS_DSP_READ_IRQ () {	0x4;}
}
unless(defined(&ESS_DSP_READ_HALF_IRQ)) {
    sub ESS_DSP_READ_HALF_IRQ () {	0x2;}
}
unless(defined(&ESS_DSP_READ_OFLOW)) {
    sub ESS_DSP_READ_OFLOW () {	0x1;}
}
unless(defined(&ESS_DSP_READ_ANYIRQ)) {
    sub ESS_DSP_READ_ANYIRQ () {	( &ESS_DSP_READ_IRQ |  &ESS_DSP_READ_HALF_IRQ |  &ESS_DSP_READ_OFLOW);}
}
unless(defined(&ESS_MIX_REG_SELECT)) {
    sub ESS_MIX_REG_SELECT () {	0x4;}
}
unless(defined(&ESS_MIX_REG_DATA)) {
    sub ESS_MIX_REG_DATA () {	0x5;}
}
unless(defined(&ESS_MIX_RESET)) {
    sub ESS_MIX_RESET () {	0x;}
}
unless(defined(&ESS_MREG_VOLUME_VOICE)) {
    sub ESS_MREG_VOLUME_VOICE () {	0x14;}
}
unless(defined(&ESS_MREG_VOLUME_MIC)) {
    sub ESS_MREG_VOLUME_MIC () {	0x1a;}
}
unless(defined(&ESS_MREG_ADC_SOURCE)) {
    sub ESS_MREG_ADC_SOURCE () {	0x1c;}
}
unless(defined(&ESS_SOURCE_MIC)) {
    sub ESS_SOURCE_MIC () {	0x;}
}
unless(defined(&ESS_SOURCE_CD)) {
    sub ESS_SOURCE_CD () {	0x2;}
}
unless(defined(&ESS_SOURCE_LINE)) {
    sub ESS_SOURCE_LINE () {	0x6;}
}
unless(defined(&ESS_SOURCE_MIXER)) {
    sub ESS_SOURCE_MIXER () {	0x7;}
}
unless(defined(&ESS_MREG_VOLUME_MASTER)) {
    sub ESS_MREG_VOLUME_MASTER () {	0x32;}
}
unless(defined(&ESS_MREG_VOLUME_SYNTH)) {
    sub ESS_MREG_VOLUME_SYNTH () {	0x36;}
}
unless(defined(&ESS_MREG_VOLUME_CD)) {
    sub ESS_MREG_VOLUME_CD () {	0x38;}
}
unless(defined(&ESS_MREG_VOLUME_AUXB)) {
    sub ESS_MREG_VOLUME_AUXB () {	0x3a;}
}
unless(defined(&ESS_MREG_VOLUME_PCSPKR)) {
    sub ESS_MREG_VOLUME_PCSPKR () {	0x3c;}
}
unless(defined(&ESS_MREG_VOLUME_LINE)) {
    sub ESS_MREG_VOLUME_LINE () {	0x3e;}
}
unless(defined(&ESS_MREG_VOLUME_LEFT)) {
    sub ESS_MREG_VOLUME_LEFT () {	0x60;}
}
unless(defined(&ESS_MREG_VOLUME_RIGHT)) {
    sub ESS_MREG_VOLUME_RIGHT () {	0x62;}
}
unless(defined(&ESS_VOLUME_MUTE)) {
    sub ESS_VOLUME_MUTE () {	0x40;}
}
unless(defined(&ESS_MREG_VOLUME_CTRL)) {
    sub ESS_MREG_VOLUME_CTRL () {	0x64;}
}
unless(defined(&ESS_MREG_SAMPLE_RATE)) {
    sub ESS_MREG_SAMPLE_RATE () {	0x70;}
}
unless(defined(&ESS_MREG_FILTER_CLOCK)) {
    sub ESS_MREG_FILTER_CLOCK () {	0x72;}
}
unless(defined(&ESS_MREG_XFER_COUNTLO)) {
    sub ESS_MREG_XFER_COUNTLO () {	0x74;}
}
unless(defined(&ESS_MREG_XFER_COUNTHI)) {
    sub ESS_MREG_XFER_COUNTHI () {	0x76;}
}
unless(defined(&ESS_MREG_AUDIO2_CTRL1)) {
    sub ESS_MREG_AUDIO2_CTRL1 () {	0x78;}
}
unless(defined(&ESS_AUDIO2_CTRL1_SINGLE)) {
    sub ESS_AUDIO2_CTRL1_SINGLE () {	0x;}
}
unless(defined(&ESS_AUDIO2_CTRL1_DEMAND_2)) {
    sub ESS_AUDIO2_CTRL1_DEMAND_2 () {	0x40;}
}
unless(defined(&ESS_AUDIO2_CTRL1_DEMAND_4)) {
    sub ESS_AUDIO2_CTRL1_DEMAND_4 () {	0x80;}
}
unless(defined(&ESS_AUDIO2_CTRL1_DEMAND_8)) {
    sub ESS_AUDIO2_CTRL1_DEMAND_8 () {	0xc0;}
}
unless(defined(&ESS_AUDIO2_CTRL1_XFER_SIZE)) {
    sub ESS_AUDIO2_CTRL1_XFER_SIZE () {	0x20;}
}
unless(defined(&ESS_AUDIO2_CTRL1_AUTO_INIT)) {
    sub ESS_AUDIO2_CTRL1_AUTO_INIT () {	0x10;}
}
unless(defined(&ESS_AUDIO2_CTRL1_FIFO_ENABLE)) {
    sub ESS_AUDIO2_CTRL1_FIFO_ENABLE () {	0x2;}
}
unless(defined(&ESS_AUDIO2_CTRL1_DAC_ENABLE)) {
    sub ESS_AUDIO2_CTRL1_DAC_ENABLE () {	0x1;}
}
unless(defined(&ESS_MREG_AUDIO2_CTRL2)) {
    sub ESS_MREG_AUDIO2_CTRL2 () {	0x7a;}
}
unless(defined(&ESS_AUDIO2_CTRL2_FIFO_SIZE)) {
    sub ESS_AUDIO2_CTRL2_FIFO_SIZE () {	0x1;}
}
unless(defined(&ESS_AUDIO2_CTRL2_CHANNELS)) {
    sub ESS_AUDIO2_CTRL2_CHANNELS () {	0x2;}
}
unless(defined(&ESS_AUDIO2_CTRL2_FIFO_SIGNED)) {
    sub ESS_AUDIO2_CTRL2_FIFO_SIGNED () {	0x4;}
}
unless(defined(&ESS_AUDIO2_CTRL2_DMA_ENABLE)) {
    sub ESS_AUDIO2_CTRL2_DMA_ENABLE () {	0x20;}
}
unless(defined(&ESS_AUDIO2_CTRL2_IRQ2_ENABLE)) {
    sub ESS_AUDIO2_CTRL2_IRQ2_ENABLE () {	0x40;}
}
unless(defined(&ESS_AUDIO2_CTRL2_IRQ_LATCH)) {
    sub ESS_AUDIO2_CTRL2_IRQ_LATCH () {	0x80;}
}
unless(defined(&ESS_MREG_AUDIO2_CTRL3)) {
    sub ESS_MREG_AUDIO2_CTRL3 () {	0x7d;}
}
unless(defined(&ESS_AUDIO2_CTRL3_DRQA)) {
    sub ESS_AUDIO2_CTRL3_DRQA () {	0x;}
}
unless(defined(&ESS_AUDIO2_CTRL3_DRQB)) {
    sub ESS_AUDIO2_CTRL3_DRQB () {	0x1;}
}
unless(defined(&ESS_AUDIO2_CTRL3_DRQC)) {
    sub ESS_AUDIO2_CTRL3_DRQC () {	0x2;}
}
unless(defined(&ESS_AUDIO2_CTRL3_DRQD)) {
    sub ESS_AUDIO2_CTRL3_DRQD () {	0x3;}
}
unless(defined(&ESS_AUDIO2_CTRL3_DRQ_PD)) {
    sub ESS_AUDIO2_CTRL3_DRQ_PD () {	0x4;}
}
unless(defined(&ESS_MREG_INTR_ST)) {
    sub ESS_MREG_INTR_ST () {	0x7f;}
}
unless(defined(&ESS_IS_SELECT_IRQ)) {
    sub ESS_IS_SELECT_IRQ () {	0x1;}
}
unless(defined(&ESS_IS_ES1888)) {
    sub ESS_IS_ES1888 () {	0x;}
}
unless(defined(&ESS_IS_INTRA)) {
    sub ESS_IS_INTRA () {	0x2;}
}
unless(defined(&ESS_IS_INTRB)) {
    sub ESS_IS_INTRB () {	0x4;}
}
unless(defined(&ESS_IS_INTRC)) {
    sub ESS_IS_INTRC () {	0x6;}
}
unless(defined(&ESS_IS_INTRD)) {
    sub ESS_IS_INTRD () {	0x8;}
}
unless(defined(&ESS_IS_INTRE)) {
    sub ESS_IS_INTRE () {	0xa;}
}
1;
