require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC79XX_OPENBSD_H_)) {
    eval 'sub _AIC79XX_OPENBSD_H_ () {1;}' unless defined(&_AIC79XX_OPENBSD_H_);
    require 'pci.ph';
    require 'sys/param.ph';
    require 'sys/kernel.ph';
    require 'sys/systm.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/queue.ph';
    eval 'sub AIC_PCI_CONFIG () {1;}' unless defined(&AIC_PCI_CONFIG);
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'scsi/scsiconf.ph';
    require 'uvm/uvm_extern.ph';
    if(defined(&DEBUG)) {
	eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
    } else {
	eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
    }
    eval 'sub SCSI_IS_SCSIBUS_B {
        my($ahd, $sc_link) = @_;
	    eval q((0));
    }' unless defined(&SCSI_IS_SCSIBUS_B);
    eval 'sub SCSI_CHANNEL {
        my($ahd, $sc_link) = @_;
	    eval q((ord(\'A\')));
    }' unless defined(&SCSI_CHANNEL);
    eval 'sub SCSI_SCSI_ID {
        my($ahd, $sc_link) = @_;
	    eval q(( ($ahd->{our_id})));
    }' unless defined(&SCSI_SCSI_ID);
    eval 'sub BUILD_SCSIID {
        my($ahd, $sc_link, $target_id, $our_id) = @_;
	    eval q((((($target_id) <<  &TID_SHIFT) &  &TID) | ($our_id)));
    }' unless defined(&BUILD_SCSIID);
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    my($type, $member) = @_;
    	    eval q((((($type *)0)->$member)));
	}' unless defined(&offsetof);
    }
    eval 'sub ahd_dmamap_sync {
        my($ahc, $dma_tag, $dmamap, $offset, $len, $op) = @_;
	    eval q( &bus_dmamap_sync($dma_tag, $dmamap, $offset, $len, $op));
    }' unless defined(&ahd_dmamap_sync);
    eval 'sub AHD_NSEG () {( &roundup( &btoc( &MAXPHYS) + 1, 16));}' unless defined(&AHD_NSEG);
    if((defined(&AHD_REG_PRETTY_PRINT) ? &AHD_REG_PRETTY_PRINT : 0)) {
	eval 'sub AIC_DEBUG_REGISTERS () {1;}' unless defined(&AIC_DEBUG_REGISTERS);
    } else {
	eval 'sub AIC_DEBUG_REGISTERS () {0;}' unless defined(&AIC_DEBUG_REGISTERS);
    }
    require 'dev/ic/aic79xx.ph';
    eval 'sub aic_timer_stop () { &timeout_del;}' unless defined(&aic_timer_stop);
    eval 'sub aic_get_timeout {
        my($scb) = @_;
	    eval q((($scb)-> ($xs->{timeout})));
    }' unless defined(&aic_get_timeout);
    eval 'sub ahd_inb {
        my($ahd, $port) = @_;
	    eval q( &bus_space_read_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff));
    }' unless defined(&ahd_inb);
    eval 'sub ahd_outb {
        my($ahd, $port, $value) = @_;
	    eval q( &bus_space_write_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff, $value));
    }' unless defined(&ahd_outb);
    eval 'sub ahd_inw_atomic {
        my($ahd, $port) = @_;
	    eval q( &aic_le16toh( &bus_space_read_2(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff)));
    }' unless defined(&ahd_inw_atomic);
    eval 'sub ahd_outw_atomic {
        my($ahd, $port, $value) = @_;
	    eval q( &bus_space_write_2(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff),  &aic_htole16($value)));
    }' unless defined(&ahd_outw_atomic);
    eval 'sub ahd_outsb {
        my($ahd, $port, $valp, $count) = @_;
	    eval q( &bus_space_write_multi_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff), $valp, $count));
    }' unless defined(&ahd_outsb);
    eval 'sub ahd_insb {
        my($ahd, $port, $valp, $count) = @_;
	    eval q( &bus_space_read_multi_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff), $valp, $count));
    }' unless defined(&ahd_insb);
    eval 'sub ahd_lockinit {
        my($ahd) = @_;
	    eval q();
    }' unless defined(&ahd_lockinit);
    eval 'sub ahd_lock {
        my($ahd, $flags) = @_;
	    eval q(*($flags) =  &splbio());
    }' unless defined(&ahd_lock);
    eval 'sub ahd_unlock {
        my($ahd, $flags) = @_;
	    eval q( &splx(*($flags)));
    }' unless defined(&ahd_unlock);
    eval 'sub ahd_done_lockinit {
        my($ahd) = @_;
	    eval q();
    }' unless defined(&ahd_done_lockinit);
    eval 'sub ahd_done_lock {
        my($ahd, $flags) = @_;
	    eval q();
    }' unless defined(&ahd_done_lock);
    eval 'sub ahd_done_unlock {
        my($ahd, $flags) = @_;
	    eval q();
    }' unless defined(&ahd_done_unlock);
    eval 'sub ahd_list_lockinit {
        my($x) = @_;
	    eval q();
    }' unless defined(&ahd_list_lockinit);
    eval 'sub ahd_list_lock {
        my($flags) = @_;
	    eval q(*($flags) =  &splbio());
    }' unless defined(&ahd_list_lock);
    eval 'sub ahd_list_unlock {
        my($flags) = @_;
	    eval q( &splx(*($flags)));
    }' unless defined(&ahd_list_unlock);
    eval 'sub scsi_4btoul {
        my($b) = @_;
	    eval q(( &_4btol($b)));
    }' unless defined(&scsi_4btoul);
    eval 'sub aic_set_transaction_status {
        my($scb, $status) = @_;
	    eval q(($scb)-> ($xs->{error}) = ($status));
    }' unless defined(&aic_set_transaction_status);
    eval 'sub aic_set_scsi_status {
        my($scb, $status) = @_;
	    eval q(($scb)-> ($xs->{xs_status}) = ($status));
    }' unless defined(&aic_set_scsi_status);
    eval 'sub aic_set_transaction_tag {
        my($scb, $enabled, $type) = @_;
	    eval q();
    }' unless defined(&aic_set_transaction_tag);
    eval 'sub aic_set_residual {
        my($scb, $residual) = @_;
	    eval q(($scb)-> ($xs->{resid}) = ($residual));
    }' unless defined(&aic_set_residual);
    eval 'sub aic_set_sense_residual {
        my($scb, $residual) = @_;
	    eval q(($scb)-> ($xs->{resid}) = ($residual));
    }' unless defined(&aic_set_sense_residual);
    eval 'sub aic_get_transaction_status {
        my($scb) = @_;
	    eval q(((($scb)-> ($xs->{flags}) &  &ITSDONE) ?  &CAM_REQ_CMP : ($scb)-> ($xs->{error})));
    }' unless defined(&aic_get_transaction_status);
    eval 'sub aic_get_scsi_status {
        my($scb) = @_;
	    eval q((($scb)-> ($xs->{status})));
    }' unless defined(&aic_get_scsi_status);
    eval 'sub aic_get_transfer_length {
        my($scb) = @_;
	    eval q((($scb)-> ($xs->{datalen})));
    }' unless defined(&aic_get_transfer_length);
    eval 'sub aic_get_transfer_dir {
        my($scb) = @_;
	    eval q((($scb)-> ($xs->{flags}) & ( &SCSI_DATA_IN |  &SCSI_DATA_OUT)));
    }' unless defined(&aic_get_transfer_dir);
    eval 'sub aic_get_residual {
        my($scb) = @_;
	    eval q((($scb)-> ($xs->{resid})));
    }' unless defined(&aic_get_residual);
    eval 'sub aic_get_sense_bufsize {
        my($ahd, $scb) = @_;
	    eval q(($sizeof{\'struct scsi_sense_data\'}));
    }' unless defined(&aic_get_sense_bufsize);
    eval 'sub aic_perform_autosense {
        my($scb) = @_;
	    eval q((1));
    }' unless defined(&aic_perform_autosense);
    eval 'sub aic_freeze_simq {
        my($ahd) = @_;
	    eval q();
    }' unless defined(&aic_freeze_simq);
    eval 'sub aic_release_simq {
        my($ahd) = @_;
	    eval q();
    }' unless defined(&aic_release_simq);
    eval 'sub aic_freeze_scb {
        my($scb) = @_;
	    eval q();
    }' unless defined(&aic_freeze_scb);
    eval 'sub ahd_platform_freeze_devq {
        my($ahd, $scb) = @_;
	    eval q();
    }' unless defined(&ahd_platform_freeze_devq);
    eval 'sub ahd_platform_abort_scbs {
        my($ahd, $target, $channel, $lun, $tag, $role, $status) = @_;
	    eval q();
    }' unless defined(&ahd_platform_abort_scbs);
    eval 'sub aic_get_pci_function {
        my($pci) = @_;
	    eval q((($pci)-> &pa_function));
    }' unless defined(&aic_get_pci_function);
    eval 'sub aic_get_pci_slot {
        my($pci) = @_;
	    eval q((($pci)-> &pa_device));
    }' unless defined(&aic_get_pci_slot);
    eval 'sub aic_get_pci_bus {
        my($pci) = @_;
	    eval q((($pci)-> &pa_bus));
    }' unless defined(&aic_get_pci_bus);
    eval("sub AHD_POWER_STATE_D0 () { 0; }") unless defined(&AHD_POWER_STATE_D0);
    eval("sub AHD_POWER_STATE_D1 () { 1; }") unless defined(&AHD_POWER_STATE_D1);
    eval("sub AHD_POWER_STATE_D2 () { 2; }") unless defined(&AHD_POWER_STATE_D2);
    eval("sub AHD_POWER_STATE_D3 () { 3; }") unless defined(&AHD_POWER_STATE_D3);
    eval 'sub ahd_platform_init {
        my($ahd) = @_;
	    eval q();
    }' unless defined(&ahd_platform_init);
}
1;
