require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_PROC_H_)) {
    eval 'sub _SYS_PROC_H_ () {1;}' unless defined(&_SYS_PROC_H_);
    require 'machine/proc.ph';
    require 'sys/selinfo.ph';
    require 'sys/queue.ph';
    require 'sys/timeout.ph';
    require 'sys/event.ph';
    require 'machine/atomic.ph';
    eval 'sub curproc () { &curcpu()-> &ci_curproc;}' unless defined(&curproc);
    if(defined(&_KERNEL)) {
	eval 'sub __need_process () {1;}' unless defined(&__need_process);
    }
    eval 'sub EMUL_ENABLED () {0x1;}' unless defined(&EMUL_ENABLED);
    eval 'sub EMUL_NATIVE () {0x2;}' unless defined(&EMUL_NATIVE);
    if(defined(&__need_process)) {
    } else {
    }
    eval 'sub p_cred () { ($p_p->{ps_cred});}' unless defined(&p_cred);
    eval 'sub p_ucred () { ($p_cred->{pc_ucred});}' unless defined(&p_ucred);
    eval 'sub p_rlimit () { ($p_p->{ps_limit}->{pl_rlimit});}' unless defined(&p_rlimit);
    eval 'sub p_startzero () { &p_oppid;}' unless defined(&p_startzero);
    eval 'sub p_endzero () { &p_startcopy;}' unless defined(&p_endzero);
    eval 'sub p_startcopy () { &p_sigmask;}' unless defined(&p_startcopy);
    eval 'sub p_endcopy () { &p_addr;}' unless defined(&p_endcopy);
    eval 'sub p_session () { ($p_pgrp->{pg_session});}' unless defined(&p_session);
    eval 'sub p_pgid () { ($p_pgrp->{pg_id});}' unless defined(&p_pgid);
    eval 'sub SIDL () {1;}' unless defined(&SIDL);
    eval 'sub SRUN () {2;}' unless defined(&SRUN);
    eval 'sub SSLEEP () {3;}' unless defined(&SSLEEP);
    eval 'sub SSTOP () {4;}' unless defined(&SSTOP);
    eval 'sub SZOMB () {5;}' unless defined(&SZOMB);
    eval 'sub SDEAD () {6;}' unless defined(&SDEAD);
    eval 'sub SONPROC () {7;}' unless defined(&SONPROC);
    eval 'sub P_ZOMBIE {
        my($p) = @_;
	    eval q((($p)-> &p_stat ==  &SZOMB || ($p)-> &p_stat ==  &SDEAD));
    }' unless defined(&P_ZOMBIE);
    eval 'sub P_ADVLOCK () {0x1;}' unless defined(&P_ADVLOCK);
    eval 'sub P_CONTROLT () {0x2;}' unless defined(&P_CONTROLT);
    eval 'sub P_INMEM () {0x4;}' unless defined(&P_INMEM);
    eval 'sub P_NOCLDSTOP () {0x8;}' unless defined(&P_NOCLDSTOP);
    eval 'sub P_PPWAIT () {0x10;}' unless defined(&P_PPWAIT);
    eval 'sub P_PROFIL () {0x20;}' unless defined(&P_PROFIL);
    eval 'sub P_SELECT () {0x40;}' unless defined(&P_SELECT);
    eval 'sub P_SINTR () {0x80;}' unless defined(&P_SINTR);
    eval 'sub P_SUGID () {0x100;}' unless defined(&P_SUGID);
    eval 'sub P_SYSTEM () {0x200;}' unless defined(&P_SYSTEM);
    eval 'sub P_TIMEOUT () {0x400;}' unless defined(&P_TIMEOUT);
    eval 'sub P_TRACED () {0x800;}' unless defined(&P_TRACED);
    eval 'sub P_WAITED () {0x1000;}' unless defined(&P_WAITED);
    eval 'sub P_WEXIT () {0x2000;}' unless defined(&P_WEXIT);
    eval 'sub P_EXEC () {0x4000;}' unless defined(&P_EXEC);
    eval 'sub P_OWEUPC () {0x8000;}' unless defined(&P_OWEUPC);
    eval 'sub P_SSTEP () {0x20000;}' unless defined(&P_SSTEP);
    eval 'sub P_SUGIDEXEC () {0x40000;}' unless defined(&P_SUGIDEXEC);
    eval 'sub P_NOCLDWAIT () {0x80000;}' unless defined(&P_NOCLDWAIT);
    eval 'sub P_NOZOMBIE () {0x100000;}' unless defined(&P_NOZOMBIE);
    eval 'sub P_INEXEC () {0x200000;}' unless defined(&P_INEXEC);
    eval 'sub P_SYSTRACE () {0x400000;}' unless defined(&P_SYSTRACE);
    eval 'sub P_CONTINUED () {0x800000;}' unless defined(&P_CONTINUED);
    eval 'sub P_BIGLOCK () {0x2000000;}' unless defined(&P_BIGLOCK);
    eval 'sub P_THREAD () {0x4000000;}' unless defined(&P_THREAD);
    eval 'sub P_IGNEXITRV () {0x8000000;}' unless defined(&P_IGNEXITRV);
    eval 'sub P_SOFTDEP () {0x10000000;}' unless defined(&P_SOFTDEP);
    eval 'sub P_STOPPED () {0x20000000;}' unless defined(&P_STOPPED);
    eval 'sub P_BITS () {("\\20\\01ADVLOCK\\02CTTY\\04NOCLDSTOP\\05PPWAIT\\06PROFIL\\07SELECT" "\\010SINTR\\011SUGID\\012SYSTEM\\013TIMEOUT\\014TRACED\\015WAITED\\016WEXIT" "\\017EXEC\\020PWEUPC\\022SSTEP\\023SUGIDEXEC\\024NOCLDWAIT" "\\025NOZOMBIE\\026INEXEC\\027SYSTRACE\\030CONTINUED\\032BIGLOCK" "\\033THREAD\\034IGNEXITRV\\035SOFTDEP\\036STOPPED");}' unless defined(&P_BITS);
    eval 'sub P_EXITSIG {
        my($p) = @_;
	    eval q(((($p)-> &p_flag &  &P_TRACED) ?  &SIGCHLD : ($p)-> &p_exitsig));
    }' unless defined(&P_EXITSIG);
    if(defined(&_KERNEL)) {
	eval 'sub PID_MAX () {32766;}' unless defined(&PID_MAX);
	eval 'sub NO_PID () {( &PID_MAX+1);}' unless defined(&NO_PID);
	eval 'sub SESS_LEADER {
	    my($p) = @_;
    	    eval q((($p)-> ($p_session->{s_leader}) == ($p)));
	}' unless defined(&SESS_LEADER);
	eval 'sub SESSHOLD {
	    my($s) = @_;
    	    eval q((($s)-> &s_count++));
	}' unless defined(&SESSHOLD);
	eval 'sub SESSRELE {
	    my($s) = @_;
    	    eval q({  &if (--($s)-> &s_count == 0)  &pool_put( &session_pool, $s); });
	}' unless defined(&SESSRELE);
	eval 'sub FORK_FORK () {0x1;}' unless defined(&FORK_FORK);
	eval 'sub FORK_VFORK () {0x2;}' unless defined(&FORK_VFORK);
	eval 'sub FORK_RFORK () {0x4;}' unless defined(&FORK_RFORK);
	eval 'sub FORK_PPWAIT () {0x8;}' unless defined(&FORK_PPWAIT);
	eval 'sub FORK_SHAREFILES () {0x10;}' unless defined(&FORK_SHAREFILES);
	eval 'sub FORK_CLEANFILES () {0x20;}' unless defined(&FORK_CLEANFILES);
	eval 'sub FORK_NOZOMBIE () {0x40;}' unless defined(&FORK_NOZOMBIE);
	eval 'sub FORK_SHAREVM () {0x80;}' unless defined(&FORK_SHAREVM);
	eval 'sub FORK_SIGHAND () {0x200;}' unless defined(&FORK_SIGHAND);
	eval 'sub FORK_PTRACE () {0x400;}' unless defined(&FORK_PTRACE);
	eval 'sub FORK_THREAD () {0x800;}' unless defined(&FORK_THREAD);
	eval 'sub EXIT_NORMAL () {0x1;}' unless defined(&EXIT_NORMAL);
	eval 'sub EXIT_THREAD () {0x2;}' unless defined(&EXIT_THREAD);
	eval 'sub PIDHASH {
	    my($pid) = @_;
    	    eval q(( $pidhashtbl[($pid) &  &pidhash]));
	}' unless defined(&PIDHASH);
	eval 'sub PGRPHASH {
	    my($pgid) = @_;
    	    eval q(( $pgrphashtbl[($pgid) &  &pgrphash]));
	}' unless defined(&PGRPHASH);
	eval 'sub NQS () {32;}' unless defined(&NQS);
	if(!defined( &remrunqueue)) {
	}
	if(!defined( &setrunqueue)) {
	}
	eval 'sub wakeup_one {
	    my($c) = @_;
    	    eval q( &wakeup_n(($c), 1));
	}' unless defined(&wakeup_one);
	if(!defined( &cpu_switch)) {
	}
	if(!defined( &cpu_wait)) {
	}
	eval 'sub ltsleep {
	    my($c, $p, $w, $t, $l) = @_;
    	    eval q( &tsleep($c, $p, $w, $t));
	}' unless defined(&ltsleep);
	if(defined( &MULTIPROCESSOR)) {
	}
    }
}
1;
