require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPARC_PARAM_H_)) {
    eval 'sub _SPARC_PARAM_H_ () {1;}' unless defined(&_SPARC_PARAM_H_);
    eval 'sub _MACHINE () { &sparc;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC;}' unless defined(&MID_MACHINE);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub ALIGNBYTES () {7;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub SUN4_PGSHIFT () {13;}' unless defined(&SUN4_PGSHIFT);
    eval 'sub SUN4CM_PGSHIFT () {12;}' unless defined(&SUN4CM_PGSHIFT);
    eval 'sub KERNBASE () {0xf8000000;}' unless defined(&KERNBASE);
    eval 'sub KERNTEXTOFF () {0xf8004000;}' unless defined(&KERNTEXTOFF);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub USPACE () {8192;}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    eval 'sub MSGBUFSIZE () {4096;}' unless defined(&MSGBUFSIZE);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        my($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        my($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub dvma_malloc {
	        my($len,$kaddr,$flags) = @_;
    		eval q( &dvma_malloc_space($len,$kaddr,$flags,0));
	    }' unless defined(&dvma_malloc);
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	    if(0) {
	    }
	}
    }
    eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
    eval 'sub CPU_SUN4C () {1;}' unless defined(&CPU_SUN4C);
    eval 'sub CPU_SUN4M () {2;}' unless defined(&CPU_SUN4M);
    if(defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    }
 elsif(defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    }
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(1);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(0);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4COR4M);
    }
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(1);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(1);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(0);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {8192;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {8192;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    }
    unless(defined(&NBPG)) {
	if(defined(&STANDALONE)) {
	    eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
	    eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
	    eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
	    eval 'sub PAGE_SIZE () { &nbpg;}' unless defined(&PAGE_SIZE);
	    eval 'sub PAGE_MASK () { &pgofset;}' unless defined(&PAGE_MASK);
	    eval 'sub PAGE_SHIFT () { &pgshift;}' unless defined(&PAGE_SHIFT);
	} else {
	    eval 'sub NBPG () { ($uvmexp->{pagesize});}' unless defined(&NBPG);
	    eval 'sub PGOFSET () { ($uvmexp->{pagemask});}' unless defined(&PGOFSET);
	    eval 'sub PGSHIFT () { ($uvmexp->{pageshift});}' unless defined(&PGSHIFT);
	    eval 'sub PAGE_SIZE () { ($uvmexp->{pagesize});}' unless defined(&PAGE_SIZE);
	    eval 'sub PAGE_MASK () { ($uvmexp->{pagemask});}' unless defined(&PAGE_MASK);
	    eval 'sub PAGE_SHIFT () { ($uvmexp->{pageshift});}' unless defined(&PAGE_SHIFT);
	}
    }
}
1;
