require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&WPI_TX_RING_COUNT)) {
    sub WPI_TX_RING_COUNT () {	256;}
}
unless(defined(&WPI_SVC_RING_COUNT)) {
    sub WPI_SVC_RING_COUNT () {	256;}
}
unless(defined(&WPI_CMD_RING_COUNT)) {
    sub WPI_CMD_RING_COUNT () {	256;}
}
unless(defined(&WPI_RX_RING_COUNT)) {
    sub WPI_RX_RING_COUNT () {	64;}
}
unless(defined(&WPI_RING_DMA_ALIGN)) {
    sub WPI_RING_DMA_ALIGN () {	0x4000;}
}
unless(defined(&WPI_MAX_SCATTER)) {
    sub WPI_MAX_SCATTER () {	4;}
}
unless(defined(&WPI_RBUF_SIZE)) {
    sub WPI_RBUF_SIZE () {	(3* 1024);}
}
unless(defined(&WPI_HWCONFIG)) {
    sub WPI_HWCONFIG () {	0x;}
}
unless(defined(&WPI_INTR)) {
    sub WPI_INTR () {	0x8;}
}
unless(defined(&WPI_MASK)) {
    sub WPI_MASK () {	0xc;}
}
unless(defined(&WPI_INTR_STATUS)) {
    sub WPI_INTR_STATUS () {	0x10;}
}
unless(defined(&WPI_GPIO_STATUS)) {
    sub WPI_GPIO_STATUS () {	0x18;}
}
unless(defined(&WPI_RESET)) {
    sub WPI_RESET () {	0x20;}
}
unless(defined(&WPI_GPIO_CTL)) {
    sub WPI_GPIO_CTL () {	0x24;}
}
unless(defined(&WPI_EEPROM_CTL)) {
    sub WPI_EEPROM_CTL () {	0x2c;}
}
unless(defined(&WPI_EEPROM_STATUS)) {
    sub WPI_EEPROM_STATUS () {	0x30;}
}
unless(defined(&WPI_UCODE_CLR)) {
    sub WPI_UCODE_CLR () {	0x5c;}
}
unless(defined(&WPI_TEMPERATURE)) {
    sub WPI_TEMPERATURE () {	0x60;}
}
unless(defined(&WPI_CHICKEN)) {
    sub WPI_CHICKEN () {	0x100;}
}
unless(defined(&WPI_PLL_CTL)) {
    sub WPI_PLL_CTL () {	0x20c;}
}
unless(defined(&WPI_FW_TARGET)) {
    sub WPI_FW_TARGET () {	0x410;}
}
unless(defined(&WPI_WRITE_MEM_ADDR)) {
    sub WPI_WRITE_MEM_ADDR () {	0x444;}
}
unless(defined(&WPI_READ_MEM_ADDR)) {
    sub WPI_READ_MEM_ADDR () {	0x448;}
}
unless(defined(&WPI_WRITE_MEM_DATA)) {
    sub WPI_WRITE_MEM_DATA () {	0x44c;}
}
unless(defined(&WPI_READ_MEM_DATA)) {
    sub WPI_READ_MEM_DATA () {	0x450;}
}
unless(defined(&WPI_TX_WIDX)) {
    sub WPI_TX_WIDX () {	0x460;}
}
unless(defined(&WPI_TX_CTL)) {
    sub WPI_TX_CTL {
	my($qid) = @_;
	eval q((0x940 + ($qid) * 8));
    }
}
unless(defined(&WPI_TX_BASE)) {
    sub WPI_TX_BASE {
	my($qid) = @_;
	eval q((0x944 + ($qid) * 8));
    }
}
unless(defined(&WPI_TX_DESC)) {
    sub WPI_TX_DESC {
	my($qid) = @_;
	eval q((0x980 + ($qid) * 80));
    }
}
unless(defined(&WPI_RX_CONFIG)) {
    sub WPI_RX_CONFIG () {	0xc00;}
}
unless(defined(&WPI_RX_BASE)) {
    sub WPI_RX_BASE () {	0xc04;}
}
unless(defined(&WPI_RX_WIDX)) {
    sub WPI_RX_WIDX () {	0xc20;}
}
unless(defined(&WPI_RX_RIDX_PTR)) {
    sub WPI_RX_RIDX_PTR () {	0xc24;}
}
unless(defined(&WPI_RX_CTL)) {
    sub WPI_RX_CTL () {	0xcc0;}
}
unless(defined(&WPI_RX_STATUS)) {
    sub WPI_RX_STATUS () {	0xcc4;}
}
unless(defined(&WPI_TX_CONFIG)) {
    sub WPI_TX_CONFIG {
	my($qid) = @_;
	eval q((0xd00 + ($qid) * 32));
    }
}
unless(defined(&WPI_TX_CREDIT)) {
    sub WPI_TX_CREDIT {
	my($qid) = @_;
	eval q((0xd04 + ($qid) * 32));
    }
}
unless(defined(&WPI_TX_STATE)) {
    sub WPI_TX_STATE {
	my($qid) = @_;
	eval q((0xd08 + ($qid) * 32));
    }
}
unless(defined(&WPI_TX_BASE_PTR)) {
    sub WPI_TX_BASE_PTR () {	0xe80;}
}
unless(defined(&WPI_MSG_CONFIG)) {
    sub WPI_MSG_CONFIG () {	0xe88;}
}
unless(defined(&WPI_TX_STATUS)) {
    sub WPI_TX_STATUS () {	0xe90;}
}
unless(defined(&WPI_MEM_MODE)) {
    sub WPI_MEM_MODE () {	0x2e00;}
}
unless(defined(&WPI_MEM_RA)) {
    sub WPI_MEM_RA () {	0x2e04;}
}
unless(defined(&WPI_MEM_TXCFG)) {
    sub WPI_MEM_TXCFG () {	0x2e10;}
}
unless(defined(&WPI_MEM_MAGIC4)) {
    sub WPI_MEM_MAGIC4 () {	0x2e14;}
}
unless(defined(&WPI_MEM_MAGIC5)) {
    sub WPI_MEM_MAGIC5 () {	0x2e20;}
}
unless(defined(&WPI_MEM_BYPASS1)) {
    sub WPI_MEM_BYPASS1 () {	0x2e2c;}
}
unless(defined(&WPI_MEM_BYPASS2)) {
    sub WPI_MEM_BYPASS2 () {	0x2e30;}
}
unless(defined(&WPI_MEM_CLOCK1)) {
    sub WPI_MEM_CLOCK1 () {	0x3004;}
}
unless(defined(&WPI_MEM_CLOCK2)) {
    sub WPI_MEM_CLOCK2 () {	0x3008;}
}
unless(defined(&WPI_MEM_POWER)) {
    sub WPI_MEM_POWER () {	0x300c;}
}
unless(defined(&WPI_MEM_PCIDEV)) {
    sub WPI_MEM_PCIDEV () {	0x3010;}
}
unless(defined(&WPI_MEM_UCODE_CTL)) {
    sub WPI_MEM_UCODE_CTL () {	0x3400;}
}
unless(defined(&WPI_MEM_UCODE_SRC)) {
    sub WPI_MEM_UCODE_SRC () {	0x3404;}
}
unless(defined(&WPI_MEM_UCODE_DST)) {
    sub WPI_MEM_UCODE_DST () {	0x3408;}
}
unless(defined(&WPI_MEM_UCODE_SIZE)) {
    sub WPI_MEM_UCODE_SIZE () {	0x340c;}
}
unless(defined(&WPI_MEM_UCODE_BASE)) {
    sub WPI_MEM_UCODE_BASE () {	0x3800;}
}
unless(defined(&WPI_HW_ALM_MB)) {
    sub WPI_HW_ALM_MB () {	(1<< 8);}
}
unless(defined(&WPI_HW_ALM_MM)) {
    sub WPI_HW_ALM_MM () {	(1<< 9);}
}
unless(defined(&WPI_HW_SKU_MRC)) {
    sub WPI_HW_SKU_MRC () {	(1<< 10);}
}
unless(defined(&WPI_HW_REV_D)) {
    sub WPI_HW_REV_D () {	(1<< 11);}
}
unless(defined(&WPI_HW_TYPE_B)) {
    sub WPI_HW_TYPE_B () {	(1<< 12);}
}
unless(defined(&WPI_MEM_4)) {
    sub WPI_MEM_4 () {	(($sizeof{ &uint32_t} - 1) << 24);}
}
unless(defined(&WPI_FW_TEXT)) {
    sub WPI_FW_TEXT () {	0x;}
}
unless(defined(&WPI_FW_DATA)) {
    sub WPI_FW_DATA () {	0x800000;}
}
unless(defined(&WPI_POWERED)) {
    sub WPI_POWERED () {	(1<< 9);}
}
unless(defined(&WPI_NEVO_RESET)) {
    sub WPI_NEVO_RESET () {	(1<< 0);}
}
unless(defined(&WPI_SW_RESET)) {
    sub WPI_SW_RESET () {	(1<< 7);}
}
unless(defined(&WPI_MASTER_DISABLED)) {
    sub WPI_MASTER_DISABLED () {	(1<< 8);}
}
unless(defined(&WPI_STOP_MASTER)) {
    sub WPI_STOP_MASTER () {	(1<< 9);}
}
unless(defined(&WPI_GPIO_CLOCK)) {
    sub WPI_GPIO_CLOCK () {	(1<< 0);}
}
unless(defined(&WPI_GPIO_INIT)) {
    sub WPI_GPIO_INIT () {	(1<< 2);}
}
unless(defined(&WPI_GPIO_MAC)) {
    sub WPI_GPIO_MAC () {	(1<< 3);}
}
unless(defined(&WPI_GPIO_SLEEP)) {
    sub WPI_GPIO_SLEEP () {	(1<< 4);}
}
unless(defined(&WPI_GPIO_PWR_STATUS)) {
    sub WPI_GPIO_PWR_STATUS () {	0x7000000;}
}
unless(defined(&WPI_GPIO_PWR_SLEEP)) {
    sub WPI_GPIO_PWR_SLEEP () {	(4<< 24);}
}
unless(defined(&WPI_CHICKEN_RXNOLOS)) {
    sub WPI_CHICKEN_RXNOLOS () {	(1<< 23);}
}
unless(defined(&WPI_PLL_INIT)) {
    sub WPI_PLL_INIT () {	(1<< 24);}
}
unless(defined(&WPI_RADIO_OFF)) {
    sub WPI_RADIO_OFF () {	(1<< 1);}
}
unless(defined(&WPI_DISABLE_CMD)) {
    sub WPI_DISABLE_CMD () {	(1<< 2);}
}
unless(defined(&WPI_RX_IDLE)) {
    sub WPI_RX_IDLE () {	(1<< 24);}
}
unless(defined(&WPI_UC_RUN)) {
    sub WPI_UC_RUN () {	(1<< 30);}
}
unless(defined(&WPI_ALIVE_INTR)) {
    sub WPI_ALIVE_INTR () {	(1<< 0);}
}
unless(defined(&WPI_WAKEUP_INTR)) {
    sub WPI_WAKEUP_INTR () {	(1<< 1);}
}
unless(defined(&WPI_SW_ERROR)) {
    sub WPI_SW_ERROR () {	(1<< 25);}
}
unless(defined(&WPI_TX_INTR)) {
    sub WPI_TX_INTR () {	(1<< 27);}
}
unless(defined(&WPI_HW_ERROR)) {
    sub WPI_HW_ERROR () {	(1<< 29);}
}
unless(defined(&WPI_RX_INTR)) {
    sub WPI_RX_INTR () {	(1<< 31);}
}
unless(defined(&WPI_INTR_MASK)) {
    sub WPI_INTR_MASK () {	( &WPI_SW_ERROR |  &WPI_HW_ERROR |  &WPI_TX_INTR |  &WPI_RX_INTR |  &WPI_ALIVE_INTR |  &WPI_WAKEUP_INTR);}
}
unless(defined(&WPI_TX_IDLE)) {
    sub WPI_TX_IDLE {
	my($qid) = @_;
	eval q((1<< (($qid) + 24) | 1<< (($qid) + 16)));
    }
}
unless(defined(&WPI_EEPROM_READY)) {
    sub WPI_EEPROM_READY () {	(1<< 0);}
}
unless(defined(&WPI_EEPROM_VERSION)) {
    sub WPI_EEPROM_VERSION () {	0x7;}
}
unless(defined(&WPI_EEPROM_LOCKED)) {
    sub WPI_EEPROM_LOCKED () {	0x180;}
}
unless(defined(&WPI_MAX_SEG_LEN)) {
    sub WPI_MAX_SEG_LEN () {	65520;}
}
unless(defined(&WPI_PAD32)) {
    sub WPI_PAD32 {
	my($x) = @_;
	eval q((((($x) + 3) & ~3) - ($x)));
    }
}
unless(defined(&WPI_UC_READY)) {
    sub WPI_UC_READY () {	1;}
}
unless(defined(&WPI_RX_DONE)) {
    sub WPI_RX_DONE () {	27;}
}
unless(defined(&WPI_TX_DONE)) {
    sub WPI_TX_DONE () {	28;}
}
unless(defined(&WPI_START_SCAN)) {
    sub WPI_START_SCAN () {	130;}
}
unless(defined(&WPI_STOP_SCAN)) {
    sub WPI_STOP_SCAN () {	132;}
}
unless(defined(&WPI_STATE_CHANGED)) {
    sub WPI_STATE_CHANGED () {	161;}
}
unless(defined(&WPI_STAT_MAXLEN)) {
    sub WPI_STAT_MAXLEN () {	20;}
}
unless(defined(&WPI_RSSI_OFFSET)) {
    sub WPI_RSSI_OFFSET () {	95;}
}
unless(defined(&WPI_RX_NO_CRC_ERR)) {
    sub WPI_RX_NO_CRC_ERR () {	(1<< 0);}
}
unless(defined(&WPI_RX_NO_OVFL_ERR)) {
    sub WPI_RX_NO_OVFL_ERR () {	(1<< 1);}
}
unless(defined(&WPI_RX_NOERROR)) {
    sub WPI_RX_NOERROR () {	( &WPI_RX_NO_CRC_ERR |  &WPI_RX_NO_OVFL_ERR);}
}
unless(defined(&WPI_CMD_CONFIGURE)) {
    sub WPI_CMD_CONFIGURE () {	16;}
}
unless(defined(&WPI_CMD_ASSOCIATE)) {
    sub WPI_CMD_ASSOCIATE () {	17;}
}
unless(defined(&WPI_CMD_TSF)) {
    sub WPI_CMD_TSF () {	20;}
}
unless(defined(&WPI_CMD_ADD_NODE)) {
    sub WPI_CMD_ADD_NODE () {	24;}
}
unless(defined(&WPI_CMD_TX_DATA)) {
    sub WPI_CMD_TX_DATA () {	28;}
}
unless(defined(&WPI_CMD_MRR_SETUP)) {
    sub WPI_CMD_MRR_SETUP () {	71;}
}
unless(defined(&WPI_CMD_SET_LED)) {
    sub WPI_CMD_SET_LED () {	72;}
}
unless(defined(&WPI_CMD_SET_POWER_MODE)) {
    sub WPI_CMD_SET_POWER_MODE () {	119;}
}
unless(defined(&WPI_CMD_SCAN)) {
    sub WPI_CMD_SCAN () {	128;}
}
unless(defined(&WPI_CMD_SET_BEACON)) {
    sub WPI_CMD_SET_BEACON () {	145;}
}
unless(defined(&WPI_CMD_BLUETOOTH)) {
    sub WPI_CMD_BLUETOOTH () {	155;}
}
unless(defined(&WPI_CMD_TXPOWER)) {
    sub WPI_CMD_TXPOWER () {	176;}
}
unless(defined(&WPI_MODE_HOSTAP)) {
    sub WPI_MODE_HOSTAP () {	1;}
}
unless(defined(&WPI_MODE_STA)) {
    sub WPI_MODE_STA () {	3;}
}
unless(defined(&WPI_MODE_IBSS)) {
    sub WPI_MODE_IBSS () {	4;}
}
unless(defined(&WPI_MODE_MONITOR)) {
    sub WPI_MODE_MONITOR () {	6;}
}
unless(defined(&WPI_STATE_ASSOCIATED)) {
    sub WPI_STATE_ASSOCIATED () {	4;}
}
unless(defined(&WPI_CONFIG_24GHZ)) {
    sub WPI_CONFIG_24GHZ () {	(1<< 0);}
}
unless(defined(&WPI_CONFIG_CCK)) {
    sub WPI_CONFIG_CCK () {	(1<< 1);}
}
unless(defined(&WPI_CONFIG_AUTO)) {
    sub WPI_CONFIG_AUTO () {	(1<< 2);}
}
unless(defined(&WPI_CONFIG_SHSLOT)) {
    sub WPI_CONFIG_SHSLOT () {	(1<< 4);}
}
unless(defined(&WPI_CONFIG_SHPREAMBLE)) {
    sub WPI_CONFIG_SHPREAMBLE () {	(1<< 5);}
}
unless(defined(&WPI_CONFIG_NODIVERSITY)) {
    sub WPI_CONFIG_NODIVERSITY () {	(1<< 7);}
}
unless(defined(&WPI_CONFIG_ANTENNA_A)) {
    sub WPI_CONFIG_ANTENNA_A () {	(1<< 8);}
}
unless(defined(&WPI_CONFIG_ANTENNA_B)) {
    sub WPI_CONFIG_ANTENNA_B () {	(1<< 9);}
}
unless(defined(&WPI_CONFIG_TSF)) {
    sub WPI_CONFIG_TSF () {	(1<< 15);}
}
unless(defined(&WPI_FILTER_PROMISC)) {
    sub WPI_FILTER_PROMISC () {	(1<< 0);}
}
unless(defined(&WPI_FILTER_CTL)) {
    sub WPI_FILTER_CTL () {	(1<< 1);}
}
unless(defined(&WPI_FILTER_MULTICAST)) {
    sub WPI_FILTER_MULTICAST () {	(1<< 2);}
}
unless(defined(&WPI_FILTER_NODECRYPT)) {
    sub WPI_FILTER_NODECRYPT () {	(1<< 3);}
}
unless(defined(&WPI_FILTER_BSS)) {
    sub WPI_FILTER_BSS () {	(1<< 5);}
}
unless(defined(&WPI_NODE_UPDATE)) {
    sub WPI_NODE_UPDATE () {	(1<< 0);}
}
unless(defined(&WPI_ID_BSS)) {
    sub WPI_ID_BSS () {	0;}
}
unless(defined(&WPI_ID_BROADCAST)) {
    sub WPI_ID_BROADCAST () {	24;}
}
unless(defined(&WPI_TX_NEED_RTS)) {
    sub WPI_TX_NEED_RTS () {	(1<< 1);}
}
unless(defined(&WPI_TX_NEED_CTS)) {
    sub WPI_TX_NEED_CTS () {	(1<< 2);}
}
unless(defined(&WPI_TX_NEED_ACK)) {
    sub WPI_TX_NEED_ACK () {	(1<< 3);}
}
unless(defined(&WPI_TX_FULL_TXOP)) {
    sub WPI_TX_FULL_TXOP () {	(1<< 7);}
}
unless(defined(&WPI_TX_AUTO_SEQ)) {
    sub WPI_TX_AUTO_SEQ () {	(1<< 13);}
}
unless(defined(&WPI_TX_INSERT_TSTAMP)) {
    sub WPI_TX_INSERT_TSTAMP () {	(1<< 16);}
}
unless(defined(&WPI_MRR_CTL)) {
    sub WPI_MRR_CTL () {	0;}
}
unless(defined(&WPI_MRR_DATA)) {
    sub WPI_MRR_DATA () {	1;}
}
unless(defined(&WPI_OFDM6)) {
    sub WPI_OFDM6 () {	0;}
}
unless(defined(&WPI_OFDM54)) {
    sub WPI_OFDM54 () {	7;}
}
unless(defined(&WPI_CCK1)) {
    sub WPI_CCK1 () {	8;}
}
unless(defined(&WPI_CCK2)) {
    sub WPI_CCK2 () {	9;}
}
unless(defined(&WPI_CCK11)) {
    sub WPI_CCK11 () {	11;}
}
unless(defined(&WPI_LED_ACTIVITY)) {
    sub WPI_LED_ACTIVITY () {	1;}
}
unless(defined(&WPI_LED_LINK)) {
    sub WPI_LED_LINK () {	2;}
}
unless(defined(&WPI_SCAN_5GHZ)) {
    sub WPI_SCAN_5GHZ () {	1;}
}
unless(defined(&WPI_CHAN_ACTIVE)) {
    sub WPI_CHAN_ACTIVE () {	3;}
}
unless(defined(&WPI_EEPROM_MAC)) {
    sub WPI_EEPROM_MAC () {	0x15;}
}
unless(defined(&WPI_EEPROM_REVISION)) {
    sub WPI_EEPROM_REVISION () {	0x35;}
}
unless(defined(&WPI_EEPROM_CAPABILITIES)) {
    sub WPI_EEPROM_CAPABILITIES () {	0x45;}
}
unless(defined(&WPI_EEPROM_TYPE)) {
    sub WPI_EEPROM_TYPE () {	0x4a;}
}
unless(defined(&WPI_EEPROM_PWR1)) {
    sub WPI_EEPROM_PWR1 () {	0x1ae;}
}
unless(defined(&WPI_EEPROM_PWR2)) {
    sub WPI_EEPROM_PWR2 () {	0x1bc;}
}
unless(defined(&WPI_READ)) {
    sub WPI_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&WPI_WRITE)) {
    sub WPI_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&WPI_WRITE_REGION_4)) {
    sub WPI_WRITE_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
1;
