.TH GV_TCL N "10 March 2007"

.SH NAME

gv_tcl - graph manipulation in tcl

.SH SYNOPSIS

#!/usr/bin/tclsh
.br
load /usr/lib/graphviz/tcl/gv.so

.SH USAGE

Requires tcl7.6 or later.

.SH INTRODUCTION

.B gv_tcl
is a dynamically loaded extension for
.B tcl
that provides access to the graph facilities of
.B graphviz.

.SH COMMANDS

.TP
\fBNew graphs\fR
.br
.TP
New empty graph
.br
\fI<graph_handle>\fR \fBgv::graph\fR \fI<name>\fR
.br
\fI<graph_handle>\fR \fBgv::digraph\fR \fI<name>\fR
.br
\fI<graph_handle>\fR \fBgv::strictgraph\fR \fI<name>\fR
.br
\fI<graph_handle>\fR \fBgv::strictdigraph\fR \fI<name>\fR
.br
.TP
New graph from a dot-syntax string or file
.br
\fI<graph_handle>\fR \fBgv::readstring\fR \fI<string>\fR
.br
\fI<graph_handle>\fR \fBgv::read\fR \fI<filename>\fR
.br
\fI<graph_handle>\fR \fBgv::read\fR \fI<channel>\fR
.br
.TP
Add new subgraph to existing graph
.br
\fI<graph_handle>\fR \fBgv::graph\fR \fI<graph_handle> <name>\fR
.br
.TP
\fBNew nodes\fR
.br
.TP
Add new node to existing graph
.br
\fI<node_handle>\fR \fBgv::node\fR \fI<graph_handle> <name>\fR
.br
.TP
\fBNew edges\fR
.br
.TP
Add new edge between existing nodes
.br
\fI<edge_handle>\fR \fBgv::edge\fR \fI<tail_node_handle> <head_node_handle>\fR
.br
.TP
Add a new edge between an existing tail node, and a named head node which will be induced in the graph if it doesn't already exist
.br
\fI<edge_handle>\fR \fBgv::edge\fR \fI<tail_node_handle> <head_name>\fR
.br
.TP
Add a new edge between an existing head node, and a named tail node which will be induced in the graph if it doesn't already exist
.br
\fI<edge_handle>\fR \fBgv::edge\fR \fI<tail_name> <head_node_handle>\fR
.br
.TP
Add a new edge between named tail  and head nodes which will be induced in the graph if they don't already exist
.br
\fI<edge_handle>\fR \fBgv::edge\fR \fI<graph_handle> <tail_name> <head_name>\fR
.br
.TP
\fBSetting attribute values\fR
.br
.TP
Set value of named attribute of graph/node/edge - creating attribute if necessary
.br
\fI<string>\fR \fBgv::setv\fR \fI<graph_handle> <attr_name> <attr_value>\fR
.br
\fI<string>\fR \fBgv::setv\fR \fI<node_handle> <attr_name> <attr_value>\fR
.br
\fI<string>\fR \fBgv::setv\fR \fI<edge_handle> <attr_name> <attr_value>\fR
.br
.TP
Set value of existing attribute of graph/node/edge (using attribute handle)
.br
\fI<string>\fR \fBgv::setv\fR \fI<graph_handle> <attr_handle> <attr_value>\fR
.br
\fI<string>\fR \fBgv::setv\fR \fI<node_handle> <attr_handle> <attr_value>\fR
.br
\fI<string>\fR \fBgv::setv\fR \fI<edge_handle> <attr_handle> <attr_value>\fR
.br
.TP
\fBGetting attribute values\fR
.br
.TP
Get value of named attribute of graph/node/edge
.br
\fI<string>\fR \fBgv::getv\fR \fI<graph_handle> <attr_name>\fR
.br
\fI<string>\fR \fBgv::getv\fR \fI<node_handle> <attr_name>\fR
.br
\fI<string>\fR \fBgv::getv\fR \fI<edge_handle> <attr_name>\fR
.br
.TP
Get value of attribute of graph/node/edge (using attribute handle)
.br
\fI<string>\fR \fBgv::getv\fR \fI<graph_handle> <attr_handle>\fR
.br
\fI<string>\fR \fBgv::getv\fR \fI<node_handle> <attr_handle>\fR
.br
\fI<string>\fR \fBgv::getv\fR \fI<edge_handle> <attr_handle>\fR
.br
.TP
\fBObtain names from handles\fR
.br
\fI<string>\fR \fBgv::nameof\fR \fI<graph_handle>\fR
.br
\fI<string>\fR \fBgv::nameof\fR \fI<node_handle>\fR
.br
\fI<string>\fR \fBgv::nameof\fR \fI<attr_handle>\fR
.br
.TP
\fBFind handles from names\fR
.br
\fI<graph_handle>\fR \fBgv::findsubg\fR \fI<graph_handle> <name>\fR
.br
\fI<node_handle>\fR \fBgv::findnode\fR \fI<graph_handle> <name>\fR
.br
\fI<edge_handle>\fR \fBgv::findedge\fR \fI<tail_node_handle> <head_node_handle>\fR
.br
\fI<attr_handle>\fR \fBgv::findattr\fR \fI<graph_handle> <name>\fR
.br
\fI<attr_handle>\fR \fBgv::findattr\fR \fI<node_handle> <name>\fR
.br
\fI<attr_handle>\fR \fBgv::findattr\fR \fI<edge_handle> <name>\fR
.br
.TP
\fBMisc graph navigators returning handles\fR
.br
\fI<node_handle>\fR \fBgv::headof\fR \fI<edge_handle>\fR
.br
\fI<node_handle>\fR \fBgv::tailof\fR \fI<edge_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::graphof\fR \fI<graph_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::graphof\fR \fI<edge_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::graphof\fR \fI<node_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::rootof\fR \fI<graph_handle>\fR
.br
.TP
\fBObtain handles of proto node/edge for setting default attribute values\fR
.br
\fI<node_handle>\fR \fBgv::protonode\fR \fI<graph_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::protoedge\fR \fI<graph_handle>\fR
.br
.TP
\fBIterators\fR
.br
.TP
Iteration termination tests
.br
\fI<boolean_string>\fR \fBgv::ok\fR \fI<graph_handle>\fR
.br
\fI<boolean_string>\fR \fBgv::ok\fR \fI<node_handle>\fR
.br
\fI<boolean_string>\fR \fBgv::ok\fR \fI<edge_handle>\fR
.br
\fI<boolean_string>\fR \fBgv::ok\fR \fI<attr_handle>\fR
.br
.TP
Iterate over subgraphs of a graph
.br
\fI<graph_handle>\fR \fBgv::firstsubg\fR \fI<graph_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::nextsubg\fR \fI<graph_handle> <subgraph_handle>\fR
.br
.TP
Iterate over supergraphs of a graph (obscure and rarely useful)
.br
\fI<graph_handle>\fR \fBgv::firstsupg\fR \fI<graph_handle>\fR
.br
\fI<graph_handle>\fR \fBgv::nextsupg\fR \fI<graph_handle> <subgraph_handle>\fR
.br
.TP
Iterate over edges of a graph
.br
\fI<edge_handle>\fR \fBgv::firstedge\fR \fI<graph_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextedge\fR \fI<graph_handle> <edge_handle>\fR
.br
.TP
Iterate over outedges of a graph
.br
\fI<edge_handle>\fR \fBgv::firstout\fR \fI<graph_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextout\fR \fI<graph_handle> <edge_handle>\fR
.br
.TP
Iterate over edges of a node
.br
\fI<edge_handle>\fR \fBgv::firstedge\fR \fI<node_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextedge\fR \fI<node_handle> <edge_handle>\fR
.br
.TP
Iterate over out-edges of a node
.br
\fI<edge_handle>\fR \fBgv::firstout\fR \fI<node_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextout\fR \fI<node_handle> <edge_handle>\fR
.br
.TP
Iterate over head nodes reachable from out-edges of a node
.br
\fI<node_handle>\fR \fBgv::firsthead\fR \fI<node_handle>\fR
.br
\fI<node_handle>\fR \fBgv::nexthead\fR \fI<node_handle> <head_node_handle>\fR
.br
.TP
Iterate over in-edges of a graph
.br
\fI<edge_handle>\fR \fBgv::firstin\fR \fI<graph_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextin\fR \fI<node_handle> <edge_handle>\fR
.br
.TP
Iterate over in-edges of a node
.br
\fI<edge_handle>\fR \fBgv::firstin\fR \fI<node_handle>\fR
.br
\fI<edge_handle>\fR \fBgv::nextin\fR \fI<graph_handle> <edge_handle>\fR
.br
.TP
Iterate over tail nodes reachable from in-edges of a node
.br
\fI<node_handle>\fR \fBgv::firsttail\fR \fI<node_handle>\fR
.br
\fI<node_handle>\fR \fBgv::nexttail\fR \fI<node_handle> <tail_node_handle>\fR
.br
.TP
Iterate over nodes of a graph
.br
\fI<node_handle>\fR \fBgv::firstnode\fR \fI<graph_handle>\fR
.br
\fI<node_handle>\fR \fBgv::nextnode\fR \fI<graph_handle> <node_handle>\fR
.br
.TP
Iterate over nodes of an edge
.br
\fI<node_handle>\fR \fBgv::firstnode\fR \fI<edge_handle>\fR
.br
\fI<node_handle>\fR \fBgv::nextnode\fR \fI<edge_handle> <node_handle>\fR
.br
.TP
Iterate over attributes of a graph
.br
\fI<attr_handle>\fR \fBgv::firstattr\fR \fI<graph_handle>\fR
.br
\fI<attr_handle>\fR \fBgv::nextattr\fR \fI<graph_handle> <attr_handle>\fR
.br
.TP
Iterate over attributes of an edge
.br
\fI<attr_handle>\fR \fBgv::firstattr\fR \fI<edge_handle>\fR
.br
\fI<attr_handle>\fR \fBgv::nextattr\fR \fI<edge_handle> <attr_handle>\fR
.br
.TP
Iterate over attributes of a node
.br
\fI<attr_handle>\fR \fBgv::firstattr\fR \fI<node_handle>\fR
.br
\fI<attr_handle>\fR \fBgv::nextattr\fR \fI<node_handle> <attr_handle>\fR
.br
.TP
\fBRemove graph objects\fR
.br
\fBgv::rm\fR \fI<graph_handle>\fR
.br
\fBgv::rm\fR \fI<node_handle>\fR
.br
\fBgv::rm\fR \fI<edge_handle>\fR
.br
.TP
\fBLayout\fR
.br
.TP
Annotate a graph with layout attributes and values using a specific layout engine
.br
\fBgv::layout\fR \fI<graph_handle> <engine>\fR
.br
.TP
\fBRender\fR
.br
.TP
Render a layout into attributes of the graph
.br
\fBgv::render\fR \fI<graph_handle>\fR
.br
.TP
Render a layout in a specific format
.br
\fBgv::render\fR \fI<graph_handle> <format>\fR
.br
\fBgv::render\fR \fI<graph_handle> <format> <filename>\fR
.br
\fBgv::render\fR \fI<graph_handle> <format> <channel>\fR
.br
\fBgv::render\fR \fI<graph_handle> <format> <data_handle>\fR
.br

.SH KEYWORDS

graph, dot, neato, fdp, circo, twopi, tcl.

