%% Generated by the Erlang ASN.1 BER-compiler version, utilizing bit-syntax:1.4.4.12
%% Purpose: encoder and decoder to the types in mod megaco_per_bin_media_gateway_control_v1

-module('megaco_per_bin_media_gateway_control_v1').
-include("megaco_per_bin_media_gateway_control_v1.hrl").
-define('RT_PER',asn1rt_per_bin).
-export([encoding_rule/0]).
-export([
'enc_Value'/1,
'enc_TimeNotation'/1,
'enc_H221NonStandard'/1,
'enc_NonStandardIdentifier'/1,
'enc_NonStandardData'/1,
'enc_StatisticsParameter'/1,
'enc_StatisticsDescriptor'/1,
'enc_PackagesItem'/1,
'enc_PackagesDescriptor'/1,
'enc_ServiceChangeProfile'/1,
'enc_ServiceChangeMethod'/1,
'enc_ServiceChangeResParm'/1,
'enc_ServiceChangeAddress'/1,
'enc_ServiceChangeParm'/1,
'enc_DigitMapValue'/1,
'enc_DigitMapName'/1,
'enc_DigitMapDescriptor'/1,
'enc_ModemType'/1,
'enc_ModemDescriptor'/1,
'enc_RequestID'/1,
'enc_SigParameter'/1,
'enc_NotifyCompletion'/1,
'enc_SignalName'/1,
'enc_SignalType'/1,
'enc_Signal'/1,
'enc_SeqSigList'/1,
'enc_SignalRequest'/1,
'enc_SignalsDescriptor'/1,
'enc_EventSpec'/1,
'enc_EventBufferDescriptor'/1,
'enc_SecondRequestedActions'/1,
'enc_SecondRequestedEvent'/1,
'enc_SecondEventsDescriptor'/1,
'enc_EventDM'/1,
'enc_RequestedActions'/1,
'enc_RequestedEvent'/1,
'enc_EventsDescriptor'/1,
'enc_StreamID'/1,
'enc_MuxType'/1,
'enc_MuxDescriptor'/1,
'enc_ServiceState'/1,
'enc_EventBufferControl'/1,
'enc_TerminationStateDescriptor'/1,
'enc_PropertyGroup'/1,
'enc_LocalRemoteDescriptor'/1,
'enc_Relation'/1,
'enc_PkgdName'/1,
'enc_Name'/1,
'enc_PropertyParm'/1,
'enc_StreamMode'/1,
'enc_LocalControlDescriptor'/1,
'enc_StreamParms'/1,
'enc_StreamDescriptor'/1,
'enc_MediaDescriptor'/1,
'enc_TerminationIDList'/1,
'enc_TerminationID'/1,
'enc_WildcardField'/1,
'enc_ServiceChangeResult'/1,
'enc_ServiceChangeReply'/1,
'enc_ServiceChangeRequest'/1,
'enc_EventParameter'/1,
'enc_EventName'/1,
'enc_ObservedEvent'/1,
'enc_ObservedEventsDescriptor'/1,
'enc_NotifyReply'/1,
'enc_NotifyRequest'/1,
'enc_AuditDescriptor'/1,
'enc_AuditReturnParameter'/1,
'enc_TerminationAudit'/1,
'enc_AuditResult'/1,
'enc_AuditReply'/1,
'enc_AuditRequest'/1,
'enc_SubtractRequest'/1,
'enc_AmmsReply'/1,
'enc_AmmDescriptor'/1,
'enc_AmmRequest'/1,
'enc_TopologyRequest'/1,
'enc_CommandReply'/1,
'enc_Command'/1,
'enc_CommandRequest'/1,
'enc_ContextAttrAuditRequest'/1,
'enc_ContextRequest'/1,
'enc_ActionReply'/1,
'enc_ActionRequest'/1,
'enc_ContextID'/1,
'enc_ErrorText'/1,
'enc_ErrorCode'/1,
'enc_ErrorDescriptor'/1,
'enc_TransactionAck'/1,
'enc_TransactionResponseAck'/1,
'enc_TransactionReply'/1,
'enc_TransactionPending'/1,
'enc_TransactionRequest'/1,
'enc_TransactionId'/1,
'enc_Transaction'/1,
'enc_PathName'/1,
'enc_IP6Address'/1,
'enc_IP4Address'/1,
'enc_DomainName'/1,
'enc_MId'/1,
'enc_Message'/1,
'enc_AuthData'/1,
'enc_SequenceNum'/1,
'enc_SecurityParmIndex'/1,
'enc_AuthenticationHeader'/1,
'enc_MegacoMessage'/1
]).

-export([
'dec_Value'/2,
'dec_TimeNotation'/2,
'dec_H221NonStandard'/2,
'dec_NonStandardIdentifier'/2,
'dec_NonStandardData'/2,
'dec_StatisticsParameter'/2,
'dec_StatisticsDescriptor'/2,
'dec_PackagesItem'/2,
'dec_PackagesDescriptor'/2,
'dec_ServiceChangeProfile'/2,
'dec_ServiceChangeMethod'/2,
'dec_ServiceChangeResParm'/2,
'dec_ServiceChangeAddress'/2,
'dec_ServiceChangeParm'/2,
'dec_DigitMapValue'/2,
'dec_DigitMapName'/2,
'dec_DigitMapDescriptor'/2,
'dec_ModemType'/2,
'dec_ModemDescriptor'/2,
'dec_RequestID'/2,
'dec_SigParameter'/2,
'dec_NotifyCompletion'/2,
'dec_SignalName'/2,
'dec_SignalType'/2,
'dec_Signal'/2,
'dec_SeqSigList'/2,
'dec_SignalRequest'/2,
'dec_SignalsDescriptor'/2,
'dec_EventSpec'/2,
'dec_EventBufferDescriptor'/2,
'dec_SecondRequestedActions'/2,
'dec_SecondRequestedEvent'/2,
'dec_SecondEventsDescriptor'/2,
'dec_EventDM'/2,
'dec_RequestedActions'/2,
'dec_RequestedEvent'/2,
'dec_EventsDescriptor'/2,
'dec_StreamID'/2,
'dec_MuxType'/2,
'dec_MuxDescriptor'/2,
'dec_ServiceState'/2,
'dec_EventBufferControl'/2,
'dec_TerminationStateDescriptor'/2,
'dec_PropertyGroup'/2,
'dec_LocalRemoteDescriptor'/2,
'dec_Relation'/2,
'dec_PkgdName'/2,
'dec_Name'/2,
'dec_PropertyParm'/2,
'dec_StreamMode'/2,
'dec_LocalControlDescriptor'/2,
'dec_StreamParms'/2,
'dec_StreamDescriptor'/2,
'dec_MediaDescriptor'/2,
'dec_TerminationIDList'/2,
'dec_TerminationID'/2,
'dec_WildcardField'/2,
'dec_ServiceChangeResult'/2,
'dec_ServiceChangeReply'/2,
'dec_ServiceChangeRequest'/2,
'dec_EventParameter'/2,
'dec_EventName'/2,
'dec_ObservedEvent'/2,
'dec_ObservedEventsDescriptor'/2,
'dec_NotifyReply'/2,
'dec_NotifyRequest'/2,
'dec_AuditDescriptor'/2,
'dec_AuditReturnParameter'/2,
'dec_TerminationAudit'/2,
'dec_AuditResult'/2,
'dec_AuditReply'/2,
'dec_AuditRequest'/2,
'dec_SubtractRequest'/2,
'dec_AmmsReply'/2,
'dec_AmmDescriptor'/2,
'dec_AmmRequest'/2,
'dec_TopologyRequest'/2,
'dec_CommandReply'/2,
'dec_Command'/2,
'dec_CommandRequest'/2,
'dec_ContextAttrAuditRequest'/2,
'dec_ContextRequest'/2,
'dec_ActionReply'/2,
'dec_ActionRequest'/2,
'dec_ContextID'/2,
'dec_ErrorText'/2,
'dec_ErrorCode'/2,
'dec_ErrorDescriptor'/2,
'dec_TransactionAck'/2,
'dec_TransactionResponseAck'/2,
'dec_TransactionReply'/2,
'dec_TransactionPending'/2,
'dec_TransactionRequest'/2,
'dec_TransactionId'/2,
'dec_Transaction'/2,
'dec_PathName'/2,
'dec_IP6Address'/2,
'dec_IP4Address'/2,
'dec_DomainName'/2,
'dec_MId'/2,
'dec_Message'/2,
'dec_AuthData'/2,
'dec_SequenceNum'/2,
'dec_SecurityParmIndex'/2,
'dec_AuthenticationHeader'/2,
'dec_MegacoMessage'/2
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   per_bin.

encode(Type,Data) ->
case catch ?RT_PER:complete(encode_disp(Type,Data)) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {X,_Rest} ->
    {ok,X};
  {X,_Rest,_Len} ->
    {ok,X}
end.

encode_disp('Value',Data) -> 'enc_Value'(Data);
encode_disp('TimeNotation',Data) -> 'enc_TimeNotation'(Data);
encode_disp('H221NonStandard',Data) -> 'enc_H221NonStandard'(Data);
encode_disp('NonStandardIdentifier',Data) -> 'enc_NonStandardIdentifier'(Data);
encode_disp('NonStandardData',Data) -> 'enc_NonStandardData'(Data);
encode_disp('StatisticsParameter',Data) -> 'enc_StatisticsParameter'(Data);
encode_disp('StatisticsDescriptor',Data) -> 'enc_StatisticsDescriptor'(Data);
encode_disp('PackagesItem',Data) -> 'enc_PackagesItem'(Data);
encode_disp('PackagesDescriptor',Data) -> 'enc_PackagesDescriptor'(Data);
encode_disp('ServiceChangeProfile',Data) -> 'enc_ServiceChangeProfile'(Data);
encode_disp('ServiceChangeMethod',Data) -> 'enc_ServiceChangeMethod'(Data);
encode_disp('ServiceChangeResParm',Data) -> 'enc_ServiceChangeResParm'(Data);
encode_disp('ServiceChangeAddress',Data) -> 'enc_ServiceChangeAddress'(Data);
encode_disp('ServiceChangeParm',Data) -> 'enc_ServiceChangeParm'(Data);
encode_disp('DigitMapValue',Data) -> 'enc_DigitMapValue'(Data);
encode_disp('DigitMapName',Data) -> 'enc_DigitMapName'(Data);
encode_disp('DigitMapDescriptor',Data) -> 'enc_DigitMapDescriptor'(Data);
encode_disp('ModemType',Data) -> 'enc_ModemType'(Data);
encode_disp('ModemDescriptor',Data) -> 'enc_ModemDescriptor'(Data);
encode_disp('RequestID',Data) -> 'enc_RequestID'(Data);
encode_disp('SigParameter',Data) -> 'enc_SigParameter'(Data);
encode_disp('NotifyCompletion',Data) -> 'enc_NotifyCompletion'(Data);
encode_disp('SignalName',Data) -> 'enc_SignalName'(Data);
encode_disp('SignalType',Data) -> 'enc_SignalType'(Data);
encode_disp('Signal',Data) -> 'enc_Signal'(Data);
encode_disp('SeqSigList',Data) -> 'enc_SeqSigList'(Data);
encode_disp('SignalRequest',Data) -> 'enc_SignalRequest'(Data);
encode_disp('SignalsDescriptor',Data) -> 'enc_SignalsDescriptor'(Data);
encode_disp('EventSpec',Data) -> 'enc_EventSpec'(Data);
encode_disp('EventBufferDescriptor',Data) -> 'enc_EventBufferDescriptor'(Data);
encode_disp('SecondRequestedActions',Data) -> 'enc_SecondRequestedActions'(Data);
encode_disp('SecondRequestedEvent',Data) -> 'enc_SecondRequestedEvent'(Data);
encode_disp('SecondEventsDescriptor',Data) -> 'enc_SecondEventsDescriptor'(Data);
encode_disp('EventDM',Data) -> 'enc_EventDM'(Data);
encode_disp('RequestedActions',Data) -> 'enc_RequestedActions'(Data);
encode_disp('RequestedEvent',Data) -> 'enc_RequestedEvent'(Data);
encode_disp('EventsDescriptor',Data) -> 'enc_EventsDescriptor'(Data);
encode_disp('StreamID',Data) -> 'enc_StreamID'(Data);
encode_disp('MuxType',Data) -> 'enc_MuxType'(Data);
encode_disp('MuxDescriptor',Data) -> 'enc_MuxDescriptor'(Data);
encode_disp('ServiceState',Data) -> 'enc_ServiceState'(Data);
encode_disp('EventBufferControl',Data) -> 'enc_EventBufferControl'(Data);
encode_disp('TerminationStateDescriptor',Data) -> 'enc_TerminationStateDescriptor'(Data);
encode_disp('PropertyGroup',Data) -> 'enc_PropertyGroup'(Data);
encode_disp('LocalRemoteDescriptor',Data) -> 'enc_LocalRemoteDescriptor'(Data);
encode_disp('Relation',Data) -> 'enc_Relation'(Data);
encode_disp('PkgdName',Data) -> 'enc_PkgdName'(Data);
encode_disp('Name',Data) -> 'enc_Name'(Data);
encode_disp('PropertyParm',Data) -> 'enc_PropertyParm'(Data);
encode_disp('StreamMode',Data) -> 'enc_StreamMode'(Data);
encode_disp('LocalControlDescriptor',Data) -> 'enc_LocalControlDescriptor'(Data);
encode_disp('StreamParms',Data) -> 'enc_StreamParms'(Data);
encode_disp('StreamDescriptor',Data) -> 'enc_StreamDescriptor'(Data);
encode_disp('MediaDescriptor',Data) -> 'enc_MediaDescriptor'(Data);
encode_disp('TerminationIDList',Data) -> 'enc_TerminationIDList'(Data);
encode_disp('TerminationID',Data) -> 'enc_TerminationID'(Data);
encode_disp('WildcardField',Data) -> 'enc_WildcardField'(Data);
encode_disp('ServiceChangeResult',Data) -> 'enc_ServiceChangeResult'(Data);
encode_disp('ServiceChangeReply',Data) -> 'enc_ServiceChangeReply'(Data);
encode_disp('ServiceChangeRequest',Data) -> 'enc_ServiceChangeRequest'(Data);
encode_disp('EventParameter',Data) -> 'enc_EventParameter'(Data);
encode_disp('EventName',Data) -> 'enc_EventName'(Data);
encode_disp('ObservedEvent',Data) -> 'enc_ObservedEvent'(Data);
encode_disp('ObservedEventsDescriptor',Data) -> 'enc_ObservedEventsDescriptor'(Data);
encode_disp('NotifyReply',Data) -> 'enc_NotifyReply'(Data);
encode_disp('NotifyRequest',Data) -> 'enc_NotifyRequest'(Data);
encode_disp('AuditDescriptor',Data) -> 'enc_AuditDescriptor'(Data);
encode_disp('AuditReturnParameter',Data) -> 'enc_AuditReturnParameter'(Data);
encode_disp('TerminationAudit',Data) -> 'enc_TerminationAudit'(Data);
encode_disp('AuditResult',Data) -> 'enc_AuditResult'(Data);
encode_disp('AuditReply',Data) -> 'enc_AuditReply'(Data);
encode_disp('AuditRequest',Data) -> 'enc_AuditRequest'(Data);
encode_disp('SubtractRequest',Data) -> 'enc_SubtractRequest'(Data);
encode_disp('AmmsReply',Data) -> 'enc_AmmsReply'(Data);
encode_disp('AmmDescriptor',Data) -> 'enc_AmmDescriptor'(Data);
encode_disp('AmmRequest',Data) -> 'enc_AmmRequest'(Data);
encode_disp('TopologyRequest',Data) -> 'enc_TopologyRequest'(Data);
encode_disp('CommandReply',Data) -> 'enc_CommandReply'(Data);
encode_disp('Command',Data) -> 'enc_Command'(Data);
encode_disp('CommandRequest',Data) -> 'enc_CommandRequest'(Data);
encode_disp('ContextAttrAuditRequest',Data) -> 'enc_ContextAttrAuditRequest'(Data);
encode_disp('ContextRequest',Data) -> 'enc_ContextRequest'(Data);
encode_disp('ActionReply',Data) -> 'enc_ActionReply'(Data);
encode_disp('ActionRequest',Data) -> 'enc_ActionRequest'(Data);
encode_disp('ContextID',Data) -> 'enc_ContextID'(Data);
encode_disp('ErrorText',Data) -> 'enc_ErrorText'(Data);
encode_disp('ErrorCode',Data) -> 'enc_ErrorCode'(Data);
encode_disp('ErrorDescriptor',Data) -> 'enc_ErrorDescriptor'(Data);
encode_disp('TransactionAck',Data) -> 'enc_TransactionAck'(Data);
encode_disp('TransactionResponseAck',Data) -> 'enc_TransactionResponseAck'(Data);
encode_disp('TransactionReply',Data) -> 'enc_TransactionReply'(Data);
encode_disp('TransactionPending',Data) -> 'enc_TransactionPending'(Data);
encode_disp('TransactionRequest',Data) -> 'enc_TransactionRequest'(Data);
encode_disp('TransactionId',Data) -> 'enc_TransactionId'(Data);
encode_disp('Transaction',Data) -> 'enc_Transaction'(Data);
encode_disp('PathName',Data) -> 'enc_PathName'(Data);
encode_disp('IP6Address',Data) -> 'enc_IP6Address'(Data);
encode_disp('IP4Address',Data) -> 'enc_IP4Address'(Data);
encode_disp('DomainName',Data) -> 'enc_DomainName'(Data);
encode_disp('MId',Data) -> 'enc_MId'(Data);
encode_disp('Message',Data) -> 'enc_Message'(Data);
encode_disp('AuthData',Data) -> 'enc_AuthData'(Data);
encode_disp('SequenceNum',Data) -> 'enc_SequenceNum'(Data);
encode_disp('SecurityParmIndex',Data) -> 'enc_SecurityParmIndex'(Data);
encode_disp('AuthenticationHeader',Data) -> 'enc_AuthenticationHeader'(Data);
encode_disp('MegacoMessage',Data) -> 'enc_MegacoMessage'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('Value',Data) -> 'dec_Value'(Data,mandatory);
decode_disp('TimeNotation',Data) -> 'dec_TimeNotation'(Data,mandatory);
decode_disp('H221NonStandard',Data) -> 'dec_H221NonStandard'(Data,mandatory);
decode_disp('NonStandardIdentifier',Data) -> 'dec_NonStandardIdentifier'(Data,mandatory);
decode_disp('NonStandardData',Data) -> 'dec_NonStandardData'(Data,mandatory);
decode_disp('StatisticsParameter',Data) -> 'dec_StatisticsParameter'(Data,mandatory);
decode_disp('StatisticsDescriptor',Data) -> 'dec_StatisticsDescriptor'(Data,mandatory);
decode_disp('PackagesItem',Data) -> 'dec_PackagesItem'(Data,mandatory);
decode_disp('PackagesDescriptor',Data) -> 'dec_PackagesDescriptor'(Data,mandatory);
decode_disp('ServiceChangeProfile',Data) -> 'dec_ServiceChangeProfile'(Data,mandatory);
decode_disp('ServiceChangeMethod',Data) -> 'dec_ServiceChangeMethod'(Data,mandatory);
decode_disp('ServiceChangeResParm',Data) -> 'dec_ServiceChangeResParm'(Data,mandatory);
decode_disp('ServiceChangeAddress',Data) -> 'dec_ServiceChangeAddress'(Data,mandatory);
decode_disp('ServiceChangeParm',Data) -> 'dec_ServiceChangeParm'(Data,mandatory);
decode_disp('DigitMapValue',Data) -> 'dec_DigitMapValue'(Data,mandatory);
decode_disp('DigitMapName',Data) -> 'dec_DigitMapName'(Data,mandatory);
decode_disp('DigitMapDescriptor',Data) -> 'dec_DigitMapDescriptor'(Data,mandatory);
decode_disp('ModemType',Data) -> 'dec_ModemType'(Data,mandatory);
decode_disp('ModemDescriptor',Data) -> 'dec_ModemDescriptor'(Data,mandatory);
decode_disp('RequestID',Data) -> 'dec_RequestID'(Data,mandatory);
decode_disp('SigParameter',Data) -> 'dec_SigParameter'(Data,mandatory);
decode_disp('NotifyCompletion',Data) -> 'dec_NotifyCompletion'(Data,mandatory);
decode_disp('SignalName',Data) -> 'dec_SignalName'(Data,mandatory);
decode_disp('SignalType',Data) -> 'dec_SignalType'(Data,mandatory);
decode_disp('Signal',Data) -> 'dec_Signal'(Data,mandatory);
decode_disp('SeqSigList',Data) -> 'dec_SeqSigList'(Data,mandatory);
decode_disp('SignalRequest',Data) -> 'dec_SignalRequest'(Data,mandatory);
decode_disp('SignalsDescriptor',Data) -> 'dec_SignalsDescriptor'(Data,mandatory);
decode_disp('EventSpec',Data) -> 'dec_EventSpec'(Data,mandatory);
decode_disp('EventBufferDescriptor',Data) -> 'dec_EventBufferDescriptor'(Data,mandatory);
decode_disp('SecondRequestedActions',Data) -> 'dec_SecondRequestedActions'(Data,mandatory);
decode_disp('SecondRequestedEvent',Data) -> 'dec_SecondRequestedEvent'(Data,mandatory);
decode_disp('SecondEventsDescriptor',Data) -> 'dec_SecondEventsDescriptor'(Data,mandatory);
decode_disp('EventDM',Data) -> 'dec_EventDM'(Data,mandatory);
decode_disp('RequestedActions',Data) -> 'dec_RequestedActions'(Data,mandatory);
decode_disp('RequestedEvent',Data) -> 'dec_RequestedEvent'(Data,mandatory);
decode_disp('EventsDescriptor',Data) -> 'dec_EventsDescriptor'(Data,mandatory);
decode_disp('StreamID',Data) -> 'dec_StreamID'(Data,mandatory);
decode_disp('MuxType',Data) -> 'dec_MuxType'(Data,mandatory);
decode_disp('MuxDescriptor',Data) -> 'dec_MuxDescriptor'(Data,mandatory);
decode_disp('ServiceState',Data) -> 'dec_ServiceState'(Data,mandatory);
decode_disp('EventBufferControl',Data) -> 'dec_EventBufferControl'(Data,mandatory);
decode_disp('TerminationStateDescriptor',Data) -> 'dec_TerminationStateDescriptor'(Data,mandatory);
decode_disp('PropertyGroup',Data) -> 'dec_PropertyGroup'(Data,mandatory);
decode_disp('LocalRemoteDescriptor',Data) -> 'dec_LocalRemoteDescriptor'(Data,mandatory);
decode_disp('Relation',Data) -> 'dec_Relation'(Data,mandatory);
decode_disp('PkgdName',Data) -> 'dec_PkgdName'(Data,mandatory);
decode_disp('Name',Data) -> 'dec_Name'(Data,mandatory);
decode_disp('PropertyParm',Data) -> 'dec_PropertyParm'(Data,mandatory);
decode_disp('StreamMode',Data) -> 'dec_StreamMode'(Data,mandatory);
decode_disp('LocalControlDescriptor',Data) -> 'dec_LocalControlDescriptor'(Data,mandatory);
decode_disp('StreamParms',Data) -> 'dec_StreamParms'(Data,mandatory);
decode_disp('StreamDescriptor',Data) -> 'dec_StreamDescriptor'(Data,mandatory);
decode_disp('MediaDescriptor',Data) -> 'dec_MediaDescriptor'(Data,mandatory);
decode_disp('TerminationIDList',Data) -> 'dec_TerminationIDList'(Data,mandatory);
decode_disp('TerminationID',Data) -> 'dec_TerminationID'(Data,mandatory);
decode_disp('WildcardField',Data) -> 'dec_WildcardField'(Data,mandatory);
decode_disp('ServiceChangeResult',Data) -> 'dec_ServiceChangeResult'(Data,mandatory);
decode_disp('ServiceChangeReply',Data) -> 'dec_ServiceChangeReply'(Data,mandatory);
decode_disp('ServiceChangeRequest',Data) -> 'dec_ServiceChangeRequest'(Data,mandatory);
decode_disp('EventParameter',Data) -> 'dec_EventParameter'(Data,mandatory);
decode_disp('EventName',Data) -> 'dec_EventName'(Data,mandatory);
decode_disp('ObservedEvent',Data) -> 'dec_ObservedEvent'(Data,mandatory);
decode_disp('ObservedEventsDescriptor',Data) -> 'dec_ObservedEventsDescriptor'(Data,mandatory);
decode_disp('NotifyReply',Data) -> 'dec_NotifyReply'(Data,mandatory);
decode_disp('NotifyRequest',Data) -> 'dec_NotifyRequest'(Data,mandatory);
decode_disp('AuditDescriptor',Data) -> 'dec_AuditDescriptor'(Data,mandatory);
decode_disp('AuditReturnParameter',Data) -> 'dec_AuditReturnParameter'(Data,mandatory);
decode_disp('TerminationAudit',Data) -> 'dec_TerminationAudit'(Data,mandatory);
decode_disp('AuditResult',Data) -> 'dec_AuditResult'(Data,mandatory);
decode_disp('AuditReply',Data) -> 'dec_AuditReply'(Data,mandatory);
decode_disp('AuditRequest',Data) -> 'dec_AuditRequest'(Data,mandatory);
decode_disp('SubtractRequest',Data) -> 'dec_SubtractRequest'(Data,mandatory);
decode_disp('AmmsReply',Data) -> 'dec_AmmsReply'(Data,mandatory);
decode_disp('AmmDescriptor',Data) -> 'dec_AmmDescriptor'(Data,mandatory);
decode_disp('AmmRequest',Data) -> 'dec_AmmRequest'(Data,mandatory);
decode_disp('TopologyRequest',Data) -> 'dec_TopologyRequest'(Data,mandatory);
decode_disp('CommandReply',Data) -> 'dec_CommandReply'(Data,mandatory);
decode_disp('Command',Data) -> 'dec_Command'(Data,mandatory);
decode_disp('CommandRequest',Data) -> 'dec_CommandRequest'(Data,mandatory);
decode_disp('ContextAttrAuditRequest',Data) -> 'dec_ContextAttrAuditRequest'(Data,mandatory);
decode_disp('ContextRequest',Data) -> 'dec_ContextRequest'(Data,mandatory);
decode_disp('ActionReply',Data) -> 'dec_ActionReply'(Data,mandatory);
decode_disp('ActionRequest',Data) -> 'dec_ActionRequest'(Data,mandatory);
decode_disp('ContextID',Data) -> 'dec_ContextID'(Data,mandatory);
decode_disp('ErrorText',Data) -> 'dec_ErrorText'(Data,mandatory);
decode_disp('ErrorCode',Data) -> 'dec_ErrorCode'(Data,mandatory);
decode_disp('ErrorDescriptor',Data) -> 'dec_ErrorDescriptor'(Data,mandatory);
decode_disp('TransactionAck',Data) -> 'dec_TransactionAck'(Data,mandatory);
decode_disp('TransactionResponseAck',Data) -> 'dec_TransactionResponseAck'(Data,mandatory);
decode_disp('TransactionReply',Data) -> 'dec_TransactionReply'(Data,mandatory);
decode_disp('TransactionPending',Data) -> 'dec_TransactionPending'(Data,mandatory);
decode_disp('TransactionRequest',Data) -> 'dec_TransactionRequest'(Data,mandatory);
decode_disp('TransactionId',Data) -> 'dec_TransactionId'(Data,mandatory);
decode_disp('Transaction',Data) -> 'dec_Transaction'(Data,mandatory);
decode_disp('PathName',Data) -> 'dec_PathName'(Data,mandatory);
decode_disp('IP6Address',Data) -> 'dec_IP6Address'(Data,mandatory);
decode_disp('IP4Address',Data) -> 'dec_IP4Address'(Data,mandatory);
decode_disp('DomainName',Data) -> 'dec_DomainName'(Data,mandatory);
decode_disp('MId',Data) -> 'dec_MId'(Data,mandatory);
decode_disp('Message',Data) -> 'dec_Message'(Data,mandatory);
decode_disp('AuthData',Data) -> 'dec_AuthData'(Data,mandatory);
decode_disp('SequenceNum',Data) -> 'dec_SequenceNum'(Data,mandatory);
decode_disp('SecurityParmIndex',Data) -> 'dec_SecurityParmIndex'(Data,mandatory);
decode_disp('AuthenticationHeader',Data) -> 'dec_AuthenticationHeader'(Data,mandatory);
decode_disp('MegacoMessage',Data) -> 'dec_MegacoMessage'(Data,mandatory);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
  [{vsn,'1.4.4.12'},   {module,'megaco_per_bin_media_gateway_control_v1'},   {options,[per_bin,
 report_errors,
 {cwd,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/megaco/src/binary"},
 {outdir,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/megaco/src/binary"},
 noobj,
 {i,"."},
 {i,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/megaco/src/binary"}]}].

'enc_Value'({'Value',Val}) ->
'enc_Value'(Val);

'enc_Value'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_Value_components'(Val, [])
].
'enc_Value_components'([], Acc) -> lists:reverse(Acc);

'enc_Value_components'([H|T], Acc) ->
'enc_Value_components'(T, [?RT_PER:encode_octet_string([],H) | Acc]).


'dec_Value'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_Value_components'(Num, Bytes1, telltype, []).
'dec_Value_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_Value_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = ?RT_PER:decode_octet_string(Bytes,[]),
   'dec_Value_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_TimeNotation'(Val) ->
Val1 = ?RT_PER:list_to_record('TimeNotation', Val),
[

%% attribute number 1 with type IA5String
?RT_PER:encode_IA5String([{'SizeConstraint',8}],?RT_PER:cindex(2,Val1,date)),

%% attribute number 2 with type IA5String
?RT_PER:encode_IA5String([{'SizeConstraint',8}],?RT_PER:cindex(3,Val1,time))].


'dec_TimeNotation'(Bytes,_) ->

%% attribute number 1 with type IA5String
{Term1,Bytes1} = ?RT_PER:decode_IA5String(Bytes,[{'SizeConstraint',8}]),

%% attribute number 2 with type IA5String
{Term2,Bytes2} = ?RT_PER:decode_IA5String(Bytes1,[{'SizeConstraint',8}]),
{{'TimeNotation',Term1,Term2},Bytes2}.

'enc_H221NonStandard'(Val) ->
Val1 = ?RT_PER:list_to_record('H221NonStandard', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,255}}],?RT_PER:cindex(2,Val1,t35CountryCode1)),

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,255}}],?RT_PER:cindex(3,Val1,t35CountryCode2)),

%% attribute number 3 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,255}}],?RT_PER:cindex(4,Val1,t35Extension)),

%% attribute number 4 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],?RT_PER:cindex(5,Val1,manufacturerCode))].


'dec_H221NonStandard'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,255}}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = ?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,255}}]),

%% attribute number 3 with type INTEGER
{Term3,Bytes4} = ?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,255}}]),

%% attribute number 4 with type INTEGER
{Term4,Bytes5} = ?RT_PER:decode_integer(Bytes4,[{'ValueRange',{0,65535}}]),
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'H221NonStandard',Term1,Term2,Term3,Term4},Bytes7}.


'enc_NonStandardIdentifier'({'NonStandardIdentifier',Val}) ->
'enc_NonStandardIdentifier'(Val);

'enc_NonStandardIdentifier'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[object,h221NonStandard,experimental],[]}, {3,0}),
case element(1,Val) of
object ->
?RT_PER:encode_object_identifier(element(2,Val));
h221NonStandard ->
'enc_H221NonStandard'(element(2,Val));
experimental ->
?RT_PER:encode_IA5String([{'SizeConstraint',8}],element(2,Val))
end
].


'dec_NonStandardIdentifier'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,3,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*3 of
0 -> {object,
?RT_PER:decode_object_identifier(Bytes2)};
1 -> {h221NonStandard,
'dec_H221NonStandard'(Bytes2,telltype)};
2 -> {experimental,
?RT_PER:decode_IA5String(Bytes2,[{'SizeConstraint',8}])};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_NonStandardData'(Val) ->
Val1 = ?RT_PER:list_to_record('NonStandardData', Val),
[

%% attribute number 1 with type Externaltypereference950megaco_per_bin_media_gateway_control_v1NonStandardIdentifier
'enc_NonStandardIdentifier'(?RT_PER:cindex(2,Val1,nonStandardIdentifier)),

%% attribute number 2 with type OCTET STRING
?RT_PER:encode_octet_string([],?RT_PER:cindex(3,Val1,data))].


'dec_NonStandardData'(Bytes,_) ->

%%  attribute number 1 with type NonStandardIdentifier
{Term1,Bytes1} = 'dec_NonStandardIdentifier'(Bytes,telltype),

%% attribute number 2 with type OCTET STRING
{Term2,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[]),
{{'NonStandardData',Term1,Term2},Bytes2}.

'enc_StatisticsParameter'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,statName)),
case ?RT_PER:cindex(3,Val1,statValue) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference945megaco_per_bin_media_gateway_control_v1Value
'enc_Value'(Tmpval1)
end].


'dec_StatisticsParameter'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',4}]),

%%  attribute number 2 with type Value
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_Value'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'StatisticsParameter',Term1,Term2},Bytes3}.


'enc_StatisticsDescriptor'({'StatisticsDescriptor',Val}) ->
'enc_StatisticsDescriptor'(Val);

'enc_StatisticsDescriptor'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_StatisticsDescriptor_components'(Val, [])
].
'enc_StatisticsDescriptor_components'([], Acc) -> lists:reverse(Acc);

'enc_StatisticsDescriptor_components'([H|T], Acc) ->
'enc_StatisticsDescriptor_components'(T, ['enc_StatisticsParameter'(H)

 | Acc]).


'dec_StatisticsDescriptor'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_StatisticsDescriptor_components'(Num, Bytes1, telltype, []).
'dec_StatisticsDescriptor_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_StatisticsDescriptor_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_StatisticsParameter'(Bytes,telltype),
   'dec_StatisticsDescriptor_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_PackagesItem'(Val) ->
Val1 = ?RT_PER:list_to_record('PackagesItem', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',2}],?RT_PER:cindex(2,Val1,packageName)),

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],?RT_PER:cindex(3,Val1,packageVersion))].


'dec_PackagesItem'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',2}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = ?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,99}}]),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'PackagesItem',Term1,Term2},Bytes5}.


'enc_PackagesDescriptor'({'PackagesDescriptor',Val}) ->
'enc_PackagesDescriptor'(Val);

'enc_PackagesDescriptor'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_PackagesDescriptor_components'(Val, [])
].
'enc_PackagesDescriptor_components'([], Acc) -> lists:reverse(Acc);

'enc_PackagesDescriptor_components'([H|T], Acc) ->
'enc_PackagesDescriptor_components'(T, ['enc_PackagesItem'(H)

 | Acc]).


'dec_PackagesDescriptor'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_PackagesDescriptor_components'(Num, Bytes1, telltype, []).
'dec_PackagesDescriptor_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_PackagesDescriptor_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PackagesItem'(Bytes,telltype),
   'dec_PackagesDescriptor_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_ServiceChangeProfile'(Val) ->
Val1 = ?RT_PER:list_to_record('ServiceChangeProfile', Val),
[

%% attribute number 1 with type IA5String
?RT_PER:encode_IA5String([{'SizeConstraint',{1,67}}],?RT_PER:cindex(2,Val1,profileName))].


'dec_ServiceChangeProfile'(Bytes,_) ->

%% attribute number 1 with type IA5String
{Term1,Bytes1} = ?RT_PER:decode_IA5String(Bytes,[{'SizeConstraint',{1,67}}]),
{{'ServiceChangeProfile',Term1},Bytes1}.


'enc_ServiceChangeMethod'({'ServiceChangeMethod',Val}) ->
'enc_ServiceChangeMethod'(Val);

'enc_ServiceChangeMethod'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'failover' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 0)];
'forced' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 1)];
'graceful' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 2)];
'restart' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 3)];
'disconnected' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 4)];
'handOff' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 5)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 5 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_ServiceChangeMethod'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,5}}],{{failover,forced,graceful,restart,disconnected,handOff},{}}).

'enc_ServiceChangeResParm'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4,5,6],5,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,serviceChangeMgcId) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type Externaltypereference900megaco_per_bin_media_gateway_control_v1MId
'enc_MId'(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,serviceChangeAddress) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type Externaltypereference901megaco_per_bin_media_gateway_control_v1ServiceChangeAddress
'enc_ServiceChangeAddress'(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,serviceChangeVersion) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],Tmpval3)
end,
case ?RT_PER:cindex(5,Val1,serviceChangeProfile) of
asn1_NOVALUE -> [];
Tmpval4 ->

%% attribute number 4 with type Externaltypereference903megaco_per_bin_media_gateway_control_v1ServiceChangeProfile
'enc_ServiceChangeProfile'(Tmpval4)
end,
case ?RT_PER:cindex(6,Val1,timeStamp) of
asn1_NOVALUE -> [];
Tmpval5 ->

%% attribute number 5 with type Externaltypereference904megaco_per_bin_media_gateway_control_v1TimeNotation
'enc_TimeNotation'(Tmpval5)
end].


'dec_ServiceChangeResParm'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,5), 
%%  attribute number 1 with type MId
{Term1,Bytes3} = case Opt band (1 bsl 4) of
_Opt1 when _Opt1 > 0 ->'dec_MId'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 2 with type ServiceChangeAddress
{Term2,Bytes4} = case Opt band (1 bsl 3) of
_Opt2 when _Opt2 > 0 ->'dec_ServiceChangeAddress'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case Opt band (1 bsl 2) of
_Opt3 when _Opt3 > 0 ->?RT_PER:decode_integer(Bytes4,[{'ValueRange',{0,99}}]);
0 ->{asn1_NOVALUE,Bytes4}

end,

%%  attribute number 4 with type ServiceChangeProfile
{Term4,Bytes6} = case Opt band (1 bsl 1) of
_Opt4 when _Opt4 > 0 ->'dec_ServiceChangeProfile'(Bytes5,telltype);
0 ->{asn1_NOVALUE,Bytes5}

end,

%%  attribute number 5 with type TimeNotation
{Term5,Bytes7} = case Opt band (1 bsl 0) of
_Opt5 when _Opt5 > 0 ->'dec_TimeNotation'(Bytes6,telltype);
0 ->{asn1_NOVALUE,Bytes6}

end,
{Extensions,Bytes8} = ?RT_PER:getextension(Ext,Bytes7),
Bytes9= ?RT_PER:skipextensions(Bytes8,1,Extensions)
,
{{'ServiceChangeResParm',Term1,Term2,Term3,Term4,Term5},Bytes9}.


'enc_ServiceChangeAddress'({'ServiceChangeAddress',Val}) ->
'enc_ServiceChangeAddress'(Val);

'enc_ServiceChangeAddress'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[portNumber,ip4Address,ip6Address,domainName,deviceName,mtpAddress],[]}, {6,0}),
case element(1,Val) of
portNumber ->
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],element(2,Val));
ip4Address ->
'enc_IP4Address'(element(2,Val));
ip6Address ->
'enc_IP6Address'(element(2,Val));
domainName ->
'enc_DomainName'(element(2,Val));
deviceName ->
?RT_PER:encode_IA5String([{'SizeConstraint',{1,64}}],element(2,Val));
mtpAddress ->
?RT_PER:encode_octet_string([{'SizeConstraint',{2,4}}],element(2,Val))
end
].


'dec_ServiceChangeAddress'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,6,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*6 of
0 -> {portNumber,
?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,65535}}])};
1 -> {ip4Address,
'dec_IP4Address'(Bytes2,telltype)};
2 -> {ip6Address,
'dec_IP6Address'(Bytes2,telltype)};
3 -> {domainName,
'dec_DomainName'(Bytes2,telltype)};
4 -> {deviceName,
?RT_PER:decode_IA5String(Bytes2,[{'SizeConstraint',{1,64}}])};
5 -> {mtpAddress,
?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',{2,4}}])};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_ServiceChangeParm'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4,5,7,8,9,10],7,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type ENUMERATED
case (case ?RT_PER:cindex(2,Val1,serviceChangeMethod) of {_,_}->element(2,?RT_PER:cindex(2,Val1,serviceChangeMethod));_->?RT_PER:cindex(2,Val1,serviceChangeMethod) end) of
'failover' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 0)];
'forced' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 1)];
'graceful' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 2)];
'restart' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 3)];
'disconnected' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 4)];
'handOff' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,5}}], 5)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 5 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end,
case ?RT_PER:cindex(3,Val1,serviceChangeAddress) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference875megaco_per_bin_media_gateway_control_v1ServiceChangeAddress
'enc_ServiceChangeAddress'(Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,serviceChangeVersion) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],Tmpval2)
end,
case ?RT_PER:cindex(5,Val1,serviceChangeProfile) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 4 with type Externaltypereference877megaco_per_bin_media_gateway_control_v1ServiceChangeProfile
'enc_ServiceChangeProfile'(Tmpval3)
end,

%% attribute number 5 with type Externaltypereference878megaco_per_bin_media_gateway_control_v1Value
'enc_Value'(?RT_PER:cindex(6,Val1,serviceChangeReason)),
case ?RT_PER:cindex(7,Val1,serviceChangeDelay) of
asn1_NOVALUE -> [];
Tmpval4 ->

%% attribute number 6 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],Tmpval4)
end,
case ?RT_PER:cindex(8,Val1,serviceChangeMgcId) of
asn1_NOVALUE -> [];
Tmpval5 ->

%% attribute number 7 with type Externaltypereference881megaco_per_bin_media_gateway_control_v1MId
'enc_MId'(Tmpval5)
end,
case ?RT_PER:cindex(9,Val1,timeStamp) of
asn1_NOVALUE -> [];
Tmpval6 ->

%% attribute number 8 with type Externaltypereference882megaco_per_bin_media_gateway_control_v1TimeNotation
'enc_TimeNotation'(Tmpval6)
end,
case ?RT_PER:cindex(10,Val1,nonStandardData) of
asn1_NOVALUE -> [];
Tmpval7 ->

%% attribute number 9 with type Externaltypereference883megaco_per_bin_media_gateway_control_v1NonStandardData
'enc_NonStandardData'(Tmpval7)
end].


'dec_ServiceChangeParm'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,7), 
%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = ?RT_PER:decode_enumerated(Bytes2,[{'ValueRange',{0,5}}],{{failover,forced,graceful,restart,disconnected,handOff},{}}),

%%  attribute number 2 with type ServiceChangeAddress
{Term2,Bytes4} = case Opt band (1 bsl 6) of
_Opt1 when _Opt1 > 0 ->'dec_ServiceChangeAddress'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case Opt band (1 bsl 5) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_integer(Bytes4,[{'ValueRange',{0,99}}]);
0 ->{asn1_NOVALUE,Bytes4}

end,

%%  attribute number 4 with type ServiceChangeProfile
{Term4,Bytes6} = case Opt band (1 bsl 4) of
_Opt3 when _Opt3 > 0 ->'dec_ServiceChangeProfile'(Bytes5,telltype);
0 ->{asn1_NOVALUE,Bytes5}

end,

%%  attribute number 5 with type Value
{Term5,Bytes7} = 'dec_Value'(Bytes6,telltype),

%% attribute number 6 with type INTEGER
{Term6,Bytes8} = case Opt band (1 bsl 3) of
_Opt4 when _Opt4 > 0 ->?RT_PER:decode_integer(Bytes7,[{'ValueRange',{0,4294967295}}]);
0 ->{asn1_NOVALUE,Bytes7}

end,

%%  attribute number 7 with type MId
{Term7,Bytes9} = case Opt band (1 bsl 2) of
_Opt5 when _Opt5 > 0 ->'dec_MId'(Bytes8,telltype);
0 ->{asn1_NOVALUE,Bytes8}

end,

%%  attribute number 8 with type TimeNotation
{Term8,Bytes10} = case Opt band (1 bsl 1) of
_Opt6 when _Opt6 > 0 ->'dec_TimeNotation'(Bytes9,telltype);
0 ->{asn1_NOVALUE,Bytes9}

end,

%%  attribute number 9 with type NonStandardData
{Term9,Bytes11} = case Opt band (1 bsl 0) of
_Opt7 when _Opt7 > 0 ->'dec_NonStandardData'(Bytes10,telltype);
0 ->{asn1_NOVALUE,Bytes10}

end,
{Extensions,Bytes12} = ?RT_PER:getextension(Ext,Bytes11),
Bytes13= ?RT_PER:skipextensions(Bytes12,1,Extensions)
,
{{'ServiceChangeParm',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},Bytes13}.

'enc_DigitMapValue'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,startTimer) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,shortTimer) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,longTimer) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],Tmpval3)
end,

%% attribute number 4 with type IA5String
?RT_PER:encode_IA5String([],?RT_PER:cindex(5,Val1,digitMapBody))].


'dec_DigitMapValue'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,99}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,99}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->?RT_PER:decode_integer(Bytes4,[{'ValueRange',{0,99}}]);
0 ->{asn1_NOVALUE,Bytes4}

end,

%% attribute number 4 with type IA5String
{Term4,Bytes6} = ?RT_PER:decode_IA5String(Bytes5,[]),
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'DigitMapValue',Term1,Term2,Term3,Term4},Bytes8}.


'enc_DigitMapName'({'DigitMapName',Val}) ->
'enc_DigitMapName'(Val);

'enc_DigitMapName'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',2}],Val).


'dec_DigitMapName'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',2}]).

'enc_DigitMapDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3],2,Val),
[
Opt,
case ?RT_PER:cindex(2,Val1,digitMapName) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',2}],Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,digitMapValue) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type Externaltypereference857megaco_per_bin_media_gateway_control_v1DigitMapValue
'enc_DigitMapValue'(Tmpval2)
end].


'dec_DigitMapDescriptor'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,2), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',2}]);
0 ->{asn1_NOVALUE,Bytes1}

end,

%%  attribute number 2 with type DigitMapValue
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_DigitMapValue'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'DigitMapDescriptor',Term1,Term2},Bytes3}.


'enc_ModemType'({'ModemType',Val}) ->
'enc_ModemType'(Val);

'enc_ModemType'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'v18' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 0)];
'v22' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 1)];
'v22bis' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 2)];
'v32' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 3)];
'v32bis' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 4)];
'v34' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 5)];
'v90' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 6)];
'v91' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 7)];
'synchISDN' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 8)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 8 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_ModemType'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,8}}],{{v18,v22,v22bis,v32,v32bis,v34,v90,v91,synchISDN},{}}).

'enc_ModemDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
Opt,

%% attribute number 1 with type SEQUENCE OF
'enc_ModemDescriptor_mtl'(?RT_PER:cindex(2,Val1,mtl)),

%% attribute number 2 with type SEQUENCE OF
'enc_ModemDescriptor_mpl'(?RT_PER:cindex(3,Val1,mpl)),
case ?RT_PER:cindex(4,Val1,nonStandardData) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type Externaltypereference837megaco_per_bin_media_gateway_control_v1NonStandardData
'enc_NonStandardData'(Tmpval1)
end].

'enc_ModemDescriptor_mtl'({'ModemDescriptor_mtl',Val}) ->
'enc_ModemDescriptor_mtl'(Val);

'enc_ModemDescriptor_mtl'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ModemDescriptor_mtl_components'(Val, [])
].
'enc_ModemDescriptor_mtl_components'([], Acc) -> lists:reverse(Acc);

'enc_ModemDescriptor_mtl_components'([H|T], Acc) ->
'enc_ModemDescriptor_mtl_components'(T, [case (case H of {_,_}->element(2,H);_->H end) of
'v18' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 0)];
'v22' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 1)];
'v22bis' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 2)];
'v32' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 3)];
'v32bis' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 4)];
'v34' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 5)];
'v90' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 6)];
'v91' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 7)];
'synchISDN' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,8}}], 8)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 8 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end | Acc]).

'dec_ModemDescriptor_mtl'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ModemDescriptor_mtl_components'(Num, Bytes1, telltype, []).
'dec_ModemDescriptor_mtl_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ModemDescriptor_mtl_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = ?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,8}}],{{v18,v22,v22bis,v32,v32bis,v34,v90,v91,synchISDN},{}}),
   'dec_ModemDescriptor_mtl_components'(Num-1, Remain, telltype, [Term|Acc]).

'enc_ModemDescriptor_mpl'({'ModemDescriptor_mpl',Val}) ->
'enc_ModemDescriptor_mpl'(Val);

'enc_ModemDescriptor_mpl'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ModemDescriptor_mpl_components'(Val, [])
].
'enc_ModemDescriptor_mpl_components'([], Acc) -> lists:reverse(Acc);

'enc_ModemDescriptor_mpl_components'([H|T], Acc) ->
'enc_ModemDescriptor_mpl_components'(T, ['enc_PropertyParm'(H)

 | Acc]).

'dec_ModemDescriptor_mpl'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ModemDescriptor_mpl_components'(Num, Bytes1, telltype, []).
'dec_ModemDescriptor_mpl_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ModemDescriptor_mpl_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PropertyParm'(Bytes,telltype),
   'dec_ModemDescriptor_mpl_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ModemDescriptor'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_ModemDescriptor_mtl'(Bytes1, telltype),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_ModemDescriptor_mpl'(Bytes2, telltype),

%%  attribute number 3 with type NonStandardData
{Term3,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_NonStandardData'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,
{{'ModemDescriptor',Term1,Term2,Term3},Bytes4}.


'enc_RequestID'({'RequestID',Val}) ->
'enc_RequestID'(Val);

'enc_RequestID'(Val) ->
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],Val).


'dec_RequestID'(Bytes,_) ->
?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,4294967295}}]).

'enc_SigParameter'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',2}],?RT_PER:cindex(2,Val1,sigParameterName)),

%% attribute number 2 with type Externaltypereference819megaco_per_bin_media_gateway_control_v1Value
'enc_Value'(?RT_PER:cindex(3,Val1,value)),
case ?RT_PER:cindex(4,Val1,extraInfo) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type CHOICE
'enc_SigParameter_extraInfo'(Tmpval1)
end].

'enc_SigParameter_extraInfo'({'SigParameter_extraInfo',Val}) ->
'enc_SigParameter_extraInfo'(Val);

'enc_SigParameter_extraInfo'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[relation,range,sublist], 3),
case element(1,Val) of
relation ->
case (case element(2,Val) of {_,_}->element(2,element(2,Val));_->element(2,Val) end) of
'greaterThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'smallerThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'unequalTo' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end;
range ->
?RT_PER:encode_boolean(element(2,Val));
sublist ->
?RT_PER:encode_boolean(element(2,Val))
end
].

'dec_SigParameter_extraInfo'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,3, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {relation,
?RT_PER:decode_enumerated(Bytes1,[{'ValueRange',{0,2}}],{{greaterThan,smallerThan,unequalTo},{}})};
1 -> {range,
?RT_PER:decode_boolean(Bytes1)};
2 -> {sublist,
?RT_PER:decode_boolean(Bytes1)}
end,

{{Cname,Val},NewBytes}.


'dec_SigParameter'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',2}]),

%%  attribute number 2 with type Value
{Term2,Bytes4} = 'dec_Value'(Bytes3,telltype),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_SigParameter_extraInfo'(Bytes4, telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'SigParameter',Term1,Term2,Term3},Bytes7}.


'enc_NotifyCompletion'({'NotifyCompletion',Val}) ->
'enc_NotifyCompletion'(Val);

'enc_NotifyCompletion'(Val) ->
?RT_PER:encode_bit_string([],Val,[{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]).


'dec_NotifyCompletion'(Bytes,_) ->
?RT_PER:decode_bit_string(Bytes,[],[{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]).


'enc_SignalName'({'SignalName',Val}) ->
'enc_SignalName'(Val);

'enc_SignalName'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',4}],Val).


'dec_SignalName'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]).


'enc_SignalType'({'SignalType',Val}) ->
'enc_SignalType'(Val);

'enc_SignalType'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'brief' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'onOff' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'timeOut' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_SignalType'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,2}}],{{brief,onOff,timeOut},{}}).

'enc_Signal'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4,5,6,7],5,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,signalName)),
case ?RT_PER:cindex(3,Val1,streamID) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,sigType) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type ENUMERATED
case (case Tmpval2 of {_,_}->element(2,Tmpval2);_->Tmpval2 end) of
'brief' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'onOff' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'timeOut' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end
end,
case ?RT_PER:cindex(5,Val1,duration) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 4 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval3)
end,
case ?RT_PER:cindex(6,Val1,notifyCompletion) of
asn1_NOVALUE -> [];
Tmpval4 ->

%% attribute number 5 with type BIT STRING
?RT_PER:encode_bit_string([],Tmpval4,[{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}])
end,
case ?RT_PER:cindex(7,Val1,keepActive) of
asn1_NOVALUE -> [];
Tmpval5 ->

%% attribute number 6 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval5)
end,

%% attribute number 7 with type SEQUENCE OF
'enc_Signal_sigParList'(?RT_PER:cindex(8,Val1,sigParList))].

'enc_Signal_sigParList'({'Signal_sigParList',Val}) ->
'enc_Signal_sigParList'(Val);

'enc_Signal_sigParList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_Signal_sigParList_components'(Val, [])
].
'enc_Signal_sigParList_components'([], Acc) -> lists:reverse(Acc);

'enc_Signal_sigParList_components'([H|T], Acc) ->
'enc_Signal_sigParList_components'(T, ['enc_SigParameter'(H)

 | Acc]).

'dec_Signal_sigParList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_Signal_sigParList_components'(Num, Bytes1, telltype, []).
'dec_Signal_sigParList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_Signal_sigParList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_SigParameter'(Bytes,telltype),
   'dec_Signal_sigParList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_Signal'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,5), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 4) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type ENUMERATED
{Term3,Bytes5} = case Opt band (1 bsl 3) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_enumerated(Bytes4,[{'ValueRange',{0,2}}],{{brief,onOff,timeOut},{}});
0 ->{asn1_NOVALUE,Bytes4}

end,

%% attribute number 4 with type INTEGER
{Term4,Bytes6} = case Opt band (1 bsl 2) of
_Opt3 when _Opt3 > 0 ->?RT_PER:decode_integer(Bytes5,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes5}

end,

%% attribute number 5 with type BIT STRING
{Term5,Bytes7} = case Opt band (1 bsl 1) of
_Opt4 when _Opt4 > 0 ->?RT_PER:decode_bit_string(Bytes6,[],[{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]);
0 ->{asn1_NOVALUE,Bytes6}

end,

%% attribute number 6 with type BOOLEAN
{Term6,Bytes8} = case Opt band (1 bsl 0) of
_Opt5 when _Opt5 > 0 ->?RT_PER:decode_boolean(Bytes7);
0 ->{asn1_NOVALUE,Bytes7}

end,

%% attribute number 7 with type SEQUENCE OF
{Term7,Bytes9} = 'dec_Signal_sigParList'(Bytes8, telltype),
{Extensions,Bytes10} = ?RT_PER:getextension(Ext,Bytes9),
Bytes11= ?RT_PER:skipextensions(Bytes10,1,Extensions)
,
{{'Signal',Term1,Term2,Term3,Term4,Term5,Term6,Term7},Bytes11}.

'enc_SeqSigList'(Val) ->
Val1 = ?RT_PER:list_to_record('SeqSigList', Val),
[

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],?RT_PER:cindex(2,Val1,id)),

%% attribute number 2 with type SEQUENCE OF
'enc_SeqSigList_signalList'(?RT_PER:cindex(3,Val1,signalList))].

'enc_SeqSigList_signalList'({'SeqSigList_signalList',Val}) ->
'enc_SeqSigList_signalList'(Val);

'enc_SeqSigList_signalList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_SeqSigList_signalList_components'(Val, [])
].
'enc_SeqSigList_signalList_components'([], Acc) -> lists:reverse(Acc);

'enc_SeqSigList_signalList_components'([H|T], Acc) ->
'enc_SeqSigList_signalList_components'(T, ['enc_Signal'(H)

 | Acc]).

'dec_SeqSigList_signalList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_SeqSigList_signalList_components'(Num, Bytes1, telltype, []).
'dec_SeqSigList_signalList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_SeqSigList_signalList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_Signal'(Bytes,telltype),
   'dec_SeqSigList_signalList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_SeqSigList'(Bytes,_) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = ?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,65535}}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes2} = 'dec_SeqSigList_signalList'(Bytes1, telltype),
{{'SeqSigList',Term1,Term2},Bytes2}.


'enc_SignalRequest'({'SignalRequest',Val}) ->
'enc_SignalRequest'(Val);

'enc_SignalRequest'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[signal,seqSigList],[]}, {2,0}),
case element(1,Val) of
signal ->
'enc_Signal'(element(2,Val));
seqSigList ->
'enc_SeqSigList'(element(2,Val))
end
].


'dec_SignalRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,2,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*2 of
0 -> {signal,
'dec_Signal'(Bytes2,telltype)};
1 -> {seqSigList,
'dec_SeqSigList'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.

'enc_SignalsDescriptor'({'SignalsDescriptor',Val}) ->
'enc_SignalsDescriptor'(Val);

'enc_SignalsDescriptor'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_SignalsDescriptor_components'(Val, [])
].
'enc_SignalsDescriptor_components'([], Acc) -> lists:reverse(Acc);

'enc_SignalsDescriptor_components'([H|T], Acc) ->
'enc_SignalsDescriptor_components'(T, ['enc_SignalRequest'(H)

 | Acc]).


'dec_SignalsDescriptor'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_SignalsDescriptor_components'(Num, Bytes1, telltype, []).
'dec_SignalsDescriptor_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_SignalsDescriptor_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_SignalRequest'(Bytes,telltype),
   'dec_SignalsDescriptor_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_EventSpec'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,eventName)),
case ?RT_PER:cindex(3,Val1,streamID) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end,

%% attribute number 3 with type SEQUENCE OF
'enc_EventSpec_eventParList'(?RT_PER:cindex(4,Val1,eventParList))].

'enc_EventSpec_eventParList'({'EventSpec_eventParList',Val}) ->
'enc_EventSpec_eventParList'(Val);

'enc_EventSpec_eventParList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_EventSpec_eventParList_components'(Val, [])
].
'enc_EventSpec_eventParList_components'([], Acc) -> lists:reverse(Acc);

'enc_EventSpec_eventParList_components'([H|T], Acc) ->
'enc_EventSpec_eventParList_components'(T, ['enc_EventParameter'(H)

 | Acc]).

'dec_EventSpec_eventParList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_EventSpec_eventParList_components'(Num, Bytes1, telltype, []).
'dec_EventSpec_eventParList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_EventSpec_eventParList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_EventParameter'(Bytes,telltype),
   'dec_EventSpec_eventParList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_EventSpec'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = 'dec_EventSpec_eventParList'(Bytes4, telltype),
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'EventSpec',Term1,Term2,Term3},Bytes7}.


'enc_EventBufferDescriptor'({'EventBufferDescriptor',Val}) ->
'enc_EventBufferDescriptor'(Val);

'enc_EventBufferDescriptor'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_EventBufferDescriptor_components'(Val, [])
].
'enc_EventBufferDescriptor_components'([], Acc) -> lists:reverse(Acc);

'enc_EventBufferDescriptor_components'([H|T], Acc) ->
'enc_EventBufferDescriptor_components'(T, ['enc_EventSpec'(H)

 | Acc]).


'dec_EventBufferDescriptor'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_EventBufferDescriptor_components'(Num, Bytes1, telltype, []).
'dec_EventBufferDescriptor_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_EventBufferDescriptor_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_EventSpec'(Bytes,telltype),
   'dec_EventBufferDescriptor_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_SecondRequestedActions'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,keepActive) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,eventDM) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type Externaltypereference756megaco_per_bin_media_gateway_control_v1EventDM
'enc_EventDM'(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,signalsDescriptor) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type Externaltypereference757megaco_per_bin_media_gateway_control_v1SignalsDescriptor
'enc_SignalsDescriptor'(Tmpval3)
end].


'dec_SecondRequestedActions'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%% attribute number 1 with type BOOLEAN
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_boolean(Bytes2);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 2 with type EventDM
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->'dec_EventDM'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%%  attribute number 3 with type SignalsDescriptor
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->'dec_SignalsDescriptor'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'SecondRequestedActions',Term1,Term2,Term3},Bytes7}.

'enc_SecondRequestedEvent'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,pkgdName)),
case ?RT_PER:cindex(3,Val1,streamID) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,eventAction) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type Externaltypereference748megaco_per_bin_media_gateway_control_v1SecondRequestedActions
'enc_SecondRequestedActions'(Tmpval2)
end,

%% attribute number 4 with type SEQUENCE OF
'enc_SecondRequestedEvent_evParList'(?RT_PER:cindex(5,Val1,evParList))].

'enc_SecondRequestedEvent_evParList'({'SecondRequestedEvent_evParList',Val}) ->
'enc_SecondRequestedEvent_evParList'(Val);

'enc_SecondRequestedEvent_evParList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_SecondRequestedEvent_evParList_components'(Val, [])
].
'enc_SecondRequestedEvent_evParList_components'([], Acc) -> lists:reverse(Acc);

'enc_SecondRequestedEvent_evParList_components'([H|T], Acc) ->
'enc_SecondRequestedEvent_evParList_components'(T, ['enc_EventParameter'(H)

 | Acc]).

'dec_SecondRequestedEvent_evParList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_SecondRequestedEvent_evParList_components'(Num, Bytes1, telltype, []).
'dec_SecondRequestedEvent_evParList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_SecondRequestedEvent_evParList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_EventParameter'(Bytes,telltype),
   'dec_SecondRequestedEvent_evParList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_SecondRequestedEvent'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%%  attribute number 3 with type SecondRequestedActions
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_SecondRequestedActions'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_SecondRequestedEvent_evParList'(Bytes5, telltype),
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'SecondRequestedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_SecondEventsDescriptor'(Val) ->
Val1 = ?RT_PER:list_to_record('SecondEventsDescriptor', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,requestID)),

%% attribute number 2 with type SEQUENCE OF
'enc_SecondEventsDescriptor_eventList'(?RT_PER:cindex(3,Val1,eventList))].

'enc_SecondEventsDescriptor_eventList'({'SecondEventsDescriptor_eventList',Val}) ->
'enc_SecondEventsDescriptor_eventList'(Val);

'enc_SecondEventsDescriptor_eventList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_SecondEventsDescriptor_eventList_components'(Val, [])
].
'enc_SecondEventsDescriptor_eventList_components'([], Acc) -> lists:reverse(Acc);

'enc_SecondEventsDescriptor_eventList_components'([H|T], Acc) ->
'enc_SecondEventsDescriptor_eventList_components'(T, ['enc_SecondRequestedEvent'(H)

 | Acc]).

'dec_SecondEventsDescriptor_eventList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_SecondEventsDescriptor_eventList_components'(Num, Bytes1, telltype, []).
'dec_SecondEventsDescriptor_eventList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_SecondEventsDescriptor_eventList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_SecondRequestedEvent'(Bytes,telltype),
   'dec_SecondEventsDescriptor_eventList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_SecondEventsDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_SecondEventsDescriptor_eventList'(Bytes2, telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'SecondEventsDescriptor',Term1,Term2},Bytes5}.


'enc_EventDM'({'EventDM',Val}) ->
'enc_EventDM'(Val);

'enc_EventDM'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[digitMapName,digitMapValue], 2),
case element(1,Val) of
digitMapName ->
?RT_PER:encode_octet_string([{'SizeConstraint',2}],element(2,Val));
digitMapValue ->
'enc_DigitMapValue'(element(2,Val))
end
].


'dec_EventDM'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,2, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {digitMapName,
?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',2}])};
1 -> {digitMapValue,
'dec_DigitMapValue'(Bytes1,telltype)}
end,

{{Cname,Val},NewBytes}.
'enc_RequestedActions'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4,5],4,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,keepActive) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,eventDM) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type Externaltypereference721megaco_per_bin_media_gateway_control_v1EventDM
'enc_EventDM'(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,secondEvent) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type Externaltypereference722megaco_per_bin_media_gateway_control_v1SecondEventsDescriptor
'enc_SecondEventsDescriptor'(Tmpval3)
end,
case ?RT_PER:cindex(5,Val1,signalsDescriptor) of
asn1_NOVALUE -> [];
Tmpval4 ->

%% attribute number 4 with type Externaltypereference723megaco_per_bin_media_gateway_control_v1SignalsDescriptor
'enc_SignalsDescriptor'(Tmpval4)
end].


'dec_RequestedActions'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,4), 
%% attribute number 1 with type BOOLEAN
{Term1,Bytes3} = case Opt band (1 bsl 3) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_boolean(Bytes2);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 2 with type EventDM
{Term2,Bytes4} = case Opt band (1 bsl 2) of
_Opt2 when _Opt2 > 0 ->'dec_EventDM'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%%  attribute number 3 with type SecondEventsDescriptor
{Term3,Bytes5} = case Opt band (1 bsl 1) of
_Opt3 when _Opt3 > 0 ->'dec_SecondEventsDescriptor'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,

%%  attribute number 4 with type SignalsDescriptor
{Term4,Bytes6} = case Opt band (1 bsl 0) of
_Opt4 when _Opt4 > 0 ->'dec_SignalsDescriptor'(Bytes5,telltype);
0 ->{asn1_NOVALUE,Bytes5}

end,
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'RequestedActions',Term1,Term2,Term3,Term4},Bytes8}.

'enc_RequestedEvent'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,pkgdName)),
case ?RT_PER:cindex(3,Val1,streamID) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,eventAction) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type Externaltypereference713megaco_per_bin_media_gateway_control_v1RequestedActions
'enc_RequestedActions'(Tmpval2)
end,

%% attribute number 4 with type SEQUENCE OF
'enc_RequestedEvent_evParList'(?RT_PER:cindex(5,Val1,evParList))].

'enc_RequestedEvent_evParList'({'RequestedEvent_evParList',Val}) ->
'enc_RequestedEvent_evParList'(Val);

'enc_RequestedEvent_evParList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_RequestedEvent_evParList_components'(Val, [])
].
'enc_RequestedEvent_evParList_components'([], Acc) -> lists:reverse(Acc);

'enc_RequestedEvent_evParList_components'([H|T], Acc) ->
'enc_RequestedEvent_evParList_components'(T, ['enc_EventParameter'(H)

 | Acc]).

'dec_RequestedEvent_evParList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_RequestedEvent_evParList_components'(Num, Bytes1, telltype, []).
'dec_RequestedEvent_evParList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_RequestedEvent_evParList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_EventParameter'(Bytes,telltype),
   'dec_RequestedEvent_evParList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_RequestedEvent'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%%  attribute number 3 with type RequestedActions
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_RequestedActions'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_RequestedEvent_evParList'(Bytes5, telltype),
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'RequestedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_EventsDescriptor'(Val) ->
Val1 = ?RT_PER:list_to_record('EventsDescriptor', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,requestID)),

%% attribute number 2 with type SEQUENCE OF
'enc_EventsDescriptor_eventList'(?RT_PER:cindex(3,Val1,eventList))].

'enc_EventsDescriptor_eventList'({'EventsDescriptor_eventList',Val}) ->
'enc_EventsDescriptor_eventList'(Val);

'enc_EventsDescriptor_eventList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_EventsDescriptor_eventList_components'(Val, [])
].
'enc_EventsDescriptor_eventList_components'([], Acc) -> lists:reverse(Acc);

'enc_EventsDescriptor_eventList_components'([H|T], Acc) ->
'enc_EventsDescriptor_eventList_components'(T, ['enc_RequestedEvent'(H)

 | Acc]).

'dec_EventsDescriptor_eventList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_EventsDescriptor_eventList_components'(Num, Bytes1, telltype, []).
'dec_EventsDescriptor_eventList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_EventsDescriptor_eventList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_RequestedEvent'(Bytes,telltype),
   'dec_EventsDescriptor_eventList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_EventsDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_EventsDescriptor_eventList'(Bytes2, telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'EventsDescriptor',Term1,Term2},Bytes5}.


'enc_StreamID'({'StreamID',Val}) ->
'enc_StreamID'(Val);

'enc_StreamID'(Val) ->
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Val).


'dec_StreamID'(Bytes,_) ->
?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,65535}}]).


'enc_MuxType'({'MuxType',Val}) ->
'enc_MuxType'(Val);

'enc_MuxType'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'h221' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 0)];
'h223' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 1)];
'h226' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 2)];
'v76' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 3)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 3 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_MuxType'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,3}}],{{h221,h223,h226,v76},{}}).

'enc_MuxDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type ENUMERATED
case (case ?RT_PER:cindex(2,Val1,muxType) of {_,_}->element(2,?RT_PER:cindex(2,Val1,muxType));_->?RT_PER:cindex(2,Val1,muxType) end) of
'h221' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 0)];
'h223' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 1)];
'h226' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 2)];
'v76' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,3}}], 3)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 3 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end,

%% attribute number 2 with type SEQUENCE OF
'enc_MuxDescriptor_termList'(?RT_PER:cindex(3,Val1,termList)),
case ?RT_PER:cindex(4,Val1,nonStandardData) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type Externaltypereference684megaco_per_bin_media_gateway_control_v1NonStandardData
'enc_NonStandardData'(Tmpval1)
end].

'enc_MuxDescriptor_termList'({'MuxDescriptor_termList',Val}) ->
'enc_MuxDescriptor_termList'(Val);

'enc_MuxDescriptor_termList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_MuxDescriptor_termList_components'(Val, [])
].
'enc_MuxDescriptor_termList_components'([], Acc) -> lists:reverse(Acc);

'enc_MuxDescriptor_termList_components'([H|T], Acc) ->
'enc_MuxDescriptor_termList_components'(T, ['enc_TerminationID'(H)

 | Acc]).

'dec_MuxDescriptor_termList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_MuxDescriptor_termList_components'(Num, Bytes1, telltype, []).
'dec_MuxDescriptor_termList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_MuxDescriptor_termList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_TerminationID'(Bytes,telltype),
   'dec_MuxDescriptor_termList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_MuxDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = ?RT_PER:decode_enumerated(Bytes2,[{'ValueRange',{0,3}}],{{h221,h223,h226,v76},{}}),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_MuxDescriptor_termList'(Bytes3, telltype),

%%  attribute number 3 with type NonStandardData
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_NonStandardData'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'MuxDescriptor',Term1,Term2,Term3},Bytes7}.


'enc_ServiceState'({'ServiceState',Val}) ->
'enc_ServiceState'(Val);

'enc_ServiceState'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'test' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'outOfSvc' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'inSvc' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_ServiceState'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,2}}],{{test,outOfSvc,inSvc},{}}).


'enc_EventBufferControl'({'EventBufferControl',Val}) ->
'enc_EventBufferControl'(Val);

'enc_EventBufferControl'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'off' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,1}}], 0)];
'lockStep' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,1}}], 1)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 1 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_EventBufferControl'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,1}}],{{off,lockStep},{}}).

'enc_TerminationStateDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type SEQUENCE OF
'enc_TerminationStateDescriptor_propertyParms'(?RT_PER:cindex(2,Val1,propertyParms)),
case ?RT_PER:cindex(3,Val1,eventBufferControl) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type ENUMERATED
case (case Tmpval1 of {_,_}->element(2,Tmpval1);_->Tmpval1 end) of
'off' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,1}}], 0)];
'lockStep' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,1}}], 1)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 1 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end
end,
case ?RT_PER:cindex(4,Val1,serviceState) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type ENUMERATED
case (case Tmpval2 of {_,_}->element(2,Tmpval2);_->Tmpval2 end) of
'test' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'outOfSvc' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'inSvc' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end
end].

'enc_TerminationStateDescriptor_propertyParms'({'TerminationStateDescriptor_propertyParms',Val}) ->
'enc_TerminationStateDescriptor_propertyParms'(Val);

'enc_TerminationStateDescriptor_propertyParms'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TerminationStateDescriptor_propertyParms_components'(Val, [])
].
'enc_TerminationStateDescriptor_propertyParms_components'([], Acc) -> lists:reverse(Acc);

'enc_TerminationStateDescriptor_propertyParms_components'([H|T], Acc) ->
'enc_TerminationStateDescriptor_propertyParms_components'(T, ['enc_PropertyParm'(H)

 | Acc]).

'dec_TerminationStateDescriptor_propertyParms'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TerminationStateDescriptor_propertyParms_components'(Num, Bytes1, telltype, []).
'dec_TerminationStateDescriptor_propertyParms_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TerminationStateDescriptor_propertyParms_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PropertyParm'(Bytes,telltype),
   'dec_TerminationStateDescriptor_propertyParms_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_TerminationStateDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes3} = 'dec_TerminationStateDescriptor_propertyParms'(Bytes2, telltype),

%% attribute number 2 with type ENUMERATED
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_enumerated(Bytes3,[{'ValueRange',{0,1}}],{{off,lockStep},{}});
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type ENUMERATED
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_enumerated(Bytes4,[{'ValueRange',{0,2}}],{{test,outOfSvc,inSvc},{}});
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'TerminationStateDescriptor',Term1,Term2,Term3},Bytes7}.


'enc_PropertyGroup'({'PropertyGroup',Val}) ->
'enc_PropertyGroup'(Val);

'enc_PropertyGroup'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_PropertyGroup_components'(Val, [])
].
'enc_PropertyGroup_components'([], Acc) -> lists:reverse(Acc);

'enc_PropertyGroup_components'([H|T], Acc) ->
'enc_PropertyGroup_components'(T, ['enc_PropertyParm'(H)

 | Acc]).


'dec_PropertyGroup'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_PropertyGroup_components'(Num, Bytes1, telltype, []).
'dec_PropertyGroup_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_PropertyGroup_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PropertyParm'(Bytes,telltype),
   'dec_PropertyGroup_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_LocalRemoteDescriptor'(Val) ->
Val1 = ?RT_PER:list_to_record('LocalRemoteDescriptor', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type SEQUENCE OF
'enc_LocalRemoteDescriptor_propGrps'(?RT_PER:cindex(2,Val1,propGrps))].

'enc_LocalRemoteDescriptor_propGrps'({'LocalRemoteDescriptor_propGrps',Val}) ->
'enc_LocalRemoteDescriptor_propGrps'(Val);

'enc_LocalRemoteDescriptor_propGrps'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_LocalRemoteDescriptor_propGrps_components'(Val, [])
].
'enc_LocalRemoteDescriptor_propGrps_components'([], Acc) -> lists:reverse(Acc);

'enc_LocalRemoteDescriptor_propGrps_components'([H|T], Acc) ->
'enc_LocalRemoteDescriptor_propGrps_components'(T, ['enc_PropertyGroup'(H)

 | Acc]).

'dec_LocalRemoteDescriptor_propGrps'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_LocalRemoteDescriptor_propGrps_components'(Num, Bytes1, telltype, []).
'dec_LocalRemoteDescriptor_propGrps_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_LocalRemoteDescriptor_propGrps_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PropertyGroup'(Bytes,telltype),
   'dec_LocalRemoteDescriptor_propGrps_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_LocalRemoteDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_LocalRemoteDescriptor_propGrps'(Bytes1, telltype),
{Extensions,Bytes3} = ?RT_PER:getextension(Ext,Bytes2),
Bytes4= ?RT_PER:skipextensions(Bytes3,1,Extensions)
,
{{'LocalRemoteDescriptor',Term1},Bytes4}.


'enc_Relation'({'Relation',Val}) ->
'enc_Relation'(Val);

'enc_Relation'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'greaterThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'smallerThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'unequalTo' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_Relation'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,2}}],{{greaterThan,smallerThan,unequalTo},{}}).


'enc_PkgdName'({'PkgdName',Val}) ->
'enc_PkgdName'(Val);

'enc_PkgdName'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',4}],Val).


'dec_PkgdName'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]).


'enc_Name'({'Name',Val}) ->
'enc_Name'(Val);

'enc_Name'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',2}],Val).


'dec_Name'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',2}]).

'enc_PropertyParm'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,name)),

%% attribute number 2 with type SEQUENCE OF
'enc_PropertyParm_value'(?RT_PER:cindex(3,Val1,value)),
case ?RT_PER:cindex(4,Val1,extraInfo) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type CHOICE
'enc_PropertyParm_extraInfo'(Tmpval1)
end].

'enc_PropertyParm_value'({'PropertyParm_value',Val}) ->
'enc_PropertyParm_value'(Val);

'enc_PropertyParm_value'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_PropertyParm_value_components'(Val, [])
].
'enc_PropertyParm_value_components'([], Acc) -> lists:reverse(Acc);

'enc_PropertyParm_value_components'([H|T], Acc) ->
'enc_PropertyParm_value_components'(T, [?RT_PER:encode_octet_string([],H) | Acc]).

'dec_PropertyParm_value'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_PropertyParm_value_components'(Num, Bytes1, telltype, []).
'dec_PropertyParm_value_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_PropertyParm_value_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = ?RT_PER:decode_octet_string(Bytes,[]),
   'dec_PropertyParm_value_components'(Num-1, Remain, telltype, [Term|Acc]).

'enc_PropertyParm_extraInfo'({'PropertyParm_extraInfo',Val}) ->
'enc_PropertyParm_extraInfo'(Val);

'enc_PropertyParm_extraInfo'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[relation,range,sublist], 3),
case element(1,Val) of
relation ->
case (case element(2,Val) of {_,_}->element(2,element(2,Val));_->element(2,Val) end) of
'greaterThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'smallerThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'unequalTo' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end;
range ->
?RT_PER:encode_boolean(element(2,Val));
sublist ->
?RT_PER:encode_boolean(element(2,Val))
end
].

'dec_PropertyParm_extraInfo'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,3, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {relation,
?RT_PER:decode_enumerated(Bytes1,[{'ValueRange',{0,2}}],{{greaterThan,smallerThan,unequalTo},{}})};
1 -> {range,
?RT_PER:decode_boolean(Bytes1)};
2 -> {sublist,
?RT_PER:decode_boolean(Bytes1)}
end,

{{Cname,Val},NewBytes}.


'dec_PropertyParm'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_PropertyParm_value'(Bytes3, telltype),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_PropertyParm_extraInfo'(Bytes4, telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'PropertyParm',Term1,Term2,Term3},Bytes7}.


'enc_StreamMode'({'StreamMode',Val}) ->
'enc_StreamMode'(Val);

'enc_StreamMode'(Val) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
'sendOnly' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 0)];
'recvOnly' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 1)];
'sendRecv' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 2)];
'inactive' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 3)];
'loopBack' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 4)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 4 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end.


'dec_StreamMode'(Bytes,_) ->
?RT_PER:decode_enumerated(Bytes,[{'ValueRange',{0,4}}],{{sendOnly,recvOnly,sendRecv,inactive,loopBack},{}}).

'enc_LocalControlDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,streamMode) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type ENUMERATED
case (case Tmpval1 of {_,_}->element(2,Tmpval1);_->Tmpval1 end) of
'sendOnly' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 0)];
'recvOnly' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 1)];
'sendRecv' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 2)];
'inactive' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 3)];
'loopBack' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,4}}], 4)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 4 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end
end,
case ?RT_PER:cindex(3,Val1,reserveValue) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,reserveGroup) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval3)
end,

%% attribute number 4 with type SEQUENCE OF
'enc_LocalControlDescriptor_propertyParms'(?RT_PER:cindex(5,Val1,propertyParms))].

'enc_LocalControlDescriptor_propertyParms'({'LocalControlDescriptor_propertyParms',Val}) ->
'enc_LocalControlDescriptor_propertyParms'(Val);

'enc_LocalControlDescriptor_propertyParms'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_LocalControlDescriptor_propertyParms_components'(Val, [])
].
'enc_LocalControlDescriptor_propertyParms_components'([], Acc) -> lists:reverse(Acc);

'enc_LocalControlDescriptor_propertyParms_components'([H|T], Acc) ->
'enc_LocalControlDescriptor_propertyParms_components'(T, ['enc_PropertyParm'(H)

 | Acc]).

'dec_LocalControlDescriptor_propertyParms'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_LocalControlDescriptor_propertyParms_components'(Num, Bytes1, telltype, []).
'dec_LocalControlDescriptor_propertyParms_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_LocalControlDescriptor_propertyParms_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_PropertyParm'(Bytes,telltype),
   'dec_LocalControlDescriptor_propertyParms_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_LocalControlDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_enumerated(Bytes2,[{'ValueRange',{0,4}}],{{sendOnly,recvOnly,sendRecv,inactive,loopBack},{}});
0 ->{asn1_NOVALUE,Bytes2}

end,

%% attribute number 2 with type BOOLEAN
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_boolean(Bytes3);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type BOOLEAN
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->?RT_PER:decode_boolean(Bytes4);
0 ->{asn1_NOVALUE,Bytes4}

end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_LocalControlDescriptor_propertyParms'(Bytes5, telltype),
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'LocalControlDescriptor',Term1,Term2,Term3,Term4},Bytes8}.

'enc_StreamParms'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,localControlDescriptor) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type Externaltypereference571megaco_per_bin_media_gateway_control_v1LocalControlDescriptor
'enc_LocalControlDescriptor'(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,localDescriptor) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type Externaltypereference572megaco_per_bin_media_gateway_control_v1LocalRemoteDescriptor
'enc_LocalRemoteDescriptor'(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,remoteDescriptor) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type Externaltypereference573megaco_per_bin_media_gateway_control_v1LocalRemoteDescriptor
'enc_LocalRemoteDescriptor'(Tmpval3)
end].


'dec_StreamParms'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%%  attribute number 1 with type LocalControlDescriptor
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->'dec_LocalControlDescriptor'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 2 with type LocalRemoteDescriptor
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->'dec_LocalRemoteDescriptor'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%%  attribute number 3 with type LocalRemoteDescriptor
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->'dec_LocalRemoteDescriptor'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'StreamParms',Term1,Term2,Term3},Bytes7}.

'enc_StreamDescriptor'(Val) ->
Val1 = ?RT_PER:list_to_record('StreamDescriptor', Val),
[

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],?RT_PER:cindex(2,Val1,streamID)),

%% attribute number 2 with type Externaltypereference566megaco_per_bin_media_gateway_control_v1StreamParms
'enc_StreamParms'(?RT_PER:cindex(3,Val1,streamParms))].


'dec_StreamDescriptor'(Bytes,_) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = ?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,65535}}]),

%%  attribute number 2 with type StreamParms
{Term2,Bytes2} = 'dec_StreamParms'(Bytes1,telltype),
{{'StreamDescriptor',Term1,Term2},Bytes2}.

'enc_MediaDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3],2,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,termStateDescr) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type Externaltypereference554megaco_per_bin_media_gateway_control_v1TerminationStateDescriptor
'enc_TerminationStateDescriptor'(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,streams) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type CHOICE
'enc_MediaDescriptor_streams'(Tmpval2)
end].

'enc_MediaDescriptor_streams'({'MediaDescriptor_streams',Val}) ->
'enc_MediaDescriptor_streams'(Val);

'enc_MediaDescriptor_streams'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[oneStream,multiStream], 2),
case element(1,Val) of
oneStream ->
'enc_StreamParms'(element(2,Val));
multiStream ->
'enc_MediaDescriptor_streams_multiStream'(element(2,Val))
end
].

'enc_MediaDescriptor_streams_multiStream'({'MediaDescriptor_streams_multiStream',Val}) ->
'enc_MediaDescriptor_streams_multiStream'(Val);

'enc_MediaDescriptor_streams_multiStream'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_MediaDescriptor_streams_multiStream_components'(Val, [])
].
'enc_MediaDescriptor_streams_multiStream_components'([], Acc) -> lists:reverse(Acc);

'enc_MediaDescriptor_streams_multiStream_components'([H|T], Acc) ->
'enc_MediaDescriptor_streams_multiStream_components'(T, ['enc_StreamDescriptor'(H)

 | Acc]).

'dec_MediaDescriptor_streams_multiStream'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_MediaDescriptor_streams_multiStream_components'(Num, Bytes1, telltype, []).
'dec_MediaDescriptor_streams_multiStream_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_MediaDescriptor_streams_multiStream_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_StreamDescriptor'(Bytes,telltype),
   'dec_MediaDescriptor_streams_multiStream_components'(Num-1, Remain, telltype, [Term|Acc]).

'dec_MediaDescriptor_streams'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,2, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {oneStream,
'dec_StreamParms'(Bytes1,telltype)};
1 -> {multiStream,
'dec_MediaDescriptor_streams_multiStream'(Bytes1, telltype)}
end,

{{Cname,Val},NewBytes}.


'dec_MediaDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%%  attribute number 1 with type TerminationStateDescriptor
{Term1,Bytes3} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->'dec_TerminationStateDescriptor'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,

%% attribute number 2 with type CHOICE
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_MediaDescriptor_streams'(Bytes3, telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,
{Extensions,Bytes5} = ?RT_PER:getextension(Ext,Bytes4),
Bytes6= ?RT_PER:skipextensions(Bytes5,1,Extensions)
,
{{'MediaDescriptor',Term1,Term2},Bytes6}.


'enc_TerminationIDList'({'TerminationIDList',Val}) ->
'enc_TerminationIDList'(Val);

'enc_TerminationIDList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TerminationIDList_components'(Val, [])
].
'enc_TerminationIDList_components'([], Acc) -> lists:reverse(Acc);

'enc_TerminationIDList_components'([H|T], Acc) ->
'enc_TerminationIDList_components'(T, ['enc_TerminationID'(H)

 | Acc]).


'dec_TerminationIDList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TerminationIDList_components'(Num, Bytes1, telltype, []).
'dec_TerminationIDList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TerminationIDList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_TerminationID'(Bytes,telltype),
   'dec_TerminationIDList_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_TerminationID'(Val) ->
Val1 = ?RT_PER:list_to_record('TerminationID', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type SEQUENCE OF
'enc_TerminationID_wildcard'(?RT_PER:cindex(2,Val1,wildcard)),

%% attribute number 2 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',{1,8}}],?RT_PER:cindex(3,Val1,id))].

'enc_TerminationID_wildcard'({'TerminationID_wildcard',Val}) ->
'enc_TerminationID_wildcard'(Val);

'enc_TerminationID_wildcard'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TerminationID_wildcard_components'(Val, [])
].
'enc_TerminationID_wildcard_components'([], Acc) -> lists:reverse(Acc);

'enc_TerminationID_wildcard_components'([H|T], Acc) ->
'enc_TerminationID_wildcard_components'(T, [?RT_PER:encode_octet_string([{'SizeConstraint',1}],H) | Acc]).

'dec_TerminationID_wildcard'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TerminationID_wildcard_components'(Num, Bytes1, telltype, []).
'dec_TerminationID_wildcard_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TerminationID_wildcard_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = ?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',1}]),
   'dec_TerminationID_wildcard_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_TerminationID'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_TerminationID_wildcard'(Bytes1, telltype),

%% attribute number 2 with type OCTET STRING
{Term2,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',{1,8}}]),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'TerminationID',Term1,Term2},Bytes5}.


'enc_WildcardField'({'WildcardField',Val}) ->
'enc_WildcardField'(Val);

'enc_WildcardField'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',1}],Val).


'dec_WildcardField'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',1}]).


'enc_ServiceChangeResult'({'ServiceChangeResult',Val}) ->
'enc_ServiceChangeResult'(Val);

'enc_ServiceChangeResult'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[errorDescriptor,serviceChangeResParms], 2),
case element(1,Val) of
errorDescriptor ->
'enc_ErrorDescriptor'(element(2,Val));
serviceChangeResParms ->
'enc_ServiceChangeResParm'(element(2,Val))
end
].


'dec_ServiceChangeResult'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,2, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {errorDescriptor,
'dec_ErrorDescriptor'(Bytes1,telltype)};
1 -> {serviceChangeResParms,
'dec_ServiceChangeResParm'(Bytes1,telltype)}
end,

{{Cname,Val},NewBytes}.
'enc_ServiceChangeReply'(Val) ->
Val1 = ?RT_PER:list_to_record('ServiceChangeReply', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type Externaltypereference524megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type Externaltypereference525megaco_per_bin_media_gateway_control_v1ServiceChangeResult
'enc_ServiceChangeResult'(?RT_PER:cindex(3,Val1,serviceChangeResult))].


'dec_ServiceChangeReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%%  attribute number 1 with type TerminationIDList
{Term1,Bytes2} = 'dec_TerminationIDList'(Bytes1,telltype),

%%  attribute number 2 with type ServiceChangeResult
{Term2,Bytes3} = 'dec_ServiceChangeResult'(Bytes2,telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'ServiceChangeReply',Term1,Term2},Bytes5}.

'enc_ServiceChangeRequest'(Val) ->
Val1 = ?RT_PER:list_to_record('ServiceChangeRequest', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type Externaltypereference517megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type Externaltypereference518megaco_per_bin_media_gateway_control_v1ServiceChangeParm
'enc_ServiceChangeParm'(?RT_PER:cindex(3,Val1,serviceChangeParms))].


'dec_ServiceChangeRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%%  attribute number 1 with type TerminationIDList
{Term1,Bytes2} = 'dec_TerminationIDList'(Bytes1,telltype),

%%  attribute number 2 with type ServiceChangeParm
{Term2,Bytes3} = 'dec_ServiceChangeParm'(Bytes2,telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'ServiceChangeRequest',Term1,Term2},Bytes5}.

'enc_EventParameter'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',2}],?RT_PER:cindex(2,Val1,eventParameterName)),

%% attribute number 2 with type Externaltypereference504megaco_per_bin_media_gateway_control_v1Value
'enc_Value'(?RT_PER:cindex(3,Val1,value)),
case ?RT_PER:cindex(4,Val1,extraInfo) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type CHOICE
'enc_EventParameter_extraInfo'(Tmpval1)
end].

'enc_EventParameter_extraInfo'({'EventParameter_extraInfo',Val}) ->
'enc_EventParameter_extraInfo'(Val);

'enc_EventParameter_extraInfo'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[relation,range,sublist], 3),
case element(1,Val) of
relation ->
case (case element(2,Val) of {_,_}->element(2,element(2,Val));_->element(2,Val) end) of
'greaterThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0)];
'smallerThan' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1)];
'unequalTo' -> [{bit,0},?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2)];
{asn1_enum,EnumV} when integer(EnumV), EnumV > 2 -> [{bit,1},?RT_PER:encode_small_number(EnumV)];
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end;
range ->
?RT_PER:encode_boolean(element(2,Val));
sublist ->
?RT_PER:encode_boolean(element(2,Val))
end
].

'dec_EventParameter_extraInfo'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,3, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {relation,
?RT_PER:decode_enumerated(Bytes1,[{'ValueRange',{0,2}}],{{greaterThan,smallerThan,unequalTo},{}})};
1 -> {range,
?RT_PER:decode_boolean(Bytes1)};
2 -> {sublist,
?RT_PER:decode_boolean(Bytes1)}
end,

{{Cname,Val},NewBytes}.


'dec_EventParameter'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',2}]),

%%  attribute number 2 with type Value
{Term2,Bytes4} = 'dec_Value'(Bytes3,telltype),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_EventParameter_extraInfo'(Bytes4, telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'EventParameter',Term1,Term2,Term3},Bytes7}.


'enc_EventName'({'EventName',Val}) ->
'enc_EventName'(Val);

'enc_EventName'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',4}],Val).


'dec_EventName'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]).

'enc_ObservedEvent'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,5],2,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,eventName)),
case ?RT_PER:cindex(3,Val1,streamID) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end,

%% attribute number 3 with type SEQUENCE OF
'enc_ObservedEvent_eventParList'(?RT_PER:cindex(4,Val1,eventParList)),
case ?RT_PER:cindex(5,Val1,timeNotation) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 4 with type Externaltypereference495megaco_per_bin_media_gateway_control_v1TimeNotation
'enc_TimeNotation'(Tmpval2)
end].

'enc_ObservedEvent_eventParList'({'ObservedEvent_eventParList',Val}) ->
'enc_ObservedEvent_eventParList'(Val);

'enc_ObservedEvent_eventParList'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ObservedEvent_eventParList_components'(Val, [])
].
'enc_ObservedEvent_eventParList_components'([], Acc) -> lists:reverse(Acc);

'enc_ObservedEvent_eventParList_components'([H|T], Acc) ->
'enc_ObservedEvent_eventParList_components'(T, ['enc_EventParameter'(H)

 | Acc]).

'dec_ObservedEvent_eventParList'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ObservedEvent_eventParList_components'(Num, Bytes1, telltype, []).
'dec_ObservedEvent_eventParList_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ObservedEvent_eventParList_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_EventParameter'(Bytes,telltype),
   'dec_ObservedEvent_eventParList_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ObservedEvent'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes3,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = 'dec_ObservedEvent_eventParList'(Bytes4, telltype),

%%  attribute number 4 with type TimeNotation
{Term4,Bytes6} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_TimeNotation'(Bytes5,telltype);
0 ->{asn1_NOVALUE,Bytes5}

end,
{Extensions,Bytes7} = ?RT_PER:getextension(Ext,Bytes6),
Bytes8= ?RT_PER:skipextensions(Bytes7,1,Extensions)
,
{{'ObservedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_ObservedEventsDescriptor'(Val) ->
Val1 = ?RT_PER:list_to_record('ObservedEventsDescriptor', Val),
[

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,requestId)),

%% attribute number 2 with type SEQUENCE OF
'enc_ObservedEventsDescriptor_observedEventLst'(?RT_PER:cindex(3,Val1,observedEventLst))].

'enc_ObservedEventsDescriptor_observedEventLst'({'ObservedEventsDescriptor_observedEventLst',Val}) ->
'enc_ObservedEventsDescriptor_observedEventLst'(Val);

'enc_ObservedEventsDescriptor_observedEventLst'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ObservedEventsDescriptor_observedEventLst_components'(Val, [])
].
'enc_ObservedEventsDescriptor_observedEventLst_components'([], Acc) -> lists:reverse(Acc);

'enc_ObservedEventsDescriptor_observedEventLst_components'([H|T], Acc) ->
'enc_ObservedEventsDescriptor_observedEventLst_components'(T, ['enc_ObservedEvent'(H)

 | Acc]).

'dec_ObservedEventsDescriptor_observedEventLst'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ObservedEventsDescriptor_observedEventLst_components'(Num, Bytes1, telltype, []).
'dec_ObservedEventsDescriptor_observedEventLst_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ObservedEventsDescriptor_observedEventLst_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_ObservedEvent'(Bytes,telltype),
   'dec_ObservedEventsDescriptor_observedEventLst_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ObservedEventsDescriptor'(Bytes,_) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = ?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes2} = 'dec_ObservedEventsDescriptor_observedEventLst'(Bytes1, telltype),
{{'ObservedEventsDescriptor',Term1,Term2},Bytes2}.

'enc_NotifyReply'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type Externaltypereference479megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),
case ?RT_PER:cindex(3,Val1,errorDescriptor) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference480megaco_per_bin_media_gateway_control_v1ErrorDescriptor
'enc_ErrorDescriptor'(Tmpval1)
end].


'dec_NotifyReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%%  attribute number 1 with type TerminationIDList
{Term1,Bytes3} = 'dec_TerminationIDList'(Bytes2,telltype),

%%  attribute number 2 with type ErrorDescriptor
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_ErrorDescriptor'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,
{Extensions,Bytes5} = ?RT_PER:getextension(Ext,Bytes4),
Bytes6= ?RT_PER:skipextensions(Bytes5,1,Extensions)
,
{{'NotifyReply',Term1,Term2},Bytes6}.

'enc_NotifyRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([4],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type Externaltypereference471megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type Externaltypereference472megaco_per_bin_media_gateway_control_v1ObservedEventsDescriptor
'enc_ObservedEventsDescriptor'(?RT_PER:cindex(3,Val1,observedEventsDescriptor)),
case ?RT_PER:cindex(4,Val1,errorDescriptor) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 3 with type Externaltypereference473megaco_per_bin_media_gateway_control_v1ErrorDescriptor
'enc_ErrorDescriptor'(Tmpval1)
end].


'dec_NotifyRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%%  attribute number 1 with type TerminationIDList
{Term1,Bytes3} = 'dec_TerminationIDList'(Bytes2,telltype),

%%  attribute number 2 with type ObservedEventsDescriptor
{Term2,Bytes4} = 'dec_ObservedEventsDescriptor'(Bytes3,telltype),

%%  attribute number 3 with type ErrorDescriptor
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_ErrorDescriptor'(Bytes4,telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'NotifyRequest',Term1,Term2,Term3},Bytes7}.

'enc_AuditDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2],1,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,auditToken) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type BIT STRING
?RT_PER:encode_bit_string([],Tmpval1,[{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}])
end].


'dec_AuditDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type BIT STRING
{Term1,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_bit_string(Bytes2,[],[{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'AuditDescriptor',Term1},Bytes5}.


'enc_AuditReturnParameter'({'AuditReturnParameter',Val}) ->
'enc_AuditReturnParameter'(Val);

'enc_AuditReturnParameter'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[errorDescriptor,mediaDescriptor,modemDescriptor,muxDescriptor,eventsDescriptor,eventBufferDescriptor,signalsDescriptor,digitMapDescriptor,observedEventsDescriptor,statisticsDescriptor,packagesDescriptor,emptyDescriptors],[]}, {12,0}),
case element(1,Val) of
errorDescriptor ->
'enc_ErrorDescriptor'(element(2,Val));
mediaDescriptor ->
'enc_MediaDescriptor'(element(2,Val));
modemDescriptor ->
'enc_ModemDescriptor'(element(2,Val));
muxDescriptor ->
'enc_MuxDescriptor'(element(2,Val));
eventsDescriptor ->
'enc_EventsDescriptor'(element(2,Val));
eventBufferDescriptor ->
'enc_EventBufferDescriptor'(element(2,Val));
signalsDescriptor ->
'enc_SignalsDescriptor'(element(2,Val));
digitMapDescriptor ->
'enc_DigitMapDescriptor'(element(2,Val));
observedEventsDescriptor ->
'enc_ObservedEventsDescriptor'(element(2,Val));
statisticsDescriptor ->
'enc_StatisticsDescriptor'(element(2,Val));
packagesDescriptor ->
'enc_PackagesDescriptor'(element(2,Val));
emptyDescriptors ->
'enc_AuditDescriptor'(element(2,Val))
end
].


'dec_AuditReturnParameter'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,12,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*12 of
0 -> {errorDescriptor,
'dec_ErrorDescriptor'(Bytes2,telltype)};
1 -> {mediaDescriptor,
'dec_MediaDescriptor'(Bytes2,telltype)};
2 -> {modemDescriptor,
'dec_ModemDescriptor'(Bytes2,telltype)};
3 -> {muxDescriptor,
'dec_MuxDescriptor'(Bytes2,telltype)};
4 -> {eventsDescriptor,
'dec_EventsDescriptor'(Bytes2,telltype)};
5 -> {eventBufferDescriptor,
'dec_EventBufferDescriptor'(Bytes2,telltype)};
6 -> {signalsDescriptor,
'dec_SignalsDescriptor'(Bytes2,telltype)};
7 -> {digitMapDescriptor,
'dec_DigitMapDescriptor'(Bytes2,telltype)};
8 -> {observedEventsDescriptor,
'dec_ObservedEventsDescriptor'(Bytes2,telltype)};
9 -> {statisticsDescriptor,
'dec_StatisticsDescriptor'(Bytes2,telltype)};
10 -> {packagesDescriptor,
'dec_PackagesDescriptor'(Bytes2,telltype)};
11 -> {emptyDescriptors,
'dec_AuditDescriptor'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.

'enc_TerminationAudit'({'TerminationAudit',Val}) ->
'enc_TerminationAudit'(Val);

'enc_TerminationAudit'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TerminationAudit_components'(Val, [])
].
'enc_TerminationAudit_components'([], Acc) -> lists:reverse(Acc);

'enc_TerminationAudit_components'([H|T], Acc) ->
'enc_TerminationAudit_components'(T, ['enc_AuditReturnParameter'(H)

 | Acc]).


'dec_TerminationAudit'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TerminationAudit_components'(Num, Bytes1, telltype, []).
'dec_TerminationAudit_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TerminationAudit_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_AuditReturnParameter'(Bytes,telltype),
   'dec_TerminationAudit_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_AuditResult'(Val) ->
Val1 = ?RT_PER:list_to_record('AuditResult', Val),
[

%% attribute number 1 with type Externaltypereference428megaco_per_bin_media_gateway_control_v1TerminationID
'enc_TerminationID'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type Externaltypereference429megaco_per_bin_media_gateway_control_v1TerminationAudit
'enc_TerminationAudit'(?RT_PER:cindex(3,Val1,terminationAuditResult))].


'dec_AuditResult'(Bytes,_) ->

%%  attribute number 1 with type TerminationID
{Term1,Bytes1} = 'dec_TerminationID'(Bytes,telltype),

%%  attribute number 2 with type TerminationAudit
{Term2,Bytes2} = 'dec_TerminationAudit'(Bytes1,telltype),
{{'AuditResult',Term1,Term2},Bytes2}.


'enc_AuditReply'({'AuditReply',Val}) ->
'enc_AuditReply'(Val);

'enc_AuditReply'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[contextAuditResult,error,auditResult],[]}, {3,0}),
case element(1,Val) of
contextAuditResult ->
'enc_TerminationIDList'(element(2,Val));
error ->
'enc_ErrorDescriptor'(element(2,Val));
auditResult ->
'enc_AuditResult'(element(2,Val))
end
].


'dec_AuditReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,3,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*3 of
0 -> {contextAuditResult,
'dec_TerminationIDList'(Bytes2,telltype)};
1 -> {error,
'dec_ErrorDescriptor'(Bytes2,telltype)};
2 -> {auditResult,
'dec_AuditResult'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_AuditRequest'(Val) ->
Val1 = ?RT_PER:list_to_record('AuditRequest', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type Externaltypereference413megaco_per_bin_media_gateway_control_v1TerminationID
'enc_TerminationID'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type Externaltypereference414megaco_per_bin_media_gateway_control_v1AuditDescriptor
'enc_AuditDescriptor'(?RT_PER:cindex(3,Val1,auditDescriptor))].


'dec_AuditRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%%  attribute number 1 with type TerminationID
{Term1,Bytes2} = 'dec_TerminationID'(Bytes1,telltype),

%%  attribute number 2 with type AuditDescriptor
{Term2,Bytes3} = 'dec_AuditDescriptor'(Bytes2,telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'AuditRequest',Term1,Term2},Bytes5}.

'enc_SubtractRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type Externaltypereference406megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),
case ?RT_PER:cindex(3,Val1,auditDescriptor) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference407megaco_per_bin_media_gateway_control_v1AuditDescriptor
'enc_AuditDescriptor'(Tmpval1)
end].


'dec_SubtractRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%%  attribute number 1 with type TerminationIDList
{Term1,Bytes3} = 'dec_TerminationIDList'(Bytes2,telltype),

%%  attribute number 2 with type AuditDescriptor
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_AuditDescriptor'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,
{Extensions,Bytes5} = ?RT_PER:getextension(Ext,Bytes4),
Bytes6= ?RT_PER:skipextensions(Bytes5,1,Extensions)
,
{{'SubtractRequest',Term1,Term2},Bytes6}.

'enc_AmmsReply'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type Externaltypereference399megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),
case ?RT_PER:cindex(3,Val1,terminationAudit) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference400megaco_per_bin_media_gateway_control_v1TerminationAudit
'enc_TerminationAudit'(Tmpval1)
end].


'dec_AmmsReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%%  attribute number 1 with type TerminationIDList
{Term1,Bytes3} = 'dec_TerminationIDList'(Bytes2,telltype),

%%  attribute number 2 with type TerminationAudit
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_TerminationAudit'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,
{Extensions,Bytes5} = ?RT_PER:getextension(Ext,Bytes4),
Bytes6= ?RT_PER:skipextensions(Bytes5,1,Extensions)
,
{{'AmmsReply',Term1,Term2},Bytes6}.


'enc_AmmDescriptor'({'AmmDescriptor',Val}) ->
'enc_AmmDescriptor'(Val);

'enc_AmmDescriptor'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[mediaDescriptor,modemDescriptor,muxDescriptor,eventsDescriptor,eventBufferDescriptor,signalsDescriptor,digitMapDescriptor,auditDescriptor],[]}, {8,0}),
case element(1,Val) of
mediaDescriptor ->
'enc_MediaDescriptor'(element(2,Val));
modemDescriptor ->
'enc_ModemDescriptor'(element(2,Val));
muxDescriptor ->
'enc_MuxDescriptor'(element(2,Val));
eventsDescriptor ->
'enc_EventsDescriptor'(element(2,Val));
eventBufferDescriptor ->
'enc_EventBufferDescriptor'(element(2,Val));
signalsDescriptor ->
'enc_SignalsDescriptor'(element(2,Val));
digitMapDescriptor ->
'enc_DigitMapDescriptor'(element(2,Val));
auditDescriptor ->
'enc_AuditDescriptor'(element(2,Val))
end
].


'dec_AmmDescriptor'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,8,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*8 of
0 -> {mediaDescriptor,
'dec_MediaDescriptor'(Bytes2,telltype)};
1 -> {modemDescriptor,
'dec_ModemDescriptor'(Bytes2,telltype)};
2 -> {muxDescriptor,
'dec_MuxDescriptor'(Bytes2,telltype)};
3 -> {eventsDescriptor,
'dec_EventsDescriptor'(Bytes2,telltype)};
4 -> {eventBufferDescriptor,
'dec_EventBufferDescriptor'(Bytes2,telltype)};
5 -> {signalsDescriptor,
'dec_SignalsDescriptor'(Bytes2,telltype)};
6 -> {digitMapDescriptor,
'dec_DigitMapDescriptor'(Bytes2,telltype)};
7 -> {auditDescriptor,
'dec_AuditDescriptor'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_AmmRequest'(Val) ->
Val1 = ?RT_PER:list_to_record('AmmRequest', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type Externaltypereference377megaco_per_bin_media_gateway_control_v1TerminationIDList
'enc_TerminationIDList'(?RT_PER:cindex(2,Val1,terminationID)),

%% attribute number 2 with type SEQUENCE OF
'enc_AmmRequest_descriptors'(?RT_PER:cindex(3,Val1,descriptors))].

'enc_AmmRequest_descriptors'({'AmmRequest_descriptors',Val}) ->
'enc_AmmRequest_descriptors'(Val);

'enc_AmmRequest_descriptors'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_AmmRequest_descriptors_components'(Val, [])
].
'enc_AmmRequest_descriptors_components'([], Acc) -> lists:reverse(Acc);

'enc_AmmRequest_descriptors_components'([H|T], Acc) ->
'enc_AmmRequest_descriptors_components'(T, ['enc_AmmDescriptor'(H)

 | Acc]).

'dec_AmmRequest_descriptors'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_AmmRequest_descriptors_components'(Num, Bytes1, telltype, []).
'dec_AmmRequest_descriptors_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_AmmRequest_descriptors_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_AmmDescriptor'(Bytes,telltype),
   'dec_AmmRequest_descriptors_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_AmmRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%%  attribute number 1 with type TerminationIDList
{Term1,Bytes2} = 'dec_TerminationIDList'(Bytes1,telltype),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_AmmRequest_descriptors'(Bytes2, telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'AmmRequest',Term1,Term2},Bytes5}.

'enc_TopologyRequest'(Val) ->
Val1 = ?RT_PER:list_to_record('TopologyRequest', Val),
[

%% attribute number 1 with type Externaltypereference365megaco_per_bin_media_gateway_control_v1TerminationID
'enc_TerminationID'(?RT_PER:cindex(2,Val1,terminationFrom)),

%% attribute number 2 with type Externaltypereference366megaco_per_bin_media_gateway_control_v1TerminationID
'enc_TerminationID'(?RT_PER:cindex(3,Val1,terminationTo)),

%% attribute number 3 with type ENUMERATED
case (case ?RT_PER:cindex(4,Val1,topologyDirection) of {_,_}->element(2,?RT_PER:cindex(4,Val1,topologyDirection));_->?RT_PER:cindex(4,Val1,topologyDirection) end) of
'bothway' -> ?RT_PER:encode_integer([{'ValueRange',{0,2}}], 0);
'isolate' -> ?RT_PER:encode_integer([{'ValueRange',{0,2}}], 1);
'oneway' -> ?RT_PER:encode_integer([{'ValueRange',{0,2}}], 2);
EnumVal -> exit({error,{asn1, {enumerated_not_in_range, EnumVal}}})
end].


'dec_TopologyRequest'(Bytes,_) ->

%%  attribute number 1 with type TerminationID
{Term1,Bytes1} = 'dec_TerminationID'(Bytes,telltype),

%%  attribute number 2 with type TerminationID
{Term2,Bytes2} = 'dec_TerminationID'(Bytes1,telltype),

%% attribute number 3 with type ENUMERATED
{Term3,Bytes3} = ?RT_PER:decode_enumerated(Bytes2,[{'ValueRange',{0,2}}],{bothway,isolate,oneway}),
{{'TopologyRequest',Term1,Term2,Term3},Bytes3}.


'enc_CommandReply'({'CommandReply',Val}) ->
'enc_CommandReply'(Val);

'enc_CommandReply'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[addReply,moveReply,modReply,subtractReply,auditCapReply,auditValueReply,notifyReply,serviceChangeReply],[]}, {8,0}),
case element(1,Val) of
addReply ->
'enc_AmmsReply'(element(2,Val));
moveReply ->
'enc_AmmsReply'(element(2,Val));
modReply ->
'enc_AmmsReply'(element(2,Val));
subtractReply ->
'enc_AmmsReply'(element(2,Val));
auditCapReply ->
'enc_AuditReply'(element(2,Val));
auditValueReply ->
'enc_AuditReply'(element(2,Val));
notifyReply ->
'enc_NotifyReply'(element(2,Val));
serviceChangeReply ->
'enc_ServiceChangeReply'(element(2,Val))
end
].


'dec_CommandReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,8,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*8 of
0 -> {addReply,
'dec_AmmsReply'(Bytes2,telltype)};
1 -> {moveReply,
'dec_AmmsReply'(Bytes2,telltype)};
2 -> {modReply,
'dec_AmmsReply'(Bytes2,telltype)};
3 -> {subtractReply,
'dec_AmmsReply'(Bytes2,telltype)};
4 -> {auditCapReply,
'dec_AuditReply'(Bytes2,telltype)};
5 -> {auditValueReply,
'dec_AuditReply'(Bytes2,telltype)};
6 -> {notifyReply,
'dec_NotifyReply'(Bytes2,telltype)};
7 -> {serviceChangeReply,
'dec_ServiceChangeReply'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.

'enc_Command'({'Command',Val}) ->
'enc_Command'(Val);

'enc_Command'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[addReq,moveReq,modReq,subtractReq,auditCapRequest,auditValueRequest,notifyReq,serviceChangeReq],[]}, {8,0}),
case element(1,Val) of
addReq ->
'enc_AmmRequest'(element(2,Val));
moveReq ->
'enc_AmmRequest'(element(2,Val));
modReq ->
'enc_AmmRequest'(element(2,Val));
subtractReq ->
'enc_SubtractRequest'(element(2,Val));
auditCapRequest ->
'enc_AuditRequest'(element(2,Val));
auditValueRequest ->
'enc_AuditRequest'(element(2,Val));
notifyReq ->
'enc_NotifyRequest'(element(2,Val));
serviceChangeReq ->
'enc_ServiceChangeRequest'(element(2,Val))
end
].


'dec_Command'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,8,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*8 of
0 -> {addReq,
'dec_AmmRequest'(Bytes2,telltype)};
1 -> {moveReq,
'dec_AmmRequest'(Bytes2,telltype)};
2 -> {modReq,
'dec_AmmRequest'(Bytes2,telltype)};
3 -> {subtractReq,
'dec_SubtractRequest'(Bytes2,telltype)};
4 -> {auditCapRequest,
'dec_AuditRequest'(Bytes2,telltype)};
5 -> {auditValueRequest,
'dec_AuditRequest'(Bytes2,telltype)};
6 -> {notifyReq,
'dec_NotifyRequest'(Bytes2,telltype)};
7 -> {serviceChangeReq,
'dec_ServiceChangeRequest'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_CommandRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type Externaltypereference329megaco_per_bin_media_gateway_control_v1Command
'enc_Command'(?RT_PER:cindex(2,Val1,command)),
case ?RT_PER:cindex(3,Val1,optional) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type NULL
?RT_PER:encode_null(Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,wildcardReturn) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type NULL
?RT_PER:encode_null(Tmpval2)
end].


'dec_CommandRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,2), 
%%  attribute number 1 with type Command
{Term1,Bytes3} = 'dec_Command'(Bytes2,telltype),

%% attribute number 2 with type NULL
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_null(Bytes3);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_null(Bytes4);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'CommandRequest',Term1,Term2,Term3},Bytes7}.

'enc_ContextAttrAuditRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,topology) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type NULL
?RT_PER:encode_null(Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,emergency) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type NULL
?RT_PER:encode_null(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,priority) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type NULL
?RT_PER:encode_null(Tmpval3)
end].


'dec_ContextAttrAuditRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%% attribute number 1 with type NULL
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_null(Bytes2);
0 ->{asn1_NOVALUE,Bytes2}

end,

%% attribute number 2 with type NULL
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_null(Bytes3);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->?RT_PER:decode_null(Bytes4);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'ContextAttrAuditRequest',Term1,Term2,Term3},Bytes7}.

'enc_ContextRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2,3,4],3,Val),
[
?RT_PER:setext(false), Opt,
case ?RT_PER:cindex(2,Val1,priority) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,15}}],Tmpval1)
end,
case ?RT_PER:cindex(3,Val1,emergency) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 2 with type BOOLEAN
?RT_PER:encode_boolean(Tmpval2)
end,
case ?RT_PER:cindex(4,Val1,topologyReq) of
asn1_NOVALUE -> [];
Tmpval3 ->

%% attribute number 3 with type SEQUENCE OF
'enc_ContextRequest_topologyReq'(Tmpval3)
end].

'enc_ContextRequest_topologyReq'({'ContextRequest_topologyReq',Val}) ->
'enc_ContextRequest_topologyReq'(Val);

'enc_ContextRequest_topologyReq'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ContextRequest_topologyReq_components'(Val, [])
].
'enc_ContextRequest_topologyReq_components'([], Acc) -> lists:reverse(Acc);

'enc_ContextRequest_topologyReq_components'([H|T], Acc) ->
'enc_ContextRequest_topologyReq_components'(T, ['enc_TopologyRequest'(H)

 | Acc]).

'dec_ContextRequest_topologyReq'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ContextRequest_topologyReq_components'(Num, Bytes1, telltype, []).
'dec_ContextRequest_topologyReq_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ContextRequest_topologyReq_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_TopologyRequest'(Bytes,telltype),
   'dec_ContextRequest_topologyReq_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ContextRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,3), 
%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case Opt band (1 bsl 2) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,15}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,

%% attribute number 2 with type BOOLEAN
{Term2,Bytes4} = case Opt band (1 bsl 1) of
_Opt2 when _Opt2 > 0 ->?RT_PER:decode_boolean(Bytes3);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = case Opt band (1 bsl 0) of
_Opt3 when _Opt3 > 0 ->'dec_ContextRequest_topologyReq'(Bytes4, telltype);
0 ->{asn1_NOVALUE,Bytes4}

end,
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'ContextRequest',Term1,Term2,Term3},Bytes7}.

'enc_ActionReply'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
Opt,

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,contextId)),
case ?RT_PER:cindex(3,Val1,errorDescriptor) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference306megaco_per_bin_media_gateway_control_v1ErrorDescriptor
'enc_ErrorDescriptor'(Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,contextReply) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type Externaltypereference307megaco_per_bin_media_gateway_control_v1ContextRequest
'enc_ContextRequest'(Tmpval2)
end,

%% attribute number 4 with type SEQUENCE OF
'enc_ActionReply_commandReply'(?RT_PER:cindex(5,Val1,commandReply))].

'enc_ActionReply_commandReply'({'ActionReply_commandReply',Val}) ->
'enc_ActionReply_commandReply'(Val);

'enc_ActionReply_commandReply'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ActionReply_commandReply_components'(Val, [])
].
'enc_ActionReply_commandReply_components'([], Acc) -> lists:reverse(Acc);

'enc_ActionReply_commandReply_components'([H|T], Acc) ->
'enc_ActionReply_commandReply_components'(T, ['enc_CommandReply'(H)

 | Acc]).

'dec_ActionReply_commandReply'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ActionReply_commandReply_components'(Num, Bytes1, telltype, []).
'dec_ActionReply_commandReply_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ActionReply_commandReply_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_CommandReply'(Bytes,telltype),
   'dec_ActionReply_commandReply_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ActionReply'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,2), 
%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%%  attribute number 2 with type ErrorDescriptor
{Term2,Bytes3} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->'dec_ErrorDescriptor'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 3 with type ContextRequest
{Term3,Bytes4} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_ContextRequest'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes5} = 'dec_ActionReply_commandReply'(Bytes4, telltype),
{{'ActionReply',Term1,Term2,Term3,Term4},Bytes5}.

'enc_ActionRequest'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3,4],2,Val),
[
Opt,

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,contextId)),
case ?RT_PER:cindex(3,Val1,contextRequest) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type Externaltypereference298megaco_per_bin_media_gateway_control_v1ContextRequest
'enc_ContextRequest'(Tmpval1)
end,
case ?RT_PER:cindex(4,Val1,contextAttrAuditReq) of
asn1_NOVALUE -> [];
Tmpval2 ->

%% attribute number 3 with type Externaltypereference299megaco_per_bin_media_gateway_control_v1ContextAttrAuditRequest
'enc_ContextAttrAuditRequest'(Tmpval2)
end,

%% attribute number 4 with type SEQUENCE OF
'enc_ActionRequest_commandRequests'(?RT_PER:cindex(5,Val1,commandRequests))].

'enc_ActionRequest_commandRequests'({'ActionRequest_commandRequests',Val}) ->
'enc_ActionRequest_commandRequests'(Val);

'enc_ActionRequest_commandRequests'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_ActionRequest_commandRequests_components'(Val, [])
].
'enc_ActionRequest_commandRequests_components'([], Acc) -> lists:reverse(Acc);

'enc_ActionRequest_commandRequests_components'([H|T], Acc) ->
'enc_ActionRequest_commandRequests_components'(T, ['enc_CommandRequest'(H)

 | Acc]).

'dec_ActionRequest_commandRequests'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_ActionRequest_commandRequests_components'(Num, Bytes1, telltype, []).
'dec_ActionRequest_commandRequests_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_ActionRequest_commandRequests_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_CommandRequest'(Bytes,telltype),
   'dec_ActionRequest_commandRequests_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_ActionRequest'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,2), 
%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%%  attribute number 2 with type ContextRequest
{Term2,Bytes3} = case Opt band (1 bsl 1) of
_Opt1 when _Opt1 > 0 ->'dec_ContextRequest'(Bytes2,telltype);
0 ->{asn1_NOVALUE,Bytes2}

end,

%%  attribute number 3 with type ContextAttrAuditRequest
{Term3,Bytes4} = case Opt band (1 bsl 0) of
_Opt2 when _Opt2 > 0 ->'dec_ContextAttrAuditRequest'(Bytes3,telltype);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes5} = 'dec_ActionRequest_commandRequests'(Bytes4, telltype),
{{'ActionRequest',Term1,Term2,Term3,Term4},Bytes5}.


'enc_ContextID'({'ContextID',Val}) ->
'enc_ContextID'(Val);

'enc_ContextID'(Val) ->
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],Val).


'dec_ContextID'(Bytes,_) ->
?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,4294967295}}]).


'enc_ErrorText'({'ErrorText',Val}) ->
'enc_ErrorText'(Val);

'enc_ErrorText'(Val) ->
?RT_PER:encode_IA5String([],Val).


'dec_ErrorText'(Bytes,_) ->
?RT_PER:decode_IA5String(Bytes,[]).


'enc_ErrorCode'({'ErrorCode',Val}) ->
'enc_ErrorCode'(Val);

'enc_ErrorCode'(Val) ->
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Val).


'dec_ErrorCode'(Bytes,_) ->
?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,65535}}]).

'enc_ErrorDescriptor'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],?RT_PER:cindex(2,Val1,errorCode)),
case ?RT_PER:cindex(3,Val1,errorText) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type IA5String
?RT_PER:encode_IA5String([],Tmpval1)
end].


'dec_ErrorDescriptor'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,65535}}]),

%% attribute number 2 with type IA5String
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_IA5String(Bytes2,[]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'ErrorDescriptor',Term1,Term2},Bytes3}.

'enc_TransactionAck'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,firstAck)),
case ?RT_PER:cindex(3,Val1,lastAck) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],Tmpval1)
end].


'dec_TransactionAck'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,4294967295}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'TransactionAck',Term1,Term2},Bytes3}.


'enc_TransactionResponseAck'({'TransactionResponseAck',Val}) ->
'enc_TransactionResponseAck'(Val);

'enc_TransactionResponseAck'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TransactionResponseAck_components'(Val, [])
].
'enc_TransactionResponseAck_components'([], Acc) -> lists:reverse(Acc);

'enc_TransactionResponseAck_components'([H|T], Acc) ->
'enc_TransactionResponseAck_components'(T, ['enc_TransactionAck'(H)

 | Acc]).


'dec_TransactionResponseAck'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TransactionResponseAck_components'(Num, Bytes1, telltype, []).
'dec_TransactionResponseAck_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TransactionResponseAck_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_TransactionAck'(Bytes,telltype),
   'dec_TransactionResponseAck_components'(Num-1, Remain, telltype, [Term|Acc]).
'enc_TransactionReply'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
?RT_PER:setext(false), Opt,

%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,transactionId)),
case ?RT_PER:cindex(3,Val1,immAckRequired) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type NULL
?RT_PER:encode_null(Tmpval1)
end,

%% attribute number 3 with type CHOICE
'enc_TransactionReply_transactionResult'(?RT_PER:cindex(4,Val1,transactionResult))].

'enc_TransactionReply_transactionResult'({'TransactionReply_transactionResult',Val}) ->
'enc_TransactionReply_transactionResult'(Val);

'enc_TransactionReply_transactionResult'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[transactionError,actionReplies], 2),
case element(1,Val) of
transactionError ->
'enc_ErrorDescriptor'(element(2,Val));
actionReplies ->
'enc_TransactionReply_transactionResult_actionReplies'(element(2,Val))
end
].

'enc_TransactionReply_transactionResult_actionReplies'({'TransactionReply_transactionResult_actionReplies',Val}) ->
'enc_TransactionReply_transactionResult_actionReplies'(Val);

'enc_TransactionReply_transactionResult_actionReplies'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TransactionReply_transactionResult_actionReplies_components'(Val, [])
].
'enc_TransactionReply_transactionResult_actionReplies_components'([], Acc) -> lists:reverse(Acc);

'enc_TransactionReply_transactionResult_actionReplies_components'([H|T], Acc) ->
'enc_TransactionReply_transactionResult_actionReplies_components'(T, ['enc_ActionReply'(H)

 | Acc]).

'dec_TransactionReply_transactionResult_actionReplies'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TransactionReply_transactionResult_actionReplies_components'(Num, Bytes1, telltype, []).
'dec_TransactionReply_transactionResult_actionReplies_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TransactionReply_transactionResult_actionReplies_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_ActionReply'(Bytes,telltype),
   'dec_TransactionReply_transactionResult_actionReplies_components'(Num-1, Remain, telltype, [Term|Acc]).

'dec_TransactionReply_transactionResult'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,2, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {transactionError,
'dec_ErrorDescriptor'(Bytes1,telltype)};
1 -> {actionReplies,
'dec_TransactionReply_transactionResult_actionReplies'(Bytes1, telltype)}
end,

{{Cname,Val},NewBytes}.


'dec_TransactionReply'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),
{Opt,Bytes2} = ?RT_PER:getoptionals2(Bytes1,1), 
%% attribute number 1 with type INTEGER
{Term1,Bytes3} = ?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type NULL
{Term2,Bytes4} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_null(Bytes3);
0 ->{asn1_NOVALUE,Bytes3}

end,

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = 'dec_TransactionReply_transactionResult'(Bytes4, telltype),
{Extensions,Bytes6} = ?RT_PER:getextension(Ext,Bytes5),
Bytes7= ?RT_PER:skipextensions(Bytes6,1,Extensions)
,
{{'TransactionReply',Term1,Term2,Term3},Bytes7}.

'enc_TransactionPending'(Val) ->
Val1 = ?RT_PER:list_to_record('TransactionPending', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,transactionId))].


'dec_TransactionPending'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),
{Extensions,Bytes3} = ?RT_PER:getextension(Ext,Bytes2),
Bytes4= ?RT_PER:skipextensions(Bytes3,1,Extensions)
,
{{'TransactionPending',Term1},Bytes4}.

'enc_TransactionRequest'(Val) ->
Val1 = ?RT_PER:list_to_record('TransactionRequest', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],?RT_PER:cindex(2,Val1,transactionId)),

%% attribute number 2 with type SEQUENCE OF
'enc_TransactionRequest_actions'(?RT_PER:cindex(3,Val1,actions))].

'enc_TransactionRequest_actions'({'TransactionRequest_actions',Val}) ->
'enc_TransactionRequest_actions'(Val);

'enc_TransactionRequest_actions'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_TransactionRequest_actions_components'(Val, [])
].
'enc_TransactionRequest_actions_components'([], Acc) -> lists:reverse(Acc);

'enc_TransactionRequest_actions_components'([H|T], Acc) ->
'enc_TransactionRequest_actions_components'(T, ['enc_ActionRequest'(H)

 | Acc]).

'dec_TransactionRequest_actions'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_TransactionRequest_actions_components'(Num, Bytes1, telltype, []).
'dec_TransactionRequest_actions_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_TransactionRequest_actions_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_ActionRequest'(Bytes,telltype),
   'dec_TransactionRequest_actions_components'(Num-1, Remain, telltype, [Term|Acc]).


'dec_TransactionRequest'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,4294967295}}]),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_TransactionRequest_actions'(Bytes2, telltype),
{Extensions,Bytes4} = ?RT_PER:getextension(Ext,Bytes3),
Bytes5= ?RT_PER:skipextensions(Bytes4,1,Extensions)
,
{{'TransactionRequest',Term1,Term2},Bytes5}.


'enc_TransactionId'({'TransactionId',Val}) ->
'enc_TransactionId'(Val);

'enc_TransactionId'(Val) ->
?RT_PER:encode_integer([{'ValueRange',{0,4294967295}}],Val).


'dec_TransactionId'(Bytes,_) ->
?RT_PER:decode_integer(Bytes,[{'ValueRange',{0,4294967295}}]).


'enc_Transaction'({'Transaction',Val}) ->
'enc_Transaction'(Val);

'enc_Transaction'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[transactionRequest,transactionPending,transactionReply,transactionResponseAck],[]}, {4,0}),
case element(1,Val) of
transactionRequest ->
'enc_TransactionRequest'(element(2,Val));
transactionPending ->
'enc_TransactionPending'(element(2,Val));
transactionReply ->
'enc_TransactionReply'(element(2,Val));
transactionResponseAck ->
'enc_TransactionResponseAck'(element(2,Val))
end
].


'dec_Transaction'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,4,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*4 of
0 -> {transactionRequest,
'dec_TransactionRequest'(Bytes2,telltype)};
1 -> {transactionPending,
'dec_TransactionPending'(Bytes2,telltype)};
2 -> {transactionReply,
'dec_TransactionReply'(Bytes2,telltype)};
3 -> {transactionResponseAck,
'dec_TransactionResponseAck'(Bytes2,telltype)};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.

'enc_PathName'({'PathName',Val}) ->
'enc_PathName'(Val);

'enc_PathName'(Val) ->
?RT_PER:encode_IA5String([{'SizeConstraint',{1,64}}],Val).


'dec_PathName'(Bytes,_) ->
?RT_PER:decode_IA5String(Bytes,[{'SizeConstraint',{1,64}}]).

'enc_IP6Address'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',16}],?RT_PER:cindex(2,Val1,address)),
case ?RT_PER:cindex(3,Val1,portNumber) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end].


'dec_IP6Address'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',16}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'IP6Address',Term1,Term2},Bytes3}.

'enc_IP4Address'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,address)),
case ?RT_PER:cindex(3,Val1,portNumber) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end].


'dec_IP4Address'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',4}]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'IP4Address',Term1,Term2},Bytes3}.

'enc_DomainName'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([3],1,Val),
[
Opt,

%% attribute number 1 with type IA5String
?RT_PER:encode_IA5String([],?RT_PER:cindex(2,Val1,name)),
case ?RT_PER:cindex(3,Val1,portNumber) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 2 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,65535}}],Tmpval1)
end].


'dec_DomainName'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%% attribute number 1 with type IA5String
{Term1,Bytes2} = ?RT_PER:decode_IA5String(Bytes1,[]),

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->?RT_PER:decode_integer(Bytes2,[{'ValueRange',{0,65535}}]);
0 ->{asn1_NOVALUE,Bytes2}

end,
{{'DomainName',Term1,Term2},Bytes3}.


'enc_MId'({'MId',Val}) ->
'enc_MId'(Val);

'enc_MId'(Val) ->
[
?RT_PER:set_choice(element(1,Val),{[ip4Address,ip6Address,domainName,deviceName,mtpAddress],[]}, {5,0}),
case element(1,Val) of
ip4Address ->
'enc_IP4Address'(element(2,Val));
ip6Address ->
'enc_IP6Address'(element(2,Val));
domainName ->
'enc_DomainName'(element(2,Val));
deviceName ->
?RT_PER:encode_IA5String([{'SizeConstraint',{1,64}}],element(2,Val));
mtpAddress ->
?RT_PER:encode_octet_string([{'SizeConstraint',{2,4}}],element(2,Val))
end
].


'dec_MId'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getbit(Bytes),
{Choice,Bytes2} = ?RT_PER:getchoice(Bytes1,5,Ext ),
{Cname,{Val,NewBytes}} = case Choice + Ext*5 of
0 -> {ip4Address,
'dec_IP4Address'(Bytes2,telltype)};
1 -> {ip6Address,
'dec_IP6Address'(Bytes2,telltype)};
2 -> {domainName,
'dec_DomainName'(Bytes2,telltype)};
3 -> {deviceName,
?RT_PER:decode_IA5String(Bytes2,[{'SizeConstraint',{1,64}}])};
4 -> {mtpAddress,
?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',{2,4}}])};
_ -> {asn1_ExtAlt, ?RT_PER:decode_open_type(Bytes2,[])}
end,

{{Cname,Val},NewBytes}.
'enc_Message'(Val) ->
Val1 = ?RT_PER:list_to_record('Message', Val),
[
?RT_PER:setext(false), 
%% attribute number 1 with type INTEGER
?RT_PER:encode_integer([{'ValueRange',{0,99}}],?RT_PER:cindex(2,Val1,version)),

%% attribute number 2 with type Externaltypereference185megaco_per_bin_media_gateway_control_v1MId
'enc_MId'(?RT_PER:cindex(3,Val1,mId)),

%% attribute number 3 with type CHOICE
'enc_Message_messageBody'(?RT_PER:cindex(4,Val1,messageBody))].

'enc_Message_messageBody'({'Message_messageBody',Val}) ->
'enc_Message_messageBody'(Val);

'enc_Message_messageBody'(Val) ->
[
?RT_PER:set_choice(element(1,Val),[messageError,transactions], 2),
case element(1,Val) of
messageError ->
'enc_ErrorDescriptor'(element(2,Val));
transactions ->
'enc_Message_messageBody_transactions'(element(2,Val))
end
].

'enc_Message_messageBody_transactions'({'Message_messageBody_transactions',Val}) ->
'enc_Message_messageBody_transactions'(Val);

'enc_Message_messageBody_transactions'(Val) ->
[

   ?RT_PER:encode_length(undefined,length(Val)),
   'enc_Message_messageBody_transactions_components'(Val, [])
].
'enc_Message_messageBody_transactions_components'([], Acc) -> lists:reverse(Acc);

'enc_Message_messageBody_transactions_components'([H|T], Acc) ->
'enc_Message_messageBody_transactions_components'(T, ['enc_Transaction'(H)

 | Acc]).

'dec_Message_messageBody_transactions'(Bytes,_) ->

{Num,Bytes1} = ?RT_PER:decode_length(Bytes,undefined),
'dec_Message_messageBody_transactions_components'(Num, Bytes1, telltype, []).
'dec_Message_messageBody_transactions_components'(0, Bytes, _, Acc) ->
   {lists:reverse(Acc), Bytes};
'dec_Message_messageBody_transactions_components'(Num, Bytes, _, Acc) ->
   {Term,Remain} = 'dec_Transaction'(Bytes,telltype),
   'dec_Message_messageBody_transactions_components'(Num-1, Remain, telltype, [Term|Acc]).

'dec_Message_messageBody'(Bytes,_) ->
{Choice,Bytes1} = ?RT_PER:getchoice(Bytes,2, 0),
{Cname,{Val,NewBytes}} = case Choice of
0 -> {messageError,
'dec_ErrorDescriptor'(Bytes1,telltype)};
1 -> {transactions,
'dec_Message_messageBody_transactions'(Bytes1, telltype)}
end,

{{Cname,Val},NewBytes}.


'dec_Message'(Bytes,_) ->
{Ext,Bytes1} = ?RT_PER:getext(Bytes),

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = ?RT_PER:decode_integer(Bytes1,[{'ValueRange',{0,99}}]),

%%  attribute number 2 with type MId
{Term2,Bytes3} = 'dec_MId'(Bytes2,telltype),

%% attribute number 3 with type CHOICE
{Term3,Bytes4} = 'dec_Message_messageBody'(Bytes3, telltype),
{Extensions,Bytes5} = ?RT_PER:getextension(Ext,Bytes4),
Bytes6= ?RT_PER:skipextensions(Bytes5,1,Extensions)
,
{{'Message',Term1,Term2,Term3},Bytes6}.


'enc_AuthData'({'AuthData',Val}) ->
'enc_AuthData'(Val);

'enc_AuthData'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',{12,32}}],Val).


'dec_AuthData'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',{12,32}}]).


'enc_SequenceNum'({'SequenceNum',Val}) ->
'enc_SequenceNum'(Val);

'enc_SequenceNum'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',4}],Val).


'dec_SequenceNum'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]).


'enc_SecurityParmIndex'({'SecurityParmIndex',Val}) ->
'enc_SecurityParmIndex'(Val);

'enc_SecurityParmIndex'(Val) ->
?RT_PER:encode_octet_string([{'SizeConstraint',4}],Val).


'dec_SecurityParmIndex'(Bytes,_) ->
?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]).

'enc_AuthenticationHeader'(Val) ->
Val1 = ?RT_PER:list_to_record('AuthenticationHeader', Val),
[

%% attribute number 1 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(2,Val1,secParmIndex)),

%% attribute number 2 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',4}],?RT_PER:cindex(3,Val1,seqNum)),

%% attribute number 3 with type OCTET STRING
?RT_PER:encode_octet_string([{'SizeConstraint',{12,32}}],?RT_PER:cindex(4,Val1,ad))].


'dec_AuthenticationHeader'(Bytes,_) ->

%% attribute number 1 with type OCTET STRING
{Term1,Bytes1} = ?RT_PER:decode_octet_string(Bytes,[{'SizeConstraint',4}]),

%% attribute number 2 with type OCTET STRING
{Term2,Bytes2} = ?RT_PER:decode_octet_string(Bytes1,[{'SizeConstraint',4}]),

%% attribute number 3 with type OCTET STRING
{Term3,Bytes3} = ?RT_PER:decode_octet_string(Bytes2,[{'SizeConstraint',{12,32}}]),
{{'AuthenticationHeader',Term1,Term2,Term3},Bytes3}.

'enc_MegacoMessage'(Val) ->
{Val1,Opt} = ?RT_PER:fixoptionals([2],1,Val),
[
Opt,
case ?RT_PER:cindex(2,Val1,authHeader) of
asn1_NOVALUE -> [];
Tmpval1 ->

%% attribute number 1 with type Externaltypereference164megaco_per_bin_media_gateway_control_v1AuthenticationHeader
'enc_AuthenticationHeader'(Tmpval1)
end,

%% attribute number 2 with type Externaltypereference165megaco_per_bin_media_gateway_control_v1Message
'enc_Message'(?RT_PER:cindex(3,Val1,mess))].


'dec_MegacoMessage'(Bytes,_) ->
{Opt,Bytes1} = ?RT_PER:getoptionals2(Bytes,1), 
%%  attribute number 1 with type AuthenticationHeader
{Term1,Bytes2} = case Opt band (1 bsl 0) of
_Opt1 when _Opt1 > 0 ->'dec_AuthenticationHeader'(Bytes1,telltype);
0 ->{asn1_NOVALUE,Bytes1}

end,

%%  attribute number 2 with type Message
{Term2,Bytes3} = 'dec_Message'(Bytes2,telltype),
{{'MegacoMessage',Term1,Term2},Bytes3}.

