/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Material.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef MATERIAL_H
#define MATERIAL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <vector>
#include <string>
#include <iostream>
#include "Color.h"
#include "FileReader.h"

using std::string;
namespace Animorph {


class Material
{
private:
  Color  rgbCol;
  string name;

public:

   Material() : rgbCol(), name() {}
  ~Material() {} 
  /*!
   * \return rgbCol the RGB Color values from this Material
   */
  const Color &getRGBCol () const {return rgbCol;}

  /*!
   * \param rgbCol set the RGB Color values for this Material
   */
  void setRGBCol (const Color &rgbCol) {this->rgbCol = rgbCol;}

  /*!
   * \return name the name of this Material
   */
  const string &getName () const {return name;}

  /*!
   * \param name set the name the name for this Material
   */
  void setName (const std::string &name) {this->name = name;}

};

/*!
The format of Material file:
\verbatim
<string>,<float>,<float>,<float>
...
\endverbatim
*/
class MaterialVector : public std::vector <Material>
{
private:
  void fromStream (std::ifstream &in_stream);

public:
  /// load a Material file
  /*!
   * \param filename the file with Material data to load
   * \return true if file is found
   * \return false if file isn't found
   */
  bool loadMaterials (const std::string& filename);

};

}

#endif // MATERIAL_H
