<?php
/** Spanish (Español)
  *
  * @bug 4401
  * @bug 4424
  *
  * @package MediaWiki
  * @subpackage Language
  */

$quickbarSettings = array(
	'Ninguna', 'Fija a la izquierda', 'Fija a la derecha', 'Flotante a la izquierda'
);

$skinNames = array(
	'standard' => 'Estándar',
);
$namespaceNames = array(
	NS_MEDIA          => 'Media',
	NS_SPECIAL        => 'Especial',
	NS_MAIN           => '',
	NS_TALK           => 'Discusión',
	NS_USER           => 'Usuario',
	NS_USER_TALK      => 'Usuario_Discusión',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK   => '$1_Discusión',
	NS_IMAGE          => 'Imagen',
	NS_IMAGE_TALK     => 'Imagen_Discusión',
	NS_MEDIAWIKI      => 'MediaWiki',
	NS_MEDIAWIKI_TALK => 'MediaWiki_Discusión',
	NS_TEMPLATE       => 'Plantilla',
	NS_TEMPLATE_TALK  => 'Plantilla_Discusión',
	NS_HELP           => 'Ayuda',
	NS_HELP_TALK      => 'Ayuda_Discusión',
	NS_CATEGORY       => 'Categoría',
	NS_CATEGORY_TALK  => 'Categoría_Discusión',
);

$datePreferences = false;
$defaultDateFormat = 'dmy';
$dateFormats = array(
	'dmy time' => 'H:i',
	'dmy date' => 'j M Y',
	'dmy both' => 'H:i j M Y',
);

$separatorTransformTable = array(',' => '.', '.' => ',' );
$linkTrail = '/^([a-záéíóúñ]+)(.*)$/sDu';




$messages = array(
'tog-underline'         => 'Subrayar enlaces',
'tog-highlightbroken'   => 'Destacar enlaces a artículos vacíos <a href="" class="new">como este</a> (alternativa: como éste<a href="" class="internal">?</a>).',
'tog-justify'           => 'Ajustar párrafos',
'tog-hideminor'         => 'Esconder ediciones menores en «cambios recientes»',
'tog-extendwatchlist'   => 'Expandir la lista de seguimiento a todos los cambios aplicables',
'tog-usenewrc'          => 'Cambios recientes realzados (no para todos los navegadores)',
'tog-numberheadings'    => 'Auto-numerar encabezados',
'tog-showtoolbar'       => 'Mostrar barra de edición',
'tog-editondblclick'    => 'Editar páginas con doble clic (JavaScript)',
'tog-editsection'       => 'Habilitar la edición de secciones usando el enlace [editar]',
'tog-editsectiononrightclick'=> 'Habilitar la edición de secciones presionando el botón de la derecha<br /> en los títulos de secciones (JavaScript)',
'tog-showtoc'           => 'Mostrar la tabla de contenidos (para paginas con más de 3 encabezados)',
'tog-rememberpassword'  => 'Recordar la contraseña entre sesiones',
'tog-editwidth'         => 'La caja de edición tiene el ancho máximo',
'tog-watchcreations'    => 'Vigilar las páginas que yo cree.',
'tog-watchdefault'      => 'Vigilar las páginas que yo modifique',
'tog-minordefault'      => 'Marcar todas las ediciones como menores por defecto',
'tog-previewontop'      => 'Mostrar la previsualización antes de la caja de edición en lugar de después',
'tog-previewonfirst'    => 'Mostrar previsualización al comenzar a editar',
'tog-nocache'           => 'Inhabilitar el \'\'cache\'\' de páginas',
'tog-enotifwatchlistpages'=> 'Enviame un correo cuando haya cambios de página',
'tog-enotifusertalkpages'=> 'Notifícame cuando cambia mi página de discusión de usuario',
'tog-enotifminoredits'  => 'Notifícame también los cambios menores de página',
'tog-enotifrevealaddr'  => 'Revela mi dirección electrónica en los correos de notificación',
'tog-shownumberswatching'=> 'Mostrar el número de usuarios que la vigilan',
'tog-fancysig'          => 'Firma sin enlace automático',
'tog-externaleditor'    => 'Utilizar editor externo por defecto',
'tog-externaldiff'      => 'Utilizar \'\'diff\'\' externo por defecto',
'tog-showjumplinks'     => 'Habilitar enlaces de accesibilidad «saltar a»',
'tog-autopatrol'        => 'Marcar mis ediciones como patrulladas',
'tog-forceeditsummary'  => 'Alertar al grabar sin resumen de edición.',
'tog-watchlisthideown'  => 'No mostrar mis ediciones en la lista de seguimiento',
'tog-watchlisthidebots' => 'No mostrar ediciones de bots en la lista de seguimiento',
'underline-always'      => 'Siempre',
'underline-never'       => 'Nunca',
'underline-default'     => 'Valor por defecto del navegador',
'skinpreview'           => '(Ver cómo queda)',
'sunday'                => 'Domingo',
'monday'                => 'Lunes',
'tuesday'               => 'Martes',
'wednesday'             => 'Miércoles',
'thursday'              => 'Jueves',
'friday'                => 'Viernes',
'saturday'              => 'Sábado',
'january'               => 'enero',
'february'              => 'febrero',
'march'                 => 'marzo',
'april'                 => 'abril',
'may_long'              => 'mayo',
'june'                  => 'junio',
'july'                  => 'julio',
'august'                => 'agosto',
'september'             => 'septiembre',
'october'               => 'octubre',
'november'              => 'noviembre',
'december'              => 'diciembre',
'jan'                   => 'ene',
'feb'                   => 'feb',
'mar'                   => 'mar',
'apr'                   => 'abr',
'may'                   => 'may',
'jun'                   => 'jun',
'jul'                   => 'jul',
'aug'                   => 'ago',
'sep'                   => 'sep',
'oct'                   => 'oct',
'nov'                   => 'nov',
'dec'                   => 'dic',
'categories'            => 'Categorías',
'pagecategories'        => '{{PLURAL:$1|Categoría|Categorías}}',
'category_header'       => 'Artículos en la categoría "$1"',
'subcategories'         => 'Subcategorías',
'mainpage'              => 'Portada',
'mainpagetext'          => 'Software wiki instalado con éxito.',
'mainpagedocfooter'     => 'Por favor, lee [http://meta.wikimedia.org/wiki/MediaWiki_i18n documentation on customizing the interface] y [http://meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide User\'s Guide] para conocer su configuración y uso.',
'portal'                => 'Portal de la comunidad',
'portal-url'            => 'Project:Portal de la comunidad',
'about'                 => 'Acerca de',
'aboutsite'             => 'Acerca de {{SITENAME}}',
'aboutpage'             => 'Project:Acerca de',
'article'               => 'Artículo',
'help'                  => 'Ayuda',
'helppage'              => 'Project:Ayuda',
'bugreports'            => 'Informes de error de software',
'bugreportspage'        => 'Project:Informes de error',
'sitesupport'           => 'Donaciones',
'sitesupport-url'       => 'Project:Apoyo al proyecto',
'faqpage'               => 'Project:FAQ',
'edithelp'              => 'Ayuda de edición',
'newwindow'             => '(Se abre en una ventana nueva)',
'edithelppage'          => 'Help:Cómo se edita una página',
'cancel'                => 'Cancelar',
'qbfind'                => 'Encontrar',
'qbbrowse'              => 'Hojear',
'qbedit'                => 'Editar',
'qbpageoptions'         => 'Opciones de página',
'qbpageinfo'            => 'Información de página',
'qbmyoptions'           => 'Mis opciones',
'qbspecialpages'        => 'Páginas especiales',
'moredotdotdot'         => 'Más...',
'mypage'                => 'Mi página',
'mytalk'                => 'Mi discusión',
'anontalk'              => 'Discusión para esta IP',
'navigation'            => 'Navegación',
'currentevents'         => 'Actualidad',
'currentevents-url'     => 'Actualidad',
'disclaimers'           => 'Aviso legal',
'disclaimerpage'        => 'Project:Limitación general de responsabilidad',
'privacy'               => 'Política de protección de datos',
'privacypage'           => 'Project:Política de protección de datos',
'returnto'              => 'Regresa a $1.',
'tagline'               => 'De {{SITENAME}}',
'search'                => 'Buscar',
'searchbutton'          => 'Buscar',
'go'                    => 'Ir',
'searcharticle'                    => 'Ir',
'history'               => 'Historial',
'history_short'         => 'Historial',
'updatedmarker'         => 'actualizado desde mi última visita',
'info_short'            => 'Información',
'printableversion'      => 'Versión para imprimir',
'permalink'             => 'Enlace permanente',
'print'                 => 'Imprimir',
'edit'                  => 'Editar',
'editthispage'          => 'Editar esta página',
'delete'                => 'Borrar',
'deletethispage'        => 'Borrar esta página',
'undelete_short'        => 'Restaurar {{PLURAL:$1|una edición|$1 ediciones}}',
'protect'               => 'Proteger',
'protectthispage'       => 'Proteger esta página',
'unprotect'             => 'Desproteger',
'unprotectthispage'     => 'Desproteger esta página',
'newpage'               => 'Página nueva',
'talkpage'              => 'Discutir esta página',
'specialpage'           => 'Página Especial',
'personaltools'         => 'Herramientas personales',
'postcomment'           => 'Poner un comentario',
'articlepage'           => 'Ver artículo',
'talk'                  => 'Discusión',
'views'                 => 'Vistas',
'toolbox'               => 'Herramientas',
'userpage'              => 'Ver página de usuario',
'projectpage'           => 'Ver página meta',
'imagepage'             => 'Ver página de imagen',
'viewtalkpage'          => 'Ver discusión',
'otherlanguages'        => 'Otros idiomas',
'redirectedfrom'        => '(Redirigido desde $1)',
'redirectpagesub'       => 'Página redirigida',
'lastmodifiedat'          => 'Esta página fue modificada por última vez el $2, $1.',
'viewcount'             => 'Esta página ha sido visitada {{PLURAL:$1|una vez|$1 veces}}.',
'copyright'             => 'El contenido está disponible bajo los términos de la <i>$1</i>',
'protectedpage'         => 'Página protegida',
'jumpto'                => 'Saltar a',
'jumptonavigation'      => 'navegación',
'jumptosearch'          => 'búsqueda',
'badaccess'             => 'Error de permisos',
'versionrequired'       => 'La versión $1 de MediaWiki es necesaria para emplear esta página',
'versionrequiredtext'   => 'Se necesita utilizar la versión $1 de MediaWiki para utilizar esta página. Para más información, consulta [[Special:Version]]',
'retrievedfrom'         => 'Obtenido de "$1"',
'youhavenewmessages'    => 'Tienes $1 ($2).',
'newmessageslink'       => 'mensajes nuevos',
'newmessagesdifflink'   => 'dif. entre las dos últimas versiones',
'editsection'           => 'editar',
'editold'               => 'editar',
'editsectionhint'       => 'Editar sección: $1',
'toc'                   => 'Tabla de contenidos',
'showtoc'               => 'mostrar',
'hidetoc'               => 'esconder',
'thisisdeleted'         => '¿Ver o restaurar $1?',
'viewdeleted'           => '¿Deseas ver $1?',
'restorelink'           => '{{PLURAL:$1|una edición borrada|$1 ediciones borradas}}',
'feedlinks'             => 'Sindicación:',
'nstab-main'            => 'Artículo',
'nstab-user'            => 'Usuario',
'nstab-media'           => 'Media',
'nstab-special'         => 'Especial',
'nstab-project'         => 'Página del proyecto',
'nstab-image'           => 'Imagen',
'nstab-mediawiki'       => 'Mensaje',
'nstab-template'        => 'Plantilla',
'nstab-help'            => 'Ayuda',
'nstab-category'        => 'Categoría',
'nosuchaction'          => 'No existe tal acción',
'nosuchactiontext'      => 'La acción especificada por el URL no es
reconocida por el software de {{SITENAME}}',
'nosuchspecialpage'     => 'No existe esa página especial',
'nospecialpagetext'     => 'Has requerido una página especial que no es
reconocida por el software de {{SITENAME}}.',
'databaseerror'         => 'Error de la base de datos',
'dberrortext'           => 'Ha ocurrido un error de sintaxis en una consulta
a la base de datos.
Esto puede indicar un error en el software.
La última consulta que se intentó fue:
<blockquote><tt>$1</tt></blockquote> dentro de la función "<tt>$2</tt>". El error de retorno de
MySQL fue"<tt>$3: $4</tt>".',
'dberrortextcl'         => 'Ha ocurrido un error de sintaxis en una consulta
a la base de datos.
La última consulta que se intentó fue:
"$1"
desde la función "$2".
MySQL retornó el error "$3: $4".',
'noconnect'             => 'No se pudo conectar a la base de datos en $1',
'nodb'                  => 'No se pudo seleccionar la base de datos $1',
'cachederror'           => 'Esta es una copia guardada en el cache de la página requerida, y puede no estar actualizada.',
'laggedslavemode'       => 'Aviso: a la página le pueden faltar las actualizaciones recientes.',
'readonly'              => 'Base de datos bloqueada',
'enterlockreason'       => 'Explica el motivo del bloqueo, incluyendo una estimación de cuándo se producirá el desbloqueo',
'readonlytext'          => 'La base de datos de {{SITENAME}} está temporalmente
bloqueada para nuevas entradas u otras modificaciones, probablemente
para mantenimiento de rutina, después de lo cual volverá a la normalidad.
El administrador que la bloqueó ofreció esta explicación:
<p>$1',
'missingarticle'        => 'La base de datos no encontró el texto de una
página que debería haber encontrado, llamada "$1".

Esto es causado usualmente por seguir un enlace a una diferencia de páginas o historial obsoleto a una página que ha sido borrada.

Si esta no es la causa, puedes haber encontrado un error en el software. Por favor, informa de esto a un administrador,
incluyendo el URL.',
'readonly_lag'          => 'La base de datos ha sido bloqueada automáticamente mientras los servidores esclavos de la base de datos alcanzan al amo',
'internalerror'         => 'Error interno',
'filecopyerror'         => 'No se pudo copiar el archivo "$1" a "$2".',
'filerenameerror'       => 'No se pudo renombrar el archivo "$1" a "$2".',
'filedeleteerror'       => 'No se pudo borrar el archivo "$1".',
'filenotfound'          => 'No se pudo encontrar el archivo "$1".',
'unexpected'            => 'Valor no esperado: "$1"="$2".',
'formerror'             => 'Error: no se pudo enviar el formulario',
'badarticleerror'       => 'Esta acción no se puede llevar a cabo en esta página.',
'cannotdelete'          => 'No se pudo borrar la página o imagen especificada. (Puede haber sido borrada por alguien antes)',
'badtitle'              => 'Título incorrecto',
'badtitletext'          => 'El título de la página solicitada esta vacío, es inválido, o es un enlace interlenguaje o interwiki incorrecto.',
'perfdisabled'          => 'Lo siento, esta función está temporalmente desactivada porque enlentece la base de datos a tal punto que nadie puede usar el wiki.',
'perfdisabledsub'       => 'Aquí hay una copia grabada de $1:',
'perfcached'            => 'Los siguientes datos están en cache y por tanto pueden estar desactualizados:',
'perfcachedts'          => 'Estos datos están almacenados. Su última actualización fue el $1.',
'wrong_wfQuery_params'  => 'Parámetros incorrectos para wfQuery()<br />
Funcción: $1<br />
Consulta: $2',
'viewsource'            => 'Ver código fuente',
'protectedtext'         => 'Esta página ha sido protegida para impedir su modificación; hay varias razones para que esto sea así, por favor vea
[[Project:Esta página está protegida]].

Puedes ver y copiar el texto fuente de esta página:',
'sqlhidden'             => '(Consulta SQL oculta)',
'logouttitle'           => 'Fin de sesión',
'logouttext'            => 'Has terminado tu sesión.
Puedes continuar usando {{SITENAME}} en forma anónima, o puedes
iniciar sesión otra vez como el mismo u otro usuario.',
'welcomecreation'       => '== ¡Bienvenido(a), $1! ==

Tu cuenta ha sido creada. No olvides personalizar [[Special:Preferences|tus preferencias]] de {{SITENAME}}.',
'loginpagetitle'        => 'Registrarse/Entrar',
'yourname'              => 'Tu nombre de usuario',
'yourpassword'          => 'Tu contraseña',
'yourpasswordagain'     => 'Repite tu contraseña',
'remembermypassword'    => 'Quiero que me recuerden entre sesiones.',
'yourdomainname'        => 'Tu dominio',
'externaldberror'       => 'Hubo un error de autenticación externa de la base de datos o bien tú no está autorizado a actualizar tu cuenta externa.',
'loginproblem'          => '<b>Hubo un problema con tu entrada.</b><br />¡Inténtalo otra vez!',
'alreadyloggedin'       => '<strong>Usuario $1, ¡ya entraste!</strong><br />',
'login'                 => 'Registrarse/Entrar',
'loginprompt'           => 'Necesitas tener cookies permitidos para registrarte en {{SITENAME}}.',
'userlogin'             => 'Registrarse/Entrar',
'logout'                => 'Salir',
'userlogout'            => 'Salir',
'notloggedin'           => 'No has entrado',
'nologin'               => '¿No tienes una cuenta? $1.',
'nologinlink'           => 'Créala',
'createaccount'         => 'Crea una nueva cuenta',
'gotaccount'            => '¿Ya tienes una cuenta? $1.',
'gotaccountlink'        => 'Ingresar',
'createaccountmail'     => 'por correo',
'badretype'             => 'Las contraseñas que ingresaste no concuerdan.',
'userexists'            => 'El nombre que entraste ya está en uso. Por favor, elige un nombre diferente.',
'youremail'             => 'Tu dirección de correo electrónico',
'username'              => 'Nombre de usuario:',
'uid'                   => 'ID de usuario:',
'yourrealname'          => 'Tu nombre real *',
'yourlanguage'          => 'Idioma:',
'yourvariant'           => 'Variante lingüística',
'yournick'              => 'Tu apodo (para firmas)',
'badsig'                => 'Firma en crudo inválida; comprueba las etiquetas HTML.',
'email'                 => 'Correo electrónico',
'prefs-help-email-enotif'=> 'Esta dirección también se usa para mandarte notificaciones por correo si tienes habilitadas las opciones correspondientes.',
'prefs-help-realname'   => '* Nombre real (opcional): si optas por proporcionarlo, se usará para dar atribución a tu trabajo.',
'loginerror'            => 'Error de inicio de sesión',
'prefs-help-email'      => '* Correo (opcional): Permite a otros usuarios escribirte por correo desde tu página de usuario o tu página de discusión sin la necesidad de revelar tu identidad.',
'nocookiesnew'          => 'La cuenta de usuario ha sido creada, pero ahora mismo no estás identificado. {{SITENAME}} usa <em>cookies</em> para identificar a los usuarios registrados, pero tú las tienes deshabilitadas. Por favor, habilítalas, e ingresa con tu nuevo nombre y contraseña.',
'nocookieslogin'        => '{{SITENAME}} utiliza <em>cookies</em> para el ingreso de los usuarios. Tienes las <em>cookies</em> deshabilitadas en el navegador. Por favor, actívalas e inténtalo de nuevo.',
'noname'                => 'No has especificado un nombre de usuario válido.',
'loginsuccesstitle'     => 'Inicio de sesión exitoso',
'loginsuccess'          => 'Has iniciado tu sesión en {{SITENAME}} como "$1".',
'nosuchuser'            => 'No existe usuario alguno llamado "$1".
Revisa tu escritura, o usa el formulario de abajo para crear una nueva cuenta de usuario.',
'nosuchusershort'       => 'No hay un usuario con el nombre "$1". Revisa cómo lo has escrito.',
'wrongpassword'         => 'La contraseña que ingresaste es incorrecta. Por favor inténtalo de nuevo.',
'wrongpasswordempty'    => 'No has escrito una contraseña, inténtalo de nuevo.',
'mailmypassword'        => 'Envíame una nueva contraseña por correo electrónico',
'passwordremindertitle' => 'Recordatorio de contraseña de {{SITENAME}}',
'passwordremindertext'  => 'Alguien (probablemente tú, desde la dirección IP $1)
solicitó que te enviáramos una nueva contraseña para iniciar sesión en {{SITENAME}} ($4).
La contraseña para el usuario "$2" es ahora "$3".
Ahora deberías iniciar sesión y cambiar tu contraseña.

Si fue alguien más quien solicitó este mensaje o has recordado tu contraseña y ya no deseas cambiarla, puedes ignorar este mensaje y seguir usando tu contraseña original.',
'noemail'               => 'No hay dirección electrónica (e-mail) registrada para "$1".',
'passwordsent'          => 'Una nueva contraseña ha sido enviada a la dirección electrónica registrada para "$1".
Por favor entra otra vez después de que la recibas.',
'eauthentsent'          => 'Un correo electrónico de confirmación ha sido enviado a la
dirección especificada. Antes de que se envíe algún otro correo,
sigue por favor las instrucciones enviadas en el mensaje, para confirmar que la dirección te pertenece.',
'mailerror'             => 'Error al enviar correo: $1',
'acct_creation_throttle_hit'=> 'Lo sentimos, ya has creado $1 cuentas. No puedes crear otra.',
'emailauthenticated'    => 'Tu dirección electrónica fue autentificada en $1.',
'emailnotauthenticated' => 'Aún no has confirmado tu durección de correo.
Hasta que lo hagas, las siguientes funciones no estarán disponibles.',
'noemailprefs'          => '<strong>Especifica una dirección electrónica para que funcionen estas características.</strong>',
'emailconfirmlink'      => 'Confirma tu dirección de correo electrónico',
'invalidemailaddress'   => 'La dirección electrónica no puede ser aceptada pues parece que tiene un formato no válido. Por favor, escribe una dirección bien formada o vacía el campo.',
'accountcreated'        => 'Cuenta creada',
'accountcreatedtext'    => 'La cuenta de usuario para $1 ha sido creada.',
'bold_sample'           => 'Texto en negrita',
'bold_tip'              => 'Texto en negrita',
'italic_sample'         => 'Texto en cursiva',
'italic_tip'            => 'Texto en cursiva',
'link_sample'           => 'Título del enlace',
'link_tip'              => 'Enlace interno',
'extlink_sample'        => 'http://www.ejemplo.com Título del enlace',
'extlink_tip'           => 'Enlace externo (recuerda añadir el prefijo http://)',
'headline_sample'       => 'Texto de titular',
'headline_tip'          => 'Titular de nivel 2',
'math_sample'           => 'Escribe aquí una fórmula',
'math_tip'              => 'Fórmula matemática (LaTeX)',
'nowiki_sample'         => 'Aquí inserta texto sin formato',
'nowiki_tip'            => 'Pasar por alto el formato wiki',
'image_sample'          => 'Ejemplo.jpg',
'image_tip'             => 'Imagen incorporada',
'media_sample'          => 'Ejemplo.ogg',
'media_tip'             => 'Enlace a archivo multimedia',
'sig_tip'               => 'Firma, fecha y hora',
'hr_tip'                => 'Línea horizontal (utilízala con moderación)',
'summary'               => 'Resumen',
'subject'               => 'Tema/título',
'minoredit'             => 'Esta es una edición menor',
'watchthis'             => 'Vigilar este artículo',
'savearticle'           => 'Grabar la página',
'preview'               => 'Previsualizar',
'showpreview'           => 'Mostrar previsualización',
'showdiff'              => 'Mostrar cambios',
'blockedtitle'          => 'El usuario está bloqueado',
'blockedtext'           => 'Tu nombre de usuario o dirección IP ha sido bloqueada por $1.
La razón dada es la que sigue:<br />$2<br /> Puedes contactar a $1 o a otro de los [[Project:Administradores|administradores]] para
discutir el bloqueo.

Nota que no podrás usar el enlace "enviar correo electrónico a este usuario" si no has registrado una dirección válida de correo electrónico en tus [[Special:Preferences|preferencias]]. 

Tu dirección IP es $3. Por favor, menciona esta dirección en cualquier consulta que hagas.',
'whitelistedittitle'    => 'Se requiere ingresar para editar.',
'whitelistedittext'     => 'Tienes que $1 para editar artículos.',
'whitelistreadtitle'    => 'Se requiere ingresar para leer',
'whitelistreadtext'     => 'Tienes que [[Special:Userlogin|registrarte]] para leer artículos.',
'whitelistacctitle'     => 'No se te permite crear una cuenta',
'whitelistacctext'      => 'Para que se te permita crear cuentas en este wiki tienes que [[Special:Userlogin|iniciar sesión]] y tener los permisos apropiados.',
'loginreqtitle'         => 'Se requiere ingresar',
'loginreqlink'          => 'ingresar',
'loginreqpagetext'      => 'Debes $1 para ver otras páginas.',
'accmailtitle'          => 'La contraseña ha sido enviada.',
'accmailtext'           => 'La contraseña para «$1» se ha enviado a $2.',
'newarticle'            => '(Nuevo)',
'newarticletext'        => 'Has seguido un enlace a una página que aún no existe. Si lo que quieres es crear esta página, empieza a escribir en la caja que sigue. Para más información consulta la [[Project:Ayuda|página de ayuda]]. Si llegaste aquí por error, presiona la tecla para volver a la página anterior de tu navegador.',
'anontalkpagetext'      => '---- \'\'Esta es la página de discusión para un usuario anónimo que aún no ha creado una cuenta (o no la usa). Por lo tanto, tenemos que usar su dirección IP para identificarlo. Una dirección IP puede ser compartida por varios usuarios. Si eres un usuario anónimo y sientes que te han dirigido comentarios irrelevantes, por favor [[Special:Userlogin|crea una cuenta o entra]] para evitar confusiones futuras con otros usuarios anónimos.\'\'',
'noarticletext'         => '(En este momento no hay texto en esta página)',
'clearyourcache'        => '\'\'\'Nota:\'\'\' Tras salvar el archivo, debes refrescar la caché de tu navegador para ver los cambios:
*\'\'\'Mozilla:\'\'\'  \'\'ctrl-shift-r\'\',
*\'\'\'Internet Explorer:\'\'\' \'\'ctrl-f5\'\',
*\'\'\'Safari:\'\'\' \'\'cmd-shift-r\'\',
*\'\'\'Konqueror\'\'\' \'\'f5\'\'.',
'usercssjsyoucanpreview'=> '<strong>Consejo:</strong> Usa el botón «Mostrar previsualización» para probar tu nuevo css/js antes de grabarlo.',
'usercsspreview'        => '\'\'\'¡Recuerda que sólo estás previsualizando tu css de usuario, aún no se ha grabado!\'\'\'',
'userjspreview'         => '\'\'\'¡Recuerda que sólo estás previsualizando tu javascript de usuario, y que todavía no se ha grabado!\'\'\'',
'updated'               => '(Actualizado)',
'note'                  => '<strong>Nota:</strong>',
'previewnote'           => '¡Recuerda que esto es sólo una previsualización, y no ha sido grabada todavía!',
'session_fail_preview'  => '<strong>Lo sentimos, no pudimos procesar tu edición debido a una pérdida de los datos de sesión. Por favor, prueba de nuevo, y si no funciona, prueba a salir y volver a ingresar.</strong>',
'previewconflict'       => 'Esta previsualización refleja el texto en el área
de edición superior como aparecerá si eliges grabar.',
'importing'             => 'Importando $1',
'editing'               => 'Editando $1',
'editinguser'               => 'Editando $1',
'editingsection'        => 'Editando $1 (sección)',
'editingcomment'        => 'Editando $1 (comentario)',
'editconflict'          => 'Conflicto de edición: $1',
'explainconflict'       => 'Alguien más ha cambiado esta página desde que empezaste
a editarla.
El área de texto superior contiene el texto de la página como existe
actualmente. Tus cambios se muestran en el área de texto inferior.
Vas a tener que incorporar tus cambios en el texto existente.
<b>Sólo</b> el texto en el área de texto superior será grabado cuando presiones
 "Grabar página".<br />',
'yourtext'              => 'Tu texto',
'storedversion'         => 'Versión almacenada',
'nonunicodebrowser'     => '<strong>AVISO: Tu navegador no cumple la norma Unicode. Se ha activado un sistema de edición alternativo que te permitirá editar artículos con seguridad: los caracteres no ASCII aparecerán en la caja de edición como códigos hexadecimales.</strong>',
'editingold'            => '<strong>ADVERTENCIA: Estás editando una versión antigua
 de esta página.
Si la grabas, los cambios hechos desde esa revisión se perderán.</strong>',
'yourdiff'              => 'Diferencias',
'copyrightwarning'      => 'Por favor observa que todas las contribuciones a {{SITENAME}} se consideran hechas públicas bajo la $2 (ver detalles en $1). Si no deseas que la gente corrija tus escritos sin piedad y los distribuya libremente, entonces no los pongas aquí. También tú nos aseguras que escribiste este texto tú mismo y eres dueño de los derechos de autor, o lo copiaste desde el dominio público u otra fuente libre.<strong>¡NO USES ESCRITOS CON COPYRIGHT SIN PERMISO!<br />',
'copyrightwarning2'     => 'Por favor, ten en cuenta que todas las contribuciones a {{SITENAME}} pueden ser editadas, modificadas o eliminadas por otros colaboradores. Si no deseas que la gente corrija tus escritos sin piedad y los distribuya libremente, entonces no los pongas aquí. <br />También tú nos aseguras que escribiste esto tú mismo y eres dueño de los derechos de autor, o lo copiaste desde el dominio público u otra fuente libre. (véase $1 para detalles). <br /><strong>¡NO USES ESCRITOS CON COPYRIGHT SIN PERMISO!</strong>',
'longpagewarning'       => '<strong>ADVERTENCIA: Esta página tiene un tamaño de $1 kilobytes; algunos navegadores pueden tener problemas editando páginas de 32kb o más.
Por favor considera la posibilidad de descomponer esta página en secciones más pequeñas.</strong>',
'readonlywarning'       => '<strong>ADVERTENCIA: La base de datos ha sido bloqueada para mantenimiento, así que no podrás grabar tus modificaciones en este momento.
Puedes "cortar y pegar" a un archivo de texto en tu computador, y grabarlo para
intentarlo después.</strong>',
'protectedpagewarning'  => '<strong>ADVERTENCIA: Esta página ha sido protegida de manera que sólo usuarios con permisos de administrador pueden editarla. Asegúrate de que estás siguiendo las [[Project:Políticas de bloqueo de páginas|gPolíticas de bloqueo de páginas]].</strong>
__NOEDITSECTION__<h3>La edición de esta página está [[Project:Esta página está protegida|protegida]].</h3>
* Puedes opinar sobre este bloqueo en la [[{{TALKPAGENAME}}|página de discusión]] del artículo.<br />',
'templatesused'         => 'Plantillas usadas en esta página:',
'edittools'             => '<!-- Este texto aparecerá bajo los formularios de edición y subida. -->',
'nocreatetitle'         => 'Creación de páginas limitada',
'nocreatetext'          => 'Este wiki ha restringido la posibilidad de crear nuevas páginas. Puedes volver atrás y editar una página existente, o [[Special:Userlogin|ingresar o crear una cuenta]].',
'revhistory'            => 'Historial de revisiones',
'nohistory'             => 'No hay un historial de ediciones para esta página.',
'revnotfound'           => 'Revisión no encontrada',
'revnotfoundtext'       => 'La revisión antigua de la página por la que preguntaste no se pudo encontrar.
Por favor revisa el URL que usaste para acceder a esta página.',
'loadhist'              => 'Recuperando el historial de la página',
'currentrev'            => 'Revisión actual',
'revisionasof'          => 'Revisión de $1',
'previousrevision'      => '← Revisión anterior',
'nextrevision'          => 'Revisión siguiente →',
'currentrevisionlink'   => 'Ver revisión actual',
'cur'                   => 'act',
'next'                  => 'sig',
'last'                  => 'prev',
'histlegend'            => 'Leyenda: (act) = diferencia con la versión actual,
(prev) = diferencia con la versión previa, M = edición menor',
'deletedrev'            => '[borrado]',
'histfirst'             => 'Primeras',
'histlast'              => 'Últimas',
'difference'            => '(Diferencia entre revisiones)',
'loadingrev'            => 'recuperando revisión para diff',
'lineno'                => 'Línea $1:',
'editcurrent'           => 'Edita la versión actual de esta página',
'selectnewerversionfordiff'=> 'Selecciona una versión más reciente para comparar',
'selectolderversionfordiff'=> 'Selecciona una versión más antigua para comparar',
'compareselectedversions'=> 'Comparar versiones seleccionadas',
'searchresults'         => 'Resultados de búsqueda',
'searchresulttext'      => 'Para más información acerca de búsquedas en {{SITENAME}}, ve a [[Project:Búsqueda|Buscando en {{SITENAME}}]].',
'searchsubtitle'        => 'Has consultado por \'\'\'[[:$1]]\'\'\'',
'searchsubtitleinvalid' => 'Para consulta "$1"',
'badquery'              => 'Consulta de búsqueda formateada en forma incorrecta',
'badquerytext'          => 'No pudimos procesar tu búsqueda.
Esto es probablemente porque intentaste buscar una palabra de menos de tres letras, lo que todavía no es posible.
También puede ser que hayas cometido un error de escritura en la expresión.
Por favor, intenta una búsqueda diferente.',
'matchtotals'           => 'La consulta "$1" coincidió con $2 títulos de artículos
y el texto de $3 artículos.',
'titlematches'          => 'Coincidencias de título de artículo',
'notitlematches'        => 'No hay coincidencias de título de artículo',
'textmatches'           => 'Coincidencias de texto de artículo',
'notextmatches'         => 'No hay coincidencias de texto de artículo',
'prevn'                 => '$1 previos',
'nextn'                 => '$1 siguientes',
'viewprevnext'          => 'Ver ($1) ($2) ($3).',
'showingresults'        => 'Abajo se muestran hasta <b>$1</b> resultados empezando por el nº<b>$2</b>.',
'showingresultsnum'     => 'Abajo se muestran los <b>$3</b> resultados empezando por el nº<b>$2</b>.',
'nonefound'             => '<strong>Nota</strong>: a menudo el fracaso en una búsqueda se debe a  intentar buscar palabras comunes como "la" o "de",
que no están en el índice, o por especificar más de una palabra a buscar (sólo las páginas
que contengan todos los términos de una búsqueda aparecerán en el resultado).',
'powersearch'           => 'Búsqueda',
'powersearchtext'       => '
Buscar en espacios de nombre:<br />
$1<br />
$2 Listar redirecciones   Buscar $3 $9',
'searchdisabled'        => 'La búsqueda en {{SITENAME}} está temporalmente deshabilitada. Mientras tanto puedes buscar mediante estos buscadores externos, pero ten en cuenta que sus índices del contenido de {{SITENAME}} pueden estar desactualizados.',
'blanknamespace'        => '(Principal)',
'preferences'           => 'Preferencias',
'prefsnologin'          => 'No has entrado',
'prefsnologintext'      => 'Debes [[Special:Userlogin|entrar]] para cambiar las preferencias de usuario.',
'prefsreset'            => 'Las preferencias han sido repuestas a sus valores almacenados.',
'qbsettings'            => 'Preferencias de "Quickbar"',
'changepassword'        => 'Cambiar contraseña',
'skin'                  => 'Piel',
'math'                  => 'Fórmulas',
'dateformat'            => 'Formato de fecha',
'datedefault'           => 'Sin preferencia',
'datetime'              => 'Fecha y hora',
'math_failure'          => 'No se pudo entender',
'math_unknown_error'    => 'error desconocido',
'math_unknown_function' => 'función desconocida',
'math_lexing_error'     => 'error de léxico',
'math_syntax_error'     => 'error de sintaxis',
'math_image_error'      => 'La conversión a PNG ha sido errónea',
'math_bad_tmpdir'       => 'No se puede escribir o crear el directorio temporal de math',
'math_bad_output'       => 'No se puede escribir o crear el directorio de salida de math',
'math_notexvc'          => 'Falta el ejecutalbe de texvc; por favor, lee math/README para configurarlo.',
'prefs-personal'        => 'Datos personales',
'prefs-rc'              => 'Cambios recientes',
'prefs-misc'            => 'Miscelánea',
'saveprefs'             => 'Grabar preferencias',
'resetprefs'            => 'Volver a preferencias por defecto',
'oldpassword'           => 'Contraseña antigua:',
'newpassword'           => 'Contraseña nueva:',
'retypenew'             => 'Reescribe la nueva contraseña:',
'textboxsize'           => 'Edición',
'rows'                  => 'Filas:',
'columns'               => 'Columnas:',
'searchresultshead'     => 'Búsquedas',
'resultsperpage'        => 'Resultados para mostrar por página',
'contextlines'          => 'Líneas para mostrar por resultado',
'contextchars'          => 'Caracteres de contexto por línea',
'stubthreshold'         => 'Umbral para mostrar esbozos:',
'recentchangescount'    => 'Número de títulos en cambios recientes',
'savedprefs'            => 'Tus preferencias han sido grabadas.',
'timezonelegend'        => 'Huso horario',
'timezonetext'          => 'Entra el número de horas de diferencia entre tu hora local
y la hora del servidor (UTC).',
'localtime'             => 'Hora local',
'timezoneoffset'        => 'Diferencia',
'servertime'            => 'La hora en el servidor es',
'guesstimezone'         => 'Obtener la hora del navegador',
'allowemail'            => 'Habilitar la recepción de correo de otros usuarios',
'defaultns'             => 'Buscar en estos espacios de nombres por defecto:',
'default'               => 'por defecto',
'files'                 => 'Archivos',
'userrights-lookup-user'=> 'Configurar grupos de usuarios',
'userrights-user-editname'=> 'Escribe un nombre de usuario:',
'editusergroup'         => 'Modificar grupos de usuarios',
'userrights-editusergroup'=> 'Modificar grupos de usuarios',
'saveusergroups'        => 'Guardar grupos de usurarios',
'userrights-groupsmember'=> 'Miembro de:',
'userrights-groupsavailable'=> 'Grupos disponibles:',
'userrights-groupshelp' => 'Selecciona los grupos a los que quieres unir al usuario (o de los que le quieres dar de baja).
Los grupos no seleccionados no cambiarán. Puedes deseleccionar con CTRL + clic izquierdo',
'changes'               => 'cambios',
'recentchanges'         => 'Cambios recientes',
'recentchangestext'     => 'Sigue los cambios más recientes al wiki en esta página.',
'rcnote'                => 'Abajo están los últimos <b>$1</b> cambios en los últimos <b>$2</b> días, actualizados $3',
'rcnotefrom'            => 'Abajo están los cambios desde <b>$2</b> (se muestran hasta <b>$1</b>).',
'rclistfrom'            => 'Mostrar cambios nuevos desde $1',
'rclinks'               => 'Ver los últimos $1 cambios en los últimos $2 días.<br />$3',
'diff'                  => 'dif',
'hide'                  => 'esconder',
'show'                  => 'mostrar',
'number_of_watching_users_pageview'=> '[$1 usuarios vigilando]',
'upload'                => 'Subir archivo',
'uploadbtn'             => 'Subir un archivo',
'reupload'              => 'Subir otra vez',
'reuploaddesc'          => 'Regresar al formulario para subir.',
'uploadnologin'         => 'No has iniciado sesión',
'uploadnologintext'     => 'Tienes que [[Special:Userlogin|iniciar sesión]] para poder subir archivos.',
'upload_directory_read_only'=> 'El directorio para subida de archivos ($1) no puede ser escrito por el servidor web.',
'uploaderror'           => 'Error al intentar subir archivo',
'uploadtext'            => 'Para ver o buscar imágenes que se hayan subido previamente, ve a la [[Special:Imagelist|lista de imágenes subidas]]. Los archivos subidos y borrados son registrados en el [[Special:Log/upload|registro de subidas]]. Consulta también la [[Project:Política de uso de imágenes|política de uso de imágenes]]. Usa el formulario siguiente para subir nuevos archivos de imágenes que vas a usar para ilustrar tus artículos. En la mayoría de los navegadores, verás un botón "Browse...", que abrirá el diálogo de selección de archivos estándar de tu sistema operativo. Cuando hayas elegido un archivo, su nombre aparecerá en el campo de texto al lado del botón "Examinar...". También debes marcar la caja afirmando que no estás violando ningún copyright al subir el archivo. Presiona el botón "Subir" para completar la subida. Esto puede tomar algún tiempo si tienes una conexión a Internet lenta. Los formatos preferidos son JPEG para imágenes fotográficas, PNG para dibujos y diagramas, y OGG para sonidos. Por favor, dale a tus archivos nombres descriptivos para evitar confusiones. Para incluir la imagen en un artículo, usa un enlace de la forma
* \'\'\'<nowiki>[[</nowiki>{{ns:Image}}<nowiki>:Archivo.jpg]]</nowiki>\'\'\'
* \'\'\'<nowiki>[[</nowiki>{{ns:Image}}<nowiki>:Archivo.png|alt text]]</nowiki>\'\'\'
o para sonidos
* \'\'\'<nowiki>[[</nowiki>{{ns:Media}}<nowiki>:Archivo.ogg]]</nowiki>\'\'\'
Por favor recuerda que, al igual que con las páginas {{SITENAME}}, otros pueden editar o borrar los archivos que has subido si piensan que es bueno para el proyecto, y se te puede bloquear, impidiéndote subir más archivos si abusas del sistema.',
'uploadlog'             => 'registro de subidas',
'uploadlogpage'         => 'Registro de subidas',
'uploadlogpagetext'     => 'Abajo hay una lista de los archivos que se han
subido recientemente. Todas las horas son del servidor (UTC).
<ul>
</ul>',
'filename'              => 'Nombre del archivo',
'filedesc'              => 'Sumario',
'fileuploadsummary'     => 'Descripción:',
'filestatus'            => 'Estado de copyright',
'filesource'            => 'Fuente',
'copyrightpage'         => 'Project:Copyrights',
'copyrightpagename'     => 'Copyright de {{SITENAME}}',
'uploadedfiles'         => 'Archivos subidos',
'ignorewarning'         => 'Ignorar aviso y guardar de todos modos',
'ignorewarnings'        => 'Ignorar cualquier aviso',
'minlength'             => 'Los nombres de imágenes deben ser al menos de tres letras.',
'illegalfilename'       => 'El nombre de archivo «$1» contiene caracteres que no están permitidos en títulos de páginas. Por favor, renombra el archivo e intenta volver a subirlo.',
'badfilename'           => 'El nombre de la imagen se ha cambiado a "$1".',
'badfiletype'           => '".$1" no es un formato de imagen recomendado.',
'largefile'             => 'Se recomienda que las imágenes no excedan los $1 bytes de tamaño. Esta imágen tiene $2',
'largefileserver'       => 'El tamaño de este archivo es mayor del que este servidor admite por configuración.',
'emptyfile'             => 'El archivo que has intentado subir parece estar vacío; por favor, verifica que realmente se trate del archivo que intentabas subir.',
'fileexists'            => 'Ya existe un archivo con este nombre, por favor comprueba el existente $1 si no estás seguro de querer reemplazarlo.


\'\'\'Nota:\'\'\' Si finalmente sustituyes el archivo, debes refrescar la caché de tu navegador para ver los cambios:
*\'\'\'Mozilla\'\'\' / \'\'\'Firefox\'\'\': Pulsa el botón \'\'\'Recargar\'\'\' (o \'\'\'ctrl-r\'\'\')
*\'\'\'Internet Explorer\'\'\' / \'\'\'Opera\'\'\': \'\'\'ctrl-f5\'\'\'
*\'\'\'Safari\'\'\': \'\'\'cmd-r\'\'\'
*\'\'\'Konqueror\'\'\': \'\'\'ctrl-r\'\'',
'fileexists-forbidden'  => 'Ya existe un archivo con este nombre. Por favor, vuelve atrás y sube este archivo con un nuevo nombre. [[Image:$1|thumb|center|$1]]',
'fileexists-shared-forbidden'=> 'Ya existe en \'\'[[Commons:Portada|Commons]]\'\' un archivo con el mismo nombre. Por favor regresa a la página anterior y sube tu archivo con otro nombre. [[Image:$1|thumb|center|$1]]',
'successfulupload'      => 'Subida con éxito',
'fileuploaded'          => 'El archivo "$1" se subió con éxito.
Por favor sigue este enlace: ($2) a la página de descripción y escribe
la información acerca del archivo, tal como de dónde viene, cuándo fue
creado y por quién, y cualquier otra cosa que puedas saber al respecto.',
'uploadwarning'         => 'Advertencia de subida de archivo',
'savefile'              => 'Grabar archivo',
'uploadedimage'         => 'subió "[[$1]]".',
'uploaddisabled'        => 'Lo sentimos, la capacidad de subir archivos está desactivada.',
'uploadscripted'        => 'Este archivo contiene HTML o código de script que puede ser interpretado erroneamente por un navegador web.',
'uploadcorrupt'         => 'Este archivo está corrupto o tiene una extensión incorrecta. Por favor, comprueba el archivo y súbleo de nuevo.',
'uploadvirus'           => '¡El archivo contiene un virus! Detalles: $1',
'sourcefilename'        => 'Nombre de origen',
'destfilename'          => 'Nombre de destino',
'license'               => 'Licencia',
'nolicense'             => 'Ninguna seleccionada',
'imagelist'             => 'Lista de imágenes',
'imagelisttext'         => 'Abajo hay una lista de $1 imágenes ordenadas $2.',
'getimagelist'          => ' obteniendo la lista de imágenes',
'ilsubmit'              => 'Búsqueda',
'showlast'              => 'Mostrar las últimas $1 imágenes ordenadas  $2.',
'byname'                => 'por nombre',
'bydate'                => 'por fecha',
'bysize'                => 'por tamaño',
'imgdelete'             => 'borr',
'imglegend'             => 'Leyenda: (desc) = mostrar/editar la descripción de la imagen.',
'imghistory'            => 'Historial de la imagen',
'deleteimg'             => 'borr',
'deleteimgcompletely'   => 'Borrar todas las revisiones',
'imghistlegend'         => 'Leyenda: (act) = esta es la imagen actual, (borr) = borrar
esta versión antigua, (rev) = revertir a esta versión antigua.
<br /><i>Clic en la fecha para ver imagen subida en esa fecha</i>.',
'imagelinks'            => 'Enlaces a la imagen',
'linkstoimage'          => 'Las siguientes páginas enlazan a esta imagen:',
'nolinkstoimage'        => 'No hay páginas que enlacen a esta imagen.',
'sharedupload'          => 'Este archivo está compartido y puede usarse desde otros proyectos.',
'shareduploadwiki'      => 'Puedes consultar $1 para más información.',
'shareduploadwiki-linktext'=> 'página de descripción del archivo',
'noimage'               => 'No existe un archivo con este nombre, puedes $1.',
'noimage-linktext'      => 'subirlo',
'uploadnewversion-linktext'=> 'Subir una nueva versión de este archivo',
'mimesearch'            => 'Búsqueda MIME',
'mimetype'              => 'Tipo MIME:',
'download'              => 'descargar',
'unwatchedpages'        => 'Páginas no vigiladas',
'statistics'            => 'Estadísticas',
'sitestats'             => 'Estadísticas del sitio',
'userstats'             => 'Estadísticas de usuario',
'sitestatstext'         => 'Hay un total de \'\'\'$1\'\'\' páginas en la base de datos
Esto incluye páginas de discusión, páginas sobre {{SITENAME}}, esbozos, redirecciones y otras que probablmente no califican como artículos.
Excluyéndolas, hay \'\'\'$2\'\'\' páginas que, probablmente, son artículos legítimos.

\'\'\'$8\'\'\' archivos fueron almacenados en el servidor.

Han habido un total de \'\'\'$3\'\'\' visitas y \'\'\'$4\'\'\' ediciones de página desde que el wiki fue instalado.
Esto resulta en un promedio de \'\'\'$5\'\'\' ediciones por página y \'\'\'$6\'\'\' visitas por edición.

La longitud de [http://meta.wikimedia.org/wiki/Help:Job_queue job queue] es de \'\'\'$7\'\'\'',
'userstatstext'         => 'Hay \'\'\'$1\'\'\' usuarios registrados.
de los cuales \'\'\'$2\'\'\' (o \'\'\'$4%\'\'\') son administradores (ver $3).',
'disambiguations'       => 'Páginas de desambiguación',
'disambiguationspage'   => 'Template:Desambiguación',
'disambiguationstext'   => 'Los siguientes artículos enlazan a una <i>página de desambiguación</i>. Deberían enlazar al artículo apropiado.<br />Una página es considerada de desambiguación si está enlazada desde $1.<br />Enlaces desde otros espacios de nombre <b>no</b> son listados aquí.',
'doubleredirects'       => 'Redirecciones dobles',
'doubleredirectstext'   => '<b>Atención:</b> Esta lista puede contener falsos positivos. Eso significa usualmente que hay texto adicional con enlaces bajo el primer #REDIRECT.<br />
Cada fila contiene enlaces al segundo y tercer redirect, así como la primera línea del segundo redirect, en la que usualmente se encontrará el artículo "real" al que el primer redirect debería apuntar.',
'brokenredirects'       => 'Redirecciones incorrectas',
'brokenredirectstext'   => 'Las redirecciones siguientes enlazan a un artículo que no existe.',
'nbytes'                => '$1 {{PLURAL:$1|byte|bytes}}',
'ncategories'           => '$1 {{PLURAL:$1|categoría|categorías}}',
'nlinks'                => '$1 {{PLURAL:$1|enlace|enlaces}}',
'nmembers'              => '$1 {{PLURAL:$1|artículo|artículos}}',
'nrevisions'            => '$1 {{PLURAL:$1|revisión|revisiones}}',
'nviews'                => '$1 {{PLURAL:$1|vista|vistas}}',
'lonelypages'           => 'Páginas huérfanas',
'uncategorizedpages'    => 'Páginas sin categorizar',
'uncategorizedcategories'=> 'Categorías sin categorizar',
'unusedcategories'      => 'Categorías sin uso',
'unusedimages'          => 'Imágenes sin uso',
'popularpages'          => 'Páginas populares',
'wantedcategories'      => 'Categorías requeridas',
'wantedpages'           => 'Páginas requeridas',
'mostlinked'            => 'Artículos más enlazados',
'mostlinkedcategories'  => 'Categorías más enlazadas',
'mostcategories'        => 'Páginas con más categorías',
'mostimages'            => 'Imágenes más usadas',
'mostrevisions'         => 'Artículos con más ediciones',
'allpages'              => 'Todas las páginas',
'prefixindex'           => 'Páginas por prefijo',
'randompage'            => 'Página aleatoria',
'shortpages'            => 'Páginas cortas',
'longpages'             => 'Páginas largas',
'deadendpages'          => 'Páginas sin salida',
'listusers'             => 'Lista de usuarios',
'specialpages'          => 'Páginas especiales',
'spheading'             => 'Páginas especiales',
'restrictedpheading'    => 'Páginas especiales restringidas',
'recentchangeslinked'   => 'Seguimiento de enlaces',
'rclsub'                => '(a páginas enlazadas desde "$1")',
'newpages'              => 'Páginas nuevas',
'ancientpages'          => 'Artículos más antiguos',
'intl'                  => 'Enlaces interlenguaje',
'move'                  => 'Trasladar',
'movethispage'          => 'Trasladar esta página',
'unusedimagestext'      => '<p>Por favor note que otros sitios web
tales como otras {{SITENAME}}s pueden enlazar a una imagen
con un URL directo, y de esa manera todavía estar listada aquí
a pesar de estar en uso activo.',
'unusedcategoriestext'  => 'Las siguientes categorías han sido creadas, pero ningún artículo o categoría las emplea.',
'booksources'           => 'Fuentes de libros',
'categoriespagetext'    => 'Existen las siguientes categorías en este wiki.',
'data'                  => 'Datos',
'userrights'            => 'Configuración de permisos de usuarios',
'groups'                => 'Grupos de usuarios',
'booksourcetext'        => 'A continuación hay una lista de enlaces a otros sitios que venden libros nuevos y usados, y también pueden contener información adicional acerca de los libros que estás buscando.
{{SITENAME}} no está relacionada con ninguno de estos negocios, y esta lista no debe ser considerada un patrocinio de los mismos.',
'alphaindexline'        => '$1 a $2',
'version'               => 'Versión',
'log'                   => 'Registros',
'alllogstext'           => 'Presentación combinada de los registros de subidas, borrados, protecciones, bloqueos y administradores.
Puedes filtrar esta vista seleccionando el tipo de registro, el nombre de usuario, o la página afectada.',
'logempty'              => 'No hay elementos en el registro con esas condiciones.',
'nextpage'              => 'Siguiente página ($1)',
'allpagesfrom'          => 'Mostrar páginas comenzando en:',
'allarticles'           => 'Todos los artículos',
'allinnamespace'        => 'Todas las páginas (espacio $1)',
'allnotinnamespace'     => 'Todas las páginas (fuera del espacio $1)',
'allpagesprev'          => 'Anterior',
'allpagesnext'          => 'Siguiente',
'allpagessubmit'        => 'Mostrar',
'allpagesprefix'        => 'Mostrar páginas con el prefijo:',
'mailnologin'           => 'No enviar dirección',
'mailnologintext'       => 'Debes [[Special:Userlogin|iniciar sesión]] y tener una dirección electrónica válida en tus [[Special:Preferences|preferencias]] para enviar un correo electrónico a otros usuarios.',
'emailuser'             => 'Enviar correo electrónico a este usuario',
'emailpage'             => 'Correo electrónico a usuario',
'emailpagetext'         => 'Si este usuario ha registrado una dirección electrónica válida en sus preferencias de usuario, el siguiente formulario sirve para enviarle un mensaje.
La dirección electrónica que indicaste en tus preferencias de usuario aparecerá en el remitente para que el destinatario te pueda responder.',
'usermailererror'       => 'El objeto de correo devolvió un error:',
'defemailsubject'       => 'Correo de {{SITENAME}}',
'noemailtitle'          => 'No hay dirección electrónica',
'noemailtext'           => 'Este usuario no ha especificado una dirección electrónica válida, o ha elegido no recibir correo electrónico de otros usuarios.',
'emailfrom'             => 'De',
'emailto'               => 'Para',
'emailsubject'          => 'Asunto',
'emailmessage'          => 'Mensaje',
'emailsend'             => 'Enviar',
'emailsent'             => 'Correo electrónico enviado',
'emailsenttext'         => 'Tu correo electrónico ha sido enviado.',
'watchlist'             => 'Lista de seguimiento',
'nowatchlist'           => 'No tienes ninguna página en tu lista de seguimiento.',
'watchnologin'          => 'No has iniciado sesión',
'watchnologintext'      => 'Debes [[Special:Userlogin|iniciar sesión]] para modificar tu lista de seguimiento.',
'addedwatch'            => 'Añadido a la lista de seguimiento',
'addedwatchtext'        => 'La página «[[:$1]]» ha sido añadida a tu [[Special:Watchlist|lista se seguimiento]]. Cambios futuros en esta página y su página de discusión asociada se indicarán ahí, y la página aparecerá \'\'\'en negritas\'\'\' en la [[Special:Recentchanges|lista de cambios recientes]] para hacerla más fácil de detectar. <p>Cuando quieras eliminar la página de tu lista de seguimiento, presiona "Dejar de vigilar" en el menú.',
'removedwatch'          => 'Eliminada de la lista de seguimiento',
'removedwatchtext'      => 'La página "[[:$1]]" ha sido eliminada de tu lista de seguimiento.',
'watch'                 => 'Vigilar',
'watchthispage'         => 'Vigilar esta página',
'unwatch'               => 'Dejar de vigilar',
'unwatchthispage'       => 'Dejar de vigilar',
'notanarticle'          => 'No es un artículo',
'watchnochange'         => 'Ninguno de los artículos en tu lista de seguimiento fue editado en el periodo de tiempo mostrado.',
'watchdetails'          => '* $1 páginas vigiladas, sin contar las de discusión
* [[Special:Watchlist/edit|Mostrar y editar la lista de seguimiento]]',
'wlheader-enotif'       => '* La notificación por correo electrónico está habilitada',
'wlheader-showupdated'  => '* Las páginas modificadas desde tu última visita aparecen en \'\'\'negrita\'\'\'',
'watchmethod-recent'    => 'chequeando ediciones recientes en la lista de seguimiento',
'watchmethod-list'      => 'buscando ediciones recientes en la lista de seguimiento',
'removechecked'         => 'Borrar artículos seleccionados de la lista de seguimiento',
'watchlistcontains'     => 'Tu lista de seguimiento posee $1 páginas.',
'watcheditlist'         => 'Aquí está un listado alfabético de tu lista de seguimiento.
Selecciona los artículos que deseas eliminar de tu lista de seguimiento y
pulsa el botón \'Eliminar artículos seleccionados\' al final de la página.',
'removingchecked'       => 'Eliminando los artículos solicitados de la lista de seguimiento...',
'couldntremove'         => 'No se pudo borrar el artículo \'$1\'...',
'iteminvalidname'       => 'Problema con el artículo \'$1\', nombre inválido...',
'wlnote'                => 'Abajo están los últimos $1 cambios en las últimas <b>$2</b> horas.',
'wlshowlast'            => 'Mostrar las últimas $1 horas $2 días $3',
'wlsaved'               => 'Esta es una versión guardada de tu lista de seguimiento.',
'watchlist-show-bots' => 'Mostrar ediciones de bots',
'watchlist-hide-bots' => 'Esconder ediciones de bots',
'watchlist-show-own' => 'Mostrar mis ediciones',
'watchlist-hide-own' => 'Esconder mis ediciones',

'enotif_mailer'         => 'Notificación por correo de {{SITENAME}}',
'enotif_reset'          => 'Marcar todas las páginas visitadas',
'enotif_newpagetext'    => 'Se trata de una nueva página.',
'changed'               => 'modificada',
'created'               => 'creada',
'enotif_subject'        => 'La página $PAGETITLE de {{SITENAME}} ha sido $CHANGEDORCREATED por $PAGEEDITOR',
'enotif_lastvisited'    => 'Vaya a $1 para ver todos los cambios desde su última visita.',
'enotif_body'           => 'Estimado/a $WATCHINGUSERNAME,

La página de {{SITENAME}} «$PAGETITLE»
ha sido $CHANGEDORCREATED por el usuario $PAGEEDITOR el $PAGEEDITDATE.
La versión actual se encuentra en {{fullurl:$PAGETITLE_RAWURL}}

$NEWPAGE

El resumen de edición es: $PAGESUMMARY $PAGEMINOREDIT

Para comunicarse con el usuario:
por correo: {{fullurl:Especial:Emailuser|target=$PAGEEDITOR_RAWURL}}
en el wiki: {{fullurl:Usuaro:$PAGEEDITOR_RAWURL}}

Para recibir nuevas notificaciones de cambios de esta página, deberá vistarla nuevamente.
También puede, en su lista de seguimiento, modificar las opciones de notificación de sus
páginas vigiladas.

             El sistema de notificación de {{SITENAME}}.

--
Cambie las opciones de su lista de seguimiento en:
{{fullurl:Especial:Watchlist|edit=yes}}',
'deletepage'            => 'Borrar esta página',
'confirm'               => 'Confirmar',
'excontent'             => 'El contenido era: \'$1\'',
'excontentauthor'       => 'El contenido era: \'$1\' (y el único autor fue \'$2\')',
'exbeforeblank'         => 'contenido antes de borrar era: \'$1\'',
'exblank'               => 'página estaba vacía',
'confirmdelete'         => 'Confirma el borrado',
'deletesub'             => '(Borrando "$1")',
'historywarning'        => 'Atención: La página que estás por borrar tiene un historial:',
'confirmdeletetext'     => 'Estás a punto de borrar una página o imagen
en forma permanente,
así como todo su historial, de la base de datos.
Por favor, confirma que realmente quieres hacer eso, que entiendes las
consecuencias, y que lo estás haciendo de acuerdo con [[Project:Políticas]].',
'actioncomplete'        => 'Acción completa',
'deletedtext'           => '"$1" ha sido borrado.
Véase $2 para un registro de los borrados recientes.',
'deletedarticle'        => 'borrado "$1"',
'dellogpage'            => 'Registro de borrados',
'dellogpagetext'        => 'Abajo hay una lista de los borrados más recientes.
Todos los tiempos se muestran en hora del servidor (UTC).
<ul>
</ul>',
'deletionlog'           => 'registro de borrados',
'reverted'              => 'Recuperar una revisión anterior',
'deletecomment'         => 'Razón para el borrado',
'imagereverted'         => 'Revertido a una versión anterior tuvo éxito.',
'rollback'              => 'Revertir ediciones',
'rollback_short'        => 'Revertir',
'rollbacklink'          => 'Revertir',
'rollbackfailed'        => 'Reversión fallida',
'cantrollback'          => 'No se pueden revertir las ediciones; el último colaborador es el único autor de este artículo.',
'alreadyrolled'         => 'No se puede revertir la última edición de [[:$1]] por [[User:$2|$2]] ([[User talk:$2|discusión]]); alguien más ya ha editado o revertido esa página. La última edición fue hecha por [[User:$3|$3]] ([[User talk:$3|discusión]]).',
'editcomment'           => 'El resumen de la edición fue: "<i>$1</i>".',
'revertpage'            => 'Revertidas las ediciones realizadas por [[Special:Contributions/$2|$2]] ([[User talk:$2|Talk]]); hacia la última versión por [[User:$1|$1]]',
'sessionfailure'        => 'Parece que hay un problema con tu sesión;
esta acción ha sido cancelada como medida de precaución contra secuestros de sesión.
Por favor, pulsa "Retroceder", recarga la página de la que viniste e inténtalo de nuevo.',
'protectlogpage'        => 'Protecciones de páginas',
'protectlogtext'        => 'Abajo se presenta una lista de protección y desprotección de página.
Véase [[Project:Esta página está protegida]] para más información.',
'protectedarticle'      => 'protegió [[$1]]',
'unprotectedarticle'    => 'desprotegió [[$1]]',
'protectsub'            => '(Protegiendo "$1")',
'confirmprotecttext'    => '¿Realmente deseas proteger esta página?',
'confirmprotect'        => 'Confirmar protección',
'protectmoveonly'       => 'Proteger sólo contra traslados',
'protectcomment'        => 'Razón para proteger',
'unprotectsub'          => '(Desprotegiendo "$1")',
'confirmunprotecttext'  => '¿Realmente deseas desproteger esta página?',
'confirmunprotect'      => 'Confirmar la desprotección.',
'unprotectcomment'      => 'Razón para desproteger',
'protect-unchain'       => 'Configurar permisos para traslados',
'protect-text'          => 'Puedes visualizar y modificar el nivel de protección de [[$1]].
Por favor, asegúrate de que sigues las [[Project:Políticas de protección de páginas|políticas de protección de páginas]].',
'protect-viewtext'      => 'No tienes permiso para modificar los niveles de protección de esta página. Los niveles de protección actuales para [[$1]] son:',
'protect-default'       => '(por defecto)',
'protect-level-autoconfirmed'=> 'Bloquear usuarios no registrados',
'protect-level-sysop'   => 'Sólo administradores',
'undelete'              => 'Restaurar una página borrada',
'undeletepage'          => 'Ver y restaurar páginas borradas',
'viewdeletedpage'       => 'Ver páginas borradas',
'undeletepagetext'      => 'Las siguientes páginas han sido borradas pero aún están en el archivo y pueden ser restauradas. El archivo puede ser limpiado periódicamente.',
'undeletearticle'       => 'Restaurar página borrada',
'undeleterevisions'     => '$1 revisiones archivadas',
'undeletehistory'       => 'Si restauras una página, todas las revisiones serán restauradas al historial.
Si una nueva página con el mismo nombre ha sido creada desde el borrado, las versiones restauradas aparecerán como historial anterior, y la revisión actual de la página "viva" no será automáticamente reemplazada.',
'undeletehistorynoadmin'=> 'El artículo ha sido borrado. La razón de su eliminación se indica abajo en el sumario, así como el detalle de las ediciones realizadas antes del borrado. El texto completo del artículo está disponible sólo para usuarios con permisos de [[Project:Administradores|administrador]].',
'undeleterevision'      => 'Revisión borrada al $1',
'undeletebtn'           => '¡Restaurar!',
'undeletedarticle'      => 'restaurado "$1"',
'undeletedrevisions'    => '{{PLURAL:$1|Una edición restaurada|$1 ediciones restauradas}}',
'namespace'             => 'Espacio de nombres:',
'invert'                => 'Invertir selección',
'contributions'         => 'Contribuciones del usuario',
'mycontris'             => 'Mis contribuciones',
'contribsub'            => '$1',
'nocontribs'            => 'No se encontraron cambios que cumplieran estos criterios.',
'ucnote'                => 'Abajo están los últimos <b>$1</b> cambios de este usuario en los últimos <b>$2</b> días.',
'uclinks'               => 'Ver los últimos $1 cambios; ver los últimos $2 días.',
'uctop'                 => ' (última modificación)',
'newbies'               => 'noveles',
'whatlinkshere'         => 'Lo que enlaza aquí',
'notargettitle'         => 'No hay página objetivo',
'notargettext'          => 'No has especificado en qué página
llevar a cabo esta función.',
'linklistsub'           => '(Lista de enlaces)',
'linkshere'             => 'Las siguientes páginas enlazan aquí:',
'nolinkshere'           => 'Ninguna página enlaza aquí.',
'isredirect'            => 'página redirigida',
'blockip'               => 'Bloquear usuario',
'blockiptext'           => 'Usa el formulario siguiente para bloquear el
acceso de escritura desde una dirección IP específica o un nombre de usuario.
Esto debería hacerse sólo para prevenir vandalismos, y de
acuerdo a las [[Project:Políticas|políticas de {{SITENAME}}]].
Explica la razón específica del bloqueo (por ejemplo, citando
las páginas en particular que han sido objeto de vandalismo).',
'ipaddress'             => 'Dirección IP',
'ipadressorusername'    => 'Dirección IP o nombre de usuario',
'ipbexpiry'             => 'Caduca dentro de',
'ipbreason'             => 'Razón',
'ipbsubmit'             => 'Bloquear esta dirección',
'ipbother'              => 'Especificar caducidad',
'ipboptions'            => '15 minutos:15 minutes,media hora:30 minutes,una hora:1 hour,2 horas:2 hours,un día:1 day,3 días:3 days,una semana:1 week,2 semanas:2 weeks,un mes:1 month,para siempre:infinite',
'ipbotheroption'        => 'Otro tiempo',
'badipaddress'          => 'La dirección IP no tiene el formato correcto.',
'blockipsuccesssub'     => 'Bloqueo exitoso',
'blockipsuccesstext'    => 'La dirección IP "$1" ha sido bloqueada. <br />Ver [[Special:Ipblocklist|lista de IP bloqueadas]] para revisar bloqueos.',
'unblockip'             => 'Desbloquear usuario',
'unblockiptext'         => 'Usa el formulario que sigue para restaurar el
acceso de escritura a una dirección IP previamente bloqueada.',
'ipusubmit'             => 'Desbloquear esta dirección',
'ipblocklist'           => 'Lista de direcciones IP bloqueadas',
'blocklistline'         => '$1, $2 bloquea $3 ($4)',
'infiniteblock'         => 'infinito',
'expiringblock'         => 'expira $1',
'ipblocklistempty'      => 'La lista de bloqueo está vacía.',
'blocklink'             => 'bloquear',
'unblocklink'           => 'desbloquear',
'contribslink'          => 'contribuciones',
'autoblocker'           => 'Has sido bloqueado automáticamente porque tu dirección IP ha sido usada recientemente por "[[User:$1|$1]]". La razón esgrimida para bloquear a "[[User:$1|$1]]" fue "$2".',
'blocklogpage'          => 'Bloqueos de usuarios',
'blocklogentry'         => 'bloqueó a "$1" durante un plazo de "$2".',
'blocklogtext'          => 'Esto es un registro de bloqueos y desbloqueos de usuarios. Las direcciones bloqueadas automáticamente no están listadas. Vea el [[Special:Ipblocklist|listado de bloqueos de IP]] para la lista de prohibiciones y bloqueos actualmente vigente.',
'unblocklogentry'       => 'desbloqueó a "$1"',
'range_block_disabled'  => 'La facultad de administrador de crear bloqueos de rango está deshabilitada.',
'ipb_expiry_invalid'    => 'Tiempo de caducidad no válido.',
'ip_range_invalid'      => 'Rango de IP no es válido.',
'proxyblocker'          => 'Bloqueador de proxies',
'proxyblockreason'      => 'Tu dirección IP ha sido bloqueada porque es un proxy abierto. Por favor, contacta con tu proveedor de servicios de Internet o con tu servicio de asistencia técnica e infórmales de este grave problema de seguridad.',
'proxyblocksuccess'     => 'Hecho.',
'sorbsreason'           => 'Tu dirección IP está listada como proxy abierto en [http://www.sorbs.net SORBS] DNSBL.',
'sorbs_create_account_reason'=> 'Tu dirección IP está listada como proxy abierto en [http://www.sorbs.net SORBS] DNSBL. No puedes crear una cuenta',
'lockdb'                => 'Bloquear la base de datos',
'unlockdb'              => 'Desbloquear la base de datos',
'lockdbtext'            => 'El bloqueo de la base de datos impedirá a todos los usuarios editar páginas, cambiar sus preferencias, modificar sus listas de seguimiento y cualquier otra función que requiera realizar cambios en la base de datos. Por favor, confirma que ésto es precisamente lo que quieres hacer y que desbloquearás la base de datos tan pronto hayas finalizado las operaciones de mantenimiento.',
'unlockdbtext'          => 'El desbloqueo de la base de datos permitirá a todos los usuarios editar páginas, cambiar sus preferencias, modificar sus listas de seguimiento y cualesquiera otras funciones que impliquen modificar la base de datos. Por favor, confirma que esto es precisamente lo que quieres hacer.',
'lockconfirm'           => 'Sí, realmente quiero bloquear la base de datos.',
'unlockconfirm'         => 'Sí, realmente quiero desbloquear la base de datos.',
'lockbtn'               => 'Bloquear la base de datos',
'unlockbtn'             => 'Desbloquear la base de datos',
'locknoconfirm'         => 'No has confirmado lo que deseas hacer.',
'lockdbsuccesssub'      => 'El bloqueo se ha realizado con éxito',
'unlockdbsuccesssub'    => 'El desbloqueo se ha realizado con éxito',
'lockdbsuccesstext'     => 'La base de datos de {{SITENAME}} ha sido bloqueada.
<br />Recuerda retirar el bloqueo después de completar las tareas de mantenimiento.',
'unlockdbsuccesstext'   => 'La base de datos de {{SITENAME}} ha sido desbloqueada.',
'makesysoptitle'        => 'Convertir a este usuario en administrador',
'makesysoptext'         => 'Con este formulario los burócratas pueden convertir usuarios normales en administradores.
Escribe el nombre del usuario en la caja y pulsa el botón para convertir a este usuario en administrador.',
'makesysopname'         => 'Nombre del usuario:',
'makesysopsubmit'       => 'Convertir en administrador',
'makesysopok'           => '<b>El usuario "$1" es ahora un administrador</b>',
'makesysopfail'         => '<b>No se pudo convertir al usuario "$1" en administrador. (¿Escribiste su nombre correctamente?)</b>',
'setbureaucratflag'     => 'Establecer la condición de burócrata',
'rightslogtext'         => 'Este es un registro de cambios a los permisos de usuarios.',
'rights'                => 'Permisos:',
'set_user_rights'       => 'Establecer permisos de usuario',
'user_rights_set'       => '<b>Permisos para "$1" actualizados</b>',
'set_rights_fail'       => '<b>Permisos para "$1" no se han podido establecer. (¿Escribiste su nombre correctamente?)</b>',
'makesysop'             => 'Convertir a un usuario en administrador',
'already_sysop'         => 'Este usuario ya es un administrador',
'already_bureaucrat'    => 'Este usuario ya es un burócrata',
'movepage'              => 'Renombrar página',
'movepagetext'          => 'Usando el formulario que sigue renombrará una página,
moviendo todo su historial al nombre nuevo.
El título anterior se convertirá en un redireccionamiento al nuevo título.
Los enlaces al antiguo título de la página no se cambiarán. Asegúrate de no dejar redirecciones dobles o rotas.
Tú eres responsable de hacer que los enlaces sigan apuntando adonde se supone que lo deberían hacer.

Recuerda que la página \'\'\'no\'\'\' será renombrada si ya existe una página con el nuevo título, a no ser que sea una página vacía o un \'\'redirect\'\' sin historial.
Esto significa que podrás renombrar una página a su título original si has cometido un error, pero que no podrás sobreescribir una página existente.

<b>¡ADVERTENCIA!</b>
Este puede ser un cambio drástico e inesperado para una página popular;
por favor, asegúrate de entender las consecuencias que acarreará
antes de seguir adelante.',
'movepagetalktext'      => 'La página de discusión asociada, si existe, será renombrada automáticamente \'\'\'a menos que:\'\'\'
*Estés moviendo la página entre espacios de nombre diferentes,
*Una página de discusión no vacía ya existe con el nombre nuevo, o
*Desactivaste la opción "Renombrar la página de discusión también".

En estos casos, deberás trasladar manualmente el contenido de la página de discusión.',
'movearticle'           => 'Renombrar página',
'movenologin'           => 'No has iniciado sesión',
'movenologintext'       => 'Es necesario ser usuario registrado y [[Special:Userlogin|haber iniciado sesión]] para renombrar una página.',
'newtitle'              => 'A título nuevo',
'movepagebtn'           => 'Renombrar página',
'pagemovedsub'          => 'Renombrado realizado',
'pagemovedtext'         => 'Página "[[$1]]" renombrada a "[[$2]]".',
'articleexists'         => 'Ya existe una página con ese nombre, o el nombre que has
escogido no es válido.
Por favor, elige otro nombre.',
'talkexists'            => 'La página fue renombrada con éxito, pero la página de discusión no se pudo mover porque ya existe una en el título nuevo. Por favor incorpora su contenido manualmente.',
'movedto'               => 'renombrado a',
'movetalk'              => 'Renombrar la página de discusión también, si es aplicable.',
'talkpagemoved'         => 'La página de discusión correspondiente también fue renombrada.',
'talkpagenotmoved'      => 'La página de discusión correspondiente <strong>no</strong> fue renombrada.',
'1movedto2'             => '[[$1]] trasladada a [[$2]]',
'1movedto2_redir'       => '[[$1]] trasladada a [[$2]] sobre una redirección',
'movelogpage'           => 'Registro de renombrados',
'movelogpagetext'       => 'Abajo se encuentra una lista de páginas renombradas.',
'movereason'            => 'Motivo',
'revertmove'            => 'revertir',
'delete_and_move'       => 'Borrar y trasladar',
'delete_and_move_text'  => '==Se necesita borrado==

La página de destino ("[[$1]]") ya existe. ¿Quieres borrarla para dejar paso al traslado?',
'delete_and_move_reason'=> 'Borrada para dejar paso al traslado',
'selfmove'              => 'Los títulos de origen y destino son los mismos; no se puede trasladar un página sobre sí misma.',
'immobile_namespace'    => 'El título de destino es de un tipo especial; no se pueden trasladar página a ese espacio de nombres.',
'export'                => 'Exportar páginas',
'exporttext'            => 'Puedes exportar el texto y el historial de edición de una página en particular o de un conjunto de páginas a un texto XML. En el futuro, este texto podría posteriormente importarse en otro wiki que ejecutase MediaWiki, sin embargo esta capacidad no está aún disponible en la versión actual.

Para exportar páginas, escribe los títulos en la caja de texto de abajo, un título por línea, y selecciona si quieres la versión actual junto a las versiones anteriores, con las líneas del historial, o sólo la versión actual con la información sobre la última edición.

En el último caso puedes usar un enlace, por ejemplo [[Special:Export/{{Mediawiki:Mainpage}}]] for the page {{Mediawiki:Mainpage}}.',
'exportcuronly'         => 'Sólo incluir la revisión actual, no el historial completo',
'allmessages'           => 'Todos los mensajes de MediaWiki',
'allmessagesname'       => 'Nombre',
'allmessagesdefault'    => 'Texto predeterminado',
'allmessagescurrent'    => 'Texto actual',
'allmessagestext'       => 'Esta es una lista de mensajes del sistema disponibles en el espacio de nombres MediaWiki:.',
'allmessagesnotsupportedUI'=> 'Tu lengua de interfaz actual (<b>$1</b>) no está disponible en Special:AllMessages en este sitio.',
'allmessagesnotsupportedDB'=> 'Special:AllMessages no está disponible porque wgUseDatabaseMessages está deshabilitado.',
'thumbnail-more'        => 'Aumentar',
'missingimage'          => '<b>Falta imagen</b><br /><i>$1</i>',
'filemissing'           => 'Falta archivo',
'import'                => 'Importar páginas',
'importinterwiki'       => 'Importación transwiki',
'importtext'            => 'Por favor, exporta el archivo desde el wiki de origen usando la utilidad Special:Export, guárdalo en tu disco y súbelo aquí.',
'importfailed'          => 'La importación ha fallado: $1',
'importnotext'          => 'Vacío o sin texto',
'importsuccess'         => '¡La importación tuvo éxito!',
'importhistoryconflict' => 'Existen revisiones en el historial con conflicto (puede que se haya importado esta página antes)',
'importnosources'       => 'No hay fuentes de importación transwiki y las subidas directas de historial están deshabilitadas.',
'importnofile'          => 'No se subieron archivos de importación.',
'importuploaderror'     => 'La subida del archivo de importación ha fallado; quizá el archivo es mayor que el tamaño de subida permitido.',
'tooltip-search'        => 'Buscar en este wiki [alt-f]',
'tooltip-minoredit'     => 'Marcar este cambio como menor [alt-i]',
'tooltip-save'          => 'Guardar tus cambios [alt-s]',
'tooltip-preview'       => 'Previsualiza tus cambios, ¡por favor, usa esto antes de grabar! [alt-p]',
'tooltip-diff'          => 'Muestra los cambios que has introducido en el texto. [alt-v]',
'tooltip-compareselectedversions'=> 'Ver las diferencias entre las dos versiones seleccionadas de esta página. [alt-v]',
'tooltip-watch'         => 'Añadir esta página a tu lista de seguimiento [alt-w]',
'monobook.css'          => '/* cambia este archivo para personalizar la piel monobook para el sitio entero */',
'nodublincore'          => 'Metadatos Dublin Core RDF deshabilitados en este servidor.',
'nocreativecommons'     => 'Metadatos Creative Commons RDF deshabilitados en este servidor.',
'notacceptable'         => 'El servidor wiki no puede proveer los datos en un formato que tu cliente (navegador) pueda entender.',
'anonymous'             => 'Usuario(s) anónimo(s) de {{SITENAME}}',
'siteuser'              => 'Usuario $1 de {{SITENAME}}',
'lastmodifiedatby'        => 'Esta página fue modificada por última vez en $2, $1 por $3.',
'and'                   => 'y',
'othercontribs'         => 'Basado en el trabajo de $1.',
'others'                => 'otros',
'siteusers'             => 'Usuario(s) $1 de {{SITENAME}}',
'creditspage'           => 'Créditos de la página',
'nocredits'             => 'Hay información de créditos para esta página.',
'spamprotectiontitle'   => 'Filtro de protección contra spam',
'spamprotectiontext'    => 'La página que intentas guardar ha sido bloqueada por el filtro de spam. Esto se debe probablemente a alguno de los un enlaces externos incluidos en ella.

La siguiente expresión regular define los enlaces que se encuentran bloqueados en este momento:',
'spamprotectionmatch'   => 'El siguiente texto es el que activó nuestro filtro \'\'anti-spam\'\' (contra la publicidad no solicitada): $1',
'subcategorycount'      => 'Hay {{PLURAL:$1|una subcategoría|$1 subcategorías}} en esta categoría.',
'categoryarticlecount'  => 'Hay $1 {{PLURAL:$1|artículo|artículos}} en esta categoría.',
'infosubtitle'          => 'Información de la página',
'numedits'              => 'Número de ediciones (artículo): $1',
'numtalkedits'          => 'Número de ediciones (página de discusión): $1',
'numwatchers'           => 'Número de usuarios vigilándola: $1',
'numauthors'            => 'Número de autores distintos (artículo): $1',
'numtalkauthors'        => 'Número de autores distintos (página de discusión): $1',
'mw_math_png'           => 'Producir siempre PNG',
'mw_math_simple'        => 'HTML si es muy simple, si no, PNG',
'mw_math_html'          => 'HTML si es posible, si no, PNG',
'mw_math_source'        => 'Dejar como TeX (para navegadores de texto)',
'mw_math_modern'        => 'Recomendado para navegadores modernos',
'mw_math_mathml'        => 'MathML',
'markaspatrolleddiff'   => 'Marcar como revisado',
'markaspatrolledtext'   => 'Marcar este artículo como revisado',
'markedaspatrolled'     => 'Marcar como revisado',
'markedaspatrolledtext' => 'La versión seleccionada ha sido marcada como revisada.',
'rcpatroldisabled'      => 'Revisión de los Cambios Recientes deshabilitada',
'rcpatroldisabledtext'  => 'La capacidad de revisar los Cambios Recientes está deshabilitada en este momento.',
'monobook.js'           => '/* tooltips and access keys */
 var ta = new Object();
 ta[\'pt-userpage\'] = new Array(\'.\',\'Mi página de usuario\');
 ta[\'pt-anonuserpage\'] = new Array(\'.\',\'La página de usuario de la IP desde la que editas\');
 ta[\'pt-mytalk\'] = new Array(\'n\',\'Mi página de discusión\');
 ta[\'pt-anontalk\'] = new Array(\'n\',\'Discusión sobre ediciones hechas desde esta dirección IP\');
 ta[\'pt-preferences\'] = new Array(\'\',\'Mis preferencias\');
 ta[\'pt-watchlist\'] = new Array(\'l\',\'La lista de páginas para las que estás vigilando los cambios\');
 ta[\'pt-mycontris\'] = new Array(\'y\',\'Lista de mis contribuciones\');
 ta[\'pt-login\'] = new Array(\'o\',\'Te animamos a registrarte, aunque no es obligatorio\');
 ta[\'pt-anonlogin\'] = new Array(\'o\',\'Te animamos a registrarte, aunque no es obligatorio\');
 ta[\'pt-logout\'] = new Array(\'\',\'Salir de la sesión\');
 ta[\'ca-talk\'] = new Array(\'t\',\'Discusión acerca del artículo\');
 ta[\'ca-edit\'] = new Array(\'e\',\'Puedes editar esta página. Por favor, usa el botón de previsualización antes de grabar.\');
 ta[\'ca-addsection\'] = new Array(\'+\',\'Añade un comentario a esta discusión\');
 ta[\'ca-viewsource\'] = new Array(\'e\',\'Esta página está protegida, sólo puedes ver su código fuente\');
 ta[\'ca-history\'] = new Array(\'h\',\'Versiones anteriores de esta página y sus autores\');
 ta[\'ca-protect\'] = new Array(\'=\',\'Proteger esta página\');
 ta[\'ca-delete\'] = new Array(\'d\',\'Borrar esta página\');
 ta[\'ca-undelete\'] = new Array(\'d\',\'Restaurar las ediciones hechas a esta página antes de que fuese borrada\');
 ta[\'ca-move\'] = new Array(\'m\',\'Trasladar (renombrar) esta página\');
 ta[\'ca-watch\'] = new Array(\'w\',\'Añadir esta página a tu lista de seguimiento\');
 ta[\'ca-unwatch\'] = new Array(\'w\',\'Borrar esta página de tu lista de seguimiento\');
 ta[\'search\'] = new Array(\'f\',\'Buscar en este wiki\');
 ta[\'p-logo\'] = new Array(\'\',\'Portada\');
 ta[\'n-mainpage\'] = new Array(\'z\',\'Visitar la Portada\');
 ta[\'n-portal\'] = new Array(\'\',\'Acerca del proyecto, qué puedes hacer, dónde encontrar información\');
 ta[\'n-currentevents\'] = new Array(\'\',\'Información de contexto sobre acontecimientos actuales\');
 ta[\'n-recentchanges\'] = new Array(\'r\',\'La lista de cambios recientes en el wiki\');
 ta[\'n-randompage\'] = new Array(\'x\',\'Cargar una página aleatoriamente\');
 ta[\'n-help\'] = new Array(\'\',\'El lugar para aprender\');
 ta[\'n-sitesupport\'] = new Array(\'\',\'Respáldanos\');
 ta[\'t-whatlinkshere\'] = new Array(\'j\',\'Lista de todas las páginas del wiki que enlazan con ésta\');
 ta[\'t-recentchangeslinked\'] = new Array(\'k\',\'Cambios recientes en las páginas que enlazan con esta otra\');
 ta[\'feed-rss\'] = new Array(\'\',\'Sindicación RSS de esta página\');
 ta[\'feed-atom\'] = new Array(\'\',\'Sindicación Atom de esta página\');
 ta[\'t-contributions\'] = new Array(\'\',\'Ver la lista de contribuciones de este usuario\');
 ta[\'t-emailuser\'] = new Array(\'\',\'Enviar un mensaje de correo a este usuario\');
 ta[\'t-upload\'] = new Array(\'u\',\'Subir imágenes o archivos multimedia\');
 ta[\'t-specialpages\'] = new Array(\'q\',\'Lista de todas las páginas especiales\');
 ta[\'ca-nstab-main\'] = new Array(\'c\',\'Ver el artículo\');
 ta[\'ca-nstab-user\'] = new Array(\'c\',\'Ver la página de usuario\');
 ta[\'ca-nstab-media\'] = new Array(\'c\',\'Ver la página de multimedia\');
 ta[\'ca-nstab-special\'] = new Array(\'\',\'Esta es una página especial, no se puede editar la página en sí\');
 ta[\'ca-nstab-project\'] = new Array(\'a\',\'Ver la página de proyecto\');
 ta[\'ca-nstab-image\'] = new Array(\'c\',\'Ver la página de la imagen\');
 ta[\'ca-nstab-mediawiki\'] = new Array(\'c\',\'Ver el mensaje de sistema\');
 ta[\'ca-nstab-template\'] = new Array(\'c\',\'Ver la plantilla\');
 ta[\'ca-nstab-help\'] = new Array(\'c\',\'Ver la página de ayuda\');
 ta[\'ca-nstab-category\'] = new Array(\'c\',\'Ver la página de categoría\');',
'deletedrevision'       => 'Borrada revisión antigua $1.',
'previousdiff'          => '← Ir a diferencia anterior',
'nextdiff'              => 'Ir a siguiente diferencia →',
'imagemaxsize'          => 'Limitar imágenes en las páginas de descripción a:',
'thumbsize'             => 'Tamaño de diapositivas:',
'showbigimage'          => 'Descargar versión de alta resolución ($1×$2, $3 KB)',
'newimages'             => 'Galería de imágenes nuevas',
'noimages'              => 'No hay nada que ver.',
'specialloguserlabel'   => 'Usuario:',
'speciallogtitlelabel'  => 'Título:',
'passwordtooshort'      => 'Tu contraseña es muy corta. Debe tener al menos $1 caracteres.',
'mediawarning'          => '\'\'\'Aviso\'\'\': Este archivo podría contener código malicioso, ejecutándolo tu sistema podría resultar comprometido.<hr />',
'fileinfo'              => '$1KB, tipo MIME: <code>$2</code>',
'metadata'              => 'Metadatos',
'metadata-help'         => 'Este archivo contiene información adicional (metadatos), probablemente añadida por la cámara digital, el escáner o el programa usado para crearlo o digitalizarlo. Si el archivo ha sido modificado desde su estado original, pueden haberse perdido algunos detalles.',
'metadata-expand'       => 'Mostrar datos detallados',
'metadata-collapse'     => 'Ocultar datos detallados',
'exif-imagewidth'       => 'Anchura',
'exif-imagelength'      => 'Altura',
'exif-bitspersample'    => 'Bits por componente',
'exif-compression'      => 'Esquema de compresión',
'exif-photometricinterpretation'=> 'Composición de pixel',
'exif-orientation'      => 'Orientación',
'exif-samplesperpixel'  => 'Número de componentes',
'exif-planarconfiguration'=> 'Distribución de datos',
'exif-ycbcrsubsampling' => 'Razón de submuestreo de Y a C',
'exif-ycbcrpositioning' => 'Posicionamientos Y y C',
'exif-xresolution'      => 'Resolución horizontal',
'exif-yresolution'      => 'Resolución vertical',
'exif-resolutionunit'   => 'Unidad de resolución X e Y',
'exif-stripoffsets'     => 'Localización de datos de imagen',
'exif-rowsperstrip'     => 'Número de filas por banda',
'exif-stripbytecounts'  => 'Bytes por banda comprimida',
'exif-jpeginterchangeformat'=> 'Desplazamiento al JPEG SOI',
'exif-jpeginterchangeformatlength'=> 'Bytes de datos JPEG',
'exif-transferfunction' => 'Función de transferencia',
'exif-whitepoint'       => 'Cromaticidad de punto blanco',
'exif-primarychromaticities'=> 'Cromaticidades de primaridades',
'exif-ycbcrcoefficients'=> 'Coeficientes de matriz de transformación de espacio de color',
'exif-referenceblackwhite'=> 'Pareja de valores negro y blanco de referencia',
'exif-datetime'         => 'Fecha y hora de modificación del archivo',
'exif-imagedescription' => 'Título de la imagen',
'exif-make'             => 'Fabricante de la cámara',
'exif-model'            => 'Modelo de cámara',
'exif-software'         => 'Software usado',
'exif-artist'           => 'Autor',
'exif-copyright'        => 'Titular de los derechos de autor',
'exif-exifversion'      => 'Versión Exif',
'exif-flashpixversion'  => 'Versión admitida de Flashpix',
'exif-colorspace'       => 'Espacio de color',
'exif-componentsconfiguration'=> 'Significado de cada componente',
'exif-compressedbitsperpixel'=> 'Modo de compresión de la imagen',
'exif-pixelydimension'  => 'Anchura de imagen válida',
'exif-pixelxdimension'  => 'Altura de imagen válida',
'exif-makernote'        => 'Notas del fabricante',
'exif-usercomment'      => 'Comentarios de usuario',
'exif-relatedsoundfile' => 'Archivo de audio relacionado',
'exif-datetimeoriginal' => 'Fecha y hora de la generación de los datos',
'exif-datetimedigitized'=> 'Fecha y hora de la digitalización',
'exif-exposuretime'     => 'Tiempo de exposición',
'exif-fnumber'          => 'Número F',
'exif-exposureprogram'  => 'Programa de exposición',
'exif-spectralsensitivity'=> 'Sensibilidad espectral',
'exif-isospeedratings'  => 'Calificación de velocidad ISO',
'exif-oecf'             => 'Factor de conversión optoelectrónica',
'exif-shutterspeedvalue'=> 'Velocidad de obturador',
'exif-aperturevalue'    => 'Apertura',
'exif-brightnessvalue'  => 'Luminosidad',
'exif-exposurebiasvalue'=> 'Sesgo de exposición',
'exif-maxaperturevalue' => 'Apertura máxima de tierra',
'exif-subjectdistance'  => 'Distancia al sujeto',
'exif-meteringmode'     => 'Modo de medición',
'exif-lightsource'      => 'Fuente de luz',
'exif-focallength'      => 'Longitud de la lente focal',
'exif-subjectarea'      => 'Área del sujeto',
'exif-flashenergy'      => 'Energía del flash',
'exif-spatialfrequencyresponse'=> 'Respuesta de frecuencia espacial',
'exif-focalplanexresolution'=> 'Resolución X plano focal',
'exif-focalplaneyresolution'=> 'Resolución Y plano focal',
'exif-focalplaneresolutionunit'=> 'Unidad de resolución del plano focal',
'exif-subjectlocation'  => 'Localización del sujeto',
'exif-exposureindex'    => 'Índice de exposición',
'exif-sensingmethod'    => 'Método de sensor',
'exif-filesource'       => 'Fuente de archivo',
'exif-scenetype'        => 'Tipo de escena',
'exif-cfapattern'       => 'Patrón CFA',
'exif-customrendered'   => 'Procesador personalizado de imagen',
'exif-exposuremode'     => 'Modo de exposición',
'exif-whitebalance'     => 'Balance de blanco',
'exif-digitalzoomratio' => 'Razón de zoom digital',
'exif-focallengthin35mmfilm'=> 'Longitud focal en película de 35 mm',
'exif-scenecapturetype' => 'Tipo de captura de escena',
'exif-gaincontrol'      => 'Control de escena',
'exif-contrast'         => 'Contraste',
'exif-saturation'       => 'Saturación',
'exif-sharpness'        => 'Agudeza',
'exif-devicesettingdescription'=> 'Descripción de los ajustes del dispositivo',
'exif-subjectdistancerange'=> 'Rango de distancia al sujeto',
'exif-imageuniqueid'    => 'ID único de imagen',
'exif-gpslatituderef'   => 'Latitud norte o sur',
'exif-gpslatitude'      => 'Latitud',
'exif-gpslongituderef'  => 'Longitud este u oeste',
'exif-gpslongitude'     => 'Longitud',
'exif-gpsaltituderef'   => 'Refencia de altitud',
'exif-gpsaltitude'      => 'Altitud',
'exif-gpssatellites'    => 'Satélites usados para la medición',
'exif-gpsmeasuremode'   => 'Modo de medición',
'exif-gpsdop'           => 'Precisión de medición',
'exif-gpsspeedref'      => 'Unidad de velocidad',
'exif-gpsspeed'         => 'Velocidad del receptor GPS',
'exif-gpsimgdirectionref'=> 'Referencia de la dirección de imágen',
'exif-gpsimgdirection'  => 'Dirección de imágen',
'exif-gpsdestlatituderef'=> 'Referencia para la latitud del destino',
'exif-gpsdestlatitude'  => 'Destino de latitud',
'exif-gpsdestlongituderef'=> 'Referencia para la longitud del destino',
'exif-gpsdestlongitude' => 'Longitud del destino',
'exif-gpsdestbearingref'=> 'Referencia para la orientación al destino',
'exif-gpsdestbearing'   => 'Orientación del destino',
'exif-gpsdestdistanceref'=> 'Referencia para distancia al destination',
'exif-gpsdestdistance'  => 'Distancia al destino',
'exif-gpsprocessingmethod'=> 'Nombre del método de procesado GPS',
'exif-gpsareainformation'=> 'Nombre de la área GPS',
'exif-gpsdatestamp'     => 'Fecha GPS',
'exif-gpsdifferential'  => 'Corrección diferencial de GPS',
'exif-compression-1'    => 'No comprimida',
'exif-orientation-2'    => 'Volteada horizontalmente',
'exif-orientation-3'    => 'Rotada 180°',
'exif-orientation-4'    => 'Volteada verticalmente',
'exif-orientation-5'    => 'Rotada 90° CCW y volteada verticalmente',
'exif-orientation-6'    => 'Rotada 90° CW',
'exif-orientation-7'    => 'Rotada 90° CW y volteada verticalmente',
'exif-orientation-8'    => 'Rotada 90° CCW',
'exif-planarconfiguration-1'=> 'formato rechoncho (chunky)',
'exif-planarconfiguration-2'=> 'formato plano',
'exif-componentsconfiguration-0'=> 'no existe',
'exif-exposureprogram-0'=> 'No definido',
'exif-exposureprogram-2'=> 'Programa normal',
'exif-exposureprogram-3'=> 'Prioridad de apertura',
'exif-exposureprogram-4'=> 'Prioridad de obturador',
'exif-exposureprogram-5'=> 'Programa creativo (sesgado hacia la profundidad de campo)',
'exif-exposureprogram-6'=> 'Action program (sesgado hacia alta velocidad de obturador)',
'exif-exposureprogram-7'=> 'Modo retrato (para primeros planos con el fondo desenfocado)',
'exif-exposureprogram-8'=> 'Modo panorama (para fotos panorámicas con el fondo enfocado)',
'exif-subjectdistance-value'=> '$1 metros',
'exif-meteringmode-0'   => 'Desconocido',
'exif-meteringmode-1'   => 'Media',
'exif-meteringmode-5'   => 'Patrón',
'exif-meteringmode-6'   => 'Parcial',
'exif-meteringmode-255' => 'Otro',
'exif-lightsource-0'    => 'Desconocido',
'exif-lightsource-1'    => 'Luz diurna',
'exif-lightsource-2'    => 'Fluorescente',
'exif-lightsource-3'    => 'Tungsteno (luz incandescente)',
'exif-lightsource-9'    => 'Buen tiempo',
'exif-lightsource-10'   => 'Tiempo nublado',
'exif-lightsource-11'   => 'Penumbra',
'exif-lightsource-12'   => 'Fluorescente de luz diurna (D 5700 – 7100K)',
'exif-lightsource-13'   => 'Fluorescente de día soleado (N 4600 – 5400K)',
'exif-lightsource-14'   => 'Fluorescente blanco frío (W 3900 – 4500K)',
'exif-lightsource-15'   => 'Fluroescente blanco (WW 3200 – 3700K)',
'exif-lightsource-17'   => 'Luz estándar A',
'exif-lightsource-18'   => 'Luz estándar B',
'exif-lightsource-19'   => 'Luz estándar C',
'exif-lightsource-24'   => 'Tungsteno de estudio ISO',
'exif-lightsource-255'  => 'Otra fuente de luz',
'exif-focalplaneresolutionunit-2'=> 'pulgadas',
'exif-sensingmethod-1'  => 'No definido',
'exif-sensingmethod-2'  => 'Sensor de área de color de un chip',
'exif-sensingmethod-3'  => 'Sensor de área de color de dos chips',
'exif-sensingmethod-4'  => 'Sensor de área de color de tres chips',
'exif-sensingmethod-5'  => 'Sensor de área secuencial de color',
'exif-sensingmethod-7'  => 'Sensor trilineal',
'exif-sensingmethod-8'  => 'Sensor lineal secuencial de color',
'exif-scenetype-1'      => 'Una imagen directamente fotografiada',
'exif-customrendered-0' => 'Proceso normal',
'exif-customrendered-1' => 'Proceso personalizado',
'exif-exposuremode-0'   => 'Exposición automática',
'exif-exposuremode-1'   => 'Exposición manual',
'exif-whitebalance-0'   => 'Balance de blanco automático',
'exif-whitebalance-1'   => 'Balance de blanco manual',
'exif-scenecapturetype-0'=> 'Estándar',
'exif-scenecapturetype-1'=> 'Paisaje',
'exif-scenecapturetype-2'=> 'Retrato',
'exif-scenecapturetype-3'=> 'Escena nocturna',
'exif-gaincontrol-0'    => 'Ninguna',
'exif-contrast-1'       => 'Suave',
'exif-contrast-2'       => 'Duro',
'exif-saturation-1'     => 'Baja saturación',
'exif-saturation-2'     => 'Alta saturación',
'exif-sharpness-1'      => 'Suave',
'exif-sharpness-2'      => 'Dura',
'exif-subjectdistancerange-0'=> 'Desconocida',
'exif-subjectdistancerange-2'=> 'Vista cercana',
'exif-subjectdistancerange-3'=> 'Vista lejana',
'exif-gpslatitude-n'    => 'Latitud norte',
'exif-gpslatitude-s'    => 'Latitud sur',
'exif-gpslongitude-e'   => 'Longitud este',
'exif-gpslongitude-w'   => 'Longitud oeste',
'exif-gpsmeasuremode-2' => 'Medición bidimensional',
'exif-gpsmeasuremode-3' => 'Medición tridimensional',
'exif-gpsspeed-k'       => 'Kilómetros por hora',
'exif-gpsspeed-m'       => 'Millas por hora',
'exif-gpsspeed-n'       => 'Nudos',
'exif-gpsdirection-t'   => 'Dirección real',
'exif-gpsdirection-m'   => 'Dirección magnética',
'edit-externally'       => 'Editar este archivo usando una aplicación externa',
'edit-externally-help'  => 'Ver las [http://meta.wikimedia.org/wiki/Help:External_editors instrucciones de configuración] para más información.',
'recentchangesall'      => 'todos',
'imagelistall'          => 'todos',
'watchlistall1'         => 'todos',
'watchlistall2'         => 'todos',
'namespacesall'         => 'todos',
'confirmemail'          => 'Confirmar dirección de correo',
'confirmemail_text'     => 'Este wiki requiere que valides tu dirección de correo antes de usarlo. Pulsa el botón de abajo para enviar la confirmación.
El correo incluirá un enlace con un código; cárgalo para confirmar la validez de tu dirección.',
'confirmemail_send'     => 'Envía el código de confimación.',
'confirmemail_sent'     => 'Confirmación de correo enviada.',
'confirmemail_sendfailed'=> 'No fue posible enviar el correo de confirmación. Por favor, comprueba que no haya caracteres inválidos en la dirección de correo que has ingresado.',
'confirmemail_invalid'  => 'Código de confirmación incorrecto. El código debe de haber expirado.',
'confirmemail_success'  => 'Tu dirección de correo ha sido confirmada. Ahora puedes registrarte y colaborar en el wiki.',
'confirmemail_loggedin' => 'Tu dirección de correo ha sido confirmada.',
'confirmemail_error'    => 'Algo salió mal al guardar tu confirmación.',
'confirmemail_subject'  => 'confirmación de la dirección de correo de {{SITENAME}}',
'confirmemail_body'     => 'Alguien, probablemente tú mismo, ha registrado una
cuenta "$2" con esta dirección de correo en {{SITENAME}},
desde la dirección IP $1.

Para confirmar que esta cuenta realmente te pertenece y
activar el correo en {{SITENAME}}, abre este enlace:

$3

Si la cuenta no es tuya, no sigas el enlace. El código de confirmación expirará en $4.',
'tryexact'              => 'Probar con coincidencia exacta',
'searchfulltext'        => 'Buscar por texto completo',
'createarticle'         => 'Crear artículo',
'scarytranscludedisabled'=> '[Transclusión interwiki está deshabilitada]',
'scarytranscludefailed' => '[Obtención de plantilla falló para $1; lo sentimos]',
'scarytranscludetoolong'=> '[URL es demasiado larga; lo sentimos]',
'trackbackbox'          => '<div id="mw_trackbacks">
Trackbacks para este artículo:<br />
$1
</div>',
'trackbackremove'       => ' ([$1 Borrar])',
'trackbackdeleteok'     => 'El trackback se borró correctamente.',
'deletedwhileediting'   => 'Aviso: ¡Esta página ha sido borrada después de que iniciases la edición!',
'confirmrecreate'       => 'El usuario [[User:$1|$1]] ([[User talk:$1|discusión]]) borró este artículo después de que tú empezaces a editarlo y dio esta razón: \'\'$2\'\' Por favor, confirma que realmente deseas crear de nuevo el artículo.',
'recreate'              => 'Crear de nuevo',
'tooltip-recreate'      => 'Recupera una página que ha sido borrada',
'redirectingto'         => 'Redirigiendo a [[$1]]...',
'confirm_purge'         => '¿Vaciar la cache de esta página?

$1',
'confirm_purge_button'  => 'Aceptar',
'accesskey-compareselectedversions'	=> 'v',
'accesskey-diff'	=> 'v',
'accesskey-minoredit'	=> 'i',
'accesskey-preview'	=> 'p',
'accesskey-save'	=> 's',
'accesskey-search'	=> 'f',
'accesskey-watch'	=> 'w',
'allmessagesfilter'	=> 'Filtrar por nombre del mensaje:',
'allmessagesmodified'	=> 'Mostrar sólo los modificados',
'allpagesbadtitle'	=> 'El título dado era inválido o tenía un prefijo de enlace inter-idioma o inter-wiki. Puede contener uno o más caracteres que no se pueden usar en títulos.',
'anoneditwarning'	=> 'No has introducido tu nombre de usuario. Tu dirección IP se guardará en el historial de edición de la página.',
'anononlyblock'	=> 'sólo anon.',
'april-gen'	=> 'abril',
'articletitles'	=> 'Artículos que comienzan por \'\'$1\'\'',
'august-gen'	=> 'agosto',
'autoredircomment'	=> 'Redirigiendo a [[$1]]',
'badaccess-group0'	=> 'No estás autorizado a ejecutar la acción que has solicitado.',
'badaccess-group1'	=> 'La acción que has solicitado está restringida a los usuarios de uno de estos grupos: $1.',
'badaccess-group2'	=> 'La acción que has solicitado está restringida a los usuarios de uno de estos grupos: $1.',
'badaccess-groups'	=> 'La acción que has solicitado está restringida a los usuarios de uno de estos grupos: $1.',
'blockededitsource'	=> 'El texto de \'\'\'tus ediciones\'\'\' a \'\'\'$1\'\'\' se muestran a continuación:',
'blockedoriginalsource'	=> 'El código fuente de \'\'\'$1\'\'\' se muestra a continuación:',
'boteditletter'	=> 'b',
'cannotundelete'	=> 'Ha fallado el deshacer el borrado; alguien más puede haber deshecho el borrado antes.',
'cantcreateaccounttext'	=> 'La creación de cuentas desde esta dirección IP (<b>$1</b>) ha sido bloqueada. 
Esto se debe probablemente a vandalismos persistentes desde tu escuela o tu proveedor de servicios de Internet.',
'cantcreateaccounttitle'	=> 'No se puede crear la cuenta',
'categorypage'	=> 'Ver página de categoría',
'clearwatchlist'	=> 'Limpiar lista de seguimiento',
'common.css'	=> '/* Los estilos CSS definidos aquí aplicarán a todas las pieles (skins) */',
'confirmedittext'	=> 'Debes confirmar tu dirección electrónica antes de editar páginas. Por favor, establece y valida una dirección electrónica a través de tus [[Special:Preferences|preferencias de usuario]].',
'confirmedittitle'	=> 'Se requiere confirmación de dirección electrónica para editar',
'confirmemail_needlogin'	=> 'Necesitas $1 para confirmar tu dirección electrónica.',
'createaccountblock'	=> 'Creación de cuenta bloqueada.',
'databasenotlocked'	=> 'La base de datos no está bloqueada.',
'december-gen'	=> 'diciembre',
'delete_and_move_confirm'	=> 'Sí, borrar la página',
'displaytitle'	=> '(Link to this page as [[$1]])',
'editinginterface'	=> '\'\'\'Aviso:\'\'\' Estás editando una página usada para proporcionar texto a la interfaz de {{SITENAME}}. Los cambios en esta página afectarán a la apariencia de la interfaz para los demás usuarios.',
'error'	=> 'Error',
'errorpagetitle'	=> 'Error',
'exportnohistory'	=> '----
\'\'\'Nota:\'\'\' Exportar el historial completo de páginas a través de este formulario ha sido deshabilitado debido a problemas de rendimiento del servidor.',
'export-submit'	=> 'Exportar',
'faq'	=> 'FAQ',
'february-gen'	=> 'febrero',
'feed-invalid'	=> 'Tipo de subscripción a sindicación de noticias inválida.',
'filewasdeleted'	=> 'Un archivo con este nombre se subió con anterioridad y posteriormente ha sido borrado. Deberías revisar el $1 antes de subirlo de nuevo.',
'fri'	=> 'vie',
'group'	=> 'Grupo:',
'group-all'	=> '(todos)',
'group-bot'	=> 'Bots',
'group-bot-member'	=> 'Bot',
'group-bureaucrat'	=> 'Burócratas',
'group-bureaucrat-member'	=> 'Burócrata',
'grouppage-bot'	=> 'Project:Bot',
'grouppage-bureaucrat'	=> 'Project:Burócratas',
'grouppage-sysop'	=> 'Project:Administradors',
'group-sysop'	=> 'Administradores',
'group-sysop-member'	=> 'Administrador',
'hideresults'	=> 'Ocultar resultados',
'hist'	=> 'hist',
'history-feed-description'	=> 'Historial de revisiones para esta página en el wiki',
'history-feed-empty'	=> 'La página solicitada no existe.
Puede haber sido borrada del wiki o renombrada.
Prueba a [[Special:Search|buscar en el wiki]] nuevas páginas relevantes.',
'history-feed-item-nocomment'	=> '$1 en $2',
'history-feed-title'	=> 'Historial de revisiones',
'imagelistforuser'	=> 'Esto sólo muestra imágenes subidas por $1.',
'imgdesc'	=> 'desc',
'importbadinterwiki'	=> 'Enlace interwiki anómalo',
'importcantopen'	=> 'No se puedo importar este archivo',
'import-interwiki-history'	=> 'Copiar todas las versiones históricas para esta página',
'import-interwiki-namespace'	=> 'Transferir páginas al espacio de nombres:',
'import-interwiki-submit'	=> 'Importar',
'import-interwiki-text'	=> 'Selecciona un wiki y un título de página para importar.
Las fechas de revisiones y los nombres de editores se preservarán.
Todas las importaciones transwiki se registran en el [[Special:Log/import|registro de importaciones]].',
'import-logentry-interwiki'	=> 'transwikificada $1',
'import-logentry-interwiki-detail'	=> '$1 revisión/ones desde $2',
'import-logentry-upload'	=> 'importada [[$1]] por subida de archivo',
'import-logentry-upload-detail'	=> '$1 revisión/ones',
'importlogpage'	=> 'Registro de importaciones',
'importlogpagetext'	=> 'Importaciones administrativas de páginas con historial desde otros wikis.',
'importnopages'	=> 'No hay páginas que importar.',
'import-revision-count'	=> '$1 revisión/ones',
'importstart'	=> 'Importando páginas...',
'importunknownsource'	=> 'Tipo de fuente de importación desconocida',
'ipb_already_blocked'	=> '"$1" ya se encuentra bloqueado.',
'ipbanononly'	=> 'Bloquear usuarios anónimos solamente',
'ipb_cant_unblock'	=> '\'\'\'Error\'\'\': Número ID $1 de bloqueo no encontrado. Pudo haber sido desbloqueado ya.',
'ipbcreateaccount'	=> 'Prevenir creación de cuenta de usuario.',
'isbn'	=> 'ISBN',
'istemplate'	=> 'inclusión',
'january-gen'	=> 'enero',
'july-gen'	=> 'julio',
'june-gen'	=> 'junio',
'listingcontinuesabbrev'	=> ' cont.',
'listredirects'	=> 'Lista de redirecciones',
'lockfilenotwritable'	=> 'El archivo-cerrojo de la base de datos no tiene permiso de escritura. Para bloquear o desbloquear la base de datos, este archivo tiene que ser escribible por el sesrvidor web.',
'loginlanguagelabel'	=> 'Idioma: $1',
'longpageerror'	=> '<strong>ERROR: El testo que has enviado ocupa $1 kilobytes, lo cual es mayor que $2 kilobytes. No se puede guardar.</strong>',
'march-gen'	=> 'marzo',
'markedaspatrollederror'	=> 'No se puede marcar como patrullada',
'markedaspatrollederrortext'	=> 'Debes especificar una revisión para marcarla como patrullada.',
'may-gen'	=> 'mayo',
'mediawikipage'	=> 'Ver página de mensaje',
'metadata-fields'	=> 'Los campos de metadatos EXIF que se listan en este mensaje se mostrarán en la página de descripción de la imagen aún cuando la tabla de metadatos esté plegada. Existen otros campos que se mantendrán ocultos por defecto y que podrán desplegarse. 
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength',
'metadata_help'	=> 'Metadata (see [[{{ns:project}}:Metadata]] for an explanation):',
'minoreditletter'	=> 'm',
'missingcommenttext'	=> 'Por favor introduce texto debajo.',
'missingsummary'	=> '\'\'\'Atención:\'\'\' No has escrito un resumen de edición. Si haces clic nuevamente en «{{MediaWiki:Savearticle}}» tu edición se grabará sin él.',
'mon'	=> 'lun',
'newpageletter'	=> 'N',
'newpages-username'	=> 'Nombre de usuario',
'noexactmatch'	=> '<div style="border: 1px solid #ccc; padding: 7px;"><div style="background: #F9F9F9; padding: 7px">
<div style="font-size:115%"><b>No existe ningún artículo con el título que has escrito.</b></div>
<hr />
<ul>
<li>Posibles causas:
<ul>
<li>Puede que lo hayas <b>tecleado mal</b> o con alguna <b>falta de ortografía</b>. Comprueba el texto (recuerda que mayúsculas y acentos afectan a la búsqueda) o consulta [[{{ns:project}}:Búsqueda]]<!-- /a -->. </li>
<li>Puede que el artículo que buscas <b>tenga otro título</b>. Prueba a repetir tu búsqueda utilizando el botón "Búsqueda" de más arriba.
</li>
</ul>
</li>

<li>
Ten en cuenta que {{SITENAME}} es un wiki en desarrollo que va siendo construido poco a poco por sus visitantes. Si el artículo que buscas aún no existe, puedes crearlo siguiendo <b>[[$1|este enlace]]</b>. Puede que así otra gente vea el artículo y trate de completarlo.
</li>
</ul></div>
<div style="font-size:90%; padding-left: 7px">
<b>Muy importante:</b> en {{SITENAME}} <b>no se aceptan en ningún caso</b> textos con copyright sin el permiso explícito de sus autores. En particular, la mayoría de las páginas web (indiquen o no su autor o copyright) tienen copyright, por lo que su contenido es inadmisible aquí. Ten en cuenta que copiar este tipo de materiales <b>puede causar serios daños al proyecto</b>. Para más información, puedes leer <b>[[{{ns:project}}:Copyrights]]</b>
</div>
</div>',
'nouserspecified'	=> 'Debes especificar un nombre de usuario.',
'november-gen'	=> 'noviembre',
'october-gen'	=> 'octubre',
'ok'	=> 'OK',
'revision-info' => 'Revisión a fecha de $1; $2',
'orig'	=> 'orig',
'pagetitle'	=> '$1 - {{SITENAME}}',
'prefs-watchlist'	=> 'Seguimiento',
'prefs-watchlist-days'	=> 'Número de días a mostrar en la lista de seguimiento:',
'prefs-watchlist-edits'	=> 'Número de ediciones a mostrar en la lista extendida:',
'protectedinterface'	=> 'Esta página provee texto del interfaz del software. Está bloqueada para evitar [[{{ns:project}}:vandalismo|vandalismos]]. Si cree que debería cambiarse el texto, hable con un [[{{ns:project}}:Administradors|Administrador]].',
'randomredirect'	=> 'Ir a una redirección cualquiera',
'rc_categories'	=> 'Limitar a categorías (separadas por "|")',
'rc_categories_any'	=> 'Any',
'rcshowhideanons'	=> '$1 usuarios anónimos',
'rcshowhidebots'	=> '$1 bots',
'rcshowhideliu'	=> '$1 usuarios registrados',
'rcshowhidemine'	=> '$1 mis ediciones',
'rcshowhideminor'	=> '$1 ediciones menores',
'rcshowhidepatr'	=> '$1 ediciones patrulladas',
'restriction-edit'	=> 'Pueden editar',
'restriction-move'	=> 'Pueden trasladar',
'rev-deleted-comment'	=> '(comentario eliminado)',
'rev-deleted-text-permission'	=> '<div class="mw-warning plainlinks">
Esta revisión de la página ha sido eliminada de los archivos públicos.
puede haber detalles en el [{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} registro de borrado].
</div>',
'rev-deleted-text-view'	=> '<div class="mw-warning plainlinks">
Esta revisión de la página ha sido eliminada de los archivos públicos.
Como administrador de este wiki puedes verla;
puede haber detalles en el [{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} registro de borrado].
</div>',
'rev-deleted-user'	=> '(nombre de usuario eliminado)',
'revdelete-hide-comment'	=> 'Ocultar comentario de edición',
'revdelete-hide-restricted'	=> 'Aplicar estas restricciones a los administradores tal como al resto',
'revdelete-hide-text'	=> 'Ocultar el texto de la revisión',
'revdelete-hide-user'	=> 'Ocultar el nombre/IP del editor',
'revdelete-legend'	=> 'Establecer restricciones de revisión:',
'revdelete-log'	=> 'Comentario de registro:',
'revdelete-logentry'	=> 'cambiada la visibilidad de la revisión para [[$1]]',
'revdelete-selected'	=> 'Revisión seleccionada de [[:$1]]:',
'revdelete-submit'	=> 'Aplicar a la revisión seleccionada',
'revdelete-text'	=> 'Las revisiones borradas aún aparecerán en el historial de la página,
pero sus contenidos no serán accesibles al público.

Otros administradores de este wiki aún podrán acceder al contenido oculto y podrán deshacer el borrado a través de la misma interfaz, a menos los operadores del sitio establezcan una restricción adicional.',
'rev-delundel'	=> 'mostrar/ocultar',
'revertimg'	=> 'rev',
'revisiondelete'	=> 'Borrar/deshacer borrado revisiones',
'rightslog'	=> 'Cambios de perfil de usuarios',
'rightslogentry'	=> 'modificó los grupos a los que pertenece $1: de $2 a $3',
'rightsnone'	=> 'ninguno',
'sat'	=> 'sab',
'searchcontaining'	=> 'Buscar artículos que contengan \'\'$1\'\'.',
'searchnamed'	=> 'Buscar artículos con este nombre \'\'$1\'\'.',
'sectionlink'	=> '→',
'semiprotectedpagewarning'	=> '\'\'\'Nota:\'\'\' Esta página ha sido protegida para que sólo usuarios registrados puedan editarla.',
'september-gen'	=> 'septiembre',
'session_fail_preview_html'	=> '<strong>Lo sentimos, no hemos podido procesar tu cambio debido a una pérdida de datos de sesión.</strong>

\'\'Puesto que este wiki tiene el HTML puro habilitado, la visión preliminar está oculta para prevenirse contra ataques en JavaScript.\'\'

<strong>If this is a legitimate edit attempt, please try again. If it still doesn\'t work, try logging out and logging back in.</strong>',
'showhidebots'	=> '($1 bots)',
'showlivepreview'	=> 'Live preview',
'sorbs'	=> 'SORBS DNSBL',
'spam_blanking'	=> 'Todas las revisiones contienen enlaces a $1, blanqueando',
'spambot_username'	=> 'Limpieza de spam de MediaWiki',
'spam_reverting'	=> 'Revirtiendo a la última versión que no contenga enlaces a $1',
'sp-contributions-newbies-sub'	=> 'Para nuevos',
'sp-contributions-newer'	=> '< $1 posteriores',
'sp-contributions-newest'	=> 'Últimas',
'sp-contributions-older'	=> '$1 previas >',
'sp-contributions-oldest'	=> 'Primeras',
'sp-newimages-showfrom'	=> 'Mostrar nuevas imágines empezando por $1',
'statistics-mostpopular'	=> 'Páginas más vistas',
'sun'	=> 'dom',
'templatepage'	=> 'Ver página de plantilla',
'thu'	=> 'jue',
'thumbnail_error'	=> 'Error al crear miniatura: $1',
'tog-uselivepreview'	=> 'Usar live preview (JavaScript) (Experimental)',
'trackbacklink'	=> 'Trackback',
'tue'	=> 'mar',
'unblocked'	=> '[[User:$1|$1]] ha sido desbloqueado',
'uncategorizedimages'	=> 'Imágenes sin categorizar',
'undeletecomment'	=> 'Razón para restaurar:',
'undeletedfiles'	=> '$1 archivo(s) restaurados',
'undeletedpage'	=> '<big>\'\'\'Se ha restaurado $1\'\'\'</big>

Consulta el [[Special:Log/delete|registro de borrados]] para ver una lista de los últimos borrados / restauraciones.',
'undeletedrevisions-files'	=> '$1 revisions and $2 file(s) restored',
'undeleteextrahelp'	=> 'Para restaurar todas las revisiones, deja todas las casillas sin seleccionar y pulsa \'\'\'¡Restaurar!\'\'\'. Para restaurar sólo algunas revisiones, marca las revisiones que quieres restaurar y pulsa \'\'\'¡Restaurar!\'\'\'. Haciendo clic en al botón \'\'\'Nada\'\'\', se deseleccionarán  todas las casillas y eliminará el comentario actual.',
'undeletereset'	=> 'Nada',
'unit-pixel'	=> 'px',
'unusedtemplates'	=> 'Plantillas sin uso',
'unusedtemplatestext'	=> 'Aquí se enumeran todas las páginas en la zona de plantillas que no están incluidas en otras páginas. Recuerda mirar lo que enlaza a las plantillas antes de borrarlas.',
'unusedtemplateswlh'	=> 'otros enlaces',
'uploaddisabledtext'	=> 'Las subidas de archivos están deshabilitadas en este wiki',
'userinvalidcssjstitle'	=> '\'\'\'Aviso:\'\'\' No existe la piel "$1". Recuerda que las páginas personalizadas .css y .js tienen un título en minúsculas, p.e. Usuario:Foo/monobook.css en vez de  Usuario:Foo/Monobook.css.',
'variantname-sr'	=> 'sr',
'variantname-sr-ec'	=> 'sr-ec',
'variantname-sr-el'	=> 'sr-el',
'variantname-sr-jc'	=> 'sr-jc',
'variantname-sr-jl'	=> 'sr-jl',
'variantname-zh'	=> 'zh',
'variantname-zh-cn'	=> 'cn',
'variantname-zh-hk'	=> 'hk',
'variantname-zh-sg'	=> 'sg',
'variantname-zh-tw'	=> 'tw',
'viewhelppage'	=> 'Ver página de ayuda',
'viewpagelogs'	=> 'Ver los registros de esta página',
'viewsourcefor'	=> 'para $1',
'watchlistanontext'	=> 'Para ver o editar las entradas de tu lista de seguimiento debes $1.',
'watchlistclearbutton'	=> 'Vaciar la lista de seguimiento',
'watchlistcleardone'	=> 'Tu lista de seguimiento ha sido borrada. Se eliminaron $1 elementos.',
'watchlistcleartext'	=> '¿Estás seguro de querer borrarlos?',
'watchlistcount'	=> '\'\'\'Tienes $1 páginas en tu lista de seguimiento, incluyendo las de discusión.\'\'\'',
'watchlistfor'	=> '(para \'\'\'$1\'\'\')',
'wed'	=> 'mie',
'wldone'	=> 'Hecho.',
'youhavenewmessagesmulti'	=> 'Tienes nuevos mensajes en $1',

);
?>
