/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    StoredCollection(DataView dataView) {
        super(dataView);
    }

    final boolean add(Object object, Object object2) {
        boolean bl = this.beginAutoCommit();
        try {
            int n = this.view.put(object, object2, Db.DB_NODUPDATA, null);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public Iterator iterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public StoredIterator iterator(boolean bl) {
        try {
            return new StoredIterator(this, bl && this.isWriteAllowed(), null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return arrayList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        Iterator iterator = this.iterator();
        try {
            while (n < objectArray.length && iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            if (n < objectArray.length) {
                objectArray[n] = null;
            } else if (iterator.hasNext()) {
                ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                objectArray = arrayList.toArray(objectArray);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAll(Collection collection) {
        Iterator iterator;
        block3: {
            boolean bl;
            iterator = collection.iterator();
            try {
                do {
                    if (iterator.hasNext()) continue;
                    break block3;
                } while (this.contains(iterator.next()));
                bl = false;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                StoredIterator.close(iterator);
                throw throwable;
            }
            StoredIterator.close(iterator);
            return bl;
        }
        Object var5_5 = null;
        StoredIterator.close(iterator);
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, true);
    }

    public boolean retainAll(Collection collection) {
        return this.removeAll(collection, false);
    }

    private boolean removeAll(Collection collection, boolean bl) {
        Iterator iterator = null;
        boolean bl2 = this.beginAutoCommit();
        try {
            boolean bl3 = false;
            iterator = this.iterator();
            while (iterator.hasNext()) {
                if (bl != collection.contains(iterator.next())) continue;
                iterator.remove();
                bl3 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl2);
            return bl3;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        Iterator iterator;
        block4: {
            boolean bl2;
            if (!(object instanceof Collection)) {
                return false;
            }
            Collection collection = StoredCollection.copyCollection(object);
            iterator = this.iterator();
            try {
                do {
                    if (iterator.hasNext()) continue;
                    bl = collection.isEmpty();
                    break block4;
                } while (collection.remove(iterator.next()));
                bl2 = false;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                StoredIterator.close(iterator);
                throw throwable;
            }
            StoredIterator.close(iterator);
            return bl2;
        }
        Object var6_7 = null;
        StoredIterator.close(iterator);
        return bl;
    }

    public List toList() {
        ArrayList arrayList;
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next());
            }
            arrayList = arrayList2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return arrayList;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append(']');
            string = stringBuffer.toString();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return string;
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray) {
        return this.join(storedContainerArray, objectArray, false);
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray, boolean bl) {
        try {
            DataView[] dataViewArray = new DataView[storedContainerArray.length];
            int n = 0;
            while (n < storedContainerArray.length) {
                dataViewArray[n] = storedContainerArray[n].view;
                ++n;
            }
            DataCursor dataCursor = this.view.join(dataViewArray, objectArray, bl);
            return new StoredIterator(this, false, dataCursor);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object getFirstOrLast(boolean bl) {
        Object object;
        DataCursor dataCursor = null;
        try {
            try {
                dataCursor = new DataCursor(this.view, false);
                int n = dataCursor.get(null, null, bl ? Db.DB_FIRST : Db.DB_LAST, false);
                object = n == 0 ? this.makeIteratorData(null, dataCursor) : null;
                Object var6_6 = null;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeCursor(dataCursor);
            throw throwable;
        }
        this.closeCursor(dataCursor);
        return object;
    }

    abstract Object makeIteratorData(StoredIterator var1, DataCursor var2) throws DbException, IOException;

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object object) {
        if (object instanceof StoredCollection) {
            return ((StoredCollection)object).toList();
        }
        return new ArrayList((Collection)object);
    }

    public abstract boolean remove(Object var1);

    public abstract boolean add(Object var1);

    public abstract boolean contains(Object var1);
}

