/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.IntegrityConstraintException;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public class ForeignKeyIndex
extends DataIndex {
    public static final int ON_DELETE_ABORT = 0;
    public static final int ON_DELETE_CASCADE = 1;
    public static final int ON_DELETE_CLEAR = 2;
    DataStore foreignStore;
    int deleteAction;

    public ForeignKeyIndex(DataStore dataStore, Db db, KeyExtractor keyExtractor, DataStore dataStore2, int n) {
        super(dataStore, db, dataStore2.keyFormat, keyExtractor);
        this.foreignStore = dataStore2;
        this.deleteAction = n;
        dataStore2.addInverseIndex(this);
        if (n == 2 && keyExtractor.getPrimaryKeyFormat() != null) {
            throw new IllegalArgumentException("ON_DELETE_CLEAR cannot be used with key extractor that requires primary key");
        }
    }

    public final DataStore getForeignStore() {
        return this.foreignStore;
    }

    public final int getDeleteAction() {
        return this.deleteAction;
    }

    final void applyIndexInsert(DataThang dataThang, DataThang dataThang2) throws DbException, IOException {
        int n = this.foreignStore.db.get(dataThang2, DataThang.getDiscardDataThang(), 0);
        if (n != 0) {
            throw new IllegalArgumentException("Integrity error inserting in " + this.db + ", index key not found in " + this.foreignStore.db);
        }
        super.applyIndexInsert(dataThang, dataThang2);
    }

    final void applyForeignDelete(DataThang dataThang) throws DbException, IOException {
        DataEnvironment dataEnvironment = this.store.db.env;
        DataThang dataThang2 = new DataThang();
        int n = this.db.get(dataThang, dataThang2, 0);
        if (n == 0) {
            switch (this.deleteAction) {
                case 0: {
                    throw new IntegrityConstraintException("ON_DELETE_ABORT: deletion not allowed");
                }
                case 1: {
                    DataThang dataThang3 = new DataThang();
                    Dbc dbc = this.store.db.openCursor(true);
                    try {
                        n = dbc.get(dataThang2, dataThang3, Db.DB_SET | dataEnvironment.getWriteLockFlag());
                        if (n != 0) {
                            throw new IntegrityConstraintException("ON_DELETE_CASCADE: index entry not found");
                        }
                        dbc.delete(0);
                        this.store.applyChange(dataThang2, dataThang3, null);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.store.db.closeCursor(dbc);
                        throw throwable;
                    }
                    this.store.db.closeCursor(dbc);
                    break;
                }
                case 2: {
                    DataThang dataThang4 = new DataThang();
                    Dbc dbc = this.store.db.openCursor(true);
                    try {
                        n = dbc.get(dataThang2, dataThang4, Db.DB_SET | dataEnvironment.getWriteLockFlag());
                        if (n != 0) {
                            throw new IntegrityConstraintException("ON_DELETE_CLEAR: index entry not found");
                        }
                        this.keyExtractor.clearIndexKey(this.keyExtractor.getValueFormat() != null ? dataThang4 : null);
                        dbc.put(dataThang2, dataThang4, Db.DB_CURRENT);
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.store.db.closeCursor(dbc);
                        throw throwable;
                    }
                    this.store.db.closeCursor(dbc);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown delete action " + this.deleteAction);
                }
            }
        }
    }
}

