# Simple queues plugin :-)
# Submitted by michwill
# contact me to michwill@jabber.ru if needed

import gtk, gtk.glade
import pygtk
import gobject
__name = 'Simple Queue'
__version = '0.4'
__author = 'michwill'
__blurb = "Queues support in pymp'd. You can add song in queue via key 'q' or buton on panel"

def queueRender(column, cell, model, iter, queueIDs):
    try:
	id = int(model.get_value(iter, 6))
	cell.set_property('text', queueIDs.index(id)+1)
    except Exception, e:
	cell.set_property('text', '') 


class Simplequeue:
	def _init(self, data):
		self.xml, self.pluginMenu, self.pympd, self.base_dir, parser = data
		#Drawing button
		self.parent = self.xml.get_widget("hbox6")
		self.addqueue = gtk.Button()
		self.addqueue.set_label('')
		image = gtk.Image()
		image.set_from_stock(gtk.STOCK_INDENT, gtk.ICON_SIZE_LARGE_TOOLBAR)
		self.addqueue.set_image(image)
		self.addqueue.connect('clicked', self.add_queue)
		self.addqueue.show_all()
		self.parent.add(self.addqueue)
		#Drawing menu entry
		self.menuBar = self.xml.get_widget("menubar1")
		self.buildPluginMenu(self.pluginMenu)
		#Playlist
		self.playlistTree = self.xml.get_widget("playlistTreeView")
		self.playlistTree.connect("row-activated",self.row_activated)
		#Keybinding
		self.playlistTree.connect("key-press-event",self.key_press_event)
		#Other
		self.QueueIDs = []
		self.oldID = -1
		self.ClickedFlag = False
		#Treeview column
		self.column = gtk.TreeViewColumn('Q')
		self.column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		self.column.set_visible(True)
		self.column.set_property('fixed-width', 20)
		self.column.set_resizable(True)
		self.playlistTree.insert_column(self.column, 0)
		cellQueue = gtk.CellRendererText()
		self.column.pack_start(cellQueue)
#		self.column.set_attributes(cellQueue)
		self.column.set_cell_data_func(cellQueue, queueRender, self.QueueIDs)
	def _conf(self, hasDialog=None):
		return False
	def _spin(self, data, songChanged=False):
		song = self.pympd.getCurrentSong()
		if self.ClickedFlag:
			self.ClickedFlag = False
			if self.QueueIDs != []:
				if int(song.id) == self.QueueIDs[0]:
					self.rem_queue(self.pluginSubMenu.get_children()[2],int(song.id))
			return
		if not song:
			return
		if songChanged & (self.QueueIDs != []):
			if self.oldID != int(song.id):
				id = self.QueueIDs[0]
				self.oldID = id
				self.pympd.play(id)
				self.rem_queue(self.pluginSubMenu.get_children()[2],id)
	def _unload(self):
		self.parent.remove(self.addqueue)
		self.playlistTree.remove_column(self.column)
		self.pluginMenuEntry.destroy()
	def buildPluginMenu(self, pluginMenu):
		self.pluginMenuEntry = gtk.MenuItem('Queue')
		self.pluginSubMenu = gtk.Menu()
		self.pluginSubMenu.set_title('Queue')
		self.pluginMenuEntry.set_submenu(self.pluginSubMenu)

		menuEntry = gtk.ImageMenuItem(gtk.STOCK_CLEAR)
		menuEntry.get_children()[0].set_text("Clear queue")
		menuEntry.connect('activate', self.clear_clicked)
		self.pluginSubMenu.append(menuEntry)
		menuEntry = gtk.SeparatorMenuItem()
		self.pluginSubMenu.append(menuEntry)

		self.pluginMenuEntry.show_all()
		self.menuBar.insert(self.pluginMenuEntry, 4)

	def key_press_event(self, obj, event):
		from gtk.gdk import keyval_name
		if keyval_name(event.keyval)=='q':
			self.add_queue(obj)
			return True
		return False


	def clear_clicked(self, obj):
		objs = self.pluginSubMenu.get_children()[2:]
		for i in objs:
			self.pluginSubMenu.remove(self.pluginSubMenu.get_children()[2])
			self.QueueIDs.pop()
		self.playlistTree.queue_draw()
	def add_queue(self, obj):
		selection = self.playlistTree.get_selection()
		model, pathlist = selection.get_selected_rows()
		for i in pathlist:
			iter = model.get_iter(i)
			id = int(model.get_value(iter,6))
			if not id in self.QueueIDs:
				self.QueueIDs.append(id)
				song = self.pympd.listSongInPlaylist(id)
				text = "%s: %s" % (song.artist, song.title)
				menuEntry = gtk.MenuItem(text)
				menuEntry.connect('activate', self.rem_queue, id)
				self.pluginSubMenu.append(menuEntry)
			else:
				self.pluginSubMenu.remove(self.pluginSubMenu.get_children()[self.QueueIDs.index(id)+2])
				self.QueueIDs.remove(id)
		self.playlistTree.queue_draw()
		self.pluginSubMenu.show_all()
	def rem_queue(self, obj, data):
		self.QueueIDs.remove(data)
		self.pluginSubMenu.remove(obj)
		self.playlistTree.queue_draw()
	def row_activated(self, treeview, iter, path):
		self.ClickedFlag = True
