/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.repository.AbstractRepository;
import fr.jayasoft.ivy.repository.Repository;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.resolver.AbstractResourceResolver;
import fr.jayasoft.ivy.resolver.MDResolvedResource;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.ResolverHelper;
import fr.jayasoft.ivy.resolver.ResourceMDParser;
import fr.jayasoft.ivy.util.ChecksumHelper;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.version.VersionMatcher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RepositoryResolver
extends AbstractResourceResolver {
    private Repository _repository;
    private Boolean _alwaysCheckExactRevision = null;

    public Repository getRepository() {
        return this._repository;
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    public void setName(String name) {
        super.setName(name);
        if (this._repository instanceof AbstractRepository) {
            ((AbstractRepository)this._repository).setName(name);
        }
    }

    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        return RepositoryResolver.findResourceUsingPattern(this.getName(), this.getRepository(), this.getLatestStrategy(), this.getIvy().getVersionMatcher(), rmdparser, mrid, pattern, artifact, date, this.isAlwaysCheckExactRevision());
    }

    public static ResolvedResource findResourceUsingPattern(String name, Repository repository, LatestStrategy strategy, VersionMatcher versionMatcher, ResourceMDParser rmdparser, ModuleRevisionId mrid, String pattern, Artifact artifact, Date date, boolean alwaysCheckExactRevision) {
        try {
            if (!versionMatcher.isDynamic(mrid) || alwaysCheckExactRevision) {
                String resourceName = IvyPatternHelper.substitute(pattern, mrid, artifact);
                Message.debug("\t trying " + resourceName);
                Resource res = repository.getResource(resourceName);
                boolean reachable = res.exists();
                if (reachable) {
                    String revision = pattern.indexOf("revision") == -1 ? "working@" + name : mrid.getRevision();
                    return new ResolvedResource(res, revision);
                }
                if (versionMatcher.isDynamic(mrid)) {
                    return RepositoryResolver.findDynamicResourceUsingPattern(name, repository, strategy, versionMatcher, rmdparser, mrid, pattern, artifact, date);
                }
                Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + res);
                return null;
            }
            return RepositoryResolver.findDynamicResourceUsingPattern(name, repository, strategy, versionMatcher, rmdparser, mrid, pattern, artifact, date);
        }
        catch (IOException ex) {
            throw new RuntimeException(name + ": unable to get resource for " + mrid + ": res=" + IvyPatternHelper.substitute(pattern, mrid, artifact) + ": " + ex, ex);
        }
    }

    private static ResolvedResource findDynamicResourceUsingPattern(String name, Repository repository, LatestStrategy strategy, VersionMatcher versionMatcher, ResourceMDParser rmdparser, ModuleRevisionId mrid, String pattern, Artifact artifact, Date date) {
        ArtifactInfo[] rress = ResolverHelper.findAll(repository, mrid, pattern, artifact);
        if (rress == null) {
            Message.debug("\t" + name + ": unable to list resources for " + mrid + ": pattern=" + pattern);
            return null;
        }
        ResolvedResource found = null;
        List sorted = strategy.sort(rress);
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            ResolvedResource rres = (ResolvedResource)iter.next();
            if (date != null && rres.getLastModified() > date.getTime()) {
                Message.debug("\t" + name + ": too young: " + rres);
                continue;
            }
            ModuleRevisionId foundMrid = ModuleRevisionId.newInstance(mrid, rres.getRevision());
            if (!versionMatcher.accept(mrid, foundMrid)) {
                Message.debug("\t" + name + ": rejected by version matcher: " + rres);
                continue;
            }
            if (versionMatcher.needModuleDescriptor(mrid, foundMrid)) {
                MDResolvedResource r = rmdparser.parse(rres.getResource(), rres.getRevision());
                if (!versionMatcher.accept(mrid, r.getResolvedModuleRevision().getDescriptor())) {
                    Message.debug("\t" + name + ": md rejected by version matcher: " + rres);
                    continue;
                }
                found = r;
                continue;
            }
            found = rres;
        }
        if (found == null) {
            Message.debug("\t" + name + ": no resource found for " + mrid + ": pattern=" + pattern);
        } else if (!found.getResource().exists()) {
            Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + found.getResource());
            return null;
        }
        return found;
    }

    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this._repository.get(resource.getName(), dest);
        return dest.length();
    }

    /*
     * WARNING - void declaration
     */
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        void var4_4;
        String destPattern;
        if ("ivy".equals(artifact.getType()) && !this.getIvyPatterns().isEmpty()) {
            destPattern = (String)this.getIvyPatterns().get(0);
        } else if (!this.getArtifactPatterns().isEmpty()) {
            destPattern = (String)this.getArtifactPatterns().get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        String dest = IvyPatternHelper.substitute((String)var4_4, mrid, artifact);
        this.put(artifact, src, dest, overwrite);
        Message.info("\tpublished " + artifact.getName() + " to " + this.hidePassword(dest));
    }

    private void put(Artifact artifact, File src, String dest, boolean overwrite) throws IOException {
        this._repository.put(artifact, src, dest, overwrite);
        String[] checksums = this.getChecksumAlgorithms();
        for (int i = 0; i < checksums.length; ++i) {
            this.putChecksum(artifact, src, dest, overwrite, checksums[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChecksum(Artifact artifact, File src, String dest, boolean overwrite, String algorithm) throws IOException {
        File csFile = File.createTempFile("ivytemp", algorithm);
        try {
            FileUtil.copy((InputStream)new ByteArrayInputStream(ChecksumHelper.computeAsString(src, algorithm).getBytes()), csFile, null);
            this._repository.put(DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, algorithm, artifact.getExt() + "." + algorithm), csFile, dest + "." + algorithm, overwrite);
        }
        finally {
            csFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache, boolean useOrigin) {
        try {
            this._repository.addTransferListener(ivy);
            DownloadReport downloadReport = super.download(artifacts, ivy, cache, useOrigin);
            Object var7_6 = null;
            if (ivy != null) {
                this._repository.removeTransferListener(ivy);
            }
            return downloadReport;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                if (ivy == null) break block3;
                this._repository.removeTransferListener(ivy);
            }
            throw throwable;
        }
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern, tokenValues);
            String[] values = ResolverHelper.listTokenValues(this._repository, partiallyResolvedPattern, token);
            if (values == null) continue;
            names.addAll(Arrays.asList(values));
        }
    }

    public String getTypeName() {
        return "repository";
    }

    public void dumpConfig() {
        super.dumpConfig();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    public void setIvy(Ivy ivy) {
        super.setIvy(ivy);
        if (ivy != null && this._alwaysCheckExactRevision == null) {
            this._alwaysCheckExactRevision = Boolean.valueOf(ivy.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        return this._alwaysCheckExactRevision == null ? true : this._alwaysCheckExactRevision;
    }

    public void setAlwaysCheckExactRevision(boolean alwaysCheckExactRevision) {
        this._alwaysCheckExactRevision = alwaysCheckExactRevision;
    }
}

