#!/usr/bin/php
<?php
/**
 * The main Horde setup script which allows for a step by step setup
 * or reconfiguration of a Horde installation.
 *
 * $Horde: horde/scripts/setup.php,v 1.25.10.10 2006/05/18 15:47:32 chuck Exp $
 *
 * Copyright 2003-2006 Marko Djukic <marko@oblo.com>
 * Copyright 2003-2006 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @author  Charles J. Hagenbuch <chuck@horde.org>
 * @since   Horde 3.0
 */

@define('AUTH_HANDLER', true);
@define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/core.php';
require_once 'Horde/CLI.php';

$cli = new Horde_CLI();

/* Check for config files. */
$files = array('conf.php',
               'mime_drivers.php',
               'nls.php',
               'prefs.php',
               'registry.php');
foreach ($files as $filename) {
    $file = HORDE_BASE . '/config/' . $filename;
    if (file_exists($file)) {
        cli_log(sprintf(_("File \"%s\" is available."), $filename), 'message');
        continue;
    }

    cli_log(sprintf(_("File \"%s\" is missing."), $filename), 'warning');

    $distfile = $file . '.dist';
    if (file_exists($distfile)) {
        $create_config = $cli->prompt(sprintf(_("Create \"%s\" from defaults now?"), $filename), array('y' => _("Yes"), 'n' => _("No")));
        if ($create_config == 'y') {
            if (!copy($distfile, $file)) {
                $cli->fatal(sprintf(_("Copying \"%1$s.dist\" to \"%1$s\" failed. Check your installation."), $filename));
            }
            cli_log(sprintf(_("File %s created."), $filename), 'success');
        } else {
            $cli->fatal(sprintf(_("You need the \"%s\" file to continue setup and to use Horde."), $filename));
        }
    } else {
        $cli->fatal(sprintf(_("Cannot find \"%s\", check your installation."), $distfile));
    }
}

cli_log(_("Initial setup completed. Now continue the setup with your browser, go to: http://<Your Horde install URL>/admin/"), 'success');
exit;

/**
 * Wrap the messages with an indent, neater screen display.
 */
function cli_log($message, $type = 'message')
{
    $message = wordwrap($message, 69, "\n           ");
    $GLOBALS['cli']->message($message, 'cli.' . $type);
}
