#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
from os.path import getmtime, exists
import time
import types
import __builtin__
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import DummyTransaction
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from prewikka import User, utils
from prewikka.templates.MessageListing import MessageListing

##################################################
## MODULE CONSTANTS
try:
    True, False
except NameError:
    True, False = (1==1), (1==0)
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.0rc7'
__CHEETAH_versionTuple__ = (2, 0, 0, 'candidate', 7)
__CHEETAH_genTime__ = 1175335477.5699999
__CHEETAH_genTimestamp__ = 'Sat Mar 31 04:04:37 2007'
__CHEETAH_src__ = 'prewikka/templates/AlertListing.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Nov 18 04:30:32 2006'
__CHEETAH_docstring__ = 'Autogenerated by CHEETAH: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class AlertListing(MessageListing):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        MessageListing.__init__(self, *args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def head_extra_content(self, **KWS):



        ## CHEETAH: generated from #block head_extra_content at line 4, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
<script type="text/javascript">

<!-- 
function del_entry(link) {
	row = link.parentNode.parentNode
	table = row.parentNode
	if ( ! row.nextSibling ) {
                row.previousSibling.lastChild.appendChild(row.lastChild.firstChild)
	}

	table.removeChild(row)	
}

function end(row) {
	field = document.createElement("td")
	field.setAttribute("width", "11px")
	row.appendChild(field)

	if ( row.firstChild != row.lastChild ) {
		link = document.createElement("a")
		link.onclick = function(){ del_entry(this) }
		link.setAttribute("href", "#")
		content = document.createTextNode("-")
		link.appendChild(content)
		field.appendChild(link)		
	} else {
		content = document.createTextNode(" ")
		field.appendChild(content)
	}
}

''')
        for category, aggregations in VFN(VFFSL(SL,"available_aggregations",True),"items",False)(): # generated from line 37, col 1
            write('function aggregated_')
            _v = VFFSL(SL,"category",True) # '${category}' on line 38, col 21
            if _v is not None: write(_filter(_v, rawExpr='${category}')) # from line 38, col 21.
            write('_add_entry(path) {\n\ttable = document.getElementById("')
            _v = VFFSL(SL,"category",True) # '${category}' on line 39, col 35
            if _v is not None: write(_filter(_v, rawExpr='${category}')) # from line 39, col 35.
            write('''_aggregation_table")

        if ( table.lastChild && table.lastChild.nodeName == "TR" ) {
                table.lastChild.lastChild.removeChild(table.lastChild.lastChild.lastChild)
        }

        row = document.createElement("tr")
        table.appendChild(row)

        field = document.createElement("th")
        row.appendChild(field)
        content = document.createTextNode("Group entry by:")
        field.appendChild(content)

        field = document.createElement("td")
        row.appendChild(field)
        select = document.createElement("select")
        field.appendChild(select)

	select.setAttribute("name", "aggregated_''')
            _v = VFFSL(SL,"category",True) # '${category}' on line 58, col 42
            if _v is not None: write(_filter(_v, rawExpr='${category}')) # from line 58, col 42.
            write('")\n        \n')
            for aggregation_name, aggregated_path in VFFSL(SL,"aggregations",True): # generated from line 60, col 9
                write('        \n\toption = document.createElement("option")\n\toption.setAttribute("value", \'')
                _v = VFFSL(SL,"aggregated_path",True) # '$aggregated_path' on line 63, col 32
                if _v is not None: write(_filter(_v, rawExpr='$aggregated_path')) # from line 63, col 32.
                write("')\n\tif ( path == '")
                _v = VFFSL(SL,"aggregated_path",True) # '$aggregated_path' on line 64, col 16
                if _v is not None: write(_filter(_v, rawExpr='$aggregated_path')) # from line 64, col 16.
                write('''\' ) {
		option.setAttribute("selected", "true")
	}
	option_value = document.createTextNode(\'''')
                _v = VFFSL(SL,"aggregation_name",True) # '$aggregation_name' on line 67, col 42
                if _v is not None: write(_filter(_v, rawExpr='$aggregation_name')) # from line 67, col 42.
                write('''\')
	option.appendChild(option_value)
	select.appendChild(option)
        
''')
            write('''
	end(row)
	field = document.createElement("td")
	field.setAttribute("width", "11px")
	row.appendChild(field)

	link = document.createElement("a")
	link.onclick = function(){ aggregated_''')
            _v = VFFSL(SL,"category",True) # '${category}' on line 79, col 40
            if _v is not None: write(_filter(_v, rawExpr='${category}')) # from line 79, col 40.
            write('''_add_entry('') }
	link.setAttribute("href", "#")
	content = document.createTextNode("+")
	link.appendChild(content)
	field.appendChild(link)
}
''')
        write('\n')
        for name, objects in (
			  ("classification", (("text", "alert.classification.text"), 					      ("messageid", "alert.messageid"))                          ),

                          ("analyzer", (("name", "alert.analyzer.name"),                                         ("node location", "alert.analyzer.node.location"),                                         ("node address", "alert.analyzer.node.address.address"),                                         ("node name", "alert.analyzer.node.name"),                                         ("manufacturer", "alert.analyzer.manufacturer"),                                         ("model", "alert.analyzer.model"),                                         ("class", "alert.analyzer.class"),					("analyzerid", "alert.analyzer.analyzerid"))                          ), 

                          ("source", (("address", "alert.source.node.address.address"),                                       ("node name", "alert.source.node.name"),                                       ("user", "alert.source.user.user_id.name"),                                       ("process", "alert.source.process.name"),                                       ("service", "alert.source.service.name"),                                       ("port", "alert.source.service.port"),                                       ("interface", "alert.source.interface"))                          ), 
 
                          ("target", (("address", "alert.target.node.address.address"),                                       ("node name", "alert.target.node.name"),                                       ("user", "alert.target.user.user_id.name"),                                       ("process", "alert.target.process.name"),                                       ("service", "alert.target.service.name"),                                       ("port", "alert.target.service.port"),                                       ("interface", "alert.target.interface"),				      ("file path", "alert.target.file.path"))                          )
): # generated from line 87, col 1
            write('\nfunction ')
            _v = VFFSL(SL,"name",True) # '${name}' on line 122, col 10
            if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 122, col 10.
            write("_add_entry(object, value, num) {\n\ttable = document.getElementById('")
            _v = VFFSL(SL,"name",True) # '${name}' on line 123, col 35
            if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 123, col 35.
            write('''_table')

	if ( table.lastChild && table.lastChild.nodeName == "TR" ) {
		table.lastChild.lastChild.removeChild(table.lastChild.lastChild.lastChild)
	}

	row = document.createElement("tr")
	table.appendChild(row)

	field = document.createElement("th")
	content = document.createTextNode("Filter on:")
	field.appendChild(content)
	row.appendChild(field)
	
	field = document.createElement("td")
	row.appendChild(field)
	select = document.createElement("select")
	field.appendChild(select)
	select.setAttribute("name", "''')
            _v = VFFSL(SL,"name",True) # '${name}' on line 141, col 31
            if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 141, col 31.
            write('_object_" + num)\n        \n')
            for object_name, object in VFFSL(SL,"objects",True): # generated from line 143, col 1
                write('        \n\toption = document.createElement("option")\n\toption.setAttribute("value", \'')
                _v = VFFSL(SL,"object",True) # '$object' on line 146, col 32
                if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 146, col 32.
                write("')\n\tif ( object == '")
                _v = VFFSL(SL,"object",True) # '$object' on line 147, col 18
                if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 147, col 18.
                write('''\' ) {
		option.setAttribute("selected", "true")
	}
	option_value = document.createTextNode(\'''')
                _v = VFFSL(SL,"object_name",True) # '$object_name' on line 150, col 42
                if _v is not None: write(_filter(_v, rawExpr='$object_name')) # from line 150, col 42.
                write('''\')
	option.appendChild(option_value)
	select.appendChild(option)
        
''')
            write('''
	field = document.createElement("td")
	row.appendChild(field)
	input = document.createElement("input")
	field.appendChild(input)
	input.setAttribute("name", \'''')
            _v = VFFSL(SL,"name",True) # '${name}' on line 160, col 30
            if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 160, col 30.
            write('''_value_' + num)
	input.setAttribute("value", value)

	end(row)
	
	field = document.createElement("td")
	field.setAttribute("width", "11px")
	row.appendChild(field)
	link = document.createElement("a")
	link.onclick = function(){ ''')
            _v = VFFSL(SL,"name",True) # '${name}' on line 169, col 29
            if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 169, col 29.
            write('''_add_entry('', '', (num + 1)) };
	link.setAttribute("href", "#")
	content = document.createTextNode("+")
	link.appendChild(content)
	field.appendChild(link)
}

''')
        write('//--></script>\n\n')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def message_fields_header(self, **KWS):



        ## CHEETAH: generated from #block message_fields_header at line 182, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        self._CHEETAH__globalSetVars["address_cnt"] = 0
        write('''
<thead>
<tr>
  <td class="filter_popup">
    <a onclick="javascript:toggleFilteredColumnVisibility('classification');" href="#">Classification</a>
    <div id="classification">
      <table style="width: 100%;"><tbody id="classification_table" style="width: 100%;"></tbody></table>
      <script type="text/javascript">
''')
        cnt = 0
        for object, value in VFFSL(SL,"classification",True): # generated from line 193, col 9
            escaped_value = utils.escape_attribute(VFFSL(SL,"value",True))
            write('          classification_add_entry("')
            _v = VFFSL(SL,"object",True) # '$object' on line 195, col 37
            if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 195, col 37.
            write('", "')
            _v = VFFSL(SL,"escaped_value",True) # '$escaped_value' on line 195, col 48
            if _v is not None: write(_filter(_v, rawExpr='$escaped_value')) # from line 195, col 48.
            write('", ')
            _v = VFFSL(SL,"cnt",True) # '$cnt' on line 195, col 65
            if _v is not None: write(_filter(_v, rawExpr='$cnt')) # from line 195, col 65.
            write(')\n')
            cnt = VFFSL(SL,"cnt",True) + 1
        write('''      </script>

      <table style="width: 100%;"><tbody id="classification_aggregation_table"></tbody></table>
      <script type="text/javascript">
''')
        if len(VFFSL(SL,"aggregated_classification",True)) == 0: # generated from line 202, col 7
            write('        aggregated_classification_add_entry("")\n')
        else: # generated from line 204, col 7
            for path in VFFSL(SL,"aggregated_classification",True): # generated from line 205, col 9
                write("          aggregated_classification_add_entry('")
                _v = VFFSL(SL,"path",True) # '$path' on line 206, col 48
                if _v is not None: write(_filter(_v, rawExpr='$path')) # from line 206, col 48.
                write("')\n")
        write('''      </script>

      <table style="width: 100%;">
      <tr>
       <th>Severity:</th>

''')
        if "info" in VFFSL(SL,"alert.assessment.impact.severity",True): # generated from line 215, col 7
            checked = "checked='checked'"
        else: # generated from line 217, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.severity" value="info" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 220, col 104
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 220, col 104.
        write(' />info</td>\n\n')
        if "low" in VFFSL(SL,"alert.assessment.impact.severity",True): # generated from line 222, col 7
            checked = "checked='checked'"
        else: # generated from line 224, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.severity" value="low" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 227, col 103
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 227, col 103.
        write(' />low</td>\n\n')
        if "medium" in VFFSL(SL,"alert.assessment.impact.severity",True): # generated from line 229, col 7
            checked = "checked='checked'"
        else: # generated from line 231, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.severity" value="medium" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 234, col 106
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 234, col 106.
        write(' />medium</td>\n\n')
        if "high" in VFFSL(SL,"alert.assessment.impact.severity",True): # generated from line 236, col 7
            checked = "checked='checked'"
        else: # generated from line 238, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.severity" value="high" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 241, col 104
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 241, col 104.
        write(' />high</td>\n      \n')
        if "none" in VFFSL(SL,"alert.assessment.impact.severity",True): # generated from line 243, col 7
            checked = "checked='checked'"
        else: # generated from line 245, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.severity" value="none" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 248, col 104
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 248, col 104.
        write(''' />none</td>

      </tr>

      <tr>
       <th>Completion:</th>

      <td>&nbsp;</td>
      
''')
        if "succeeded" in VFFSL(SL,"alert.assessment.impact.completion",True): # generated from line 257, col 7
            checked = "checked='checked'"
        else: # generated from line 259, col 7
            checked = ""
        write('      <td colspan="2"><input class="checkbox" type="checkbox" name="alert.assessment.impact.completion" value="succeeded" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 262, col 123
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 262, col 123.
        write(' />succeeded</td>\n      \n')
        if "failed" in VFFSL(SL,"alert.assessment.impact.completion",True): # generated from line 264, col 7
            checked = "checked='checked'"
        else: # generated from line 266, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.completion" value="failed" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 269, col 108
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 269, col 108.
        write(' />failed</td>\n\n')
        if "none" in VFFSL(SL,"alert.assessment.impact.completion",True): # generated from line 271, col 7
            checked = "checked='checked'"
        else: # generated from line 273, col 7
            checked = ""
        write('      <td><input class="checkbox" type="checkbox" name="alert.assessment.impact.completion" value="none" ')
        _v = VFFSL(SL,"checked",True) # '$checked' on line 276, col 106
        if _v is not None: write(_filter(_v, rawExpr='$checked')) # from line 276, col 106.
        write(''' />none</td>
    </tr>
    </table>
    </div>

''')
        if VFFSL(SL,"classification_filtered",True): # generated from line 281, col 5
            write('      <span class="filter_enabled_marker">*</span>\n')
        write('''  </td>

  <td class="filter_popup">
    <a onclick="javascript:toggleFilteredColumnVisibility('source');" href="#">Source</a>
    <div id="source">
      <table style="width: 100%;"><tbody id="source_table"></tbody></table>
      <script type="text/javascript">
''')
        cnt = 0
        for object, value in VFFSL(SL,"source",True): # generated from line 292, col 9
            escaped_value = utils.escape_attribute(VFFSL(SL,"value",True))
            write('          source_add_entry("')
            _v = VFFSL(SL,"object",True) # '$object' on line 294, col 29
            if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 294, col 29.
            write('", "')
            _v = VFFSL(SL,"escaped_value",True) # '$escaped_value' on line 294, col 40
            if _v is not None: write(_filter(_v, rawExpr='$escaped_value')) # from line 294, col 40.
            write('", ')
            _v = VFFSL(SL,"cnt",True) # '$cnt' on line 294, col 57
            if _v is not None: write(_filter(_v, rawExpr='$cnt')) # from line 294, col 57.
            write(')\n')
            cnt += 1
        write('''      </script>
      <table style="width: 100%;"><tbody id="source_aggregation_table"></tbody></table>
      <script type="text/javascript">
''')
        if len(VFFSL(SL,"aggregated_source",True)) == 0: # generated from line 300, col 7
            write('        aggregated_source_add_entry("")\n')
        else: # generated from line 302, col 7
            for path in VFFSL(SL,"aggregated_source",True): # generated from line 303, col 9
                write("          aggregated_source_add_entry('")
                _v = VFFSL(SL,"path",True) # '$path' on line 304, col 40
                if _v is not None: write(_filter(_v, rawExpr='$path')) # from line 304, col 40.
                write("')\n")
        write('      </script>\n    </div>\n')
        if VFFSL(SL,"source_filtered",True): # generated from line 309, col 5
            write('      <span class="filter_enabled_marker">*</span>\n')
        write('''  </td>

  <td class="filter_popup">
    <a onclick="javascript:toggleFilteredColumnVisibility('target');" href="#">Target</a>
    <div id="target">
      <table style="width: 100%;"><tbody id="target_table"></tbody></table>
      <script type="text/javascript">
''')
        cnt = 0
        for object, value in VFFSL(SL,"target",True): # generated from line 320, col 9
            escaped_value = utils.escape_attribute(VFFSL(SL,"value",True))
            write('          target_add_entry("')
            _v = VFFSL(SL,"object",True) # '$object' on line 322, col 29
            if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 322, col 29.
            write('", "')
            _v = VFFSL(SL,"escaped_value",True) # '$escaped_value' on line 322, col 40
            if _v is not None: write(_filter(_v, rawExpr='$escaped_value')) # from line 322, col 40.
            write('", ')
            _v = VFFSL(SL,"cnt",True) # '$cnt' on line 322, col 57
            if _v is not None: write(_filter(_v, rawExpr='$cnt')) # from line 322, col 57.
            write(')\n')
            cnt = VFFSL(SL,"cnt",True) + 1
        write('''      </script>
      <table style="width: 100%;"><tbody id="target_aggregation_table"></tbody></table>
      <script type="text/javascript">
''')
        if len(VFFSL(SL,"aggregated_target",True)) == 0: # generated from line 328, col 7
            write('        aggregated_target_add_entry("")\n')
        else: # generated from line 330, col 7
            for path in VFFSL(SL,"aggregated_target",True): # generated from line 331, col 9
                write("          aggregated_target_add_entry('")
                _v = VFFSL(SL,"path",True) # '$path' on line 332, col 40
                if _v is not None: write(_filter(_v, rawExpr='$path')) # from line 332, col 40.
                write("')\n")
        write('      </script>\n    </div>\n')
        if VFFSL(SL,"target_filtered",True): # generated from line 337, col 5
            write('      <span class="filter_enabled_marker">*</span>\n')
        write('''  </td>
  
  <td class="filter_popup">
    <a onclick="javascript:toggleFilteredColumnVisibility('analyzer');" href="#">Sensor</a>
    <div id="analyzer">
    <table style="width: 100%;"><tbody id="analyzer_table"></tbody></table>
        <script  type="text/javascript">
''')
        cnt = 0
        for object, value in VFFSL(SL,"analyzer",True): # generated from line 348, col 11
            escaped_value = utils.escape_attribute(VFFSL(SL,"value",True))
            write('            analyzer_add_entry("')
            _v = VFFSL(SL,"object",True) # '$object' on line 350, col 33
            if _v is not None: write(_filter(_v, rawExpr='$object')) # from line 350, col 33.
            write('", "')
            _v = VFFSL(SL,"escaped_value",True) # '$escaped_value' on line 350, col 44
            if _v is not None: write(_filter(_v, rawExpr='$escaped_value')) # from line 350, col 44.
            write('", ')
            _v = VFFSL(SL,"cnt",True) # '$cnt' on line 350, col 61
            if _v is not None: write(_filter(_v, rawExpr='$cnt')) # from line 350, col 61.
            write(')\n')
            cnt = VFFSL(SL,"cnt",True) + 1
        write('        </script>\n    </div>\n')
        if VFFSL(SL,"analyzer_filtered",True): # generated from line 355, col 5
            write('      <span class="filter_enabled_marker">*</span>\n')
        write('''  </td>

  <td>Time</td>

  <td>
    <input src="prewikka/images/search.png" type="image" style="border: 0;" />
  </td>
</tr>
</thead>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def message_fields(self, **KWS):



        ## CHEETAH: generated from #block message_fields at line 370, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('\n<td>\n')
        if VFFSL(SL,"message.correlation_alert_name",True): # generated from line 373, col 3
            write('    <b>Correlation Alert')
            if VFFSL(SL,"message.correlated_alert_display",True): # generated from line 375, col 5
                plural = ""
                if VFFSL(SL,"message.correlated_alert_number",True) > 1: # generated from line 377, col 7
                    plural = "s"
                write('      (<a href="')
                _v = VFFSL(SL,"message.correlated_alert_display",True) # '$message.correlated_alert_display' on line 380, col 17
                if _v is not None: write(_filter(_v, rawExpr='$message.correlated_alert_display')) # from line 380, col 17.
                write('">')
                _v = VFFSL(SL,"message.correlated_alert_number",True) # '$message.correlated_alert_number' on line 380, col 52
                if _v is not None: write(_filter(_v, rawExpr='$message.correlated_alert_number')) # from line 380, col 52.
                write('</a> alert')
                _v = VFFSL(SL,"plural",True) # '$plural' on line 380, col 94
                if _v is not None: write(_filter(_v, rawExpr='$plural')) # from line 380, col 94.
                write(')')
            write(':</b> <i><a href="')
            _v = VFFSL(SL,"message.correlation_alert_link",True) # '$message.correlation_alert_link' on line 382, col 19
            if _v is not None: write(_filter(_v, rawExpr='$message.correlation_alert_link')) # from line 382, col 19.
            write('">')
            _v = VFFSL(SL,"message.correlation_alert_name",True) # '$message.correlation_alert_name' on line 382, col 52
            if _v is not None: write(_filter(_v, rawExpr='$message.correlation_alert_name')) # from line 382, col 52.
            write('</a></i><br/>')
        write('\n')
        if VFFSL(SL,"message.aggregated",True) and VFFSL(SL,"message.aggregated_classifications_hidden",True) > 0: # generated from line 385, col 3
            write('    <b>(')
            _v = VFFSL(SL,"message.aggregated_classifications_hidden",True) # '$message.aggregated_classifications_hidden' on line 386, col 9
            if _v is not None: write(_filter(_v, rawExpr='$message.aggregated_classifications_hidden')) # from line 386, col 9.
            write('/')
            _v = VFFSL(SL,"message.aggregated_classifications_total",True) # '$message.aggregated_classifications_total' on line 386, col 52
            if _v is not None: write(_filter(_v, rawExpr='$message.aggregated_classifications_total')) # from line 386, col 52.
            write(' alerts not shown...\n    <a href="')
            _v = VFFSL(SL,"message.aggregated_classifications_hidden_expand",True) # '$message.aggregated_classifications_hidden_expand' on line 387, col 14
            if _v is not None: write(_filter(_v, rawExpr='$message.aggregated_classifications_hidden_expand')) # from line 387, col 14.
            write('">expand</a>)</b>\n    <br/>\n')
        write('\n')
        for info in VFFSL(SL,"message.infos",True): # generated from line 391, col 3
            if VFFSL(SL,"message.aggregated",True) and (len(VFFSL(SL,"message.infos",True)) > 1 or VFFSL(SL,"info.count",True) > 1): # generated from line 392, col 5
                write('      ')
                _v = VFFSL(SL,"info.count",True) # '$info.count' on line 393, col 7
                if _v is not None: write(_filter(_v, rawExpr='$info.count')) # from line 393, col 7.
                write(' x\n')
            write('     \n')
            if VFFSL(SL,"info.classification.value",True): # generated from line 396, col 5
                write('      <a class="impact_severity_')
                _v = VFFSL(SL,"info.severity.value",True) # '$info.severity.value' on line 397, col 33
                if _v is not None: write(_filter(_v, rawExpr='$info.severity.value')) # from line 397, col 33.
                write('" href="')
                _v = VFFSL(SL,"info.display",True) # '$info.display' on line 397, col 61
                if _v is not None: write(_filter(_v, rawExpr='$info.display')) # from line 397, col 61.
                write('">')
                _v = VFFSL(SL,"info.classification.value",True) # '$info.classification.value' on line 397, col 76
                if _v is not None: write(_filter(_v, rawExpr='$info.classification.value')) # from line 397, col 76.
                write('</a>\n')
            else: # generated from line 398, col 5
                write('      <a class="impact_severity_')
                _v = VFFSL(SL,"info.severity.value",True) # '$info.severity.value' on line 399, col 33
                if _v is not None: write(_filter(_v, rawExpr='$info.severity.value')) # from line 399, col 33.
                write('" href="')
                _v = VFFSL(SL,"info.display",True) # '$info.display' on line 399, col 61
                if _v is not None: write(_filter(_v, rawExpr='$info.display')) # from line 399, col 61.
                write('">n/a</a>\n')
            write('\n')
            if VFFSL(SL,"info.completion.value",True): # generated from line 402, col 5
                write('      (<span class="impact_completion_')
                _v = VFFSL(SL,"info.completion.value",True) # '$info.completion.value' on line 403, col 39
                if _v is not None: write(_filter(_v, rawExpr='$info.completion.value')) # from line 403, col 39.
                write('">')
                _v = VFFSL(SL,"info.completion.value",True) # '$info.completion.value' on line 403, col 63
                if _v is not None: write(_filter(_v, rawExpr='$info.completion.value')) # from line 403, col 63.
                write('</span>)\n')
            write('\n    <br/>')
            _v = VFFSL(SL,"info.classification_references",True) # '$info.classification_references' on line 406, col 10
            if _v is not None: write(_filter(_v, rawExpr='$info.classification_references')) # from line 406, col 10.
            write('\n')
        write('</td>\n\n')
        for name, direction in ("source", VFFSL(SL,"message.source",True)), ("target", VFFSL(SL,"message.target",True)): # generated from line 410, col 1
            write('<td>\n')
            if len(VFFSL(SL,"direction",True)) == 0: # generated from line 412, col 1
                write('       n/a\n')
            write('\n')
            need_hr = 0
            write('\n')
            for direction in VFFSL(SL,"direction",True)      : # generated from line 418, col 1
                if VFFSL(SL,"need_hr",True): # generated from line 419, col 7
                    write('\t<hr style="border: 1px dashed #808080; margin-top: 3px; margin-bottom: 0px;" />\n')
                write('\n')
                need_hr = 1
                service = ""
                proto_param = ""
                proto_str = ""
                write('    \n')
                if VFFSL(SL,"direction.protocol.value",True) != None: # generated from line 428, col 7
                    proto_str = VFN(VFFSL(SL,"direction.protocol.value",True),"lower",False)()
                    proto_param = "&amp;protocol=" + VFN(VFFSL(SL,"direction.protocol.value",True),"upper",False)()
                write('\n')
                if VFFSL(SL,"direction.service.value",True) != None: # generated from line 433, col 7
                    service = ":<a target=\"$prewikka.external_link_target\" href=\"https://www.prelude-ids.com/port_details.php?port="
                    service += VFFSL(SL,"str",False)(VFFSL(SL,"direction.service.value",True)) + VFFSL(SL,"proto_param",True) + "\">" + VFFSL(SL,"str",False)(VFFSL(SL,"direction.service.value",True))
                    write('       \n')
                    if VFFSL(SL,"proto_str",True): # generated from line 437, col 8
                        service += "/" + VFFSL(SL,"proto_str",True) + "</a>"
                    else: # generated from line 439, col 8
                        service += "</a>"
                    write('\n')
                elif VFFSL(SL,"proto_str",True): # generated from line 443, col 7
                    service += ":" + VFFSL(SL,"proto_str",True)
                write('\n')
                for address in VFFSL(SL,"direction.addresses",True): # generated from line 447, col 7
                    write('       <a href="#" onclick="javascript:toggleVisibilityUnique(\'menu_')
                    _v = VFFSL(SL,"address_cnt",True) # '$address_cnt' on line 448, col 69
                    if _v is not None: write(_filter(_v, rawExpr='$address_cnt')) # from line 448, col 69.
                    write('\'); return false;">')
                    _v = VFFSL(SL,"address.value",True) # '$address.value' on line 448, col 100
                    if _v is not None: write(_filter(_v, rawExpr='$address.value')) # from line 448, col 100.
                    write('</a>')
                    _v = VFFSL(SL,"service",True) # '$service' on line 448, col 118
                    if _v is not None: write(_filter(_v, rawExpr='$service')) # from line 448, col 118.
                    write('<br />\n       <span id="menu_')
                    _v = VFFSL(SL,"address_cnt",True) # '$address_cnt' on line 449, col 23
                    if _v is not None: write(_filter(_v, rawExpr='$address_cnt')) # from line 449, col 23.
                    write('" class="popup_menu">\n')
                    self._CHEETAH__globalSetVars["address_cnt"] += 1
                    write('\n         - <a href="')
                    _v = VFFSL(SL,"address.inline_filter",True) # '$address.inline_filter' on line 452, col 21
                    if _v is not None: write(_filter(_v, rawExpr='$address.inline_filter')) # from line 452, col 21.
                    write('">Filter on this ')
                    _v = VFFSL(SL,"name",True) # '$name' on line 452, col 60
                    if _v is not None: write(_filter(_v, rawExpr='$name')) # from line 452, col 60.
                    write('</a><br />\n \n')
                    if not VFFSL(SL,"address.category",True) or VFFSL(SL,"address.category",True) in ("ipv4-addr", "ipv4-net", "ipv6-addr", "ipv6-net"): # generated from line 454, col 8
                        write('         - <a target="')
                        _v = VFFSL(SL,"prewikka.external_link_target",True) # '$prewikka.external_link_target' on line 455, col 23
                        if _v is not None: write(_filter(_v, rawExpr='$prewikka.external_link_target')) # from line 455, col 23.
                        write('" href="https://www.prelude-ids.com/host_details.php?host=')
                        _v = VFFSL(SL,"address.value",True) # '$address.value' on line 455, col 111
                        if _v is not None: write(_filter(_v, rawExpr='$address.value')) # from line 455, col 111.
                        write('">')
                        _v = VFN(VFFSL(SL,"name",True),"capitalize",False)() # '$name.capitalize()' on line 455, col 127
                        if _v is not None: write(_filter(_v, rawExpr='$name.capitalize()')) # from line 455, col 127.
                        write(' information</a><br />\n\n')
                        for cmdname, link in VFFSL(SL,"address.host_commands",True): # generated from line 457, col 11
                            write('         - <a href="')
                            _v = VFFSL(SL,"link",True) # '$link' on line 458, col 21
                            if _v is not None: write(_filter(_v, rawExpr='$link')) # from line 458, col 21.
                            write('">')
                            _v = VFFSL(SL,"cmdname",True) # '$cmdname' on line 458, col 28
                            if _v is not None: write(_filter(_v, rawExpr='$cmdname')) # from line 458, col 28.
                            write('</a><br />\n')
                    write('\n       </span>\n')
                write('     \n')
                if VFFSL(SL,"len",False)(VFFSL(SL,"direction.addresses",True)) == 0 and VFFSL(SL,"service",True): # generated from line 465, col 7
                    write('\tservice: ')
                    _v = VFFSL(SL,"service",True)[1:] # '$service[1:]' on line 466, col 11
                    if _v is not None: write(_filter(_v, rawExpr='$service[1:]')) # from line 466, col 11.
                    write('\n')
                write('\n')
                if VFFSL(SL,"direction.users",True): # generated from line 469, col 7
                    if len(VFFSL(SL,"direction.users",True)) > 1: # generated from line 470, col 9
                        write('          users:\n')
                    else: # generated from line 472, col 9
                        write('          user:\n')
                    write('\n')
                    cnt = 0
                    for user in VFFSL(SL,"direction.users",True): # generated from line 477, col 9
                        if VFFSL(SL,"cnt",True) > 0: # generated from line 478, col 11
                            write('            ;&nbsp;\n')
                        write('          \n\t  ')
                        _v = VFFSL(SL,"user.user.value",True) # '$user.user.value' on line 482, col 4
                        if _v is not None: write(_filter(_v, rawExpr='$user.user.value')) # from line 482, col 4.
                        write('    \n\n')
                        if VFFSL(SL,"user.user_extra.value",True) != None: # generated from line 484, col 11
                            write('            (')
                            _v = VFFSL(SL,"user.user_extra.value",True) # '$user.user_extra.value' on line 485, col 14
                            if _v is not None: write(_filter(_v, rawExpr='$user.user_extra.value')) # from line 485, col 14.
                            write(')\n')
                        write('      \n')
                        cnt = VFFSL(SL,"cnt",True) + 1
                write('\n')
                if VFFSL(SL,"direction.process.value",True): # generated from line 492, col 7
                    write('        process: ')
                    _v = VFFSL(SL,"direction.process.value",True) # '$direction.process.value' on line 493, col 18
                    if _v is not None: write(_filter(_v, rawExpr='$direction.process.value')) # from line 493, col 18.
                    write('\n')
                    if VFFSL(SL,"direction.process_extra.value",True) != None: # generated from line 494, col 9
                        write('          (')
                        _v = VFFSL(SL,"direction.process_extra.value",True) # '$direction.process_extra.value' on line 495, col 12
                        if _v is not None: write(_filter(_v, rawExpr='$direction.process_extra.value')) # from line 495, col 12.
                        write(')\n')
                write('\n')
                if VFFSL(SL,"direction.interface.value",True): # generated from line 499, col 6
                    write('        interface: ')
                    _v = VFFSL(SL,"direction.interface.value",True) # '$direction.interface.value' on line 500, col 20
                    if _v is not None: write(_filter(_v, rawExpr='$direction.interface.value')) # from line 500, col 20.
                    write('\n')
                write('\n')
                cnt = 0
                for file in VFFSL(SL,"direction.files",True): # generated from line 504, col 6
                    if VFFSL(SL,"cnt",True) > 0: # generated from line 505, col 8
                        write('         <br />\n')
                    write('\n       <a href="')
                    _v = VFFSL(SL,"file.inline_filter",True) # '$file.inline_filter' on line 509, col 17
                    if _v is not None: write(_filter(_v, rawExpr='$file.inline_filter')) # from line 509, col 17.
                    write('">')
                    _v = VFFSL(SL,"file.value",True) # '$file.value' on line 509, col 38
                    if _v is not None: write(_filter(_v, rawExpr='$file.value')) # from line 509, col 38.
                    write('</a>\n')
                    cnt = VFFSL(SL,"cnt",True) + 1
            write('\n</td>\n')
        write('\n<td>\n')
        for sensor in VFFSL(SL,"message.sensors",True): # generated from line 518, col 3
            write('    <a href="')
            _v = VFFSL(SL,"sensor.name.inline_filter",True) # '$sensor.name.inline_filter' on line 519, col 14
            if _v is not None: write(_filter(_v, rawExpr='$sensor.name.inline_filter')) # from line 519, col 14.
            write('">')
            _v = VFFSL(SL,"sensor.name.value",True) # '$sensor.name.value' on line 519, col 42
            if _v is not None: write(_filter(_v, rawExpr='$sensor.name.value')) # from line 519, col 42.
            write('</a>\n')
            if VFFSL(SL,"sensor.node_name.value",True): # generated from line 520, col 5
                write('      (')
                _v = VFFSL(SL,"sensor.node_name.value",True) # '$sensor.node_name.value' on line 521, col 8
                if _v is not None: write(_filter(_v, rawExpr='$sensor.node_name.value')) # from line 521, col 8.
                write(')\n')
            write('    <br/>\n')
        write('</td>\n<td>\n')
        if VFFSL(SL,"message.aggregated",True): # generated from line 527, col 3
            if VFFSL(SL,"message.time_min.value",True) == VFFSL(SL,"message.time_max.value",True): # generated from line 528, col 5
                write('      ')
                _v = VFFSL(SL,"message.time_min.value",True) # '$message.time_min.value' on line 529, col 7
                if _v is not None: write(_filter(_v, rawExpr='$message.time_min.value')) # from line 529, col 7.
                write('\n')
            else: # generated from line 530, col 5
                write('      ')
                _v = VFFSL(SL,"message.time_max.value",True) # '$message.time_max.value' on line 531, col 7
                if _v is not None: write(_filter(_v, rawExpr='$message.time_max.value')) # from line 531, col 7.
                write(' -\n      ')
                _v = VFFSL(SL,"message.time_min.value",True) # '$message.time_min.value' on line 532, col 7
                if _v is not None: write(_filter(_v, rawExpr='$message.time_min.value')) # from line 532, col 7.
                write('\n')
        else: # generated from line 534, col 3
            write('    ')
            _v = VFFSL(SL,"message.time.value",True) # '$message.time.value' on line 535, col 5
            if _v is not None: write(_filter(_v, rawExpr='$message.time.value')) # from line 535, col 5.
            write('\n')
            if VFFSL(SL,"message.analyzer_time.value",True): # generated from line 536, col 5
                write('      (sent at ')
                _v = VFFSL(SL,"message.analyzer_time.value",True) # '$message.analyzer_time.value' on line 537, col 16
                if _v is not None: write(_filter(_v, rawExpr='$message.analyzer_time.value')) # from line 537, col 16.
                write(')\n')
        write('</td>\n\n')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def timeline_extra_content(self, **KWS):



        ## CHEETAH: generated from #block timeline_extra_content at line 544, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<tr>
  <td id="filter_control_label">Filter: </td>
  <td colspan="3">
  <select name="filter" size="1" class="filter_control_select">
  <option value="">&nbsp;</option>
''')
        for fltr in VFFSL(SL,"filters",True): # generated from line 550, col 3
            if VFFSL(SL,"fltr",True) == VFFSL(SL,"current_filter",True): # generated from line 551, col 5
                selected = "selected=\"selected\""
            else: # generated from line 553, col 5
                selected = ""
            write('    <option value="')
            _v = VFN(VFFSL(SL,"utils",True),"escape_html_string",False)(VFFSL(SL,"fltr",True)) # '$utils.escape_html_string($fltr)' on line 556, col 20
            if _v is not None: write(_filter(_v, rawExpr='$utils.escape_html_string($fltr)')) # from line 556, col 20.
            write('" ')
            _v = VFFSL(SL,"selected",True) # '$selected' on line 556, col 54
            if _v is not None: write(_filter(_v, rawExpr='$selected')) # from line 556, col 54.
            write('>')
            _v = VFFSL(SL,"fltr",True) # '$fltr' on line 556, col 64
            if _v is not None: write(_filter(_v, rawExpr='$fltr')) # from line 556, col 64.
            write('</option>\n')
        write('''  </select>
  </td>
</tr>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('\n')
        self.head_extra_content(trans=trans)
        write('\n\n')
        self.message_fields_header(trans=trans)
        write('\n\n')
        self.message_fields(trans=trans)
        write('\n')
        self.timeline_extra_content(trans=trans)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_AlertListing= 'writeBody'

## END CLASS DEFINITION

if not hasattr(AlertListing, '_initCheetahAttributes'):
    templateAPIClass = getattr(AlertListing, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(AlertListing)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=AlertListing()).run()


