/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import org.w3c.dom.Node;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableGridModel;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Misc;

public class TableFormatter {
    private WriterStyleCollection wsc;
    private boolean bApplyCellFormat;
    private TableGridModel table;
    private boolean[][] bHBorder;
    private boolean[][] bVBorder;
    private boolean[] bGlobalVBorder;
    private String[] sColumnWidth;
    private boolean bIsLongtable;
    private boolean bIsSubtable;

    public TableFormatter(WriterStyleCollection writerStyleCollection, TableGridModel tableGridModel, boolean bl, boolean bl2) {
        int n;
        int n2;
        this.wsc = writerStyleCollection;
        this.table = tableGridModel;
        this.bApplyCellFormat = bl2;
        int n3 = tableGridModel.getRowCount();
        int n4 = tableGridModel.getColCount();
        this.bHBorder = new boolean[n3 + 1][n4];
        for (n2 = 0; n2 <= n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                this.bHBorder[n2][n] = false;
            }
        }
        this.bVBorder = new boolean[n3][n4 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n <= n4; ++n) {
                this.bVBorder[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            while (n < n4) {
                Node node = tableGridModel.getCell(n2, n);
                String string = Misc.getAttribute(node, "table:style-name");
                StyleWithProperties styleWithProperties = writerStyleCollection.getCellStyle(string);
                int n5 = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-spanned"), 1);
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                if (styleWithProperties != null) {
                    String string2 = styleWithProperties.getProperty("fo:border");
                    if (string2 != null && !"none".equals(string2)) {
                        bl3 = true;
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                    }
                    if ((string2 = styleWithProperties.getProperty("fo:border-left")) != null && !"none".equals(string2)) {
                        bl3 = true;
                    }
                    if ((string2 = styleWithProperties.getProperty("fo:border-right")) != null && !"none".equals(string2)) {
                        bl4 = true;
                    }
                    if ((string2 = styleWithProperties.getProperty("fo:border-top")) != null && !"none".equals(string2)) {
                        bl5 = true;
                    }
                    if ((string2 = styleWithProperties.getProperty("fo:border-bottom")) != null && !"none".equals(string2)) {
                        bl6 = true;
                    }
                }
                boolean[] blArray = this.bVBorder[n2];
                int n6 = n;
                blArray[n6] = blArray[n6] | bl3;
                boolean[] blArray2 = this.bVBorder[n2];
                int n7 = n + n5;
                blArray2[n7] = blArray2[n7] | bl4;
                do {
                    boolean[] blArray3 = this.bHBorder[n2];
                    int n8 = n;
                    blArray3[n8] = blArray3[n8] | bl5;
                    boolean[] blArray4 = this.bHBorder[n2 + 1];
                    int n9 = n++;
                    blArray4[n9] = blArray4[n9] | bl6;
                } while (--n5 > 0);
            }
        }
        this.bIsSubtable = "table:sub-table".equals(tableGridModel.getTableNode().getNodeName());
        this.bGlobalVBorder = new boolean[n4 + 1];
        for (n2 = 0; n2 <= n4; ++n2) {
            n = 0;
            for (int i = 0; i < n3; ++i) {
                n += this.bVBorder[i][n2] ? 1 : -1;
            }
            this.bGlobalVBorder[n2] = n > 0;
        }
        this.sColumnWidth = new String[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            StyleWithProperties styleWithProperties = writerStyleCollection.getColumnStyle(tableGridModel.getCol(n2).getStyleName());
            if (styleWithProperties != null) {
                this.sColumnWidth[n2] = styleWithProperties.getProperty("style:column-width");
            }
            if (this.sColumnWidth[n2] != null) continue;
            this.sColumnWidth[n2] = "2cm";
        }
        String string = Misc.getAttribute(tableGridModel.getTableNode(), "table:style-name");
        StyleWithProperties styleWithProperties = writerStyleCollection.getTableStyle(string);
        this.bIsLongtable = !this.bIsSubtable && bl && !"false".equals(styleWithProperties.getProperty("style:may-break-between-rows"));
    }

    public boolean isLongtable() {
        return this.bIsLongtable;
    }

    public boolean isSubtable() {
        return this.bIsSubtable;
    }

    public void applyTableStyle(BeforeAfter beforeAfter) {
        String string;
        String string2 = Misc.getAttribute(this.table.getTableNode(), "table:style-name");
        StyleWithProperties styleWithProperties = this.wsc.getTableStyle(string2);
        int n = 99;
        if (styleWithProperties != null && !this.bIsSubtable) {
            string = styleWithProperties.getProperty("table:align");
            if ("left".equals(string)) {
                n = 108;
            } else if ("right".equals(string)) {
                n = 114;
            }
        }
        if (this.bIsLongtable) {
            beforeAfter.add("\\begin{longtable}[" + (char)n + "]", "\\end{longtable}");
        } else if (!this.bIsSubtable) {
            string = "center";
            switch (n) {
                case 99: {
                    string = "center";
                    break;
                }
                case 114: {
                    string = "flushright";
                    break;
                }
                case 108: {
                    string = "flushleft";
                }
            }
            beforeAfter.add("\\begin{" + string + "}\\begin{tabular}", "\\end{tabular}\\end{" + string + "}");
        } else {
            beforeAfter.add("\\hspace*{-\\tabcolsep}\\begin{tabular}", "\\end{tabular}\\hspace*{-\\tabcolsep}");
        }
        beforeAfter.add("{", "");
        if (this.bGlobalVBorder[0]) {
            beforeAfter.add("|", "");
        }
        int n2 = this.table.getColCount();
        for (int i = 0; i < n2; ++i) {
            beforeAfter.add("p{" + Misc.add(this.sColumnWidth[i], "-0.2cm") + "}", "");
            if (!this.bGlobalVBorder[i + 1]) continue;
            beforeAfter.add("|", "");
        }
        beforeAfter.add("}", "");
    }

    public String getInterrowMaterial(int n) {
        int n2 = this.table.getColCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.bHBorder[n][i]) continue;
            ++n3;
        }
        if (n3 == 0) {
            return "";
        }
        if (n3 == n2) {
            return "\\hline";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (bl && !this.bHBorder[n][i]) {
                stringBuffer.append(i).append("}");
                bl = false;
                continue;
            }
            if (bl || !this.bHBorder[n][i]) continue;
            stringBuffer.append("\\cline{").append(i + 1).append("-");
            bl = true;
        }
        if (bl) {
            stringBuffer.append(n2).append("}");
        }
        return stringBuffer.toString();
    }

    public void applyCellStyle(int n, int n2, BeforeAfter beforeAfter) {
        Node node = this.table.getCell(n, n2);
        int n3 = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-spanned"), 1);
        boolean bl = n2 == 0 && this.bVBorder[n][0] != this.bGlobalVBorder[0];
        boolean bl2 = this.bVBorder[n][n2 + 1] != this.bGlobalVBorder[n2 + 1];
        String string = this.sColumnWidth[n2];
        for (int i = n2 + 1; i < n2 + n3; ++i) {
            string = Misc.add(string, this.sColumnWidth[i]);
        }
        string = Misc.add(string, "-0.2cm");
        if (bl || bl2 || n3 > 1) {
            beforeAfter.add("\\multicolumn{" + n3 + "}{", "");
            if (n2 == 0 && this.bVBorder[n][0]) {
                beforeAfter.add("|", "");
            }
            beforeAfter.add("p{" + string + "}", "");
            if (this.bVBorder[n][n2 + n3]) {
                beforeAfter.add("|", "");
            }
            beforeAfter.add("}{", "}");
        }
        if (this.bApplyCellFormat) {
            StyleWithProperties styleWithProperties = this.wsc.getCellStyle(Misc.getAttribute(node, "table:style-name"));
            String string2 = "c";
            if (styleWithProperties != null) {
                String string3 = styleWithProperties.getProperty("fo:vertical-align");
                if ("".equals(string3)) {
                    string2 = "b";
                } else if ("top".equals(string3)) {
                    string2 = "b";
                } else if ("bottom".equals(string3)) {
                    string2 = "t";
                }
            }
            beforeAfter.add("\\begin{minipage}[" + string2 + "]{" + string + "}", "\\end{minipage}");
        }
    }
}

