/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: script.js,v 1.2 2006/01/19 20:01:49 craig_mcc Exp $
 */

// IE or not?
var g_isIE;
// storage for locations from application managed bean
var g_initial_location = null;
var g_initial_locations = new Array();
// storage or all locations
var g_locations = new Array();
// map
var g_map;
// XMLHttpRequest
var g_request = null;
// Div placeholders
var g_map_id;
var g_message_id;
var g_search_id;
var g_select_id;
var g_message;

// When the page loads:
//     prevent return key submits;
//     build search string;
//     build select options list; 
//     display initial map locations (if specified);
function load() {
    if (navigator.userAgent.toLowerCase().lastIndexOf("ie") != -1) g_isIE = true;
    if (g_isIE) {
        //prevent a return key from submitting the form
        document.forms[0].onsubmit = function(){return false;};
    } else {
        // don't allow return keys to submit the form
        document.forms[0].setAttribute("onsubmit","return false;");
    }
    buildSearchArea();
    buildSelectArea();
    if (g_message != null) {
        document.getElementById(g_message_id).innerHTML = 
            "<span style=\"color:red\">" + g_message + "</span>"; 
        return;
    }
    
    if (g_initial_location != null || g_initial_locations.length > 0) {
        displayMapLocations();
    }
}

// Build a single location element;
var buildLocation = function(locations, idx) {
    g_locations[idx] = new Location (
        getElementTextNS("", "Latitude", locations[idx], 0),
        getElementTextNS("", "Longitude", locations[idx], 0),
        getElementTextNS("", "Address", locations[idx], 0),
        getElementTextNS("", "City", locations[idx], 0),
        getElementTextNS("", "State", locations[idx], 0),
        getElementTextNS("", "Zip", locations[idx], 0),
        getElementTextNS("", "Country", locations[idx], 0)
    );
}

// Display initial map locations;
function displayMapLocations() {
    g_map = new GMap(document.getElementById(g_map_id));
    g_map.addControl(new GSmallMapControl());
    g_map.addControl(new GMapTypeControl());
    var locationsDOM;
    var locations;

    if (g_initial_location != null) {
        locationsDOM = parseXMLString(g_initial_location);
        locations = locationsDOM.getElementsByTagName("Result");
        for (var i = 0; i < locations.length; i++) {
            buildLocation(locations, i);
            var point = new GPoint(g_locations[i].Longitude, g_locations[i].Latitude);
            g_map.centerAndZoom(point, 13);
            displayMarker(point, i);
            document.getElementById(g_map_id).style.border = "2px solid";
        }
    } else if (g_initial_locations.length > 0) {
        for (var idx = 0; idx < g_initial_locations.length; idx++) {
            locationsDOM = parseXMLString(g_initial_locations[idx]);
            locations = locationsDOM.getElementsByTagName("Result");
            for (var i = 0; i < locations.length; i++) {
                buildLocation(locations, i);
                var point = new GPoint(g_locations[i].Longitude, g_locations[i].Latitude);
                g_map.centerAndZoom(point, 13);
                displayMarker(point, i);
                document.getElementById(g_map_id).style.border = "2px solid";
            }
        }
    }
}

// Parse xml string;
function parseXMLString(xmlString) {
    var returnDoc = null;
    if (!g_isIE) {
        var parser = new DOMParser();
        returnDoc =  parser.parseFromString(xmlString, "text/xml");
    } else {
        var myDocument = new ActiveXObject("Microsoft.XMLDOM")
        myDocument.async="false";
        returnDoc =  myDocument.loadXML(xmlString);  
    }
    return returnDoc;
}

function buildSearchArea() {
    var searchArea = document.getElementById(g_search_id);
    searchArea.innerHTML = "<table><tr><td>" + 
        "<input type=\"text\" name=\"location\" size=\"50\">" +
        "</td>" + "<td><input type=\"button\" value=\"Search\" onclick=\"getCoordinates()\"></td></tr></table><br>";
}

function buildSelectArea() {
    var selectArea = document.getElementById(g_select_id);
    selectArea.innerHTML = 
      "<select id=\"locationList\" size=\"1\" onchange=\"displayMap(this.options[this.selectedIndex].value)\">" +
        "<option value=\"\">Yahoo Suggest</option></select>";
}

// Display the map with a single location;
function displayMap(idx) {
    g_map = new GMap(document.getElementById(g_map_id));
    g_map.addControl(new GSmallMapControl());
    g_map.addControl(new GMapTypeControl());
    var point = new GPoint(g_locations[idx].Longitude, g_locations[idx].Latitude);
    g_map.centerAndZoom(point, 4);
    displayMarker(point, idx);
    document.getElementById(g_map_id).style.border = "2px solid";
}

function displayMarker(point, idx) {
    var marker = new GMarker(point);
    var markerInfo = "Address:" + g_locations[idx].GetAddress() + "<br/>" + 
        "Longitude:" + g_locations[idx].Longitude +
        "<br/>" + "Latitude:" + g_locations[idx].Latitude + "<br/>";
    GEvent.addListener(marker, "click",
        function() {
            marker.openInfoWindowHtml(markerInfo);
        });
    g_map.addOverlay(marker);
}


// Invoked when the 'Search' button is clicked;
function getCoordinates() {
    var context = initRequest();
    context.request.onreadystatechange = processRequest;
    context.request.send(context.params);
    return false;
}

function clearAll() {
    clearSelect();
    document.getElementById(g_message_id).innerHTML = '';
}
                                                                                                                          
function clearSelect() {
    var select = document.getElementById("locationList");
    while (select.length > 0) {
        select.remove(0);
    }
}

function buildLocationList() {
    var request = getXMLHttpRequest();
    var errors = request.responseXML.getElementsByTagName("Error");
    if (errors.length > 0) {
        document.getElementById(g_message_id).innerHTML = 
            "<span style=\"color:red\">" + 
            getElementTextNS("", "Message", errors[0], 0) + "</span>";
        return;
    }
    var locations = request.responseXML.getElementsByTagName("Result");
    if (locations.length < 1) {
        document.getElementById(g_message_id).innerHTML =
            "<span style=\"color:red\">No locations found for that entry.</span>";
        document.getElementById(g_select_id).style.display = 'none';
        return;
    }

    for (var i = 0; i < locations.length; i++) {
        buildLocation(locations, i);
        //Add node to the drop down
        var select = document.getElementById("locationList");
        var opt = document.createElement("option");
        opt.value = i;
        opt.appendChild(document.createTextNode(g_locations[i].GetAddress()));
        select.appendChild(opt);
    }
    if (locations.length > 1) {
        document.getElementById(g_select_id).style.display = 'block';
    } else {
        document.getElementById(g_select_id).style.display = 'none';
    }
    document.forms[0].location.value = g_locations[0].GetAddress();
    displayMap('0');
}

// Container for a location.
function Location (Latitude, Longitude, Address, City, State, Zip, Country) {
    this.Latitude = Latitude;
    this.Longitude = Longitude;
    this.Address = Address;
    this.City = City;
    this.State = State;
    this.Zip = Zip;
    this.Country = Country;
                                                                                                                          
    // Create well formatted location address
    this.GetAddress = function() {
        var addressItem = '';
        if (this.Address != '') {
            addressItem = this.Address;
        }
        if (this.City != '') {
            addressItem = (addressItem=='') ? this.City : addressItem + ", " + this.City;
        }
        if (this != '') {
            addressItem = (addressItem=='') ? this.State : addressItem + ", " + this.State;
        }
        if (this.Zip != '') {
            addressItem = (addressItem=='') ? this.Zip : addressItem + ", " + this.Zip;
        }
        if (this.Country != '') {
            addressItem = (addressItem=='') ? this.Country : addressItem + ", " + this.Country;
        }
        return addressItem;
    }
}

// Retrieve text of an XML document element, including elements using namespaces
function getElementTextNS(prefix, local, parentElem, index) {
    var result = "";
    if (prefix && isIE) {
        // IE/Windows way of handling namespaces
        result = parentElem.getElementsByTagName(prefix + ":" + local)[index];
    } else {
        // the namespace versions of this method
        // (getElementsByTagNameNS()) operate
        // differently in Safari and Mozilla, but both
        // return value with just local name, provided
        // there aren't conflicts with non-namespace element
        // names
        result = parentElem.getElementsByTagName(local)[index];
    }
    if (result) {
        // get text, accounting for possible
        // whitespace (carriage return) text nodes
        if (result.childNodes.length > 1) {
            return result.childNodes[1].nodeValue;
        } else {
                if (result.firstChild == null) return '';
            return result.firstChild.nodeValue;
        }
    } else {
        return "n/a";
    }
}

// XMLHttpRequest functions
function initRequest() {
    var stateName = "javax.faces.ViewState";
    var stateArray = window.document.getElementsByName(stateName);
    var stateValue = null;
    var params = "";
                                                                                                                        
    if (null != stateArray && 0 < stateArray.length) {
        stateValue = stateArray[0].value;
        var encodedValue = encodeURI(stateValue);
        var re = new RegExp("\\+", "g");
        var encodedPlusValue = encodedValue.replace(re, "\%2B");
        params = stateName + "=" + encodedPlusValue + "&";
    }
                                                                                                                        
    var formName = getCurrentFormId();
    params = params + formName + "=" + formName;
    var location= document.forms[0].location.value;
    params = params + "&location=" + location;
    var postbackURL = getPostbackURL();
    var request = getXMLHttpRequest();
                                                                                                                        
    request.open("POST", postbackURL, true);
    request.setRequestHeader("Content-Type", 
        "application/x-www-form-urlencoded");
    var result = new Array();
    result.request = request;
    result.params = params;
    return result;
}

function getXMLHttpRequest() {
  if (!g_request) {
    if (window.XMLHttpRequest) {
      g_request = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
      g_isIE = true;
      g_request = new ActiveXObject("Microsoft.XMLHTTP");
    }
  }
  return (g_request);
}
                                                                                                                        
function getPostbackURL() {
  return (window.document.forms[0].action);
}
                                                                                                                        
function getCurrentFormId() {
  return (window.document.forms[0].id);
}

function processRequest() {
    var request = getXMLHttpRequest();
    if (request.readyState == 4) {
        var clientId = "";
        if (request.status == 200) { 
            clearAll();
            buildLocationList();
        } else {
            document.getElementById(g_message_id).innerHTML = 
                "<span style=\"color:red\">There was a problem retrieving the XML: " + 
                request.statusText + "</span>";
        }
    }
}


