/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.transform.Source;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.ui.Util;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class TransformPanel
extends JPanel {
    private static final long serialVersionUID = -3449709794133206327L;
    public static final String DATA_XML_MODIFIED = "DATA_XML_MODIFIED";
    public static final String DATA_XSL_MODIFIED = "DATA_XSL_MODIFIED";
    public static final String DATA_OUTPUT_MODIFIED = "DATA_OUTPUT_MODIFIED";
    public static final String DATA_PROCESS_MODIFIED = "DATA_PROCESS_MODIFIED";
    public static final String DATA_OVERWRITE_MODIFIED = "DATA_OVERWRITE_MODIFIED";
    private URL baseURL;
    private Data data;
    private boolean initialized = false;
    private DataObject xmlDataObject;
    private String xml_stylesheet;
    private DataObject xslDataObject;
    private TransformHistory xmlHistory;
    private TransformHistory xslHistory;
    private boolean userSetOutput = false;
    private boolean userSetProcess = false;
    private String lastOutputFileExt = "html";
    private Object lastXSLObject = new Object();
    private boolean suppressXSL;
    private static final String[] SHOW_NAMES = new String[]{Util.THIS.getString("NAME_process_output_do_nothing"), Util.THIS.getString("NAME_process_output_apply_default_action"), Util.THIS.getString("NAME_process_output_open_in_browser")};
    private static final Object JUST_PREVIEW = new Preview();
    private JButton browseInputButton;
    private JButton browseXSLTButton;
    private JComboBox inputComboBox;
    private JLabel inputLabel;
    private JComboBox outputComboBox;
    private JLabel outputLabel;
    private JCheckBox overwriteCheckBox;
    private JComboBox showComboBox;
    private JLabel showLabel;
    private JComboBox transformComboBox;
    private JLabel transformLabel;

    public TransformPanel(DataObject xml, String xml_ss, DataObject xsl, boolean suppressXSL) throws MalformedURLException, FileStateInvalidException {
        this.initComponents();
        this.init(xml, xml_ss, xsl, suppressXSL);
        this.initAccessibility();
    }

    public TransformPanel(DataObject xml, String xml_ss, DataObject xsl) throws MalformedURLException, FileStateInvalidException {
        this(xml, xml_ss, xsl, false);
    }

    private void init(DataObject xml, String xml_ss, DataObject xsl, boolean supXSL) throws MalformedURLException, FileStateInvalidException {
        this.data = new Data();
        this.xmlDataObject = xml;
        this.xml_stylesheet = xml_ss;
        this.xslDataObject = xsl;
        this.suppressXSL = supXSL;
        if (this.xmlDataObject != null) {
            this.setInput(TransformUtil.getURLName(this.xmlDataObject.getPrimaryFile()));
            FileObject xmlFileObject = this.xmlDataObject.getPrimaryFile();
            this.xmlHistory = (TransformHistory)xmlFileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.xmlHistory != null) {
                this.setXSL(this.xmlHistory.getLastXSL());
            }
            if (this.data.xsl == null && this.xml_stylesheet != null) {
                this.setXSL(this.xml_stylesheet);
            }
            try {
                this.baseURL = xmlFileObject.getParent().getURL();
            }
            catch (FileStateInvalidException exc) {
                // empty catch block
            }
        }
        if (this.xslDataObject != null) {
            this.setXSL(TransformUtil.getURLName(this.xslDataObject.getPrimaryFile()));
            FileObject xslFileObject = this.xslDataObject.getPrimaryFile();
            this.xslHistory = (TransformHistory)xslFileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.data.xml == null && this.xslHistory != null) {
                this.setInput(this.xslHistory.getLastXML());
            }
            if (this.baseURL == null) {
                try {
                    this.baseURL = xslFileObject.getParent().getURL();
                }
                catch (FileStateInvalidException exc) {
                    // empty catch block
                }
            }
        }
        if (this.xmlHistory != null || this.xslHistory != null) {
            if (this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getLastXSLOutput());
            }
            if ((this.data.output == null || this.data.output instanceof String && "".equals(this.data.output)) && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getLastXMLOutput());
            }
            if (this.data.output == null) {
                this.setOutput(JUST_PREVIEW);
            }
        }
        if (this.xmlHistory != null) {
            this.setOverwriteOutput(this.xmlHistory.isOverwriteOutput());
            this.setProcessOutput(new Integer(this.xmlHistory.getProcessOutput()));
        } else if (this.xslHistory != null) {
            this.setOverwriteOutput(this.xslHistory.isOverwriteOutput());
            this.setProcessOutput(new Integer(this.xslHistory.getProcessOutput()));
        }
        this.ownInitComponents();
    }

    private void ownInitComponents() {
        this.updateXMLComboBoxModel(null);
        this.updateXSLComboBoxModel(null);
        this.updateComponents();
        this.setCaretPosition(this.inputComboBox);
        this.setCaretPosition(this.transformComboBox);
        this.setCaretPosition(this.outputComboBox);
    }

    private void setCaretPosition(JComboBox comboBox) {
        ComboBoxEditor cbEditor = comboBox.getEditor();
        final Component editorComponent = cbEditor.getEditorComponent();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TransformPanel.setCaretPosition: " + comboBox);
            Util.THIS.debug("    editorComponent = " + editorComponent);
        }
        if (editorComponent instanceof JTextField) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTextField textField = (JTextField)editorComponent;
                    int length = textField.getText().length();
                    textField.setCaretPosition(length);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    text[" + length + "]='" + textField.getText() + "' - " + textField.getCaretPosition());
                    }
                }
            });
        }
    }

    private void updateXMLComboBoxModel(Object prefItem) {
        String[] history = null;
        if (this.xmlDataObject == null && this.xslHistory != null) {
            history = this.xslHistory.getXMLs();
        }
        Vector<Object> cbModel = new Vector<Object>();
        if (prefItem != null) {
            cbModel.add(prefItem);
        }
        if (history != null) {
            for (int i = 0; i < history.length; ++i) {
                cbModel.add(history[i]);
            }
        }
        this.inputComboBox.setModel(new DefaultComboBoxModel(cbModel));
    }

    private void updateXSLComboBoxModel(Object prefItem) {
        String[] history = null;
        if (this.xslDataObject == null && this.xmlHistory != null) {
            history = this.xmlHistory.getXSLs();
        }
        Vector<Object> cbModel = new Vector<Object>();
        if (prefItem != null) {
            cbModel.add(prefItem);
        }
        if (this.xml_stylesheet != null) {
            cbModel.add(this.xml_stylesheet);
        }
        if (history != null) {
            for (int i = 0; i < history.length; ++i) {
                if (history[i] == null || history[i].equals(this.xml_stylesheet)) continue;
                cbModel.add(history[i]);
            }
        }
        this.transformComboBox.setModel(new DefaultComboBoxModel(cbModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitialized() {
        Data data = this.data;
        synchronized (data) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialized(boolean init) {
        Data data = this.data;
        synchronized (data) {
            this.initialized = init;
        }
    }

    private static String guessFileName(String xml) {
        String fileName = null;
        int slashIndex = xml.lastIndexOf(47);
        fileName = slashIndex != -1 ? xml.substring(slashIndex + 1) : xml;
        return fileName;
    }

    private String guessOutputFileExt() {
        String ext;
        block4: {
            ext = this.lastOutputFileExt;
            String xslObject = this.getXSL();
            if (xslObject != this.lastXSLObject) {
                try {
                    Source xslSource = TransformUtil.createSource(this.baseURL, xslObject);
                    ext = TransformUtil.guessOutputExt(xslSource);
                    this.lastXSLObject = xslObject;
                    this.lastOutputFileExt = ext;
                }
                catch (Exception exc) {
                    if (!Util.THIS.isLoggable()) break block4;
                    Util.THIS.debug("[TransformPanel] Cannot guess extension!", exc);
                }
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("[TransformPanel] I guess output has '" + ext + "' extension.");
        }
        return ext;
    }

    private Object guessOutputFile() {
        Object output = this.data.output;
        if (output == null || "".equals(output) || JUST_PREVIEW.equals(output)) {
            String origName = TransformPanel.guessFileName(this.data.xml);
            String origExt = "";
            int dotIndex = origName.lastIndexOf(46);
            if (dotIndex != -1) {
                origExt = origName.substring(dotIndex + 1);
                origName = origName.substring(0, dotIndex);
            }
            String ext = this.guessOutputFileExt();
            String plusName = "";
            if (ext.equals(origExt)) {
                plusName = Util.THIS.getString("NAME_plusNameIfSameName");
            }
            output = origName + plusName + "." + ext;
        }
        return output;
    }

    private void initOutputComboBox(Object defaultOutput) {
        this.outputComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{defaultOutput, JUST_PREVIEW}));
    }

    private void updateComponents() {
        boolean notXML;
        this.setInitialized(false);
        boolean bl = notXML = this.xmlDataObject == null;
        if (this.data.xml != null) {
            this.inputComboBox.setSelectedItem(this.data.xml);
            this.inputComboBox.setEditable(this.data.xml instanceof String);
        }
        this.inputComboBox.setEnabled(notXML);
        this.browseInputButton.setEnabled(notXML);
        if (this.suppressXSL) {
            this.transformLabel.setVisible(false);
            this.transformComboBox.setVisible(false);
            this.browseXSLTButton.setVisible(false);
        } else {
            this.transformLabel.setVisible(true);
            this.transformComboBox.setVisible(true);
            this.browseXSLTButton.setVisible(true);
            boolean notXSL = this.xslDataObject == null;
            this.transformComboBox.setEnabled(notXSL);
            this.browseXSLTButton.setEnabled(notXSL);
            if (this.data.xsl != null) {
                this.transformComboBox.setSelectedItem(this.data.xsl);
                this.transformComboBox.setEditable(this.data.xsl instanceof String);
            }
        }
        boolean canOutput = true;
        if (this.data.xml == null || this.data.xsl == null || this.data.xml.length() == 0 || this.data.xsl.length() == 0) {
            canOutput = false;
        }
        this.outputComboBox.setEnabled(canOutput);
        if (canOutput) {
            Object output = this.guessOutputFile();
            this.initOutputComboBox(output);
            this.outputComboBox.setSelectedItem(this.data.output != null ? output : JUST_PREVIEW);
            this.outputComboBox.setEditable(this.data.output != null);
        }
        if (this.data.overwrite != null) {
            this.overwriteCheckBox.setSelected(this.data.overwrite);
        }
        this.overwriteCheckBox.setEnabled(canOutput && this.data.output != null);
        if (this.data.process != null) {
            this.showComboBox.setSelectedIndex(this.data.process);
        } else {
            String ext = this.guessOutputFileExt().toLowerCase();
            if (ext.equals("html") || ext.equals("htm")) {
                this.showComboBox.setSelectedIndex(2);
            } else {
                this.showComboBox.setSelectedIndex(1);
            }
        }
        this.showComboBox.setEnabled(canOutput && this.data.output != null);
        this.setInitialized(true);
    }

    public Data getData() {
        return new Data(this.getInput(), this.getXSL(), this.getOutput(), this.isOverwriteOutput(), this.getProcessOutput());
    }

    public void setData(Data data) {
        this.data = data;
        this.updateComponents();
    }

    private String getInput() {
        return (String)this.inputComboBox.getSelectedItem();
    }

    private String getXSL() {
        return (String)this.transformComboBox.getSelectedItem();
    }

    private String getOutput() {
        Object output = this.outputComboBox.getSelectedItem();
        if (JUST_PREVIEW.equals(output)) {
            return null;
        }
        return (String)output;
    }

    private boolean isOverwriteOutput() {
        return this.overwriteCheckBox.isSelected();
    }

    private int getProcessOutput() {
        return this.showComboBox.getSelectedIndex();
    }

    private Dimension comboSize(int columns) {
        JTextField template = new JTextField();
        template.setColumns(columns);
        return template.getPreferredSize();
    }

    private void initComponents() {
        this.inputLabel = new JLabel();
        this.inputLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_XML_input_mnemonic"));
        this.inputComboBox = new JComboBox();
        this.browseInputButton = new JButton();
        this.transformLabel = new JLabel();
        this.transformLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_XSL_transform_mnemonic"));
        this.transformComboBox = new JComboBox();
        this.browseXSLTButton = new JButton();
        this.outputLabel = new JLabel();
        this.outputLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_trans_output_mnemonic"));
        this.outputComboBox = new JComboBox();
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteCheckBox.setMnemonic(Util.THIS.getChar("LBL_over_write_mnemonic"));
        this.showLabel = new JLabel();
        this.showLabel.setDisplayedMnemonic(Util.THIS.getChar("LBL_show_output_mnemonic"));
        this.showComboBox = new JComboBox();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.inputLabel.setLabelFor(this.inputComboBox);
        this.inputLabel.setText(Util.THIS.getString("LBL_XML_input"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.inputLabel, gridBagConstraints);
        this.inputComboBox.setEditable(true);
        this.inputComboBox.setPreferredSize(this.comboSize(40));
        this.inputComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.inputComboBox, gridBagConstraints);
        this.browseInputButton.setMnemonic(Util.THIS.getChar("LBL_browse_file_mnemonic"));
        this.browseInputButton.setText(Util.THIS.getString("LBL_browse_file"));
        this.browseInputButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.browseInputButton, gridBagConstraints);
        this.transformLabel.setLabelFor(this.transformComboBox);
        this.transformLabel.setText(Util.THIS.getString("LBL_XSL_transform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.transformLabel, gridBagConstraints);
        this.transformComboBox.setEditable(true);
        this.transformComboBox.setPreferredSize(this.comboSize(40));
        this.transformComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.transformComboBox, gridBagConstraints);
        this.browseXSLTButton.setMnemonic(Util.THIS.getChar("LBL_browse_xslt_mnemonic"));
        this.browseXSLTButton.setText(Util.THIS.getString("LBL_browse_xslt"));
        this.browseXSLTButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.browseXSLTButton, gridBagConstraints);
        this.outputLabel.setLabelFor(this.outputComboBox);
        this.outputLabel.setText(Util.THIS.getString("LBL_trans_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.outputLabel, gridBagConstraints);
        this.outputComboBox.setEditable(true);
        this.outputComboBox.setPreferredSize(this.comboSize(40));
        this.outputComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.outputComboBox, gridBagConstraints);
        this.overwriteCheckBox.setSelected(true);
        this.overwriteCheckBox.setText(Util.THIS.getString("LBL_over_write"));
        this.overwriteCheckBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.overwriteCheckBox, gridBagConstraints);
        this.showLabel.setText(Util.THIS.getString("LBL_show_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.showLabel, gridBagConstraints);
        this.showComboBox.setModel(new DefaultComboBoxModel<String>(SHOW_NAMES));
        this.showComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 6, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.showComboBox, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TransformPanel"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_overwriteCheckBox"));
        this.outputComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_outputComboBox"));
        this.inputComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_inputComboBox"));
        this.browseXSLTButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_browseXSLTButton"));
        this.showComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_showComboBox"));
        this.browseInputButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_browseInputButton"));
        this.transformComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_transformComboBox"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseXSLTButtonActionPerformed(ActionEvent evt) {
        try {
            File selectedFile = this.getFileFromChooser(this.getXSL());
            if (selectedFile == null) {
                return;
            }
            FileObject fo = FileUtil.toFileObject((File)selectedFile);
            DataObject dObj = DataObject.find((FileObject)fo);
            if (dObj == null || !TransformUtil.isXSLTransformation(dObj)) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_notXslFile", selectedFile.getName()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                return;
            }
            this.setXSL(TransformUtil.getURLName(fo));
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getXSLOutput(this.data.xsl));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateXSLComboBoxModel(this.data.xsl);
            this.updateComponents();
            this.setCaretPosition(this.transformComboBox);
        }
        catch (IOException exc) {
            Util.THIS.debug(exc);
        }
        finally {
            Util.icons = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseInputButtonActionPerformed(ActionEvent evt) {
        try {
            File selectedFile = this.getFileFromChooser(this.getInput());
            if (selectedFile == null) {
                return;
            }
            FileObject fo = FileUtil.toFileObject((File)selectedFile);
            DataObject dObj = DataObject.find((FileObject)fo);
            if (dObj == null || dObj.getCookie(TransformableCookie.class) == null) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_notXmlFile", selectedFile.getName()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                return;
            }
            this.setInput(TransformUtil.getURLName(fo));
            if (!this.userSetOutput && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getXMLOutput(this.data.xml));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateXMLComboBoxModel(this.data.xml);
            this.updateComponents();
            this.setCaretPosition(this.inputComboBox);
        }
        catch (IOException exc) {
            Util.THIS.debug(exc);
        }
        finally {
            Util.icons = null;
        }
    }

    public void setInput(String input) {
        if (this.data == null) {
            return;
        }
        String oldInput = this.data.getInput();
        this.data.setInput(input);
        this.firePropertyChange(DATA_XML_MODIFIED, oldInput, input);
    }

    public void setXSL(String xslValue) {
        if (this.data == null) {
            return;
        }
        String oldXSL = this.data.getXSL();
        this.data.setXSL(xslValue);
        this.firePropertyChange(DATA_XSL_MODIFIED, oldXSL, xslValue);
    }

    public void setOutput(Object outputValue) {
        if (this.data == null) {
            return;
        }
        Object oldOutput = this.data.getOutput();
        this.data.setOutput(outputValue);
        this.firePropertyChange(DATA_OUTPUT_MODIFIED, oldOutput, outputValue);
    }

    public void setOverwriteOutput(Boolean overwriteObject) {
        if (this.data == null || overwriteObject == null) {
            return;
        }
        this.setOverwriteOutput((boolean)overwriteObject);
    }

    public void setOverwriteOutput(boolean overwriteValue) {
        if (this.data == null) {
            return;
        }
        boolean oldOverwrite = this.data.isOverwriteOutput();
        this.data.setOverwriteOutput(overwriteValue);
        this.firePropertyChange(DATA_OVERWRITE_MODIFIED, oldOverwrite, overwriteValue);
    }

    public void setProcessOutput(Integer processObject) {
        if (this.data == null || processObject == null) {
            return;
        }
        this.setProcessOutput((int)processObject);
    }

    public void setProcessOutput(int processValue) {
        if (this.data == null) {
            return;
        }
        int oldProcess = this.data.getProcessOutput();
        this.data.setProcessOutput(processValue);
        this.firePropertyChange(DATA_PROCESS_MODIFIED, oldProcess, processValue);
    }

    private void showComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            this.setProcessOutput(new Integer(this.showComboBox.getSelectedIndex()));
            this.userSetProcess = true;
            this.updateComponents();
        }
    }

    private void overwriteCheckBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            this.setOverwriteOutput(this.overwriteCheckBox.isSelected());
            this.updateComponents();
        }
    }

    private void transformComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            String item = (String)this.transformComboBox.getSelectedItem();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.transformComboBoxActionPerformed: getSelectedItem = " + item);
            }
            if (item == null) {
                return;
            }
            this.setXSL(item.trim());
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getXSLOutput(this.data.xsl));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateComponents();
        }
    }

    private void inputComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            String item = (String)this.inputComboBox.getSelectedItem();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformPanel.inputComboBoxActionPerformed: getSelectedItem = " + item);
            }
            if (item == null) {
                return;
            }
            this.setInput(item.trim());
            if (!this.userSetOutput && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getXMLOutput(this.data.xml));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateComponents();
        }
    }

    private void outputComboBoxActionPerformed(ActionEvent evt) {
        if (this.isInitialized()) {
            Object item = this.outputComboBox.getSelectedItem();
            if (item instanceof String) {
                String str = ((String)item).trim();
                if (str.length() == 0) {
                    str = null;
                }
                item = str;
            }
            this.setOutput(item);
            this.userSetOutput = true;
            this.updateComponents();
        }
    }

    private File getFileFromChooser(String oldUrl) {
        JFileChooser chooser = new JFileChooser();
        if (oldUrl != null) {
            try {
                File parentDir;
                File file = null;
                URI url = new URI(oldUrl);
                if (url != null) {
                    file = new File(url);
                }
                if (file != null && (parentDir = file.getParentFile()) != null && parentDir.exists()) {
                    chooser.setCurrentDirectory(parentDir);
                }
            }
            catch (URISyntaxException ex) {
            }
            catch (IllegalArgumentException x) {
                // empty catch block
            }
        }
        File selectedFile = null;
        if (chooser.showOpenDialog(this) == 0) {
            selectedFile = chooser.getSelectedFile();
        }
        return selectedFile;
    }

    private static class Preview {
        private Preview() {
        }

        public String toString() {
            return Util.THIS.getString("NAME_output_just_preview");
        }
    }

    public static final class Data {
        private String xml;
        private String xsl;
        private Object output;
        private Boolean overwrite;
        private Integer process;

        public Data() {
            this.xml = null;
            this.xsl = null;
            this.output = "";
            this.overwrite = null;
            this.process = null;
        }

        public Data(String xml, String xsl, Object output, boolean overwrite, int process) {
            this.xml = xml;
            this.xsl = xsl;
            this.output = output;
            this.overwrite = overwrite ? Boolean.TRUE : Boolean.FALSE;
            this.process = process == -1 ? null : new Integer(process);
        }

        public String getInput() {
            return this.xml;
        }

        public String getXSL() {
            return this.xsl;
        }

        public Object getOutput() {
            return this.output;
        }

        public boolean isOverwriteOutput() {
            if (this.overwrite == null) {
                return false;
            }
            return this.overwrite;
        }

        public int getProcessOutput() {
            if (this.process == null) {
                return 0;
            }
            return this.process;
        }

        public void setInput(String input) {
            this.xml = input;
        }

        public void setXSL(String xslValue) {
            this.xsl = xslValue;
        }

        public void setOutput(Object outputValue) {
            this.output = JUST_PREVIEW.equals(outputValue) ? null : outputValue;
        }

        public void setOverwriteOutput(boolean overwriteValue) {
            this.overwrite = overwriteValue ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setProcessOutput(Integer processObject) {
            this.process = processObject;
        }

        public void setProcessOutput(int processValue) {
            this.setProcessOutput(new Integer(processValue));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append("[input='").append(this.xml).append("'; ");
            sb.append("xsl='").append(this.xsl).append("'; ");
            sb.append("output='").append(this.output).append("'; ");
            sb.append("overwrite='").append(this.overwrite).append("'; ");
            sb.append("process='").append(this.process).append("]");
            return sb.toString();
        }
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == TransformPanel.this.inputComboBox) {
                TransformPanel.this.inputComboBoxActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.browseInputButton) {
                TransformPanel.this.browseInputButtonActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.transformComboBox) {
                TransformPanel.this.transformComboBoxActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.browseXSLTButton) {
                TransformPanel.this.browseXSLTButtonActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.outputComboBox) {
                TransformPanel.this.outputComboBoxActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.overwriteCheckBox) {
                TransformPanel.this.overwriteCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == TransformPanel.this.showComboBox) {
                TransformPanel.this.showComboBoxActionPerformed(evt);
            }
        }
    }
}

