/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.xml;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetClassLoaderForClass;
import oracle.toplink.essentials.internal.security.PrivilegedNewInstanceFromClass;
import oracle.toplink.essentials.platform.xml.XMLPlatform;
import oracle.toplink.essentials.platform.xml.XMLPlatformException;

public class XMLPlatformFactory {
    public static final String XML_PLATFORM_PROPERTY = "toplink.xml.platform";
    public static final String XDK_PLATFORM_CLASS_NAME = "oracle.toplink.essentials.platform.xml.xdk.XDKPlatform";
    public static final String JAXP_PLATFORM_CLASS_NAME = "oracle.toplink.essentials.platform.xml.jaxp.JAXPPlatform";
    private static XMLPlatformFactory instance;
    private Class xmlPlatformClass;

    private XMLPlatformFactory() {
    }

    public static XMLPlatformFactory getInstance() throws XMLPlatformException {
        if (null == instance) {
            instance = new XMLPlatformFactory();
        }
        return instance;
    }

    public Class getXMLPlatformClass() throws XMLPlatformException {
        if (null != this.xmlPlatformClass) {
            return this.xmlPlatformClass;
        }
        String newXMLPlatformClassName = System.getProperty(XML_PLATFORM_PROPERTY);
        if (null == newXMLPlatformClassName) {
            newXMLPlatformClassName = JAXP_PLATFORM_CLASS_NAME;
        }
        try {
            ClassLoader classLoader = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(this.getClass()));
                }
                catch (PrivilegedActionException exc) {}
            } else {
                classLoader = PrivilegedAccessHelper.getClassLoaderForClass(this.getClass());
            }
            Class<?> newXMLPlatformClass = classLoader.loadClass(newXMLPlatformClassName);
            this.setXMLPlatformClass(newXMLPlatformClass);
            return this.xmlPlatformClass;
        }
        catch (ClassNotFoundException e) {
            throw XMLPlatformException.xmlPlatformClassNotFound(newXMLPlatformClassName, e);
        }
    }

    public void setXMLPlatformClass(Class xmlPlatformClass) {
        this.xmlPlatformClass = xmlPlatformClass;
    }

    public XMLPlatform getXMLPlatform() throws XMLPlatformException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (XMLPlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getXMLPlatformClass()));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof InstantiationException) {
                        throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), throwableException);
                    }
                    throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), throwableException);
                }
            }
            return (XMLPlatform)PrivilegedAccessHelper.newInstanceFromClass(this.getXMLPlatformClass());
        }
        catch (IllegalAccessException e) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), e);
        }
        catch (InstantiationException e) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), e);
        }
    }
}

