/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.CommentRenameFinder;
import org.netbeans.modules.refactoring.RenameUsageElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RenameRefactoringPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    private RefObject jmiObject = null;
    private String newName = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private FileObject originalFolder = null;
    private Set varNames;
    private RenameRefactoring refactoring;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin;

    public RenameRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        this.jmiObject = (RefObject)rename.getRefactoredObject();
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getNewName());
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getNewName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            Problem result = RenameRefactoringPlugin.isElementAvail((Element)this.jmiObject);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Resource res = ((Element)this.jmiObject).getResource();
            if (res != null && CheckUtils.isFromLibrary(res)) {
                Problem problem = RenameRefactoringPlugin.createProblem(result, true, RenameRefactoringPlugin.getCannotRename(res));
                return problem;
            }
            if (res != null && !CheckUtils.isElementInOpenProject((Element)this.jmiObject)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (this.jmiObject instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
                return problem;
            }
            if (this.jmiObject instanceof Method) {
                this.fireProgressListenerStep();
                Method m = (Method)this.jmiObject;
                List argTypes = this.getParamTypes(m);
                this.fireProgressListenerStep();
                this.overriddenByMethods = this.overriddenBy(m, m.getName(), argTypes);
                this.fireProgressListenerStep();
                if (!this.overriddenByMethods.isEmpty()) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{this.getDefClassName(m.getDeclaringClass())});
                    result = RenameRefactoringPlugin.createProblem(result, false, msg);
                }
                ClassDefinition[] par = new ClassDefinition[]{null, null};
                this.overridesMethods = this.overrides(m, m.getName(), argTypes, par);
                this.fireProgressListenerStep();
                if (!this.overridesMethods.isEmpty()) {
                    if (par[0] == null) {
                        boolean fatal = false;
                        Iterator iter = this.overridesMethods.iterator();
                        while (iter.hasNext()) {
                            Method method = (Method)iter.next();
                            if (!CheckUtils.isFromLibrary(method.getResource())) continue;
                            fatal = true;
                            break;
                        }
                        String msg = fatal ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                        result = RenameRefactoringPlugin.createProblem(result, fatal, msg);
                    } else {
                        String clsName = this.getDefClassName(par[0]);
                        String msg = CheckUtils.isFromLibrary(par[0].getResource()) ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : new MessageFormat(RenameRefactoringPlugin.getString("ERR_Overrides_tree")).format(new Object[]{clsName, this.getDefClassName(par[1]), clsName});
                        result = RenameRefactoringPlugin.createProblem(result, true, msg);
                    }
                }
            } else if (this.jmiObject instanceof Field) {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                Field f = (Field)this.jmiObject;
                Field hiddenField = this.hides(f, f.getName());
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (hiddenField != null) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{this.getDefClassName(hiddenField.getDeclaringClass())});
                    result = RenameRefactoringPlugin.createProblem(result, false, msg);
                }
            } else if (!(this.jmiObject instanceof JavaPackage || this.jmiObject instanceof Variable || this.jmiObject instanceof Attribute || this.jmiObject instanceof JavaClass)) {
                this.fireProgressListenerStep();
                if (!(this.jmiObject instanceof Resource) || !((Resource)this.jmiObject).getClassifiers().isEmpty()) {
                    result = RenameRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_RenameWrongType"));
                }
            }
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private static final String getCannotRename(Resource r) {
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotRenameFile")).format(new Object[]{r.getName()});
    }

    private Problem checkParameters(String newName) {
        String msg;
        Problem result = null;
        if (this.getElementName((NamedElement)this.jmiObject).equals(newName)) {
            RefFeatured comp;
            boolean nameNotChanged = true;
            if (this.jmiObject instanceof JavaClass && (comp = this.jmiObject.refImmediateComposite()) instanceof Resource && RenameRefactoringPlugin.isResourceClass((Resource)comp, this.jmiObject)) {
                String dobjName = JavaMetamodel.getManager().getDataObject((Resource)comp).getName();
                nameNotChanged = dobjName.equals(newName);
            }
            if (nameNotChanged) {
                return RenameRefactoringPlugin.createProblem(result, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            }
        }
        if (!Utilities.isJavaIdentifier((String)newName)) {
            String s = this.jmiObject instanceof JavaPackage ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String msg2 = new MessageFormat(s).format(new Object[]{newName});
            result = RenameRefactoringPlugin.createProblem(result, true, msg2);
            return result;
        }
        if (this.jmiObject instanceof JavaPackage) {
            if (this.doCheckName) {
                ClassPath projectClassPath;
                JavaPackage pckg = (JavaPackage)this.jmiObject;
                String fullName = pckg.getName();
                int last = fullName.lastIndexOf(46);
                String name = last > 0 ? fullName.substring(0, last + 1) + newName : newName;
                if (this.originalFolder != null && (projectClassPath = ClassPath.getClassPath((FileObject)this.originalFolder, (String)"classpath/source")).findResource(name.replace('.', '/')) != null) {
                    String msg3 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_PackageExists")).format(new Object[]{newName});
                    result = RenameRefactoringPlugin.createProblem(result, true, msg3);
                }
            }
            this.newName = newName;
            return result;
        }
        if ((this.jmiObject instanceof JavaClass || this.jmiObject instanceof Resource) && this.doCheckName) {
            RefObject ref;
            if (this.jmiObject instanceof Resource) {
                ref = this.jmiObject;
            } else {
                FileObject fo;
                ClassPath cp;
                ref = this.jmiObject.refImmediateComposite();
                String pkgname = ((NamedElement)this.jmiObject).getName();
                int i = pkgname.indexOf(46);
                pkgname = i >= 0 ? pkgname.substring(0, i) : "";
                String fqn = "".equals(pkgname) ? newName : pkgname + '.' + newName;
                JavaClass clazz = ClassIndex.getClassByFqn((String)fqn, (ClassPath)(cp = ClassPath.getClassPath((FileObject)(fo = JavaModel.getFileObject((Resource)((Element)ref).getResource())), (String)"classpath/source")));
                if (clazz != null && !this.jmiObject.equals(clazz)) {
                    String msg4 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, pkgname});
                    return RenameRefactoringPlugin.createProblem(result, true, msg4);
                }
            }
            if (ref instanceof Resource && !JavaMetamodel.getManager().getDataObject((Resource)ref).getName().equals(newName)) {
                DataObject dobj = JavaMetamodel.getManager().getDataObject((Resource)ref);
                FileObject primFile = dobj.getPrimaryFile();
                FileObject folder = primFile.getParent();
                FileObject[] children = folder.getChildren();
                for (int x = 0; x < children.length; ++x) {
                    if (children[x] == primFile || children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
                    String msg5 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, ((Resource)ref).getPackageName()});
                    result = RenameRefactoringPlugin.createProblem(result, true, msg5);
                    break;
                }
            }
        }
        if (this.jmiObject instanceof Feature && (msg = this.clashes((Feature)this.jmiObject, newName)) != null) {
            result = RenameRefactoringPlugin.createProblem(result, true, msg);
            return result;
        }
        if (this.jmiObject instanceof Variable && (msg = this.variableClashes(newName, JavaModelUtil.getDeclaringFeature((Element)((Variable)this.jmiObject)))) != null) {
            result = RenameRefactoringPlugin.createProblem(result, true, msg);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(String newName) {
        int steps = 0;
        if (this.overriddenByMethods != null) {
            steps += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            steps += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * steps);
        try {
            this.fireProgressListenerStep();
            Problem result = this.checkParameters(newName);
            if (result != null && result.isFatal()) {
                Problem problem = result;
                return problem;
            }
            this.fireProgressListenerStep();
            if (this.jmiObject instanceof Method) {
                String msg;
                Method m = (Method)this.jmiObject;
                result = this.checkMethodForOverriding(m, newName, result);
                Iterator iter = this.overridesMethods.iterator();
                while (iter.hasNext()) {
                    m = (Method)iter.next();
                    msg = this.clashes((Feature)m, newName);
                    if (msg != null) {
                        result = RenameRefactoringPlugin.createProblem(result, true, msg);
                    }
                    result = this.checkMethodForOverriding(m, newName, result);
                }
                iter = this.overriddenByMethods.iterator();
                while (iter.hasNext()) {
                    m = (Method)iter.next();
                    msg = this.clashes((Feature)m, newName);
                    if (msg != null) {
                        result = RenameRefactoringPlugin.createProblem(result, true, msg);
                    }
                    result = this.checkMethodForOverriding(m, newName, result);
                }
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
            } else if (this.jmiObject instanceof Field) {
                Field f = (Field)this.jmiObject;
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                Field hiddenField = this.hides(f, newName);
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (hiddenField != null) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{this.getDefClassName(hiddenField.getDeclaringClass())});
                    result = RenameRefactoringPlugin.createProblem(result, false, msg);
                }
            }
            if (result == null || !result.isFatal()) {
                this.newName = newName;
            }
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private Problem checkMethodForOverriding(Method m, String newName, Problem problem) {
        List argTypes = this.getParamTypes(m);
        this.fireProgressListenerStep();
        problem = this.willBeOverridden(m, newName, argTypes, problem);
        this.fireProgressListenerStep();
        problem = this.willOverride(m, newName, argTypes, problem);
        this.fireProgressListenerStep();
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag elements) {
        this.varNames = null;
        CommentRenameFinder docFinder = null;
        if (this.newName == null) {
            return new Problem(true, RenameRefactoringPlugin.getString("ERR_NameNotSet"));
        }
        int steps = 9;
        if (this.overriddenByMethods != null) {
            steps += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            steps += this.overridesMethods.size();
        }
        JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
        try {
            Method m;
            Iterator iter;
            if (this.refactoring.isSearchInComments()) {
                docFinder = new CommentRenameFinder((Element)this.jmiObject, this.newName);
                elements.addAll(this.refactoring, docFinder.searchCommentsInResource(((Element)this.jmiObject).getResource()));
            }
            if (this.jmiObject instanceof JavaPackage) {
                DataFolder folder;
                this.referencesIterator = ((NamedElement)this.jmiObject).getReferences().iterator();
                while (this.referencesIterator.hasNext()) {
                    Element element = (Element)this.referencesIterator.next();
                    if (this.cancelRequest) {
                        Problem problem = null;
                        return problem;
                    }
                    if (this.refactoring.isSearchInComments()) {
                        elements.addAll(this.refactoring, docFinder.searchCommentsInResource(element.getResource()));
                    }
                    elements.add(this.refactoring, new RenamePackageElement(this.jmiObject, element, this.newName));
                }
                DataFolder dataFolder = folder = this.originalFolder != null ? DataFolder.findFolder((FileObject)this.originalFolder) : this.getFolder(((JavaPackage)this.jmiObject).getName());
                if (folder != null) {
                    elements.add(this.refactoring, new RenameDataFolder(folder, this.newName));
                }
                Problem problem = null;
                return problem;
            }
            this.addElementsForJmiObject(elements, this.jmiObject, docFinder);
            if (this.overridesMethods != null) {
                iter = this.overridesMethods.iterator();
                while (iter.hasNext()) {
                    if (this.cancelRequest) {
                        Problem problem = null;
                        return problem;
                    }
                    m = (Method)iter.next();
                    if (m.getResource().getName().endsWith(".class")) {
                        Problem problem = RenameRefactoringPlugin.resourceNotAvailable(m);
                        return problem;
                    }
                    elements.add(this.refactoring, new RenameDOElement((RefObject)m));
                }
            }
            if (this.overriddenByMethods != null) {
                iter = this.overriddenByMethods.iterator();
                while (iter.hasNext()) {
                    if (this.cancelRequest) {
                        m = null;
                        return m;
                    }
                    m = (Method)iter.next();
                    if (m.getResource().getName().endsWith(".class")) {
                        Problem problem = RenameRefactoringPlugin.resourceNotAvailable(m);
                        return problem;
                    }
                    elements.add(this.refactoring, new RenameDOElement((RefObject)m));
                }
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.referencesIterator = null;
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        }
    }

    private static Problem resourceNotAvailable(Method m) {
        String resourceName = Utilities.replaceString((String)m.getResource().getName(), (String)".class", (String)".java");
        return new Problem(true, new MessageFormat(RenameRefactoringPlugin.getString("ERR_ResourceUnavailable")).format(new Object[]{m.getName(), resourceName}));
    }

    private void addElementsForJmiObject(RefactoringElementsBag elements, RefObject refObject, CommentRenameFinder docFinder) {
        elements.add(this.refactoring, new RenameDOElement(refObject));
        this.referencesIterator = refObject instanceof Method ? ((MethodImpl)refObject).findDependencies(true, true, false).iterator() : ((NamedElement)refObject).getReferences().iterator();
        while (this.referencesIterator.hasNext()) {
            Element element = (Element)this.referencesIterator.next();
            if (this.cancelRequest) {
                return;
            }
            if (this.refactoring.isSearchInComments()) {
                elements.addAll(this.refactoring, docFinder.searchCommentsInResource(element.getResource()));
            }
            String name = this.newName;
            if (this.jmiObject instanceof Field) {
                Feature f = JavaModelUtil.getDeclaringFeature((Element)element);
                if (((VariableAccess)element).getParentClass() == null && this.variableClashes(this.newName, f) != null) {
                    ClassDefinition decl = ((Field)this.jmiObject).getDeclaringClass();
                    if (f.getDeclaringClass().equals(decl)) {
                        name = "this." + this.newName;
                    } else if (decl instanceof NamedElement) {
                        name = decl.getName() + ".this." + this.newName;
                    }
                }
            }
            elements.add(this.refactoring, new RenameUsageElement(refObject, element, name));
        }
    }

    private DataFolder getFolder(String name) {
        FileObject fo = RefactoringClassPathImplementation.getDefault().findResource(name.replace('.', '/'));
        if (fo == null) {
            return null;
        }
        return DataFolder.findFolder((FileObject)fo);
    }

    private Collection overriddenBy(Method method, String name, List argTypes) {
        if (!CheckUtils.isVirtual((Feature)method)) {
            return Collections.EMPTY_LIST;
        }
        return ((MethodImpl)method).findDependencies(false, false, true);
    }

    private Collection overrides(Method method, String name, List argTypes, ClassDefinition[] cls_par) {
        ClassDefinition cd;
        ClassDefinition implementor;
        if (!CheckUtils.isVirtual((Feature)method)) {
            return Collections.EMPTY_LIST;
        }
        ClassDefinition javaClass = method.getDeclaringClass();
        LinkedList<JavaClass> supertypes = new LinkedList<JavaClass>();
        HashSet<Method> result = new HashSet<Method>();
        Method last = null;
        supertypes.addAll(javaClass.getInterfaces());
        JavaClass jc = javaClass.getSuperClass();
        if (jc != null) {
            supertypes.add(jc);
        }
        while (supertypes.size() > 0) {
            jc = (ClassDefinition)supertypes.removeFirst();
            if (jc instanceof UnresolvedClass) continue;
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null && CheckUtils.isVirtual((Feature)m)) {
                result.add(m);
                last = m;
            }
            supertypes.addAll(jc.getInterfaces());
            if ((jc = jc.getSuperClass()) == null) continue;
            supertypes.add(jc);
        }
        if (last != null && (implementor = this.findDifferentSubtype((JavaClass)(cd = last.getDeclaringClass()), name, argTypes, javaClass)) != null) {
            cls_par[0] = cd;
            cls_par[1] = implementor;
        }
        return result;
    }

    private ClassDefinition findDifferentSubtype(JavaClass baseClass, String name, List argTypes, ClassDefinition subtype) {
        HashSet supertypes = new HashSet();
        LinkedList subtypes = new LinkedList();
        JavaClass jc = baseClass;
        this.collectSupertypes(supertypes, subtype);
        this.addSubtypes((ClassDefinition)jc, subtypes);
        while (subtypes.size() > 0) {
            jc = (ClassDefinition)subtypes.removeFirst();
            if (jc instanceof UnresolvedClass || supertypes.contains(jc)) continue;
            if (jc.getMethod(name, argTypes, false) != null) {
                return jc;
            }
            this.addSubtypes((ClassDefinition)jc, subtypes);
        }
        return null;
    }

    private void collectSupertypes(Set supertypes, ClassDefinition jc) {
        if (jc == null) {
            return;
        }
        supertypes.add(jc);
        this.collectSupertypes(supertypes, (ClassDefinition)jc.getSuperClass());
        Iterator iter = jc.getInterfaces().iterator();
        while (iter.hasNext()) {
            this.collectSupertypes(supertypes, (ClassDefinition)iter.next());
        }
    }

    private boolean isStatic(Feature feature) {
        return (feature.getModifiers() & 8) > 0;
    }

    private int getAccessLevel(Feature f) {
        int mod = f.getModifiers();
        if ((mod & 1) > 0) {
            return 3;
        }
        if ((mod & 4) > 0) {
            return 2;
        }
        if ((mod & 2) > 0) {
            return 0;
        }
        return 1;
    }

    private Method isOverridden(Method method, String name, List argTypes) {
        if (!CheckUtils.isVirtual((Feature)method)) {
            return null;
        }
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList subtypes = new LinkedList();
        this.addSubtypes(jc, subtypes);
        while (subtypes.size() > 0) {
            jc = (ClassDefinition)subtypes.removeFirst();
            if (jc instanceof UnresolvedClass) continue;
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null && CheckUtils.isVirtual((Feature)m)) {
                return m;
            }
            this.addSubtypes(jc, subtypes);
        }
        return null;
    }

    private Problem willBeOverridden(Method method, String name, List argTypes, Problem problem) {
        int accessLevel = this.getAccessLevel((Feature)method);
        if (accessLevel == 0) {
            return null;
        }
        boolean isStatic = this.isStatic((Feature)method);
        boolean isFinal = (method.getModifiers() & 0x10) > 0;
        Method temp = null;
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList subtypes = new LinkedList();
        this.addSubtypes(jc, subtypes);
        while (subtypes.size() > 0) {
            jc = (ClassDefinition)subtypes.removeFirst();
            if (jc instanceof UnresolvedClass) continue;
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null) {
                if (temp == null) {
                    temp = m;
                }
                if (isFinal) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_final")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, msg);
                }
                if (this.getAccessLevel((Feature)m) < accessLevel) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_access")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, msg);
                }
                if (isStatic == this.isStatic((Feature)m)) continue;
                String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_static")).format(new Object[]{isStatic ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), method.getName(), this.getDefClassName(method.getDeclaringClass()), this.isStatic((Feature)m) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                return RenameRefactoringPlugin.createProblem(problem, true, msg);
            }
            this.addSubtypes(jc, subtypes);
        }
        if (temp != null) {
            String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), temp.getName(), this.getDefClassName(temp.getDeclaringClass())});
            return RenameRefactoringPlugin.createProblem(problem, false, msg);
        }
        return problem;
    }

    private Problem willOverride(Method method, String name, List argTypes, Problem problem) {
        int accessLevel = this.getAccessLevel((Feature)method);
        boolean isStatic = this.isStatic((Feature)method);
        Method temp = null;
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList<ClassDefinition> supertypes = new LinkedList<ClassDefinition>();
        supertypes.addAll(jc.getInterfaces());
        jc = jc.getSuperClass();
        if (jc != null) {
            supertypes.add(jc);
        }
        while (supertypes.size() > 0) {
            jc = (ClassDefinition)supertypes.removeFirst();
            if (jc instanceof UnresolvedClass) continue;
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null) {
                if (temp == null) {
                    temp = m;
                }
                if ((m.getModifiers() & 0x10) > 0) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_final")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, msg);
                }
                if (this.getAccessLevel((Feature)m) > accessLevel) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_access")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, msg);
                }
                if (isStatic == this.isStatic((Feature)m)) continue;
                String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_static")).format(new Object[]{isStatic ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), method.getName(), this.getDefClassName(method.getDeclaringClass()), this.isStatic((Feature)m) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), m.getName(), this.getDefClassName(m.getDeclaringClass())});
                return RenameRefactoringPlugin.createProblem(problem, true, msg);
            }
            supertypes.addAll(jc.getInterfaces());
            if ((jc = jc.getSuperClass()) == null) continue;
            supertypes.add(jc);
        }
        if (temp != null) {
            String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), temp.getName(), this.getDefClassName(temp.getDeclaringClass())});
            return RenameRefactoringPlugin.createProblem(problem, false, msg);
        }
        return problem;
    }

    private Method overrides(Method method, String name, List argTypes, boolean findFinal) {
        Method res = null;
        if (!CheckUtils.isVirtual((Feature)method)) {
            return null;
        }
        ClassDefinition jc = method.getDeclaringClass();
        LinkedList<ClassDefinition> supertypes = new LinkedList<ClassDefinition>();
        supertypes.addAll(jc.getInterfaces());
        jc = jc.getSuperClass();
        if (jc != null) {
            supertypes.add(jc);
        }
        while (supertypes.size() > 0) {
            jc = (ClassDefinition)supertypes.removeFirst();
            if (jc instanceof UnresolvedClass) continue;
            Method m = jc.getMethod(name, argTypes, false);
            if (m != null && CheckUtils.isVirtual((Feature)m)) {
                if ((m.getModifiers() & 0x10) > 0) {
                    res = m;
                    break;
                }
                if (res == null) {
                    res = m;
                    if (!findFinal) break;
                }
            }
            supertypes.addAll(jc.getInterfaces());
            if ((jc = jc.getSuperClass()) == null) continue;
            supertypes.add(jc);
        }
        return res;
    }

    private Field hides(Field field, String name) {
        if (!CheckUtils.isVirtual((Feature)field)) {
            return null;
        }
        ClassDefinition jc = field.getDeclaringClass();
        for (jc = jc.getSuperClass(); jc != null; jc = jc.getSuperClass()) {
            Field f = jc.getField(name, false);
            if (f == null || !CheckUtils.isVirtual((Feature)f)) continue;
            return f;
        }
        return null;
    }

    private String variableClashes(String newName, Feature scope) {
        if (this.varNames == null) {
            this.varNames = CheckUtils.getAllVariableNames(scope);
        }
        if (this.varNames.contains(newName)) {
            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_LocVariableClash")).format(new Object[]{newName});
        }
        return null;
    }

    private String clashes(Feature feature, String newName) {
        ClassDefinition dc = feature.getDeclaringClass();
        if (!(feature instanceof TypeParameter)) {
            if (feature instanceof JavaClass) {
                if (dc != null) {
                    String result = this.checkInnersForClash(newName, dc);
                    if (result != null) {
                        return result;
                    }
                } else {
                    Element composite = (Element)feature.refImmediateComposite();
                    if (composite instanceof Resource) {
                        Resource resource = (Resource)composite;
                        DataObject dobj = JavaMetamodel.getManager().getDataObject(resource);
                        FileObject primFile = dobj.getPrimaryFile();
                        FileObject folder = primFile.getParent();
                        FileObject[] children = folder.getChildren();
                        for (int x = 0; x < children.length; ++x) {
                            if (children[x] == primFile || children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
                            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, resource.getPackageName()});
                        }
                    }
                }
            } else if (feature instanceof Method) {
                List params = this.getParamTypes((Method)feature);
                if (dc.getMethod(newName, params, false) != null) {
                    return new MessageFormat(RenameRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{newName, this.getDefClassName(dc)});
                }
            } else if (feature instanceof Field && dc.getField(newName, false) != null) {
                return new MessageFormat(RenameRefactoringPlugin.getString("ERR_FieldClash")).format(new Object[]{newName, this.getDefClassName(dc)});
            }
        }
        return null;
    }

    private String checkInnersForClash(String newName, ClassDefinition dc) {
        Iterator iter = dc.getFeatures().iterator();
        while (iter.hasNext()) {
            JavaClass nestedClass;
            Object obj = iter.next();
            if (!(obj instanceof JavaClass) || !(nestedClass = (JavaClass)obj).getSimpleName().equals(newName)) continue;
            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_InnerClassClash")).format(new Object[]{newName, this.getDefClassName(dc)});
        }
        return null;
    }

    String getElementName(NamedElement elem) {
        if (elem instanceof JavaClass) {
            return ((JavaClass)elem).getSimpleName();
        }
        return elem.getName();
    }

    String getDefClassName(ClassDefinition cd) {
        if (cd instanceof JavaClass) {
            return ((JavaClass)cd).getName();
        }
        return "";
    }

    private List getParamTypes(Method method) {
        LinkedList<Type> types = new LinkedList<Type>();
        Iterator iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            types.add(RenameRefactoringPlugin.getRealType(((Parameter)iter.next()).getType()));
        }
        return types;
    }

    private static Type getRealType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getDefinition();
        }
        return type;
    }

    static boolean isResourceClass(Resource res, RefObject refObject) {
        int end;
        if (res == null || !(refObject instanceof JavaClass)) {
            return false;
        }
        int classCount = 0;
        Iterator iter = res.getClassifiers().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof JavaClass)) continue;
            ++classCount;
        }
        if (classCount == 1) {
            return true;
        }
        String relativeResName = res.getName();
        String javaClassName = ((JavaClass)refObject).getSimpleName();
        int begin = relativeResName.lastIndexOf(47) + 1;
        if (begin < 0) {
            begin = 0;
        }
        return javaClassName.equals(relativeResName.substring(begin, end = relativeResName.lastIndexOf(46)));
    }

    private void addSubtypes(ClassDefinition cd, List list) {
        if (!(cd instanceof JavaClass)) {
            return;
        }
        JavaClass jc = (JavaClass)cd;
        Collection subtypes = null;
        subtypes = jc.isInterface() ? jc.getImplementors() : jc.getSubClasses();
        list.addAll(subtypes);
    }

    private static final String getString(String key) {
        return NbBundle.getMessage((Class)RenameRefactoring.class, (String)key);
    }

    public void start(ProgressEvent event) {
        this.fireProgressListenerStart(event.getOperationType(), event.getCount());
    }

    public void step(ProgressEvent event) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent event) {
        this.fireProgressListenerStop();
    }

    private class RenameDataFolder
    extends SimpleRefactoringElementImpl
    implements RefactoringElementImplementation,
    ExternalChange {
        private final String text;
        private PositionBounds bounds;
        private String oldName;
        private String newName;
        private DataFolder folder;

        public RenameDataFolder(DataFolder folder, String name) {
            this.newName = name;
            this.folder = folder;
            this.text = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$RenameRefactoring == null ? (class$org$netbeans$modules$refactoring$api$RenameRefactoring = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.api.RenameRefactoring")) : class$org$netbeans$modules$refactoring$api$RenameRefactoring), (String)"LBL_RenameFolder"), folder.getName(), this.newName);
        }

        public String getDisplayText() {
            return this.text;
        }

        public Element getJavaElement() {
            return (Element)RenameRefactoringPlugin.this.jmiObject;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)RenameRefactoringPlugin.this.jmiObject);
            }
            return this.bounds;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        private void doRename() {
            this.oldName = this.folder.getName();
            try {
                this.folder.rename(this.newName);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public void performExternalChange() {
            this.doRename();
        }

        public void undoExternalChange() {
            if (this.oldName == null) {
                return;
            }
            String temp = this.newName;
            this.newName = this.oldName;
            this.oldName = temp;
            this.doRename();
            this.newName = temp;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    private class RenamePackageElement
    extends RenameUsageElement {
        private String oldName;

        public RenamePackageElement(RefObject jmiObject, Element feature, String newName) {
            super(jmiObject, feature, newName);
            this.oldName = null;
        }

        public void performChange() {
            MultipartId mpi = (MultipartId)this.feature;
            this.oldName = mpi.getName();
            mpi.setName(RenameRefactoringPlugin.this.newName);
        }
    }

    private class RenameDOElement
    extends SimpleRefactoringElementImpl
    implements ExternalChange {
        private final String text;
        private PositionBounds bounds = null;
        private String oldName = null;
        private Resource res = null;
        private RefObject refObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RenameDOElement(RefObject refObject) {
            this.refObject = refObject;
            Object o = refObject instanceof Resource ? refObject : refObject.refImmediateComposite();
            if (o instanceof Resource) {
                this.res = (Resource)o;
            }
            String bundleName = null;
            if (refObject instanceof Resource) {
                bundleName = "LBL_RenameClassDO";
            } else if (refObject instanceof JavaEnum) {
                bundleName = "LBL_RenameEnum";
            } else if (refObject instanceof AnnotationType) {
                bundleName = "LBL_RenameAnnotationType";
            } else if (refObject instanceof TypeParameter) {
                bundleName = "LBL_RenameTypeParameter";
            } else if (refObject instanceof JavaClass) {
                bundleName = this.isResourceClass() ? "LBL_RenameClassDO" : "LBL_RenameClass";
            } else if (refObject instanceof Method) {
                bundleName = "LBL_RenameMethod";
            } else if (refObject instanceof Field) {
                bundleName = "LBL_RenameField";
            } else if (refObject instanceof Parameter) {
                bundleName = "LBL_RenameParameter";
            } else if (refObject instanceof LocalVariable) {
                bundleName = "LBL_RenameLocVariable";
            } else if (refObject instanceof Attribute) {
                bundleName = "LBL_RenameAttribute";
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Invalid type " + refObject.getClass()));
            }
            this.text = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$RenameRefactoring == null ? (class$org$netbeans$modules$refactoring$api$RenameRefactoring = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.api.RenameRefactoring")) : class$org$netbeans$modules$refactoring$api$RenameRefactoring), (String)bundleName), RenameRefactoringPlugin.this.newName);
        }

        private boolean isResourceClass() {
            return RenameRefactoringPlugin.isResourceClass(this.res, this.refObject);
        }

        public String getDisplayText() {
            return this.text;
        }

        public Element getJavaElement() {
            return (Element)this.refObject;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null && !(this.refObject instanceof Resource)) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.refObject);
            }
            return this.bounds;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void performChange() {
            if (this.refObject instanceof Resource) {
                JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
            } else {
                NamedElement obj = (NamedElement)this.refObject;
                if (obj instanceof JavaClass) {
                    this.oldName = ((JavaClass)obj).getSimpleName();
                    if (this.isResourceClass()) {
                        JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
                    }
                    ((JavaClass)obj).setSimpleName(RenameRefactoringPlugin.this.newName);
                } else {
                    this.oldName = obj.getName();
                    obj.setName(RenameRefactoringPlugin.this.newName);
                }
            }
        }

        private void doRename() {
            try {
                DataObject dobj = JavaMetamodel.getManager().getDataObject(this.res);
                this.oldName = dobj.getName();
                dobj.rename(RenameRefactoringPlugin.this.newName);
            }
            catch (DataObjectNotFoundException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public void performExternalChange() {
            this.doRename();
        }

        public void undoExternalChange() {
            if (this.oldName == null) {
                return;
            }
            String temp = RenameRefactoringPlugin.this.newName;
            RenameRefactoringPlugin.this.newName = this.oldName;
            this.oldName = temp;
            this.doRename();
            RenameRefactoringPlugin.this.newName = temp;
        }

        public FileObject getParentFile() {
            return null;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.RenameRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin).desiredAssertionStatus();
        }
    }
}

