/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.moveclass.AbstractMoveClassRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EjbJarMoveClassRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    public Problem fastCheckParameters(Collection resources, FileObject target) {
        Problem problem = null;
        for (Resource res : resources) {
            FileObject fo = JavaModel.getFileObject((Resource)res);
            if (fo == null) continue;
            Project prj1 = FileOwnerQuery.getOwner((FileObject)fo);
            Project prj2 = null;
            if (target != null) {
                prj2 = FileOwnerQuery.getOwner((FileObject)target);
            }
            if (prj2 == null || prj1.equals(prj2) || !this.isEjbMove(res)) continue;
            Problem newProblem = new Problem(true, NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarOtherProjectWarningMoveClass"));
            problem = Utility.addProblemsToEnd(problem, newProblem);
            break;
        }
        return problem;
    }

    private boolean isEjbMove(Resource res) {
        JavaClass jc;
        int i;
        List l = res.getClassifiers();
        if (l == null) {
            return false;
        }
        JavaClass iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.EJBLocalObject");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.EJBLocalHome");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.EJBHome");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.EJBObject");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.EntityBean");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.SessionBean");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.ejb.MessageDrivenBean");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        iface = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.jms.MessageListener");
        for (i = 0; i < l.size(); ++i) {
            jc = (JavaClass)l.get(i);
            if (!jc.isSubTypeOf((ClassDefinition)iface)) continue;
            return true;
        }
        return false;
    }

    public Problem checkParameters(Collection resources, FileObject target) {
        return this.fastCheckParameters(resources, target);
    }

    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (Resource resource : resources) {
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            Collection emodules = Utility.getRelevantEjbModules(fo);
            Iterator emIter = null;
            if (emodules != null) {
                emIter = emodules.iterator();
            }
            if (emIter == null) continue;
            while (emIter.hasNext()) {
                EjbJar em = (EjbJar)emIter.next();
                if (em == null) continue;
                FileObject ejbJarFO = em.getDeploymentDescriptor();
                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD = null;
                try {
                    ejbJarDD = DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (ejbJarDD != null && ejbJarDD.getStatus() != 2 && ejbJarFO != null) {
                    EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
                    Session[] sessionBeans = eBeans != null ? eBeans.getSession() : null;
                    err.log("Session Beans: " + sessionBeans);
                    Entity[] entityBeans = eBeans != null ? eBeans.getEntity() : null;
                    err.log("Entity Beans: " + entityBeans);
                    MessageDriven[] messageBeans = eBeans != null ? eBeans.getMessageDriven() : null;
                    err.log("MessageDriven Beans: " + messageBeans);
                    List classes = resource.getClassifiers();
                    err.log("Classes in resource: " + classes);
                    for (int j = 0; j < classes.size(); ++j) {
                        AbstractMoveClassRefactoringElement elem;
                        AbstractMoveClassRefactoringElement elem2;
                        AbstractMoveClassRefactoringElement elem3;
                        AbstractMoveClassRefactoringElement elem4;
                        String ejbRemote;
                        EjbJarHomeMoveClassRefactoringElement elem5;
                        String ejbHome;
                        EjbJarLocalHomeMoveClassRefactoringElement elem6;
                        String ejbLocalHome;
                        EjbJarLocalMoveClassRefactoringElement elem7;
                        String ejbLocal;
                        EjbJarBeanClassMoveClassRefactoringElement elem8;
                        String ejbClass;
                        int b;
                        JavaClass jClass = (JavaClass)classes.get(j);
                        err.log("javaclass: " + jClass);
                        String name = jClass.getName();
                        err.log("name: " + name);
                        String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                        err.log("targetPackage: " + targetPackage);
                        String newName = Utility.getClassName(targetPackage, jClass.getSimpleName());
                        err.log("newname: " + newName);
                        if (sessionBeans != null && sessionBeans.length > 0) {
                            for (b = 0; b < sessionBeans.length; ++b) {
                                EjbLocalRef[] localRefs;
                                Session sBean;
                                block42: {
                                    sBean = sessionBeans[b];
                                    err.log("Session Bean: " + sBean);
                                    ejbClass = sBean.getEjbClass();
                                    err.log("EJB Class: " + ejbClass);
                                    if (ejbClass != null && ejbClass.equals(name)) {
                                        elem8 = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem8);
                                    }
                                    ejbLocal = sBean.getLocal();
                                    err.log("EJB Local: " + ejbLocal);
                                    if (ejbLocal != null && ejbLocal.equals(name)) {
                                        elem7 = new EjbJarLocalMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem7);
                                    }
                                    ejbLocalHome = sBean.getLocalHome();
                                    err.log("EJB LocalHome: " + ejbLocalHome);
                                    if (ejbLocalHome != null && ejbLocalHome.equals(name)) {
                                        elem6 = new EjbJarLocalHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem6);
                                    }
                                    ejbHome = sBean.getHome();
                                    err.log("EJB Home: " + ejbHome);
                                    if (ejbHome != null && ejbHome.equals(name)) {
                                        elem5 = new EjbJarHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem5);
                                    }
                                    ejbRemote = sBean.getRemote();
                                    err.log("EJB Remote: " + ejbRemote);
                                    if (ejbRemote != null && ejbRemote.equals(name)) {
                                        elem4 = new EjbJarRemoteMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem4);
                                    }
                                    String serviceEndpoint = null;
                                    try {
                                        serviceEndpoint = sBean.getServiceEndpoint();
                                        if (ErrorManager.getDefault().isLoggable(1)) {
                                            err.log("EJB Service Endpoint: " + serviceEndpoint);
                                        }
                                        if (serviceEndpoint != null && serviceEndpoint.equals(name)) {
                                            elem3 = new EjbJarServiceEndpointMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                                        }
                                    }
                                    catch (VersionNotSupportedException versionex) {
                                        if (!ErrorManager.getDefault().isLoggable(1)) break block42;
                                        err.log("Service endpoint not supported in this version of dd.");
                                    }
                                }
                                EjbRef[] refs = sBean.getEjbRef();
                                if (refs != null && refs.length > 0) {
                                    for (int l = 0; l < refs.length; ++l) {
                                        EjbRef ref = refs[l];
                                        err.log("EJB ref: " + ref);
                                        String refHome = ref.getHome();
                                        err.log("home ref: " + refHome);
                                        if (refHome != null && refHome.equals(name)) {
                                            elem2 = new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)sBean, name, newName, ejbJarFO);
                                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                                        }
                                        String refRemote = ref.getRemote();
                                        err.log("remote ref: " + refRemote);
                                        if (refRemote == null || !refRemote.equals(name)) continue;
                                        elem = new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, (Ejb)sBean, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                    }
                                }
                                if ((localRefs = sBean.getEjbLocalRef()) == null || localRefs.length <= 0) continue;
                                for (int l = 0; l < localRefs.length; ++l) {
                                    EjbLocalRef localRef = localRefs[l];
                                    err.log("EJB local ref: " + localRef);
                                    String refLocal = localRef.getLocal();
                                    err.log("local ref: " + refLocal);
                                    if (refLocal != null && refLocal.equals(name)) {
                                        elem = new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, (Ejb)sBean, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                    }
                                    String refLocalHome = localRef.getLocalHome();
                                    err.log("localHome ref: " + refLocalHome);
                                    if (refLocalHome == null || !refLocalHome.equals(name)) continue;
                                    EjbJarRefLocalHomeMoveClassRefactoringElement elem9 = new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)sBean, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem9);
                                }
                            }
                        }
                        if (entityBeans != null && entityBeans.length > 0) {
                            for (b = 0; b < entityBeans.length; ++b) {
                                EjbLocalRef[] localRefs;
                                EjbRef[] refs;
                                Entity entBean = entityBeans[b];
                                err.log("Entity Bean: " + entBean);
                                ejbClass = entBean.getEjbClass();
                                err.log("EJB Class: " + ejbClass);
                                if (ejbClass != null && ejbClass.equals(name)) {
                                    elem8 = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem8);
                                }
                                ejbLocal = entBean.getLocal();
                                err.log("EJB Local: " + ejbLocal);
                                if (ejbLocal != null && ejbLocal.equals(name)) {
                                    elem7 = new EjbJarLocalMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem7);
                                }
                                ejbLocalHome = entBean.getLocalHome();
                                err.log("EJB LocalHome: " + ejbLocalHome);
                                if (ejbLocalHome != null && ejbLocalHome.equals(name)) {
                                    elem6 = new EjbJarLocalHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem6);
                                }
                                ejbHome = entBean.getHome();
                                err.log("EJB Home: " + ejbHome);
                                if (ejbHome != null && ejbHome.equals(name)) {
                                    elem5 = new EjbJarHomeMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem5);
                                }
                                ejbRemote = entBean.getRemote();
                                err.log("EJB Remote: " + ejbRemote);
                                if (ejbRemote != null && ejbRemote.equals(name)) {
                                    elem4 = new EjbJarRemoteMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem4);
                                }
                                if ((refs = entBean.getEjbRef()) != null && refs.length > 0) {
                                    for (int l = 0; l < refs.length; ++l) {
                                        EjbRef ref = refs[l];
                                        err.log("EJB ref: " + ref);
                                        String refHome = ref.getHome();
                                        err.log("home ref: " + refHome);
                                        if (refHome != null && refHome.equals(name)) {
                                            EjbJarRefHomeMoveClassRefactoringElement elem10 = new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)entBean, name, newName, ejbJarFO);
                                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem10);
                                        }
                                        String refRemote = ref.getRemote();
                                        err.log("remote ref: " + refRemote);
                                        if (refRemote == null || !refRemote.equals(name)) continue;
                                        elem2 = new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, (Ejb)entBean, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                                    }
                                }
                                if ((localRefs = entBean.getEjbLocalRef()) == null || localRefs.length <= 0) continue;
                                for (int l = 0; l < localRefs.length; ++l) {
                                    EjbLocalRef localRef = localRefs[l];
                                    err.log("EJB local ref: " + localRef);
                                    String refLocal = localRef.getLocal();
                                    err.log("local ref: " + refLocal);
                                    if (refLocal != null && refLocal.equals(name)) {
                                        elem2 = new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, (Ejb)entBean, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                                    }
                                    String refLocalHome = localRef.getLocalHome();
                                    err.log("localHome ref: " + refLocalHome);
                                    if (refLocalHome == null || !refLocalHome.equals(name)) continue;
                                    elem = new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)entBean, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                }
                            }
                        }
                        if (messageBeans == null || messageBeans.length <= 0) continue;
                        for (b = 0; b < messageBeans.length; ++b) {
                            EjbLocalRef[] localRefs;
                            EjbRef[] refs;
                            MessageDriven msgBean = messageBeans[b];
                            err.log("MessageDriven Bean: " + msgBean);
                            ejbClass = msgBean.getEjbClass();
                            err.log("EJB Class: " + ejbClass);
                            if (ejbClass != null && ejbClass.equals(name)) {
                                elem8 = new EjbJarBeanClassMoveClassRefactoringElement(ejbJarDD, name, newName, ejbJarFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem8);
                            }
                            if ((refs = msgBean.getEjbRef()) != null && refs.length > 0) {
                                for (int l = 0; l < refs.length; ++l) {
                                    EjbRef ref = refs[l];
                                    err.log("EJB ref: " + ref);
                                    String refHome = ref.getHome();
                                    err.log("home ref: " + refHome);
                                    if (refHome != null && refHome.equals(name)) {
                                        elem4 = new EjbJarRefHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)msgBean, name, newName, ejbJarFO);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem4);
                                    }
                                    String refRemote = ref.getRemote();
                                    err.log("remote ref: " + refRemote);
                                    if (refRemote == null || !refRemote.equals(name)) continue;
                                    elem3 = new EjbJarRefRemoteMoveClassRefactoringElement(ejbJarDD, (Ejb)msgBean, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                                }
                            }
                            if ((localRefs = msgBean.getEjbLocalRef()) == null || localRefs.length <= 0) continue;
                            for (int l = 0; l < localRefs.length; ++l) {
                                EjbLocalRef localRef = localRefs[l];
                                err.log("EJB local ref: " + localRef);
                                String refLocal = localRef.getLocal();
                                err.log("local ref: " + refLocal);
                                if (refLocal != null && refLocal.equals(name)) {
                                    elem3 = new EjbJarRefLocalMoveClassRefactoringElement(ejbJarDD, (Ejb)msgBean, name, newName, ejbJarFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                                }
                                String refLocalHome = localRef.getLocalHome();
                                err.log("localHome ref: " + refLocalHome);
                                if (refLocalHome == null || !refLocalHome.equals(name)) continue;
                                EjbJarRefLocalHomeMoveClassRefactoringElement elem11 = new EjbJarRefLocalHomeMoveClassRefactoringElement(ejbJarDD, (Ejb)msgBean, name, newName, ejbJarFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem11);
                            }
                        }
                    }
                    continue;
                }
                if (ejbJarFO == null) continue;
                Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarMoveClassInvalidProblem"));
                problem = Utility.addProblemsToEnd(problem, newProblem);
            }
        }
        return problem;
    }

    public final class EjbJarRefRemoteMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Ejb ejb;
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarRefRemoteMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) {
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarRefRemoteMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbRef[] refs = this.ejb.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbRemote = refs[i].getRemote();
                if (!this.oldName.equals(ejbRemote)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setRemote(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EjbRef[] refs = this.ejb.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbRemote = refs[i].getRemote();
                if (!this.newName.equals(ejbRemote)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setRemote(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarRefHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Ejb ejb;
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarRefHomeMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) {
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarRefHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbRef[] refs = this.ejb.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbHome = refs[i].getHome();
                if (!this.oldName.equals(ejbHome)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setHome(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EjbRef[] refs = this.ejb.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbHome = refs[i].getHome();
                if (!this.newName.equals(ejbHome)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setHome(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarRefLocalHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Ejb ejb;
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarRefLocalHomeMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) {
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarRefLocalHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = this.ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbLocalHome = refs[i].getLocalHome();
                if (!this.oldName.equals(ejbLocalHome)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocalHome(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EjbLocalRef[] refs = this.ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbLocalHome = refs[i].getLocalHome();
                if (!this.newName.equals(ejbLocalHome)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocalHome(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarRefLocalMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Ejb ejb;
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarRefLocalMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, Ejb ejb, String oldName, String newName, FileObject parentFile) {
            this.ejb = ejb;
            this.oldName = oldName;
            this.newName = newName;
            this.ejbJarDD = ejbJarDD;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarRefLocalMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = this.ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbLocal = refs[i].getLocal();
                if (!this.oldName.equals(ejbLocal)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocal(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EjbLocalRef[] refs = this.ejb.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String ejbLocal = refs[i].getLocal();
                if (!this.newName.equals(ejbLocal)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocal(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarServiceEndpointMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarServiceEndpointMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarServiceEndpointMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            try {
                for (int i = 0; i < sEjbs.length; ++i) {
                    String serviceEndpoint = sEjbs[i].getServiceEndpoint();
                    if (!this.oldName.equals(serviceEndpoint)) continue;
                    ejb = sEjbs[i];
                    break;
                }
                if (ejb != null) {
                    ejb.setServiceEndpoint(this.newName);
                    try {
                        this.ejbJarDD.write(this.parentFile);
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (VersionNotSupportedException ex) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            try {
                for (int i = 0; i < sEjbs.length; ++i) {
                    String serviceEndpoint = sEjbs[i].getServiceEndpoint();
                    if (!this.newName.equals(serviceEndpoint)) continue;
                    ejb = sEjbs[i];
                    break;
                }
                if (ejb != null) {
                    ejb.setServiceEndpoint(this.oldName);
                    try {
                        this.ejbJarDD.write(this.parentFile);
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (VersionNotSupportedException ex) {
                // empty catch block
            }
        }
    }

    public final class EjbJarRemoteMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarRemoteMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarRemoteMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbRemote = sEjbs[i].getRemote();
                if (!this.oldName.equals(ejbRemote)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbRemote = eEjbs[i].getRemote();
                    if (!this.oldName.equals(ejbRemote)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setRemote(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbRemote = sEjbs[i].getRemote();
                if (!this.newName.equals(ejbRemote)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbRemote = eEjbs[i].getRemote();
                    if (!this.newName.equals(ejbRemote)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setRemote(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarHomeMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbHome = sEjbs[i].getHome();
                if (!this.oldName.equals(ejbHome)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbHome = eEjbs[i].getHome();
                    if (!this.oldName.equals(ejbHome)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setHome(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbHome = sEjbs[i].getHome();
                if (!this.newName.equals(ejbHome)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbHome = eEjbs[i].getHome();
                    if (!this.newName.equals(ejbHome)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setHome(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarLocalHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarLocalHomeMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarLocalHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbLocalHome = sEjbs[i].getLocalHome();
                if (!this.oldName.equals(ejbLocalHome)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbLocalHome = eEjbs[i].getLocalHome();
                    if (!this.oldName.equals(ejbLocalHome)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setLocalHome(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbLocalHome = sEjbs[i].getLocalHome();
                if (!this.newName.equals(ejbLocalHome)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbLocalHome = eEjbs[i].getLocalHome();
                    if (!this.newName.equals(ejbLocalHome)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setLocalHome(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarLocalMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarLocalMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarLocalMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbLocal = sEjbs[i].getLocal();
                if (!this.oldName.equals(ejbLocal)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbLocal = eEjbs[i].getLocal();
                    if (!this.oldName.equals(ejbLocal)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setLocal(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Session ejb = null;
            Session[] sEjbs = eBeans.getSession();
            for (int i = 0; i < sEjbs.length; ++i) {
                String ejbLocal = sEjbs[i].getLocal();
                if (!this.newName.equals(ejbLocal)) continue;
                ejb = sEjbs[i];
                break;
            }
            if (ejb == null) {
                Entity[] eEjbs = eBeans.getEntity();
                for (int i = 0; i < eEjbs.length; ++i) {
                    String ejbLocal = eEjbs[i].getLocal();
                    if (!this.newName.equals(ejbLocal)) continue;
                    ejb = eEjbs[i];
                    break;
                }
            }
            if (ejb != null) {
                ejb.setLocal(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public final class EjbJarBeanClassMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD;

        public EjbJarBeanClassMoveClassRefactoringElement(org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJarDD, String oldName, String newName, FileObject parentFile) {
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarMoveClassRefactoring.class, (String)"TXT_EjbJarBeanClassMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Ejb[] ejbs = eBeans.getEjbs();
            Ejb ejb = null;
            for (int i = 0; i < ejbs.length; ++i) {
                String ejbClass = ejbs[i].getEjbClass();
                if (!this.oldName.equals(ejbClass)) continue;
                ejb = ejbs[i];
                break;
            }
            if (ejb != null) {
                ejb.setEjbClass(this.newName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            EnterpriseBeans eBeans = this.ejbJarDD.getEnterpriseBeans();
            Ejb[] ejbs = eBeans.getEjbs();
            Ejb ejb = null;
            for (int i = 0; i < ejbs.length; ++i) {
                String ejbClass = ejbs[i].getEjbClass();
                if (!this.newName.equals(ejbClass)) continue;
                ejb = ejbs[i];
                break;
            }
            if (ejb != null) {
                ejb.setEjbClass(this.oldName);
                try {
                    this.ejbJarDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }
}

