/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.java.bridge.ClassElementImpl;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.FeaturesCollection;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.javacore.JMManager;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.src.Type;

abstract class ObjectsCollection {
    static int POS_VAL_NONE = -1;
    static int POS_VAL_FIELD = 0;
    static int POS_VAL_INITIALIZER = 1;
    static int POS_VAL_CONSTRUCTOR = 2;
    static int POS_VAL_METHOD = 3;
    static int POS_VAL_CLASS = 4;
    static final Type[] NO_TYPES = new Type[0];
    private WeakHashMap cache = new WeakHashMap();
    protected FeaturesCollection members;

    public ObjectsCollection(FeaturesCollection members) {
        this.members = members;
    }

    public abstract RefObject createFeature(RefObject var1, org.openide.src.Element var2);

    public abstract org.openide.src.Element createElement(RefObject var1);

    public abstract org.openide.src.Element[] getEmptyArray();

    public abstract String getPropertyName();

    public abstract boolean isOfType(RefObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.openide.src.Element cachedElement(RefObject refObject) {
        org.openide.src.Element elem;
        WeakReference ref = (WeakReference)this.cache.get(refObject);
        if (ref != null && (elem = (org.openide.src.Element)ref.get()) != null) {
            return elem;
        }
        this.members.repository.beginTrans(false);
        try {
            this.members.parentImpl.setClassPath();
            elem = this.createElement(refObject);
            this.cache.put(refObject, new WeakReference<org.openide.src.Element>(elem));
            org.openide.src.Element element = elem;
            return element;
        }
        finally {
            this.members.repository.endTrans(false);
        }
    }

    public List getFeatures() {
        return this.members.javaClass.getFeatures();
    }

    public boolean isValid() {
        return this.members.javaClass.isValid();
    }

    public abstract boolean matches(org.openide.src.Element var1, RefObject var2);

    public int getPositionalValue() {
        return POS_VAL_NONE;
    }

    public boolean isClassMember() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openide.src.Element[] getElements() {
        ArrayList<org.openide.src.Element> result = new ArrayList<org.openide.src.Element>();
        this.members.repository.beginTrans(false);
        try {
            if (this.isValid()) {
                this.members.parentImpl.setClassPath();
                List features = this.getFeatures();
                if (features != null) {
                    Iterator iter = features.iterator();
                    while (iter.hasNext()) {
                        RefObject feature = (RefObject)iter.next();
                        if (!this.isOfType(feature)) continue;
                        result.add(this.cachedElement(feature));
                    }
                }
                org.openide.src.Element[] elementArray = result.toArray(this.getEmptyArray());
                return elementArray;
            }
            org.openide.src.Element[] elementArray = this.getEmptyArray();
            return elementArray;
        }
        finally {
            this.members.repository.endTrans(false);
        }
    }

    private org.openide.src.Element[] getMembers() {
        List features = this.getFeatures();
        int size = features.size();
        org.openide.src.Element[] result = new org.openide.src.Element[size];
        Iterator iter = features.iterator();
        for (int x = 0; x < size; ++x) {
            RefObject feature = (RefObject)iter.next();
            result[x] = this.cachedMember(feature);
        }
        return result;
    }

    private org.openide.src.Element cachedMember(RefObject f) {
        if (f instanceof JavaClass) {
            return ((ClassElementImpl)this.members.parentImpl).innerClasses.cachedElement(f);
        }
        if (f instanceof Method) {
            return ((ClassElementImpl)this.members.parentImpl).methods.cachedElement(f);
        }
        if (f instanceof Constructor) {
            return ((ClassElementImpl)this.members.parentImpl).constructors.cachedElement(f);
        }
        if (f instanceof Field) {
            return ((ClassElementImpl)this.members.parentImpl).fields.cachedElement(f);
        }
        if (f instanceof Initializer) {
            return ((ClassElementImpl)this.members.parentImpl).initializers.cachedElement(f);
        }
        throw new RuntimeException();
    }

    public void changeMembers(org.openide.src.Element[] items, int operation) throws SourceException {
        for (int x = 0; x < items.length; ++x) {
            if (items[x] != null) continue;
            throw new NullPointerException("null element in " + items.getClass().getName());
        }
        switch (operation) {
            case 1: {
                this.addMembers(items);
                break;
            }
            case -1: {
                this.removeMembers(items);
                break;
            }
            case 0: {
                this.setMembers(items);
                break;
            }
            default: {
                throw new RuntimeException("Unknown/unsupported operation: " + operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMembers(org.openide.src.Element[] items) throws SourceException {
        if (items.length == 0) {
            return;
        }
        boolean veto = this.isClassMember() && (this.members.parentImpl.hasVetoableListeners(this.getPropertyName()) || this.members.parentImpl.hasVetoableListeners("members"));
        org.openide.src.Element[] oldElems = null;
        org.openide.src.Element[] oldMembers = null;
        this.members.repository.beginTrans(true);
        boolean failed = true;
        try {
            if (this.isValid()) {
                this.members.parentImpl.setClassPath();
                if (veto) {
                    oldElems = this.getElements();
                    oldMembers = this.getMembers();
                }
                int index = this.findAddPosition(this.getPositionalValue());
                ListIterator<RefObject> listIter = this.getFeatures().listIterator(index);
                for (int i = 0; i < items.length; ++i) {
                    RefObject feature = this.createFeature((RefObject)this.members.javaClass, items[i]);
                    listIter.add(feature);
                }
                if (veto) {
                    int[] indexes = new int[items.length];
                    List<org.openide.src.Element> added = Arrays.asList(items);
                    org.openide.src.Element[] newMembers = this.getMembers();
                    for (int x = 0; x < items.length; ++x) {
                        indexes[x] = x + index;
                    }
                    MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)this.members.parentImpl.getElement(), "members", (Object)oldMembers, (Object)newMembers);
                    evt.makeInsertion(added, indexes);
                    this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                    org.openide.src.Element[] newElems = this.getElements();
                    indexes = new int[items.length];
                    for (int x = 0; x < items.length; ++x) {
                        indexes[x] = x + oldElems.length;
                    }
                    evt = new MultiPropertyChangeEvent((Object)this.members.parentImpl.getElement(), this.getPropertyName(), (Object)oldElems, (Object)newElems);
                    evt.makeInsertion(added, indexes);
                    this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                }
                failed = false;
            } else {
                failed = false;
                this.members.parentImpl.throwIsInvalid();
            }
        }
        catch (InvalidObjectException e) {
            this.members.parentImpl.throwIsInvalid();
        }
        finally {
            this.members.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMembers(org.openide.src.Element[] items) throws SourceException {
        if (items == null || items.length == 0) {
            return;
        }
        boolean veto = this.isClassMember() && (this.members.parentImpl.hasVetoableListeners(this.getPropertyName()) || this.members.parentImpl.hasVetoableListeners("members"));
        org.openide.src.Element[] oldElems = null;
        org.openide.src.Element[] oldMembers = null;
        int[] elemsIndexes = null;
        int[] membersIndexes = null;
        boolean failed = true;
        this.members.repository.beginTrans(true);
        try {
            if (this.isValid()) {
                List list;
                String name;
                this.members.parentImpl.setClassPath();
                if (veto) {
                    oldElems = this.getElements();
                    oldMembers = this.getMembers();
                    elemsIndexes = new int[items.length];
                    membersIndexes = new int[items.length];
                }
                List features = this.getFeatures();
                HashMap<String, LinkedList<org.openide.src.Element>> map = new HashMap<String, LinkedList<org.openide.src.Element>>();
                for (int x = 0; x < items.length; ++x) {
                    name = items[x] instanceof MemberElement ? ((MemberElement)items[x]).getName().getName() : (items[x] instanceof InitializerElement ? "initializer" : ((ImportElement)items[x]).getImport().getIdentifier().getFullName());
                    list = (LinkedList<org.openide.src.Element>)map.get(name);
                    if (list == null) {
                        list = new LinkedList<org.openide.src.Element>();
                        map.put(name, (LinkedList<org.openide.src.Element>)list);
                    }
                    list.add(items[x]);
                }
                ListIterator iter = features.listIterator();
                int removedCounter = 0;
                int elemsCounter = 0;
                int membersCounter = 0;
                while (iter.hasNext()) {
                    RefObject f = (RefObject)iter.next();
                    if (this.isOfType(f)) {
                        if (f instanceof Constructor) {
                            name = ((JavaClass)((Constructor)f).getDeclaringClass()).getSimpleName();
                        } else if (f instanceof Initializer) {
                            name = "initializer";
                        } else if (f instanceof Import) {
                            name = ((Import)f).getName();
                            if (name.endsWith(".*")) {
                                name = name.substring(0, name.length() - 2);
                            }
                        } else {
                            name = f instanceof JavaClass ? ((JavaClass)f).getSimpleName() : ((Feature)f).getName();
                        }
                        list = (List)map.get(name);
                        if (list != null) {
                            ListIterator iter2 = list.listIterator();
                            while (iter2.hasNext()) {
                                org.openide.src.Element elem = (org.openide.src.Element)iter2.next();
                                if (!this.matches(elem, f)) continue;
                                iter2.remove();
                                iter.remove();
                                f.refDelete();
                                if (list.size() == 0) {
                                    map.remove(name);
                                }
                                if (veto) {
                                    membersIndexes[removedCounter] = membersCounter;
                                    elemsIndexes[removedCounter] = elemsCounter;
                                }
                                ++removedCounter;
                                break;
                            }
                        }
                        ++elemsCounter;
                    }
                    ++membersCounter;
                }
                if (map.size() > 0) {
                    throw new SourceException("An element to be removed not found.");
                }
                if (veto) {
                    List<org.openide.src.Element> removed = Arrays.asList(items);
                    org.openide.src.Element[] newMembers = this.getMembers();
                    MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)this.members.parentImpl.getElement(), "members", (Object)oldMembers, (Object)newMembers);
                    evt.makeRemoval(removed, membersIndexes);
                    this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                    org.openide.src.Element[] newElems = this.getElements();
                    evt = new MultiPropertyChangeEvent((Object)this.members.parentImpl.getElement(), this.getPropertyName(), (Object)oldElems, (Object)newElems);
                    evt.makeInsertion(removed, elemsIndexes);
                    this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                }
                failed = false;
            } else {
                failed = false;
                this.members.parentImpl.throwIsInvalid();
            }
        }
        catch (InvalidObjectException e) {
            this.members.parentImpl.throwIsInvalid();
        }
        finally {
            this.members.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMembers(org.openide.src.Element[] items) throws SourceException {
        block38: {
            boolean veto = this.isClassMember() && (this.members.parentImpl.hasVetoableListeners(this.getPropertyName()) || this.members.parentImpl.hasVetoableListeners("members"));
            org.openide.src.Element[] oldElems = null;
            org.openide.src.Element[] oldMembers = null;
            boolean failed = true;
            this.members.repository.beginTrans(true);
            try {
                if (this.isValid()) {
                    RefObject refObj;
                    int x;
                    this.members.parentImpl.setClassPath();
                    if (veto) {
                        oldElems = this.getElements();
                        oldMembers = this.getMembers();
                    }
                    List features = this.getFeatures();
                    int size = features.size();
                    Iterator iter = features.iterator();
                    LinkedList<Integer> list = new LinkedList<Integer>();
                    int posValue = this.getPositionalValue();
                    int maxPrevValue = -1;
                    int addIndex = -1;
                    LinkedList<org.openide.src.Element> setFeatures = new LinkedList<org.openide.src.Element>();
                    LinkedList<org.openide.src.Element> removedFeatures = new LinkedList<org.openide.src.Element>();
                    for (int i = 0; i < size; ++i) {
                        RefObject feature = (RefObject)iter.next();
                        int val = this.getPositionalValue(feature);
                        if (val <= posValue && val > maxPrevValue) {
                            maxPrevValue = val;
                        }
                        if (val == maxPrevValue) {
                            addIndex = i;
                        }
                        if (val != posValue) continue;
                        list.add(new Integer(i));
                    }
                    int size2 = list.size();
                    int[] pos = new int[size2];
                    iter = list.iterator();
                    for (int i = 0; i < size2; ++i) {
                        pos[i] = (Integer)iter.next();
                    }
                    ListIterator<RefObject> listIterator = features.listIterator();
                    int counter = 0;
                    int numToBeSet = Math.min(size2, items.length);
                    if (numToBeSet == 0) {
                        for (x = 0; x <= addIndex; ++x) {
                            listIterator.next();
                        }
                    } else {
                        for (x = 0; x <= pos[numToBeSet - 1]; ++x) {
                            refObj = (RefObject)listIterator.next();
                            if (pos[counter] == x) {
                                listIterator.set(this.createFeature((RefObject)this.members.javaClass, items[counter]));
                                refObj.refDelete();
                                if (veto) {
                                    setFeatures.add(this.cachedElement(refObj));
                                }
                                ++counter;
                            }
                            ++addIndex;
                        }
                    }
                    if (numToBeSet < items.length) {
                        for (x = numToBeSet; x < items.length; ++x) {
                            listIterator.add(this.createFeature((RefObject)this.members.javaClass, items[x]));
                        }
                    } else if (numToBeSet < size2) {
                        for (x = pos[numToBeSet - 1] + 1; x <= pos[size2 - 1]; ++x) {
                            refObj = (RefObject)listIterator.next();
                            if (pos[counter] != x) continue;
                            listIterator.remove();
                            refObj.refDelete();
                            if (veto) {
                                removedFeatures.add(this.cachedElement(refObj));
                            }
                            ++counter;
                        }
                    }
                    if (veto) {
                        int x2;
                        int[] indexes;
                        int[] addIndexes = null;
                        int[] removeIndexes = addIndexes = new int[0];
                        int[] setIndexes = addIndexes;
                        LinkedList affectedIndexes = new LinkedList();
                        org.openide.src.Element source = this.members.parentImpl.getElement();
                        LinkedList<MultiPropertyChangeEvent> evtElems = new LinkedList<MultiPropertyChangeEvent>();
                        LinkedList<MultiPropertyChangeEvent> evtMembers = new LinkedList<MultiPropertyChangeEvent>();
                        org.openide.src.Element[] newMembers = this.getMembers();
                        org.openide.src.Element[] newElems = this.getElements();
                        if (numToBeSet > 0) {
                            LinkedList<org.openide.src.Element> curr = new LinkedList<org.openide.src.Element>();
                            setIndexes = new int[numToBeSet];
                            indexes = new int[numToBeSet];
                            for (x2 = 0; x2 < numToBeSet; ++x2) {
                                curr.add(items[x2]);
                                setIndexes[x2] = pos[x2];
                            }
                            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)source, "members", (Object)oldMembers, (Object)newMembers);
                            evt.makeReplacement(setFeatures, curr, setIndexes);
                            evtMembers.add(evt);
                            for (x2 = 0; x2 < numToBeSet; ++x2) {
                                indexes[x2] = x2;
                            }
                            evt = new MultiPropertyChangeEvent((Object)source, this.getPropertyName(), (Object)oldElems, (Object)newElems);
                            evt.makeReplacement(setFeatures, curr, indexes);
                            evtElems.add(evt);
                        }
                        ++addIndex;
                        if (numToBeSet < items.length) {
                            LinkedList<org.openide.src.Element> inserted = new LinkedList<org.openide.src.Element>();
                            indexes = new int[items.length - numToBeSet];
                            addIndexes = new int[items.length - numToBeSet];
                            for (x2 = numToBeSet; x2 < items.length; ++x2) {
                                inserted.add(items[x2]);
                                addIndexes[x2 - numToBeSet] = addIndex + x2 - numToBeSet;
                            }
                            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)source, "members", (Object)oldMembers, (Object)newMembers);
                            evt.makeInsertion(inserted, addIndexes);
                            evtMembers.add(evt);
                            for (x2 = 0; x2 < items.length - numToBeSet; ++x2) {
                                indexes[x2] = x2;
                            }
                            evt = new MultiPropertyChangeEvent((Object)source, this.getPropertyName(), (Object)oldElems, (Object)newElems);
                            evt.makeInsertion(inserted, indexes);
                            evtElems.add(evt);
                        } else if (numToBeSet < size2) {
                            int x3;
                            indexes = new int[size2 - numToBeSet];
                            removeIndexes = new int[size2 - numToBeSet];
                            for (x3 = 0; x3 < size2 - numToBeSet; ++x3) {
                                removeIndexes[x3] = pos[numToBeSet + x3];
                            }
                            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)source, "members", (Object)oldMembers, (Object)newMembers);
                            evt.makeRemoval(removedFeatures, removeIndexes);
                            evtMembers.add(evt);
                            for (x3 = 0; x3 < size2 - numToBeSet; ++x3) {
                                indexes[x3] = numToBeSet + x3;
                            }
                            evt = new MultiPropertyChangeEvent((Object)source, this.getPropertyName(), (Object)oldElems, (Object)newElems);
                            evt.makeRemoval(removedFeatures, indexes);
                            evtElems.add(evt);
                        }
                        indexes = new int[setIndexes.length + addIndexes.length + removeIndexes.length];
                        int i = 0;
                        for (x2 = 0; x2 < setIndexes.length; ++x2) {
                            indexes[i] = setIndexes[x2];
                            ++i;
                        }
                        for (x2 = 0; x2 < addIndexes.length; ++x2) {
                            indexes[i] = addIndexes[x2];
                            ++i;
                        }
                        for (x2 = 0; x2 < removeIndexes.length; ++x2) {
                            indexes[i] = removeIndexes[x2];
                            ++i;
                        }
                        MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)source, "members", (Object)oldMembers, (Object)newMembers);
                        evt.makeCompound(evtMembers, indexes);
                        this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                        for (x2 = 0; x2 < indexes.length; ++x2) {
                            indexes[x2] = 0;
                        }
                        evt = new MultiPropertyChangeEvent((Object)source, this.getPropertyName(), (Object)oldElems, (Object)newElems);
                        evt.makeCompound(evtElems, indexes);
                        this.members.parentImpl.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                    }
                    failed = false;
                    break block38;
                }
                failed = false;
                this.members.parentImpl.throwIsInvalid();
            }
            catch (InvalidObjectException e) {
                this.members.parentImpl.throwIsInvalid();
            }
            finally {
                this.members.repository.endTrans(failed);
            }
        }
    }

    private int findAddPosition(int posValue) {
        List features = this.getFeatures();
        int size = features.size();
        if (size == 0) {
            return 0;
        }
        Element[] elems = new Element[size];
        Iterator iter = features.iterator();
        int maxPrevValue = -1;
        int index = -1;
        for (int i = 0; i < size; ++i) {
            Element feature;
            elems[i] = feature = (Element)iter.next();
            int val = this.getPositionalValue((RefObject)feature);
            if (val <= posValue && val > maxPrevValue) {
                maxPrevValue = val;
            }
            if (val != maxPrevValue) continue;
            index = i;
        }
        return index + 1;
    }

    private int getPositionalValue(RefObject feature) {
        if (feature instanceof JavaClass) {
            return POS_VAL_CLASS;
        }
        if (feature instanceof Method) {
            return POS_VAL_METHOD;
        }
        if (feature instanceof Constructor) {
            return POS_VAL_CONSTRUCTOR;
        }
        if (feature instanceof Field) {
            return POS_VAL_FIELD;
        }
        if (feature instanceof Initializer) {
            return POS_VAL_INITIALIZER;
        }
        return POS_VAL_NONE;
    }

    static class FeaturesListener
    extends ElementImpl.ElementListener {
        static org.openide.src.Element[] NO_ELEMENTS = new org.openide.src.Element[0];
        protected ArrayList features;
        protected boolean fireMembers = true;

        FeaturesListener(ElementImpl impl) {
            super(impl);
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                try {
                    ((MDRChangeSource)this.javaElement).addListener((MDRChangeListener)this);
                    this.features = new ArrayList();
                    List classFeatures = ((JavaClass)this.javaElement).getFeatures();
                    if (classFeatures != null) {
                        this.features.addAll(classFeatures);
                    }
                }
                catch (InvalidObjectException invalidObjectException) {
                    // empty catch block
                }
            }
        }

        private String elemName(RefObject elem) {
            if (elem == null) {
                return "null";
            }
            try {
                return ((NamedElement)elem).getName();
            }
            catch (Exception e) {
                return "deleted";
            }
        }

        protected boolean isWatchedAttribute(AttributeEvent ev) {
            return ev.getAttributeName().equals("contents");
        }

        public void doChange(MDRChangeEvent event) {
            super.doChange(event);
            if (event instanceof AttributeEvent && this.isWatchedAttribute((AttributeEvent)event)) {
                AttributeEvent attribEvent = (AttributeEvent)event;
                RefObject prev = (RefObject)attribEvent.getOldElement();
                RefObject curr = (RefObject)attribEvent.getNewElement();
                if (event.isOfType(0x1010001)) {
                    this.doSet(prev, curr);
                } else if (event.isOfType(0x1010004)) {
                    this.doRemove(prev);
                } else {
                    this.doAdd(attribEvent.getPosition(), curr);
                }
            }
        }

        public void doSet(RefObject oldFeature, RefObject feature) {
            ObjectsCollection coll = this.getFeatureCollection(feature);
            if (coll == null) {
                return;
            }
            int position = -1;
            ArrayList<org.openide.src.Element> temp = new ArrayList<org.openide.src.Element>();
            ArrayList<org.openide.src.Element> allTemp = new ArrayList<org.openide.src.Element>();
            Iterator iter = this.features.iterator();
            int size = this.features.size();
            int index = -1;
            for (int x = 0; x < size; ++x) {
                RefObject f = (RefObject)iter.next();
                org.openide.src.Element elem = this.cachedElement(f);
                if (elem != null) {
                    allTemp.add(elem);
                    if (coll.isOfType(f)) {
                        temp.add(elem);
                    }
                }
                if (!f.equals(oldFeature)) continue;
                index = temp.size() - 1;
                position = x;
            }
            if (index == -1) {
                JMManager.getLog().log(1, "Bad index: " + this.elemName(feature));
            }
            org.openide.src.Element oldElem = coll.cachedElement(this.features.set(position, feature));
            org.openide.src.Element newElem = coll.cachedElement(feature);
            if (oldElem == null || newElem == null) {
                return;
            }
            org.openide.src.Element[] old = temp.toArray(NO_ELEMENTS);
            LinkedList<org.openide.src.Element> orig = new LinkedList<org.openide.src.Element>();
            LinkedList<org.openide.src.Element> replacement = new LinkedList<org.openide.src.Element>();
            orig.add(oldElem);
            replacement.add(newElem);
            temp.set(index, newElem);
            org.openide.src.Element[] now = temp.toArray(NO_ELEMENTS);
            if (this.fireMembers) {
                org.openide.src.Element[] allOld = allTemp.toArray(NO_ELEMENTS);
                allTemp.set(position, newElem);
                org.openide.src.Element[] allNew = allTemp.toArray(NO_ELEMENTS);
                MultiPropertyChangeEvent mEvt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), "members", (Object)allOld, (Object)allNew);
                mEvt.makeReplacement(orig, replacement, new int[]{position});
                this.impl.fireOwnPropertyChange((PropertyChangeEvent)mEvt);
            }
            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), coll.getPropertyName(), (Object)old, (Object)now);
            evt.makeReplacement(orig, replacement, new int[]{index});
            this.impl.fireOwnPropertyChange((PropertyChangeEvent)evt);
            this.impl.notifyConnectionSet(oldElem, newElem);
        }

        public void doAdd(int position, RefObject feature) {
            ObjectsCollection coll;
            int size = this.features.size();
            if (position == -1 || position > size) {
                position = size;
            }
            if ((coll = this.getFeatureCollection(feature)) == null) {
                return;
            }
            ArrayList<org.openide.src.Element> temp = new ArrayList<org.openide.src.Element>();
            ArrayList<org.openide.src.Element> allTemp = new ArrayList<org.openide.src.Element>();
            Iterator iter = this.features.iterator();
            int index = -1;
            for (int x = 0; x < size; ++x) {
                RefObject f = (RefObject)iter.next();
                org.openide.src.Element elem = this.cachedElement(f);
                if (elem != null) {
                    allTemp.add(elem);
                    if (coll.isOfType(f)) {
                        temp.add(elem);
                    }
                }
                if (x != position) continue;
                index = temp.size();
            }
            if (index == -1) {
                index = temp.size();
            }
            this.features.add(position, feature);
            org.openide.src.Element addedElem = coll.cachedElement(feature);
            if (addedElem == null) {
                return;
            }
            org.openide.src.Element[] old = temp.toArray(NO_ELEMENTS);
            LinkedList<org.openide.src.Element> added = new LinkedList<org.openide.src.Element>();
            added.add(addedElem);
            temp.add(index, addedElem);
            org.openide.src.Element[] newElems = temp.toArray(NO_ELEMENTS);
            if (this.fireMembers) {
                org.openide.src.Element[] allOld = allTemp.toArray(NO_ELEMENTS);
                allTemp.add(position, addedElem);
                org.openide.src.Element[] allNew = allTemp.toArray(NO_ELEMENTS);
                MultiPropertyChangeEvent mEvt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), "members", (Object)allOld, (Object)allNew);
                mEvt.makeInsertion(added, new int[]{position});
                this.impl.fireOwnPropertyChange((PropertyChangeEvent)mEvt);
            }
            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), coll.getPropertyName(), (Object)old, (Object)newElems);
            evt.makeInsertion(added, new int[]{index});
            this.impl.fireOwnPropertyChange((PropertyChangeEvent)evt);
            this.impl.notifyConnectionAdd(addedElem);
        }

        public void doRemove(RefObject member) {
            int position = -1;
            ObjectsCollection coll = this.getFeatureCollection(member);
            if (coll == null) {
                return;
            }
            ArrayList<org.openide.src.Element> temp = new ArrayList<org.openide.src.Element>();
            ArrayList<org.openide.src.Element> allTemp = new ArrayList<org.openide.src.Element>();
            Iterator iter = this.features.iterator();
            int size = this.features.size();
            int index = -1;
            for (int x = 0; x < size; ++x) {
                RefObject feature = (RefObject)iter.next();
                org.openide.src.Element elem = this.cachedElement(feature);
                if (elem != null) {
                    allTemp.add(elem);
                    if (coll.isOfType(feature)) {
                        temp.add(elem);
                    }
                }
                if (!member.equals(feature)) continue;
                index = temp.size() - 1;
                position = x;
            }
            if (position == -1) {
                JMManager.getLog().log(1, "Bad index: " + this.elemName(member));
                return;
            }
            this.features.remove(position);
            if (this.cachedElement(member) == null) {
                return;
            }
            org.openide.src.Element[] old = temp.toArray(NO_ELEMENTS);
            org.openide.src.Element o = (org.openide.src.Element)temp.remove(index);
            LinkedList<org.openide.src.Element> removed = new LinkedList<org.openide.src.Element>();
            removed.add(o);
            org.openide.src.Element[] newElems = temp.toArray(NO_ELEMENTS);
            if (this.fireMembers) {
                org.openide.src.Element[] allOld = allTemp.toArray(NO_ELEMENTS);
                allTemp.remove(position);
                org.openide.src.Element[] allNew = allTemp.toArray(NO_ELEMENTS);
                MultiPropertyChangeEvent mEvt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), "members", (Object)allOld, (Object)allNew);
                mEvt.makeRemoval(removed, new int[]{position});
                this.impl.fireOwnPropertyChange((PropertyChangeEvent)mEvt);
            }
            MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent((Object)this.impl.getElement(), coll.getPropertyName(), (Object)old, (Object)newElems);
            evt.makeRemoval(removed, new int[]{index});
            this.impl.fireOwnPropertyChange((PropertyChangeEvent)evt);
            this.impl.notifyConnectionRemove(o);
        }

        public ObjectsCollection getFeatureCollection(RefObject feature) {
            if (feature instanceof JavaClass) {
                return ((ClassElementImpl)this.impl).innerClasses;
            }
            if (feature instanceof Method) {
                return ((ClassElementImpl)this.impl).methods;
            }
            if (feature instanceof Constructor) {
                return ((ClassElementImpl)this.impl).constructors;
            }
            if (feature instanceof Field) {
                return ((ClassElementImpl)this.impl).fields;
            }
            if (feature instanceof Initializer) {
                return ((ClassElementImpl)this.impl).initializers;
            }
            return null;
        }

        public org.openide.src.Element cachedElement(RefObject f) {
            if (f instanceof JavaClass) {
                return ((ClassElementImpl)this.impl).innerClasses.cachedElement(f);
            }
            if (f instanceof Method) {
                return ((ClassElementImpl)this.impl).methods.cachedElement(f);
            }
            if (f instanceof Constructor) {
                return ((ClassElementImpl)this.impl).constructors.cachedElement(f);
            }
            if (f instanceof Field) {
                return ((ClassElementImpl)this.impl).fields.cachedElement(f);
            }
            if (f instanceof Initializer) {
                return ((ClassElementImpl)this.impl).initializers.cachedElement(f);
            }
            return null;
        }
    }
}

