/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;

public final class WinClassicEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];
    private static final Rectangle scratch5 = new Rectangle();
    private static boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final int ICON_WIDTH = 17;
    private static final int ICON_HEIGHT = 14;

    public WinClassicEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinClassicEditorTabDisplayerUI((TabDisplayer)c);
    }

    public Rectangle getTabRect(int idx, Rectangle rect) {
        Rectangle r = super.getTabRect(idx, rect);
        r.y = 0;
        r.height = this.displayer.getHeight();
        return r;
    }

    public void install() {
        super.install();
        if (!isGenericUI) {
            this.displayer.setBackground(UIManager.getColor("tab_unsel_fill"));
            this.displayer.setOpaque(true);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + (isGenericUI ? 5 : 6);
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] result = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinClassicEditorTabDisplayerUI.configureButton(result[0], new LeftIcon());
        WinClassicEditorTabDisplayerUI.configureButton(result[2], new DownIcon());
        WinClassicEditorTabDisplayerUI.configureButton(result[1], new RightIcon());
        result[0].setPreferredSize(new Dimension(15, 14));
        result[2].setPreferredSize(new Dimension(16, 14));
        result[1].setPreferredSize(new Dimension(15, 14));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return result;
    }

    private static void configureButton(JButton button, Icon icon) {
        button.setIcon(icon);
        button.setMargin(null);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
        if (isGenericUI) {
            button.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void genericPaintAfterTabs(Graphics g) {
        g.setColor(UIManager.getColor("controlShadow"));
        Insets ins = this.displayer.getInsets();
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        boolean selEnd = false;
        int last = this.getLastVisibleTab();
        if (last > -1) {
            this.getTabRect(last, scratch5);
            g.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() - 1, this.displayer.getWidth() - (ins.left + ins.right) - 4, this.displayer.getHeight() - 1);
            g.drawLine(0, this.displayer.getHeight() - 2, 2, this.displayer.getHeight() - 2);
            if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
                boolean sel = last == this.displayer.getSelectionModel().getSelectedIndex();
                int x = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                g.setColor(sel ? UIManager.getColor("controlShadow") : ColorUtil.adjustTowards(g.getColor(), 20, UIManager.getColor("control")));
                g.drawLine(x, WinClassicEditorTabDisplayerUI.scratch5.y + 5, x, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
                g.setColor(ColorUtil.adjustTowards(g.getColor(), 20, UIManager.getColor("control")));
                g.drawLine(x + 1, WinClassicEditorTabDisplayerUI.scratch5.y + 6, x + 1, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
            }
            if ((this.tabState.getState(this.getFirstVisibleTab()) & 2) != 0 && this.getFirstVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gp = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)g).setPaint(gp);
                g.drawLine(0, this.displayer.getHeight() / 2, 0, this.displayer.getHeight());
            } else {
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(0, this.displayer.getHeight(), 0, this.displayer.getHeight() - 2);
            }
            if ((this.tabState.getState(this.getLastVisibleTab()) & 1) != 0 && this.getLastVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gp = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)g).setPaint(gp);
                this.getTabRect(this.getLastVisibleTab(), scratch5);
                g.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() / 2, WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight());
            }
        } else {
            g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, r.x + r.width - 4, this.displayer.getHeight() - ins.bottom);
        }
    }

    protected void paintAfterTabs(Graphics g) {
        if (isGenericUI) {
            this.genericPaintAfterTabs(g);
            return;
        }
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        g.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets ins = this.getTabAreaInsets();
        ++ins.bottom;
        g.fillRect(r.x, r.y + r.height, r.x + r.width, this.displayer.getHeight() - (r.y + r.height));
        g.setColor(UIManager.getColor("controlLtHighlight"));
        int selEnd = 0;
        int i = this.selectionModel.getSelectedIndex();
        if (i != -1) {
            this.getTabRect(i, scratch5);
            if (WinClassicEditorTabDisplayerUI.scratch5.width != 0) {
                if (r.x < WinClassicEditorTabDisplayerUI.scratch5.x) {
                    g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, WinClassicEditorTabDisplayerUI.scratch5.x - 1, this.displayer.getHeight() - ins.bottom);
                }
                if (WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width < r.x + r.width) {
                    selEnd = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --selEnd;
                    }
                    g.drawLine(selEnd, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
                }
            }
            return;
        }
        g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinClassicEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 55);
    }

    private static class DownIcon
    extends LeftIcon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            xpoints[0] = x + 4;
            ypoints[0] = ++y + 5;
            xpoints[1] = x + 11;
            ypoints[1] = y + 5;
            xpoints[2] = x + 7;
            ypoints[2] = y + 9;
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class RightIcon
    extends LeftIcon {
        private RightIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            xpoints[0] = x + 5;
            ypoints[0] = ++y + 2;
            xpoints[1] = x + 5;
            ypoints[1] = y + 10;
            xpoints[2] = x + 9;
            ypoints[2] = y + 6;
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        protected boolean enabled = false;

        private LeftIcon() {
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 17;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            xpoints[0] = --x + 5;
            ypoints[0] = ++y + 6;
            xpoints[1] = x + 9;
            ypoints[1] = y + 2;
            xpoints[2] = x + 9;
            ypoints[2] = y + 10;
            g.setColor(c.isEnabled() ? c.getForeground() : UIManager.getColor("controlShadow"));
            g.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets in = WinClassicEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] c = parent.getComponents();
            int x = parent.getWidth() - in.right + 4;
            int y = 0;
            for (int i = 0; i < c.length; ++i) {
                Dimension psize = c[i].getPreferredSize();
                y = in.top + 4;
                int w = Math.min(psize.width, parent.getWidth() - x);
                if (i == 2) {
                    x += 2;
                }
                c[i].setBounds(x, y, w, Math.min(psize.height, parent.getHeight()));
                x += psize.width;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return WinClassicEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return WinClassicEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

