/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabSelectionModel;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;
import org.netbeans.swing.tabcontrol.plaf.ViewTabLayoutModel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class AbstractViewTabDisplayerUI
extends TabDisplayerUI {
    private TabDataModel dataModel;
    private ViewTabLayoutModel layoutModel;
    private FontMetrics fm;
    private Font txtFont;
    protected Controller controller;
    protected static IconLoader iconCache = new IconLoader();
    protected PinButton pinButton;
    private final Action pinAction = new PinAction();
    private static final String PIN_ACTION = "pinAction";
    protected final TabState tabState = new ViewTabState();

    public AbstractViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        displayer.setLayout(null);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        ToolTipManager.sharedInstance().registerComponent(this.displayer);
        this.controller = this.createController();
        this.dataModel = this.displayer.getModel();
        this.layoutModel = new ViewTabLayoutModel(this.dataModel, this.displayer);
        this.dataModel.addChangeListener(this.controller);
        this.dataModel.addComplexListDataListener(this.controller);
        this.displayer.addPropertyChangeListener(this.controller);
        this.selectionModel.addChangeListener(this.controller);
        this.displayer.addMouseListener(this.controller);
        this.displayer.addMouseMotionListener(this.controller);
        LocationInformer locInfo = this.displayer.getLocationInformer();
        if (locInfo != null) {
            this.pinButton = this.createPinButton();
        }
        this.installPinButton();
    }

    protected void installPinButton() {
        if (this.pinButton != null) {
            this.displayer.add(this.pinButton);
            this.pinButton.addActionListener(this.controller);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        ToolTipManager.sharedInstance().unregisterComponent(this.displayer);
        this.displayer.removePropertyChangeListener(this.controller);
        this.dataModel.removeChangeListener(this.controller);
        this.dataModel.removeComplexListDataListener(this.controller);
        this.selectionModel.removeChangeListener(this.controller);
        this.displayer.removeMouseListener(this.controller);
        this.displayer.removeMouseMotionListener(this.controller);
        if (this.pinButton != null) {
            this.displayer.remove(this.pinButton);
            this.pinButton.removeActionListener(this.controller);
            this.pinButton = null;
        }
        this.layoutModel = null;
        this.selectionModel = null;
        this.dataModel = null;
        this.controller = null;
    }

    protected abstract Controller createController();

    public void paint(Graphics g, JComponent c) {
        ColorUtil.setupAntialiasing(g);
        for (int i = 0; i < this.dataModel.size(); ++i) {
            TabData tabData = this.dataModel.getTab(i);
            int x = this.layoutModel.getX(i);
            int y = this.layoutModel.getY(i);
            int width = this.layoutModel.getW(i);
            int height = this.layoutModel.getH(i);
            String text = tabData.getText();
            if (!g.hitClip(x, y, width, height)) continue;
            this.paintTabBackground(g, i, x, y, width, height);
            this.paintTabContent(g, i, text, x, y, width, height);
            this.paintTabBorder(g, i, x, y, width, height);
        }
    }

    protected final TabDataModel getDataModel() {
        return this.dataModel;
    }

    public final TabLayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    protected final TabDisplayer getDisplayer() {
        return this.displayer;
    }

    protected final SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Controller getController() {
        return this.controller;
    }

    protected final boolean isSelected(int index) {
        return this.selectionModel.getSelectedIndex() == index;
    }

    protected final boolean isActive() {
        return this.displayer.isActive();
    }

    protected final boolean isFocused(int index) {
        return this.isSelected(index) && this.isActive();
    }

    protected final SingleSelectionModel createSelectionModel() {
        return new DefaultTabSelectionModel(this.displayer.getModel());
    }

    public String getCommandAtPoint(Point p) {
        return this.controller.inCloseIconRect(p) != -1 ? "close" : "select";
    }

    public int dropIndexOfPoint(Point p) {
        int result = 0;
        for (int i = 0; i < this.displayer.getModel().size(); ++i) {
            int x = this.getLayoutModel().getX(i);
            int w = this.getLayoutModel().getW(i);
            if (p.x < x || p.x > x + w) continue;
            if (i == this.displayer.getModel().size() - 1) {
                if (p.x > x + w / 2) {
                    result = this.displayer.getModel().size();
                    break;
                }
                result = i;
                break;
            }
            result = i;
            break;
        }
        return result;
    }

    protected Font getTxtFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                this.txtFont = new Font("Dialog", 0, 11);
            } else if (this.txtFont.isBold()) {
                this.txtFont = new Font(this.txtFont.getName(), 0, this.txtFont.getSize());
            }
        }
        return this.txtFont;
    }

    protected final FontMetrics getTxtFontMetrics() {
        if (this.fm == null) {
            TabDisplayer control = this.getDisplayer();
            this.fm = control.getFontMetrics(this.getTxtFont());
        }
        return this.fm;
    }

    protected abstract void paintTabContent(Graphics var1, int var2, String var3, int var4, int var5, int var6, int var7);

    protected abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected final int getCenteredIconY(Icon icon, int index) {
        TabLayoutModel tlm = this.getLayoutModel();
        int y = tlm.getY(index);
        int h = tlm.getH(index);
        int iconHeight = icon.getIconHeight();
        return y + Math.max(0, h / 2 - iconHeight / 2);
    }

    protected final PinButton configurePinButton(int index) {
        if (this.pinButton == null) {
            return null;
        }
        LocationInformer locInfo = this.getDisplayer().getLocationInformer();
        if (locInfo == null) {
            return null;
        }
        Object orientation = locInfo.getOrientation(this.getDisplayer().getModel().getTab(index).getComponent());
        this.pinButton.setOrientation(orientation);
        return this.pinButton;
    }

    protected PinButton createPinButton() {
        HashMap<Object, String> normalIcons = new HashMap<Object, String>(6);
        normalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-east.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-west.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-south.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-center.gif");
        HashMap<Object, String> pressedIcons = new HashMap<Object, String>(6);
        pressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-east.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-west.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-south.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-center.gif");
        HashMap<Object, String> rolloverIcons = new HashMap<Object, String>(6);
        rolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-east.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-west.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-south.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-center.gif");
        return new PinButton(normalIcons, pressedIcons, rolloverIcons);
    }

    protected void performPinAction() {
        int index = this.getSelectionModel().getSelectedIndex();
        PinButton pinB = this.configurePinButton(index);
        if (pinB != null) {
            if (TabDisplayer.ORIENTATION_CENTER.equals(pinB.getOrientation())) {
                this.shouldPerformAction("disableAutoHide", index, null);
            } else {
                this.shouldPerformAction("enableAutoHide", index, null);
            }
        }
    }

    public void unregisterShortcuts(JComponent comp) {
        comp.getInputMap(1).remove(KeyStroke.getKeyStroke(8, 128));
        comp.getActionMap().remove(PIN_ACTION);
    }

    public void registerShortcuts(JComponent comp) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(8, 128), PIN_ACTION);
        comp.getActionMap().put(PIN_ACTION, this.pinAction);
    }

    public Polygon getExactTabIndication(int index) {
        TabDisplayer control = this.getDisplayer();
        int height = control.getHeight();
        TabLayoutModel tlm = this.getLayoutModel();
        int tabXStart = tlm.getX(index);
        int tabXEnd = tabXStart + tlm.getW(index);
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = tabXStart;
        ypoints[0] = 0;
        xpoints[1] = tabXEnd;
        ypoints[1] = 0;
        xpoints[2] = tabXEnd;
        ypoints[2] = height - 1;
        xpoints[3] = tabXStart;
        ypoints[3] = height - 1;
        return new EqualPolygon(xpoints, ypoints);
    }

    public Polygon getInsertTabIndication(int index) {
        int tabXEnd;
        int tabXStart;
        EqualPolygon indication = new EqualPolygon();
        TabDisplayer control = this.getDisplayer();
        int height = control.getHeight();
        int width = control.getWidth();
        TabLayoutModel tlm = this.getLayoutModel();
        if (index == 0) {
            tabXStart = 0;
            tabXEnd = tlm.getW(0) / 2;
        } else if (index >= this.getDataModel().size()) {
            tabXStart = tlm.getX(index - 1) + tlm.getW(index - 1) / 2;
            tabXEnd = tabXStart + tlm.getW(index - 1);
            if (tabXEnd > width) {
                tabXEnd = width;
            }
        } else {
            tabXStart = tlm.getX(index - 1) + tlm.getW(index - 1) / 2;
            tabXEnd = tlm.getX(index) + tlm.getW(index) / 2;
        }
        indication.moveTo(tabXStart, 0);
        indication.lineTo(tabXEnd, 0);
        indication.lineTo(tabXEnd, height - 1);
        indication.lineTo(tabXStart, height - 1);
        return indication;
    }

    private static Image loadImage(String path) {
        try {
            URL url = AbstractViewTabDisplayerUI.class.getResource("/" + path);
            return Toolkit.getDefaultToolkit().createImage(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Image createImageOfTab(int index) {
        TabData td = this.displayer.getModel().getTab(index);
        JLabel lbl = new JLabel(td.getText());
        int width = lbl.getFontMetrics(lbl.getFont()).stringWidth(td.getText());
        int height = lbl.getFontMetrics(lbl.getFont()).getHeight();
        width = width + td.getIcon().getIconWidth() + 6;
        height = Math.max(height, td.getIcon().getIconHeight()) + 5;
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = config.createCompatibleImage(width, height);
        Graphics2D g = image.createGraphics();
        g.setColor(lbl.getForeground());
        g.setFont(lbl.getFont());
        td.getIcon().paintIcon(lbl, g, 0, 0);
        g.drawString(td.getText(), 18, height / 2);
        return image;
    }

    public Rectangle getTabRect(int index, Rectangle destination) {
        if (destination == null) {
            destination = new Rectangle();
        }
        if (index < 0 || index > this.displayer.getModel().size()) {
            destination.setBounds(0, 0, 0, 0);
            return destination;
        }
        destination.x = this.layoutModel.getX(index);
        destination.width = this.layoutModel.getW(index);
        destination.height = this.layoutModel.getH(index);
        destination.y = Math.min(0, this.displayer.getHeight() - destination.height);
        return destination;
    }

    public int tabForCoordinate(Point p) {
        int max = this.displayer.getModel().size();
        if (max == 0 || p.y > this.displayer.getHeight() || p.y < 0 || p.x < 0 || p.x > this.displayer.getWidth()) {
            return -1;
        }
        for (int i = 0; i < max; ++i) {
            int left = this.layoutModel.getX(i);
            int right = left + this.layoutModel.getW(i);
            if (p.x <= left || p.x >= right) continue;
            return i;
        }
        return -1;
    }

    protected int createRepaintPolicy() {
        return 93;
    }

    protected boolean isAttention(int tab) {
        return (this.tabState.getState(tab) & 0x4000) != 0;
    }

    protected void requestAttention(int tab) {
        this.tabState.addAlarmTab(tab);
    }

    protected void cancelRequestAttention(int tab) {
        this.tabState.removeAlarmTab(tab);
    }

    public String getTooltipForButtons(Point point) {
        if (this.getController().inPinButtonRect(point)) {
            if (this.pinButton != null) {
                return this.pinButton.getPinToolTipText();
            }
            return null;
        }
        if (this.getController().inCloseIconRect(point) != -1) {
            return NbBundle.getMessage((Class)AbstractViewTabDisplayerUI.class, (String)"CloseButton.tooltip");
        }
        return null;
    }

    private final class PinAction
    extends AbstractAction {
        private PinAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewTabDisplayerUI.this.performPinAction();
        }
    }

    protected static class PinButton
    extends JButton {
        private Map pressedIcons;
        private Map rolloverIcons;
        private Map regularIcons;
        private Object orientation;

        public PinButton(Map regularIcons, Map pressedIcons, Map rolloverIcons) {
            this.regularIcons = regularIcons;
            this.pressedIcons = pressedIcons;
            this.rolloverIcons = rolloverIcons;
            this.setFocusable(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(rolloverIcons != null);
            this.setOrientation(TabDisplayer.ORIENTATION_CENTER);
        }

        public void updateUI() {
            super.updateUI();
            this.setFocusable(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public Object getOrientation() {
            return this.orientation;
        }

        public void setOrientation(Object orientation) {
            this.orientation = orientation;
            if (orientation != TabDisplayer.ORIENTATION_INVISIBLE) {
                Icon icon = iconCache.obtainIcon((String)this.regularIcons.get(orientation));
                this.setIcon(icon);
                this.setSize(icon.getIconWidth(), icon.getIconHeight());
                if (this.pressedIcons != null) {
                    this.setPressedIcon(iconCache.obtainIcon((String)this.regularIcons.get(orientation)));
                }
                if (this.rolloverIcons != null) {
                    this.setRolloverIcon(iconCache.obtainIcon((String)this.rolloverIcons.get(orientation)));
                }
                this.setToolTipText(this.getPinToolTipText());
            } else {
                this.setIcon(null);
                this.setPressedIcon(null);
                this.setSize(0, 0);
                this.setRolloverIcon(null);
                this.setToolTipText(null);
            }
        }

        private String getPinToolTipText() {
            if (this.orientation != TabDisplayer.ORIENTATION_CENTER) {
                return NbBundle.getMessage((Class)(class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI == null ? (class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI = AbstractViewTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI")) : class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI), (String)"AutoHideButton.tooltip");
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI == null ? (class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI = AbstractViewTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI")) : class$org$netbeans$swing$tabcontrol$plaf$AbstractViewTabDisplayerUI), (String)"AutoHideButton.restore.tooltip");
        }
    }

    abstract class Controller
    extends MouseAdapter
    implements MouseMotionListener,
    ChangeListener,
    PropertyChangeListener,
    ActionListener,
    ComplexListDataListener {
        private int closePressed = -1;
        private int mouseInCloseButton = -1;
        private boolean selectionChanged;

        Controller() {
        }

        protected abstract int inCloseIconRect(Point var1);

        protected abstract boolean inPinButtonRect(Point var1);

        protected boolean shouldReact(MouseEvent e) {
            boolean isLeft = SwingUtilities.isLeftMouseButton(e);
            return isLeft;
        }

        public void stateChanged(ChangeEvent ce) {
            AbstractViewTabDisplayerUI.this.displayer.repaint();
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if ("active".equals(pce.getPropertyName())) {
                AbstractViewTabDisplayerUI.this.displayer.repaint();
            }
        }

        protected void performAction(MouseEvent e) {
            if (AbstractViewTabDisplayerUI.this.shouldPerformAction("close", this.mouseInCloseButton, e)) {
                AbstractViewTabDisplayerUI.this.getDataModel().removeTab(this.mouseInCloseButton);
            }
        }

        public void mousePressed(MouseEvent e) {
            boolean change;
            Point p = e.getPoint();
            int i = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(p.x, p.y);
            AbstractViewTabDisplayerUI.this.tabState.setPressed(i);
            SingleSelectionModel sel = AbstractViewTabDisplayerUI.this.getSelectionModel();
            boolean bl = this.selectionChanged = i != sel.getSelectedIndex();
            if ((i != -1 || !this.selectionChanged) && (change = AbstractViewTabDisplayerUI.this.shouldPerformAction("select", i, e))) {
                AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(i);
                AbstractViewTabDisplayerUI.this.tabState.setSelected(i);
                Component tc = AbstractViewTabDisplayerUI.this.getDataModel().getTab(i).getComponent();
                if (null != tc && tc instanceof TopComponent && !((TopComponent)tc).isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                    ((TopComponent)tc).requestActive();
                }
            }
            if (this.shouldReact(e) && !this.selectionChanged) {
                this.setClosePressed(this.inCloseIconRect(e.getPoint()));
            }
            if (i != -1 && e.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", i, e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && !e.isPopupTrigger()) {
                boolean change;
                SingleSelectionModel sel;
                Point p = e.getPoint();
                int i = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(p.x, p.y);
                boolean bl = this.selectionChanged = i != (sel = AbstractViewTabDisplayerUI.this.getSelectionModel()).getSelectedIndex();
                if ((i != -1 || !this.selectionChanged) && (change = AbstractViewTabDisplayerUI.this.shouldPerformAction("select", i, e))) {
                    AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(i);
                }
                if (i != -1) {
                    AbstractViewTabDisplayerUI.this.shouldPerformAction("maximize", i, e);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            AbstractViewTabDisplayerUI.this.tabState.setPressed(-1);
            if (this.shouldReact(e) && !this.selectionChanged) {
                this.setClosePressed(-1);
                Point point = e.getPoint();
                this.mouseInCloseButton = this.inCloseIconRect(point);
                if (this.mouseInCloseButton >= 0) {
                    this.performAction(e);
                    this.setMouseInCloseButton(point);
                }
            }
            Point p = e.getPoint();
            int i = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(p.x, p.y);
            if (i != -1 && e.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", i, e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.setMouseInCloseButton(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            this.setClosePressed(this.inCloseIconRect(e.getPoint()));
            this.setMouseInCloseButton(e.getPoint());
        }

        public void mouseExited(MouseEvent e) {
            this.setMouseInCloseButton(e.getPoint());
        }

        public int isClosePressed() {
            return this.closePressed;
        }

        public int isMouseInCloseButton() {
            return this.mouseInCloseButton;
        }

        protected void setClosePressed(int pressed) {
            if (this.closePressed == pressed) {
                return;
            }
            int oldValue = this.closePressed;
            this.closePressed = pressed;
            if (this.closePressed == -1) {
                TabLayoutModel tlm = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tlm.getX(oldValue), tlm.getY(oldValue), tlm.getW(oldValue), tlm.getH(oldValue));
            } else if (oldValue == -1) {
                TabLayoutModel tlm = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tlm.getX(this.closePressed), tlm.getY(this.closePressed), tlm.getW(this.closePressed), tlm.getH(this.closePressed));
            } else {
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint();
            }
        }

        protected void setMouseInCloseButton(Point location) {
            int isNow = this.inCloseIconRect(location);
            if (this.mouseInCloseButton == isNow || AbstractViewTabDisplayerUI.this.dataModel.size() == 0) {
                return;
            }
            int oldValue = this.mouseInCloseButton;
            this.mouseInCloseButton = isNow;
            AbstractViewTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(isNow);
            if (isNow == -1) {
                TabLayoutModel tlm = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tlm.getX(oldValue), tlm.getY(oldValue), tlm.getW(oldValue), tlm.getH(oldValue));
            } else if (oldValue == -1) {
                TabLayoutModel tlm = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tlm.getX(isNow), tlm.getY(isNow), tlm.getW(isNow), tlm.getH(isNow));
            } else {
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint();
            }
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewTabDisplayerUI.this.performPinAction();
        }

        public void indicesAdded(ComplexListDataEvent e) {
            AbstractViewTabDisplayerUI.this.tabState.indicesAdded(e);
        }

        public void indicesRemoved(ComplexListDataEvent e) {
            AbstractViewTabDisplayerUI.this.tabState.indicesRemoved(e);
        }

        public void indicesChanged(ComplexListDataEvent e) {
            AbstractViewTabDisplayerUI.this.tabState.indicesChanged(e);
        }

        public void intervalAdded(ListDataEvent evt) {
            AbstractViewTabDisplayerUI.this.tabState.intervalAdded(evt);
        }

        public void intervalRemoved(ListDataEvent evt) {
            AbstractViewTabDisplayerUI.this.tabState.intervalRemoved(evt);
        }

        public void contentsChanged(ListDataEvent evt) {
            AbstractViewTabDisplayerUI.this.tabState.contentsChanged(evt);
        }
    }

    private class ViewTabState
    extends TabState {
        private ViewTabState() {
        }

        public int getRepaintPolicy(int tab) {
            return AbstractViewTabDisplayerUI.this.createRepaintPolicy();
        }

        public void repaintAllTabs() {
            AbstractViewTabDisplayerUI.this.displayer.repaint();
        }

        public void repaintTab(int tab) {
            if (tab < 0 || tab >= AbstractViewTabDisplayerUI.this.displayer.getModel().size()) {
                return;
            }
            Rectangle r = AbstractViewTabDisplayerUI.this.getTabRect(tab, null);
            AbstractViewTabDisplayerUI.this.displayer.repaint(r);
        }
    }

    static final class IconLoader {
        private Map paths2Icons;

        IconLoader() {
        }

        public Icon obtainIcon(String iconPath) {
            Icon icon;
            if (this.paths2Icons == null) {
                this.paths2Icons = new HashMap(6);
            }
            if ((icon = (Icon)this.paths2Icons.get(iconPath)) == null) {
                Image image = AbstractViewTabDisplayerUI.loadImage(iconPath);
                if (image == null) {
                    throw new IllegalArgumentException("Icon with resource path: " + iconPath + " can't be loaded, probably wrong path.");
                }
                icon = new ImageIcon(image);
                this.paths2Icons.put(iconPath, icon);
            }
            return icon;
        }
    }
}

