/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.MultiSplitPane;

public class SplitView
extends ViewElement {
    private int orientation;
    private ArrayList splitWeights;
    private ArrayList children;
    private MultiSplitPane splitPane;
    private boolean isDirty = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SplitView(Controller controller, double resizeWeight, int orientation, List splitWeights, List children) {
        super(controller, resizeWeight);
        this.orientation = orientation;
        this.splitWeights = new ArrayList(splitWeights);
        this.children = new ArrayList(children);
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public void setSplitWeights(List newSplitWeights) {
        this.splitWeights.clear();
        this.splitWeights.addAll(newSplitWeights);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public List getChildren() {
        return new ArrayList(this.children);
    }

    public Component getComponent() {
        return this.getSplitPane();
    }

    public void remove(ViewElement view) {
        int index = this.children.indexOf(view);
        if (index >= 0) {
            this.children.remove(index);
            this.splitWeights.remove(index);
            if (null != this.splitPane) {
                this.splitPane.removeViewElementAt(index);
            }
            this.isDirty = true;
        }
    }

    public void setChildren(List newChildren) {
        this.children.clear();
        this.children.addAll(newChildren);
        if (!$assertionsDisabled && this.children.size() != this.splitWeights.size()) {
            throw new AssertionError();
        }
        this.isDirty = true;
        if (null != this.splitPane) {
            this.updateSplitPane();
        }
    }

    public boolean updateAWTHierarchy(Dimension availableSpace) {
        boolean res = false;
        if (!availableSpace.equals(this.getSplitPane().getSize()) || this.isDirty) {
            this.isDirty = false;
            this.getSplitPane().setSize(availableSpace);
            this.getSplitPane().invalidate();
            res = true;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            ViewElement child = (ViewElement)i.next();
            res |= child.updateAWTHierarchy(child.getComponent().getSize());
        }
        return res;
    }

    private MultiSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new MultiSplitPane();
            this.updateSplitPane();
            this.splitPane.setDividerSize(this.orientation == 0 ? 4 : 5);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.addPropertyChangeListener("splitPositions", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ArrayList weights = new ArrayList(SplitView.this.children.size());
                    ArrayList views = new ArrayList(SplitView.this.children.size());
                    SplitView.this.splitPane.calculateSplitWeights(views, weights);
                    ViewElement[] arrViews = new ViewElement[views.size()];
                    double[] arrWeights = new double[views.size()];
                    for (int i = 0; i < views.size(); ++i) {
                        arrViews[i] = (ViewElement)views.get(i);
                        arrWeights[i] = (Double)weights.get(i);
                    }
                    SplitView.this.getController().userMovedSplit(SplitView.this, arrViews, arrWeights);
                }
            });
        }
        return this.splitPane;
    }

    public int getDividerSize() {
        return this.getSplitPane().getDividerSize();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("[");
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement child = (ViewElement)this.children.get(i);
            buffer.append(i + 1);
            buffer.append('=');
            if (child instanceof SplitView) {
                buffer.append(child.getClass());
                buffer.append('@');
                buffer.append(Integer.toHexString(child.hashCode()));
            } else {
                buffer.append(child.toString());
            }
            if (i >= this.children.size() - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void updateSplitPane() {
        ViewElement[] arrViews = new ViewElement[this.children.size()];
        double[] arrSplitWeights = new double[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement view;
            arrViews[i] = view = (ViewElement)this.children.get(i);
            arrSplitWeights[i] = (Double)this.splitWeights.get(i);
        }
        this.splitPane.setChildren(this.orientation, arrViews, arrSplitWeights);
    }

    private static void debugLog(String message) {
        Debug.log(SplitView.class, message);
    }

    static {
        $assertionsDisabled = !SplitView.class.desiredAssertionStatus();
    }
}

