/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public final class IdxPropertyPattern
extends PropertyPattern {
    protected Method indexedGetterMethod = null;
    protected Method indexedSetterMethod = null;
    protected Type indexedType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IdxPropertyPattern(PatternAnalyser patternAnalyser, Method getterMethod, Method setterMethod, Method indexedGetterMethod, Method indexedSetterMethod) throws IntrospectionException, JmiException {
        super(patternAnalyser, getterMethod, setterMethod);
        this.indexedGetterMethod = indexedGetterMethod;
        this.indexedSetterMethod = indexedSetterMethod;
        this.findIndexedPropertyType();
        if (this.type == null && this.indexedType != null) {
            JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)this.indexedType);
            this.type = jmodel.getArray().resolveArray(this.indexedType);
        }
        this.name = this.findIndexedPropertyName();
    }

    private IdxPropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean niGetter, boolean niWithReturn, boolean niSetter, boolean niWithSet) throws JmiException, GenerateBeanException {
        return IdxPropertyPattern.create(patternAnalyser, name, type, mode, bound, constrained, withField, withReturn, withSet, withSupport, niGetter, niWithReturn, niSetter, niWithSet, false, false);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean niGetter, boolean niWithReturn, boolean niSetter, boolean niWithSet, boolean useSupport, boolean fromField) throws JmiException, GenerateBeanException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        IdxPropertyPattern ipp = new IdxPropertyPattern(patternAnalyser);
        ipp.name = name;
        ipp.type = null;
        ipp.indexedType = patternAnalyser.findType(type);
        if (withField || withSupport || niGetter || niSetter) {
            JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ipp.indexedType);
            ipp.type = jmodel.getArray().resolveArray(ipp.indexedType);
        }
        if ((withField || withSupport) && !fromField && ipp.type != null) {
            try {
                ipp.generateField(true);
            }
            catch (GenerateBeanException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String supportName = null;
        String vetoSupportName = null;
        if (withSupport) {
            boolean boundSupport = bound;
            boolean constrainedSupport = constrained;
            if (!useSupport) {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(ipp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(ipp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            } else {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(ipp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(ipp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            }
            if (boundSupport) {
                supportName = BeanPatternGenerator.supportField(ipp.getDeclaringClass());
            }
            if (constrainedSupport) {
                vetoSupportName = BeanPatternGenerator.vetoSupportField(ipp.getDeclaringClass());
            }
            if (boundSupport) {
                BeanPatternGenerator.supportListenerMethods(ipp.getDeclaringClass(), supportName);
            }
            if (constrainedSupport) {
                BeanPatternGenerator.vetoSupportListenerMethods(ipp.getDeclaringClass(), vetoSupportName);
            }
        }
        if (mode == 1 || mode == 2) {
            if (fromField && withReturn || !fromField) {
                ipp.generateIndexedGetterMethod(BeanPatternGenerator.idxPropertyGetterBody(name, withReturn), true);
            }
            if (ipp.type != null && niGetter) {
                ipp.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(name, niWithReturn), true);
            }
        }
        if (mode == 1 || mode == 4) {
            if (fromField && withSet || !fromField) {
                ipp.generateIndexedSetterMethod(BeanPatternGenerator.idxPropertySetterBody(name, ipp.getIndexedType(), bound, constrained, withSet, withSupport, supportName, vetoSupportName), constrained, true);
            }
            if (ipp.type != null && niSetter) {
                ipp.generateSetterMethod(BeanPatternGenerator.propertySetterBody(name, ipp.getType(), bound, constrained, niWithSet, withSupport, supportName, vetoSupportName), constrained, true);
            }
        }
        return ipp;
    }

    public Type getIndexedType() {
        return this.indexedType;
    }

    public void setName(String name) throws IllegalArgumentException, JmiException {
        String oldName = this.name;
        super.setName(name);
        name = IdxPropertyPattern.capitalizeFirstLetter(name);
        if (this.indexedGetterMethod != null) {
            String idxGetterMethodID = (this.indexedGetterMethod.getName().startsWith("get") ? "get" : "is") + name;
            this.indexedGetterMethod.setName(idxGetterMethodID);
            String oldGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), oldName);
            String newGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), this.getName());
            String indexedGetterJavadoc = this.indexedGetterMethod.getJavadocText();
            if (indexedGetterJavadoc != null && oldGetterComment.trim().equals(indexedGetterJavadoc.trim())) {
                this.indexedGetterMethod.setJavadocText(newGetterComment);
            }
        }
        if (this.indexedSetterMethod != null) {
            String idxSetterMethodID = "set" + name;
            this.indexedSetterMethod.setName(idxSetterMethodID);
            String oldSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), oldName, oldName);
            String newSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), this.getName(), this.getName());
            String indexedSetterJavadoc = this.indexedSetterMethod.getJavadocText();
            if (indexedSetterJavadoc != null && oldSetterComment.trim().equals(indexedSetterJavadoc.trim())) {
                this.indexedSetterMethod.setJavadocText(newSetterComment);
            }
        }
        if (this.estimatedField != null && this.estimatedField.getName().equals(this.getName())) {
            String oldSetterBody;
            String existingSetterBody;
            int mode = this.getMode();
            if (mode == 1 || mode == 2) {
                String existingGetterBody = this.indexedGetterMethod.getBodyText().trim();
                String oldGetterBody1 = BeanPatternGenerator.idxPropertyGetterBody(oldName, true, true).trim();
                String oldGetterBody2 = BeanPatternGenerator.idxPropertyGetterBody(oldName, true, false).trim();
                if (existingGetterBody.equals(oldGetterBody1)) {
                    this.indexedGetterMethod.setBodyText(BeanPatternGenerator.idxPropertyGetterBody(this.getName(), true, true));
                } else if (existingGetterBody.equals(oldGetterBody2)) {
                    this.indexedGetterMethod.setBodyText(BeanPatternGenerator.idxPropertyGetterBody(this.getName(), true, false));
                }
            }
            if ((mode == 1 || mode == 4) && (existingSetterBody = this.indexedSetterMethod.getBodyText().trim()).equals(oldSetterBody = BeanPatternGenerator.idxPropertySetterBody(oldName, this.type, false, false, true, false, null, null).trim())) {
                this.indexedSetterMethod.setBodyText(BeanPatternGenerator.idxPropertySetterBody(this.getName(), this.getType(), false, false, true, false, null, null));
                if (this.indexedSetterMethod != null) {
                    List params = this.indexedSetterMethod.getParameters();
                    Parameter param = (Parameter)params.get(1);
                    param.setName(Introspector.decapitalize(name));
                }
            }
        }
    }

    public Method getIndexedGetterMethod() {
        return this.indexedGetterMethod;
    }

    public Method getIndexedSetterMethod() {
        return this.indexedSetterMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type type) throws JmiException {
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            this.setTypeImpl(type);
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    private void setTypeImpl(Type type) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.type != null && this.type.equals(type)) {
            return;
        }
        Type oldIndexedType = this.indexedType;
        Type oldType = this.type;
        if (oldType == null) {
            this.type = type;
            oldType = type;
            int mode = this.getMode();
            if (mode == 1 || mode == 2) {
                try {
                    this.generateGetterMethod();
                }
                catch (GenerateBeanException e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
            }
            if (mode == 1 || mode == 4) {
                try {
                    this.generateSetterMethod();
                }
                catch (GenerateBeanException e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
            }
        } else {
            super.setType(type);
        }
        if (type instanceof Array && oldType instanceof Array && oldIndexedType.equals(((Array)oldType).getType())) {
            Type newType = ((Array)type).getType();
            this.setIndexedTypeImpl(newType, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexedType(Type type) throws JmiException {
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            this.setIndexedTypeImpl(type, true);
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    private void setIndexedTypeImpl(Type type, boolean changeType) throws JmiException {
        List params;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.indexedType.equals(type)) {
            return;
        }
        Type oldType = this.type;
        if (this.indexedGetterMethod != null) {
            this.indexedGetterMethod.setType(type);
        }
        if (this.indexedSetterMethod != null && (params = this.indexedSetterMethod.getParameters()).size() > 1) {
            Parameter param = (Parameter)params.get(1);
            param.setType(type);
            String body = this.indexedSetterMethod.getBodyText();
            if (body != null && (body.indexOf("firePropertyChange") != -1 || body.indexOf("fireVetoableChange") != -1)) {
                String newBody;
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION) && (newBody = this.regeneratePropertySupport(this.indexedSetterMethod.getBodyText(), null, param.getName(), type, oldType)) != null) {
                    this.indexedSetterMethod.setBodyText(newBody);
                }
            }
        }
        if (changeType) {
            JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)type);
            Array newArrayType = jmodel.getArray().resolveArray(type);
            super.setType((Type)newArrayType);
        }
        this.indexedType = type;
    }

    public int getMode() {
        if (this.indexedSetterMethod != null && this.indexedGetterMethod != null) {
            return 1;
        }
        if (this.indexedGetterMethod != null && this.indexedSetterMethod == null) {
            return 2;
        }
        if (this.indexedSetterMethod != null && this.indexedGetterMethod == null) {
            return 4;
        }
        return super.getMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) throws GenerateBeanException, JmiException {
        if (this.getMode() == mode) {
            return;
        }
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            switch (mode) {
                case 1: {
                    if (this.getterMethod == null) {
                        this.generateGetterMethod();
                    }
                    if (this.setterMethod == null) {
                        this.generateSetterMethod();
                    }
                    if (this.indexedGetterMethod == null) {
                        this.generateIndexedGetterMethod();
                    }
                    if (this.indexedSetterMethod != null) break;
                    this.generateIndexedSetterMethod();
                    break;
                }
                case 2: {
                    if (this.getterMethod == null) {
                        this.generateGetterMethod();
                    }
                    if (this.indexedGetterMethod == null) {
                        this.generateIndexedGetterMethod();
                    }
                    if (this.setterMethod == null && this.indexedSetterMethod == null) break;
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                    if (this.setterMethod != null) {
                        this.deleteSetterMethod();
                    }
                    if (this.indexedSetterMethod == null) break;
                    this.deleteIndexedSetterMethod();
                    break;
                }
                case 4: {
                    if (this.setterMethod == null) {
                        this.generateSetterMethod();
                    }
                    if (this.indexedSetterMethod == null) {
                        this.generateIndexedSetterMethod();
                    }
                    if (this.getterMethod == null && this.indexedGetterMethod == null) break;
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                    if (this.getterMethod != null) {
                        this.deleteGetterMethod();
                    }
                    if (this.indexedGetterMethod == null) break;
                    this.deleteIndexedGetterMethod();
                }
            }
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    public Node.Cookie getCookie(Class cookieType) {
        return super.getCookie(cookieType);
    }

    public void destroy() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        this.deleteIndexedSetterMethod();
        this.deleteIndexedGetterMethod();
        super.destroy();
    }

    IdxPropertyPattern(PropertyPattern x, PropertyPattern y) throws JmiException {
        super(x, y);
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (x instanceof IdxPropertyPattern) {
            IdxPropertyPattern ix = (IdxPropertyPattern)x;
            this.indexedGetterMethod = ix.indexedGetterMethod;
            this.indexedSetterMethod = ix.indexedSetterMethod;
            this.indexedType = ix.indexedType;
            Type type = this.type = this.type == null ? ix.type : this.type;
        }
        if (y instanceof IdxPropertyPattern) {
            IdxPropertyPattern iy = (IdxPropertyPattern)y;
            if (iy.indexedGetterMethod != null) {
                this.indexedGetterMethod = iy.indexedGetterMethod;
            }
            if (iy.indexedSetterMethod != null) {
                this.indexedSetterMethod = iy.indexedSetterMethod;
            }
            this.indexedType = iy.indexedType;
            this.type = this.type == null ? iy.type : this.type;
        }
        this.name = this.findIndexedPropertyName();
    }

    private void findIndexedPropertyType() throws IntrospectionException, JmiException {
        Type propType;
        List params;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        this.indexedType = null;
        if (this.indexedGetterMethod != null) {
            params = this.indexedGetterMethod.getParameters();
            if (params.size() != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            Parameter param = (Parameter)params.get(0);
            if (!JMIUtils.isPrimitiveType(param.getType(), PrimitiveTypeKindEnum.INT)) {
                throw new IntrospectionException("not int index to indexed read method");
            }
            this.indexedType = this.indexedGetterMethod.getType();
            if (JMIUtils.isPrimitiveType(this.indexedType, PrimitiveTypeKindEnum.VOID)) {
                throw new IntrospectionException("indexed read method return void");
            }
        }
        if (this.indexedSetterMethod != null) {
            params = this.indexedSetterMethod.getParameters();
            if (params.size() != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            Parameter param1 = (Parameter)params.get(0);
            if (!JMIUtils.isPrimitiveType(param1.getType(), PrimitiveTypeKindEnum.INT)) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            Parameter param2 = (Parameter)params.get(1);
            if (this.indexedType != null && !this.indexedType.equals(param2.getType())) {
                throw new IntrospectionException("type mismatch between indexed read and write methods");
            }
            this.indexedType = param2.getType();
        }
        if (!((propType = this.getType()) == null || propType instanceof Array && this.indexedType.equals(((Array)propType).getType()))) {
            throw new IntrospectionException("type mismatch between property type and indexed type");
        }
    }

    String findIndexedPropertyName() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String superName = this.findPropertyName();
        if (superName == null) {
            String methodName = null;
            if (this.indexedGetterMethod != null) {
                methodName = this.indexedGetterMethod.getName();
            } else if (this.indexedSetterMethod != null) {
                methodName = this.indexedSetterMethod.getName();
            } else {
                throw new InternalError("Indexed property with all methods == null");
            }
            return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
        }
        return superName;
    }

    void generateGetterMethod() throws GenerateBeanException, JmiException {
        if (this.type != null) {
            super.generateGetterMethod();
        }
    }

    void generateSetterMethod() throws GenerateBeanException, JmiException {
        if (this.type != null) {
            super.generateSetterMethod();
        }
    }

    void generateIndexedGetterMethod() throws GenerateBeanException, JmiException {
        this.generateIndexedGetterMethod(null, false);
    }

    void generateIndexedGetterMethod(String body, boolean javadoc) throws GenerateBeanException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newGetter = jmodel.getMethod().createMethod();
        Parameter newParameter = jmodel.getParameter().createParameter();
        newParameter.setName("index");
        newParameter.setType(jmodel.getType().resolve("int"));
        newGetter.setName("get" + IdxPropertyPattern.capitalizeFirstLetter(this.getName()));
        newGetter.setType(this.indexedType);
        newGetter.setModifiers(1);
        newGetter.getParameters().add(newParameter);
        if (declaringClass.isInterface()) {
            newGetter.setBodyText(null);
        } else if (body != null) {
            newGetter.setBodyText(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), this.getName());
            newGetter.setJavadocText(comment);
        }
        if (declaringClass == null) {
            throw new GenerateBeanException();
        }
        declaringClass.getFeatures().add(newGetter);
        this.indexedGetterMethod = newGetter;
    }

    void generateIndexedSetterMethod() throws GenerateBeanException, JmiException {
        this.generateIndexedSetterMethod(null, false, false);
    }

    void generateIndexedSetterMethod(String body, boolean constrained, boolean javadoc) throws GenerateBeanException, JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newSetter = jmodel.getMethod().createMethod();
        Parameter newParamIndex = jmodel.getParameter().createParameter();
        newParamIndex.setName("index");
        newParamIndex.setType(jmodel.getType().resolve("int"));
        Parameter newParamValue = jmodel.getParameter().createParameter();
        newParamValue.setName(this.name);
        newParamValue.setType(this.indexedType);
        newSetter.setName("set" + IdxPropertyPattern.capitalizeFirstLetter(this.getName()));
        newSetter.setType(jmodel.getType().resolve("void"));
        newSetter.setModifiers(1);
        List params = newSetter.getParameters();
        params.add(newParamIndex);
        params.add(newParamValue);
        if (constrained) {
            MultipartId propVetoEx = jmodel.getMultipartId().createMultipartId("java.beans.PropertyVetoException", null, null);
            if (propVetoEx == null) {
                throw new GenerateBeanException("cannot resolve java.beans.PropertyVetoException");
            }
            newSetter.getExceptionNames().add(propVetoEx);
        }
        if (declaringClass.isInterface()) {
            newSetter.setBodyText(null);
        } else if (body != null) {
            newSetter.setBodyText(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), this.getName(), this.name);
            if (constrained) {
                comment = comment + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            newSetter.setJavadocText(comment);
        }
        if (declaringClass == null) {
            throw new GenerateBeanException();
        }
        declaringClass.getFeatures().add(newSetter);
        this.indexedSetterMethod = newSetter;
    }

    void deleteIndexedGetterMethod() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.indexedGetterMethod == null) {
            return;
        }
        JavaClass declaringClass = this.getDeclaringClass();
        declaringClass.getFeatures().remove(this.indexedGetterMethod);
        this.indexedGetterMethod = null;
    }

    void deleteIndexedSetterMethod() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.indexedSetterMethod == null) {
            return;
        }
        JavaClass declaringClass = this.getDeclaringClass();
        declaringClass.getFeatures().remove(this.indexedSetterMethod);
        this.indexedSetterMethod = null;
    }

    void copyProperties(IdxPropertyPattern src) throws JmiException {
        boolean changed;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        boolean bl = !src.getIndexedType().equals(this.getIndexedType()) || !(src.getType() == null ? this.getType() == null : src.getType().equals(this.getType())) || !src.getName().equals(this.getName()) || src.getMode() != this.getMode() || !(src.getEstimatedField() != null ? src.getEstimatedField().equals(this.estimatedField) : this.estimatedField == null) ? true : (changed = false);
        if (src.getIndexedGetterMethod() != this.indexedGetterMethod) {
            this.indexedGetterMethod = src.getIndexedGetterMethod();
        }
        if (src.getIndexedSetterMethod() != this.indexedSetterMethod) {
            this.indexedSetterMethod = src.getIndexedSetterMethod();
        }
        if (src.getGetterMethod() != this.getterMethod) {
            changed = true;
            this.getterMethod = src.getGetterMethod();
        }
        if (src.getSetterMethod() != this.setterMethod) {
            changed = true;
            this.setterMethod = src.getSetterMethod();
        }
        if (src.getEstimatedField() != this.estimatedField) {
            this.estimatedField = src.getEstimatedField();
        }
        if (changed) {
            try {
                this.type = this.findPropertyType();
                this.findIndexedPropertyType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.name = this.findIndexedPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    static {
        $assertionsDisabled = !IdxPropertyPattern.class.desiredAssertionStatus();
    }
}

