/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMICompletionQuery;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;

public class AbbreviationsCompletionProvider
implements CompletionProvider {
    private static final boolean NON_EXACT_MATCH = Boolean.getBoolean("nebeans.editor.completion.abbreviations.nonexactmatch");
    private static final boolean ENABLED = Boolean.getBoolean("nebeans.editor.completion.abbreviations.enable");
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$AbbreviationsCompletionProvider;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    public static List queryImpl(Document doc, int offset) {
        if (!ENABLED || !(doc instanceof BaseDocument)) {
            return Collections.EMPTY_LIST;
        }
        BaseDocument bdoc = (BaseDocument)doc;
        try {
            int id;
            TokenID token = ((ExtSyntaxSupport)bdoc.getSyntaxSupport()).getTokenID(offset);
            int n = id = token != null ? token.getNumericID() : 0;
            if (id == 10 || id == 9 || id == 7 || id == 8) {
                return Collections.EMPTY_LIST;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        try {
            Class kitClass = bdoc.getKitClass();
            if (kitClass != null) {
                int index;
                BaseOptions o = BaseOptions.getOptions((Class)kitClass);
                Map abbrevs = o.getAbbrevMap();
                int maxCodeLength = 0;
                Iterator i = abbrevs.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (key.length() <= maxCodeLength) continue;
                    maxCodeLength = key.length();
                }
                Acceptor abbrevAcceptor = (Acceptor)Settings.getValue((Class)kitClass, (String)"abbrev-reset-acceptor");
                if (abbrevAcceptor == null) {
                    abbrevAcceptor = AcceptorFactory.NON_JAVA_IDENTIFIER;
                }
                String potentialPrefix = doc.getText(offset - maxCodeLength - 1, maxCodeLength + 1);
                for (index = 0; index < maxCodeLength + 1 && !abbrevAcceptor.accept(potentialPrefix.charAt(maxCodeLength - index)); ++index) {
                }
                if (index == 0) {
                    return Collections.EMPTY_LIST;
                }
                String prefix = potentialPrefix.substring(maxCodeLength - index + 1);
                ArrayList<NbJMIResultItem.StringResultItem> result = new ArrayList<NbJMIResultItem.StringResultItem>();
                Iterator i2 = abbrevs.keySet().iterator();
                while (i2.hasNext()) {
                    String key = (String)i2.next();
                    if ((!NON_EXACT_MATCH || !key.startsWith(prefix)) && !key.equals(prefix)) continue;
                    result.add(NbJavaJMICompletionQuery.getJMIItemFactory().createStringResultItem((String)abbrevs.get(key)));
                }
                return result;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    static class Query
    extends AsyncCompletionQuery {
        static final /* synthetic */ boolean $assertionsDisabled;

        Query() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            List results = AbbreviationsCompletionProvider.queryImpl(doc, caretOffset);
            if (!$assertionsDisabled && results == null) {
                throw new AssertionError();
            }
            resultSet.addAllItems((Collection)results);
            resultSet.finish();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$java$AbbreviationsCompletionProvider == null ? (class$org$netbeans$modules$editor$java$AbbreviationsCompletionProvider = AbbreviationsCompletionProvider.class$("org.netbeans.modules.editor.java.AbbreviationsCompletionProvider")) : class$org$netbeans$modules$editor$java$AbbreviationsCompletionProvider).desiredAssertionStatus();
        }
    }
}

