/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerJavadoc;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class NbPlatformCustomizerModules
extends JPanel {
    private JLabel moduleLabel;
    private JList moduleList;
    private JScrollPane moduleSP;

    NbPlatformCustomizerModules() {
        this.initComponents();
        this.initAccessibility();
    }

    void setPlatform(final NbPlatform plaf) {
        this.moduleList.setModel(this.createWaitModel());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final ModuleEntry[] modules = plaf.getModules();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        NbPlatformCustomizerModules.this.moduleList.setModel(new PlatformComponentFactory.ModuleEntryListModel(modules));
                    }
                });
            }
        });
    }

    void reset() {
        this.moduleList.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.moduleLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleList = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.moduleLabel.setLabelFor(this.moduleList);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage((Class)NbPlatformCustomizerModules.class, (String)"LBL_PlatformModules"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.moduleLabel, gridBagConstraints);
        this.moduleList.setSelectionMode(0);
        this.moduleSP.setViewportView(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.moduleSP, gridBagConstraints);
    }

    private void initAccessibility() {
        this.moduleList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moduleList"));
    }

    private String getMessage(String key) {
        return NbBundle.getMessage((Class)NbPlatformCustomizerJavadoc.class, (String)key);
    }

    private ListModel createWaitModel() {
        DefaultListModel<String> waitModel = new DefaultListModel<String>();
        waitModel.addElement(NbBundle.getMessage((Class)NbPlatformCustomizerModules.class, (String)"LBL_PleaseWait"));
        return waitModel;
    }
}

